/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.document;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.ITypeEditorInput;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;

public abstract class LibraryElementXtextDocumentProvider
extends XtextDocumentProvider {
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        boolean result = false;
        if (editorInput instanceof ITypeEditorInput) {
            ITypeEditorInput typeEditorInput = (ITypeEditorInput)editorInput;
            LibraryElement libraryElement = typeEditorInput.getContent();
            if (libraryElement != null) {
                this.setDocumentContent(document, libraryElement);
                result = true;
            }
        } else if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(fileEditorInput.getFile());
            if (typeEntry != null) {
                this.setDocumentContent(document, typeEntry.getType());
                result = true;
            } else {
                result = super.setDocumentContent(document, editorInput, encoding);
            }
        }
        if (result) {
            this.setDocumentResource((XtextDocument)document, editorInput, encoding);
        }
        return result;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        Object object = element;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ITypeEditorInput.class, IFileEditorInput.class}, (Object)object2, n)) {
            case 0: {
                ITypeEditorInput typeEditorInput = (ITypeEditorInput)object2;
                LibraryElement libraryElement = typeEditorInput.getContent();
                if (libraryElement == null) break;
                this.doSaveDocument(monitor, (IFileEditorInput)typeEditorInput, libraryElement, (XtextDocument)document);
                this.updateFileInfo((IFileEditorInput)typeEditorInput);
                break;
            }
            case 1: {
                IFileEditorInput fileEditorInput = (IFileEditorInput)object2;
                TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(fileEditorInput.getFile());
                if (typeEntry != null) {
                    LibraryElement libraryElement = typeEntry.copyType();
                    if (libraryElement == null) break;
                    this.doSaveDocument(monitor, fileEditorInput, libraryElement, (XtextDocument)document);
                    typeEntry.save(libraryElement, monitor);
                    this.updateFileInfo(fileEditorInput);
                    break;
                }
                super.doSaveDocument(monitor, element, document, overwrite);
                break;
            }
            default: {
                super.doSaveDocument(monitor, element, document, overwrite);
            }
        }
    }

    protected void updateFileInfo(IFileEditorInput fileEditorInput) throws CoreException {
        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(fileEditorInput);
        if (info != null) {
            IAnnotationModel model = info.fModel;
            if (model instanceof ResourceMarkerAnnotationModel) {
                ResourceMarkerAnnotationModel resourceMarkerAnnotationModel = (ResourceMarkerAnnotationModel)model;
                resourceMarkerAnnotationModel.updateMarkers(info.fDocument);
            }
            info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
        }
    }

    public boolean isSynchronized(Object element) {
        if (element instanceof ITypeEditorInput) {
            return true;
        }
        return super.isSynchronized(element);
    }

    protected void handleElementContentChanged(IFileEditorInput fileEditorInput) {
        TypeEntry typeEntry;
        if (fileEditorInput instanceof ITypeEditorInput) {
            return;
        }
        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(fileEditorInput);
        if (info == null) {
            return;
        }
        XtextDocument document = (XtextDocument)info.fDocument;
        super.handleElementContentChanged(fileEditorInput);
        if (document == info.fDocument && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(fileEditorInput.getFile())) != null) {
            LibraryElement libraryElement = typeEntry.getType();
            this.removeUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
            document.internalModify(resource -> {
                if (resource instanceof LibraryElementXtextResource) {
                    LibraryElementXtextResource libResource = (LibraryElementXtextResource)resource;
                    libResource.setLibraryElement(libraryElement);
                }
                return null;
            });
            this.addUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
        }
    }

    public abstract void doSaveDocument(IProgressMonitor var1, IFileEditorInput var2, LibraryElement var3, XtextDocument var4) throws CoreException;

    public abstract void setDocumentContent(IDocument var1, LibraryElement var2) throws CoreException;
}

