/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.st;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.forte_ng.st.StructuredTextSupport;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateAndTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNop;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeOfDayLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class STMethodSupport
extends StructuredTextSupport {
    private final org.eclipse.fordiac.ide.model.libraryElement.STMethod method;
    private final Map<Object, Object> cache;
    private STMethod parseResult;

    public STMethodSupport(org.eclipse.fordiac.ide.model.libraryElement.STMethod method, Map<?, ?> options) {
        this.method = method;
        this.cache = ILanguageSupport.getCacheOption(options);
    }

    public boolean prepare() {
        if (this.parseResult == null && this.getErrors().isEmpty()) {
            EObject container = this.method.eContainer();
            if (container instanceof BaseFBType) {
                Function<BaseFBType, STAlgorithmSource> _function = it -> StructuredTextParseUtil.parse((BaseFBType)((BaseFBType)container), this.getErrors(), this.getWarnings(), this.getInfos());
                STAlgorithmSource _computeCached = (STAlgorithmSource)ILanguageSupport.computeCached(this.cache, (Object)((BaseFBType)container), _function);
                EList _elements = null;
                if (_computeCached != null) {
                    _elements = _computeCached.getElements();
                }
                Iterable _filter = null;
                if (_elements != null) {
                    _filter = Iterables.filter((Iterable)_elements, STMethod.class);
                }
                STMethod _findFirst = null;
                if (_filter != null) {
                    Functions.Function1 _function_1 = it -> {
                        String _name = it.getName();
                        String _name_1 = this.method.getName();
                        return Objects.equals(_name, _name_1);
                    };
                    _findFirst = (STMethod)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)_function_1);
                }
                this.parseResult = _findFirst;
            } else {
                this.parseResult = StructuredTextParseUtil.parse((org.eclipse.fordiac.ide.model.libraryElement.STMethod)this.method, this.getErrors(), this.getWarnings(), this.getInfos());
            }
        }
        return this.parseResult != null;
    }

    public CharSequence generate(Map<?, ?> options) throws ExportException {
        CharSequence _xblockexpression = null;
        this.prepare();
        CharSequence _xifexpression = null;
        Object _get = options.get("header");
        boolean _equals = Objects.equals(_get, Boolean.TRUE);
        if (_equals) {
            CharSequence _generateStructuredTextMethodHeader = null;
            if (this.parseResult != null) {
                _generateStructuredTextMethodHeader = this.generateStructuredTextMethodHeader(this.parseResult);
            }
            _xifexpression = _generateStructuredTextMethodHeader;
        } else {
            CharSequence _generateStructuredTextMethodImpl = null;
            if (this.parseResult != null) {
                _generateStructuredTextMethodImpl = this.generateStructuredTextMethodImpl(this.parseResult);
            }
            _xifexpression = _generateStructuredTextMethodImpl;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence generateStructuredTextMethodHeader(STMethod method) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateStructuredTextMethodDeclaration = this.generateStructuredTextMethodDeclaration(method, true);
        _builder.append((Object)_generateStructuredTextMethodDeclaration);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateStructuredTextMethodImpl(STMethod method) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateStructuredTextMethodDeclaration = this.generateStructuredTextMethodDeclaration(method, false);
        _builder.append((Object)_generateStructuredTextMethodDeclaration);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStructuredTextMethodBody = this.generateStructuredTextMethodBody(method);
        _builder.append((Object)_generateStructuredTextMethodBody, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateStructuredTextMethodDeclaration(STMethod method, boolean header) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _elvis = null;
        DataType _returnType = method.getReturnType();
        CharSequence _generateTypeName = null;
        if (_returnType != null) {
            _generateTypeName = ForteNgExportUtil.generateTypeName((INamedElement)_returnType);
        }
        _elvis = _generateTypeName != null ? _generateTypeName : "void";
        _builder.append((Object)_elvis);
        _builder.append(" ");
        if (!header) {
            CharSequence _generateTypeName_1 = ForteNgExportUtil.generateTypeName((INamedElement)this.getFBType());
            _builder.append((Object)_generateTypeName_1);
            _builder.append("::");
        }
        _builder.append("method_");
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateStructuredTextMethodParameters = this.generateStructuredTextMethodParameters(method);
        _builder.append((Object)_generateStructuredTextMethodParameters);
        _builder.append(")");
        return _builder;
    }

    private CharSequence generateStructuredTextMethodParameters(STMethod method) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<Pair<STVarDeclaration, Boolean>> _structuredTextMethodParameters = this.getStructuredTextMethodParameters(method);
        boolean _hasElements = false;
        for (Pair<STVarDeclaration, Boolean> param : _structuredTextMethodParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateFeatureTypeName = this.generateFeatureTypeName((STVarDeclaration)param.getKey(), (Boolean)param.getValue());
            _builder.append((Object)_generateFeatureTypeName);
            _builder.append(" ");
            Boolean _value = (Boolean)param.getValue();
            if (_value.booleanValue()) {
                _builder.append("&");
            }
            CharSequence _generateFeatureName = this.generateFeatureName((INamedElement)param.getKey());
            _builder.append((Object)_generateFeatureName);
        }
        return _builder;
    }

    private Iterable<Pair<STVarDeclaration, Boolean>> getStructuredTextMethodParameters(STMethod method) {
        Functions.Function1 _function = it -> it.getVarDeclarations();
        Functions.Function1 _function_1 = it -> Pair.of((Object)it, (Object)false);
        Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInputDeclarationBlock.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.getVarDeclarations();
        Functions.Function1 _function_3 = it -> Pair.of((Object)it, (Object)true);
        Iterable _map_1 = IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarInOutDeclarationBlock.class), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        Iterable _plus = Iterables.concat((Iterable)_map, (Iterable)_map_1);
        Functions.Function1 _function_4 = it -> it.getVarDeclarations();
        Functions.Function1 _function_5 = it -> Pair.of((Object)it, (Object)true);
        Iterable _map_2 = IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarOutputDeclarationBlock.class), (Functions.Function1)_function_4), (Functions.Function1)_function_5);
        return Iterables.concat((Iterable)_plus, (Iterable)_map_2);
    }

    private CharSequence generateStructuredTextMethodBody(STMethod method) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        DataType _returnType = method.getReturnType();
        boolean bl = _tripleNotEquals = _returnType != null;
        if (_tripleNotEquals) {
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((INamedElement)method.getReturnType());
            _builder.append((Object)_generateTypeName);
            _builder.append(" st_ret_val = ");
            CharSequence _generateTypeDefaultValue = this.generateTypeDefaultValue((INamedElement)method.getReturnType());
            _builder.append((Object)_generateTypeDefaultValue);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        CharSequence _generateVariables = this.generateVariables(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarOutputDeclarationBlock.class), false);
        _builder.append((Object)_generateVariables);
        _builder.newLineIfNotEmpty();
        CharSequence _generateVariables_1 = this.generateVariables(Iterables.filter((Iterable)method.getBody().getVarDeclarations(), STVarTempDeclarationBlock.class), true);
        _builder.append((Object)_generateVariables_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)method.getBody().getStatements());
        _builder.append((Object)_generateStatementList);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DataType _returnType_1 = method.getReturnType();
        boolean bl2 = _tripleNotEquals_1 = _returnType_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append("return st_ret_val;");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    protected CharSequence _generateStatement(STReturn stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return");
        DataType _returnType = this.parseResult.getReturnType();
        boolean bl = _tripleNotEquals = _returnType != null;
        if (_tripleNotEquals) {
            _builder.append(" st_ret_val");
        }
        _builder.append(";");
        return _builder;
    }

    @Override
    protected CharSequence _generateExpression(STFeatureExpression expr) {
        CharSequence _xifexpression = null;
        _xifexpression = expr.getFeature() == this.parseResult && !expr.isCall() ? "st_ret_val" : super._generateExpression(expr);
        return _xifexpression;
    }

    private BaseFBType getFBType() {
        EObject _rootContainer;
        BaseFBType _switchResult = null;
        EObject root = _rootContainer = EcoreUtil.getRootContainer((EObject)this.method);
        boolean _matched = false;
        if (root instanceof BaseFBType) {
            _matched = true;
            _switchResult = (BaseFBType)root;
        }
        return _switchResult;
    }

    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set _xblockexpression = null;
        this.prepare();
        Set _xifexpression = null;
        if (this.parseResult != null) {
            Set _xifexpression_1 = null;
            Object _get = options.get("header");
            boolean _equals = Objects.equals(_get, Boolean.TRUE);
            if (_equals) {
                DataType _returnType = this.parseResult.getReturnType();
                Iterable _filterNull = IterableExtensions.filterNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DataType[]{_returnType})));
                Functions.Function1 _function = it -> it instanceof STVarInputDeclarationBlock || it instanceof STVarOutputDeclarationBlock;
                Functions.Function1 _function_1 = it -> it.getVarDeclarations();
                Functions.Function1 _function_2 = it -> it.getType();
                Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)this.parseResult.getBody().getVarDeclarations(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                _xifexpression_1 = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_filterNull, (Iterable)_map));
            } else {
                _xifexpression_1 = this.getContainedDependencies((EObject)this.parseResult);
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = CollectionLiterals.emptySet();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateStatement(STStatement stmt) {
        if (stmt instanceof STCaseStatement) {
            return this._generateStatement((STCaseStatement)stmt);
        }
        if (stmt instanceof STContinue) {
            return this._generateStatement((STContinue)stmt);
        }
        if (stmt instanceof STExit) {
            return this._generateStatement((STExit)stmt);
        }
        if (stmt instanceof STExpression) {
            return this._generateStatement((STExpression)stmt);
        }
        if (stmt instanceof STForStatement) {
            return this._generateStatement((STForStatement)stmt);
        }
        if (stmt instanceof STIfStatement) {
            return this._generateStatement((STIfStatement)stmt);
        }
        if (stmt instanceof STNop) {
            return this._generateStatement((STNop)stmt);
        }
        if (stmt instanceof STRepeatStatement) {
            return this._generateStatement((STRepeatStatement)stmt);
        }
        if (stmt instanceof STReturn) {
            return this._generateStatement((STReturn)stmt);
        }
        if (stmt instanceof STWhileStatement) {
            return this._generateStatement((STWhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateExpression(STExpression expr) {
        if (expr instanceof STArrayAccessExpression) {
            return this._generateExpression((STArrayAccessExpression)expr);
        }
        if (expr instanceof STAssignment) {
            return this._generateExpression((STAssignment)expr);
        }
        if (expr instanceof STBinaryExpression) {
            return this._generateExpression((STBinaryExpression)expr);
        }
        if (expr instanceof STBuiltinFeatureExpression) {
            return this._generateExpression((STBuiltinFeatureExpression)expr);
        }
        if (expr instanceof STDateAndTimeLiteral) {
            return this._generateExpression((STDateAndTimeLiteral)expr);
        }
        if (expr instanceof STDateLiteral) {
            return this._generateExpression((STDateLiteral)expr);
        }
        if (expr instanceof STFeatureExpression) {
            return this._generateExpression((STFeatureExpression)expr);
        }
        if (expr instanceof STMemberAccessExpression) {
            return this._generateExpression((STMemberAccessExpression)expr);
        }
        if (expr instanceof STMultibitPartialExpression) {
            return this._generateExpression((STMultibitPartialExpression)expr);
        }
        if (expr instanceof STNumericLiteral) {
            return this._generateExpression((STNumericLiteral)expr);
        }
        if (expr instanceof STStringLiteral) {
            return this._generateExpression((STStringLiteral)expr);
        }
        if (expr instanceof STTimeLiteral) {
            return this._generateExpression((STTimeLiteral)expr);
        }
        if (expr instanceof STTimeOfDayLiteral) {
            return this._generateExpression((STTimeOfDayLiteral)expr);
        }
        if (expr instanceof STUnaryExpression) {
            return this._generateExpression((STUnaryExpression)expr);
        }
        if (expr != null) {
            return this._generateExpression(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

