/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.draw2d.FordiacFigureUtilities;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.figures.InteractionStyleFigure;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.DeviceInterfaceEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceContainer;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceContainerEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeleteDeviceEditPolicy;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeviceViewLayoutEditPolicy;
import org.eclipse.fordiac.ide.systemconfiguration.policies.SegmentNodeEditPolicy;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class DeviceEditPart
extends AbstractPositionableElementEditPart
implements NodeEditPart {
    private ZoomManager zoomManager;
    private ResourceContainer resContainer;

    DeviceEditPart(ZoomManager zoomManager) {
        this.setConnectable(true);
        this.zoomManager = zoomManager;
    }

    public Device getModel() {
        return (Device)super.getModel();
    }

    protected EContentAdapter createContentAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getColorizableElement_Color().equals(feature)) {
                    DeviceEditPart.this.backgroundColorChanged((IFigure)DeviceEditPart.this.getFigure());
                } else {
                    super.notifyChanged(notification);
                    DeviceEditPart.this.refreshChildren();
                    DeviceEditPart.this.refreshTargetConnections();
                }
            }
        };
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    public DeviceFigure getFigure() {
        return (DeviceFigure)super.getFigure();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof DeviceInterfaceEditPart) {
            this.getFigure().getDataInputs().add(child);
        } else if (childEditPart instanceof ResourceContainerEditPart) {
            this.getFigure().getContentPane().add(child);
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof DeviceInterfaceEditPart) {
            this.getFigure().getDataInputs().remove(child);
        } else if (childEditPart instanceof ResourceContainerEditPart) {
            this.getFigure().getContentPane().remove(child);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.resContainer = new ResourceContainer((Device)model);
    }

    protected List getModelChildren() {
        ArrayList<ResourceContainer> elements = new ArrayList<ResourceContainer>();
        elements.addAll((Collection<ResourceContainer>)this.getModel().getVarDeclarations());
        elements.add(this.resContainer);
        return elements;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DeviceViewLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteDeviceEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SegmentNodeEditPolicy());
    }

    public Label getNameLabel() {
        return this.getFigure().getName();
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        return null;
    }

    protected IFigure createFigureForModel() {
        return new DeviceFigure();
    }

    protected void backgroundColorChanged(IFigure figure) {
        Color fordiacColor = this.getModel().getColor();
        if (fordiacColor == null) {
            fordiacColor = ColorHelper.createRandomColor();
            this.getModel().setColor(fordiacColor);
        }
        this.setColor(figure, fordiacColor);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    protected List<?> getModelTargetConnections() {
        ArrayList connections = new ArrayList();
        connections.addAll(this.getModel().getInConnections());
        connections.addAll(super.getModelTargetConnections());
        return connections;
    }

    private final class DeviceConnectionAnchor
    extends ChopboxAnchor {
        DeviceConnectionAnchor(IFigure owner) {
            super(owner);
        }

        protected Rectangle getBox() {
            Rectangle main = DeviceEditPart.this.getFigure().getConnectionReferenceFigure().getBounds().getCopy();
            Rectangle top = DeviceEditPart.this.getFigure().getName().getBounds();
            main.setHeight(main.height + top.height());
            main.y = top.y();
            return main;
        }
    }

    private class DeviceFigure
    extends Shape
    implements InteractionStyleFigure {
        private final Label instanceNameLabel = new Label();
        private Figure dataInputs = new Figure();
        private Figure contentPane;
        private RoundedRectangle bottom = new RoundedRectangle(){

            protected void fillShape(Graphics graphics) {
                Display display = Display.getCurrent();
                Rectangle boundingRect = this.getBounds().getCopy();
                boundingRect.scale(DeviceEditPart.this.zoomManager.getZoom());
                Point topLeft = boundingRect.getTopLeft();
                Point bottomRight = boundingRect.getBottomRight();
                org.eclipse.swt.graphics.Color first = ColorHelper.lighter((org.eclipse.swt.graphics.Color)this.getBackgroundColor());
                Pattern pattern = new Pattern((org.eclipse.swt.graphics.Device)display, (float)topLeft.x, (float)topLeft.y, (float)bottomRight.x, (float)bottomRight.y, first, this.getBackgroundColor());
                graphics.setBackgroundPattern(pattern);
                graphics.fillRoundRectangle(this.getBounds(), this.getCornerDimensions().width, this.getCornerDimensions().height);
                graphics.setBackgroundPattern(null);
                pattern.dispose();
                first.dispose();
            }
        };

        public int getIntersectionStyle(Point location) {
            if (this.instanceNameLabel.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                return 1;
            }
            return 0;
        }

        public DeviceFigure() {
            this.setBackgroundColor(ColorConstants.white);
            this.setFillXOR(true);
            this.setLayoutManager((LayoutManager)new ToolbarLayout());
            this.createInstanceNameLabel((Figure)this);
            IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
            int cornerDim = pf.getInt("CornerDim");
            this.bottom.setCornerDimensions(new Dimension(cornerDim, cornerDim));
            ToolbarLayout bottomLayout = new ToolbarLayout();
            bottomLayout.setStretchMinorAxis(true);
            this.bottom.setLayoutManager((LayoutManager)bottomLayout);
            this.bottom.setOutline(false);
            this.add((IFigure)this.bottom);
            this.createDeviceInfoSection((Figure)this.bottom);
            ToolbarLayout bottomInputsLayout = new ToolbarLayout(false);
            bottomInputsLayout.setStretchMinorAxis(true);
            this.dataInputs.setLayoutManager((LayoutManager)bottomInputsLayout);
            this.dataInputs.setOpaque(false);
            this.bottom.add((IFigure)this.dataInputs);
            this.createContentPane(this.bottom);
        }

        private void createInstanceNameLabel(Figure parent) {
            this.instanceNameLabel.setText(DeviceEditPart.this.getINamedElement().getName());
            this.instanceNameLabel.setTextAlignment(2);
            this.instanceNameLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            parent.add((IFigure)this.instanceNameLabel);
        }

        private void createDeviceInfoSection(Figure parent) {
            ToolbarLayout deviceInfoLayout = new ToolbarLayout();
            deviceInfoLayout.setStretchMinorAxis(true);
            Figure deviceInfo = new Figure();
            deviceInfo.setLayoutManager((LayoutManager)deviceInfoLayout);
            DeviceType type = DeviceEditPart.this.getModel().getType();
            String typeName = type != null ? type.getName() : "Type not set!";
            Label l = new Label(typeName);
            deviceInfo.add((IFigure)l);
            l.setTextAlignment(2);
            l.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
            l.setBorder((Border)new MarginBorder(0, 0, 10, 0));
            parent.add((IFigure)deviceInfo);
            deviceInfo.setBorder((Border)new LineBorder(){

                public void paint(IFigure figure, Graphics graphics, Insets insets) {
                    tempRect.setBounds(2.getPaintRectangle((IFigure)figure, (Insets)insets));
                    if (1 == (this.getWidth() & 1)) {
                        --2.tempRect.height;
                    }
                    tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
                    graphics.setLineWidth(this.getWidth());
                    graphics.setBackgroundColor(DeviceFigure.this.bottom.getBackgroundColor());
                    FordiacFigureUtilities.paintEtchedBorder((Graphics)graphics, (Rectangle)new Rectangle(2.tempRect.x - 3, 2.tempRect.y + 2.tempRect.height - 3, 2.tempRect.width + 5, 3));
                }
            });
        }

        private void createContentPane(RoundedRectangle container) {
            this.contentPane = new Figure();
            this.contentPane.setLayoutManager((LayoutManager)new ToolbarLayout());
            container.add((IFigure)this.contentPane);
            this.contentPane.setBorder((Border)new LineBorder(){

                public void paint(IFigure figure, Graphics graphics, Insets insets) {
                    tempRect.setBounds(3.getPaintRectangle((IFigure)figure, (Insets)insets));
                    if (1 == (this.getWidth() & 1)) {
                        --3.tempRect.height;
                    }
                    tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
                    graphics.setLineWidth(this.getWidth());
                    graphics.setBackgroundColor(DeviceFigure.this.bottom.getBackgroundColor());
                    FordiacFigureUtilities.paintEtchedBorder((Graphics)graphics, (Rectangle)new Rectangle(3.tempRect.x - 3, 3.tempRect.y, 3.tempRect.width + 5, 3));
                }
            });
        }

        public Label getName() {
            return this.instanceNameLabel;
        }

        public Figure getConnectionReferenceFigure() {
            return this.bottom;
        }

        protected void fillShape(Graphics graphics) {
        }

        protected void outlineShape(Graphics graphics) {
        }

        public Figure getDataInputs() {
            return this.dataInputs;
        }

        public Figure getContentPane() {
            return this.contentPane;
        }
    }
}

