/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.annotations;

import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;

public final class SubAppAnnotations {
    public static FBNetwork loadSubAppNetwork(TypedSubApp subApp) {
        FBNetwork subAppNetwork = subApp.getSubAppNetwork();
        if (subAppNetwork == null) {
            subAppNetwork = FBNetworkHelper.copyFBNetWork(subApp.getType().getFBNetwork(), subApp.getInterface());
            subApp.setSubAppNetwork(subAppNetwork);
            subAppNetwork.getEventConnections().forEach(Connection::checkIfConnectionBroken);
            subAppNetwork.getDataConnections().forEach(Connection::checkIfConnectionBroken);
            subAppNetwork.getAdapterConnections().forEach(Connection::checkIfConnectionBroken);
        }
        return subAppNetwork;
    }

    public static Stream<INamedElement> findBySimpleName(TypedSubApp root, String name) {
        SubAppAnnotations.loadSubAppNetwork(root);
        return NamedElementAnnotations.findBySimpleName(root, name);
    }

    private SubAppAnnotations() {
        throw new UnsupportedOperationException("The utility class SubAppAnnotations should not be instatiated");
    }
}

