/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.command.CommandStackEvent;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.impl.AbstractTransactionalCommandStack;

public class TransactionalDualCompareCommandStack
implements ICompareCommandStack,
IDisposable {
    private static final int IS_SAVE_NEEDED_WILL_BE_TRUE = -2;
    private final AbstractTransactionalCommandStack leftCommandStack;
    private final AbstractTransactionalCommandStack rightCommandStack;
    private final List<AbstractTransactionalCommandStack> commandStackStack;
    private int top;
    private AbstractTransactionalCommandStack mostRecentCommandStack;
    private int saveIndex = -1;
    private final List<CommandStackListener> listeners;
    private final SideCommandStackListener sideCommandStackListener;
    private boolean deliver = true;
    private boolean deferredExecuteNotification;

    public TransactionalDualCompareCommandStack(AbstractTransactionalCommandStack leftCommandStack, AbstractTransactionalCommandStack rightCommandStack) {
        this.leftCommandStack = (AbstractTransactionalCommandStack)Preconditions.checkNotNull((Object)leftCommandStack);
        this.rightCommandStack = (AbstractTransactionalCommandStack)Preconditions.checkNotNull((Object)rightCommandStack);
        this.sideCommandStackListener = new SideCommandStackListener();
        this.leftCommandStack.addCommandStackListener((CommandStackListener)this.sideCommandStackListener);
        this.rightCommandStack.addCommandStackListener((CommandStackListener)this.sideCommandStackListener);
        this.listeners = Lists.newArrayList();
        this.commandStackStack = Lists.newArrayList();
        this.top = -1;
    }

    public void dispose() {
        this.leftCommandStack.removeCommandStackListener((CommandStackListener)this.sideCommandStackListener);
        this.rightCommandStack.removeCommandStackListener((CommandStackListener)this.sideCommandStackListener);
    }

    @Deprecated
    protected void notifyListeners(Object source) {
        if (this.deliver) {
            for (CommandStackListener commandStackListener : this.listeners) {
                commandStackListener.commandStackChanged(new EventObject(source));
            }
        }
    }

    protected void notifyListeners(CommandStack commandStack, CommandStackEvent.Operation operation) {
        if (this.deliver) {
            this.deferredExecuteNotification = false;
            for (CommandStackListener commandStackListener : this.listeners) {
                commandStackListener.commandStackChanged((EventObject)new CommandStackEvent(commandStack, operation));
            }
        } else if (operation == CommandStackEvent.Operation.EXECUTE) {
            this.deferredExecuteNotification = true;
        }
    }

    public void execute(Command command) {
        if (command instanceof ICompareCopyCommand) {
            if (command.canExecute()) {
                this.sideCommandStackListener.setIgnoreCommandStackChanged(true);
                try {
                    ICompareCopyCommand compareCommand = (ICompareCopyCommand)command;
                    AbstractTransactionalCommandStack commandStack = compareCommand.isLeftToRight() ? this.rightCommandStack : this.leftCommandStack;
                    ExceptionHandler oldExceptionHandler = commandStack.getExceptionHandler();
                    ExecuteCompletionHandler completionHandler = new ExecuteCompletionHandler();
                    commandStack.setExceptionHandler((ExceptionHandler)completionHandler);
                    commandStack.execute((Command)compareCommand);
                    if (!completionHandler.hadException()) {
                        ((AbstractCompletionHandler)completionHandler).handleSuccessfulCompletion(commandStack);
                    }
                    commandStack.setExceptionHandler(oldExceptionHandler);
                    this.notifyListeners(this, CommandStackEvent.Operation.EXECUTE);
                }
                finally {
                    this.sideCommandStackListener.setIgnoreCommandStackChanged(false);
                }
            } else if (!this.deliver) {
                this.deferredExecuteNotification = true;
            }
        }
    }

    public boolean canUndo() {
        return this.top != -1 && this.commandStackStack.get(this.top).canUndo();
    }

    public void undo() {
        if (this.canUndo()) {
            this.sideCommandStackListener.setIgnoreCommandStackChanged(true);
            try {
                AbstractTransactionalCommandStack commandStack = this.commandStackStack.get(this.top--);
                ExceptionHandler oldExceptionHandler = commandStack.getExceptionHandler();
                UndoCompletionHandler completionHandler = new UndoCompletionHandler();
                commandStack.setExceptionHandler((ExceptionHandler)completionHandler);
                commandStack.undo();
                if (!completionHandler.hadException()) {
                    ((AbstractCompletionHandler)completionHandler).handleSuccessfulCompletion(commandStack);
                }
                commandStack.setExceptionHandler(oldExceptionHandler);
                this.notifyListeners(this, CommandStackEvent.Operation.UNDO);
            }
            finally {
                this.sideCommandStackListener.setIgnoreCommandStackChanged(false);
            }
        }
    }

    public boolean canRedo() {
        return this.top < this.commandStackStack.size() - 1;
    }

    public Command getUndoCommand() {
        Command undoCommand = this.top == -1 || this.top == this.commandStackStack.size() ? null : this.commandStackStack.get(this.top).getUndoCommand();
        return undoCommand;
    }

    public Command getRedoCommand() {
        Command redoCommand = this.top + 1 >= this.commandStackStack.size() ? null : this.commandStackStack.get(this.top + 1).getRedoCommand();
        return redoCommand;
    }

    public Command getMostRecentCommand() {
        if (this.mostRecentCommandStack != null) {
            return this.mostRecentCommandStack.getMostRecentCommand();
        }
        return null;
    }

    public void redo() {
        if (this.canRedo()) {
            this.sideCommandStackListener.setIgnoreCommandStackChanged(true);
            try {
                AbstractTransactionalCommandStack commandStack = this.commandStackStack.get(++this.top);
                ExceptionHandler oldExceptionHandler = commandStack.getExceptionHandler();
                RedoCompletionHandler completionHandler = new RedoCompletionHandler();
                commandStack.setExceptionHandler((ExceptionHandler)completionHandler);
                commandStack.redo();
                if (!completionHandler.hadException()) {
                    ((AbstractCompletionHandler)completionHandler).handleSuccessfulCompletion(commandStack);
                }
                commandStack.setExceptionHandler(oldExceptionHandler);
                this.notifyListeners(this, CommandStackEvent.Operation.REDO);
            }
            finally {
                this.sideCommandStackListener.setIgnoreCommandStackChanged(false);
            }
        }
    }

    public void flush() {
        this.commandStackStack.clear();
        this.top = -1;
        this.saveIndex = -1;
        this.mostRecentCommandStack = null;
        this.leftCommandStack.flush();
        this.rightCommandStack.flush();
        this.notifyListeners(this, CommandStackEvent.Operation.FLUSH);
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isLeftSaveNeeded() {
        return this.leftCommandStack.isSaveNeeded();
    }

    @Override
    public boolean isRightSaveNeeded() {
        return this.rightCommandStack.isSaveNeeded();
    }

    @Override
    public void leftSaveIsDone() {
        this.leftCommandStack.saveIsDone();
    }

    @Override
    public void rightSaveIsDone() {
        this.rightCommandStack.saveIsDone();
    }

    public boolean isDeliver() {
        return this.deliver;
    }

    public void setDeliver(boolean deliver) {
        this.deliver = deliver;
        if (deliver && this.deferredExecuteNotification) {
            this.notifyListeners(this, CommandStackEvent.Operation.EXECUTE);
        }
    }

    private static abstract class AbstractCompletionHandler
    implements ExceptionHandler {
        private boolean hadException;

        private AbstractCompletionHandler() {
        }

        public void handleException(Exception e) {
            this.hadException = true;
        }

        abstract void handleSuccessfulCompletion(AbstractTransactionalCommandStack var1);

        boolean hadException() {
            return this.hadException;
        }
    }

    private final class ExecuteCompletionHandler
    extends AbstractCompletionHandler {
        private ExecuteCompletionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            if (!this.hadException()) {
                super.handleException(e);
                TransactionalDualCompareCommandStack.this.mostRecentCommandStack = null;
            }
        }

        @Override
        void handleSuccessfulCompletion(AbstractTransactionalCommandStack commandStack) {
            TransactionalDualCompareCommandStack.this.commandStackStack.subList(TransactionalDualCompareCommandStack.this.top + 1, TransactionalDualCompareCommandStack.this.commandStackStack.size()).clear();
            TransactionalDualCompareCommandStack.this.mostRecentCommandStack = commandStack;
            TransactionalDualCompareCommandStack.this.commandStackStack.add(commandStack);
            TransactionalDualCompareCommandStack transactionalDualCompareCommandStack = TransactionalDualCompareCommandStack.this;
            transactionalDualCompareCommandStack.top = transactionalDualCompareCommandStack.top + 1;
            if (TransactionalDualCompareCommandStack.this.saveIndex >= TransactionalDualCompareCommandStack.this.top) {
                TransactionalDualCompareCommandStack.this.saveIndex = -2;
            }
        }
    }

    private final class RedoCompletionHandler
    extends AbstractCompletionHandler {
        private RedoCompletionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            if (!this.hadException()) {
                super.handleException(e);
                TransactionalDualCompareCommandStack.this.mostRecentCommandStack = null;
                List list = TransactionalDualCompareCommandStack.this.commandStackStack;
                TransactionalDualCompareCommandStack transactionalDualCompareCommandStack = TransactionalDualCompareCommandStack.this;
                int n = transactionalDualCompareCommandStack.top;
                transactionalDualCompareCommandStack.top = n - 1;
                list.subList(n, TransactionalDualCompareCommandStack.this.commandStackStack.size()).clear();
            }
        }

        @Override
        public void handleSuccessfulCompletion(AbstractTransactionalCommandStack commandStack) {
            TransactionalDualCompareCommandStack.this.mostRecentCommandStack = commandStack;
        }
    }

    private final class SideCommandStackListener
    implements CommandStackListener {
        private boolean ignoreCommandStackChanged;

        private SideCommandStackListener() {
        }

        public void commandStackChanged(EventObject event) {
            AbstractTransactionalCommandStack commandStack;
            if (!this.ignoreCommandStackChanged && (commandStack = (AbstractTransactionalCommandStack)event.getSource()).getMostRecentCommand() != null) {
                new ExecuteCompletionHandler().handleSuccessfulCompletion(commandStack);
                TransactionalDualCompareCommandStack.this.notifyListeners((CommandStack)commandStack, CommandStackEvent.Operation.EXECUTE);
            }
        }

        public void setIgnoreCommandStackChanged(boolean ignoreCommandStackChanged) {
            this.ignoreCommandStackChanged = ignoreCommandStackChanged;
        }
    }

    private final class UndoCompletionHandler
    extends AbstractCompletionHandler {
        private UndoCompletionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            if (!this.hadException()) {
                super.handleException(e);
                TransactionalDualCompareCommandStack.this.mostRecentCommandStack = null;
                TransactionalDualCompareCommandStack.this.flush();
            }
        }

        @Override
        public void handleSuccessfulCompletion(AbstractTransactionalCommandStack commandStack) {
            TransactionalDualCompareCommandStack.this.mostRecentCommandStack = commandStack;
        }
    }
}

