/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ArraySize;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public final class ConfigurableFBManagement {
    public static final String MEMBER_VAR_SEPARATOR = "%";

    static void updateFbConfiguration(ConfigurableFB fb) {
        if (fb instanceof ConfigurableMoveFB) {
            ConfigurableFBManagement.updateMoveFbConfiguration(fb);
        } else if (fb instanceof StructManipulator) {
            StructManipulator sm = (StructManipulator)fb;
            ConfigurableFBManagement.updateStructManipulatorConfiguration(sm);
        }
    }

    private static void updateMoveFbConfiguration(ConfigurableFB fb) {
        if (fb.getDataType() != null && fb.getInterface() != null) {
            for (VarDeclaration input : fb.getInterface().getInputVars()) {
                input.setType(fb.getDataType());
            }
            for (VarDeclaration output : fb.getInterface().getOutputVars()) {
                output.setType(fb.getDataType());
            }
        }
    }

    static void loadFbConfiguration(ConfigurableFB fb, String attributeName, String typeName) {
        if (fb instanceof ConfigurableMoveFB) {
            ConfigurableMoveFB moveFB = (ConfigurableMoveFB)fb;
            ConfigurableFBManagement.loadFbMoveConfiguration(moveFB, attributeName, typeName);
        } else if (fb instanceof Demultiplexer) {
            Demultiplexer demux = (Demultiplexer)fb;
            ConfigurableFBManagement.loadVisibleChildrenDemuxConfiguration(demux, attributeName, typeName);
        }
        if (fb instanceof StructManipulator) {
            StructManipulator structFB = (StructManipulator)fb;
            ConfigurableFBManagement.loadStructManipulatorConfiguration(structFB, attributeName, typeName);
        }
    }

    private static void loadFbMoveConfiguration(ConfigurableMoveFB fb, String attributeName, String typeName) {
        if ("DataType".equals(attributeName) && typeName != null) {
            ConfigurableFBManagement.setDataType(fb, typeName);
        }
    }

    private static void loadStructManipulatorConfiguration(StructManipulator fb, String attributeName, String typeName) {
        if ("StructuredType".equals(attributeName) && typeName != null) {
            ConfigurableFBManagement.setDataType(fb, typeName);
        }
    }

    private static void setDataType(ConfigurableFB fb, String typeName) {
        DataType dataType = fb.getTypeLibrary().getDataTypeLibrary().getType(typeName);
        fb.setDataType(dataType);
        ConfigurableFBManagement.updateFbConfiguration(fb);
    }

    private static void loadVisibleChildrenDemuxConfiguration(Demultiplexer fb, String attributeName, String visibleChildren) {
        if ("VisibleChildren".equals(attributeName) && visibleChildren != null) {
            fb.setIsConfigured(true);
            ConfigurableFBManagement.updateConfiguredDemuxConfiguration(fb, visibleChildren);
        }
    }

    static EList<Attribute> getConfigurableFbAttributes(ConfigurableFB fb) {
        if (fb.getDataType() == null) {
            return ECollections.emptyEList();
        }
        if (fb instanceof ConfigurableMoveFB) {
            ConfigurableMoveFB movefb = (ConfigurableMoveFB)fb;
            return ConfigurableFBManagement.getFbMoveAttributes(movefb);
        }
        if (fb instanceof Multiplexer) {
            Multiplexer mux = (Multiplexer)fb;
            return ConfigurableFBManagement.getStructManipulatorAttributes(mux);
        }
        if (fb instanceof Demultiplexer) {
            Demultiplexer demux = (Demultiplexer)fb;
            return ConfigurableFBManagement.getConfigurableDemuxAttributes(demux);
        }
        return ECollections.emptyEList();
    }

    private static EList<Attribute> getFbMoveAttributes(ConfigurableMoveFB fb) {
        Attribute attr = LibraryElementFactory.eINSTANCE.createAttribute();
        attr.setName("DataType");
        attr.setValue(PackageNameHelper.getFullTypeName(fb.getDataType()));
        return ECollections.asEList((Object[])new Attribute[]{attr});
    }

    private static EList<Attribute> getStructManipulatorAttributes(StructManipulator fb) {
        Attribute attr = LibraryElementFactory.eINSTANCE.createAttribute();
        attr.setName("StructuredType");
        attr.setType(IecTypes.ElementaryTypes.STRING);
        attr.setValue(PackageNameHelper.getFullTypeName(fb.getDataType()));
        return ECollections.asEList((Object[])new Attribute[]{attr});
    }

    private static EList<Attribute> getConfigurableDemuxAttributes(Demultiplexer fb) {
        EList<Attribute> structTypeAttr = ConfigurableFBManagement.getStructManipulatorAttributes(fb);
        if (fb.isIsConfigured()) {
            Attribute attr = LibraryElementFactory.eINSTANCE.createAttribute();
            attr.setName("VisibleChildren");
            attr.setType(IecTypes.ElementaryTypes.STRING);
            attr.setValue(ConfigurableFBManagement.buildVisibleChildrenString(fb.getMemberVars()));
            if (!ConfigurableFBManagement.isInDefaultConfiguration(fb, attr.getValue(), fb.getDataType())) {
                return ECollections.asEList((Object[])new Attribute[]{(Attribute)structTypeAttr.get(0), attr});
            }
            fb.setIsConfigured(false);
        }
        return structTypeAttr;
    }

    private static boolean isInDefaultConfiguration(Demultiplexer demux, String visibleChildrenString, DataType dataType) {
        if (!(dataType instanceof StructuredType)) {
            return true;
        }
        EList<VarDeclaration> possibleChildren = ((StructuredType)dataType).getMemberVariables();
        if (demux.getMemberVars().size() != possibleChildren.size()) {
            return false;
        }
        String unconfiguredVarList = ConfigurableFBManagement.buildVisibleChildrenString(possibleChildren);
        return unconfiguredVarList.equals(visibleChildrenString);
    }

    public static String buildVisibleChildrenString(EList<VarDeclaration> memberVars) {
        if (memberVars.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        memberVars.forEach(varDecl -> {
            StringBuilder stringBuilder2 = sb.append(varDecl.getName() + ",");
        });
        return sb.substring(0, sb.length() - 1);
    }

    static String getMemberVarName(MemberVarDeclaration varDecl, String separator) {
        StringBuilder sb = new StringBuilder();
        varDecl.getParentNames().forEach(name -> {
            StringBuilder stringBuilder2 = sb.append((String)name).append(separator);
        });
        sb.append(varDecl.getVarName());
        return sb.toString();
    }

    static void setMemberVarName(MemberVarDeclaration varDecl, String name) {
        String[] subNames = ConfigurableFBManagement.splitMemberVarName(name);
        varDecl.setName(subNames[subNames.length - 1]);
    }

    static void updateStructManipulatorConfiguration(StructManipulator muxer) {
        Demultiplexer demux;
        if (!(muxer.getDataType() instanceof StructuredType)) {
            muxer.getMemberVars().clear();
            ConfigurableFBManagement.getEventWithPins(muxer).getWith().clear();
        } else if (muxer instanceof Demultiplexer && (demux = (Demultiplexer)muxer).isIsConfigured()) {
            ConfigurableFBManagement.updateConfiguredDemuxConfiguration(demux, ConfigurableFBManagement.buildVisibleChildrenString(muxer.getMemberVars()));
        } else {
            boolean createAsInputs = muxer instanceof Multiplexer;
            ConfigurableFBManagement.createMemberVars(muxer, createAsInputs);
            VarDeclaration structPin = ConfigurableFBManagement.getStructuredTypePin(muxer);
            structPin.setType(muxer.getDataType());
        }
    }

    private static Event getEventWithPins(StructManipulator muxer) {
        if (muxer instanceof Multiplexer) {
            return (Event)muxer.getInterface().getEventInputs().get(0);
        }
        return (Event)muxer.getInterface().getEventOutputs().get(0);
    }

    private static VarDeclaration getStructuredTypePin(StructManipulator muxer) {
        if (muxer instanceof Multiplexer) {
            return (VarDeclaration)muxer.getInterface().getOutputVars().get(0);
        }
        return (VarDeclaration)muxer.getInterface().getInputVars().get(0);
    }

    private static void createMemberVars(StructManipulator muxer, boolean isInput) {
        ((StructuredType)muxer.getDataType()).getMemberVariables().forEach(memberVar -> {
            MemberVarDeclaration varDecl = ConfigurableFBManagement.copyVarAsMember(memberVar, isInput);
            muxer.getMemberVars().add((Object)varDecl);
        });
        ConfigurableFBManagement.getEventWithPins(muxer).getWith().clear();
        muxer.getMemberVars().forEach(varDecl -> {
            With with = LibraryElementFactory.eINSTANCE.createWith();
            with.setVariables((VarDeclaration)varDecl);
            ConfigurableFBManagement.getEventWithPins(muxer).getWith().add((Object)with);
        });
    }

    private static MemberVarDeclaration copyVarAsMember(VarDeclaration memberVar, boolean isInput) {
        MemberVarDeclaration copy = LibraryElementFactory.eINSTANCE.createMemberVarDeclaration();
        copy.setName(memberVar.getName());
        copy.setType(memberVar.getType());
        copy.setValue(LibraryElementFactory.eINSTANCE.createValue());
        copy.setIsInput(isInput);
        copy.setArraySize((ArraySize)EcoreUtil.copy((EObject)memberVar.getArraySize()));
        return copy;
    }

    private static void updateConfiguredDemuxConfiguration(Demultiplexer demux, String visibleChildren) {
        if (visibleChildren == null || !(demux.getDataType() instanceof StructuredType) || !demux.isIsConfigured()) {
            ConfigurableFBManagement.updateStructManipulatorConfiguration(demux);
        } else {
            demux.getMemberVars().clear();
            ConfigurableFBManagement.getEventWithPins(demux).getWith().clear();
            if (!visibleChildren.isBlank()) {
                String[] memberVarNames;
                StructuredType structType = (StructuredType)demux.getDataType();
                String[] stringArray = memberVarNames = visibleChildren.trim().split(",");
                int n = memberVarNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String memberVarName = stringArray[n2];
                    String[] subnames = ConfigurableFBManagement.splitMemberVarName(memberVarName);
                    VarDeclaration varInStruct = ConfigurableFBManagement.findVarDeclarationInStruct(structType, subnames);
                    if (varInStruct != null) {
                        MemberVarDeclaration pin = ConfigurableFBManagement.copyVarAsMember(varInStruct, false);
                        pin.getParentNames().addAll(Arrays.asList(subnames).subList(0, subnames.length - 1));
                        demux.getMemberVars().add((Object)pin);
                    }
                    ++n2;
                }
                demux.getMemberVars().forEach(varDecl -> {
                    With with = LibraryElementFactory.eINSTANCE.createWith();
                    with.setVariables((VarDeclaration)varDecl);
                    ConfigurableFBManagement.getEventWithPins(demux).getWith().add((Object)with);
                });
            }
            ConfigurableFBManagement.getStructuredTypePin(demux).setType(demux.getDataType());
        }
    }

    static String[] splitMemberVarName(String memberVarName) {
        String trimmedMemberVarName = memberVarName.trim();
        String[] subnames = trimmedMemberVarName.split(MEMBER_VAR_SEPARATOR);
        if (subnames.length == 1) {
            subnames = trimmedMemberVarName.split("\\.");
        }
        return subnames;
    }

    private static VarDeclaration findVarDeclarationInStruct(StructuredType struct, String[] subnames) {
        VarDeclaration found = null;
        Object members = struct.getMemberVariables();
        String[] stringArray = subnames;
        int n = subnames.length;
        int n2 = 0;
        while (n2 < n) {
            String subname = stringArray[n2];
            List<VarDeclaration> findings = members.stream().filter(memVar -> memVar.getName().equals(subname)).toList();
            if (findings.isEmpty()) {
                found = null;
                break;
            }
            found = findings.get(0);
            DataType dataType = found.getType();
            if (dataType instanceof StructuredType) {
                StructuredType structType = (StructuredType)dataType;
                members = structType.getMemberVariables();
            } else {
                members = Collections.emptyList();
            }
            ++n2;
        }
        return found;
    }

    private ConfigurableFBManagement() {
        throw new UnsupportedOperationException();
    }
}

