/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextfunctioneditor.formatting2;

import com.google.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreAutowrapFormatter;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreFormatter;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.services.STFunctionGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionPackage;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;

public class STFunctionFormatter
extends STCoreFormatter {
    @Inject
    private STFunctionGrammarAccess grammarAccess;

    protected void _format(STFunctionSource source, IFormattableDocument document) {
        this.formatSource((STSource)source, document);
        if (source.getName() != null) {
            this.formatPackage((STSource)source, document);
        }
        this.formatImports(source.getImports(), document);
        source.getFunctions().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
    }

    protected void _format(STFunction function, IFormattableDocument document) {
        ISemanticRegion functionKeyword = this.textRegionExtensions.regionFor((EObject)function).keyword("FUNCTION");
        ISemanticRegion endKeyword = this.textRegionExtensions.regionFor((EObject)function).keyword("END_FUNCTION");
        document.prepend(functionKeyword, IHiddenRegionFormatter::noIndentation);
        document.append(functionKeyword, IHiddenRegionFormatter::oneSpace);
        if (function.getReturnType() != null) {
            ISemanticRegion colonKeyword = this.textRegionExtensions.regionFor((EObject)function).keyword(":");
            document.surround(colonKeyword, IHiddenRegionFormatter::oneSpace);
            document.prepend(colonKeyword, format -> {
                format.autowrap();
                format.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.regionFor((EObject)function).feature((EStructuralFeature)STFunctionPackage.Literals.ST_FUNCTION__RETURN_TYPE).getNextHiddenRegion()));
            });
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)function).feature((EStructuralFeature)STFunctionPackage.Literals.ST_FUNCTION__RETURN_TYPE), IHiddenRegionFormatter::oneSpace), it -> it.setNewLines(1, 1, 2));
        } else {
            document.append(this.textRegionExtensions.regionFor((EObject)function).assignment(this.grammarAccess.getSTFunctionAccess().getNameAssignment_2()), it -> it.setNewLines(1, 1, 2));
        }
        this.formatVarDeclarationBlocks(function.getVarDeclarations(), document);
        function.getCode().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        document.prepend(endKeyword, IHiddenRegionFormatter::noIndentation);
        document.append(endKeyword, it -> it.setNewLines(1, 2, 2));
    }

    public void format(Object object, IFormattableDocument document) {
        Object object2 = object;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STFunctionSource.class, STFunction.class}, (Object)object2, 0)) {
            case 0: {
                STFunctionSource element = (STFunctionSource)object2;
                this._format(element, document);
                break;
            }
            case 1: {
                STFunction element = (STFunction)object2;
                this._format(element, document);
                break;
            }
            default: {
                super.format(object, document);
            }
        }
    }
}

