/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.ui.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.ui.Messages;
import org.eclipse.fordiac.ide.library.ui.refactoring.AddLibraryDependencyChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class DeleteLibraryDependencyChange
extends CompositeChange {
    private final IProject project;
    private final String symbolicName;

    public DeleteLibraryDependencyChange(IProject project, String symbolicName) {
        super(Messages.DeleteLibraryParticipant_Change_Title);
        this.project = project;
        this.symbolicName = symbolicName;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Manifest projectManifest = ManifestHelper.getContainerManifest((IContainer)this.project);
        if (projectManifest == null || projectManifest.getDependencies() == null) {
            return null;
        }
        Required dependency = projectManifest.getDependencies().getRequired().stream().filter(r -> this.symbolicName.equals(r.getSymbolicName())).findAny().orElse(null);
        if (dependency != null && ManifestHelper.removeDependency((Manifest)projectManifest, (Required)dependency) && ManifestHelper.saveManifest((Manifest)projectManifest)) {
            return new AddLibraryDependencyChange(this.project, dependency);
        }
        return null;
    }
}

