% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-date.R
\name{transform_timespan}
\alias{transform_timespan}
\alias{timespan_trans}
\alias{transform_hms}
\alias{hms_trans}
\title{Transformation for times (class hms)}
\usage{
transform_timespan(unit = c("secs", "mins", "hours", "days", "weeks"))

timespan_trans(unit = c("secs", "mins", "hours", "days", "weeks"))

transform_hms()

hms_trans()
}
\arguments{
\item{unit}{The unit used to interpret numeric input}
}
\description{
\code{transform_timespan()} provides transformations for data encoding time passed
along with breaks and label formatting showing standard unit of time fitting
the range of the data. \code{transform_hms()} provides the same but using standard
hms idioms and formatting.
}
\examples{
# transform_timespan allows you to specify the time unit numeric data is
# interpreted in
trans_min <- transform_timespan("mins")
demo_timespan(seq(0, 100), trans = trans_min)
# Input already in difftime format is interpreted correctly
demo_timespan(as.difftime(seq(0, 100), units = "secs"), trans = trans_min)

if (require("hms")) {
  # transform_hms always assumes seconds
  hms <- round(runif(10) * 86400)
  t <- transform_hms()
  t$transform(hms)
  t$inverse(t$transform(hms))
  t$breaks(hms)
  # The break labels also follow the hms format
  demo_timespan(hms, trans = t)
}

}
