% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-cross.R
\name{cross}
\alias{cross}
\alias{cross2}
\alias{cross3}
\alias{cross_df}
\alias{cross_n}
\alias{cross_d}
\title{Produce all combinations of list elements}
\usage{
cross(.l, .filter = NULL)

cross2(.x, .y, .filter = NULL)

cross3(.x, .y, .z, .filter = NULL)

cross_df(.l, .filter = NULL)
}
\arguments{
\item{.l}{A list of lists or atomic vectors. Alternatively, a data
frame. \code{cross_df()} requires all elements to be named.}

\item{.filter}{A predicate function that takes the same number of
arguments as the number of variables to be combined.}

\item{.x, .y, .z}{Lists or atomic vectors.}
}
\value{
\code{cross2()}, \code{cross3()} and \code{cross()}
always return a list. \code{cross_df()} always returns a data
frame. \code{cross()} returns a list where each element is one
combination so that the list can be directly mapped
over. \code{cross_df()} returns a data frame where each row is one
combination.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These functions were deprecated in purrr 1.0.0 because they
are slow and buggy, and we no longer think they are the right
approach to solving this problem. Please use \code{tidyr::expand_grid()}
instead.

Here is an example of equivalent usages for \code{cross()} and
\code{expand_grid()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data <- list(
  id = c("John", "Jane"),
  sep = c("! ", "... "),
  greeting = c("Hello.", "Bonjour.")
)

# With deprecated `cross()`
data |> cross() |> map_chr(\\(...) paste0(..., collapse = ""))
#> [1] "John! Hello."     "Jane! Hello."     "John... Hello."   "Jane... Hello."  
#> [5] "John! Bonjour."   "Jane! Bonjour."   "John... Bonjour." "Jane... Bonjour."

# With `expand_grid()`
tidyr::expand_grid(!!!data) |> pmap_chr(paste)
#> [1] "John! Hello."     "John! Bonjour."   "John... Hello."   "John... Bonjour."
#> [5] "Jane! Hello."     "Jane! Bonjour."   "Jane... Hello."   "Jane... Bonjour."
}\if{html}{\out{</div>}}
}
\details{
\code{cross2()} returns the product set of the elements of
\code{.x} and \code{.y}. \code{cross3()} takes an additional
\code{.z} argument. \code{cross()} takes a list \code{.l} and
returns the cartesian product of all its elements in a list, with
one combination by element. \code{cross_df()} is like
\code{cross()} but returns a data frame, with one combination by
row.

\code{cross()}, \code{cross2()} and \code{cross3()} return the
cartesian product is returned in wide format. This makes it more
amenable to mapping operations. \code{cross_df()} returns the output
in long format just as \code{expand.grid()} does. This is adapted
to rowwise operations.

When the number of combinations is large and the individual
elements are heavy memory-wise, it is often useful to filter
unwanted combinations on the fly with \code{.filter}. It must be
a predicate function that takes the same number of arguments as the
number of crossed objects (2 for \code{cross2()}, 3 for
\code{cross3()}, \code{length(.l)} for \code{cross()}) and
returns \code{TRUE} or \code{FALSE}. The combinations where the
predicate function returns \code{TRUE} will be removed from the
result.
}
\examples{
# We build all combinations of names, greetings and separators from our
# list of data and pass each one to paste()
data <- list(
  id = c("John", "Jane"),
  greeting = c("Hello.", "Bonjour."),
  sep = c("! ", "... ")
)

data |>
  cross() |>
  map(lift(paste))

# cross() returns the combinations in long format: many elements,
# each representing one combination. With cross_df() we'll get a
# data frame in long format: crossing three objects produces a data
# frame of three columns with each row being a particular
# combination. This is the same format that expand.grid() returns.
args <- data |> cross_df()

# In case you need a list in long format (and not a data frame)
# just run as.list() after cross_df()
args |> as.list()

# This format is often less practical for functional programming
# because applying a function to the combinations requires a loop
out <- vector("character", length = nrow(args))
for (i in seq_along(out))
  out[[i]] <- invoke("paste", map(args, i))
out

# It's easier to transpose and then use invoke_map()
args |> transpose() |> map_chr(\(x) exec(paste, !!!x))

# Unwanted combinations can be filtered out with a predicate function
filter <- function(x, y) x >= y
cross2(1:5, 1:5, .filter = filter) |> str()

# To give names to the components of the combinations, we map
# setNames() on the product:
x <- seq_len(3)
cross2(x, x, .filter = `==`) |>
  map(setNames, c("x", "y"))

# Alternatively we can encapsulate the arguments in a named list
# before crossing to get named components:
list(x = x, y = x) |>
  cross(.filter = `==`)
}
\seealso{
\code{\link[=expand.grid]{expand.grid()}}
}
\keyword{internal}
