% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveGRangesList.R
\name{saveObject,GRangesList-method}
\alias{saveObject,GRangesList-method}
\alias{stageObject,GRangesList-method}
\title{Save a GRangesList object to disk}
\usage{
\S4method{saveObject}{GRangesList}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{GRangesList} object.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to specific methods.}
}
\value{
\code{x} is saved to \code{path}, and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{GRangesList} object to its on-disk representation.
}
\examples{
gr <- GRanges("chrA", IRanges(1:100, width=1))
grl <- split(gr, rep(1:3, length.out=length(gr)))

tmp <- tempfile()
saveObject(grl, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readGRangesList}}, to read a \linkS4class{GRangesList} from disk.
}
\author{
Aaron Lun
}
