Gradle Kotlin DSL 0.12.0 Release Notes
============================

Gradle Kotlin DSL v0.12.0 brings the latest and greatest Kotlin (**1.1.51**), runs on Java 9, has better support for Kotlin dependencies and more.

v0.12.0 is expected to be included in the upcoming Gradle 4.3 RC1.

The features in this release are also available for immediate use within the latest Gradle Kotlin DSL distribution snapshot. To use it, upgrade your Gradle wrapper in the following fashion:

    $ cd $YOUR_PROJECT_ROOT
    $ gradle wrapper --gradle-distribution-url https://repo.gradle.org/gradle/dist-snapshots/gradle-kotlin-dsl-4.3-20171004164220+0000-all.zip

Once Gradle 4.3 RC1 is out, we encourage all users to upgrade in the following fashion:

    $ cd $YOUR_PROJECT_ROOT
    $ gradle wrapper --gradle-version 4.3-rc-1 --distribution-type all

## Breaking changes

Starting with this release, [`kotlin("...")` plugin requests no longer default to `embeddedKotlinVersion`](#kotlin_plugin_request_version) and so build scripts that rely on that behavior must be changed to include an explicit version number otherwise they will fail.

For a concrete example, the following simple build script that applies the `kotlin("jvm")` plugin without specifying a version number will now fail:

```kotlin
// build.gradle.kts
plugins {
    kotlin("jvm")
}
```

    $ ./gradlew tasks
    FAILURE: Build failed with an exception.

    * What went wrong:
    Plugin [id: 'org.jetbrains.kotlin.jvm'] was not found in any of the following sources:

    ...

The solution is to include a version number:

```kotlin
// build.gradle.kts
plugins {
    kotlin("jvm") version "1.1.51"
}
```

Notice that in a multi-project setup, the version number for plugins used in multiple projects should be specified only once in a common ancestor project, possibly the root as it's done in [this sample](https://github.com/gradle/kotlin-dsl/blob/276b67ab352da61ea8dabafeb21637ddb7f1a019/samples/multi-kotlin-project/build.gradle.kts#L3).

Updates since v0.11.1
----------------------

 * **Kotlin 1.1.51** ([#473](https://github.com/gradle/kotlin-dsl/issues/473)). The embedded Kotlin version was upgraded from Kotlin 1.1.4-3 to the latest  [Kotlin 1.1.51 release](https://github.com/JetBrains/kotlin/releases/tag/v1.1.51), an update to [Kotlin 1.1.50](https://blog.jetbrains.com/kotlin/2017/09/kotlin-1-1-50-is-out/).

 * **Kotlin based build scripts run on Java 9 :tada:** ([#454](https://github.com/gradle/kotlin-dsl/issues/454), [#493](https://github.com/gradle/kotlin-dsl/issues/493)). Thanks in large part to the great Gradle Kotlin DSL community and [Jonathan Leitschuh](https://github.com/JLLeitschuh) in particular who pushed the necessary changes and testing forward. Thank you!

 * **More use-cases supported by the plugins block** ([#426](https://github.com/gradle/kotlin-dsl/issues/426)). Specifically, plugins already available in the classpath can now be applied via the plugins block thus enabling the following use cases:

    1. Plugin defined in `buildSrc` can be applied by id

        ```kotlin
        // root/buildSrc/src/main/kotlin/build/MyPlugin.kt
        package build

        import org.gradle.api.*

        open class MyPlugin : Plugin<Project> {

            override fun apply(project: Project) {
                // ...
            }
        }
        ```

        ```kotlin
        // root/buildSrc/build.gradle.kts
        plugins {
            `kotlin-dsl`
            `java-gradle-plugin`
        }

        gradlePlugin {
            (plugins) {
                "my-plugin" {
                    id = "my-plugin"
                    implementationClass = "build.MyPlugin"
                }
            }
        }
        ```

        ```kotlin
        // root/build.gradle.kts
        plugins {
            id("my-plugin")
        }
        ```

    2. Plugin applied to parent project can be applied in child projects

        ```kotlin
        // root/build.gradle.kts
        plugins {
            id("foo") version "1.0"
        }
        ```

        ```kotlin
        // root/sub/build.gradle.kts
        plugins {
            id("foo")
        }
        ```

    3. Plugin requested but not applied on parent can be applied in child projects

        ```kotlin
        // root/build.gradle.kts
        plugins {
            id("foo") version "1.0" apply false
        }
        ```

        ```kotlin
        // root/sub/build.gradle.kts
        plugins {
            id("foo")
        }
        ```

 * **Improved documentation**. The [_Configuring Plugins in the Gradle Kotlin DSL_]( https://github.com/gradle/kotlin-dsl/blob/03e020b796f474e9ac8862449606a0cb393053c4/doc/getting-started/Configuring-Plugins.md) documentation section was revamped to account for the new capabilities in Gradle and the Gradle Kotlin DSL. The [API documentation](https://gradle.github.io/kotlin-dsl-docs/api/) has also been updated to match this release.

 * **`kotlin("...")` plugin request no longer defaults to `embeddedKotlinVersion`** ([#520](https://github.com/gradle/kotlin-dsl/issues/520), [#521](https://github.com/gradle/kotlin-dsl/issues/521))

    <a name="kotlin_plugin_request_version"></a>

    Given that it is now possible to use the plugins block in child projects to apply plugins already requested on a parent project, the following idiom becomes possible:

    ```kotlin
    // root/build.gradle.kts
    plugins {
        // Decide version of plugin in the root project
        kotlin("jvm") version "1.1.51" apply false
    }
    ```

    ```kotlin
    // root/child/build.gradle.kts
    plugins {
        kotlin("jvm") // Reuse version defined by parent
    }
    ```

    In order to enable that use-case `kotlin("jvm")` will no longer imply `version embeddedKotlinVersion`.

    Unfortunately **this is a breaking change** as the version will now have to be specified at least once at the top most project.

 * **`kotlin("...")` dependency notation no longer defaults to `embeddedKotlinVersion`** ([#511](https://github.com/gradle/kotlin-dsl/issues/511)). The version of Kotlin artifact dependencies will be set by the Kotlin Gradle plugin as explained in the [_Using Gradle_ section of the Kotlin reference guide](https://kotlinlang.org/docs/reference/using-gradle.html#configuring-dependencies) :

   > Starting with Kotlin 1.1.2, the dependencies with group org.jetbrains.kotlin are by default resolved with the version taken from the applied plugin. You can provide the version manually using the full dependency notation.

 * **Richer and more consistent `DependencyHandler` API** ([#291](https://github.com/gradle/kotlin-dsl/issues/291)). For configurations known at plugin application time and otherwise as demonstrated by the following screenshots:

    - **Extensions for configurations known at plugin application time**

      ![image](https://user-images.githubusercontent.com/132773/30477645-2d027588-9a0e-11e7-9be4-427a804d6bef.png)

    - **String.invoke extensions (for addressing configurations by name)**

      ![image](https://user-images.githubusercontent.com/132773/30477559-ded6d642-9a0d-11e7-9dd7-c862a5bfdd51.png)

    - **Configuration.invoke extensions (for `Configuration` references already in scope)**

      ![image](https://user-images.githubusercontent.com/132773/30477630-1a39eea4-9a0e-11e7-9900-0f6220480d5b.png)

 * **Expose groovy builder delegate** ([#503](https://github.com/gradle/kotlin-dsl/issues/503)). So it can be explicitly passed as an argument, for example when configuring `mavenDeployer`:

    ```kotlin
    mavenDeployer {
        withGroovyBuilder {
            "beforeDeployment" {
                if (signing.required)
                    signing.signPom(delegate as MavenDeployment)
            }
        }
    }
    ```        

 * **Nullable extra properties** ([#516](https://github.com/gradle/kotlin-dsl/issues/516), [#512](https://github.com/gradle/kotlin-dsl/issues/512)). Nullable extra properties can now be expressed via nullability of the property type:

    ```kotlin
    val name by extra { null } // creates null extra property

    val name: String by extra  // throws NPE on property usage
    val name: String? by extra // works as expected
    ```

 * **Implicit imports comply with the Gradle core public API definition** ([#483](https://github.com/gradle/kotlin-dsl/issues/483))

   - By disambiguating simple type names amongst types with the same simple name in different Gradle API packages. For example, resolving `Jar` to the correct type. Previously wildcard implicit imports failed to resolve `Jar` as it matches both `org.gradle.api.tasks.bundling.Jar` and `org.gradle.jvm.tasks.Jar` forcing the use of explicit imports. With the new behaviour `Jar` will be resolved to `org.gradle.jvm.tasks.Jar` as specified by Gradle.

   - By no longer including the internal `org.gradle.util` package in the set of implicit imports.

* **New sample demonstrating how to build a simple Javascript application written in Kotlin** ([#470](https://github.com/gradle/kotlin-dsl/issues/470), [#478](https://github.com/gradle/kotlin-dsl/issues/478)). The sample can be found in [samples/hello-js](https://github.com/gradle/kotlin-dsl/tree/b3e0cefeb4ae1aaa4f86ebb64c74abd73e5ac5ad/samples/hello-js).

 * **Android sample now uses the `plugins` block to apply android and kotlin plugins** ([#406](https://github.com/gradle/kotlin-dsl/issues/406)). Which makes it easier to configure the project by removing the need to generate the `gradle/project-schema.json` file.

    A plugin resolution strategy is used to substitute plugin requests for `id("com.android.application")` by the actual Android Gradle Plugin artifact. This strategy also works with the upcoming Android Gradle Plugin 3.

    The sample can be found in [samples/hello-android](https://github.com/gradle/kotlin-dsl/tree/2ebf642fed851bf7532042fac08b0383fc262c34/samples/hello-android).

 * **`kotlin-dsl` plugin no longer declares redundant runtime Kotlin dependency** ([#509](https://github.com/gradle/kotlin-dsl/issues/509), [#510](https://github.com/gradle/kotlin-dsl/issues/510)). The `embedded-kotlin` plugin, applied by `kotlin-dsl` will now add the `kotlin-stdlib` and `kotlin-reflect` dependencies to the `compileOnly` and `testCompileOnly` configurations instead of `compile`.

 * **Dollar sign in extension or configuration names no longer cause build script compilation errors** ([#494](https://github.com/gradle/kotlin-dsl/issues/494))

  * **IntelliJ improvements**
     - [KT-19310](https://youtrack.jetbrains.com/issue/KT-19310) Intellij can't resolve inner types in plugin class in build.gradle.kts files ([#417](https://github.com/gradle/kotlin-dsl/issues/417))
     - [KT-19466](https://youtrack.jetbrains.com/issue/KT-19466) Kotlin based Gradle build not recognized when added as a module ([#188](https://github.com/gradle/kotlin-dsl/issues/188))
     - [KT-18889](https://youtrack.jetbrains.com/issue/KT-18889) Cannot navigate to source of overloaded property setter ([#409](https://github.com/gradle/kotlin-dsl/issues/409))
     - [KT-18890](https://youtrack.jetbrains.com/issue/KT-18890) Cannot navigate to source of method accepting SAMWithReceiver argument ([#410](https://github.com/gradle/kotlin-dsl/issues/410))
