// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"entgo.io/ent/entc/integration/ent/card"
	"entgo.io/ent/entc/integration/ent/comment"
	"entgo.io/ent/entc/integration/ent/fieldtype"
	"entgo.io/ent/entc/integration/ent/file"
	"entgo.io/ent/entc/integration/ent/filetype"
	"entgo.io/ent/entc/integration/ent/goods"
	"entgo.io/ent/entc/integration/ent/group"
	"entgo.io/ent/entc/integration/ent/groupinfo"
	"entgo.io/ent/entc/integration/ent/item"
	"entgo.io/ent/entc/integration/ent/license"
	"entgo.io/ent/entc/integration/ent/node"
	"entgo.io/ent/entc/integration/ent/pet"
	"entgo.io/ent/entc/integration/ent/predicate"
	"entgo.io/ent/entc/integration/ent/spec"
	enttask "entgo.io/ent/entc/integration/ent/task"
	"entgo.io/ent/entc/integration/ent/user"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entql"
	"entgo.io/ent/schema/field"
)

// schemaGraph holds a representation of ent/schema at runtime.
var schemaGraph = func() *sqlgraph.Schema {
	graph := &sqlgraph.Schema{Nodes: make([]*sqlgraph.Node, 15)}
	graph.Nodes[0] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   card.Table,
			Columns: card.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: card.FieldID,
			},
		},
		Type: "Card",
		Fields: map[string]*sqlgraph.FieldSpec{
			card.FieldCreateTime: {Type: field.TypeTime, Column: card.FieldCreateTime},
			card.FieldUpdateTime: {Type: field.TypeTime, Column: card.FieldUpdateTime},
			card.FieldBalance:    {Type: field.TypeFloat64, Column: card.FieldBalance},
			card.FieldNumber:     {Type: field.TypeString, Column: card.FieldNumber},
			card.FieldName:       {Type: field.TypeString, Column: card.FieldName},
		},
	}
	graph.Nodes[1] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   comment.Table,
			Columns: comment.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: comment.FieldID,
			},
		},
		Type: "Comment",
		Fields: map[string]*sqlgraph.FieldSpec{
			comment.FieldUniqueInt:   {Type: field.TypeInt, Column: comment.FieldUniqueInt},
			comment.FieldUniqueFloat: {Type: field.TypeFloat64, Column: comment.FieldUniqueFloat},
			comment.FieldNillableInt: {Type: field.TypeInt, Column: comment.FieldNillableInt},
			comment.FieldTable:       {Type: field.TypeString, Column: comment.FieldTable},
			comment.FieldDir:         {Type: field.TypeJSON, Column: comment.FieldDir},
			comment.FieldClient:      {Type: field.TypeString, Column: comment.FieldClient},
		},
	}
	graph.Nodes[2] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   fieldtype.Table,
			Columns: fieldtype.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: fieldtype.FieldID,
			},
		},
		Type: "FieldType",
		Fields: map[string]*sqlgraph.FieldSpec{
			fieldtype.FieldInt:                   {Type: field.TypeInt, Column: fieldtype.FieldInt},
			fieldtype.FieldInt8:                  {Type: field.TypeInt8, Column: fieldtype.FieldInt8},
			fieldtype.FieldInt16:                 {Type: field.TypeInt16, Column: fieldtype.FieldInt16},
			fieldtype.FieldInt32:                 {Type: field.TypeInt32, Column: fieldtype.FieldInt32},
			fieldtype.FieldInt64:                 {Type: field.TypeInt64, Column: fieldtype.FieldInt64},
			fieldtype.FieldOptionalInt:           {Type: field.TypeInt, Column: fieldtype.FieldOptionalInt},
			fieldtype.FieldOptionalInt8:          {Type: field.TypeInt8, Column: fieldtype.FieldOptionalInt8},
			fieldtype.FieldOptionalInt16:         {Type: field.TypeInt16, Column: fieldtype.FieldOptionalInt16},
			fieldtype.FieldOptionalInt32:         {Type: field.TypeInt32, Column: fieldtype.FieldOptionalInt32},
			fieldtype.FieldOptionalInt64:         {Type: field.TypeInt64, Column: fieldtype.FieldOptionalInt64},
			fieldtype.FieldNillableInt:           {Type: field.TypeInt, Column: fieldtype.FieldNillableInt},
			fieldtype.FieldNillableInt8:          {Type: field.TypeInt8, Column: fieldtype.FieldNillableInt8},
			fieldtype.FieldNillableInt16:         {Type: field.TypeInt16, Column: fieldtype.FieldNillableInt16},
			fieldtype.FieldNillableInt32:         {Type: field.TypeInt32, Column: fieldtype.FieldNillableInt32},
			fieldtype.FieldNillableInt64:         {Type: field.TypeInt64, Column: fieldtype.FieldNillableInt64},
			fieldtype.FieldValidateOptionalInt32: {Type: field.TypeInt32, Column: fieldtype.FieldValidateOptionalInt32},
			fieldtype.FieldOptionalUint:          {Type: field.TypeUint, Column: fieldtype.FieldOptionalUint},
			fieldtype.FieldOptionalUint8:         {Type: field.TypeUint8, Column: fieldtype.FieldOptionalUint8},
			fieldtype.FieldOptionalUint16:        {Type: field.TypeUint16, Column: fieldtype.FieldOptionalUint16},
			fieldtype.FieldOptionalUint32:        {Type: field.TypeUint32, Column: fieldtype.FieldOptionalUint32},
			fieldtype.FieldOptionalUint64:        {Type: field.TypeUint64, Column: fieldtype.FieldOptionalUint64},
			fieldtype.FieldState:                 {Type: field.TypeEnum, Column: fieldtype.FieldState},
			fieldtype.FieldOptionalFloat:         {Type: field.TypeFloat64, Column: fieldtype.FieldOptionalFloat},
			fieldtype.FieldOptionalFloat32:       {Type: field.TypeFloat32, Column: fieldtype.FieldOptionalFloat32},
			fieldtype.FieldText:                  {Type: field.TypeString, Column: fieldtype.FieldText},
			fieldtype.FieldDatetime:              {Type: field.TypeTime, Column: fieldtype.FieldDatetime},
			fieldtype.FieldDecimal:               {Type: field.TypeFloat64, Column: fieldtype.FieldDecimal},
			fieldtype.FieldLinkOther:             {Type: field.TypeOther, Column: fieldtype.FieldLinkOther},
			fieldtype.FieldLinkOtherFunc:         {Type: field.TypeOther, Column: fieldtype.FieldLinkOtherFunc},
			fieldtype.FieldMAC:                   {Type: field.TypeString, Column: fieldtype.FieldMAC},
			fieldtype.FieldStringArray:           {Type: field.TypeOther, Column: fieldtype.FieldStringArray},
			fieldtype.FieldPassword:              {Type: field.TypeString, Column: fieldtype.FieldPassword},
			fieldtype.FieldStringScanner:         {Type: field.TypeString, Column: fieldtype.FieldStringScanner},
			fieldtype.FieldDuration:              {Type: field.TypeInt64, Column: fieldtype.FieldDuration},
			fieldtype.FieldDir:                   {Type: field.TypeString, Column: fieldtype.FieldDir},
			fieldtype.FieldNdir:                  {Type: field.TypeString, Column: fieldtype.FieldNdir},
			fieldtype.FieldStr:                   {Type: field.TypeString, Column: fieldtype.FieldStr},
			fieldtype.FieldNullStr:               {Type: field.TypeString, Column: fieldtype.FieldNullStr},
			fieldtype.FieldLink:                  {Type: field.TypeString, Column: fieldtype.FieldLink},
			fieldtype.FieldNullLink:              {Type: field.TypeString, Column: fieldtype.FieldNullLink},
			fieldtype.FieldActive:                {Type: field.TypeBool, Column: fieldtype.FieldActive},
			fieldtype.FieldNullActive:            {Type: field.TypeBool, Column: fieldtype.FieldNullActive},
			fieldtype.FieldDeleted:               {Type: field.TypeBool, Column: fieldtype.FieldDeleted},
			fieldtype.FieldDeletedAt:             {Type: field.TypeTime, Column: fieldtype.FieldDeletedAt},
			fieldtype.FieldRawData:               {Type: field.TypeBytes, Column: fieldtype.FieldRawData},
			fieldtype.FieldSensitive:             {Type: field.TypeBytes, Column: fieldtype.FieldSensitive},
			fieldtype.FieldIP:                    {Type: field.TypeBytes, Column: fieldtype.FieldIP},
			fieldtype.FieldNullInt64:             {Type: field.TypeInt, Column: fieldtype.FieldNullInt64},
			fieldtype.FieldSchemaInt:             {Type: field.TypeInt, Column: fieldtype.FieldSchemaInt},
			fieldtype.FieldSchemaInt8:            {Type: field.TypeInt8, Column: fieldtype.FieldSchemaInt8},
			fieldtype.FieldSchemaInt64:           {Type: field.TypeInt64, Column: fieldtype.FieldSchemaInt64},
			fieldtype.FieldSchemaFloat:           {Type: field.TypeFloat64, Column: fieldtype.FieldSchemaFloat},
			fieldtype.FieldSchemaFloat32:         {Type: field.TypeFloat32, Column: fieldtype.FieldSchemaFloat32},
			fieldtype.FieldNullFloat:             {Type: field.TypeFloat64, Column: fieldtype.FieldNullFloat},
			fieldtype.FieldRole:                  {Type: field.TypeEnum, Column: fieldtype.FieldRole},
			fieldtype.FieldPriority:              {Type: field.TypeEnum, Column: fieldtype.FieldPriority},
			fieldtype.FieldOptionalUUID:          {Type: field.TypeUUID, Column: fieldtype.FieldOptionalUUID},
			fieldtype.FieldNillableUUID:          {Type: field.TypeUUID, Column: fieldtype.FieldNillableUUID},
			fieldtype.FieldStrings:               {Type: field.TypeJSON, Column: fieldtype.FieldStrings},
			fieldtype.FieldPair:                  {Type: field.TypeBytes, Column: fieldtype.FieldPair},
			fieldtype.FieldNilPair:               {Type: field.TypeBytes, Column: fieldtype.FieldNilPair},
			fieldtype.FieldVstring:               {Type: field.TypeString, Column: fieldtype.FieldVstring},
			fieldtype.FieldTriple:                {Type: field.TypeString, Column: fieldtype.FieldTriple},
			fieldtype.FieldBigInt:                {Type: field.TypeInt, Column: fieldtype.FieldBigInt},
			fieldtype.FieldPasswordOther:         {Type: field.TypeOther, Column: fieldtype.FieldPasswordOther},
		},
	}
	graph.Nodes[3] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   file.Table,
			Columns: file.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: file.FieldID,
			},
		},
		Type: "File",
		Fields: map[string]*sqlgraph.FieldSpec{
			file.FieldSize:    {Type: field.TypeInt, Column: file.FieldSize},
			file.FieldName:    {Type: field.TypeString, Column: file.FieldName},
			file.FieldUser:    {Type: field.TypeString, Column: file.FieldUser},
			file.FieldGroup:   {Type: field.TypeString, Column: file.FieldGroup},
			file.FieldOp:      {Type: field.TypeBool, Column: file.FieldOp},
			file.FieldFieldID: {Type: field.TypeInt, Column: file.FieldFieldID},
		},
	}
	graph.Nodes[4] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   filetype.Table,
			Columns: filetype.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: filetype.FieldID,
			},
		},
		Type: "FileType",
		Fields: map[string]*sqlgraph.FieldSpec{
			filetype.FieldName:  {Type: field.TypeString, Column: filetype.FieldName},
			filetype.FieldType:  {Type: field.TypeEnum, Column: filetype.FieldType},
			filetype.FieldState: {Type: field.TypeEnum, Column: filetype.FieldState},
		},
	}
	graph.Nodes[5] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   goods.Table,
			Columns: goods.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: goods.FieldID,
			},
		},
		Type:   "Goods",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[6] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   group.Table,
			Columns: group.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: group.FieldID,
			},
		},
		Type: "Group",
		Fields: map[string]*sqlgraph.FieldSpec{
			group.FieldActive:   {Type: field.TypeBool, Column: group.FieldActive},
			group.FieldExpire:   {Type: field.TypeTime, Column: group.FieldExpire},
			group.FieldType:     {Type: field.TypeString, Column: group.FieldType},
			group.FieldMaxUsers: {Type: field.TypeInt, Column: group.FieldMaxUsers},
			group.FieldName:     {Type: field.TypeString, Column: group.FieldName},
		},
	}
	graph.Nodes[7] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   groupinfo.Table,
			Columns: groupinfo.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: groupinfo.FieldID,
			},
		},
		Type: "GroupInfo",
		Fields: map[string]*sqlgraph.FieldSpec{
			groupinfo.FieldDesc:     {Type: field.TypeString, Column: groupinfo.FieldDesc},
			groupinfo.FieldMaxUsers: {Type: field.TypeInt, Column: groupinfo.FieldMaxUsers},
		},
	}
	graph.Nodes[8] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   item.Table,
			Columns: item.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: item.FieldID,
			},
		},
		Type: "Item",
		Fields: map[string]*sqlgraph.FieldSpec{
			item.FieldText: {Type: field.TypeString, Column: item.FieldText},
		},
	}
	graph.Nodes[9] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   license.Table,
			Columns: license.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: license.FieldID,
			},
		},
		Type: "License",
		Fields: map[string]*sqlgraph.FieldSpec{
			license.FieldCreateTime: {Type: field.TypeTime, Column: license.FieldCreateTime},
			license.FieldUpdateTime: {Type: field.TypeTime, Column: license.FieldUpdateTime},
		},
	}
	graph.Nodes[10] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   node.Table,
			Columns: node.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: node.FieldID,
			},
		},
		Type: "Node",
		Fields: map[string]*sqlgraph.FieldSpec{
			node.FieldValue: {Type: field.TypeInt, Column: node.FieldValue},
		},
	}
	graph.Nodes[11] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   pet.Table,
			Columns: pet.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: pet.FieldID,
			},
		},
		Type: "Pet",
		Fields: map[string]*sqlgraph.FieldSpec{
			pet.FieldAge:      {Type: field.TypeFloat64, Column: pet.FieldAge},
			pet.FieldName:     {Type: field.TypeString, Column: pet.FieldName},
			pet.FieldUUID:     {Type: field.TypeUUID, Column: pet.FieldUUID},
			pet.FieldNickname: {Type: field.TypeString, Column: pet.FieldNickname},
			pet.FieldTrained:  {Type: field.TypeBool, Column: pet.FieldTrained},
		},
	}
	graph.Nodes[12] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   spec.Table,
			Columns: spec.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: spec.FieldID,
			},
		},
		Type:   "Spec",
		Fields: map[string]*sqlgraph.FieldSpec{},
	}
	graph.Nodes[13] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   enttask.Table,
			Columns: enttask.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: enttask.FieldID,
			},
		},
		Type: "Task",
		Fields: map[string]*sqlgraph.FieldSpec{
			enttask.FieldPriority:   {Type: field.TypeInt, Column: enttask.FieldPriority},
			enttask.FieldPriorities: {Type: field.TypeJSON, Column: enttask.FieldPriorities},
			enttask.FieldCreatedAt:  {Type: field.TypeTime, Column: enttask.FieldCreatedAt},
		},
	}
	graph.Nodes[14] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   user.Table,
			Columns: user.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: user.FieldID,
			},
		},
		Type: "User",
		Fields: map[string]*sqlgraph.FieldSpec{
			user.FieldOptionalInt: {Type: field.TypeInt, Column: user.FieldOptionalInt},
			user.FieldAge:         {Type: field.TypeInt, Column: user.FieldAge},
			user.FieldName:        {Type: field.TypeString, Column: user.FieldName},
			user.FieldLast:        {Type: field.TypeString, Column: user.FieldLast},
			user.FieldNickname:    {Type: field.TypeString, Column: user.FieldNickname},
			user.FieldAddress:     {Type: field.TypeString, Column: user.FieldAddress},
			user.FieldPhone:       {Type: field.TypeString, Column: user.FieldPhone},
			user.FieldPassword:    {Type: field.TypeString, Column: user.FieldPassword},
			user.FieldRole:        {Type: field.TypeEnum, Column: user.FieldRole},
			user.FieldEmployment:  {Type: field.TypeEnum, Column: user.FieldEmployment},
			user.FieldSSOCert:     {Type: field.TypeString, Column: user.FieldSSOCert},
		},
	}
	graph.MustAddE(
		"owner",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: true,
			Table:   card.OwnerTable,
			Columns: []string{card.OwnerColumn},
			Bidi:    false,
		},
		"Card",
		"User",
	)
	graph.MustAddE(
		"spec",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   card.SpecTable,
			Columns: card.SpecPrimaryKey,
			Bidi:    false,
		},
		"Card",
		"Spec",
	)
	graph.MustAddE(
		"owner",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   file.OwnerTable,
			Columns: []string{file.OwnerColumn},
			Bidi:    false,
		},
		"File",
		"User",
	)
	graph.MustAddE(
		"type",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   file.TypeTable,
			Columns: []string{file.TypeColumn},
			Bidi:    false,
		},
		"File",
		"FileType",
	)
	graph.MustAddE(
		"field",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   file.FieldTable,
			Columns: []string{file.FieldColumn},
			Bidi:    false,
		},
		"File",
		"FieldType",
	)
	graph.MustAddE(
		"files",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   filetype.FilesTable,
			Columns: []string{filetype.FilesColumn},
			Bidi:    false,
		},
		"FileType",
		"File",
	)
	graph.MustAddE(
		"files",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.FilesTable,
			Columns: []string{group.FilesColumn},
			Bidi:    false,
		},
		"Group",
		"File",
	)
	graph.MustAddE(
		"blocked",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.BlockedTable,
			Columns: []string{group.BlockedColumn},
			Bidi:    false,
		},
		"Group",
		"User",
	)
	graph.MustAddE(
		"users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.UsersTable,
			Columns: group.UsersPrimaryKey,
			Bidi:    false,
		},
		"Group",
		"User",
	)
	graph.MustAddE(
		"info",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   group.InfoTable,
			Columns: []string{group.InfoColumn},
			Bidi:    false,
		},
		"Group",
		"GroupInfo",
	)
	graph.MustAddE(
		"groups",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   groupinfo.GroupsTable,
			Columns: []string{groupinfo.GroupsColumn},
			Bidi:    false,
		},
		"GroupInfo",
		"Group",
	)
	graph.MustAddE(
		"prev",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: true,
			Table:   node.PrevTable,
			Columns: []string{node.PrevColumn},
			Bidi:    false,
		},
		"Node",
		"Node",
	)
	graph.MustAddE(
		"next",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   node.NextTable,
			Columns: []string{node.NextColumn},
			Bidi:    false,
		},
		"Node",
		"Node",
	)
	graph.MustAddE(
		"team",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: true,
			Table:   pet.TeamTable,
			Columns: []string{pet.TeamColumn},
			Bidi:    false,
		},
		"Pet",
		"User",
	)
	graph.MustAddE(
		"owner",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   pet.OwnerTable,
			Columns: []string{pet.OwnerColumn},
			Bidi:    false,
		},
		"Pet",
		"User",
	)
	graph.MustAddE(
		"card",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   spec.CardTable,
			Columns: spec.CardPrimaryKey,
			Bidi:    false,
		},
		"Spec",
		"Card",
	)
	graph.MustAddE(
		"card",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   user.CardTable,
			Columns: []string{user.CardColumn},
			Bidi:    false,
		},
		"User",
		"Card",
	)
	graph.MustAddE(
		"pets",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   user.PetsTable,
			Columns: []string{user.PetsColumn},
			Bidi:    false,
		},
		"User",
		"Pet",
	)
	graph.MustAddE(
		"files",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   user.FilesTable,
			Columns: []string{user.FilesColumn},
			Bidi:    false,
		},
		"User",
		"File",
	)
	graph.MustAddE(
		"groups",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.GroupsTable,
			Columns: user.GroupsPrimaryKey,
			Bidi:    false,
		},
		"User",
		"Group",
	)
	graph.MustAddE(
		"friends",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.FriendsTable,
			Columns: user.FriendsPrimaryKey,
			Bidi:    true,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"followers",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   user.FollowersTable,
			Columns: user.FollowersPrimaryKey,
			Bidi:    false,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"following",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.FollowingTable,
			Columns: user.FollowingPrimaryKey,
			Bidi:    false,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"team",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   user.TeamTable,
			Columns: []string{user.TeamColumn},
			Bidi:    false,
		},
		"User",
		"Pet",
	)
	graph.MustAddE(
		"spouse",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2O,
			Inverse: false,
			Table:   user.SpouseTable,
			Columns: []string{user.SpouseColumn},
			Bidi:    true,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"children",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.ChildrenTable,
			Columns: []string{user.ChildrenColumn},
			Bidi:    false,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"parent",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   user.ParentTable,
			Columns: []string{user.ParentColumn},
			Bidi:    false,
		},
		"User",
		"User",
	)
	return graph
}()

// predicateAdder wraps the addPredicate method.
// All update, update-one and query builders implement this interface.
type predicateAdder interface {
	addPredicate(func(s *sql.Selector))
}

// addPredicate implements the predicateAdder interface.
func (cq *CardQuery) addPredicate(pred func(s *sql.Selector)) {
	cq.predicates = append(cq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the CardQuery builder.
func (cq *CardQuery) Filter() *CardFilter {
	return &CardFilter{config: cq.config, predicateAdder: cq}
}

// addPredicate implements the predicateAdder interface.
func (m *CardMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the CardMutation builder.
func (m *CardMutation) Filter() *CardFilter {
	return &CardFilter{config: m.config, predicateAdder: m}
}

// CardFilter provides a generic filtering capability at runtime for CardQuery.
type CardFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *CardFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[0].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *CardFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(card.FieldID))
}

// WhereCreateTime applies the entql time.Time predicate on the create_time field.
func (f *CardFilter) WhereCreateTime(p entql.TimeP) {
	f.Where(p.Field(card.FieldCreateTime))
}

// WhereUpdateTime applies the entql time.Time predicate on the update_time field.
func (f *CardFilter) WhereUpdateTime(p entql.TimeP) {
	f.Where(p.Field(card.FieldUpdateTime))
}

// WhereBalance applies the entql float64 predicate on the balance field.
func (f *CardFilter) WhereBalance(p entql.Float64P) {
	f.Where(p.Field(card.FieldBalance))
}

// WhereNumber applies the entql string predicate on the number field.
func (f *CardFilter) WhereNumber(p entql.StringP) {
	f.Where(p.Field(card.FieldNumber))
}

// WhereName applies the entql string predicate on the name field.
func (f *CardFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(card.FieldName))
}

// WhereHasOwner applies a predicate to check if query has an edge owner.
func (f *CardFilter) WhereHasOwner() {
	f.Where(entql.HasEdge("owner"))
}

// WhereHasOwnerWith applies a predicate to check if query has an edge owner with a given conditions (other predicates).
func (f *CardFilter) WhereHasOwnerWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("owner", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasSpec applies a predicate to check if query has an edge spec.
func (f *CardFilter) WhereHasSpec() {
	f.Where(entql.HasEdge("spec"))
}

// WhereHasSpecWith applies a predicate to check if query has an edge spec with a given conditions (other predicates).
func (f *CardFilter) WhereHasSpecWith(preds ...predicate.Spec) {
	f.Where(entql.HasEdgeWith("spec", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (cq *CommentQuery) addPredicate(pred func(s *sql.Selector)) {
	cq.predicates = append(cq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the CommentQuery builder.
func (cq *CommentQuery) Filter() *CommentFilter {
	return &CommentFilter{config: cq.config, predicateAdder: cq}
}

// addPredicate implements the predicateAdder interface.
func (m *CommentMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the CommentMutation builder.
func (m *CommentMutation) Filter() *CommentFilter {
	return &CommentFilter{config: m.config, predicateAdder: m}
}

// CommentFilter provides a generic filtering capability at runtime for CommentQuery.
type CommentFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *CommentFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[1].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *CommentFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(comment.FieldID))
}

// WhereUniqueInt applies the entql int predicate on the unique_int field.
func (f *CommentFilter) WhereUniqueInt(p entql.IntP) {
	f.Where(p.Field(comment.FieldUniqueInt))
}

// WhereUniqueFloat applies the entql float64 predicate on the unique_float field.
func (f *CommentFilter) WhereUniqueFloat(p entql.Float64P) {
	f.Where(p.Field(comment.FieldUniqueFloat))
}

// WhereNillableInt applies the entql int predicate on the nillable_int field.
func (f *CommentFilter) WhereNillableInt(p entql.IntP) {
	f.Where(p.Field(comment.FieldNillableInt))
}

// WhereTable applies the entql string predicate on the table field.
func (f *CommentFilter) WhereTable(p entql.StringP) {
	f.Where(p.Field(comment.FieldTable))
}

// WhereDir applies the entql json.RawMessage predicate on the dir field.
func (f *CommentFilter) WhereDir(p entql.BytesP) {
	f.Where(p.Field(comment.FieldDir))
}

// WhereClient applies the entql string predicate on the client field.
func (f *CommentFilter) WhereClient(p entql.StringP) {
	f.Where(p.Field(comment.FieldClient))
}

// addPredicate implements the predicateAdder interface.
func (ftq *FieldTypeQuery) addPredicate(pred func(s *sql.Selector)) {
	ftq.predicates = append(ftq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the FieldTypeQuery builder.
func (ftq *FieldTypeQuery) Filter() *FieldTypeFilter {
	return &FieldTypeFilter{config: ftq.config, predicateAdder: ftq}
}

// addPredicate implements the predicateAdder interface.
func (m *FieldTypeMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the FieldTypeMutation builder.
func (m *FieldTypeMutation) Filter() *FieldTypeFilter {
	return &FieldTypeFilter{config: m.config, predicateAdder: m}
}

// FieldTypeFilter provides a generic filtering capability at runtime for FieldTypeQuery.
type FieldTypeFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *FieldTypeFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[2].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *FieldTypeFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(fieldtype.FieldID))
}

// WhereInt applies the entql int predicate on the int field.
func (f *FieldTypeFilter) WhereInt(p entql.IntP) {
	f.Where(p.Field(fieldtype.FieldInt))
}

// WhereInt8 applies the entql int8 predicate on the int8 field.
func (f *FieldTypeFilter) WhereInt8(p entql.Int8P) {
	f.Where(p.Field(fieldtype.FieldInt8))
}

// WhereInt16 applies the entql int16 predicate on the int16 field.
func (f *FieldTypeFilter) WhereInt16(p entql.Int16P) {
	f.Where(p.Field(fieldtype.FieldInt16))
}

// WhereInt32 applies the entql int32 predicate on the int32 field.
func (f *FieldTypeFilter) WhereInt32(p entql.Int32P) {
	f.Where(p.Field(fieldtype.FieldInt32))
}

// WhereInt64 applies the entql int64 predicate on the int64 field.
func (f *FieldTypeFilter) WhereInt64(p entql.Int64P) {
	f.Where(p.Field(fieldtype.FieldInt64))
}

// WhereOptionalInt applies the entql int predicate on the optional_int field.
func (f *FieldTypeFilter) WhereOptionalInt(p entql.IntP) {
	f.Where(p.Field(fieldtype.FieldOptionalInt))
}

// WhereOptionalInt8 applies the entql int8 predicate on the optional_int8 field.
func (f *FieldTypeFilter) WhereOptionalInt8(p entql.Int8P) {
	f.Where(p.Field(fieldtype.FieldOptionalInt8))
}

// WhereOptionalInt16 applies the entql int16 predicate on the optional_int16 field.
func (f *FieldTypeFilter) WhereOptionalInt16(p entql.Int16P) {
	f.Where(p.Field(fieldtype.FieldOptionalInt16))
}

// WhereOptionalInt32 applies the entql int32 predicate on the optional_int32 field.
func (f *FieldTypeFilter) WhereOptionalInt32(p entql.Int32P) {
	f.Where(p.Field(fieldtype.FieldOptionalInt32))
}

// WhereOptionalInt64 applies the entql int64 predicate on the optional_int64 field.
func (f *FieldTypeFilter) WhereOptionalInt64(p entql.Int64P) {
	f.Where(p.Field(fieldtype.FieldOptionalInt64))
}

// WhereNillableInt applies the entql int predicate on the nillable_int field.
func (f *FieldTypeFilter) WhereNillableInt(p entql.IntP) {
	f.Where(p.Field(fieldtype.FieldNillableInt))
}

// WhereNillableInt8 applies the entql int8 predicate on the nillable_int8 field.
func (f *FieldTypeFilter) WhereNillableInt8(p entql.Int8P) {
	f.Where(p.Field(fieldtype.FieldNillableInt8))
}

// WhereNillableInt16 applies the entql int16 predicate on the nillable_int16 field.
func (f *FieldTypeFilter) WhereNillableInt16(p entql.Int16P) {
	f.Where(p.Field(fieldtype.FieldNillableInt16))
}

// WhereNillableInt32 applies the entql int32 predicate on the nillable_int32 field.
func (f *FieldTypeFilter) WhereNillableInt32(p entql.Int32P) {
	f.Where(p.Field(fieldtype.FieldNillableInt32))
}

// WhereNillableInt64 applies the entql int64 predicate on the nillable_int64 field.
func (f *FieldTypeFilter) WhereNillableInt64(p entql.Int64P) {
	f.Where(p.Field(fieldtype.FieldNillableInt64))
}

// WhereValidateOptionalInt32 applies the entql int32 predicate on the validate_optional_int32 field.
func (f *FieldTypeFilter) WhereValidateOptionalInt32(p entql.Int32P) {
	f.Where(p.Field(fieldtype.FieldValidateOptionalInt32))
}

// WhereOptionalUint applies the entql uint predicate on the optional_uint field.
func (f *FieldTypeFilter) WhereOptionalUint(p entql.UintP) {
	f.Where(p.Field(fieldtype.FieldOptionalUint))
}

// WhereOptionalUint8 applies the entql uint8 predicate on the optional_uint8 field.
func (f *FieldTypeFilter) WhereOptionalUint8(p entql.Uint8P) {
	f.Where(p.Field(fieldtype.FieldOptionalUint8))
}

// WhereOptionalUint16 applies the entql uint16 predicate on the optional_uint16 field.
func (f *FieldTypeFilter) WhereOptionalUint16(p entql.Uint16P) {
	f.Where(p.Field(fieldtype.FieldOptionalUint16))
}

// WhereOptionalUint32 applies the entql uint32 predicate on the optional_uint32 field.
func (f *FieldTypeFilter) WhereOptionalUint32(p entql.Uint32P) {
	f.Where(p.Field(fieldtype.FieldOptionalUint32))
}

// WhereOptionalUint64 applies the entql uint64 predicate on the optional_uint64 field.
func (f *FieldTypeFilter) WhereOptionalUint64(p entql.Uint64P) {
	f.Where(p.Field(fieldtype.FieldOptionalUint64))
}

// WhereState applies the entql string predicate on the state field.
func (f *FieldTypeFilter) WhereState(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldState))
}

// WhereOptionalFloat applies the entql float64 predicate on the optional_float field.
func (f *FieldTypeFilter) WhereOptionalFloat(p entql.Float64P) {
	f.Where(p.Field(fieldtype.FieldOptionalFloat))
}

// WhereOptionalFloat32 applies the entql float32 predicate on the optional_float32 field.
func (f *FieldTypeFilter) WhereOptionalFloat32(p entql.Float32P) {
	f.Where(p.Field(fieldtype.FieldOptionalFloat32))
}

// WhereText applies the entql string predicate on the text field.
func (f *FieldTypeFilter) WhereText(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldText))
}

// WhereDatetime applies the entql time.Time predicate on the datetime field.
func (f *FieldTypeFilter) WhereDatetime(p entql.TimeP) {
	f.Where(p.Field(fieldtype.FieldDatetime))
}

// WhereDecimal applies the entql float64 predicate on the decimal field.
func (f *FieldTypeFilter) WhereDecimal(p entql.Float64P) {
	f.Where(p.Field(fieldtype.FieldDecimal))
}

// WhereLinkOther applies the entql other predicate on the link_other field.
func (f *FieldTypeFilter) WhereLinkOther(p entql.OtherP) {
	f.Where(p.Field(fieldtype.FieldLinkOther))
}

// WhereLinkOtherFunc applies the entql other predicate on the link_other_func field.
func (f *FieldTypeFilter) WhereLinkOtherFunc(p entql.OtherP) {
	f.Where(p.Field(fieldtype.FieldLinkOtherFunc))
}

// WhereMAC applies the entql string predicate on the mac field.
func (f *FieldTypeFilter) WhereMAC(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldMAC))
}

// WhereStringArray applies the entql other predicate on the string_array field.
func (f *FieldTypeFilter) WhereStringArray(p entql.OtherP) {
	f.Where(p.Field(fieldtype.FieldStringArray))
}

// WherePassword applies the entql string predicate on the password field.
func (f *FieldTypeFilter) WherePassword(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldPassword))
}

// WhereStringScanner applies the entql string predicate on the string_scanner field.
func (f *FieldTypeFilter) WhereStringScanner(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldStringScanner))
}

// WhereDuration applies the entql int64 predicate on the duration field.
func (f *FieldTypeFilter) WhereDuration(p entql.Int64P) {
	f.Where(p.Field(fieldtype.FieldDuration))
}

// WhereDir applies the entql string predicate on the dir field.
func (f *FieldTypeFilter) WhereDir(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldDir))
}

// WhereNdir applies the entql string predicate on the ndir field.
func (f *FieldTypeFilter) WhereNdir(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldNdir))
}

// WhereStr applies the entql string predicate on the str field.
func (f *FieldTypeFilter) WhereStr(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldStr))
}

// WhereNullStr applies the entql string predicate on the null_str field.
func (f *FieldTypeFilter) WhereNullStr(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldNullStr))
}

// WhereLink applies the entql string predicate on the link field.
func (f *FieldTypeFilter) WhereLink(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldLink))
}

// WhereNullLink applies the entql string predicate on the null_link field.
func (f *FieldTypeFilter) WhereNullLink(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldNullLink))
}

// WhereActive applies the entql bool predicate on the active field.
func (f *FieldTypeFilter) WhereActive(p entql.BoolP) {
	f.Where(p.Field(fieldtype.FieldActive))
}

// WhereNullActive applies the entql bool predicate on the null_active field.
func (f *FieldTypeFilter) WhereNullActive(p entql.BoolP) {
	f.Where(p.Field(fieldtype.FieldNullActive))
}

// WhereDeleted applies the entql bool predicate on the deleted field.
func (f *FieldTypeFilter) WhereDeleted(p entql.BoolP) {
	f.Where(p.Field(fieldtype.FieldDeleted))
}

// WhereDeletedAt applies the entql time.Time predicate on the deleted_at field.
func (f *FieldTypeFilter) WhereDeletedAt(p entql.TimeP) {
	f.Where(p.Field(fieldtype.FieldDeletedAt))
}

// WhereRawData applies the entql []byte predicate on the raw_data field.
func (f *FieldTypeFilter) WhereRawData(p entql.BytesP) {
	f.Where(p.Field(fieldtype.FieldRawData))
}

// WhereSensitive applies the entql []byte predicate on the sensitive field.
func (f *FieldTypeFilter) WhereSensitive(p entql.BytesP) {
	f.Where(p.Field(fieldtype.FieldSensitive))
}

// WhereIP applies the entql []byte predicate on the ip field.
func (f *FieldTypeFilter) WhereIP(p entql.BytesP) {
	f.Where(p.Field(fieldtype.FieldIP))
}

// WhereNullInt64 applies the entql int predicate on the null_int64 field.
func (f *FieldTypeFilter) WhereNullInt64(p entql.IntP) {
	f.Where(p.Field(fieldtype.FieldNullInt64))
}

// WhereSchemaInt applies the entql int predicate on the schema_int field.
func (f *FieldTypeFilter) WhereSchemaInt(p entql.IntP) {
	f.Where(p.Field(fieldtype.FieldSchemaInt))
}

// WhereSchemaInt8 applies the entql int8 predicate on the schema_int8 field.
func (f *FieldTypeFilter) WhereSchemaInt8(p entql.Int8P) {
	f.Where(p.Field(fieldtype.FieldSchemaInt8))
}

// WhereSchemaInt64 applies the entql int64 predicate on the schema_int64 field.
func (f *FieldTypeFilter) WhereSchemaInt64(p entql.Int64P) {
	f.Where(p.Field(fieldtype.FieldSchemaInt64))
}

// WhereSchemaFloat applies the entql float64 predicate on the schema_float field.
func (f *FieldTypeFilter) WhereSchemaFloat(p entql.Float64P) {
	f.Where(p.Field(fieldtype.FieldSchemaFloat))
}

// WhereSchemaFloat32 applies the entql float32 predicate on the schema_float32 field.
func (f *FieldTypeFilter) WhereSchemaFloat32(p entql.Float32P) {
	f.Where(p.Field(fieldtype.FieldSchemaFloat32))
}

// WhereNullFloat applies the entql float64 predicate on the null_float field.
func (f *FieldTypeFilter) WhereNullFloat(p entql.Float64P) {
	f.Where(p.Field(fieldtype.FieldNullFloat))
}

// WhereRole applies the entql string predicate on the role field.
func (f *FieldTypeFilter) WhereRole(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldRole))
}

// WherePriority applies the entql string predicate on the priority field.
func (f *FieldTypeFilter) WherePriority(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldPriority))
}

// WhereOptionalUUID applies the entql [16]byte predicate on the optional_uuid field.
func (f *FieldTypeFilter) WhereOptionalUUID(p entql.ValueP) {
	f.Where(p.Field(fieldtype.FieldOptionalUUID))
}

// WhereNillableUUID applies the entql [16]byte predicate on the nillable_uuid field.
func (f *FieldTypeFilter) WhereNillableUUID(p entql.ValueP) {
	f.Where(p.Field(fieldtype.FieldNillableUUID))
}

// WhereStrings applies the entql json.RawMessage predicate on the strings field.
func (f *FieldTypeFilter) WhereStrings(p entql.BytesP) {
	f.Where(p.Field(fieldtype.FieldStrings))
}

// WherePair applies the entql []byte predicate on the pair field.
func (f *FieldTypeFilter) WherePair(p entql.BytesP) {
	f.Where(p.Field(fieldtype.FieldPair))
}

// WhereNilPair applies the entql []byte predicate on the nil_pair field.
func (f *FieldTypeFilter) WhereNilPair(p entql.BytesP) {
	f.Where(p.Field(fieldtype.FieldNilPair))
}

// WhereVstring applies the entql string predicate on the vstring field.
func (f *FieldTypeFilter) WhereVstring(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldVstring))
}

// WhereTriple applies the entql string predicate on the triple field.
func (f *FieldTypeFilter) WhereTriple(p entql.StringP) {
	f.Where(p.Field(fieldtype.FieldTriple))
}

// WhereBigInt applies the entql int predicate on the big_int field.
func (f *FieldTypeFilter) WhereBigInt(p entql.IntP) {
	f.Where(p.Field(fieldtype.FieldBigInt))
}

// WherePasswordOther applies the entql other predicate on the password_other field.
func (f *FieldTypeFilter) WherePasswordOther(p entql.OtherP) {
	f.Where(p.Field(fieldtype.FieldPasswordOther))
}

// addPredicate implements the predicateAdder interface.
func (fq *FileQuery) addPredicate(pred func(s *sql.Selector)) {
	fq.predicates = append(fq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the FileQuery builder.
func (fq *FileQuery) Filter() *FileFilter {
	return &FileFilter{config: fq.config, predicateAdder: fq}
}

// addPredicate implements the predicateAdder interface.
func (m *FileMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the FileMutation builder.
func (m *FileMutation) Filter() *FileFilter {
	return &FileFilter{config: m.config, predicateAdder: m}
}

// FileFilter provides a generic filtering capability at runtime for FileQuery.
type FileFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *FileFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[3].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *FileFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(file.FieldID))
}

// WhereSize applies the entql int predicate on the size field.
func (f *FileFilter) WhereSize(p entql.IntP) {
	f.Where(p.Field(file.FieldSize))
}

// WhereName applies the entql string predicate on the name field.
func (f *FileFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(file.FieldName))
}

// WhereUser applies the entql string predicate on the user field.
func (f *FileFilter) WhereUser(p entql.StringP) {
	f.Where(p.Field(file.FieldUser))
}

// WhereGroup applies the entql string predicate on the group field.
func (f *FileFilter) WhereGroup(p entql.StringP) {
	f.Where(p.Field(file.FieldGroup))
}

// WhereOp applies the entql bool predicate on the op field.
func (f *FileFilter) WhereOp(p entql.BoolP) {
	f.Where(p.Field(file.FieldOp))
}

// WhereFieldID applies the entql int predicate on the field_id field.
func (f *FileFilter) WhereFieldID(p entql.IntP) {
	f.Where(p.Field(file.FieldFieldID))
}

// WhereHasOwner applies a predicate to check if query has an edge owner.
func (f *FileFilter) WhereHasOwner() {
	f.Where(entql.HasEdge("owner"))
}

// WhereHasOwnerWith applies a predicate to check if query has an edge owner with a given conditions (other predicates).
func (f *FileFilter) WhereHasOwnerWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("owner", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasType applies a predicate to check if query has an edge type.
func (f *FileFilter) WhereHasType() {
	f.Where(entql.HasEdge("type"))
}

// WhereHasTypeWith applies a predicate to check if query has an edge type with a given conditions (other predicates).
func (f *FileFilter) WhereHasTypeWith(preds ...predicate.FileType) {
	f.Where(entql.HasEdgeWith("type", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasField applies a predicate to check if query has an edge field.
func (f *FileFilter) WhereHasField() {
	f.Where(entql.HasEdge("field"))
}

// WhereHasFieldWith applies a predicate to check if query has an edge field with a given conditions (other predicates).
func (f *FileFilter) WhereHasFieldWith(preds ...predicate.FieldType) {
	f.Where(entql.HasEdgeWith("field", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (ftq *FileTypeQuery) addPredicate(pred func(s *sql.Selector)) {
	ftq.predicates = append(ftq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the FileTypeQuery builder.
func (ftq *FileTypeQuery) Filter() *FileTypeFilter {
	return &FileTypeFilter{config: ftq.config, predicateAdder: ftq}
}

// addPredicate implements the predicateAdder interface.
func (m *FileTypeMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the FileTypeMutation builder.
func (m *FileTypeMutation) Filter() *FileTypeFilter {
	return &FileTypeFilter{config: m.config, predicateAdder: m}
}

// FileTypeFilter provides a generic filtering capability at runtime for FileTypeQuery.
type FileTypeFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *FileTypeFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[4].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *FileTypeFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(filetype.FieldID))
}

// WhereName applies the entql string predicate on the name field.
func (f *FileTypeFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(filetype.FieldName))
}

// WhereType applies the entql string predicate on the type field.
func (f *FileTypeFilter) WhereType(p entql.StringP) {
	f.Where(p.Field(filetype.FieldType))
}

// WhereState applies the entql string predicate on the state field.
func (f *FileTypeFilter) WhereState(p entql.StringP) {
	f.Where(p.Field(filetype.FieldState))
}

// WhereHasFiles applies a predicate to check if query has an edge files.
func (f *FileTypeFilter) WhereHasFiles() {
	f.Where(entql.HasEdge("files"))
}

// WhereHasFilesWith applies a predicate to check if query has an edge files with a given conditions (other predicates).
func (f *FileTypeFilter) WhereHasFilesWith(preds ...predicate.File) {
	f.Where(entql.HasEdgeWith("files", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (gq *GoodsQuery) addPredicate(pred func(s *sql.Selector)) {
	gq.predicates = append(gq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the GoodsQuery builder.
func (gq *GoodsQuery) Filter() *GoodsFilter {
	return &GoodsFilter{config: gq.config, predicateAdder: gq}
}

// addPredicate implements the predicateAdder interface.
func (m *GoodsMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the GoodsMutation builder.
func (m *GoodsMutation) Filter() *GoodsFilter {
	return &GoodsFilter{config: m.config, predicateAdder: m}
}

// GoodsFilter provides a generic filtering capability at runtime for GoodsQuery.
type GoodsFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *GoodsFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[5].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *GoodsFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(goods.FieldID))
}

// addPredicate implements the predicateAdder interface.
func (gq *GroupQuery) addPredicate(pred func(s *sql.Selector)) {
	gq.predicates = append(gq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the GroupQuery builder.
func (gq *GroupQuery) Filter() *GroupFilter {
	return &GroupFilter{config: gq.config, predicateAdder: gq}
}

// addPredicate implements the predicateAdder interface.
func (m *GroupMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the GroupMutation builder.
func (m *GroupMutation) Filter() *GroupFilter {
	return &GroupFilter{config: m.config, predicateAdder: m}
}

// GroupFilter provides a generic filtering capability at runtime for GroupQuery.
type GroupFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *GroupFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[6].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *GroupFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(group.FieldID))
}

// WhereActive applies the entql bool predicate on the active field.
func (f *GroupFilter) WhereActive(p entql.BoolP) {
	f.Where(p.Field(group.FieldActive))
}

// WhereExpire applies the entql time.Time predicate on the expire field.
func (f *GroupFilter) WhereExpire(p entql.TimeP) {
	f.Where(p.Field(group.FieldExpire))
}

// WhereType applies the entql string predicate on the type field.
func (f *GroupFilter) WhereType(p entql.StringP) {
	f.Where(p.Field(group.FieldType))
}

// WhereMaxUsers applies the entql int predicate on the max_users field.
func (f *GroupFilter) WhereMaxUsers(p entql.IntP) {
	f.Where(p.Field(group.FieldMaxUsers))
}

// WhereName applies the entql string predicate on the name field.
func (f *GroupFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(group.FieldName))
}

// WhereHasFiles applies a predicate to check if query has an edge files.
func (f *GroupFilter) WhereHasFiles() {
	f.Where(entql.HasEdge("files"))
}

// WhereHasFilesWith applies a predicate to check if query has an edge files with a given conditions (other predicates).
func (f *GroupFilter) WhereHasFilesWith(preds ...predicate.File) {
	f.Where(entql.HasEdgeWith("files", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasBlocked applies a predicate to check if query has an edge blocked.
func (f *GroupFilter) WhereHasBlocked() {
	f.Where(entql.HasEdge("blocked"))
}

// WhereHasBlockedWith applies a predicate to check if query has an edge blocked with a given conditions (other predicates).
func (f *GroupFilter) WhereHasBlockedWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("blocked", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasUsers applies a predicate to check if query has an edge users.
func (f *GroupFilter) WhereHasUsers() {
	f.Where(entql.HasEdge("users"))
}

// WhereHasUsersWith applies a predicate to check if query has an edge users with a given conditions (other predicates).
func (f *GroupFilter) WhereHasUsersWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasInfo applies a predicate to check if query has an edge info.
func (f *GroupFilter) WhereHasInfo() {
	f.Where(entql.HasEdge("info"))
}

// WhereHasInfoWith applies a predicate to check if query has an edge info with a given conditions (other predicates).
func (f *GroupFilter) WhereHasInfoWith(preds ...predicate.GroupInfo) {
	f.Where(entql.HasEdgeWith("info", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (giq *GroupInfoQuery) addPredicate(pred func(s *sql.Selector)) {
	giq.predicates = append(giq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the GroupInfoQuery builder.
func (giq *GroupInfoQuery) Filter() *GroupInfoFilter {
	return &GroupInfoFilter{config: giq.config, predicateAdder: giq}
}

// addPredicate implements the predicateAdder interface.
func (m *GroupInfoMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the GroupInfoMutation builder.
func (m *GroupInfoMutation) Filter() *GroupInfoFilter {
	return &GroupInfoFilter{config: m.config, predicateAdder: m}
}

// GroupInfoFilter provides a generic filtering capability at runtime for GroupInfoQuery.
type GroupInfoFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *GroupInfoFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[7].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *GroupInfoFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(groupinfo.FieldID))
}

// WhereDesc applies the entql string predicate on the desc field.
func (f *GroupInfoFilter) WhereDesc(p entql.StringP) {
	f.Where(p.Field(groupinfo.FieldDesc))
}

// WhereMaxUsers applies the entql int predicate on the max_users field.
func (f *GroupInfoFilter) WhereMaxUsers(p entql.IntP) {
	f.Where(p.Field(groupinfo.FieldMaxUsers))
}

// WhereHasGroups applies a predicate to check if query has an edge groups.
func (f *GroupInfoFilter) WhereHasGroups() {
	f.Where(entql.HasEdge("groups"))
}

// WhereHasGroupsWith applies a predicate to check if query has an edge groups with a given conditions (other predicates).
func (f *GroupInfoFilter) WhereHasGroupsWith(preds ...predicate.Group) {
	f.Where(entql.HasEdgeWith("groups", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (iq *ItemQuery) addPredicate(pred func(s *sql.Selector)) {
	iq.predicates = append(iq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the ItemQuery builder.
func (iq *ItemQuery) Filter() *ItemFilter {
	return &ItemFilter{config: iq.config, predicateAdder: iq}
}

// addPredicate implements the predicateAdder interface.
func (m *ItemMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the ItemMutation builder.
func (m *ItemMutation) Filter() *ItemFilter {
	return &ItemFilter{config: m.config, predicateAdder: m}
}

// ItemFilter provides a generic filtering capability at runtime for ItemQuery.
type ItemFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *ItemFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[8].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql string predicate on the id field.
func (f *ItemFilter) WhereID(p entql.StringP) {
	f.Where(p.Field(item.FieldID))
}

// WhereText applies the entql string predicate on the text field.
func (f *ItemFilter) WhereText(p entql.StringP) {
	f.Where(p.Field(item.FieldText))
}

// addPredicate implements the predicateAdder interface.
func (lq *LicenseQuery) addPredicate(pred func(s *sql.Selector)) {
	lq.predicates = append(lq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the LicenseQuery builder.
func (lq *LicenseQuery) Filter() *LicenseFilter {
	return &LicenseFilter{config: lq.config, predicateAdder: lq}
}

// addPredicate implements the predicateAdder interface.
func (m *LicenseMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the LicenseMutation builder.
func (m *LicenseMutation) Filter() *LicenseFilter {
	return &LicenseFilter{config: m.config, predicateAdder: m}
}

// LicenseFilter provides a generic filtering capability at runtime for LicenseQuery.
type LicenseFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *LicenseFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[9].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *LicenseFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(license.FieldID))
}

// WhereCreateTime applies the entql time.Time predicate on the create_time field.
func (f *LicenseFilter) WhereCreateTime(p entql.TimeP) {
	f.Where(p.Field(license.FieldCreateTime))
}

// WhereUpdateTime applies the entql time.Time predicate on the update_time field.
func (f *LicenseFilter) WhereUpdateTime(p entql.TimeP) {
	f.Where(p.Field(license.FieldUpdateTime))
}

// addPredicate implements the predicateAdder interface.
func (nq *NodeQuery) addPredicate(pred func(s *sql.Selector)) {
	nq.predicates = append(nq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the NodeQuery builder.
func (nq *NodeQuery) Filter() *NodeFilter {
	return &NodeFilter{config: nq.config, predicateAdder: nq}
}

// addPredicate implements the predicateAdder interface.
func (m *NodeMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the NodeMutation builder.
func (m *NodeMutation) Filter() *NodeFilter {
	return &NodeFilter{config: m.config, predicateAdder: m}
}

// NodeFilter provides a generic filtering capability at runtime for NodeQuery.
type NodeFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *NodeFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[10].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *NodeFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(node.FieldID))
}

// WhereValue applies the entql int predicate on the value field.
func (f *NodeFilter) WhereValue(p entql.IntP) {
	f.Where(p.Field(node.FieldValue))
}

// WhereHasPrev applies a predicate to check if query has an edge prev.
func (f *NodeFilter) WhereHasPrev() {
	f.Where(entql.HasEdge("prev"))
}

// WhereHasPrevWith applies a predicate to check if query has an edge prev with a given conditions (other predicates).
func (f *NodeFilter) WhereHasPrevWith(preds ...predicate.Node) {
	f.Where(entql.HasEdgeWith("prev", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasNext applies a predicate to check if query has an edge next.
func (f *NodeFilter) WhereHasNext() {
	f.Where(entql.HasEdge("next"))
}

// WhereHasNextWith applies a predicate to check if query has an edge next with a given conditions (other predicates).
func (f *NodeFilter) WhereHasNextWith(preds ...predicate.Node) {
	f.Where(entql.HasEdgeWith("next", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (pq *PetQuery) addPredicate(pred func(s *sql.Selector)) {
	pq.predicates = append(pq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the PetQuery builder.
func (pq *PetQuery) Filter() *PetFilter {
	return &PetFilter{config: pq.config, predicateAdder: pq}
}

// addPredicate implements the predicateAdder interface.
func (m *PetMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the PetMutation builder.
func (m *PetMutation) Filter() *PetFilter {
	return &PetFilter{config: m.config, predicateAdder: m}
}

// PetFilter provides a generic filtering capability at runtime for PetQuery.
type PetFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *PetFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[11].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *PetFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(pet.FieldID))
}

// WhereAge applies the entql float64 predicate on the age field.
func (f *PetFilter) WhereAge(p entql.Float64P) {
	f.Where(p.Field(pet.FieldAge))
}

// WhereName applies the entql string predicate on the name field.
func (f *PetFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(pet.FieldName))
}

// WhereUUID applies the entql [16]byte predicate on the uuid field.
func (f *PetFilter) WhereUUID(p entql.ValueP) {
	f.Where(p.Field(pet.FieldUUID))
}

// WhereNickname applies the entql string predicate on the nickname field.
func (f *PetFilter) WhereNickname(p entql.StringP) {
	f.Where(p.Field(pet.FieldNickname))
}

// WhereTrained applies the entql bool predicate on the trained field.
func (f *PetFilter) WhereTrained(p entql.BoolP) {
	f.Where(p.Field(pet.FieldTrained))
}

// WhereHasTeam applies a predicate to check if query has an edge team.
func (f *PetFilter) WhereHasTeam() {
	f.Where(entql.HasEdge("team"))
}

// WhereHasTeamWith applies a predicate to check if query has an edge team with a given conditions (other predicates).
func (f *PetFilter) WhereHasTeamWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("team", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasOwner applies a predicate to check if query has an edge owner.
func (f *PetFilter) WhereHasOwner() {
	f.Where(entql.HasEdge("owner"))
}

// WhereHasOwnerWith applies a predicate to check if query has an edge owner with a given conditions (other predicates).
func (f *PetFilter) WhereHasOwnerWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("owner", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (sq *SpecQuery) addPredicate(pred func(s *sql.Selector)) {
	sq.predicates = append(sq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the SpecQuery builder.
func (sq *SpecQuery) Filter() *SpecFilter {
	return &SpecFilter{config: sq.config, predicateAdder: sq}
}

// addPredicate implements the predicateAdder interface.
func (m *SpecMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the SpecMutation builder.
func (m *SpecMutation) Filter() *SpecFilter {
	return &SpecFilter{config: m.config, predicateAdder: m}
}

// SpecFilter provides a generic filtering capability at runtime for SpecQuery.
type SpecFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *SpecFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[12].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *SpecFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(spec.FieldID))
}

// WhereHasCard applies a predicate to check if query has an edge card.
func (f *SpecFilter) WhereHasCard() {
	f.Where(entql.HasEdge("card"))
}

// WhereHasCardWith applies a predicate to check if query has an edge card with a given conditions (other predicates).
func (f *SpecFilter) WhereHasCardWith(preds ...predicate.Card) {
	f.Where(entql.HasEdgeWith("card", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (tq *TaskQuery) addPredicate(pred func(s *sql.Selector)) {
	tq.predicates = append(tq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TaskQuery builder.
func (tq *TaskQuery) Filter() *TaskFilter {
	return &TaskFilter{config: tq.config, predicateAdder: tq}
}

// addPredicate implements the predicateAdder interface.
func (m *TaskMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TaskMutation builder.
func (m *TaskMutation) Filter() *TaskFilter {
	return &TaskFilter{config: m.config, predicateAdder: m}
}

// TaskFilter provides a generic filtering capability at runtime for TaskQuery.
type TaskFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *TaskFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[13].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *TaskFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(enttask.FieldID))
}

// WherePriority applies the entql int predicate on the priority field.
func (f *TaskFilter) WherePriority(p entql.IntP) {
	f.Where(p.Field(enttask.FieldPriority))
}

// WherePriorities applies the entql json.RawMessage predicate on the priorities field.
func (f *TaskFilter) WherePriorities(p entql.BytesP) {
	f.Where(p.Field(enttask.FieldPriorities))
}

// WhereCreatedAt applies the entql time.Time predicate on the created_at field.
func (f *TaskFilter) WhereCreatedAt(p entql.TimeP) {
	f.Where(p.Field(enttask.FieldCreatedAt))
}

// addPredicate implements the predicateAdder interface.
func (uq *UserQuery) addPredicate(pred func(s *sql.Selector)) {
	uq.predicates = append(uq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the UserQuery builder.
func (uq *UserQuery) Filter() *UserFilter {
	return &UserFilter{config: uq.config, predicateAdder: uq}
}

// addPredicate implements the predicateAdder interface.
func (m *UserMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the UserMutation builder.
func (m *UserMutation) Filter() *UserFilter {
	return &UserFilter{config: m.config, predicateAdder: m}
}

// UserFilter provides a generic filtering capability at runtime for UserQuery.
type UserFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *UserFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[14].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *UserFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(user.FieldID))
}

// WhereOptionalInt applies the entql int predicate on the optional_int field.
func (f *UserFilter) WhereOptionalInt(p entql.IntP) {
	f.Where(p.Field(user.FieldOptionalInt))
}

// WhereAge applies the entql int predicate on the age field.
func (f *UserFilter) WhereAge(p entql.IntP) {
	f.Where(p.Field(user.FieldAge))
}

// WhereName applies the entql string predicate on the name field.
func (f *UserFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(user.FieldName))
}

// WhereLast applies the entql string predicate on the last field.
func (f *UserFilter) WhereLast(p entql.StringP) {
	f.Where(p.Field(user.FieldLast))
}

// WhereNickname applies the entql string predicate on the nickname field.
func (f *UserFilter) WhereNickname(p entql.StringP) {
	f.Where(p.Field(user.FieldNickname))
}

// WhereAddress applies the entql string predicate on the address field.
func (f *UserFilter) WhereAddress(p entql.StringP) {
	f.Where(p.Field(user.FieldAddress))
}

// WherePhone applies the entql string predicate on the phone field.
func (f *UserFilter) WherePhone(p entql.StringP) {
	f.Where(p.Field(user.FieldPhone))
}

// WherePassword applies the entql string predicate on the password field.
func (f *UserFilter) WherePassword(p entql.StringP) {
	f.Where(p.Field(user.FieldPassword))
}

// WhereRole applies the entql string predicate on the role field.
func (f *UserFilter) WhereRole(p entql.StringP) {
	f.Where(p.Field(user.FieldRole))
}

// WhereEmployment applies the entql string predicate on the employment field.
func (f *UserFilter) WhereEmployment(p entql.StringP) {
	f.Where(p.Field(user.FieldEmployment))
}

// WhereSSOCert applies the entql string predicate on the SSOCert field.
func (f *UserFilter) WhereSSOCert(p entql.StringP) {
	f.Where(p.Field(user.FieldSSOCert))
}

// WhereHasCard applies a predicate to check if query has an edge card.
func (f *UserFilter) WhereHasCard() {
	f.Where(entql.HasEdge("card"))
}

// WhereHasCardWith applies a predicate to check if query has an edge card with a given conditions (other predicates).
func (f *UserFilter) WhereHasCardWith(preds ...predicate.Card) {
	f.Where(entql.HasEdgeWith("card", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasPets applies a predicate to check if query has an edge pets.
func (f *UserFilter) WhereHasPets() {
	f.Where(entql.HasEdge("pets"))
}

// WhereHasPetsWith applies a predicate to check if query has an edge pets with a given conditions (other predicates).
func (f *UserFilter) WhereHasPetsWith(preds ...predicate.Pet) {
	f.Where(entql.HasEdgeWith("pets", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFiles applies a predicate to check if query has an edge files.
func (f *UserFilter) WhereHasFiles() {
	f.Where(entql.HasEdge("files"))
}

// WhereHasFilesWith applies a predicate to check if query has an edge files with a given conditions (other predicates).
func (f *UserFilter) WhereHasFilesWith(preds ...predicate.File) {
	f.Where(entql.HasEdgeWith("files", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasGroups applies a predicate to check if query has an edge groups.
func (f *UserFilter) WhereHasGroups() {
	f.Where(entql.HasEdge("groups"))
}

// WhereHasGroupsWith applies a predicate to check if query has an edge groups with a given conditions (other predicates).
func (f *UserFilter) WhereHasGroupsWith(preds ...predicate.Group) {
	f.Where(entql.HasEdgeWith("groups", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFriends applies a predicate to check if query has an edge friends.
func (f *UserFilter) WhereHasFriends() {
	f.Where(entql.HasEdge("friends"))
}

// WhereHasFriendsWith applies a predicate to check if query has an edge friends with a given conditions (other predicates).
func (f *UserFilter) WhereHasFriendsWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("friends", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFollowers applies a predicate to check if query has an edge followers.
func (f *UserFilter) WhereHasFollowers() {
	f.Where(entql.HasEdge("followers"))
}

// WhereHasFollowersWith applies a predicate to check if query has an edge followers with a given conditions (other predicates).
func (f *UserFilter) WhereHasFollowersWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("followers", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFollowing applies a predicate to check if query has an edge following.
func (f *UserFilter) WhereHasFollowing() {
	f.Where(entql.HasEdge("following"))
}

// WhereHasFollowingWith applies a predicate to check if query has an edge following with a given conditions (other predicates).
func (f *UserFilter) WhereHasFollowingWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("following", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTeam applies a predicate to check if query has an edge team.
func (f *UserFilter) WhereHasTeam() {
	f.Where(entql.HasEdge("team"))
}

// WhereHasTeamWith applies a predicate to check if query has an edge team with a given conditions (other predicates).
func (f *UserFilter) WhereHasTeamWith(preds ...predicate.Pet) {
	f.Where(entql.HasEdgeWith("team", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasSpouse applies a predicate to check if query has an edge spouse.
func (f *UserFilter) WhereHasSpouse() {
	f.Where(entql.HasEdge("spouse"))
}

// WhereHasSpouseWith applies a predicate to check if query has an edge spouse with a given conditions (other predicates).
func (f *UserFilter) WhereHasSpouseWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("spouse", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasChildren applies a predicate to check if query has an edge children.
func (f *UserFilter) WhereHasChildren() {
	f.Where(entql.HasEdge("children"))
}

// WhereHasChildrenWith applies a predicate to check if query has an edge children with a given conditions (other predicates).
func (f *UserFilter) WhereHasChildrenWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("children", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasParent applies a predicate to check if query has an edge parent.
func (f *UserFilter) WhereHasParent() {
	f.Where(entql.HasEdge("parent"))
}

// WhereHasParentWith applies a predicate to check if query has an edge parent with a given conditions (other predicates).
func (f *UserFilter) WhereHasParentWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("parent", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}
