/*
   ub_hebrew2beta.h - tables for Hebrew Unicode to Beta Code conversion.

   Author: Paul Hardy, unifoundry <at> unifoundry.com

   Copyright (C) 2018, 2019, 2020 Paul Hardy

   LICENSE:

      This program is free software: you can redistribute it and/or modify
      it under the terms of the GNU General Public License as published by
      the Free Software Foundation, either version 2 of the License, or
      (at your option) any later version.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.
      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*
   uni05xx_hebrew_betacode holds Unicode to Hebrew Beta Code mappings
   for the Unicode range U+0590..U+05FF.
*/
char *uni05xx_hebrew_betacode [0x600 - 0x590] = {
   /* U+0590 */  "{\\u0590}",
   /* U+0591 */  "{\\u0591}",
   /* U+0592 */  "{\\u0592}",
   /* U+0593 */  "{\\u0593}",
   /* U+0594 */  "{\\u0594}",
   /* U+0595 */  "{\\u0595}",
   /* U+0596 */  "{\\u0596}",
   /* U+0597 */  "{\\u0597}",
   /* U+0598 */  "{\\u0598}",
   /* U+0599 */  "{\\u0599}",
   /* U+059A */  "{\\u059A}",
   /* U+059B */  "{\\u059B}",
   /* U+059C */  "{\\u059C}",
   /* U+059D */  "{\\u059D}",
   /* U+059E */  "{\\u059E}",
   /* U+059F */  "{\\u059F}",
   /* U+05A0 */  "{\\u05A0}",
   /* U+05A1 */  "{\\u05A1}",
   /* U+05A2 */  "{\\u05A2}",
   /* U+05A3 */  "{\\u05A3}",
   /* U+05A4 */  "{\\u05A4}",
   /* U+05A5 */  "{\\u05A5}",
   /* U+05A6 */  "{\\u05A6}",
   /* U+05A7 */  "{\\u05A7}",
   /* U+05A8 */  "{\\u05A8}",
   /* U+05A9 */  "{\\u05A9}",
   /* U+05AA */  "{\\u05AA}",
   /* U+05AB */  "{\\u05AB}",
   /* U+05AC */  "{\\u05AC}",
   /* U+05AD */  "{\\u05AD}",
   /* U+05AE */  "{\\u05AE}",
   /* U+05AF */  "{\\u05AF}",
   /* U+05B0 */  "{\\u05B0}",
   /* U+05B1 */  "{\\u05B1}",
   /* U+05B2 */  "{\\u05B2}",
   /* U+05B3 */  "{\\u05B3}",
   /* U+05B4 */  "{\\u05B4}",
   /* U+05B5 */  "{\\u05B5}",
   /* U+05B6 */  "{\\u05B6}",
   /* U+05B7 */  "{\\u05B7}",
   /* U+05B8 */  "{\\u05B8}",
   /* U+05B9 */  "{\\u05B9}",
   /* U+05BA */  "{\\u05BA}",
   /* U+05BB */  "{\\u05BB}",
   /* U+05BC */  "{\\u05BC}",
   /* U+05BD */  "{\\u05BD}",
   /* U+05BE */  "{\\u05BE}",
   /* U+05BF */  "{\\u05BF}",
   /* U+05C0 */  "{\\u05C0}",
   /* U+05C1 */  "{\\u05C1}",
   /* U+05C2 */  "{\\u05C2}",
   /* U+05C3 */  "{\\u05C3}",
   /* U+05C4 */  "{\\u05C4}",
   /* U+05C5 */  "{\\u05C5}",
   /* U+05C6 */  "{\\u05C6}",
   /* U+05C7 */  "{\\u05C7}",
   /* U+05C8 */  "{\\u05C8}",
   /* U+05C9 */  "{\\u05C9}",
   /* U+05CA */  "{\\u05CA}",
   /* U+05CB */  "{\\u05CB}",
   /* U+05CC */  "{\\u05CC}",
   /* U+05CD */  "{\\u05CD}",
   /* U+05CE */  "{\\u05CE}",
   /* U+05CF */  "{\\u05CF}",
   /* U+05D0 */  "A",
   /* U+05D1 */  "b",
   /* U+05D2 */  "g",
   /* U+05D3 */  "d",
   /* U+05D4 */  "h",
   /* U+05D5 */  "v",
   /* U+05D6 */  "z",
   /* U+05D7 */  "H",
   /* U+05D8 */  "Q",
   /* U+05D9 */  "y",
   /* U+05DA */  "k2",
   /* U+05DB */  "k1",
   /* U+05DC */  "l",
   /* U+05DD */  "m2",
   /* U+05DE */  "m1",
   /* U+05DF */  "n2",
   /* U+05E0 */  "n1",
   /* U+05E1 */  "S",
   /* U+05E2 */  "a",
   /* U+05E3 */  "p2",
   /* U+05E4 */  "p1",
   /* U+05E5 */  "T2",
   /* U+05E6 */  "T1",
   /* U+05E7 */  "q",
   /* U+05E8 */  "r",
   /* U+05E9 */  "s",
   /* U+05EA */  "t",
   /* U+05EB */  "{\\u05EB}",
   /* U+05EC */  "{\\u05EC}",
   /* U+05ED */  "{\\u05ED}",
   /* U+05EE */  "{\\u05EE}",
   /* U+05EF */  "{\\u05EF}",
   /* U+05F0 */  "{\\u05F0}",
   /* U+05F1 */  "{\\u05F1}",
   /* U+05F2 */  "{\\u05F2}",
   /* U+05F3 */  "{\\u05F3}",
   /* U+05F4 */  "{\\u05F4}",
   /* U+05F5 */  "{\\u05F5}",
   /* U+05F6 */  "{\\u05F6}",
   /* U+05F7 */  "{\\u05F7}",
   /* U+05F8 */  "{\\u05F8}",
   /* U+05F9 */  "{\\u05F9}",
   /* U+05FA */  "{\\u05FA}",
   /* U+05FB */  "{\\u05FB}",
   /* U+05FC */  "{\\u05FC}",
   /* U+05FD */  "{\\u05FD}",
   /* U+05FE */  "{\\u05FE}",
   /* U+05FF */  "{\\u05FF}"
};

