% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertNumbering.R
\name{convertNumbering}
\alias{convertNumbering}
\title{convertNumbering: IMGT-Kabat number conversion}
\usage{
convertNumbering(locus, from, to, calls)
}
\arguments{
\item{locus}{string indicating heavy ("IGH") or light chains ("IGK" or "IGL)}

\item{from}{string indicating numbering system to convert to ("IMGT" or "KABAT")}

\item{to}{string indicating original numbering system ("IMGT" or "KABAT")}

\item{calls}{vector of strings representing original numbering}
}
\value{
A vector of string indicating the corresponding numbering
}
\description{
Converts numbering systems like Kabat or IMGT using these conventions:
http://www.imgt.org/IMGTScientificChart/Numbering/IMGT-Kabat_part1.html
with Gaps (unoccupied positions) shown by "G" and Asterisks (*) shown by "S": 
arbitrary mappings (multiple possible "to" values) represented with "NA"
}
\examples{
convertNumbering("IGH", "IMGT", "KABAT", c("51", "23", "110"))
convertNumbering("IGH", "KABAT", "IMGT", c("51", "23", "G"))
}
