% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{name.formulas}
\alias{name.formulas}
\title{Name formula list elements}
\usage{
name.formulas(formulas, prefix = "F")
}
\arguments{
\item{formulas}{A named list of formula's, or expressions that
can be converted into formula's by \code{as.formula}. List elements
correspond to blocks. The block to which the list element applies is
identified by its name, so list names must correspond to block names.
The \code{formulas} argument is an alternative to the
\code{predictorMatrix} argument that allows for more flexibility in
specifying imputation models, e.g., for specifying interaction terms.}

\item{prefix}{A character vector of length 1 with the prefix to
be using for naming any unnamed blocks with two or more variables.}
}
\value{
Named list of formulas
}
\description{
This helper function names any unnamed elements in the \code{formula}
list. This is a convenience function.
}
\details{
This function will name any unnamed list elements specified in
the optional argument \code{formula}. Unnamed formula's
consisting with just one response variable will be named
after this variable. Unnamed formula's containing more
than one variable will be named by the \code{prefix}
argument, padded by an integer sequence stating at 1.
}
\examples{
# fully conditionally specified main effects model
form1 <- list(
  bmi ~ age + chl + hyp,
  hyp ~ age + bmi + chl,
  chl ~ age + bmi + hyp
)
form1 <- name.formulas(form1)
imp1 <- mice(nhanes, formulas = form1, print = FALSE, m = 1, seed = 12199)

# same model using dot notation
form2 <- list(bmi ~ ., hyp ~ ., chl ~ .)
form2 <- name.formulas(form2)
imp2 <- mice(nhanes, formulas = form2, print = FALSE, m = 1, seed = 12199)
identical(complete(imp1), complete(imp2))

# same model using repeated multivariate imputation
form3 <- name.blocks(list(all = bmi + hyp + chl ~ .))
imp3 <- mice(nhanes, formulas = form3, print = FALSE, m = 1, seed = 12199)
cmp3 <- complete(imp3)
identical(complete(imp1), complete(imp3))

# same model using predictorMatrix
imp4 <- mice(nhanes, print = FALSE, m = 1, seed = 12199, auxiliary = TRUE)
identical(complete(imp1), complete(imp4))

# different model: multivariate imputation for chl and bmi
form5 <- list(chl + bmi ~ ., hyp ~ bmi + age)
form5 <- name.formulas(form5)
imp5 <- mice(nhanes, formulas = form5, print = FALSE, m = 1, seed = 71712)
}
\seealso{
\code{\link{mice}}
}
