% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotationS2.R
\name{rotationS2}
\alias{rotationS2}
\title{Compute a Rotation on the 2-dimensional Sphere}
\usage{
rotationS2(x, y)
}
\arguments{
\item{x}{a length-\eqn{3} vector. If \eqn{\|x\|\neq 1}, normalization is applied.}

\item{y}{a length-\eqn{3} vector. If \eqn{\|y\|\neq 1}, normalization is applied.}
}
\value{
a \eqn{(3\times 3)} rotation matrix.
}
\description{
A vector of unit norm is an element on the hypersphere. When two unit-norm 
vectors \eqn{x} and \eqn{y} in 3-dimensional space are given, this function 
computes a rotation matrix \eqn{Q} on the 2-dimensional sphere such that
\deqn{y=Qx}.
}
\examples{
\donttest{
## generate two data points
#  one randomly and another on the north pole
x = stats::rnorm(3)
x = x/sqrt(sum(x^2))
y = c(0,0,1)

## compute the rotation
Q = rotationS2(x,y)

## compare 
Qx = as.vector(Q\%*\%x)

## print
printmat = rbind(Qx, y)
rownames(printmat) = c("rotated:", "target:")
print(printmat)
}

}
