% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HnswParam.R
\docType{class}
\name{HnswParam}
\alias{HnswParam}
\alias{HnswParam-class}
\alias{show,HnswParam-method}
\alias{HnswIndex}
\alias{HnswIndex-class}
\alias{defineBuilder,HnswParam-method}
\title{The HnswParam class}
\usage{
HnswParam(
  nlinks = 16,
  ef.construction = 200,
  ef.search = 10,
  distance = c("Euclidean", "Manhattan", "Cosine")
)

\S4method{defineBuilder}{HnswParam}(BNPARAM)
}
\arguments{
\item{nlinks}{Integer scalar, number of bi-directional links per element for index generation.}

\item{ef.construction}{Integer scalar, size of the dynamic list for index generation.}

\item{ef.search}{Integer scalar, size of the dynamic list for neighbor searching.}

\item{distance}{String specifying the distance metric to use.
Cosine distances are implemented as Euclidean distances on L2-normalized coordinates.}

\item{BNPARAM}{A HsnwParam instance.}
}
\value{
The \code{HnswParam} constructor returns an instance of the HnswParam class.

The \code{\link{defineBuilder}} method returns an external pointer that can be used in \code{\link{buildIndex}} to construct a HNSW index.
}
\description{
A class to hold parameters for the HNSW algorithm for approximate nearest neighbor identification.
}
\details{
In the HNSW algorithm (Malkov and Yashunin, 2016), each point is a node in a \dQuote{nagivable small world} graph.
The nearest neighbor search proceeds by starting at a node and walking through the graph to obtain closer neighbors to a given query point.
Nagivable small world graphs are used to maintain connectivity across the data set by creating links between distant points.
This speeds up the search by ensuring that the algorithm does not need to take many small steps to move from one cluster to another.
The HNSW algorithm extends this idea by using a hierarchy of such graphs containing links of different lengths, 
which avoids wasting time on small steps in the early stages of the search where the current node position is far from the query.

Larger values of \code{nlinks} improve accuracy at the expense of speed and memory usage.
Larger values of \code{ef.construction} improve index quality at the expense of indexing time.
The value of \code{ef.search} controls the accuracy of the neighbor search at run time,
where larger values improve accuracy at the expense of a slower search.

Technically, the index construction algorithm is stochastic but, for various logistical reasons, the seed is hard-coded into the C++ code.
This means that the results of the HNSW neighbor searches will be fully deterministic for the same inputs, even though the theory provides no such guarantees.
}
\examples{
(out <- HnswParam())
out[['nlinks']]

out[['nlinks']] <- 20L
out

}
\seealso{
\linkS4class{BiocNeighborParam}, for the parent class and its available methods.

\url{https://github.com/nmslib/hnswlib}, for details on the underlying algorithm.
}
\author{
Aaron Lun
}
