# Table of Contents

- [Read Me](../README.md)
- [Introduction](introduction/README.md)
  - [Motivation](introduction/Motivation.md)
  - [Core Concepts](introduction/CoreConcepts.md)
  - [Three Principles](introduction/ThreePrinciples.md)
  - [Prior Art](introduction/PriorArt.md)
  - [Learning Resources](introduction/LearningResources.md)
  - [Ecosystem](introduction/Ecosystem.md)
  - [Examples](introduction/Examples.md)
- [Basics](basics/README.md)
  - [Actions](basics/Actions.md)
  - [Reducers](basics/Reducers.md)
  - [Store](basics/Store.md)
  - [Data Flow](basics/DataFlow.md)
  - [Usage with React](basics/UsageWithReact.md)
  - [Example: Todo List](basics/ExampleTodoList.md)
- [Advanced](advanced/README.md)
  - [Async Actions](advanced/AsyncActions.md)
  - [Async Flow](advanced/AsyncFlow.md)
  - [Middleware](advanced/Middleware.md)
  - [Usage with React Router](advanced/UsageWithReactRouter.md)
  - [Example: Reddit API](advanced/ExampleRedditAPI.md)
  - [Next Steps](advanced/NextSteps.md)
- [Recipes](recipes/README.md)
  - [Configuring Your Store](recipes/ConfiguringYourStore.md)
  - [Migrating to Redux](recipes/MigratingToRedux.md)
  - [Using Object Spread Operator](recipes/UsingObjectSpreadOperator.md)
  - [Reducing Boilerplate](recipes/ReducingBoilerplate.md)
  - [Server Rendering](recipes/ServerRendering.md)
  - [Writing Tests](recipes/WritingTests.md)
  - [Computing Derived Data](recipes/ComputingDerivedData.md)
  - [Implementing Undo History](recipes/ImplementingUndoHistory.md)
  - [Isolating Subapps](recipes/IsolatingSubapps.md)
  - [Structuring Reducers](recipes/structuring-reducers/StructuringReducers.md)
    - [Prerequisite Concepts](recipes/structuring-reducers/PrerequisiteConcepts.md)
    - [Basic Reducer Structure](recipes/structuring-reducers/BasicReducerStructure.md)
    - [Splitting Reducer Logic](recipes/structuring-reducers/SplittingReducerLogic.md)
    - [Refactoring Reducers Example](recipes/structuring-reducers/RefactoringReducersExample.md)
    - [Using `combineReducers`](recipes/structuring-reducers/UsingCombineReducers.md)
    - [Beyond `combineReducers`](recipes/structuring-reducers/BeyondCombineReducers.md)
    - [Normalizing State Shape](recipes/structuring-reducers/NormalizingStateShape.md)
    - [Updating Normalized Data](recipes/structuring-reducers/UpdatingNormalizedData.md)
    - [Reusing Reducer Logic](recipes/structuring-reducers/ReusingReducerLogic.md)
    - [Immutable Update Patterns](recipes/structuring-reducers/ImmutableUpdatePatterns.md)
    - [Initializing State](recipes/structuring-reducers/InitializingState.md)
  - [Using Immutable.JS with Redux](recipes/UsingImmutableJS.md)
- [FAQ](FAQ.md)
  - [General](faq/General.md)
  - [Reducers](faq/Reducers.md)
  - [Organizing State](faq/OrganizingState.md)
  - [Store Setup](faq/StoreSetup.md)
  - [Actions](faq/Actions.md)
  - [Immutable Data](faq/ImmutableData.md)
  - [Code Structure](faq/CodeStructure.md)
  - [Performance](faq/Performance.md)
  - [Design Decisions](faq/DesignDecisions.md)
  - [React Redux](faq/ReactRedux.md)
  - [Miscellaneous](faq/Miscellaneous.md)
- [Troubleshooting](Troubleshooting.md)
- [Glossary](Glossary.md)
- [API Reference](api/README.md)
  - [createStore](api/createStore.md)
  - [Store](api/Store.md)
  - [combineReducers](api/combineReducers.md)
  - [applyMiddleware](api/applyMiddleware.md)
  - [bindActionCreators](api/bindActionCreators.md)
  - [compose](api/compose.md)
- [Change Log](../CHANGELOG.md)
- [Patrons](../PATRONS.md)
- [Feedback](Feedback.md)
