///////////////////////////////////////////////////////////////////////////////
//                                                                             
// JTOpen (IBM Toolbox for Java - OSS version)                              
//                                                                             
// Filename: ResourceMRI.java
//                                                                             
// The source code contained herein is licensed under the IBM Public License   
// Version 1.0, which has been approved by the Open Source Initiative.         
// Copyright (C) 1997-2002 International Business Machines Corporation and     
// others. All rights reserved.                                                
//                                                                             
///////////////////////////////////////////////////////////////////////////////

package com.ibm.as400.resource;

import java.util.ListResourceBundle;



/**
Locale-specific objects for the IBM Toolbox for Java.
@deprecated Use packages <tt>com.ibm.as400.access</tt> and <tt>com.ibm.as400.access.list</tt> instead. 
**/
public class ResourceMRI
extends ListResourceBundle
{
   // NLS_MESSAGEFORMAT_NONE
   // Each string is assumed NOT to be processed by the MessageFormat class.
   // This means that a single quote must be coded as 1 single quote.

   // NLS_ENCODING=UTF-8
   // Instructs the translation tools to interpret the text as UTF-8.

    public Object[][] getContents()
    {
        return resources_;
    }



    private final static Object[][] resources_ = {

        // #TRANNOTE Before you add a new resource, please make
        // #TRANNOTE sure you are not duplicating another.  The
        // #TRANNOTE goal is to keep the amount of translatable
        // #TRANNOTE text down.
        // #TRANNOTE
        // #TRANNOTE NOTE TO TRANSLATORS: The format of a line of MRI
        // #TRANNOTE    is { "KEY", "value" },
        // #TRANNOTE
        // #TRANNOTE The key must be left alone so translate only the value.
        // #TRANNOTE



        // #TRANNOTE #####################################################
        // #TRANNOTE Bean text.
        // #TRANNOTE #####################################################

        { "EVENT_PROPERTY_CHANGE_NAME",         "propertyChange" },
        { "EVENT_PROPERTY_CHANGE_DESCRIPTION",  "A bound property changed." },
        { "EVENT_RESOURCE_NAME",                "resource" },
        { "EVENT_RESOURCE_DESCRIPTION",         "A resource event occurred." },
        { "EVENT_RESOURCE_LIST_NAME",           "resourceList" },
        { "EVENT_RESOURCE_LIST_DESCRIPTION",    "A resource list event occurred." },
        { "EVENT_VETOABLE_CHANGE_NAME",         "vetoableChange" },
        { "EVENT_VETOABLE_CHANGE_DESCRIPTION",  "A contrained property changed." },

        { "PROPERTY_LOAD_ID_NAME",              "loadID" },
        { "PROPERTY_LOAD_ID_DESCRIPTION",       "The load ID." },
        { "PROPERTY_NAME_NAME",                 "name" },
        { "PROPERTY_NAME_DESCRIPTION",          "The name." },
        { "PROPERTY_NUMBER_NAME",               "number" },
        { "PROPERTY_NUMBER_DESCRIPTION",        "The number." },
        { "PROPERTY_PATH_NAME",                 "path" },
        { "PROPERTY_PATH_DESCRIPTION",          "The path." },
        { "PROPERTY_PRODUCT_ID_NAME",           "productID" },
        { "PROPERTY_PRODUCT_ID_DESCRIPTION",    "The product ID." },
        { "PROPERTY_PRODUCT_OPTION_NAME",       "productOption" },
        { "PROPERTY_PRODUCT_OPTION_DESCRIPTION","The product option." },
        { "PROPERTY_RELEASE_LEVEL_NAME",        "releaseLevel" },
        { "PROPERTY_RELEASE_LEVEL_DESCRIPTION", "The release level." },
        { "PROPERTY_SYSTEM_NAME",               "system" },
        { "PROPERTY_SYSTEM_DESCRIPTION",        "The system." },
        { "PROPERTY_USER_NAME",                 "user" },
        { "PROPERTY_USER_DESCRIPTION",          "The user." },


        // #TRANNOTE #####################################################
        // #TRANNOTE Exception text.
        // #TRANNOTE #####################################################

        { "EXC_ATTRIBUTES_NOT_RETURNED",    "One or more attributes were not returned." },
        { "EXC_ATTRIBUTES_NOT_SET",         "One or more attributes were not set." },
        { "EXC_ATTRIBUTE_READ_ONLY",        "Attribute is read-only." }, // @A1a
        { "EXC_MESSAGES_RETURNED",          "Messages were returned." },
        { "EXC_OPERATION_FAILED",           "The operation failed." },
        { "EXC_OPERATION_NOT_SUPPORTED",    "The operation is not supported." },
        { "EXC_AUTHORITY_INSUFFICIENT",     "User has insufficient authority." }, // @A1a
        { "EXC_UNKNOWN_ERROR",              "An unknown error occurred." },



        // #TRANNOTE #####################################################
        // #TRANNOTE IFSFile component MRI.
        // #TRANNOTE #####################################################
        { "IFSFILE_DESCRIPTION",                                "File" },

        { "IFSFILE_ABSOLUTE_PATH_NAME",                         "Absolute Path" },
        { "IFSFILE_CANONICAL_PATH_NAME",                        "Canonical Path" },
        { "IFSFILE_CAN_READ_NAME",                              "Can Read" },
        { "IFSFILE_CAN_WRITE_NAME",                             "Can Write" },
        { "IFSFILE_CCSID_NAME",                                 "CCSID" },
        { "IFSFILE_CREATED_NAME",                               "Created" },
        { "IFSFILE_EXISTS_NAME",                                "Exists" },
        { "IFSFILE_IS_ABSOLUTE_NAME",                           "Is Absolute" },
        { "IFSFILE_IS_DIRECTORY_NAME",                          "Is Directory" },
        { "IFSFILE_IS_FILE_NAME",                               "Is File" },
        { "IFSFILE_IS_HIDDEN_NAME",                             "Is Hidden" },
        { "IFSFILE_IS_READ_ONLY_NAME",                          "Is Read Only Name" },
        { "IFSFILE_LAST_ACCESSED_NAME",                         "Last Accessed" },
        { "IFSFILE_LAST_MODIFIED_NAME",                         "Last Modified" },
        { "IFSFILE_LENGTH_NAME",                                "Length" },
        { "IFSFILE_NAME_NAME",                                  "Name" },
        { "IFSFILE_OWNERID_NAME",                               "Owner ID" }, //@A2a
        { "IFSFILE_PARENT_NAME",                                "Parent" },
        { "IFSFILE_PATH_NAME",                                  "Path" },
        { "IFSFILE_TYPE_NAME",                                  "Type" },
        { "IFSFILE_TYPE_DIRECTORY_NAME",                        "Directory" },
        { "IFSFILE_TYPE_FILE_NAME",                             "File" },
        { "IFSFILE_TYPE_UNKNOWN_NAME",                          "Unknown" },



        // #TRANNOTE #####################################################
        // #TRANNOTE IFSFileList component MRI.
        // #TRANNOTE #####################################################

        { "IFSFILE_LIST_DESCRIPTION",                           "File" },

        { "IFSFILE_LIST_FILTER_NAME",                           "Filter" },
        { "IFSFILE_LIST_PATTERN_NAME",                          "Pattern" },




        // #TRANNOTE #####################################################
        // #TRANNOTE Java Program component MRI.
        // #TRANNOTE #####################################################

        { "JAVA_PROGRAM_DESCRIPTION",                                   "Java Program" },

        { "JAVA_PROGRAM_CLASSES_WITHOUT_CURRENT_JAVA_PROGRAMS_NAME",    "Classes Without Current Java Programs" },
        { "JAVA_PROGRAM_CLASSES_WITH_CURRENT_JAVA_PROGRAMS_NAME",       "Classes With Current Java Programs" },
        { "JAVA_PROGRAM_CLASSES_WITH_ERRORS_NAME",                      "Classes With Errors" },  // @A3A
        { "JAVA_PROGRAM_ENABLE_PERFORMANCE_COLLECTION_NAME",            "Enable Performance Collection" },
        { "JAVA_PROGRAM_ENABLE_PERFORMANCE_COLLECTION_NONE_NAME",       "None" },
        { "JAVA_PROGRAM_ENABLE_PERFORMANCE_COLLECTION_ENTRYEXIT_NAME",  "Entry/Exit" },
        { "JAVA_PROGRAM_ENABLE_PERFORMANCE_COLLECTION_FULL_NAME",       "Full" },
        { "JAVA_PROGRAM_FILE_CHANGE_NAME",                              "File Change" },
        { "JAVA_PROGRAM_JAVA_PROGRAMS_NAME",                            "Java Programs" },
        { "JAVA_PROGRAM_JAVA_PROGRAM_CREATION_NAME",                    "Java Program Creation" },
        { "JAVA_PROGRAM_JAVA_PROGRAM_SIZE_NAME",                        "Java Program Size" },
        { "JAVA_PROGRAM_LICENSED_INTERNAL_CODE_OPTIONS_NAME",           "Licensed Internal Code Options" },
        { "JAVA_PROGRAM_OPTIMIZATION_NAME",                             "Optimization" },
        { "JAVA_PROGRAM_OPTIMIZATION_-1_NAME",                          "Interpret" },
        { "JAVA_PROGRAM_OPTIMIZATION_10_NAME",                          "10" },
        { "JAVA_PROGRAM_OPTIMIZATION_20_NAME",                          "20" },
        { "JAVA_PROGRAM_OPTIMIZATION_30_NAME",                          "30" },
        { "JAVA_PROGRAM_OPTIMIZATION_40_NAME",                          "40" },
        { "JAVA_PROGRAM_OWNER_NAME",                                    "Owner" },
        { "JAVA_PROGRAM_PROFILING_DATA_NAME",                           "Profiling Data" },  // @A3A
        { "JAVA_PROGRAM_PROFILING_DATA_NOCOL_NAME",                     "Collection" },      // @A3A
        { "JAVA_PROGRAM_PROFILING_DATA_COL_NAME",                       "No Collection" },   // @A3A
        { "JAVA_PROGRAM_PROFILING_DATA_APY_NAME",                       "Apply" },           // @A3A
        { "JAVA_PROGRAM_PROFILING_DATA_CLR_NAME",                       "Clear" },           // @A3A
        { "JAVA_PROGRAM_RELEASE_PROGRAM_CREATED_FOR_NAME",              "Release Program Created For" },
        { "JAVA_PROGRAM_TOTAL_CLASSES_IN_SOURCE_NAME",                  "Total Classes In Source" },  // @A3A
        { "JAVA_PROGRAM_USE_ADOPTED_AUTHORITY_NAME",                    "Use Adopted Authority" },
        { "JAVA_PROGRAM_USE_ADOPTED_AUTHORITY_NO_NAME",                 "No" },
        { "JAVA_PROGRAM_USE_ADOPTED_AUTHORITY_YES_NAME",                "Yes" },
        { "JAVA_PROGRAM_USER_PROFILE_NAME",                             "User Profile" },
        { "JAVA_PROGRAM_USER_PROFILE_OWNER_NAME",                       "Owner" },
        { "JAVA_PROGRAM_USER_PROFILE_USER_NAME",                        "User" },



        // #TRANNOTE #####################################################
        // #TRANNOTE Job component MRI.
        // #TRANNOTE #####################################################

        { "JOB_DESCRIPTION",                                    "Job" },

        { "JOB_ACCOUNTING_CODE_NAME",                           "Accounting Code" },
        { "JOB_ACTIVE_JOB_STATUS_NAME",                         "Active Job Status" },
        { "JOB_AUXILIARY_IO_REQUESTS_NAME",                     "Auxiliary I/O Requests" },
        { "JOB_BREAK_MESSAGE_HANDLING_NAME",                    "Break Message Handling" },
        { "JOB_BREAK_MESSAGE_HANDLING_HOLD_NAME",               "Hold" },
        { "JOB_BREAK_MESSAGE_HANDLING_NORMAL_NAME",             "Normal" },
        { "JOB_BREAK_MESSAGE_HANDLING_NOTIFY_NAME",             "Notify" },
        { "JOB_CCSID_NAME",                                     "CCSID" },
        { "JOB_CCSID_-1_NAME",                                  "System Value" },
        { "JOB_CCSID_-2_NAME",                                  "Initial User" },
        { "JOB_COMPLETION_STATUS_NAME",                         "Completion Status" },
        { "JOB_COMPLETION_STATUS__NAME",                        "Not Completed" },
        { "JOB_COMPLETION_STATUS_0_NAME",                       "Completed Normally" },
        { "JOB_COMPLETION_STATUS_1_NAME",                       "Completed Abnormally" },
        { "JOB_CONTROLLED_END_REQUESTED_NAME",                  "Controlled End Requested" },
        { "JOB_CONTROLLED_END_REQUESTED__NAME",                 "Not Running" },
        { "JOB_CONTROLLED_END_REQUESTED_0_NAME",                "Not Canceled" },
        { "JOB_CONTROLLED_END_REQUESTED_1_NAME",                "Canceled" },
        { "JOB_COUNTRY_ID_NAME",                                "Country or Region ID" },   // @D4C
        { "JOB_COUNTRY_ID_SYSVAL_NAME",                         "System Value" },
        { "JOB_COUNTRY_ID_USRPRF_NAME",                         "User Profile" },
        { "JOB_CPU_TIME_USED_NAME",                             "CPU Time Used" },
        { "JOB_CURRENT_LIBRARY_NAME",                           "Current Library" },
        { "JOB_CURRENT_LIBRARY_EXISTENCE_NAME",                 "Current Library Existence" },
        { "JOB_CURRENT_SYSTEM_POOL_ID_NAME",                    "Current System Pool ID" },
        { "JOB_CURRENT_USER_NAME",                              "Current User" },
        { "JOB_DATE_ENTERED_SYSTEM_NAME",                       "Date Entered System" },
        { "JOB_DATE_FORMAT_NAME",                               "Date Format" },
        { "JOB_DATE_FORMAT_DMY_NAME",                           "Day Month Year" },
        { "JOB_DATE_FORMAT_JUL_NAME",                           "Julian" },
        { "JOB_DATE_FORMAT_MDY_NAME",                           "Month Day Year" },
        { "JOB_DATE_FORMAT_SYS_NAME",                           "System Value" },
        { "JOB_DATE_FORMAT_YMD_NAME",                           "Year Month Day" },
        { "JOB_DATE_SEPARATOR_NAME",                            "Date Separator" },
        { "JOB_DATE_SEPARATOR_S_NAME",                          "System Value" },
        { "JOB_DATE_STARTED_NAME",                              "Date Started" },
        { "JOB_DBCS_CAPABLE_NAME",                              "DBCS Capable" },
        { "JOB_DECIMAL_FORMAT_NAME",                            "Decimal Format" },
        { "JOB_DECIMAL_FORMAT__NAME",                           "Period" },
        { "JOB_DECIMAL_FORMAT_I_NAME",                          "Comma Format I" },
        { "JOB_DECIMAL_FORMAT_J_NAME",                          "Comma Format J" },
        { "JOB_DECIMAL_FORMAT_SYSVAL_NAME",                     "System Value" },
        { "JOB_DEFAULT_CCSID_NAME",                             "Default CCSID" },
        { "JOB_DEFAULT_WAIT_TIME_NAME",                         "Default Wait Time" },
        { "JOB_DEVICE_RECOVERY_ACTION_NAME",                    "Device Recovery Action" },
        { "JOB_DEVICE_RECOVERY_ACTION_DSCENDRQS_NAME",          "Disconnect End Request" },
        { "JOB_DEVICE_RECOVERY_ACTION_DSCMSG_NAME",             "Disconnect Message" },
        { "JOB_DEVICE_RECOVERY_ACTION_ENDJOB_NAME",             "End Job" },
        { "JOB_DEVICE_RECOVERY_ACTION_ENDJOBNOLIST_NAME",       "End Job No List" },
        { "JOB_DEVICE_RECOVERY_ACTION_MSG_NAME",                "Message" },
        { "JOB_DEVICE_RECOVERY_ACTION_SYSVAL_NAME",             "System Value" },
        { "JOB_ELIGIBLE_FOR_PURGE_NAME",                        "Eligible For Purge" },
        { "JOB_END_SEVERITY_NAME",                              "End Severity" },
        { "JOB_FUNCTION_NAME_NAME",                             "Function Name" },
        { "JOB_FUNCTION_TYPE_NAME",                             "Function Type" },
        { "JOB_FUNCTION_TYPE__NAME",                            "Blank" },
        { "JOB_FUNCTION_TYPE_C_NAME",                           "Command" },
        { "JOB_FUNCTION_TYPE_D_NAME",                           "Delay" },
        { "JOB_FUNCTION_TYPE_G_NAME",                           "Group" },
        { "JOB_FUNCTION_TYPE_I_NAME",                           "Index" },
        { "JOB_FUNCTION_TYPE_L_NAME",                           "Log" },
        { "JOB_FUNCTION_TYPE_M_NAME",                           "MRT" },
        { "JOB_FUNCTION_TYPE_N_NAME",                           "Menu" },
        { "JOB_FUNCTION_TYPE_O_NAME",                           "I/O" },
        { "JOB_FUNCTION_TYPE_P_NAME",                           "Program" },
        { "JOB_FUNCTION_TYPE_R_NAME",                           "Procedure" },
        { "JOB_FUNCTION_TYPE__NAME",                            "Special" },
        { "JOB_INQUIRY_MESSAGE_REPLY_NAME",                     "Inquiry Message Reply" },
        { "JOB_INQUIRY_MESSAGE_REPLY_DFT_NAME",                 "Default" },
        { "JOB_INQUIRY_MESSAGE_REPLY_RQD_NAME",                 "Required" },
        { "JOB_INQUIRY_MESSAGE_REPLY_SYSRPYL_NAME",             "System Reply List" },
        { "JOB_INSTANCE_NAME",                                  "Instance" },
        { "JOB_INTERACTIVE_TRANSACTIONS_NAME",                  "Interactive Transactions" },
        { "JOB_INTERNAL_JOB_ID_NAME",                           "Internal Job Identifier" },
        { "JOB_JOB_DATE_NAME",                                  "Job Date" },
        { "JOB_JOB_DESCRIPTION_NAME",                           "Job Description" },
        { "JOB_JOB_NAME_NAME",                                  "Job Name" },
        { "JOB_JOB_NUMBER_NAME",                                "Job Number" },
        { "JOB_JOB_QUEUE_NAME",                                 "Job Queue" },
        { "JOB_JOB_QUEUE_DATE_NAME",                            "Job Queue Date" },
        { "JOB_JOB_QUEUE_PRIORITY_NAME",                        "Job Queue Priority" },
        { "JOB_JOB_QUEUE_STATUS_NAME",                          "Job Queue Status" },
        { "JOB_JOB_QUEUE_STATUS__NAME",                         "Blank" },
        { "JOB_JOB_QUEUE_STATUS_HLD_NAME",                      "Held" },
        { "JOB_JOB_QUEUE_STATUS_RLS_NAME",                      "Released" },
        { "JOB_JOB_QUEUE_STATUS_SCD_NAME",                      "Scheduled" },
        { "JOB_JOB_STATUS_NAME",                                "Job Status" },
        { "JOB_JOB_STATUS_ACTIVE_NAME",                         "Active" },
        { "JOB_JOB_STATUS_JOBQ_NAME",                           "Job Queue" },
        { "JOB_JOB_STATUS_OUTQ_NAME",                           "Output Queue" },
        { "JOB_JOB_SUBTYPE_NAME",                               "Job Subtype" },
        { "JOB_JOB_SUBTYPE__NAME",                              "Blank" },
        { "JOB_JOB_SUBTYPE_D_NAME",                             "Immediate" },
        { "JOB_JOB_SUBTYPE_E_NAME",                             "Procedure Start Request" },
        { "JOB_JOB_SUBTYPE_F_NAME",                             "Machine Server Job" },
        { "JOB_JOB_SUBTYPE_J_NAME",                             "Prestart" },
        { "JOB_JOB_SUBTYPE_P_NAME",                             "Print Driver" },
        { "JOB_JOB_SUBTYPE_T_NAME",                             "MRT" },
        { "JOB_JOB_SUBTYPE_U_NAME",                             "Alternate Spool User" },
        { "JOB_JOB_SWITCHES_NAME",                              "Job Switches" },
        { "JOB_JOB_TYPE_NAME",                                  "Job Type" },
        { "JOB_JOB_TYPE__NAME",                                 "Not Valid" },
        { "JOB_JOB_TYPE_A_NAME",                                "Autostart" },
        { "JOB_JOB_TYPE_B_NAME",                                "Batch" },
        { "JOB_JOB_TYPE_I_NAME",                                "Interactive" },
        { "JOB_JOB_TYPE_M_NAME",                                "Subsystem Monitor" },
        { "JOB_JOB_TYPE_R_NAME",                                "Spooled Reader" },
        { "JOB_JOB_TYPE_S_NAME",                                "System" },
        { "JOB_JOB_TYPE_W_NAME",                                "Spooled Writer" },
        { "JOB_JOB_TYPE_X_NAME",                                "SCPF System" },
        { "JOB_KEEP_DDM_CONNECTIONS_ACTIVE_NAME",               "Keep DDM Connections Active" },
        { "JOB_KEEP_DDM_CONNECTIONS_ACTIVE_KEEP_NAME",          "Keep" },
        { "JOB_KEEP_DDM_CONNECTIONS_ACTIVE_DROP_NAME",          "Drop" },
        { "JOB_LANGUAGE_ID_NAME",                               "Language ID" },
        { "JOB_LANGUAGE_ID_SYSVAL_NAME",                        "System Value" },
        { "JOB_LANGUAGE_ID_USRPRF_NAME",                        "User Profile" },
        { "JOB_LOCATION_NAME_NAME",                             "Location Name" },
        { "JOB_LOG_CL_PROGRAMS_NAME",                           "Log CL Programs" },
        { "JOB_LOGGING_LEVEL_NAME",                             "Logging Level" },
        { "JOB_LOGGING_LEVEL_0_NAME",                           "None" },
        { "JOB_LOGGING_LEVEL_1_NAME",                           "Messages By Severity" },
        { "JOB_LOGGING_LEVEL_2_NAME",                           "Requests By Severity and Associated Messages" },
        { "JOB_LOGGING_LEVEL_3_NAME",                           "All Requests and Associated Messages" },
        { "JOB_LOGGING_LEVEL_4_NAME",                           "All Requests and Messages" },
        { "JOB_LOGGING_SEVERITY_NAME",                          "Logging Severity" },
        { "JOB_LOGGING_TEXT_NAME",                              "Logging Text" },
        { "JOB_LOGGING_TEXT_MSG_NAME",                          "Message" },
        { "JOB_LOGGING_TEXT_SECLVL_NAME",                       "Seclvl" },
        { "JOB_LOGGING_TEXT_NOLIST_NAME",                       "No List" },
        { "JOB_MAX_CPU_TIME_NAME",                              "Max CPU Time" },
        { "JOB_MAX_TEMP_STORAGE_NAME",                          "Max Temp Storage" },
        { "JOB_MESSAGE_QUEUE_ACTION_NAME",                      "Message Queue Action" },
        { "JOB_MESSAGE_QUEUE_ACTION_NOWRAP_NAME",               "No Wrap" },
        { "JOB_MESSAGE_QUEUE_ACTION_PRTWRAP_NAME",              "Print Wrap" },
        { "JOB_MESSAGE_QUEUE_ACTION_WRAP_NAME",                 "Wrap" },
        { "JOB_MESSAGE_QUEUE_MAX_SIZE_NAME",                    "Message Queue Max Size" },
        { "JOB_MODE_NAME",                                      "Mode" },
        { "JOB_NETWORK_ID_NAME",                                "Network ID" },
        { "JOB_OUTPUT_QUEUE_NAME",                              "Output Queue" },
        { "JOB_OUTPUT_QUEUE_PRIORITY_NAME",                     "Output Queue Priority" },
        { "JOB_PRINT_KEY_FORMAT_NAME",                          "Print Key Format" },
        { "JOB_PRINT_KEY_FORMAT_NONE_NAME",                     "None" },
        { "JOB_PRINT_KEY_FORMAT_PRTALL_NAME",                   "All" },
        { "JOB_PRINT_KEY_FORMAT_PRTBDR_NAME",                   "Border" },
        { "JOB_PRINT_KEY_FORMAT_PRTHDR_NAME",                   "Header" },
        { "JOB_PRINT_KEY_FORMAT_SYSVAL_NAME",                   "System Value" },
        { "JOB_PRINT_TEXT_NAME",                                "Print Text" },
        { "JOB_PRINT_TEXT_SYSVAL_NAME",                         "System Value" },
        { "JOB_PRINTER_DEVICE_NAME_NAME",                       "Printer Device Name" },
        { "JOB_PRINTER_DEVICE_NAME_SYSVAL_NAME",                "System Value" },
        { "JOB_PRINTER_DEVICE_NAME_USRPRF_NAME",                "User Profile" },
        { "JOB_PRINTER_DEVICE_NAME_WRKSTN_NAME",                "Work Station" },
        { "JOB_PRODUCT_LIBRARIES_NAME",                         "Product Libraries" },
        { "JOB_PRODUCT_RETURN_CODE_NAME",                       "Product Return Code" },
        { "JOB_PROGRAM_RETURN_CODE_NAME",                       "Program Return Code" },
        { "JOB_ROUTING_DATA_NAME",                              "Routing Data" },
        { "JOB_RUN_PRIORITY_NAME",                              "Run Priority" },
        { "JOB_SCHEDULE_DATE_NAME",                             "Schedule Date" },
        { "JOB_SCHEDULE_DATE_CURRENT_NAME",                     "Current" },
        { "JOB_SCHEDULE_DATE_MONTHSTR_NAME",                    "Month Start" },
        { "JOB_SCHEDULE_DATE_MONTHEND_NAME",                    "Month End" },
        { "JOB_SCHEDULE_DATE_MON_NAME",                         "Monday" },
        { "JOB_SCHEDULE_DATE_TUE_NAME",                         "Tuesday" },
        { "JOB_SCHEDULE_DATE_WED_NAME",                         "Wednesday" },
        { "JOB_SCHEDULE_DATE_THU_NAME",                         "Thursday" },
        { "JOB_SCHEDULE_DATE_FRI_NAME",                         "Friday" },
        { "JOB_SCHEDULE_DATE_SAT_NAME",                         "Saturday" },
        { "JOB_SCHEDULE_DATE_SUN_NAME",                         "Sunday" },
        { "JOB_SEQUENCE_NUMBER_NAME",                           "Sequence Number" },
        { "JOB_SERVER_TYPE_NAME",                               "Server Type" },
        { "JOB_SIGNED_ON_JOB_NAME",                             "Signed On Job" },
        { "JOB_SORT_SEQUENCE_TABLE_NAME",                       "Sort Sequence Table" },
        { "JOB_SPECIAL_ENVIRONMENT_NAME",                       "Special Environment" },
        { "JOB_SPECIAL_ENVIRONMENT__NAME",                      "Not Active" },
        { "JOB_SPECIAL_ENVIRONMENT_NONE_NAME",                  "None" },
        { "JOB_SPECIAL_ENVIRONMENT_S36_NAME",                   "System/36" },
        { "JOB_STATUS_MESSAGE_HANDLING_NAME",                   "Status Message Handling" },
        { "JOB_STATUS_MESSAGE_HANDLING_NORMAL_NAME",            "Normal" },
        { "JOB_STATUS_MESSAGE_HANDLING_NONE_NAME",              "None" },
        { "JOB_STATUS_MESSAGE_HANDLING_SYSVAL_NAME",            "System Value" },
        { "JOB_STATUS_MESSAGE_HANDLING_USRPRF_NAME",            "User Profile" },
        { "JOB_SUBMITTED_BY_JOB_NAME_NAME",                     "Submitted By Job Name" },
        { "JOB_SUBMITTED_BY_JOB_NUMBER_NAME",                   "Submitted By Job Number" },
        { "JOB_SUBMITTED_BY_USER_NAME",                         "Submitted By User Name" },
        { "JOB_SUBSYSTEM_NAME",                                 "Subsystem" },
        { "JOB_SYSTEM_POOL_ID_NAME",                            "System Pool ID" },
        { "JOB_SYSTEM_LIBRARY_LIST_NAME",                       "System Library List" },
        { "JOB_TEMP_STORAGE_USED_NAME",                         "Temp Storage Used" },
        { "JOB_THREAD_COUNT_NAME",                              "Thread Count" },
        { "JOB_TIME_SEPARATOR_NAME",                            "Time Separator" },
        { "JOB_TIME_SEPARATOR_S_NAME",                          "System Value" },
        { "JOB_TIME_SLICE_NAME",                                "Time Slice" },
        { "JOB_TIME_SLICE_END_POOL_NAME",                       "Time Slice End Pool" },
        { "JOB_TIME_SLICE_END_POOL_BASE_NAME",                  "Base" },
        { "JOB_TIME_SLICE_END_POOL_NONE_NAME",                  "None" },
        { "JOB_TIME_SLICE_END_POOL_SYSVAL_NAME",                "System Value" },
        { "JOB_TOTAL_RESPONSE_TIME_NAME",                       "Total Response Time" },
        { "JOB_USER_LIBRARY_LIST_NAME",                         "User Library List" },
        { "JOB_USER_NAME_NAME",                                 "User Name" },
        { "JOB_USER_RETURN_CODE_NAME",                          "User Return Code" },



        // #TRANNOTE #####################################################
        // #TRANNOTE Job list component MRI.
        // #TRANNOTE #####################################################

        { "JOB_LIST_NAME",                                      "Job List" },
        { "JOB_LIST_ACTIVE_JOB_STATUSES_NAME",                  "Active Job Statuses" },
        { "JOB_LIST_CURRENT_USER_PROFILES_NAME",                "Current User Profiles" },
        { "JOB_LIST_JOB_NAME_NAME",                             "Job Name" },
        { "JOB_LIST_JOB_NAME__NAME",                            "*" },
        { "JOB_LIST_JOB_NAME_ALL_NAME",                         "All" },
        { "JOB_LIST_JOB_NAME_CURRENT_NAME",                     "Current" },
        { "JOB_LIST_JOB_NUMBER_NAME",                           "Job Number" },
        { "JOB_LIST_JOB_NUMBER_ALL_NAME",                       "All" },
        { "JOB_LIST_JOB_QUEUE_NAMES_NAME",                      "Job Queue Names" },
        { "JOB_LIST_JOB_TYPE_NAME",                             "Job Type" },
        { "JOB_LIST_JOB_TYPE_A_NAME",                           "Autostart Jobs" },
        { "JOB_LIST_JOB_TYPE_ALL_NAME",                         "All Jobs" },
        { "JOB_LIST_JOB_TYPE_B_NAME",                           "Batch Jobs" },
        { "JOB_LIST_JOB_TYPE_I_NAME",                           "Interactive Jobs" },
        { "JOB_LIST_JOB_TYPE_M_NAME",                           "Subsystem Monitor Jobs" },
        { "JOB_LIST_JOB_TYPE_R_NAME",                           "Spooled Reader Jobs" },
        { "JOB_LIST_JOB_TYPE_S_NAME",                           "System Jobs" },
        { "JOB_LIST_JOB_TYPE_W_NAME",                           "Spooled Writer Jobs" },
        { "JOB_LIST_JOB_TYPE_X_NAME",                           "SCPF System Jobs" },
        { "JOB_LIST_JOBS_ON_JOB_QUEUE_STATUSES_NAME",           "Jobs On Job Queue Statuses" },
        { "JOB_LIST_JOBS_ON_JOB_QUEUE_STATUSES_HLD_NAME",       "Held" },
        { "JOB_LIST_JOBS_ON_JOB_QUEUE_STATUSES_RLS_NAME",       "Released" },
        { "JOB_LIST_JOBS_ON_JOB_QUEUE_STATUSES_SCD_NAME",       "Scheduled" },
        { "JOB_LIST_PRIMARY_JOB_STATUSES_NAME",                 "Primary Job Statuses" },
        { "JOB_LIST_PRIMARY_JOB_STATUSES_ACTIVE_NAME",          "Active Jobs" },
        { "JOB_LIST_PRIMARY_JOB_STATUSES_JOBQ_NAME",            "Job Queue" },
        { "JOB_LIST_PRIMARY_JOB_STATUSES_OUTQ_NAME",            "Output Queue" },
        { "JOB_LIST_SERVER_TYPES_NAME",                         "Server Types" },
        { "JOB_LIST_SERVER_TYPES_ALL_NAME",                     "Jobs With A Server Type" },
        { "JOB_LIST_SERVER_TYPES_BLANK_NAME",                   "Jobs Without A Server Type" },
        { "JOB_LIST_USER_NAME_NAME",                            "User Name" },
        { "JOB_LIST_USER_NAME_ALL_NAME",                        "All Users" },
        { "JOB_LIST_USER_NAME_CURRENT_NAME",                    "Current" },



        // #TRANNOTE #####################################################
        // #TRANNOTE Job log component MRI.
        // #TRANNOTE #####################################################

        { "JOB_LOG_DESCRIPTION",                                "Job Log" },
        { "JOB_LOG_LIST_DIRECTION_NAME",                        "List Direction" },
        { "JOB_LOG_LIST_DIRECTION_NEXT_NAME",                   "Next" },
        { "JOB_LOG_LIST_DIRECTION_PRV_NAME",                    "Previous" },
        { "JOB_LOG_STARTING_MESSAGE_KEY_NAME",                  "Starting Message Key" },
        { "JOB_LOG_STARTING_MESSAGE_KEY_-1_NAME",               "Newest" },
        { "JOB_LOG_STARTING_MESSAGE_KEY_0_NAME",                "Oldest" },



        // #TRANNOTE #####################################################
        // #TRANNOTE Message component MRI.
        // #TRANNOTE #####################################################

        { "MESSAGE_QUEUE_DESCRIPTION",                          "Message Queue" },
        { "MESSAGE_QUEUE_FORMATTING_CHARACTERS_NAME",           "Formatting Characters" },
        { "MESSAGE_QUEUE_FORMATTING_CHARACTERS_0_NAME",         "No Formatting" },
        { "MESSAGE_QUEUE_FORMATTING_CHARACTERS_1_NAME",         "Return Formatting Characters" },
        { "MESSAGE_QUEUE_FORMATTING_CHARACTERS_2_NAME",         "Substitute Formatting Characters" },
        { "MESSAGE_QUEUE_LIST_DIRECTION_NAME",                  "List Direction" },
        { "MESSAGE_QUEUE_LIST_DIRECTION_NEXT_NAME",             "Next" },
        { "MESSAGE_QUEUE_LIST_DIRECTION_PRV_NAME",              "Previous" },
        { "MESSAGE_QUEUE_REPLACEMENT_DATA_NAME",                "Replacement Data" },
        { "MESSAGE_QUEUE_SELECTION_CRITERIA_NAME",              "Selection Criteria" },
        { "MESSAGE_QUEUE_SELECTION_CRITERIA_ALL_NAME",          "All Messages" },
        { "MESSAGE_QUEUE_SELECTION_CRITERIA_MNR_NAME",          "Messages Needing Reply" },
        { "MESSAGE_QUEUE_SELECTION_CRITERIA_MNNR_NAME",         "Messages Not Needing Reply" },
        { "MESSAGE_QUEUE_SELECTION_CRITERIA_SCNR_NAME",         "Senders Copy Needing Reply" },
        { "MESSAGE_QUEUE_SEVERITY_CRITERIA_NAME",               "Severity Criteria" },
        { "MESSAGE_QUEUE_SORT_CRITERIA_NAME",                   "Sort Criteria" },
        { "MESSAGE_QUEUE_STARTING_USER_MESSAGE_KEY_NAME",       "Starting User Message Key" },
        { "MESSAGE_QUEUE_STARTING_USER_MESSAGE_KEY_-1_NAME",    "Newest" },
        { "MESSAGE_QUEUE_STARTING_USER_MESSAGE_KEY_0_NAME",     "Oldest" },
        { "MESSAGE_QUEUE_STARTING_WORKSTATION_MESSAGE_KEY_NAME",    "Starting Workstation Message Key" },
        { "MESSAGE_QUEUE_STARTING_WORKSTATION_MESSAGE_KEY_-1_NAME", "Newest" },
        { "MESSAGE_QUEUE_STARTING_WORKSTATION_MESSAGE_KEY_0_NAME",  "Oldest" },

        { "QUEUED_MESSAGE_DESCRIPTION",                         "Queued Message" },
        { "QUEUED_MESSAGE_ALERT_OPTION_NAME",                   "Alert Option" },
        { "QUEUED_MESSAGE_ALERT_OPTION__NAME",                  "Not specified" },
        { "QUEUED_MESSAGE_ALERT_OPTION_DEFER_NAME",             "Defer" },
        { "QUEUED_MESSAGE_ALERT_OPTION_IMMED_NAME",             "Immediate" },
        { "QUEUED_MESSAGE_ALERT_OPTION_NO_NAME",                "No" },
        { "QUEUED_MESSAGE_ALERT_OPTION_UNATTEND_NAME",          "Unattend" },
        { "QUEUED_MESSAGE_DATE_SENT_NAME",                      "Date Sent" },
        { "QUEUED_MESSAGE_DEFAULT_REPLY_NAME",                  "Default Reply" },
        { "QUEUED_MESSAGE_MESSAGE_FILE_NAME",                   "Message File" },
        { "QUEUED_MESSAGE_MESSAGE_HELP_NAME",                   "Message Help" },
        { "QUEUED_MESSAGE_MESSAGE_ID_NAME",                     "Message ID" },
        { "QUEUED_MESSAGE_MESSAGE_KEY_NAME",                    "Message Key" },
        { "QUEUED_MESSAGE_MESSAGE_QUEUE_NAME",                  "Message Queue" },
        { "QUEUED_MESSAGE_MESSAGE_SEVERITY_NAME",               "Message Severity" },
        { "QUEUED_MESSAGE_MESSAGE_TEXT_NAME",                   "Message Text" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_NAME",                   "Message Type" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_1_NAME",                 "Completion" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_2_NAME",                 "Diagnostic" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_4_NAME",                 "Informational" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_5_NAME",                 "Inquiry" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_6_NAME",                 "Senders Copy" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_8_NAME",                 "Request Copy" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_10_NAME",                "Request With Prompting" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_14_NAME",                "Notify" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_15_NAME",                "Escape" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_16_NAME",                "Notify Not Handled" }, // @D2A
        { "QUEUED_MESSAGE_MESSAGE_TYPE_17_NAME",                "Escape Not Handled" }, // @D2A
        { "QUEUED_MESSAGE_MESSAGE_TYPE_21_NAME",                "Reply Not Validity Checked" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_22_NAME",                "Reply Validity Checked" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_23_NAME",                "Reply Message Default Used" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_24_NAME",                "Reply System Default Used" },
        { "QUEUED_MESSAGE_MESSAGE_TYPE_25_NAME",                "Reply From System Reply List" },
        { "QUEUED_MESSAGE_REPLY_STATUS_NAME",                   "Reply Status" },
        { "QUEUED_MESSAGE_REPLY_STATUS_A_NAME",                 "Accepts Sent" },
        { "QUEUED_MESSAGE_REPLY_STATUS_N_NAME",                 "Not Accept" },
        { "QUEUED_MESSAGE_REPLY_STATUS_W_NAME",                 "Accepts Not Sent" },
        { "QUEUED_MESSAGE_SENDER_JOB_NAME_NAME",                "Sender Job Name" },
        { "QUEUED_MESSAGE_SENDER_JOB_NUMBER_NAME",              "Sender Job Number" },
        { "QUEUED_MESSAGE_SENDER_USER_NAME_NAME",               "Sender User Name" },
        { "QUEUED_MESSAGE_SENDING_PROGRAM_NAME_NAME",           "Sending Program Name" },
        { "QUEUED_MESSAGE_SUBSTITUTION_DATA_NAME",              "Substitution Data" },

        // #TRANNOTE #####################################################
        // #TRANNOTE Printer component MRI.
        // #TRANNOTE #####################################################

        { "PRINTER_DESCRIPTION",                                "Printer" },

        { "PRINTER_ADVANCED_FUNCTION_PRINTING_NAME",            "Advanced Function Printing" },
        { "PRINTER_ALIGN_FORMS_NAME",                           "Align Forms" },
        { "PRINTER_ALIGN_FORMS_WTR_NAME",                       "From Writer" },
        { "PRINTER_ALIGN_FORMS_FILE_NAME",                      "From File" },
        { "PRINTER_ALIGN_FORMS__NAME",                          "Ended" },
        { "PRINTER_ALLOW_DIRECT_PRINTING_NAME",                 "Allow Direct Printing" },
        { "PRINTER_AUTOMATICALLY_END_WRITER_NAME",              "Automatically End Writer" },
        { "PRINTER_AUTOMATICALLY_END_WRITER_NORDYF_NAME",       "No Files Ready" },
        { "PRINTER_AUTOMATICALLY_END_WRITER_FILEEND_NAME",      "File End" },
        { "PRINTER_AUTOMATICALLY_END_WRITER_NO_NAME",           "Do Not End" },
        { "PRINTER_AUTOMATICALLY_END_WRITER__NAME",             "Ended" },
        { "PRINTER_BETWEEN_COPIES_STATUS_NAME",                 "Between Copies Status" },
        { "PRINTER_BETWEEN_FILES_STATUS_NAME",                  "Between Files Status" },
        { "PRINTER_CHANGES_TAKE_EFFECT_NAME",                   "Changes Take Effect" },
        { "PRINTER_CHANGES_TAKE_EFFECT_NORDYF_NAME",            "No Files Ready" },
        { "PRINTER_CHANGES_TAKE_EFFECT_FILEEND_NAME",           "File End" },
        { "PRINTER_CHANGES_TAKE_EFFECT__NAME",                  "No Changes" },
        { "PRINTER_COPIES_LEFT_TO_PRODUCE_NAME",                "Copies Left To Produce" },
        { "PRINTER_DEVICE_NAME_NAME",                           "Device Name" },
        { "PRINTER_DEVICE_STATUS_NAME",                         "Device Status" },
        { "PRINTER_DEVICE_TYPE_NAME",                           "Device Type" },
        { "PRINTER_END_PENDING_STATUS_NAME",                    "End Pending Status" },
        { "PRINTER_END_PENDING_STATUS_C_NAME",                  "Controlled" },
        { "PRINTER_END_PENDING_STATUS_I_NAME",                  "Immediate" },
        { "PRINTER_END_PENDING_STATUS_N_NAME",                  "None" },
        { "PRINTER_END_PENDING_STATUS_P_NAME",                  "Page End" },
        { "PRINTER_END_PENDING_STATUS__NAME",                   "Ended" },
        { "PRINTER_FORM_TYPE_NAME",                             "Form Type" },
        { "PRINTER_FORM_TYPE_ALL_NAME",                         "All" },
        { "PRINTER_FORM_TYPE_FORMS_NAME",                       "Forms" },
        { "PRINTER_FORM_TYPE_STD_NAME",                         "Standard" },
        { "PRINTER_HELD_STATUS_NAME",                           "Held Status" },
        { "PRINTER_HOLD_PENDING_STATUS_NAME",                   "Hold Pending Status" },
        { "PRINTER_HOLD_PENDING_STATUS_C_NAME",                 "Controlled" },
        { "PRINTER_HOLD_PENDING_STATUS_I_NAME",                 "Immediate" },
        { "PRINTER_HOLD_PENDING_STATUS_N_NAME",                 "None" },
        { "PRINTER_HOLD_PENDING_STATUS_P_NAME",                 "Page End" },
        { "PRINTER_HOLD_PENDING_STATUS__NAME",                  "Ended" },
        { "PRINTER_JOB_NAME_NAME",                              "Job Name" },
        { "PRINTER_JOB_NUMBER_NAME",                            "Job Number" },
        { "PRINTER_JOB_QUEUE_STATUS_NAME",                      "Job Queue Status" },
        { "PRINTER_MESSAGE_KEY_NAME",                           "Message Key" },
        { "PRINTER_MESSAGE_OPTION_NAME",                        "Message Option" },
        { "PRINTER_MESSAGE_OPTION_INFOMSG_NAME",                "Informational Message" },
        { "PRINTER_MESSAGE_OPTION_INQMSG_NAME",                 "Inquiry Message" },
        { "PRINTER_MESSAGE_OPTION_MSG_NAME",                    "Message" },
        { "PRINTER_MESSAGE_OPTION_NOMSG_NAME",                  "No Message" },
        { "PRINTER_MESSAGE_OPTION__NAME",                       "Ended" },
        { "PRINTER_MESSAGE_QUEUE_NAME",                         "Message Queue" },
        { "PRINTER_NEXT_FILE_SEPARATORS_NAME",                  "Next File Separators" },
        { "PRINTER_NEXT_FILE_SEPARATORS_-1_NAME",               "From File" },
        { "PRINTER_NEXT_FILE_SEPARATORS_-10_NAME",              "No Changes" },
        { "PRINTER_NEXT_FORM_TYPE_NAME",                        "Next Form Type" },
        { "PRINTER_NEXT_FORM_TYPE_ALL_NAME",                    "All" },
        { "PRINTER_NEXT_FORM_TYPE_FORMS_NAME",                  "Forms" },
        { "PRINTER_NEXT_FORM_TYPE_STD_NAME",                    "Standard" },
        { "PRINTER_NEXT_MESSAGE_OPTION_NAME",                   "Next Message Option" },
        { "PRINTER_NEXT_MESSAGE_OPTION_INFOMSG_NAME",           "Informational Message" },
        { "PRINTER_NEXT_MESSAGE_OPTION_INQMSG_NAME",            "Inquiry Message" },
        { "PRINTER_NEXT_MESSAGE_OPTION_MSG_NAME",               "Message" },
        { "PRINTER_NEXT_MESSAGE_OPTION_NOMSG_NAME",             "No Message" },
        { "PRINTER_NEXT_MESSAGE_OPTION__NAME",                  "No Changes" },
        { "PRINTER_NEXT_OUTPUT_QUEUE_NAME",                     "Next Output Queue" },
        { "PRINTER_NEXT_SEPARATOR_DRAWER_NAME",                 "Next Separator Drawer" },
        { "PRINTER_NEXT_SEPARATOR_DRAWER_-1_NAME",              "From File" },
        { "PRINTER_NEXT_SEPARATOR_DRAWER_-2_NAME",              "From Device" },
        { "PRINTER_NEXT_SEPARATOR_DRAWER_-10_NAME",             "No Changes" },
        { "PRINTER_NUMBER_OF_SEPARATORS_NAME",                  "Number of Separators" },
        { "PRINTER_NUMBER_OF_SEPARATORS_-1_NAME",               "From File" },
        { "PRINTER_OUTPUT_QUEUE_NAME",                          "Output Queue" },
        { "PRINTER_OUTPUT_QUEUE_STATUS_NAME",                   "Output Queue Status" },
        { "PRINTER_OUTPUT_QUEUE_STATUS_H_NAME",                 "Held" },
        { "PRINTER_OUTPUT_QUEUE_STATUS_R_NAME",                 "Released" },
        { "PRINTER_OUTPUT_QUEUE_STATUS__NAME",                  "Not Set" },
        { "PRINTER_OVERALL_STATUS_NAME",                        "Overall Status" },
        { "PRINTER_PAGE_BEING_WRITTEN_NAME",                    "Page Being Written" },
        { "PRINTER_PUBLISHED_STATUS_NAME",                      "Published Status" },
        { "PRINTER_SEPARATOR_DRAWER_NAME",                      "Separator Drawer" },
        { "PRINTER_SEPARATOR_DRAWER_-1_NAME",                   "From File" },
        { "PRINTER_SEPARATOR_DRAWER_-2_NAME",                   "From Device" },
        { "PRINTER_SPOOLED_FILE_NAME_NAME",                     "Spooled File Name" },
        { "PRINTER_SPOOLED_FILE_NUMBER_NAME",                   "Spooled File Number" },
        { "PRINTER_STARTED_BY_USER_NAME",                       "Started By User" },
        { "PRINTER_TEXT_DESCRIPTION_NAME",                      "Text Description" },
        { "PRINTER_TOTAL_COPIES_NAME",                          "Total Copies" },
        { "PRINTER_TOTAL_PAGES_NAME",                           "Total Pages" },
        { "PRINTER_USER_NAME_NAME",                             "User Name" },
        { "PRINTER_WAITING_FOR_DATA_STATUS_NAME",               "Waiting For Data Status" },
        { "PRINTER_WAITING_FOR_DEVICE_STATUS_NAME",             "Waiting For Device Status" },
        { "PRINTER_WAITING_FOR_MESSAGE_STATUS_NAME",            "Waiting for Message Status" },
        { "PRINTER_WRITER_JOB_NAME_NAME",                       "Writer Job Name" },
        { "PRINTER_WRITER_JOB_NUMBER_NAME",                     "Writer Job Number" },
        { "PRINTER_WRITER_JOB_USER_NAME_NAME",                  "Writer Job User Name" },
        { "PRINTER_WRITER_STARTED_NAME",                        "Writer Started" },
        { "PRINTER_WRITER_STATUS_NAME",                         "Writer Status" },
        { "PRINTER_WRITER_STATUS_1_NAME",                       "Started" },
        { "PRINTER_WRITER_STATUS_2_NAME",                       "Ended" },
        { "PRINTER_WRITER_STATUS_3_NAME",                       "Job Queue" },
        { "PRINTER_WRITER_STATUS_4_NAME",                       "Held" },
        { "PRINTER_WRITER_STATUS_5_NAME",                       "Message Waiting" },
        { "PRINTER_WRITING_STATUS_NAME",                        "Writing Status" },
        { "PRINTER_WRITING_STATUS_Y_NAME",                      "Yes" },
        { "PRINTER_WRITING_STATUS_N_NAME",                      "No" },
        { "PRINTER_WRITING_STATUS_S_NAME",                      "Separators" },
        { "PRINTER_WRITING_STATUS__NAME",                       "Ended" },


        // #TRANNOTE #####################################################
        // #TRANNOTE Printer list component MRI.
        // #TRANNOTE #####################################################

        { "PRINTER_LIST_NAME",                                  "Printer List" },
        { "PRINTER_LIST_DESCRIPTION",                           "List of Printers" },

        { "PRINTER_LIST_OUTPUT_QUEUES_NAME",                    "Output Queues" },
        { "PRINTER_LIST_PRINTER_NAMES_NAME",                    "Printer Names" },

        // #TRANNOTE #####################################################
        // #TRANNOTE Software resource component MRI.
        // #TRANNOTE #####################################################

        { "SOFTWARE_RESOURCE_DESCRIPTION",                              "Software Resource" },

        { "SOFTWARE_RESOURCE_LEVEL_NAME",                               "Level" },
        { "SOFTWARE_RESOURCE_LOAD_ERROR_INDICATOR_NAME",                "Load Error Indicator" },
        { "SOFTWARE_RESOURCE_LOAD_ERROR_INDICATOR_ERROR_NAME",          "Error" },
        { "SOFTWARE_RESOURCE_LOAD_ERROR_INDICATOR_NONE_NAME",           "None" },
        { "SOFTWARE_RESOURCE_LOAD_ID_NAME",                             "Load ID" },
        { "SOFTWARE_RESOURCE_LOAD_ID_5050_NAME",                        "Code" },
        { "SOFTWARE_RESOURCE_LOAD_STATE_NAME",                          "Load State" },
        { "SOFTWARE_RESOURCE_LOAD_TYPE_NAME",                           "Load Type" },
        { "SOFTWARE_RESOURCE_LOAD_TYPE_CODE_NAME",                      "Code" },
        { "SOFTWARE_RESOURCE_LOAD_TYPE_LNG_NAME",                       "Language" },
        { "SOFTWARE_RESOURCE_MINIMUM_BASE_VRM_NAME",                    "Minimum Base VRM" },
        { "SOFTWARE_RESOURCE_MINIMUM_BASE_VRM_MATCH_NAME",              "Match" },
        { "SOFTWARE_RESOURCE_MINIMUM_TARGET_RELEASE_NAME",              "Minimum Target Release" },
        { "SOFTWARE_RESOURCE_PRIMARY_LANGUAGE_LOAD_ID_NAME",            "Primary Language Load ID" },
        { "SOFTWARE_RESOURCE_PRODUCT_ID_NAME",                          "Product ID" },
        { "SOFTWARE_RESOURCE_PRODUCT_ID_OPSYS_NAME",                    "Operating System" },
        { "SOFTWARE_RESOURCE_PRODUCT_OPTION_NAME",                      "Product Option" },
        { "SOFTWARE_RESOURCE_PRODUCT_OPTION_0000_NAME",                 "Base" },
        { "SOFTWARE_RESOURCE_REGISTRATION_TYPE_NAME",                   "Registration Type" },
        { "SOFTWARE_RESOURCE_REGISTRATION_VALUE_NAME",                  "Registration Value" },
        { "SOFTWARE_RESOURCE_RELEASE_LEVEL_NAME",                       "Release Level" },
        { "SOFTWARE_RESOURCE_RELEASE_LEVEL_CUR_NAME",                   "Current" },
        { "SOFTWARE_RESOURCE_RELEASE_LEVEL_ONLY_NAME",                  "Only" },
        { "SOFTWARE_RESOURCE_RELEASE_LEVEL_PRV_NAME",                   "Previous" },
        { "SOFTWARE_RESOURCE_REQUIREMENTS_MET_NAME",                    "Requirements Met" },
        { "SOFTWARE_RESOURCE_REQUIREMENTS_MET_0_NAME",                  "Unknown" },
        { "SOFTWARE_RESOURCE_REQUIREMENTS_MET_1_NAME",                  "All" },
        { "SOFTWARE_RESOURCE_REQUIREMENTS_MET_2_NAME",                  "Too Old Compared To Base" },
        { "SOFTWARE_RESOURCE_REQUIREMENTS_MET_3_NAME",                  "Too Old Compared To Option" },
        { "SOFTWARE_RESOURCE_SUPPORTED_FLAG_NAME",                      "Supported Flag" },
        { "SOFTWARE_RESOURCE_SYMBOLIC_LOAD_STATE_NAME",                 "Symbolic Load State" },
        { "SOFTWARE_RESOURCE_SYMBOLIC_LOAD_STATE_DEFINED_NAME",         "Defined" },
        { "SOFTWARE_RESOURCE_SYMBOLIC_LOAD_STATE_CREATED_NAME",         "Created" },
        { "SOFTWARE_RESOURCE_SYMBOLIC_LOAD_STATE_PACKAGED_NAME",        "Packaged" },
        { "SOFTWARE_RESOURCE_SYMBOLIC_LOAD_STATE_DAMAGED_NAME",         "Damaged" },
        { "SOFTWARE_RESOURCE_SYMBOLIC_LOAD_STATE_LOADED_NAME",          "Loaded" },
        { "SOFTWARE_RESOURCE_SYMBOLIC_LOAD_STATE_INSTALLED_NAME",       "Installed" },



        // #TRANNOTE #####################################################
        // #TRANNOTE User component MRI.
        // #TRANNOTE #####################################################

        { "USER_DESCRIPTION",                                   "User" },

        { "USER_ACCOUNTING_CODE_NAME",                          "Accounting Code" },
        { "USER_ALLOW_SYNCHRONIZATION_NAME",                    "Allow Synchronization" },
        { "USER_ASSISTANCE_LEVEL_NAME",                         "Assistance Level" },
        { "USER_ASSISTANCE_LEVEL_ADVANCED_NAME",                "Advanced" },
        { "USER_ASSISTANCE_LEVEL_BASIC_NAME",                   "Basic" },
        { "USER_ASSISTANCE_LEVEL_INTERMED_NAME",                "Intermediate" },
        { "USER_ASSISTANCE_LEVEL_SYSVAL_NAME",                  "System Value" },
        { "USER_ATTENTION_KEY_HANDLING_PROGRAM_NAME",           "Attention Key Handling Program" },
        { "USER_ATTENTION_KEY_HANDLING_PROGRAM_ASSIST_NAME",    "Assist" },
        { "USER_ATTENTION_KEY_HANDLING_PROGRAM_NONE_NAME",      "None" },
        { "USER_ATTENTION_KEY_HANDLING_PROGRAM_SYSVAL_NAME",    "System Value" },
        { "USER_BUILDING_NAME",                                 "Building" },
        { "USER_CC_MAIL_ADDRESS_NAME",                          "cc:Mail Address" },
        { "USER_CC_MAIL_COMMENT_NAME",                          "cc:Mail Comment" },
        { "USER_CHARACTER_CODE_SET_ID_NAME",                    "Character Code Set ID" },
        { "USER_CHARACTER_IDENTIFIER_CONTROL_NAME",             "Character Identifier Control" },
        { "USER_CHARACTER_IDENTIFIER_CONTROL_DEVD_NAME",        "Device Description" },
        { "USER_CHARACTER_IDENTIFIER_CONTROL_JOBCCSID_NAME",    "Job CCSID" },
        { "USER_CHARACTER_IDENTIFIER_CONTROL_SYSVAL_NAME",      "System Value" },
        { "USER_COMPANY_NAME",                                  "Company" },
        { "USER_COUNTRY_ID_NAME",                               "Country or Region ID" },  // @D4C
        { "USER_COUNTRY_ID_SYSVAL_NAME",                        "System Value" },
        { "USER_CURRENT_LIBRARY_NAME_NAME",                     "Current Library Name" },
        { "USER_CURRENT_LIBRARY_NAME_CRTDFT_NAME",              "Default" },
        { "USER_DATE_PASSWORD_EXPIRES_NAME",                    "Date Password Expires" },
        { "USER_DAYS_UNTIL_PASSWORD_EXPIRES_NAME",              "Days Until Password Expires" },
        { "USER_DEPARTMENT_NAME",                               "Department" },
        { "USER_DIGITAL_CERTIFICATE_INDICATOR_NAME",            "Digital Certificate Indicator" },
        { "USER_DISPLAY_SIGN_ON_INFORMATION_NAME",              "Display Sign-On Information" },
        { "USER_DISPLAY_SIGN_ON_INFORMATION_NO_NAME",           "No" },
        { "USER_DISPLAY_SIGN_ON_INFORMATION_SYSVAL_NAME",       "System Value" },
        { "USER_DISPLAY_SIGN_ON_INFORMATION_YES_NAME",          "Yes" },
        { "USER_FAX_TELEPHONE_NUMBER_NAME",                     "Fax Telephone Number" },
        { "USER_FIRST_NAME_NAME",                               "First Name" },
        { "USER_FULL_NAME_NAME",                                "Full Name" },
        { "USER_GROUP_AUTHORITY_NAME",                          "Group Authority" },
        { "USER_GROUP_AUTHORITY_ALL_NAME",                      "All" },
        { "USER_GROUP_AUTHORITY_CHANGE_NAME",                   "Change" },
        { "USER_GROUP_AUTHORITY_EXCLUDE_NAME",                  "Exclude" },
        { "USER_GROUP_AUTHORITY_NONE_NAME",                     "None" },
        { "USER_GROUP_AUTHORITY_TYPE_NAME",                     "Group Authority Type" },
        { "USER_GROUP_AUTHORITY_TYPE_PGP_NAME",                 "Primary Group" },
        { "USER_GROUP_AUTHORITY_TYPE_PRIVATE_NAME",             "Private" },
        { "USER_GROUP_AUTHORITY_USE_NAME",                      "Use" },
        { "USER_GROUP_ID_NUMBER_NAME",                          "Group ID Number" },
        { "USER_GROUP_MEMBER_INDICATOR_NAME",                   "Group Member Indicator" },
        { "USER_GROUP_PROFILE_NAME_NAME",                       "Group Profile Name" },
        { "USER_GROUP_PROFILE_NAME_NONE_NAME",                  "None" },
        { "USER_HIGHEST_SCHEDULING_PRIORITY_NAME",              "Highest Scheduling Priority" },
        { "USER_HOME_DIRECTORY_NAME",                           "Home Directory" },
        { "USER_INDIRECT_USER_NAME",                            "Indirect User" },
        { "USER_INITIAL_MENU_NAME",                             "Initial Menu" },
        { "USER_INITIAL_MENU_SIGNOFF_NAME",                     "Sign-Off" },
        { "USER_INITIAL_PROGRAM_NAME",                          "Initial Program" },
        { "USER_INITIAL_PROGRAM_NONE_NAME",                     "None" },
        { "USER_JOB_DESCRIPTION_NAME",                          "Job Description" },
        { "USER_JOB_TITLE_NAME",                                "Job Title" },
        { "USER_KEYBOARD_BUFFERING_NAME",                       "Keyboard Buffering" },
        { "USER_KEYBOARD_BUFFERING_NO_NAME",                    "No" },
        { "USER_KEYBOARD_BUFFERING_SYSVAL_NAME",                "System Value" },
        { "USER_KEYBOARD_BUFFERING_TYPEAHEAD_NAME",             "Type-Ahead" },
        { "USER_KEYBOARD_BUFFERING_YES_NAME",                   "Yes" },
        { "USER_LANGUAGE_ID_NAME",                              "Language ID" },
        { "USER_LANGUAGE_ID_SYSVAL_NAME",                       "System Value" },
        { "USER_LAST_NAME_NAME",                                "Last Name" },
        { "USER_LIMIT_CAPABILITIES_NAME",                       "Limit Capabilities" },
        { "USER_LIMIT_CAPABILITIES_NO_NAME",                    "No" },
        { "USER_LIMIT_CAPABILITIES_PARTIAL_NAME",               "Partial" },
        { "USER_LIMIT_CAPABILITIES_YES_NAME",                   "Yes" },
        { "USER_LIMIT_DEVICE_SESSIONS_NAME",                    "Limit Device Sessions" },
        { "USER_LIMIT_DEVICE_SESSIONS_NO_NAME",                 "No" },
        { "USER_LIMIT_DEVICE_SESSIONS_SYSVAL_NAME",             "System Value" },
        { "USER_LIMIT_DEVICE_SESSIONS_YES_NAME",                "Yes" },
        { "USER_LOCALE_JOB_ATTRIBUTES_NAME",                    "Locale Job Attributes" },
        { "USER_LOCALE_JOB_ATTRIBUTES_CCSID_NAME",              "CCSID" },
        { "USER_LOCALE_JOB_ATTRIBUTES_DATFMT_NAME",             "Date Format" },
        { "USER_LOCALE_JOB_ATTRIBUTES_DATSEP_NAME",             "Date Separator" },
        { "USER_LOCALE_JOB_ATTRIBUTES_DECFMT_NAME",             "Decimal Format" },
        { "USER_LOCALE_JOB_ATTRIBUTES_NONE_NAME",               "None" },
        { "USER_LOCALE_JOB_ATTRIBUTES_SRTSEQ_NAME",             "Sort Sequence" },
        { "USER_LOCALE_JOB_ATTRIBUTES_SYSVAL_NAME",             "System Value" },
        { "USER_LOCALE_JOB_ATTRIBUTES_TIMSEP_NAME",             "Time Separator" },
        { "USER_LOCALE_PATH_NAME_NAME",                         "Locale Path Name" },
        { "USER_LOCALE_PATH_NAME_C_NAME",                       "C" },
        { "USER_LOCALE_PATH_NAME_NONE_NAME",                    "None" },
        { "USER_LOCALE_PATH_NAME_POSIX_NAME",                   "POSIX" },
        { "USER_LOCALE_PATH_NAME_SYSVAL_NAME",                  "System Value" },
        { "USER_LOCAL_DATA_INDICATOR_NAME",                     "Local Data Indicator" },
        { "USER_LOCAL_DATA_INDICATOR_0_NAME",                   "Local" },
        { "USER_LOCAL_DATA_INDICATOR_1_NAME",                   "Shadowed" },
        { "USER_LOCATION_NAME",                                 "Location" },
        { "USER_MAILING_ADDRESS_LINE_1_NAME",                   "Mailing Address Line 1" },
        { "USER_MAILING_ADDRESS_LINE_2_NAME",                   "Mailing Address Line 2" },
        { "USER_MAILING_ADDRESS_LINE_3_NAME",                   "Mailing Address Line 3" },
        { "USER_MAILING_ADDRESS_LINE_4_NAME",                   "Mailing Address Line 4" },
        { "USER_MAIL_NOTIFICATION_NAME",                        "Mail Notification" },
        { "USER_MAIL_NOTIFICATION_ALLMAIL_NAME",                "All" },
        { "USER_MAIL_NOTIFICATION_NOMAIL_NAME",                 "None" },
        { "USER_MAIL_NOTIFICATION_SPECIFIC_NAME",               "Specific" },
        { "USER_MAIL_SERVER_FRAMEWORK_SERVICE_LEVEL_NAME",      "Mail Server Framework Service Level" },
        { "USER_MANAGER_CODE_NAME",                             "Manager Code" },
        { "USER_MAXIMUM_ALLOWED_STORAGE_NAME",                  "Maximum Allowed Storage" },
        { "USER_MESSAGE_NOTIFICATION_NAME",                     "Message Notification" },
        { "USER_MESSAGE_QUEUE_DELIVERY_METHOD_NAME",            "Message Queue Delivery Method" },
        { "USER_MESSAGE_QUEUE_DELIVERY_METHOD_BREAK_NAME",      "Break" },
        { "USER_MESSAGE_QUEUE_DELIVERY_METHOD_DFT_NAME",        "Default" },
        { "USER_MESSAGE_QUEUE_DELIVERY_METHOD_HOLD_NAME",       "Hold" },
        { "USER_MESSAGE_QUEUE_DELIVERY_METHOD_NOTIFY_NAME",     "Notify" },
        { "USER_MESSAGE_QUEUE_NAME",                            "Message Queue" },
        { "USER_MESSAGE_QUEUE_SEVERITY_NAME",                   "Message Queue Severity" },
        { "USER_MIDDLE_NAME_NAME",                              "Middle Name" },
        { "USER_NETWORK_USER_ID_NAME",                          "Network User ID" },
        { "USER_NO_PASSWORD_INDICATOR_NAME",                    "No Password Indicator" },
        { "USER_OBJECT_AUDITING_VALUE_NAME",                    "Object Auditing Value" },
        { "USER_OBJECT_AUDITING_VALUE_ALL_NAME",                "All" },
        { "USER_OBJECT_AUDITING_VALUE_CHANGE_NAME",             "Change" },
        { "USER_OBJECT_AUDITING_VALUE_NONE_NAME",               "None" },
        { "USER_OFFICE_NAME",                                   "Office Name" },
        { "USER_OR_NAME_NAME",                                  "O/R Name" },
        { "USER_OUTPUT_QUEUE_NAME",                             "Output Queue" },
        { "USER_OUTPUT_QUEUE_DEV_NAME",                         "Device" },
        { "USER_OUTPUT_QUEUE_WRKSTN_NAME",                      "Work Station" },
        { "USER_OWNER_NAME",                                    "Owner Name" },
        { "USER_OWNER_GRPPRF_NAME",                             "Group Profile" },
        { "USER_OWNER_USRPRF_NAME",                             "User Profile" },
        { "USER_PASSWORD_CHANGE_DATE_NAME",                     "Password Change Date" },
        { "USER_PASSWORD_EXPIRATION_INTERVAL_NAME",             "Password Expiration Interval" },
        { "USER_PREFERRED_ADDRESS_NAME",                        "Preferred Address" },
        { "USER_PREFERRED_NAME_NAME",                           "Preferred Name" },
        { "USER_PREVIOUS_SIGN_ON_NAME",                         "Previous Sign-On" },
        { "USER_PRINT_COVER_PAGE_NAME",                         "Print Cover Page" },
        { "USER_PRINT_DEVICE_NAME",                             "Print Device" },
        { "USER_PRINT_DEVICE_SYSVAL_NAME",                      "System Value" },
        { "USER_PRINT_DEVICE_WRKSTN_NAME",                      "Work Station" },
        { "USER_PRIORITY_MAIL_NOTIFICATION_NAME",               "Priority Mail Notification" },
        { "USER_SET_PASSWORD_TO_EXPIRE_NAME",                   "Set Password To Expire" },
        { "USER_SIGN_ON_ATTEMPTS_NOT_VALID_NAME",               "Sign-On Attempts Not Valid" },
        { "USER_SMTP_DOMAIN_NAME",                              "SMTP Domain" },
        { "USER_SMTP_ROUTE_NAME",                               "SMTP Route" },
        { "USER_SMTP_USER_ID_NAME",                             "SMTP User ID" },
        { "USER_SORT_SEQUENCE_TABLE_NAME",                      "Sort Sequence Table" },
        { "USER_SORT_SEQUENCE_TABLE_HEX_NAME",                  "Hex" },
        { "USER_SORT_SEQUENCE_TABLE_LANGIDSHR_NAME",            "Shared-Weight" },
        { "USER_SORT_SEQUENCE_TABLE_SYSVAL_NAME",               "System Value" },
        { "USER_SORT_SEQUENCE_TABLE_LANGIDUNQ_NAME",            "Unique-Weight" },
        { "USER_SPECIAL_AUTHORITIES_NAME",                      "Special Authorities" },
        { "USER_SPECIAL_AUTHORITIES_ALLOBJ_NAME",               "All Object" },
        { "USER_SPECIAL_AUTHORITIES_AUDIT_NAME",                "Audit" },
        { "USER_SPECIAL_AUTHORITIES_IOSYSCFG_NAME",             "I/O System Configuration" },
        { "USER_SPECIAL_AUTHORITIES_JOBCTL_NAME",               "Job Control" },
        { "USER_SPECIAL_AUTHORITIES_SAVSYS_NAME",               "Save System" },
        { "USER_SPECIAL_AUTHORITIES_SECADM_NAME",               "Security Administrator" },
        { "USER_SPECIAL_AUTHORITIES_SERVICE_NAME",              "Service" },
        { "USER_SPECIAL_AUTHORITIES_SPLCTL_NAME",               "Spool Control" },
        { "USER_SPECIAL_ENVIRONMENT_NAME",                      "Special Environment" },
        { "USER_SPECIAL_ENVIRONMENT_NONE_NAME",                 "None" },
        { "USER_SPECIAL_ENVIRONMENT_S36_NAME",                  "System/36" },
        { "USER_SPECIAL_ENVIRONMENT_SYSVAL_NAME",               "System Value" },
        { "USER_STATUS_NAME",                                   "Status" },
        { "USER_STATUS_DISABLED_NAME",                          "Not Enabled" },
        { "USER_STATUS_ENABLED_NAME",                           "Enabled" },
        { "USER_STORAGE_USED_NAME",                             "Storage Used" },
        { "USER_SUPPLEMENTAL_GROUPS_NAME",                      "Supplemental Groups" },
        { "USER_TELEPHONE_NUMBER_1_NAME",                       "Telephone Number 1" },
        { "USER_TELEPHONE_NUMBER_2_NAME",                       "Telephone Number 2" },
        { "USER_TEXT_NAME",                                     "Text" },
        { "USER_TEXT_DESCRIPTION_NAME",                         "Text Description" },
        { "USER_USER_ACTION_AUDIT_LEVEL_NAME",                  "User Action Audit Level" },
        { "USER_USER_ACTION_AUDIT_LEVEL_CMD_NAME",              "Command" },
        { "USER_USER_ACTION_AUDIT_LEVEL_CREATE_NAME",           "Create" },
        { "USER_USER_ACTION_AUDIT_LEVEL_DELETE_NAME",           "Delete" },
        { "USER_USER_ACTION_AUDIT_LEVEL_JOBDTA_NAME",           "Job Data" },
        { "USER_USER_ACTION_AUDIT_LEVEL_OBJMGT_NAME",           "Object Management" },
        { "USER_USER_ACTION_AUDIT_LEVEL_OFCSRV_NAME",           "Office Services" },
        { "USER_USER_ACTION_AUDIT_LEVEL_OPTICAL_NAME",          "Optical" },
        { "USER_USER_ACTION_AUDIT_LEVEL_PGMADP_NAME",           "Program Adoption" },
        { "USER_USER_ACTION_AUDIT_LEVEL_SAVRST_NAME",           "Save Restore" },
        { "USER_USER_ACTION_AUDIT_LEVEL_SECURITY_NAME",         "Security" },
        { "USER_USER_ACTION_AUDIT_LEVEL_SERVICE_NAME",          "Service" },
        { "USER_USER_ACTION_AUDIT_LEVEL_SPLFDTA_NAME",          "Spooled File Data" },
        { "USER_USER_ACTION_AUDIT_LEVEL_SYSMGT_NAME",           "System Management" },
        { "USER_USER_ADDRESS_NAME",                             "User Address" },
        { "USER_USER_CLASS_NAME",                               "User Class" },
        { "USER_USER_CLASS_PGMR_NAME",                          "Programmer" },
        { "USER_USER_CLASS_SECADM_NAME",                        "Security Administrator" },
        { "USER_USER_CLASS_SECOFR_NAME",                        "Security Officer" },
        { "USER_USER_CLASS_SYSOPR_NAME",                        "System Operator" },
        { "USER_USER_CLASS_USER_NAME",                          "User" },
        { "USER_USER_DESCRIPTION_NAME",                         "User Description" },
        { "USER_USER_ID_NAME",                                  "User ID" },
        { "USER_USER_ID_NUMBER_NAME",                           "User ID Number" },
        { "USER_USER_OPTIONS_NAME",                             "User Options" },
        { "USER_USER_OPTIONS_CLKWD_NAME",                       "CL Keywords" },
        { "USER_USER_OPTIONS_EXPERT_NAME",                      "Expert" },
        { "USER_USER_OPTIONS_HLPFULL_NAME",                     "Full Screen Help" },
        { "USER_USER_OPTIONS_NOSTSMSG_NAME",                    "No Status Message" },
        { "USER_USER_OPTIONS_PRTMSG_NAME",                      "Print Complete Message" },
        { "USER_USER_OPTIONS_ROLLKEY_NAME",                     "Roll Key" },
        { "USER_USER_OPTIONS_STSMSG_NAME",                      "Status Message" },
        { "USER_USER_PROFILE_NAME_NAME",                        "User Profile Name" },

        // #TRANNOTE #####################################################
        // #TRANNOTE User list component MRI.
        // #TRANNOTE #####################################################

        { "USER_LIST_NAME",                                     "User List" },
        { "USER_LIST_DESCRIPTION",                              "List of Users" },

        { "USER_LIST_GROUP_PROFILE_NAME",                       "Group Profile" },
        { "USER_LIST_GROUP_PROFILE_NOGROUP_NAME",               "No Group" },
        { "USER_LIST_GROUP_PROFILE_NONE_NAME",                  "None" },
        { "USER_LIST_SELECTION_CRITERIA_NAME",                  "Selection Criteria" },
        { "USER_LIST_SELECTION_CRITERIA_ALL_NAME",              "All" },
        { "USER_LIST_SELECTION_CRITERIA_GROUP_NAME",            "Group" },
        { "USER_LIST_SELECTION_CRITERIA_MEMBER_NAME",           "Member" },
        { "USER_LIST_SELECTION_CRITERIA_USER_NAME",             "User" },
        { "USER_LIST_USER_PROFILE_NAME",                        "User Profile" },
        { "USER_LIST_USER_PROFILE_ALL_NAME",                    "All" },



    };

}

