package skylake

const (
	EVENT_TEMP_CORE = 0x00
	UMASK_TEMP_CORE = 0x00

	EVENT_PWR_PKG_ENERGY = 0x02
	UMASK_PWR_PKG_ENERGY = 0x00

	EVENT_PWR_PP0_ENERGY = 0x01
	UMASK_PWR_PP0_ENERGY = 0x00

	EVENT_PWR_PP1_ENERGY = 0x04
	UMASK_PWR_PP1_ENERGY = 0x00

	EVENT_PWR_DRAM_ENERGY = 0x03
	UMASK_PWR_DRAM_ENERGY = 0x00

	EVENT_PWR_PLATFORM_ENERGY = 0x05
	UMASK_PWR_PLATFORM_ENERGY = 0x00

	EVENT_INSTR_RETIRED     = 0x00
	UMASK_INSTR_RETIRED_ANY = 0x00

	EVENT_CPU_CLK_UNHALTED      = 0x00
	UMASK_CPU_CLK_UNHALTED_CORE = 0x00
	UMASK_CPU_CLK_UNHALTED_REF  = 0x00

	EVENT_ICACHE_16B_IFDATA_STALL = 0x80
	UMASK_ICACHE_16B_IFDATA_STALL = 0x04

	EVENT_ICACHE_64B_IFTAG       = 0x83
	UMASK_ICACHE_64B_IFTAG_HIT   = 0x01
	UMASK_ICACHE_64B_IFTAG_MISS  = 0x02
	UMASK_ICACHE_64B_IFTAG_ALL   = 0x03
	UMASK_ICACHE_64B_IFTAG_STALL = 0x04

	EVENT_CPU_CLOCK_UNHALTED                   = 0x3C
	UMASK_CPU_CLOCK_UNHALTED_THREAD_P          = 0x00
	UMASK_CPU_CLOCK_UNHALTED_THREAD_P_ANY      = 0x00
	UMASK_CPU_CLOCK_UNHALTED_REF_XCLK          = 0x01
	UMASK_CPU_CLOCK_UNHALTED_REF_XCLK_ANY      = 0x01
	UMASK_CPU_CLOCK_UNHALTED_ONE_THREAD_ACTIVE = 0x02
	EVENT_OPTION_INVERT                        = 0x1
	UMASK_CPU_CLOCK_UNHALTED_TOTAL_CYCLES      = 0x00

	EVENT_BACLEARS     = 0xE6
	UMASK_BACLEARS_ANY = 0x01

	EVENT_ITLB_FLUSH = 0xAE
	UMASK_ITLB_FLUSH = 0x01

	EVENT_ILD_STALL_LCP = 0x87
	UMASK_ILD_STALL_LCP = 0x01

	EVENT_IDQ_UOPS_NOT_DELIVERED                            = 0x9C
	UMASK_IDQ_UOPS_NOT_DELIVERED_CORE                       = 0x01
	UMASK_IDQ_UOPS_NOT_DELIVERED_CYCLES_0_UOPS_DELIV_CORE   = 0x01
	UMASK_IDQ_UOPS_NOT_DELIVERED_CYCLES_LE_1_UOP_DELIV_CORE = 0x01
	UMASK_IDQ_UOPS_NOT_DELIVERED_CYCLES_LE_2_UOP_DELIV_CORE = 0x01
	UMASK_IDQ_UOPS_NOT_DELIVERED_CYCLES_LE_3_UOP_DELIV_CORE = 0x01
	UMASK_IDQ_UOPS_NOT_DELIVERED_CYCLES_FE_WAS_OK           = 0x01

	EVENT_DSB2MITE_SWITCHES_PENALTY_CYCLES = 0xAB
	UMASK_DSB2MITE_SWITCHES_PENALTY_CYCLES = 0x02

	EVENT_INT_MISC                      = 0x0D
	UMASK_INT_MISC_RECOVERY_CYCLES      = 0x01
	UMASK_INT_MISC_RECOVERY_COUNT       = 0x01
	UMASK_INT_MISC_RECOVERY_CYCLES_ANY  = 0x01
	EVENT_OPTION_EDGE                   = 1
	UMASK_INT_MISC_RECOVERY_COUNT_ANY   = 0x01
	UMASK_INT_MISC_CLEAR_RESTEER_CYCLES = 0x80
	UMASK_INT_MISC_CLEAR_RESTEER_COUNT  = 0x80

	EVENT_RESOURCE_STALLS     = 0xA2
	UMASK_RESOURCE_STALLS_ANY = 0x01
	UMASK_RESOURCE_STALLS_SB  = 0x08

	EVENT_PARTIAL_RAT_STALLS_SCOREBOARD = 0x59
	UMASK_PARTIAL_RAT_STALLS_SCOREBOARD = 0x01

	EVENT_UOPS_ISSUED                       = 0x0E
	UMASK_UOPS_ISSUED_ANY                   = 0x01
	UMASK_UOPS_ISSUED_VECTOR_WIDTH_MISMATCH = 0x02
	UMASK_UOPS_ISSUED_SLOW_LEA              = 0x20
	UMASK_UOPS_ISSUED_USED_CYCLES           = 0x01
	UMASK_UOPS_ISSUED_STALL_CYCLES          = 0x01
	UMASK_UOPS_ISSUED_TOTAL_CYCLES          = 0x01
	EVENT_OPTION_ANYTHREAD                  = 1
	UMASK_UOPS_ISSUED_CORE_USED_CYCLES      = 0x01
	UMASK_UOPS_ISSUED_CORE_STALL_CYCLES     = 0x01
	UMASK_UOPS_ISSUED_CORE_TOTAL_CYCLES     = 0x01
	UMASK_UOPS_ISSUED_CYCLES_GE_1_UOPS_EXEC = 0x01
	UMASK_UOPS_ISSUED_CYCLES_GE_2_UOPS_EXEC = 0x01
	UMASK_UOPS_ISSUED_CYCLES_GE_3_UOPS_EXEC = 0x01
	UMASK_UOPS_ISSUED_CYCLES_GE_4_UOPS_EXEC = 0x01
	UMASK_UOPS_ISSUED_CYCLES_GE_5_UOPS_EXEC = 0x01

	EVENT_TX_EXEC       = 0x5D
	UMASK_TX_EXEC_MISC1 = 0x01
	UMASK_TX_EXEC_MISC2 = 0x02
	UMASK_TX_EXEC_MISC3 = 0x04
	UMASK_TX_EXEC_MISC4 = 0x08
	UMASK_TX_EXEC_MISC5 = 0x10

	EVENT_RS_EVENTS_EMPTY        = 0x5E
	UMASK_RS_EVENTS_EMPTY_CYCLES = 0x01
	UMASK_RS_EVENTS_EMPTY_END    = 0x01

	EVENT_HLE_RETIRED                    = 0xC8
	UMASK_HLE_RETIRED_START              = 0x01
	UMASK_HLE_RETIRED_COMMIT             = 0x02
	UMASK_HLE_RETIRED_ABORTED            = 0x04
	UMASK_HLE_RETIRED_ABORTED_MEM        = 0x08
	UMASK_HLE_RETIRED_ABORTED_TIMER      = 0x10
	UMASK_HLE_RETIRED_ABORTED_UNFRIENDLY = 0x20
	UMASK_HLE_RETIRED_ABORTED_MEMTYPE    = 0x40
	UMASK_HLE_RETIRED_ABORTED_EVENTS     = 0x80

	EVENT_RTM_RETIRED                    = 0xC9
	UMASK_RTM_RETIRED_START              = 0x01
	UMASK_RTM_RETIRED_COMMIT             = 0x02
	UMASK_RTM_RETIRED_ABORTED            = 0x04
	UMASK_RTM_RETIRED_ABORTED_MEM        = 0x08
	UMASK_RTM_RETIRED_ABORTED_TIMER      = 0x10
	UMASK_RTM_RETIRED_ABORTED_UNFRIENDLY = 0x20
	UMASK_RTM_RETIRED_ABORTED_MEMTYPE    = 0x40
	UMASK_RTM_RETIRED_ABORTED_EVENTS     = 0x80

	EVENT_MACHINE_CLEARS                 = 0xC3
	UMASK_MACHINE_CLEARS_COUNT           = 0x01
	UMASK_MACHINE_CLEARS_MEMORY_ORDERING = 0x02
	UMASK_MACHINE_CLEARS_SMC             = 0x04

	EVENT_HW_INTERRUPTS_RECEIVED = 0xCB
	UMASK_HW_INTERRUPTS_RECEIVED = 0x01

	EVENT_INST_RETIRED     = 0xC0
	UMASK_INST_RETIRED_ANY = 0x00

	EVENT_UOPS_RETIRED                       = 0xC2
	UMASK_UOPS_RETIRED_ALL                   = 0x01
	UMASK_UOPS_RETIRED_CORE_ALL              = 0x01
	UMASK_UOPS_RETIRED_RETIRE_SLOTS          = 0x02
	UMASK_UOPS_RETIRED_USED_CYCLES           = 0x01
	UMASK_UOPS_RETIRED_STALL_CYCLES          = 0x01
	UMASK_UOPS_RETIRED_TOTAL_CYCLES          = 0x01
	UMASK_UOPS_RETIRED_CORE_RETIRE_SLOTS     = 0x02
	UMASK_UOPS_RETIRED_CORE_USED_CYCLES      = 0x01
	UMASK_UOPS_RETIRED_CORE_STALL_CYCLES     = 0x01
	UMASK_UOPS_RETIRED_CORE_TOTAL_CYCLES     = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_1_UOPS_EXEC = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_2_UOPS_EXEC = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_3_UOPS_EXEC = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_4_UOPS_EXEC = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_5_UOPS_EXEC = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_6_UOPS_EXEC = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_7_UOPS_EXEC = 0x01
	UMASK_UOPS_RETIRED_CYCLES_GE_8_UOPS_EXEC = 0x01

	EVENT_BR_INST_RETIRED              = 0xC4
	UMASK_BR_INST_RETIRED_ALL_BRANCHES = 0x00
	UMASK_BR_INST_RETIRED_CONDITIONAL  = 0x01
	UMASK_BR_INST_RETIRED_NEAR_CALL    = 0x02
	UMASK_BR_INST_RETIRED_NEAR_RETURN  = 0x08
	UMASK_BR_INST_RETIRED_NOT_TAKEN    = 0x10
	UMASK_BR_INST_RETIRED_NEAR_TAKEN   = 0x20
	UMASK_BR_INST_RETIRED_FAR_BRANCH   = 0x40

	EVENT_BR_MISP_RETIRED              = 0xC5
	UMASK_BR_MISP_RETIRED_ALL_BRANCHES = 0x00
	UMASK_BR_MISP_RETIRED_CONDITIONAL  = 0x01
	UMASK_BR_MISP_RETIRED_NEAR_TAKEN   = 0x20

	EVENT_FP_ARITH_INST_RETIRED                    = 0xC7
	UMASK_FP_ARITH_INST_RETIRED_SCALAR_DOUBLE      = 0x01
	UMASK_FP_ARITH_INST_RETIRED_SCALAR_SINGLE      = 0x02
	UMASK_FP_ARITH_INST_RETIRED_128B_PACKED_DOUBLE = 0x04
	UMASK_FP_ARITH_INST_RETIRED_128B_PACKED_SINGLE = 0x08
	UMASK_FP_ARITH_INST_RETIRED_256B_PACKED_DOUBLE = 0x10
	UMASK_FP_ARITH_INST_RETIRED_256B_PACKED_SINGLE = 0x20

	EVENT_FP_ASSIST_ANY = 0xCA
	UMASK_FP_ASSIST_ANY = 0x1E

	EVENT_MEM_INST_RETIRED                  = 0xD0
	UMASK_MEM_INST_RETIRED_STLB_MISS_LOADS  = 0x11
	UMASK_MEM_INST_RETIRED_STLB_MISS_STORES = 0x12
	UMASK_MEM_INST_RETIRED_LOCK_LOADS       = 0x21
	UMASK_MEM_INST_RETIRED_SPLIT_LOADS      = 0x41
	UMASK_MEM_INST_RETIRED_SPLIT_STORES     = 0x42
	UMASK_MEM_INST_RETIRED_ALL_LOADS        = 0x81
	UMASK_MEM_INST_RETIRED_ALL_STORES       = 0x82
	UMASK_MEM_INST_RETIRED_ALL              = 0x83

	EVENT_MEM_LOAD_RETIRED         = 0xD1
	UMASK_MEM_LOAD_RETIRED_L1_HIT  = 0x01
	UMASK_MEM_LOAD_RETIRED_L2_HIT  = 0x02
	UMASK_MEM_LOAD_RETIRED_L3_HIT  = 0x04
	UMASK_MEM_LOAD_RETIRED_L1_MISS = 0x08
	UMASK_MEM_LOAD_RETIRED_L2_MISS = 0x10
	UMASK_MEM_LOAD_RETIRED_L3_MISS = 0x20
	UMASK_MEM_LOAD_RETIRED_FB_HIT  = 0x40
	UMASK_MEM_LOAD_RETIRED_L1_ALL  = 0x09
	UMASK_MEM_LOAD_RETIRED_L2_ALL  = 0x12
	UMASK_MEM_LOAD_RETIRED_L3_ALL  = 0x24

	EVENT_MEM_LOAD_L3_HIT_RETIRED           = 0xD2
	UMASK_MEM_LOAD_L3_HIT_RETIRED_XSNP_MISS = 0x01
	UMASK_MEM_LOAD_L3_HIT_RETIRED_XSNP_HIT  = 0x02
	UMASK_MEM_LOAD_L3_HIT_RETIRED_XSNP_HITM = 0x04
	UMASK_MEM_LOAD_L3_HIT_RETIRED_XSNP_NONE = 0x08

	EVENT_FRONTEND_RETIRED = 0xC6
	//UMASK_FRONTEND_RETIRED_DSB_MISS=0x01 0x00 0x11
	//UMASK_FRONTEND_RETIRED_L1I_MISS=0x01 0x00 0x12
	//UMASK_FRONTEND_RETIRED_L2_MISS=0x01 0x00 0x13
	//UMASK_FRONTEND_RETIRED_ITLB_MISS=0x01 0x00 0x14
	//UMASK_FRONTEND_RETIRED_STLB_MISS=0x01 0x00 0x15
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_2=0x01 0x00 0x400206
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_2_BUBBLES_GE_2=0x01 0x00 0x200206
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_4=0x01 0x00 0x400406

	EVENT_UOPS_EXECUTED                            = 0xB1
	UMASK_UOPS_EXECUTED_THREAD                     = 0x01
	UMASK_UOPS_EXECUTED_USED_CYCLES                = 0x01
	UMASK_UOPS_EXECUTED_STALL_CYCLES               = 0x01
	UMASK_UOPS_EXECUTED_TOTAL_CYCLES               = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_1_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_2_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_3_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_4_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_5_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_6_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_7_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CYCLES_GE_8_UOPS_EXEC      = 0x01
	UMASK_UOPS_EXECUTED_CORE                       = 0x02
	UMASK_UOPS_EXECUTED_CORE_USED_CYCLES           = 0x02
	UMASK_UOPS_EXECUTED_CORE_STALL_CYCLES          = 0x02
	UMASK_UOPS_EXECUTED_CORE_TOTAL_CYCLES          = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_1_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_2_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_3_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_4_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_5_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_6_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_7_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_CORE_CYCLES_GE_8_UOPS_EXEC = 0x02
	UMASK_UOPS_EXECUTED_X87                        = 0x10

	EVENT_EXE_ACTIVITY                   = 0xA6
	UMASK_EXE_ACTIVITY_EXE_BOUND_0_PORTS = 0x01
	UMASK_EXE_ACTIVITY_1_PORTS_UTIL      = 0x02
	UMASK_EXE_ACTIVITY_2_PORTS_UTIL      = 0x04
	UMASK_EXE_ACTIVITY_3_PORTS_UTIL      = 0x08
	UMASK_EXE_ACTIVITY_4_PORTS_UTIL      = 0x10
	UMASK_EXE_ACTIVITY_BOUND_ON_STORES   = 0x40

	EVENT_UOPS_DISPATCHED_PORT                  = 0xA1
	UMASK_UOPS_DISPATCHED_PORT_PORT_0           = 0x01
	UMASK_UOPS_DISPATCHED_PORT_PORT_1           = 0x02
	UMASK_UOPS_DISPATCHED_PORT_PORT_2           = 0x04
	UMASK_UOPS_DISPATCHED_PORT_PORT_3           = 0x08
	UMASK_UOPS_DISPATCHED_PORT_PORT_4           = 0x10
	UMASK_UOPS_DISPATCHED_PORT_PORT_5           = 0x20
	UMASK_UOPS_DISPATCHED_PORT_PORT_6           = 0x40
	UMASK_UOPS_DISPATCHED_PORT_PORT_7           = 0x80
	UMASK_UOPS_DISPATCHED_PORT_ARITH_PORTS      = 0x63
	UMASK_UOPS_DISPATCHED_PORT_ARITH_PORTS_CORE = 0x63
	UMASK_UOPS_DISPATCHED_PORT_DATA_PORTS       = 0x9C

	EVENT_CYCLE_ACTIVITY                    = 0xA3
	UMASK_CYCLE_ACTIVITY_STALLS_TOTAL       = 0x04
	UMASK_CYCLE_ACTIVITY_CYCLES_NO_EXECUTE  = 0x04
	UMASK_CYCLE_ACTIVITY_CYCLES_L2_MISS     = 0x01
	UMASK_CYCLE_ACTIVITY_STALLS_L2_MISS     = 0x05
	UMASK_CYCLE_ACTIVITY_CYCLES_L2_PENDING  = 0x01
	UMASK_CYCLE_ACTIVITY_STALLS_L2_PENDING  = 0x05
	UMASK_CYCLE_ACTIVITY_CYCLES_L3_MISS     = 0x02
	UMASK_CYCLE_ACTIVITY_STALLS_L3_MISS     = 0x06
	UMASK_CYCLE_ACTIVITY_CYCLES_L3_PENDING  = 0x02
	UMASK_CYCLE_ACTIVITY_STALLS_L3_PENDING  = 0x06
	UMASK_CYCLE_ACTIVITY_CYCLES_MEM_ANY     = 0x10
	UMASK_CYCLE_ACTIVITY_STALLS_MEM_ANY     = 0x14
	UMASK_CYCLE_ACTIVITY_CYCLES_LDM_PENDING = 0x10
	UMASK_CYCLE_ACTIVITY_STALLS_LDM_PENDING = 0x14

	EVENT_CYCLE_ACTIVITY_CYCLES_L1D_MISS = 0xA3
	UMASK_CYCLE_ACTIVITY_CYCLES_L1D_MISS = 0x08

	EVENT_CYCLE_ACTIVITY_STALLS_L1D_MISS = 0xA3
	UMASK_CYCLE_ACTIVITY_STALLS_L1D_MISS = 0x0C

	EVENT_CYCLE_ACTIVITY_CYCLES_L1D_PENDING = 0xA3
	UMASK_CYCLE_ACTIVITY_CYCLES_L1D_PENDING = 0x08

	EVENT_CYCLE_ACTIVITY_STALLS_L1D_PENDING = 0xA3
	UMASK_CYCLE_ACTIVITY_STALLS_L1D_PENDING = 0x0C

	EVENT_EPT_WALK_PENDING = 0x4F
	UMASK_EPT_WALK_PENDING = 0x10

	EVENT_ITLB_MISSES               = 0x85
	UMASK_ITLB_MISSES_CAUSES_A_WALK = 0x01

	UMASK_ITLB_MISSES_WALK_PENDING         = 0x10
	UMASK_ITLB_MISSES_STLB_HIT             = 0x20
	UMASK_ITLB_MISSES_WALK_COMPLETED       = 0x0E
	UMASK_ITLB_MISSES_WALK_COMPLETED_4K    = 0x02
	UMASK_ITLB_MISSES_WALK_COMPLETED_2M_4M = 0x04
	UMASK_ITLB_MISSES_WALK_COMPLETED_1G    = 0x08
	UMASK_ITLB_MISSES_WALK_ACTIVE          = 0x10

	EVENT_DTLB_LOAD_MISSES                      = 0x08
	UMASK_DTLB_LOAD_MISSES_CAUSES_A_WALK        = 0x01
	UMASK_DTLB_LOAD_MISSES_WALK_PENDING         = 0x10
	UMASK_DTLB_LOAD_MISSES_STLB_HIT             = 0x20
	UMASK_DTLB_LOAD_MISSES_WALK_COMPLETED       = 0x0E
	UMASK_DTLB_LOAD_MISSES_WALK_COMPLETED_4K    = 0x02
	UMASK_DTLB_LOAD_MISSES_WALK_COMPLETED_2M_4M = 0x04
	UMASK_DTLB_LOAD_MISSES_WALK_COMPLETED_1G    = 0x08
	UMASK_DTLB_LOAD_MISSES_WALK_ACTIVE          = 0x10

	EVENT_DTLB_STORE_MISSES                      = 0x49
	UMASK_DTLB_STORE_MISSES_CAUSES_A_WALK        = 0x01
	UMASK_DTLB_STORE_MISSES_WALK_PENDING         = 0x10
	UMASK_DTLB_STORE_MISSES_STLB_HIT             = 0x20
	UMASK_DTLB_STORE_MISSES_WALK_COMPLETED       = 0x0E
	UMASK_DTLB_STORE_MISSES_WALK_COMPLETED_4K    = 0x02
	UMASK_DTLB_STORE_MISSES_WALK_COMPLETED_2M_4M = 0x04
	UMASK_DTLB_STORE_MISSES_WALK_COMPLETED_1G    = 0x08
	UMASK_DTLB_STORE_MISSES_WALK_ACTIVE          = 0x10

	EVENT_TLB_FLUSH             = 0xBD
	UMASK_TLB_FLUSH_DTLB_THREAD = 0x01
	UMASK_TLB_FLUSH_STLB_ANY    = 0x20

	EVENT_L1D             = 0x51
	UMASK_L1D_REPLACEMENT = 0x01
	UMASK_L1D_M_EVICT     = 0x04

	EVENT_TX_MEM                                                = 0x54
	UMASK_TX_MEM_ABORT_CONFLICT                                 = 0x01
	UMASK_TX_MEM_ABORT_CAPACITY                                 = 0x02
	UMASK_TX_MEM_ABORT_HLE_STORE_TO_ELIDED_LOCK                 = 0x04
	UMASK_TX_MEM_ABORT_HLE_ELISION_BUFFER_NOT_EMPTY             = 0x08
	UMASK_TX_MEM_ABORT_HLE_ELISION_BUFFER_MISMATCH              = 0x10
	UMASK_TX_MEM_ABORT_HLE_ELISION_BUFFER_UNSUPPORTED_ALIGNMENT = 0x20
	UMASK_TX_MEM_HLE_ELISION_BUFFER_FULL                        = 0x40

	EVENT_L1D_PEND_MISS                    = 0x48
	UMASK_L1D_PEND_MISS_PENDING            = 0x01
	UMASK_L1D_PEND_MISS_FB_FULL            = 0x02
	UMASK_L1D_PEND_MISS_PENDING_CYCLES     = 0x01
	UMASK_L1D_PEND_MISS_PENDING_CYCLES_ANY = 0x01

	EVENT_LOAD_HIT_PRE_SW_PF = 0x4C
	UMASK_LOAD_HIT_PRE_SW_PF = 0x01

	EVENT_LOCK_CYCLES_CACHE_LOCK          = 0x63
	UMASK_LOCK_CYCLES_CACHE_LOCK_DURATION = 0x02
	UMASK_LOCK_CYCLES_CACHE_LOCK_COUNT    = 0x02

	EVENT_LD_BLOCKS               = 0x03
	UMASK_LD_BLOCKS_STORE_FORWARD = 0x02
	UMASK_LD_BLOCKS_NO_SR         = 0x08

	EVENT_LD_BLOCKS_PARTIAL_ADDRESS_ALIAS = 0x07
	UMASK_LD_BLOCKS_PARTIAL_ADDRESS_ALIAS = 0x01

	EVENT_OFFCORE_REQUESTS                        = 0xB0
	UMASK_OFFCORE_REQUESTS_DEMAND_DATA_RD         = 0x01
	UMASK_OFFCORE_REQUESTS_DEMAND_CODE_RD         = 0x02
	UMASK_OFFCORE_REQUESTS_DEMAND_RFO             = 0x04
	UMASK_OFFCORE_REQUESTS_ALL_DATA_RD            = 0x08
	UMASK_OFFCORE_REQUESTS_L3_MISS_DEMAND_DATA_RD = 0x10
	UMASK_OFFCORE_REQUESTS_ALL_REQUESTS           = 0x80

	EVENT_OFFCORE_REQUESTS_OUTSTANDING                                    = 0x60
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_DEMAND_DATA_RD                     = 0x01
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_DEMAND_DATA_RD_GE_6                = 0x01
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_DEMAND_CODE_RD                     = 0x02
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_DEMAND_RFO                         = 0x04
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_ALL_DATA_RD                        = 0x08
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_L3_MISS_DEMAND_DATA_RD             = 0x10
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_CYCLES_WITH_DEMAND_DATA_RD         = 0x01
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_CYCLES_WITH_DATA_RD                = 0x08
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_CYCLES_WITH_DEMAND_CODE_RD         = 0x02
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_CYCLES_WITH_DEMAND_RFO             = 0x04
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_CYCLES_WITH_L3_MISS_DEMAND_DATA_RD = 0x10
	UMASK_OFFCORE_REQUESTS_OUTSTANDING_L3_MISS_DEMAND_DATA_RD_GE_6        = 0x10

	EVENT_OFFCORE_REQUESTS_BUFFER_SQ_FULL = 0xB2
	UMASK_OFFCORE_REQUESTS_BUFFER_SQ_FULL = 0x01

	EVENT_L2_TRANS                = 0xF0
	UMASK_L2_TRANS_DEMAND_DATA_RD = 0x01
	UMASK_L2_TRANS_RFO            = 0x02
	UMASK_L2_TRANS_CODE_RD        = 0x04
	UMASK_L2_TRANS_ALL_PF         = 0x08
	UMASK_L2_TRANS_L1D_WB         = 0x10
	UMASK_L2_TRANS_L2_FILL        = 0x20
	UMASK_L2_TRANS_L2_WB          = 0x40
	UMASK_L2_TRANS_ALL_REQUESTS   = 0x80

	EVENT_LONGEST_LAT_CACHE           = 0x2E
	UMASK_LONGEST_LAT_CACHE_MISS      = 0x41
	UMASK_LONGEST_LAT_CACHE_REFERENCE = 0x4F

	EVENT_L2_RQSTS                       = 0x24
	UMASK_L2_RQSTS_DEMAND_DATA_RD_MISS   = 0x21
	UMASK_L2_RQSTS_DEMAND_DATA_RD_HIT    = 0x41
	UMASK_L2_RQSTS_ALL_DEMAND_DATA_RD    = 0xE1
	UMASK_L2_RQSTS_ALL_RFO               = 0xE2
	UMASK_L2_RQSTS_ALL_CODE_RD           = 0xE4
	UMASK_L2_RQSTS_ALL_PF                = 0xF8
	UMASK_L2_RQSTS_PF_MISS               = 0x38
	UMASK_L2_RQSTS_PF_HIT                = 0xD8
	UMASK_L2_RQSTS_RFO_HIT               = 0x42
	UMASK_L2_RQSTS_RFO_MISS              = 0x22
	UMASK_L2_RQSTS_CODE_RD_HIT           = 0x44
	UMASK_L2_RQSTS_CODE_RD_MISS          = 0x24
	UMASK_L2_RQSTS_ALL_DEMAND_MISS       = 0x27
	UMASK_L2_RQSTS_ALL_DEMAND_REFERENCES = 0xE7
	UMASK_L2_RQSTS_MISS                  = 0x3F
	UMASK_L2_RQSTS_REFERENCES            = 0xFF

	EVENT_IDQ                          = 0x79
	UMASK_IDQ_MITE_UOPS                = 0x04
	UMASK_IDQ_DSB_UOPS                 = 0x08
	UMASK_IDQ_MS_DSB_UOPS              = 0x10
	UMASK_IDQ_MS_MITE_UOPS             = 0x20
	UMASK_IDQ_MS_UOPS                  = 0x30
	UMASK_IDQ_MITE_CYCLES              = 0x04
	UMASK_IDQ_MITE_CYCLES_1_UOPS       = 0x04
	UMASK_IDQ_MITE_CYCLES_2_UOPS       = 0x04
	UMASK_IDQ_MITE_CYCLES_3_UOPS       = 0x04
	UMASK_IDQ_MITE_CYCLES_4_UOPS       = 0x04
	UMASK_IDQ_MITE_CYCLES_5_UOPS       = 0x04
	UMASK_IDQ_MITE_CYCLES_6_UOPS       = 0x04
	UMASK_IDQ_DSB_CYCLES               = 0x08
	UMASK_IDQ_DSB_CYCLES_1_UOPS        = 0x08
	UMASK_IDQ_DSB_CYCLES_2_UOPS        = 0x08
	UMASK_IDQ_DSB_CYCLES_3_UOPS        = 0x08
	UMASK_IDQ_DSB_CYCLES_4_UOPS        = 0x08
	UMASK_IDQ_DSB_CYCLES_5_UOPS        = 0x08
	UMASK_IDQ_DSB_CYCLES_6_UOPS        = 0x08
	UMASK_IDQ_MS_DSB_CYCLES            = 0x10
	UMASK_IDQ_MS_DSB_CYCLES_1_UOPS     = 0x10
	UMASK_IDQ_MS_DSB_CYCLES_2_UOPS     = 0x10
	UMASK_IDQ_MS_DSB_CYCLES_3_UOPS     = 0x10
	UMASK_IDQ_MS_DSB_CYCLES_4_UOPS     = 0x10
	UMASK_IDQ_MS_DSB_CYCLES_5_UOPS     = 0x10
	UMASK_IDQ_MS_DSB_CYCLES_6_UOPS     = 0x10
	UMASK_IDQ_MS_DSB_OCCUR             = 0x10
	UMASK_IDQ_MS_MITE_CYCLES           = 0x20
	UMASK_IDQ_MS_MITE_CYCLES_1_UOPS    = 0x20
	UMASK_IDQ_MS_MITE_CYCLES_2_UOPS    = 0x20
	UMASK_IDQ_MS_MITE_CYCLES_3_UOPS    = 0x20
	UMASK_IDQ_MS_MITE_CYCLES_4_UOPS    = 0x20
	UMASK_IDQ_MS_MITE_CYCLES_5_UOPS    = 0x20
	UMASK_IDQ_MS_MITE_CYCLES_6_UOPS    = 0x20
	UMASK_IDQ_MS_CYCLES                = 0x30
	UMASK_IDQ_MS_CYCLES_1_UOPS         = 0x30
	UMASK_IDQ_MS_CYCLES_2_UOPS         = 0x30
	UMASK_IDQ_MS_CYCLES_3_UOPS         = 0x30
	UMASK_IDQ_MS_CYCLES_4_UOPS         = 0x30
	UMASK_IDQ_MS_CYCLES_5_UOPS         = 0x30
	UMASK_IDQ_MS_CYCLES_6_UOPS         = 0x30
	UMASK_IDQ_MS_SWITCHES              = 0x30
	UMASK_IDQ_ALL_DSB_CYCLES_ANY_UOPS  = 0x18
	UMASK_IDQ_ALL_DSB_CYCLES_1_UOPS    = 0x18
	UMASK_IDQ_ALL_DSB_CYCLES_2_UOPS    = 0x18
	UMASK_IDQ_ALL_DSB_CYCLES_3_UOPS    = 0x18
	UMASK_IDQ_ALL_DSB_CYCLES_4_UOPS    = 0x18
	UMASK_IDQ_ALL_DSB_CYCLES_5_UOPS    = 0x18
	UMASK_IDQ_ALL_DSB_CYCLES_6_UOPS    = 0x18
	UMASK_IDQ_ALL_MITE_CYCLES_ANY_UOPS = 0x24
	UMASK_IDQ_ALL_MITE_CYCLES_1_UOPS   = 0x24
	UMASK_IDQ_ALL_MITE_CYCLES_2_UOPS   = 0x24
	UMASK_IDQ_ALL_MITE_CYCLES_3_UOPS   = 0x24
	UMASK_IDQ_ALL_MITE_CYCLES_4_UOPS   = 0x24
	UMASK_IDQ_ALL_MITE_CYCLES_5_UOPS   = 0x24
	UMASK_IDQ_ALL_MITE_CYCLES_6_UOPS   = 0x24
	UMASK_IDQ_ALL_CYCLES_ANY_UOPS      = 0x3C
	UMASK_IDQ_ALL_CYCLES_1_UOPS        = 0x3C
	UMASK_IDQ_ALL_CYCLES_2_UOPS        = 0x3C
	UMASK_IDQ_ALL_CYCLES_3_UOPS        = 0x3C
	UMASK_IDQ_ALL_CYCLES_4_UOPS        = 0x3C
	UMASK_IDQ_ALL_CYCLES_5_UOPS        = 0x3C
	UMASK_IDQ_ALL_CYCLES_6_UOPS        = 0x3C

	EVENT_L2_LINES_IN     = 0xF1
	UMASK_L2_LINES_IN_I   = 0x01
	UMASK_L2_LINES_IN_S   = 0x02
	UMASK_L2_LINES_IN_E   = 0x04
	UMASK_L2_LINES_IN_ALL = 0x07

	EVENT_L2_LINES_OUT              = 0xF2
	UMASK_L2_LINES_OUT_SILENT       = 0x01
	UMASK_L2_LINES_OUT_NON_SILENT   = 0x02
	UMASK_L2_LINES_OUT_USELESS_PREF = 0x04

	EVENT_ARITH_DIVIDER        = 0x14
	UMASK_ARITH_DIVIDER_ACTIVE = 0x01
	UMASK_ARITH_DIVIDER_COUNT  = 0x01

	EVENT_LSD_UOPS                 = 0xA8
	UMASK_LSD_UOPS                 = 0x01
	UMASK_LSD_UOPS_CYCLES_1        = 0x01
	UMASK_LSD_UOPS_CYCLES_2        = 0x01
	UMASK_LSD_UOPS_CYCLES_3        = 0x01
	UMASK_LSD_UOPS_CYCLES_4        = 0x01
	UMASK_LSD_UOPS_CYCLES_ACTIVE   = 0x01
	UMASK_LSD_UOPS_CYCLES_INACTIVE = 0x01

	EVENT_OTHER_ASSISTS_ANY = 0xC1
	UMASK_OTHER_ASSISTS_ANY = 0x3F

	EVENT_FRONTEND_RETIRED_LATENCY = 0xC6

	//UMASK_FRONTEND_RETIRED_LATENCY_GE_8=0x01 0x00 0x400806
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_16=0x01 0x00 0x401006
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_32=0x01 0x00 0x402006
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_64=0x01 0x00 0x404006
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_128=0x01 0x00 0x408006
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_256=0x01 0x00 0x410006
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_512=0x01 0x00 0x420006
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_2_BUBBLES_GE_1=0x01 0x00 0x100206
	//UMASK_FRONTEND_RETIRED_LATENCY_GE_2_BUBBLES_GE_3=0x01 0x00 0x300206

	EVENT_OFFCORE_RESPONSE_0 = 0xB7
	EVENT_OFFCORE_RESPONSE_1 = 0xBB

	EVENT_CACHE_LOOKUP                    = 0x34
	UMASK_CACHE_LOOKUP_M                  = 0x01
	UMASK_CACHE_LOOKUP_E                  = 0x02
	UMASK_CACHE_LOOKUP_S                  = 0x04
	UMASK_CACHE_LOOKUP_I                  = 0x08
	UMASK_CACHE_LOOKUP_READ_FILTER        = 0x10
	UMASK_CACHE_LOOKUP_WRITE_FILTER       = 0x20
	UMASK_CACHE_LOOKUP_EXTSNP_FILTER      = 0x40
	UMASK_CACHE_LOOKUP_ANY_REQUEST_FILTER = 0x80
	UMASK_CACHE_LOOKUP_READ_M             = 0x11
	UMASK_CACHE_LOOKUP_WRITE_M            = 0x21
	UMASK_CACHE_LOOKUP_EXTSNP_M           = 0x41
	UMASK_CACHE_LOOKUP_ANY_M              = 0x81
	UMASK_CACHE_LOOKUP_READ_E             = 0x12
	UMASK_CACHE_LOOKUP_WRITE_E            = 0x22
	UMASK_CACHE_LOOKUP_EXTSNP_E           = 0x42
	UMASK_CACHE_LOOKUP_ANY_E              = 0x82
	UMASK_CACHE_LOOKUP_READ_S             = 0x14
	UMASK_CACHE_LOOKUP_WRITE_S            = 0x24
	UMASK_CACHE_LOOKUP_EXTSNP_S           = 0x44
	UMASK_CACHE_LOOKUP_ANY_S              = 0x84
	UMASK_CACHE_LOOKUP_READ_ES            = 0x16
	UMASK_CACHE_LOOKUP_WRITE_ES           = 0x26
	UMASK_CACHE_LOOKUP_EXTSNP_ES          = 0x46
	UMASK_CACHE_LOOKUP_ANY_ES             = 0x86
	UMASK_CACHE_LOOKUP_READ_I             = 0x18
	UMASK_CACHE_LOOKUP_WRITE_I            = 0x28
	UMASK_CACHE_LOOKUP_EXTSNP_I           = 0x48
	UMASK_CACHE_LOOKUP_ANY_I              = 0x88
	UMASK_CACHE_LOOKUP_READ_MESI          = 0x1F
	UMASK_CACHE_LOOKUP_WRITE_MESI         = 0x2F
	UMASK_CACHE_LOOKUP_EXTSNP_MESI        = 0x4F
	UMASK_CACHE_LOOKUP_ANY_MESI           = 0x8F

	EVENT_XSNP_RESPONSE               = 0x22
	UMASK_XSNP_RESPONSE_MISS_EXTERNAL = 0x21
	UMASK_XSNP_RESPONSE_MISS_XCORE    = 0x41
	UMASK_XSNP_RESPONSE_MISS_EVICTION = 0x81
	UMASK_XSNP_RESPONSE_HIT_EXTERNAL  = 0x24
	UMASK_XSNP_RESPONSE_HIT_XCORE     = 0x44
	UMASK_XSNP_RESPONSE_HIT_EVICTION  = 0x84
	UMASK_XSNP_RESPONSE_HITM_EXTERNAL = 0x28
	UMASK_XSNP_RESPONSE_HITM_XCORE    = 0x48
	UMASK_XSNP_RESPONSE_HITM_EVICTION = 0x88

	EVENT_TRK_OCCUPANCY_ALL = 0x80
	UMASK_TRK_OCCUPANCY_ALL = 0x01

	EVENT_TRK_REQUESTS        = 0x81
	UMASK_TRK_REQUESTS_ALL    = 0x01
	UMASK_TRK_REQUESTS_WRITES = 0x20

	EVENT_COH_TRK_OCCUPANCY = 0x83
	UMASK_COH_TRK_OCCUPANCY = 0x01

	EVENT_COH_TRK_REQUESTS     = 0x84
	UMASK_COH_TRK_REQUESTS_ALL = 0x01

	EVENT_UNCORE_CLOCK = 0x00
	UMASK_UNCORE_CLOCK = 0x01

	EVENT_IO_REQUESTS = 0x00
	UMASK_IO_REQUESTS = 0x00

	EVENT_DRAM_READS = 0x01
	UMASK_DRAM_READS = 0x01

	EVENT_DRAM_WRITES = 0x02
	UMASK_DRAM_WRITES = 0x02

	EVENT_PP0_TEMP = 0x00
	UMASK_PP0_TEMP = 0x00

	EVENT_PP1_TEMP = 0x01
	UMASK_PP1_TEMP = 0x01

	EVENT_VOLTAGE_CORE = 0x00
	UMASK_VOLTAGE_CORE = 0x00
)
