//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridcontainerservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AADProfile.
func (a AADProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminGroupObjectIDs", a.AdminGroupObjectIDs)
	populate(objectMap, "clientAppID", a.ClientAppID)
	populate(objectMap, "enableAzureRbac", a.EnableAzureRbac)
	populate(objectMap, "managed", a.Managed)
	populate(objectMap, "serverAppID", a.ServerAppID)
	populate(objectMap, "serverAppSecret", a.ServerAppSecret)
	populate(objectMap, "tenantID", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADProfile.
func (a *AADProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminGroupObjectIDs":
			err = unpopulate(val, "AdminGroupObjectIDs", &a.AdminGroupObjectIDs)
			delete(rawMsg, key)
		case "clientAppID":
			err = unpopulate(val, "ClientAppID", &a.ClientAppID)
			delete(rawMsg, key)
		case "enableAzureRbac":
			err = unpopulate(val, "EnableAzureRbac", &a.EnableAzureRbac)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, "Managed", &a.Managed)
			delete(rawMsg, key)
		case "serverAppID":
			err = unpopulate(val, "ServerAppID", &a.ServerAppID)
			delete(rawMsg, key)
		case "serverAppSecret":
			err = unpopulate(val, "ServerAppSecret", &a.ServerAppSecret)
			delete(rawMsg, key)
		case "tenantID":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AADProfileResponse.
func (a AADProfileResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminGroupObjectIDs", a.AdminGroupObjectIDs)
	populate(objectMap, "clientAppID", a.ClientAppID)
	populate(objectMap, "enableAzureRbac", a.EnableAzureRbac)
	populate(objectMap, "managed", a.Managed)
	populate(objectMap, "serverAppID", a.ServerAppID)
	populate(objectMap, "tenantID", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADProfileResponse.
func (a *AADProfileResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminGroupObjectIDs":
			err = unpopulate(val, "AdminGroupObjectIDs", &a.AdminGroupObjectIDs)
			delete(rawMsg, key)
		case "clientAppID":
			err = unpopulate(val, "ClientAppID", &a.ClientAppID)
			delete(rawMsg, key)
		case "enableAzureRbac":
			err = unpopulate(val, "EnableAzureRbac", &a.EnableAzureRbac)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, "Managed", &a.Managed)
			delete(rawMsg, key)
		case "serverAppID":
			err = unpopulate(val, "ServerAppID", &a.ServerAppID)
			delete(rawMsg, key)
		case "tenantID":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddonProfiles.
func (a AddonProfiles) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "config", a.Config)
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddonProfiles.
func (a *AddonProfiles) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "config":
			err = unpopulate(val, "Config", &a.Config)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddonStatus.
func (a AddonStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorMessage", a.ErrorMessage)
	populate(objectMap, "phase", a.Phase)
	populate(objectMap, "ready", a.Ready)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddonStatus.
func (a *AddonStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &a.ErrorMessage)
			delete(rawMsg, key)
		case "phase":
			err = unpopulate(val, "Phase", &a.Phase)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &a.Ready)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPool.
func (a AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", a.ExtendedLocation)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPool.
func (a *AgentPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &a.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolExtendedLocation.
func (a AgentPoolExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", a.Name)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolExtendedLocation.
func (a *AgentPoolExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolListResult.
func (a AgentPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolListResult.
func (a *AgentPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProperties.
func (a AgentPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availabilityZones", a.AvailabilityZones)
	populate(objectMap, "cloudProviderProfile", a.CloudProviderProfile)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "maxCount", a.MaxCount)
	populate(objectMap, "maxPods", a.MaxPods)
	populate(objectMap, "minCount", a.MinCount)
	populate(objectMap, "mode", a.Mode)
	populate(objectMap, "nodeImageVersion", a.NodeImageVersion)
	populate(objectMap, "nodeLabels", a.NodeLabels)
	populate(objectMap, "nodeTaints", a.NodeTaints)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "vmSize", a.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProperties.
func (a *AgentPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &a.AvailabilityZones)
			delete(rawMsg, key)
		case "cloudProviderProfile":
			err = unpopulate(val, "CloudProviderProfile", &a.CloudProviderProfile)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &a.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &a.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &a.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &a.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &a.NodeLabels)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &a.NodeTaints)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &a.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProvisioningStatusError.
func (a AgentPoolProvisioningStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", a.Code)
	populate(objectMap, "message", a.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProvisioningStatusError.
func (a *AgentPoolProvisioningStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProvisioningStatusStatus.
func (a AgentPoolProvisioningStatusStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorMessage", a.ErrorMessage)
	populate(objectMap, "provisioningStatus", a.ProvisioningStatus)
	populate(objectMap, "readyReplicas", a.ReadyReplicas)
	populate(objectMap, "replicas", a.Replicas)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProvisioningStatusStatus.
func (a *AgentPoolProvisioningStatusStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &a.ErrorMessage)
			delete(rawMsg, key)
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &a.ProvisioningStatus)
			delete(rawMsg, key)
		case "readyReplicas":
			err = unpopulate(val, "ReadyReplicas", &a.ReadyReplicas)
			delete(rawMsg, key)
		case "replicas":
			err = unpopulate(val, "Replicas", &a.Replicas)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProvisioningStatusStatusProvisioningStatus.
func (a AgentPoolProvisioningStatusStatusProvisioningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", a.Error)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "phase", a.Phase)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProvisioningStatusStatusProvisioningStatus.
func (a *AgentPoolProvisioningStatusStatusProvisioningStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "phase":
			err = unpopulate(val, "Phase", &a.Phase)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArcAgentProfile.
func (a ArcAgentProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentAutoUpgrade", a.AgentAutoUpgrade)
	populate(objectMap, "agentVersion", a.AgentVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArcAgentProfile.
func (a *ArcAgentProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpgrade":
			err = unpopulate(val, "AgentAutoUpgrade", &a.AgentAutoUpgrade)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &a.AgentVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArcAgentStatus.
func (a ArcAgentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentVersion", a.AgentVersion)
	populate(objectMap, "coreCount", a.CoreCount)
	populate(objectMap, "deploymentState", a.DeploymentState)
	populate(objectMap, "errorMessage", a.ErrorMessage)
	populateTimeRFC3339(objectMap, "lastConnectivityTime", a.LastConnectivityTime)
	populateTimeRFC3339(objectMap, "managedIdentityCertificateExpirationTime", a.ManagedIdentityCertificateExpirationTime)
	populate(objectMap, "onboardingPublicKey", a.OnboardingPublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArcAgentStatus.
func (a *ArcAgentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &a.AgentVersion)
			delete(rawMsg, key)
		case "coreCount":
			err = unpopulate(val, "CoreCount", &a.CoreCount)
			delete(rawMsg, key)
		case "deploymentState":
			err = unpopulate(val, "DeploymentState", &a.DeploymentState)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &a.ErrorMessage)
			delete(rawMsg, key)
		case "lastConnectivityTime":
			err = unpopulateTimeRFC3339(val, "LastConnectivityTime", &a.LastConnectivityTime)
			delete(rawMsg, key)
		case "managedIdentityCertificateExpirationTime":
			err = unpopulateTimeRFC3339(val, "ManagedIdentityCertificateExpirationTime", &a.ManagedIdentityCertificateExpirationTime)
			delete(rawMsg, key)
		case "onboardingPublicKey":
			err = unpopulate(val, "OnboardingPublicKey", &a.OnboardingPublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudProviderProfile.
func (c CloudProviderProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "infraNetworkProfile", c.InfraNetworkProfile)
	populate(objectMap, "infraStorageProfile", c.InfraStorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudProviderProfile.
func (c *CloudProviderProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "infraNetworkProfile":
			err = unpopulate(val, "InfraNetworkProfile", &c.InfraNetworkProfile)
			delete(rawMsg, key)
		case "infraStorageProfile":
			err = unpopulate(val, "InfraStorageProfile", &c.InfraStorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudProviderProfileInfraNetworkProfile.
func (c CloudProviderProfileInfraNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "vnetSubnetIds", c.VnetSubnetIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudProviderProfileInfraNetworkProfile.
func (c *CloudProviderProfileInfraNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vnetSubnetIds":
			err = unpopulate(val, "VnetSubnetIDs", &c.VnetSubnetIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudProviderProfileInfraStorageProfile.
func (c CloudProviderProfileInfraStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "storageSpaceIds", c.StorageSpaceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudProviderProfileInfraStorageProfile.
func (c *CloudProviderProfileInfraStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageSpaceIds":
			err = unpopulate(val, "StorageSpaceIDs", &c.StorageSpaceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControlPlaneEndpointProfileControlPlaneEndpoint.
func (c ControlPlaneEndpointProfileControlPlaneEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hostIP", c.HostIP)
	populate(objectMap, "port", c.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControlPlaneEndpointProfileControlPlaneEndpoint.
func (c *ControlPlaneEndpointProfileControlPlaneEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostIP":
			err = unpopulate(val, "HostIP", &c.HostIP)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControlPlaneProfile.
func (c ControlPlaneProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availabilityZones", c.AvailabilityZones)
	populate(objectMap, "cloudProviderProfile", c.CloudProviderProfile)
	populate(objectMap, "controlPlaneEndpoint", c.ControlPlaneEndpoint)
	populate(objectMap, "count", c.Count)
	populate(objectMap, "linuxProfile", c.LinuxProfile)
	populate(objectMap, "maxCount", c.MaxCount)
	populate(objectMap, "maxPods", c.MaxPods)
	populate(objectMap, "minCount", c.MinCount)
	populate(objectMap, "mode", c.Mode)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "nodeImageVersion", c.NodeImageVersion)
	populate(objectMap, "nodeLabels", c.NodeLabels)
	populate(objectMap, "nodeTaints", c.NodeTaints)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "vmSize", c.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControlPlaneProfile.
func (c *ControlPlaneProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &c.AvailabilityZones)
			delete(rawMsg, key)
		case "cloudProviderProfile":
			err = unpopulate(val, "CloudProviderProfile", &c.CloudProviderProfile)
			delete(rawMsg, key)
		case "controlPlaneEndpoint":
			err = unpopulate(val, "ControlPlaneEndpoint", &c.ControlPlaneEndpoint)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &c.LinuxProfile)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &c.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &c.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &c.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &c.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &c.NodeLabels)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &c.NodeTaints)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &c.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPProxyConfig.
func (h HTTPProxyConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "httpProxy", h.HTTPProxy)
	populate(objectMap, "httpsProxy", h.HTTPSProxy)
	populate(objectMap, "noProxy", h.NoProxy)
	populate(objectMap, "password", h.Password)
	populate(objectMap, "trustedCa", h.TrustedCa)
	populate(objectMap, "username", h.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPProxyConfig.
func (h *HTTPProxyConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpProxy":
			err = unpopulate(val, "HTTPProxy", &h.HTTPProxy)
			delete(rawMsg, key)
		case "httpsProxy":
			err = unpopulate(val, "HTTPSProxy", &h.HTTPSProxy)
			delete(rawMsg, key)
		case "noProxy":
			err = unpopulate(val, "NoProxy", &h.NoProxy)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &h.Password)
			delete(rawMsg, key)
		case "trustedCa":
			err = unpopulate(val, "TrustedCa", &h.TrustedCa)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &h.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPProxyConfigResponse.
func (h HTTPProxyConfigResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "httpProxy", h.HTTPProxy)
	populate(objectMap, "httpsProxy", h.HTTPSProxy)
	populate(objectMap, "noProxy", h.NoProxy)
	populate(objectMap, "trustedCa", h.TrustedCa)
	populate(objectMap, "username", h.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPProxyConfigResponse.
func (h *HTTPProxyConfigResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpProxy":
			err = unpopulate(val, "HTTPProxy", &h.HTTPProxy)
			delete(rawMsg, key)
		case "httpsProxy":
			err = unpopulate(val, "HTTPSProxy", &h.HTTPSProxy)
			delete(rawMsg, key)
		case "noProxy":
			err = unpopulate(val, "NoProxy", &h.NoProxy)
			delete(rawMsg, key)
		case "trustedCa":
			err = unpopulate(val, "TrustedCa", &h.TrustedCa)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &h.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadata.
func (h HybridIdentityMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadata.
func (h *HybridIdentityMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadataList.
func (h HybridIdentityMetadataList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadataList.
func (h *HybridIdentityMetadataList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadataProperties.
func (h HybridIdentityMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", h.Identity)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "publicKey", h.PublicKey)
	populate(objectMap, "resourceUid", h.ResourceUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadataProperties.
func (h *HybridIdentityMetadataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &h.Identity)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &h.PublicKey)
			delete(rawMsg, key)
		case "resourceUid":
			err = unpopulate(val, "ResourceUID", &h.ResourceUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfileProperties.
func (l LinuxProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminUsername", l.AdminUsername)
	populate(objectMap, "ssh", l.SSH)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfileProperties.
func (l *LinuxProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &l.AdminUsername)
			delete(rawMsg, key)
		case "ssh":
			err = unpopulate(val, "SSH", &l.SSH)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfilePropertiesSSH.
func (l LinuxProfilePropertiesSSH) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicKeys", l.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfilePropertiesSSH.
func (l *LinuxProfilePropertiesSSH) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &l.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfilePropertiesSSHPublicKeysItem.
func (l LinuxProfilePropertiesSSHPublicKeysItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyData", l.KeyData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfilePropertiesSSHPublicKeysItem.
func (l *LinuxProfilePropertiesSSHPublicKeysItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &l.KeyData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerProfile.
func (l LoadBalancerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availabilityZones", l.AvailabilityZones)
	populate(objectMap, "cloudProviderProfile", l.CloudProviderProfile)
	populate(objectMap, "count", l.Count)
	populate(objectMap, "linuxProfile", l.LinuxProfile)
	populate(objectMap, "maxCount", l.MaxCount)
	populate(objectMap, "maxPods", l.MaxPods)
	populate(objectMap, "minCount", l.MinCount)
	populate(objectMap, "mode", l.Mode)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "nodeImageVersion", l.NodeImageVersion)
	populate(objectMap, "nodeLabels", l.NodeLabels)
	populate(objectMap, "nodeTaints", l.NodeTaints)
	populate(objectMap, "osType", l.OSType)
	populate(objectMap, "vmSize", l.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerProfile.
func (l *LoadBalancerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &l.AvailabilityZones)
			delete(rawMsg, key)
		case "cloudProviderProfile":
			err = unpopulate(val, "CloudProviderProfile", &l.CloudProviderProfile)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &l.Count)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &l.LinuxProfile)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &l.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &l.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &l.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &l.Mode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &l.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &l.NodeLabels)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &l.NodeTaints)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &l.OSType)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &l.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedAgentPoolProfile.
func (n NamedAgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availabilityZones", n.AvailabilityZones)
	populate(objectMap, "cloudProviderProfile", n.CloudProviderProfile)
	populate(objectMap, "count", n.Count)
	populate(objectMap, "maxCount", n.MaxCount)
	populate(objectMap, "maxPods", n.MaxPods)
	populate(objectMap, "minCount", n.MinCount)
	populate(objectMap, "mode", n.Mode)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "nodeImageVersion", n.NodeImageVersion)
	populate(objectMap, "nodeLabels", n.NodeLabels)
	populate(objectMap, "nodeTaints", n.NodeTaints)
	populate(objectMap, "osType", n.OSType)
	populate(objectMap, "vmSize", n.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedAgentPoolProfile.
func (n *NamedAgentPoolProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &n.AvailabilityZones)
			delete(rawMsg, key)
		case "cloudProviderProfile":
			err = unpopulate(val, "CloudProviderProfile", &n.CloudProviderProfile)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &n.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &n.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &n.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &n.Mode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &n.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &n.NodeLabels)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &n.NodeTaints)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &n.OSType)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &n.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsServiceIP", n.DNSServiceIP)
	populate(objectMap, "loadBalancerProfile", n.LoadBalancerProfile)
	populate(objectMap, "loadBalancerSku", n.LoadBalancerSKU)
	populate(objectMap, "networkPolicy", n.NetworkPolicy)
	populate(objectMap, "podCidr", n.PodCidr)
	populate(objectMap, "podCidrs", n.PodCidrs)
	populate(objectMap, "serviceCidr", n.ServiceCidr)
	populate(objectMap, "serviceCidrs", n.ServiceCidrs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServiceIP":
			err = unpopulate(val, "DNSServiceIP", &n.DNSServiceIP)
			delete(rawMsg, key)
		case "loadBalancerProfile":
			err = unpopulate(val, "LoadBalancerProfile", &n.LoadBalancerProfile)
			delete(rawMsg, key)
		case "loadBalancerSku":
			err = unpopulate(val, "LoadBalancerSKU", &n.LoadBalancerSKU)
			delete(rawMsg, key)
		case "networkPolicy":
			err = unpopulate(val, "NetworkPolicy", &n.NetworkPolicy)
			delete(rawMsg, key)
		case "podCidr":
			err = unpopulate(val, "PodCidr", &n.PodCidr)
			delete(rawMsg, key)
		case "podCidrs":
			err = unpopulate(val, "PodCidrs", &n.PodCidrs)
			delete(rawMsg, key)
		case "serviceCidr":
			err = unpopulate(val, "ServiceCidr", &n.ServiceCidr)
			delete(rawMsg, key)
		case "serviceCidrs":
			err = unpopulate(val, "ServiceCidrs", &n.ServiceCidrs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestratorProfile.
func (o OrchestratorProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isPreview", o.IsPreview)
	populate(objectMap, "orchestratorType", o.OrchestratorType)
	populate(objectMap, "orchestratorVersion", o.OrchestratorVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestratorProfile.
func (o *OrchestratorProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPreview":
			err = unpopulate(val, "IsPreview", &o.IsPreview)
			delete(rawMsg, key)
		case "orchestratorType":
			err = unpopulate(val, "OrchestratorType", &o.OrchestratorType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &o.OrchestratorVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestratorVersionProfile.
func (o OrchestratorVersionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "default", o.Default)
	populate(objectMap, "isPreview", o.IsPreview)
	populate(objectMap, "orchestratorType", o.OrchestratorType)
	populate(objectMap, "orchestratorVersion", o.OrchestratorVersion)
	populate(objectMap, "upgrades", o.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestratorVersionProfile.
func (o *OrchestratorVersionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &o.Default)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &o.IsPreview)
			delete(rawMsg, key)
		case "orchestratorType":
			err = unpopulate(val, "OrchestratorType", &o.OrchestratorType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &o.OrchestratorVersion)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &o.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestratorVersionProfileListResult.
func (o OrchestratorVersionProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "orchestrators", o.Orchestrators)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestratorVersionProfileListResult.
func (o *OrchestratorVersionProfileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "orchestrators":
			err = unpopulate(val, "Orchestrators", &o.Orchestrators)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterIdentity.
func (p ProvisionedClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", p.PrincipalID)
	populate(objectMap, "tenantId", p.TenantID)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterIdentity.
func (p *ProvisionedClusterIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &p.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusters.
func (p ProvisionedClusters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusters.
func (p *ProvisionedClusters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersAllProperties.
func (p ProvisionedClustersAllProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aadProfile", p.AADProfile)
	populate(objectMap, "addonProfiles", p.AddonProfiles)
	populate(objectMap, "agentPoolProfiles", p.AgentPoolProfiles)
	populate(objectMap, "cloudProviderProfile", p.CloudProviderProfile)
	populate(objectMap, "controlPlane", p.ControlPlane)
	populate(objectMap, "enableRbac", p.EnableRbac)
	populate(objectMap, "features", p.Features)
	populate(objectMap, "httpProxyConfig", p.HTTPProxyConfig)
	populate(objectMap, "kubernetesVersion", p.KubernetesVersion)
	populate(objectMap, "linuxProfile", p.LinuxProfile)
	populate(objectMap, "networkProfile", p.NetworkProfile)
	populate(objectMap, "nodeResourceGroup", p.NodeResourceGroup)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "windowsProfile", p.WindowsProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersAllProperties.
func (p *ProvisionedClustersAllProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadProfile":
			err = unpopulate(val, "AADProfile", &p.AADProfile)
			delete(rawMsg, key)
		case "addonProfiles":
			err = unpopulate(val, "AddonProfiles", &p.AddonProfiles)
			delete(rawMsg, key)
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &p.AgentPoolProfiles)
			delete(rawMsg, key)
		case "cloudProviderProfile":
			err = unpopulate(val, "CloudProviderProfile", &p.CloudProviderProfile)
			delete(rawMsg, key)
		case "controlPlane":
			err = unpopulate(val, "ControlPlane", &p.ControlPlane)
			delete(rawMsg, key)
		case "enableRbac":
			err = unpopulate(val, "EnableRbac", &p.EnableRbac)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &p.Features)
			delete(rawMsg, key)
		case "httpProxyConfig":
			err = unpopulate(val, "HTTPProxyConfig", &p.HTTPProxyConfig)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &p.KubernetesVersion)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &p.LinuxProfile)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &p.NetworkProfile)
			delete(rawMsg, key)
		case "nodeResourceGroup":
			err = unpopulate(val, "NodeResourceGroup", &p.NodeResourceGroup)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "windowsProfile":
			err = unpopulate(val, "WindowsProfile", &p.WindowsProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersCommonPropertiesFeatures.
func (p ProvisionedClustersCommonPropertiesFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arcAgentProfile", p.ArcAgentProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersCommonPropertiesFeatures.
func (p *ProvisionedClustersCommonPropertiesFeatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arcAgentProfile":
			err = unpopulate(val, "ArcAgentProfile", &p.ArcAgentProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersCommonPropertiesStatus.
func (p ProvisionedClustersCommonPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "addonStatus", p.AddonStatus)
	populate(objectMap, "errorMessage", p.ErrorMessage)
	populate(objectMap, "featuresStatus", p.FeaturesStatus)
	populate(objectMap, "provisioningStatus", p.ProvisioningStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersCommonPropertiesStatus.
func (p *ProvisionedClustersCommonPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addonStatus":
			err = unpopulate(val, "AddonStatus", &p.AddonStatus)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &p.ErrorMessage)
			delete(rawMsg, key)
		case "featuresStatus":
			err = unpopulate(val, "FeaturesStatus", &p.FeaturesStatus)
			delete(rawMsg, key)
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &p.ProvisioningStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersCommonPropertiesStatusFeaturesStatus.
func (p ProvisionedClustersCommonPropertiesStatusFeaturesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arcAgentStatus", p.ArcAgentStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersCommonPropertiesStatusFeaturesStatus.
func (p *ProvisionedClustersCommonPropertiesStatusFeaturesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arcAgentStatus":
			err = unpopulate(val, "ArcAgentStatus", &p.ArcAgentStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersCommonPropertiesStatusProvisioningStatus.
func (p ProvisionedClustersCommonPropertiesStatusProvisioningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", p.Error)
	populate(objectMap, "operationId", p.OperationID)
	populate(objectMap, "phase", p.Phase)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersCommonPropertiesStatusProvisioningStatus.
func (p *ProvisionedClustersCommonPropertiesStatusProvisioningStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &p.Error)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &p.OperationID)
			delete(rawMsg, key)
		case "phase":
			err = unpopulate(val, "Phase", &p.Phase)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersCommonPropertiesStatusProvisioningStatusError.
func (p ProvisionedClustersCommonPropertiesStatusProvisioningStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", p.Code)
	populate(objectMap, "message", p.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersCommonPropertiesStatusProvisioningStatusError.
func (p *ProvisionedClustersCommonPropertiesStatusProvisioningStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersExtendedLocation.
func (p ProvisionedClustersExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersExtendedLocation.
func (p *ProvisionedClustersExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersPatch.
func (p ProvisionedClustersPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersPatch.
func (p *ProvisionedClustersPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersResponse.
func (p ProvisionedClustersResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersResponse.
func (p *ProvisionedClustersResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersResponseExtendedLocation.
func (p ProvisionedClustersResponseExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersResponseExtendedLocation.
func (p *ProvisionedClustersResponseExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersResponseListResult.
func (p ProvisionedClustersResponseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersResponseListResult.
func (p *ProvisionedClustersResponseListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersResponseProperties.
func (p ProvisionedClustersResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aadProfile", p.AADProfile)
	populate(objectMap, "addonProfiles", p.AddonProfiles)
	populate(objectMap, "agentPoolProfiles", p.AgentPoolProfiles)
	populate(objectMap, "cloudProviderProfile", p.CloudProviderProfile)
	populate(objectMap, "controlPlane", p.ControlPlane)
	populate(objectMap, "enableRbac", p.EnableRbac)
	populate(objectMap, "features", p.Features)
	populate(objectMap, "httpProxyConfig", p.HTTPProxyConfig)
	populate(objectMap, "kubernetesVersion", p.KubernetesVersion)
	populate(objectMap, "linuxProfile", p.LinuxProfile)
	populate(objectMap, "networkProfile", p.NetworkProfile)
	populate(objectMap, "nodeResourceGroup", p.NodeResourceGroup)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "windowsProfile", p.WindowsProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersResponseProperties.
func (p *ProvisionedClustersResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadProfile":
			err = unpopulate(val, "AADProfile", &p.AADProfile)
			delete(rawMsg, key)
		case "addonProfiles":
			err = unpopulate(val, "AddonProfiles", &p.AddonProfiles)
			delete(rawMsg, key)
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &p.AgentPoolProfiles)
			delete(rawMsg, key)
		case "cloudProviderProfile":
			err = unpopulate(val, "CloudProviderProfile", &p.CloudProviderProfile)
			delete(rawMsg, key)
		case "controlPlane":
			err = unpopulate(val, "ControlPlane", &p.ControlPlane)
			delete(rawMsg, key)
		case "enableRbac":
			err = unpopulate(val, "EnableRbac", &p.EnableRbac)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &p.Features)
			delete(rawMsg, key)
		case "httpProxyConfig":
			err = unpopulate(val, "HTTPProxyConfig", &p.HTTPProxyConfig)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &p.KubernetesVersion)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &p.LinuxProfile)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &p.NetworkProfile)
			delete(rawMsg, key)
		case "nodeResourceGroup":
			err = unpopulate(val, "NodeResourceGroup", &p.NodeResourceGroup)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "windowsProfile":
			err = unpopulate(val, "WindowsProfile", &p.WindowsProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperation.
func (r ResourceProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "display", r.Display)
	populate(objectMap, "isDataAction", r.IsDataAction)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperation.
func (r *ResourceProviderOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &r.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &r.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationDisplay.
func (r ResourceProviderOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "operation", r.Operation)
	populate(objectMap, "provider", r.Provider)
	populate(objectMap, "resource", r.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationDisplay.
func (r *ResourceProviderOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &r.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &r.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &r.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationList.
func (r ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationList.
func (r *ResourceProviderOperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpaces.
func (s StorageSpaces) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", s.ExtendedLocation)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpaces.
func (s *StorageSpaces) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &s.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesExtendedLocation.
func (s StorageSpacesExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesExtendedLocation.
func (s *StorageSpacesExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesListResult.
func (s StorageSpacesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesListResult.
func (s *StorageSpacesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesPatch.
func (s StorageSpacesPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesPatch.
func (s *StorageSpacesPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesProperties.
func (s StorageSpacesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hciStorageProfile", s.HciStorageProfile)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "vmwareStorageProfile", s.VmwareStorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesProperties.
func (s *StorageSpacesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hciStorageProfile":
			err = unpopulate(val, "HciStorageProfile", &s.HciStorageProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "vmwareStorageProfile":
			err = unpopulate(val, "VmwareStorageProfile", &s.VmwareStorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesPropertiesHciStorageProfile.
func (s StorageSpacesPropertiesHciStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "mocGroup", s.MocGroup)
	populate(objectMap, "mocLocation", s.MocLocation)
	populate(objectMap, "mocStorageContainer", s.MocStorageContainer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesPropertiesHciStorageProfile.
func (s *StorageSpacesPropertiesHciStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mocGroup":
			err = unpopulate(val, "MocGroup", &s.MocGroup)
			delete(rawMsg, key)
		case "mocLocation":
			err = unpopulate(val, "MocLocation", &s.MocLocation)
			delete(rawMsg, key)
		case "mocStorageContainer":
			err = unpopulate(val, "MocStorageContainer", &s.MocStorageContainer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesPropertiesStatus.
func (s StorageSpacesPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningStatus", s.ProvisioningStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesPropertiesStatus.
func (s *StorageSpacesPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &s.ProvisioningStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesPropertiesStatusProvisioningStatus.
func (s StorageSpacesPropertiesStatusProvisioningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", s.Error)
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "phase", s.Phase)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesPropertiesStatusProvisioningStatus.
func (s *StorageSpacesPropertiesStatusProvisioningStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &s.OperationID)
			delete(rawMsg, key)
		case "phase":
			err = unpopulate(val, "Phase", &s.Phase)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesPropertiesStatusProvisioningStatusError.
func (s StorageSpacesPropertiesStatusProvisioningStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", s.Code)
	populate(objectMap, "message", s.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesPropertiesStatusProvisioningStatusError.
func (s *StorageSpacesPropertiesStatusProvisioningStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &s.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSpacesPropertiesVmwareStorageProfile.
func (s StorageSpacesPropertiesVmwareStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datacenter", s.Datacenter)
	populate(objectMap, "datastore", s.Datastore)
	populate(objectMap, "folder", s.Folder)
	populate(objectMap, "resourcePool", s.ResourcePool)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSpacesPropertiesVmwareStorageProfile.
func (s *StorageSpacesPropertiesVmwareStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datacenter":
			err = unpopulate(val, "Datacenter", &s.Datacenter)
			delete(rawMsg, key)
		case "datastore":
			err = unpopulate(val, "Datastore", &s.Datastore)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &s.Folder)
			delete(rawMsg, key)
		case "resourcePool":
			err = unpopulate(val, "ResourcePool", &s.ResourcePool)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSKUListResult.
func (v VMSKUListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "vmSKUs", v.VMSKUs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSKUListResult.
func (v *VMSKUListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "vmSKUs":
			err = unpopulate(val, "VMSKUs", &v.VMSKUs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworks.
func (v VirtualNetworks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworks.
func (v *VirtualNetworks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksExtendedLocation.
func (v VirtualNetworksExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", v.Name)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksExtendedLocation.
func (v *VirtualNetworksExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksListResult.
func (v VirtualNetworksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksListResult.
func (v *VirtualNetworksListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPatch.
func (v VirtualNetworksPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPatch.
func (v *VirtualNetworksPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksProperties.
func (v VirtualNetworksProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dnsServers", v.DNSServers)
	populate(objectMap, "dhcpServers", v.DhcpServers)
	populate(objectMap, "gateway", v.Gateway)
	populate(objectMap, "ipAddressPrefix", v.IPAddressPrefix)
	populate(objectMap, "infraVnetProfile", v.InfraVnetProfile)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "vipPool", v.VipPool)
	populate(objectMap, "vlanID", v.VlanID)
	populate(objectMap, "vmipPool", v.VmipPool)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksProperties.
func (v *VirtualNetworksProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		case "dhcpServers":
			err = unpopulate(val, "DhcpServers", &v.DhcpServers)
			delete(rawMsg, key)
		case "gateway":
			err = unpopulate(val, "Gateway", &v.Gateway)
			delete(rawMsg, key)
		case "ipAddressPrefix":
			err = unpopulate(val, "IPAddressPrefix", &v.IPAddressPrefix)
			delete(rawMsg, key)
		case "infraVnetProfile":
			err = unpopulate(val, "InfraVnetProfile", &v.InfraVnetProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "vipPool":
			err = unpopulate(val, "VipPool", &v.VipPool)
			delete(rawMsg, key)
		case "vlanID":
			err = unpopulate(val, "VlanID", &v.VlanID)
			delete(rawMsg, key)
		case "vmipPool":
			err = unpopulate(val, "VmipPool", &v.VmipPool)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesInfraVnetProfile.
func (v VirtualNetworksPropertiesInfraVnetProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hci", v.Hci)
	populate(objectMap, "kubevirt", v.Kubevirt)
	populate(objectMap, "vmware", v.Vmware)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesInfraVnetProfile.
func (v *VirtualNetworksPropertiesInfraVnetProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hci":
			err = unpopulate(val, "Hci", &v.Hci)
			delete(rawMsg, key)
		case "kubevirt":
			err = unpopulate(val, "Kubevirt", &v.Kubevirt)
			delete(rawMsg, key)
		case "vmware":
			err = unpopulate(val, "Vmware", &v.Vmware)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesInfraVnetProfileHci.
func (v VirtualNetworksPropertiesInfraVnetProfileHci) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "mocGroup", v.MocGroup)
	populate(objectMap, "mocLocation", v.MocLocation)
	populate(objectMap, "mocVnetName", v.MocVnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesInfraVnetProfileHci.
func (v *VirtualNetworksPropertiesInfraVnetProfileHci) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mocGroup":
			err = unpopulate(val, "MocGroup", &v.MocGroup)
			delete(rawMsg, key)
		case "mocLocation":
			err = unpopulate(val, "MocLocation", &v.MocLocation)
			delete(rawMsg, key)
		case "mocVnetName":
			err = unpopulate(val, "MocVnetName", &v.MocVnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesInfraVnetProfileKubevirt.
func (v VirtualNetworksPropertiesInfraVnetProfileKubevirt) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "vnetName", v.VnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesInfraVnetProfileKubevirt.
func (v *VirtualNetworksPropertiesInfraVnetProfileKubevirt) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vnetName":
			err = unpopulate(val, "VnetName", &v.VnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesInfraVnetProfileVmware.
func (v VirtualNetworksPropertiesInfraVnetProfileVmware) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "segmentName", v.SegmentName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesInfraVnetProfileVmware.
func (v *VirtualNetworksPropertiesInfraVnetProfileVmware) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "segmentName":
			err = unpopulate(val, "SegmentName", &v.SegmentName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesStatus.
func (v VirtualNetworksPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "provisioningStatus", v.ProvisioningStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesStatus.
func (v *VirtualNetworksPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &v.ProvisioningStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesStatusProvisioningStatus.
func (v VirtualNetworksPropertiesStatusProvisioningStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", v.Error)
	populate(objectMap, "operationId", v.OperationID)
	populate(objectMap, "phase", v.Phase)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesStatusProvisioningStatus.
func (v *VirtualNetworksPropertiesStatusProvisioningStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &v.OperationID)
			delete(rawMsg, key)
		case "phase":
			err = unpopulate(val, "Phase", &v.Phase)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesStatusProvisioningStatusError.
func (v VirtualNetworksPropertiesStatusProvisioningStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", v.Code)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesStatusProvisioningStatusError.
func (v *VirtualNetworksPropertiesStatusProvisioningStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesVipPoolItem.
func (v VirtualNetworksPropertiesVipPoolItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endIP", v.EndIP)
	populate(objectMap, "startIP", v.StartIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesVipPoolItem.
func (v *VirtualNetworksPropertiesVipPoolItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endIP":
			err = unpopulate(val, "EndIP", &v.EndIP)
			delete(rawMsg, key)
		case "startIP":
			err = unpopulate(val, "StartIP", &v.StartIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPropertiesVmipPoolItem.
func (v VirtualNetworksPropertiesVmipPoolItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endIP", v.EndIP)
	populate(objectMap, "startIP", v.StartIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPropertiesVmipPoolItem.
func (v *VirtualNetworksPropertiesVmipPoolItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endIP":
			err = unpopulate(val, "EndIP", &v.EndIP)
			delete(rawMsg, key)
		case "startIP":
			err = unpopulate(val, "StartIP", &v.StartIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsProfile.
func (w WindowsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminPassword", w.AdminPassword)
	populate(objectMap, "adminUsername", w.AdminUsername)
	populate(objectMap, "enableCsiProxy", w.EnableCsiProxy)
	populate(objectMap, "licenseType", w.LicenseType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsProfile.
func (w *WindowsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &w.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &w.AdminUsername)
			delete(rawMsg, key)
		case "enableCsiProxy":
			err = unpopulate(val, "EnableCsiProxy", &w.EnableCsiProxy)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &w.LicenseType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsProfileResponse.
func (w WindowsProfileResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminUsername", w.AdminUsername)
	populate(objectMap, "enableCsiProxy", w.EnableCsiProxy)
	populate(objectMap, "licenseType", w.LicenseType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsProfileResponse.
func (w *WindowsProfileResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &w.AdminUsername)
			delete(rawMsg, key)
		case "enableCsiProxy":
			err = unpopulate(val, "EnableCsiProxy", &w.EnableCsiProxy)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &w.LicenseType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
