#!/bin/sh
### install.sh - instalacni skript pro ceske a slovenske fortunes
### -- Zdenek Pytela, 1998.06.08--2000.12.15--2006.04.07
###
### Instalace:
### V adresari FORTUNESDIR se vytvori podadresar cs
### Podadresar src/ obsahuje zdrojove texty v kodovani utf-8
### doc/ dokumentaci, misc/ dalsi, zatim nezarazene soubory
### Ceske fortunes se spousti "fortune cs",
### Pripominky, opravy chyb a nove prispevky vlastni i nalezene muzete
###  posilat na adresu <zdenekZAVpytela.net>.

VERZE="2.0.9"
FORTUNE="/usr/bin/fortune"
STRFILE="/usr/sbin/strfile"
STRFILEALT="/usr/bin/strfile"

if [ ! -x "$STRFILE" ]
then
 if [ ! -x "$STRFILEALT" ]
 then
  echo "Soubor $STRFILE ani $STRFILEALT neexistuje nebo neni spustitelny."
     exit 2
 fi
 STRFILE=$STRFILEALT
fi

### Prefix nastavte, pokud chcete vytvorit strom jinam
###  nez do sve adresarove struktury
PREFIX=${PREFIX-""}
#/bin/rm -rf $PREFIX

### Dokumentace
DOCDIR=$PREFIX${DOCDIR-"/usr/share/doc/fortune-cs-$VERZE"}

### Kde je adresar s texty fortunes (FHS 2.0)
FORTUNESDIR=$PREFIX${FORTUNESDIR:-"/usr/share/games/fortune"}

### dialog scripts go into /usr/games
GAMESDIR=$PREFIX/usr/games
APPSDIR=$PREFIX/usr/share/applications
PIXMAPDIR=$PREFIX/usr/share/pixmaps

### Konec sekce s nastavovanim promennych
###
### Instalace

### Dokumentace
if [ -d $DOCDIR ] || mkdir -p $DOCDIR
then cp -f doc/* $DOCDIR
else
 echo "Nelze vytvorit adresar $DOCDIR."
 exit 3
fi

### Instalace cookies
if [ -d $FORTUNESDIR/cs ] || mkdir -p $FORTUNESDIR/cs
then
 for SOUBOR in src/cookies/*
 do
  # MK hint: link s priponou .u8 dava informaci o kodovani
  CILOVYSOUBOR=$FORTUNESDIR/cs/${SOUBOR#src/cookies/}
  cp -f $SOUBOR $CILOVYSOUBOR
  ${STRFILE} -s $CILOVYSOUBOR
  ln -s ${SOUBOR#src/cookies/} $CILOVYSOUBOR.u8
 done
 else
  echo "Chyba pri vytvareni adresare $FORTUNESDIR."
  exit 4
fi

### dialog skripty, odkaz pro menu, ikonka
if install -d $GAMESDIR; then
 install -m755 src/fortune-cs.tk $GAMESDIR
 install -m755 src/fortune-cs.sh $GAMESDIR
fi
install -d $APPSDIR \
&& install -m644 src/fortune-cs.desktop $APPSDIR
install -d $PIXMAPDIR \
&& install -m644 src/smile35x34.xpm $PIXMAPDIR

### Zkouska: funguje to?
[ -x $FORTUNE ] && $FORTUNE $FORTUNESDIR/cs > /dev/null
exit $?

