/**
 * \file
 * \brief BitField accessors for nvs_regmap_core_1
 *
 * Autogenerated with yoda-gen 1.2.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_CORE_1_H__
 #define __ADRV9001_BF_NVS_REGMAP_CORE_1_H__

#include "adrv9001_bf_hal.h"



/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x197), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x197), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x198), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x198), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare10_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1a1), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare10_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare11_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1a2), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare11_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare12_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1a3), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare12_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare13_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1a4), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare13_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare14_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1a5), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare14_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x199), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x199), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare3_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x19a), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare3_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x19a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare4_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x19b), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare4_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x19b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare5_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x19c), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare5_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x19c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare: bit0=I_en_clkgen_mcs, bit1=I_en_dig_center_rst, bit2=I_en_clean_resample_clk_n, bit3=I_en_clean_resample_clk_p
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare6_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x19d), (value >> 0));

    return status;
}

/**
 * Top Analog Spare: bit0=I_en_clkgen_mcs, bit1=I_en_dig_center_rst, bit2=I_en_clean_resample_clk_n, bit3=I_en_clean_resample_clk_p
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare6_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x19d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare8_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x19f), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare8_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x19f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare9_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1a0), (value >> 0));

    return status;
}

/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpare9_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpareReadback0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x19e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Top Analog Spare
 */
static inline int32_t adrv9001_NvsRegmapCore1_AnalogSpareReadback1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Arm clock is automatically realign on Reference counter when arm_clk_div_value change
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmClkAutoAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Arm clock is automatically realign on Reference counter when arm_clk_div_value change
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmClkAutoAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ArmClkDivValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1df), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ArmClkDivValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1df), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Bypass the load process of ARM clock div value
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmClkLoadBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Bypass the load process of ARM clock div value
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmClkLoadBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable IRQ extend block
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmIrqExtendEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable IRQ extend block
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmIrqExtendEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Manual mode, 1: Automatic Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmIrqExtendMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Manual mode, 1: Automatic Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmIrqExtendMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ARM IRQ Extend Ratio
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmIrqExtendRatio_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e1), (value >> 0), 0x7f, 0x0);

    return status;
}

/**
 * (B0 New) ARM IRQ Extend Ratio
 */
static inline int32_t adrv9001_NvsRegmapCore1_ArmIrqExtendRatio_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e1), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Arm_clk selected, 1: Ref_clk selected
 */
static inline int32_t adrv9001_NvsRegmapCore1_Armclk2RefClkSwitchEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Arm_clk selected, 1: Ref_clk selected
 */
static inline int32_t adrv9001_NvsRegmapCore1_Armclk2RefClkSwitchEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineRTerm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15f), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineRTerm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15f), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineRcvBufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15f), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineRcvBufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineTermBiasPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15f), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineTermBiasPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineTermEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15f), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux1LoLineTermEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineRTerm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x160), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineRTerm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x160), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineRcvBufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x160), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineRcvBufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x160), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineTermBiasPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x160), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineTermBiasPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x160), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineTermEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x160), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Aux2LoLineTermEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x160), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc0ClockEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc0ClockEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit must be cleared before changing the AuxADC clock divider. Setting this bit after changing the divider word enables the AuxADC clock.
 *  Aux Adc Clock Enable
 */
static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc1ClockEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * This bit must be cleared before changing the AuxADC clock divider. Setting this bit after changing the divider word enables the AuxADC clock.
 *  Aux Adc Clock Enable
 */
static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc1ClockEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc2ClockEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc2ClockEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc3ClockEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdc3ClockEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdcClkArmSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_AuxAdcClkArmSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * The AuxADC clock results from dividing down HSDIGCLK/2 (800MHz max) as described in the following equation:
 *  Aux Adc Clk Div
 */
static inline int32_t adrv9001_NvsRegmapCore1_AuxAdcClkDiv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * The AuxADC clock results from dividing down HSDIGCLK/2 (800MHz max) as described in the following equation:
 *  Aux Adc Clk Div
 */
static inline int32_t adrv9001_NvsRegmapCore1_AuxAdcClkDiv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllCpCalOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c0), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllCpOverRangeHigh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllCpOverRangeLow_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllVcoAlcWordOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1bf), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1be), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllVcoCalInProgress_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllVcoCompOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllVcoFreqCoarseBandOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1bd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1bc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllVcoFreqFineBandOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1bb), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_AuxPllVcoTcDacOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ba), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1b9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Puts the  CLK_PLL output test signal driver into "HiZ".
 */
static inline int32_t adrv9001_NvsRegmapCore1_CkTestDriMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x192), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Puts the  CLK_PLL output test signal driver into "HiZ".
 */
static inline int32_t adrv9001_NvsRegmapCore1_CkTestDriMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x192), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enables the CLK_PLL output test signal.
 */
static inline int32_t adrv9001_NvsRegmapCore1_CkTestPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x192), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Enables the CLK_PLL output test signal.
 */
static inline int32_t adrv9001_NvsRegmapCore1_CkTestPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x192), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllCpCalOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b7), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllCpOverRangeHigh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllCpOverRangeLow_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpCpCalOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ae), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpCpOverRangeHigh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1af), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpCpOverRangeLow_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1af), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1af), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpVcoAlcWordOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ad), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1ac), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpVcoCalInProgress_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1af), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpVcoCompOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1af), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpVcoFreqCoarseBandOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ab), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1aa), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpVcoFreqFineBandOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1a9), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllLpVcoTcDacOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1a8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllVcoAlcWordOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b6), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1b5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllVcoCalInProgress_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllVcoCompOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllVcoFreqCoarseBandOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1b3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllVcoFreqFineBandOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b2), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ClkPllVcoTcDacOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1b1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1b0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This register selects which set of bits will be monitored by the control output bits when they are assigned to GPIO pins. See the document for Control output pins for more information on the signals.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ControlOutMuxSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x8), (value >> 0));

    return status;
}

/**
 * This register selects which set of bits will be monitored by the control output bits when they are assigned to GPIO pins. See the document for Control output pins for more information on the signals.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ControlOutMuxSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x190), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x190), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoDisThermalShutdown_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x191), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoDisThermalShutdown_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x191), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoFilterBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x191), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoFilterBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x191), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoIlimitInc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x190), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoIlimitInc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x190), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x190), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoThermalShutdown0c_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x191), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoThermalShutdown0c_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x191), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoVoutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x190), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoVoutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x190), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoVoutTrim_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x191), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ConverterLdoVoutTrim_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x191), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_DebugCoreControlOut_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_DebugCoreControlOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * There are two words that control the division ratio for the REF_CLK going from the analog to the digital: "devclk_divide_ratio_diff_rcv[2:0] and "dig_devclk_divide_ratio_osc_rcv[2:0]".  Which word is used it determined by the MODE pin ADC, but this bit can control which word is used when "force_dig_dev_clk_div_source_sel_from_spi" is HIGH.
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevClkDivSourceSelFromSpi_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x194), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * There are two words that control the division ratio for the REF_CLK going from the analog to the digital: "devclk_divide_ratio_diff_rcv[2:0] and "dig_devclk_divide_ratio_osc_rcv[2:0]".  Which word is used it determined by the MODE pin ADC, but this bit can control which word is used when "force_dig_dev_clk_div_source_sel_from_spi" is HIGH.
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevClkDivSourceSelFromSpi_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x194), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * The divide ratio in the analog for the REF_CLK being sent to the main digital when the REF_CLK block is in differential receiver mode.  The default is div 16 such that if the input differential clock is the maximum allowed of 1000 MHz, the REF_CLK beig sent to the digital is no greater than 80 MHz (the maximum allowed for the REF_CLK to the digital).   0 => bypass
 * 1 => div 2
 * 2 => div 4
 * 3 => div 8
 * 4 => div 16
 * 5 => div 32
 * 6 => div 64
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevclkDivideRatioDiffRcv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x195), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * The divide ratio in the analog for the REF_CLK being sent to the main digital when the REF_CLK block is in differential receiver mode.  The default is div 16 such that if the input differential clock is the maximum allowed of 1000 MHz, the REF_CLK beig sent to the digital is no greater than 80 MHz (the maximum allowed for the REF_CLK to the digital).   0 => bypass
 * 1 => div 2
 * 2 => div 4
 * 3 => div 8
 * 4 => div 16
 * 5 => div 32
 * 6 => div 64
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevclkDivideRatioDiffRcv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x195), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * The divide ratio in the analog for the REF_CLK being sent to the main digital when the REF_CLK block is in differential CMOS single-ended or oscillator mode. 0 => bypass
 * 1 => div 2
 * 2 => div 4
 * 3 => div 8
 * 4 => div 16
 * 5 => div 32
 * 6 => div 64
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevclkDivideRatioOscRcv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x195), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * The divide ratio in the analog for the REF_CLK being sent to the main digital when the REF_CLK block is in differential CMOS single-ended or oscillator mode. 0 => bypass
 * 1 => div 2
 * 2 => div 4
 * 3 => div 8
 * 4 => div 16
 * 5 => div 32
 * 6 => div 64
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevclkDivideRatioOscRcv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x195), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * RESETB signal for the MCS assocaited with the REF_CLK being sent to the digital.
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevclkDividerMcsResetb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x194), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * RESETB signal for the MCS assocaited with the REF_CLK being sent to the digital.
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDevclkDividerMcsResetb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x194), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDeviceClkDivideRatio_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x152), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * Unused
 */
static inline int32_t adrv9001_NvsRegmapCore1_DigDeviceClkDivideRatio_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x152), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * The efuse_product_id
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseFeatureData_Get(void *const device,
    uint8_t (*value)[12])
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x23), &register_value);
    (*value)[0] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x22), &register_value);
    (*value)[1] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x21), &register_value);
    (*value)[2] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x20), &register_value);
    (*value)[3] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1f), &register_value);
    (*value)[4] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1e), &register_value);
    (*value)[5] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d), &register_value);
    (*value)[6] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1c), &register_value);
    (*value)[7] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1b), &register_value);
    (*value)[8] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1a), &register_value);
    (*value)[9] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x19), &register_value);
    (*value)[10] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x18), &register_value);
    (*value)[11] = register_value;

    return status;
}

/**
 * This bit initiates loading the hardware differentiation fuses into the latches ... identical to the POR read that occurs.
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseForceRead_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xe), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * This bit initiates loading the hardware differentiation fuses into the latches ... identical to the POR read that occurs.
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseForceRead_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, this bit allows the SPI bits in 0xC20 '- 0xC22 to affect the chip configuration. When clear, the contents 0f 0xC20 '- 0xC22 are not used.
 *  Efuse Over Ride Enable
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x30), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When set, this bit allows the SPI bits in 0xC20 '- 0xC22 to affect the chip configuration. When clear, the contents 0f 0xC20 '- 0xC22 are not used.
 *  Efuse Over Ride Enable
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x30), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When set, this bit allows the SPI bits in 0xC20 '- 0xC22 to affect the chip configuration. When clear, the contents 0f 0xC20 '- 0xC22 are not used.
 *  eFuse override bits.
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseOverrides_Set(void *const device,
    uint8_t (*value)[12])
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x2f), (*value)[0]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x2e), (*value)[1]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x2d), (*value)[2]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x2c), (*value)[3]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x2b), (*value)[4]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x2a), (*value)[5]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x29), (*value)[6]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x28), (*value)[7]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x27), (*value)[8]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x26), (*value)[9]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x25), (*value)[10]);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x24), (*value)[11]);

    return status;
}

/**
 * When set, this bit allows the SPI bits in 0xC20 '- 0xC22 to affect the chip configuration. When clear, the contents 0f 0xC20 '- 0xC22 are not used.
 *  eFuse override bits.
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseOverrides_Get(void *const device,
    uint8_t (*value)[12])
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x2f), &register_value);
    (*value)[0] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x2e), &register_value);
    (*value)[1] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x2d), &register_value);
    (*value)[2] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x2c), &register_value);
    (*value)[3] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x2b), &register_value);
    (*value)[4] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x2a), &register_value);
    (*value)[5] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x29), &register_value);
    (*value)[6] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x28), &register_value);
    (*value)[7] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x27), &register_value);
    (*value)[8] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x26), &register_value);
    (*value)[9] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x25), &register_value);
    (*value)[10] = register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x24), &register_value);
    (*value)[11] = register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgAddress_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x14), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgAddress_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x14), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgStrobe_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgStrobe_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgUseGpio_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgUseGpio_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * writing this bit true sets the Efuse IP into a state in which it can be programmed.  The Efuse can only be programmed in a specific hardware mode and that gating is not completed in the yoda db
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgramStart_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xe), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * writing this bit true sets the Efuse IP into a state in which it can be programmed.  The Efuse can only be programmed in a specific hardware mode and that gating is not completed in the yoda db
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseProgramStart_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits are the Efuse segment address, The segment written to these bits will be presented to the efuse_read_data BF bits after an efuse_read_startis properly invoked
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseReadAddress_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xe), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * These bits are the Efuse segment address, The segment written to these bits will be presented to the efuse_read_data BF bits after an efuse_read_startis properly invoked
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseReadAddress_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_EfuseReadData_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x12), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x11), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x10), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * a self-clearing bit which initiates loading of fuse bit cells such that they can be read via the SPI port efuse_read_data bit field (4-bytes).  This bit is automatically cleared upon completion of the Efuse operation.
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseReadStart_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xe), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * a self-clearing bit which initiates loading of fuse bit cells such that they can be read via the SPI port efuse_read_data bit field (4-bytes).  This bit is automatically cleared upon completion of the Efuse operation.
 */
static inline int32_t adrv9001_NvsRegmapCore1_EfuseReadStart_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_EfuseState_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseUseDoubleRedundancy_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseUseDoubleRedundancy_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseUseRedundancyOring_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_EfuseUseRedundancyOring_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 0 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp0ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 0 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp0ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 1 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp1ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f3), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 1 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp1ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 2 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp2ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f3), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 2 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp2ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 3 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp3ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f3), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Enable Flex stream Proc 3 clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_FlexSp3ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ForceArmClk_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f2), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ForceArmClk_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Forces the division word selection for the REF_CLK being sent to the digital to be determined by the SPI as opposed to the mode pin.  See the description for the "dig_dev_clk_div_source_sel_from_spi" bit. "0" => Use division word selection determined by MODE pin ADC.
 * "1" => Force division word selection to be controlled by SPI.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ForceDigDevClkDivSourceSelFromSpi_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x194), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Forces the division word selection for the REF_CLK being sent to the digital to be determined by the SPI as opposed to the mode pin.  See the description for the "dig_dev_clk_div_source_sel_from_spi" bit. "0" => Use division word selection determined by MODE pin ADC.
 * "1" => Force division word selection to be controlled by SPI.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ForceDigDevClkDivSourceSelFromSpi_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x194), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ForceRefClk_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f2), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_ForceRefClk_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Forces the Gm selection of the REF_CLK oscillaor for come from the SPI, as opposed to being controlled by the mode pin.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ForceRefclkClcnfgFromSpi_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x194), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Forces the Gm selection of the REF_CLK oscillaor for come from the SPI, as opposed to being controlled by the mode pin.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ForceRefclkClcnfgFromSpi_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x194), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0Abort_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0Abort_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Abort Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0AbortFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA AHB Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0AhbError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0BlockBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xbf), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xc0), (value >> 0));

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0BlockBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xbf), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xc0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0ConfigIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0ConfigIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0ContinuousIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0ContinuousIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. It indicates the current address being driven by DMA on the AHB Bus.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0CurrIndex_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xd1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xd2), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xd3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xd4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Block Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0CurrentBlockAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xcd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xce), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xcf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xd0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Index Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0CurrentIndexAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xc5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xc6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xc7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xc8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Profile Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0CurrentProfileAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xc9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xca), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xcb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xcc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA End Of Transfer Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0EndOfTransferFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Error Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0ErrorFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Field Type Error flags: Bit 0: Profile Pointer fetched either in Index Table or in Block, Bit 1: Index Pointer fetched in Block-Transfer-Mode, or in Profile-Pointer-Table or in Block, Bit 2: Register entry fetched in Index Table, Bit 3: Both - END field and SKIP field flags are set. Bit4: Read-Modify-Write Instruction fetched in Index Table.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0FieldTypeError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc4), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA GENBUS Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0GenbusError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0IgnoreTxrxMatch_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb5), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0IgnoreTxrxMatch_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0MaxNumberOfWord_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xc1), (value >> 0));

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0MaxNumberOfWord_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xc1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Max Word Count Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0MaxWordCountError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextRx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextRx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextRx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextRxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextSkip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextSkip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextTx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextTx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextTx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0NextTxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0RegmapOffsetAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb8), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0RegmapOffsetAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb8), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0StartTableAddr_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xb9), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xba), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xbb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xbc), (value >> 0));

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0StartTableAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xb9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xba), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xbb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xbc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. This is the internal state-register of the DMA finite-state-machine.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0State_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * 3-bit Encoded Status of DMA. 000: Idle, 100: Done (without Error), 101: Done With Error, 110: Active, 111: Wait for Next
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0Stop_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0Stop_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Stop Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0StopFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0TableBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xbd), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xbe), (value >> 0));

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0TableBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xbd), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xbe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextRx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0UnexpectedNextRxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextSkip Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0UnexpectedNextSkipError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextTx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma0UnexpectedNextTxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1Abort_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1Abort_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Abort Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1AbortFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe3), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA AHB Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1AhbError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1BlockBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xe0), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xe1), (value >> 0));

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1BlockBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xe1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1ConfigIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1ConfigIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1ContinuousIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1ContinuousIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. It indicates the current address being driven by DMA on the AHB Bus.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1CurrIndex_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xf2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xf3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xf4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xf5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Block Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1CurrentBlockAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xee), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xef), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xf0), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xf1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Index Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1CurrentIndexAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xe6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xe7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xe8), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xe9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Profile Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1CurrentProfileAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xea), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xeb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xec), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xed), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA End Of Transfer Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1EndOfTransferFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Error Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1ErrorFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Field Type Error flags: Bit 0: Profile Pointer fetched either in Index Table or in Block, Bit 1: Index Pointer fetched in Block-Transfer-Mode, or in Profile-Pointer-Table or in Block, Bit 2: Register entry fetched in Index Table, Bit 3: Both - END field and SKIP field flags are set. Bit4: Read-Modify-Write Instruction fetched in Index Table.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1FieldTypeError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe5), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA GENBUS Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1GenbusError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1IgnoreTxrxMatch_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1IgnoreTxrxMatch_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1MaxNumberOfWord_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xe2), (value >> 0));

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1MaxNumberOfWord_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xe2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Max Word Count Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1MaxWordCountError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextRx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextRx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextRx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextRxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextSkip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextSkip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextTx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextTx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextTx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1NextTxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1RegmapOffsetAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd9), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1RegmapOffsetAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd9), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1StartTableAddr_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xda), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xdb), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xdc), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xdd), (value >> 0));

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1StartTableAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xda), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xdb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xdc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xdd), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. This is the internal state-register of the DMA finite-state-machine.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1State_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * 3-bit Encoded Status of DMA. 000: Idle, 100: Done (without Error), 101: Done With Error, 110: Active, 111: Wait for Next
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1Stop_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1Stop_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Stop Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1StopFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1TableBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xde), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xdf), (value >> 0));

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1TableBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xde), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xdf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextRx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1UnexpectedNextRxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextSkip Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1UnexpectedNextSkipError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextTx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma1UnexpectedNextTxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xe4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2Abort_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2Abort_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Abort Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2AbortFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x104), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA AHB Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2AhbError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2BlockBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x101), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x102), (value >> 0));

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2BlockBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x101), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x102), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2ConfigIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2ConfigIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2ContinuousIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2ContinuousIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. It indicates the current address being driven by DMA on the AHB Bus.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2CurrIndex_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x113), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x114), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x115), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x116), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Block Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2CurrentBlockAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x10f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x110), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x111), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x112), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Index Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2CurrentIndexAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x107), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x108), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x109), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x10a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Profile Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2CurrentProfileAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x10b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x10c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x10d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x10e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA End Of Transfer Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2EndOfTransferFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x104), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Error Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2ErrorFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x104), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Field Type Error flags: Bit 0: Profile Pointer fetched either in Index Table or in Block, Bit 1: Index Pointer fetched in Block-Transfer-Mode, or in Profile-Pointer-Table or in Block, Bit 2: Register entry fetched in Index Table, Bit 3: Both - END field and SKIP field flags are set.  Bit4: Read-Modify-Write Instruction fetched in Index Table.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2FieldTypeError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x106), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA GENBUS Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2GenbusError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2IgnoreTxrxMatch_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2IgnoreTxrxMatch_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2MaxNumberOfWord_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x103), (value >> 0));

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2MaxNumberOfWord_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x103), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Max Word Count Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2MaxWordCountError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextRx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextRx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextRx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextRxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextSkip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextSkip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextTx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextTx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextTx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2NextTxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2RegmapOffsetAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xfa), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2RegmapOffsetAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xfa), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2StartTableAddr_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xfb), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xfc), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xfd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xfe), (value >> 0));

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2StartTableAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xfb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xfc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xfd), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xfe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. This is the internal state-register of the DMA finite-state-machine.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2State_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x117), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * 3-bit Encoded Status of DMA. 000: Idle, 100: Done (without Error), 101: Done With Error, 110: Active, 111: Wait for Next
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x104), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2Stop_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xf8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2Stop_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xf8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Stop Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2StopFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x104), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2TableBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xff), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x100), (value >> 0));

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2TableBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xff), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x100), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextRx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2UnexpectedNextRxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextSkip Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2UnexpectedNextSkipError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextTx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma2UnexpectedNextTxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x105), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3Abort_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x119), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not abort, 1: DMA Abort
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3Abort_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x119), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Abort Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3AbortFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x125), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA AHB Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3AhbError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3BlockBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x122), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x123), (value >> 0));

    return status;
}

/**
 * Block Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3BlockBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x122), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x123), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3ConfigIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x118), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Block Transfer Mode, 1:Index Mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3ConfigIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x118), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3ContinuousIndexMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x118), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: OneTime Event Based Index Mode, 1: Continuous Index Mode. This bit is ignored if spi_dma_config_index_mode=0.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3ContinuousIndexMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x118), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. It indicates the current address being driven by DMA on the AHB Bus.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3CurrIndex_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x134), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x135), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x136), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x137), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Block Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3CurrentBlockAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x130), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x131), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x132), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x133), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Index Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3CurrentIndexAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x128), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x129), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x12a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x12b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Current Profile Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3CurrentProfileAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x12c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x12d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x12e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x12f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x119), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: DMA is disabled. All internal states and flags are cleared. 1: DMA is enabled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x119), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA End Of Transfer Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3EndOfTransferFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x125), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Error Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3ErrorFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x125), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Field Type Error flags: Bit 0: Profile Pointer fetched either in Index Table or in Block, Bit 1: Index Pointer fetched in Block-Transfer-Mode, or in Profile-Pointer-Table or in Block, Bit 2: Register entry fetched in Index Table, Bit 3: Both - END field and SKIP field flags are set.  Bit4: Read-Modify-Write Instruction fetched in Index Table.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3FieldTypeError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x127), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA GENBUS Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3GenbusError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3IgnoreTxrxMatch_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x118), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: Do not ignore NextTx/NextRx Match, 1: Ignore NextTx/NextRx Match
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3IgnoreTxrxMatch_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x118), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3MaxNumberOfWord_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x124), (value >> 0));

    return status;
}

/**
 * Maximum Number of Words allowed per DMA transfer. (Reset value is 0xFF)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3MaxNumberOfWord_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x124), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Max Word Count Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3MaxWordCountError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextRx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x11a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: Next Rx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextRx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x11a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextRx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextRxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextSkip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x11a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1: Skip Next Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextSkip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x11a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextTx_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x11a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: Next Tx Profile Transfer (used only during Index Mode)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextTx_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x11a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA NextTx Mismatch Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3NextTxMismatchError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3RegmapOffsetAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x11b), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * REGMAP Offset for the register used in DMA Read-Modify-Write Instruction.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3RegmapOffsetAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x11b), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3StartTableAddr_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x11c), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x11d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x11e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x11f), (value >> 0));

    return status;
}

/**
 * Start Table Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3StartTableAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x11c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x11d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x11e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x11f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This is a debug signal. This is the internal state-register of the DMA finite-state-machine.
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3State_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x138), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * 3-bit Encoded Status of DMA. 000: Idle, 100: Done (without Error), 101: Done With Error, 110: Active, 111: Wait for Next
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x125), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3Stop_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x119), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: Do not Stop, 1: DMA Stop
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3Stop_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x119), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Stop Flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3StopFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x125), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3TableBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x120), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x121), (value >> 0));

    return status;
}

/**
 * Profile Table Base Offset Address
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3TableBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x120), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x121), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextRx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3UnexpectedNextRxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextSkip Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3UnexpectedNextSkipError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * DMA Unexpected NextTx Error flag
 */
static inline int32_t adrv9001_NvsRegmapCore1_GeneralDma3UnexpectedNextTxError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x126), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GoldenCounterDivFactor_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1ef), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GoldenCounterDivFactor_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1ef), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GoldenCounterEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GoldenCounterEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GoldenCounterOutOfSync_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GoldenCounterOutOfSync_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntArmCalibrationErrorStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntArmErrorStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntArmMonitorInterruptStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntArmSystemErrorStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntAuxPllLockStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntClkPllLockStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntClkPllLpLockStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntFlexStreamProcError0Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntFlexStreamProcError1Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntFlexStreamProcError2Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntFlexStreamProcError3Status_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntForceGpInterruptStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntMcsLssiRx1McsStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntMcsLssiRx2McsStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntMcsSecondStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntMcsStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntRf1PllLockStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntRf2PllLockStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntRxdpIntfErrorToBbicStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntRxdpIntfReadRequestToBbicStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntStreamProcErrorStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntTx1PaProtectionErrorStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntTx2PaProtectionErrorStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa6), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntTxdpIntfErrorToBbicStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpIntTxdpIntfWriteRequestToBbicStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpInterruptBypassDevClk_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpInterruptBypassDevClk_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * default value extend Interrupt generated by 184MHz clock to get 2 cycles of dev clock (@19.2MHz)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpInterruptDevClkExtend_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9d), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * default value extend Interrupt generated by 184MHz clock to get 2 cycles of dev clock (@19.2MHz)
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpInterruptDevClkExtend_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9d), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_GpInterruptLevelSensitiveFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: edge sensitive, 1: level sensitive
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpInterruptSensitiveMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 0: edge sensitive, 1: level sensitive
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpInterruptSensitiveMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoDisThermalShutdown1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x196), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoDisThermalShutdown1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x196), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoDisThermalShutdown2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x196), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoDisThermalShutdown2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x196), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoIlimitInc1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x196), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoIlimitInc1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x196), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoIlimitInc2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x196), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoIlimitInc2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x196), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoThermalShutdown0c1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x196), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoThermalShutdown0c1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x196), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoThermalShutdown0c2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x196), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpLdoThermalShutdown0c2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x196), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmCalibrationError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmCalibrationError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmForceInterrupt_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmForceInterrupt_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmMonitorInterrupt_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmMonitorInterrupt_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmSystemError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskArmSystemError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the AUX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskAuxSynthLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * When this bit is set, it will prevent the AUX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskAuxSynthLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the CLK synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskClkSynthLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * When this bit is set, it will prevent the CLK synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskClkSynthLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the CLK synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskClkSynthLpLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * When this bit is set, it will prevent the CLK synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskClkSynthLpLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream0Error_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream0Error_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream1Error_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9f), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream1Error_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream2Error_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9f), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream2Error_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream3Error_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9f), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskFlexStream3Error_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcs_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcs_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcsLssiRx1Mcs_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcsLssiRx1Mcs_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcsLssiRx2Mcs_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcsLssiRx2Mcs_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcsSecond_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskMcsSecond_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the channel 1 PA protection error signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskPaProtectionCh1Error_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * When this bit is set, it will prevent the channel 1 PA protection error signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskPaProtectionCh1Error_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the channel 2 PA protection error signal  from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskPaProtectionCh2Error_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * When this bit is set, it will prevent the channel 2 PA protection error signal  from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskPaProtectionCh2Error_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRf2SynthLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRf2SynthLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRfSynthLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * When this bit is set, it will prevent the RX synthesizer lock
 * signal from asserting the GP interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRfSynthLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRxdpIntfErrorToBbic_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9e), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRxdpIntfErrorToBbic_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRxdpIntfReadRequestToBbic_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskRxdpIntfReadRequestToBbic_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskStreamError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskStreamError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskTxdpIntfErrorToBbic_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9e), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskTxdpIntfErrorToBbic_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskTxdpIntfWriteRequestToBbic_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskTxdpIntfWriteRequestToBbic_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskWatchdogTimeout_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_GpMaskWatchdogTimeout_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo1EnMuxTerm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x161), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo1EnMuxTerm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x161), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo1MuxRTerm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x161), (value >> 0), 0x6, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo1MuxRTerm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x161), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo1PdMuxTermBias_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x161), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo1PdMuxTermBias_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x161), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo2EnMuxTerm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x162), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo2EnMuxTerm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x162), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo2MuxRTerm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x162), (value >> 0), 0x6, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo2MuxRTerm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x162), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo2PdMuxTermBias_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x162), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Lo2PdMuxTermBias_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x162), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsCmosModeEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15e), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsCmosModeEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsCmosSmittTrig_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15e), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsCmosSmittTrig_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15e), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsLvdsDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15e), (value >> 0), 0x1c, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsLvdsDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15e), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsLvdsPnInv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15e), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsLvdsPnInv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsLvdsRxOnchipTerm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15e), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_McsLvdsRxOnchipTerm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Powers down the mode pin ADC that determines what REF_CLK mode the chip will boot in.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ModeAdcPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x193), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Powers down the mode pin ADC that determines what REF_CLK mode the chip will boot in.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ModeAdcPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x193), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Read back from MODE pin ADC.
 */
static inline int32_t adrv9001_NvsRegmapCore1_ModeAdcTherm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x193), &register_value, 0x1e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Each bit of this field is used to configure each corresponding GPIO_3p3 pin as an input. If the bit is set, the pin is configured as an output, and if it is clear the pin is configured as an input.The gpio_3p3v_direction_control_oe 11:0  bits are used to configure each corresponding 3.3v GPIO pin as an input or an output. If the bit is set, the pin is configured as an output.  The gpio_3p3v_direction_control_ie 11:0  bits correspond directly to the 3.3v GPIO[11:0] pins.
 */
static inline int32_t adrv9001_NvsRegmapCore1_NvsGpioAnalogDirectionControlIe_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x159), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x158), (value >> 0));

    return status;
}

/**
 * Each bit of this field is used to configure each corresponding GPIO_3p3 pin as an input. If the bit is set, the pin is configured as an output, and if it is clear the pin is configured as an input.The gpio_3p3v_direction_control_oe 11:0  bits are used to configure each corresponding 3.3v GPIO pin as an input or an output. If the bit is set, the pin is configured as an output.  The gpio_3p3v_direction_control_ie 11:0  bits correspond directly to the 3.3v GPIO[11:0] pins.
 */
static inline int32_t adrv9001_NvsRegmapCore1_NvsGpioAnalogDirectionControlIe_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x159), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x158), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Each bit of this field is used to configure each corresponding GPIO_3p3 pin as an output. If the bit is set, the pin is configured as an output.The gpio_3p3v_direction_control_oe 11:0  bits are used to configure each corresponding 3.3v GPIO pin as an input or an output. If the bit is set, the pin is configured as an output, and if it is clear the pin is configured as an input.  The gpio_3p3v_direction_control_oe 11:0  bits correspond directly to the 3.3v GPIO[11:0] pins.
 */
static inline int32_t adrv9001_NvsRegmapCore1_NvsGpioAnalogDirectionControlOe_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x157), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x156), (value >> 0));

    return status;
}

/**
 * Each bit of this field is used to configure each corresponding GPIO_3p3 pin as an output. If the bit is set, the pin is configured as an output.The gpio_3p3v_direction_control_oe 11:0  bits are used to configure each corresponding 3.3v GPIO pin as an input or an output. If the bit is set, the pin is configured as an output, and if it is clear the pin is configured as an input.  The gpio_3p3v_direction_control_oe 11:0  bits correspond directly to the 3.3v GPIO[11:0] pins.
 */
static inline int32_t adrv9001_NvsRegmapCore1_NvsGpioAnalogDirectionControlOe_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x157), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x156), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field shows the input value of the corresponding GPIO_3p3 pins when they are set as inputs (through gpio_3p3v_direction_control_oe).The gpio_3p3v_spi_read 11:0  bits allow the user to read the current state of the corresponding 3.3v GPIO[11:0] pins via the SPI port. The 3.3v GPIO signals are asynhronous to the SPI CLK so care must be taken to maintain the logic state of the 3.3v GPIO during the SPI read operation.
 */
static inline int32_t adrv9001_NvsRegmapCore1_NvsGpioAnalogSpiRead_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15d), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x15c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits are used to set the output value of the corresponding GPIO_3p3 pins when SPI memory is selected as the data source for output pins (through gpio_3p3v_lower_byte_lower_nibble_source_control, gpio_3p3v_lower_byte_upper_nibble_source_control, and gpio_3p3v_upper_byte_lower_nibble_source_control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_NvsGpioAnalogSpiSource_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x15b), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x15a), (value >> 0));

    return status;
}

/**
 * These bits are used to set the output value of the corresponding GPIO_3p3 pins when SPI memory is selected as the data source for output pins (through gpio_3p3v_lower_byte_lower_nibble_source_control, gpio_3p3v_lower_byte_upper_nibble_source_control, and gpio_3p3v_upper_byte_lower_nibble_source_control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_NvsGpioAnalogSpiSource_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x15b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x15a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_PdConverterLdo_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_PdConverterLdo_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Disables active shield for REF_CLK going to main digital from REF_CLK receivers. 
 * "0" = > Enable active shield
 * "1" => Disable active shield
 */
static inline int32_t adrv9001_NvsRegmapCore1_PdDigRefclkActiveShield_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x194), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Disables active shield for REF_CLK going to main digital from REF_CLK receivers. 
 * "0" = > Enable active shield
 * "1" => Disable active shield
 */
static inline int32_t adrv9001_NvsRegmapCore1_PdDigRefclkActiveShield_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x194), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Powers down last REF_CLK driver going from the analog to the digital.  Will also power down the MCS associated with the digital REF_CLK. "0" => Enable REF_CLK to digital and associated MCS pulse.
 * "1" => Disable REF_CLK to digital and assocaited MCS pulse.
 */
static inline int32_t adrv9001_NvsRegmapCore1_PdDigclk_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x194), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Powers down last REF_CLK driver going from the analog to the digital.  Will also power down the MCS associated with the digital REF_CLK. "0" => Enable REF_CLK to digital and associated MCS pulse.
 * "1" => Disable REF_CLK to digital and assocaited MCS pulse.
 */
static inline int32_t adrv9001_NvsRegmapCore1_PdDigclk_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x194), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control the AHB hready signal coming from RX2 or TX2 channels
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2AhbHready_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fc), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Control the AHB hready signal coming from RX2 or TX2 channels
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2AhbHready_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control the AHB hresp signal coming from RX2 or TX2 channels
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2AhbHresp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fc), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Control the AHB hresp signal coming from RX2 or TX2 channels
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2AhbHresp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fd), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerGatingSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerGatingSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerIsoDis_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fd), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerIsoDis_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerResetb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fd), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerResetb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerScanLatchEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgChannel2PowerScanLatchEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Wait time at powerup for ARM to boot
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonArmBootWaitTimerValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1f9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1f8), (value >> 0));

    return status;
}

/**
 * (B0 New) Wait time at powerup for ARM to boot
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonArmBootWaitTimerValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1f9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1f8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Monitor wait time at powerUp.
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonPowerupWaitTimerValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1f7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1f6), (value >> 0));

    return status;
}

/**
 * (B0 New) Monitor wait time at powerUp.
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonPowerupWaitTimerValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1f7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1f6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Give control of the AHB_spi_bridge to the Monitor at Power Up. (0: Disable monitor control, 1: Enable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupAhbBridgeEnEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Give control of the AHB_spi_bridge to the Monitor at Power Up. (0: Disable monitor control, 1: Enable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupAhbBridgeEnEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Give control of the ARM_run to the monitor at Power Up. (0: Disable monitor control, 1: Enable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupArmRunEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Give control of the ARM_run to the monitor at Power Up. (0: Disable monitor control, 1: Enable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupArmRunEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Generate reset at powerup after releasing the ISO, 1: generate reset at powerup before releasing the ISO
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupEarlyResetbEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: Generate reset at powerup after releasing the ISO, 1: generate reset at powerup before releasing the ISO
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupEarlyResetbEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Give control of the Power switch to the Monitor. (0: Enable monitor control, 1: Disable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupEnDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Give control of the Power switch to the Monitor. (0: Enable monitor control, 1: Disable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupEnDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Give control of the ISO cells to the Monitor. (0: Disable monitor control, 1: Enable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupIsoDisEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Give control of the ISO cells to the Monitor. (0: Disable monitor control, 1: Enable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupIsoDisEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Conrtol the ref_clk clock gating cell for ARM clock Mux
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupRefClkEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Conrtol the ref_clk clock gating cell for ARM clock Mux
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupRefClkEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select the control of REF_CLK clock gating cell for ARM clock Mux: 0=selection from SPI bit, 1=selection from Monitor State machine
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupRefClkEnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Select the control of REF_CLK clock gating cell for ARM clock Mux: 0=selection from SPI bit, 1=selection from Monitor State machine
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupRefClkEnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Give control of the Reset to the monitor at power Up. (0: Enable monitor control, 1: Disable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupResetbDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Give control of the Reset to the monitor at power Up. (0: Enable monitor control, 1: Disable monitor control)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonTimerPowerupResetbDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Set this bit to 1 at the end of the boot sequence to continue the monitor wakeup sequence
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorArmBootReady_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fa), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Set this bit to 1 at the end of the boot sequence to continue the monitor wakeup sequence
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorArmBootReady_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fa), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select the arm ready source signal mode: 0=from SPI (pg_monitor_arm_boot_ready), 1= from timer (pg_monitor_arm_boot_wait_time_value)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorArmBootReadySel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1fa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Select the arm ready source signal mode: 0=from SPI (pg_monitor_arm_boot_ready), 1= from timer (pg_monitor_arm_boot_wait_time_value)
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorArmBootReadySel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear AHB SPI bridge after power up
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerClearAhbSpiBridge_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f5), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear AHB SPI bridge after power up
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerClearAhbSpiBridge_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable the latch at powerup for monitor_sleep_enable bit
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerEnableSleepLatch_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable the latch at powerup for monitor_sleep_enable bit
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerEnableSleepLatch_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable low power mode.
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerModeEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable low power mode.
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerModeEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Status of the monitor Power state machine
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerState_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fb), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) 0: First Powerup, 1: powerup from previous powerdown
 */
static inline int32_t adrv9001_NvsRegmapCore1_PgMonitorPowerStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1fb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear the Realign Clock Divider counter value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignClkCounterClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Clear the Realign Clock Divider counter value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignClkCounterClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Disable Realign Counter, 1: Enable Realign Counter
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignClkCounterEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Disable Realign Counter, 1: Enable Realign Counter
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignClkCounterEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Realign Clock Divider Value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignClkDivValue_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e8), (value >> 24), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1e7), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1e6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1e5), (value >> 0));

    return status;
}

/**
 * (B0 New) Realign Clock Divider Value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignClkDivValue_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e8), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1e7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1e6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1e5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear the Realign Clock Divider counter value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx1AnaLssiClkCounterClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1ee), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Clear the Realign Clock Divider counter value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx1AnaLssiClkCounterClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ee), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Disable Realign Counter, 1: Enable Realign Counter
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx1AnaLssiClkCounterEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1ee), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Disable Realign Counter, 1: Enable Realign Counter
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx1AnaLssiClkCounterEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ee), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Realign RX1 Analog Clock Divider Value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx1AnaLssiClkDivValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1eb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1ea), (value >> 0));

    return status;
}

/**
 * (B0 New) Realign RX1 Analog Clock Divider Value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx1AnaLssiClkDivValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1eb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1ea), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear the Realign Clock Divider counter value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx2AnaLssiClkCounterClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1ee), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Clear the Realign Clock Divider counter value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx2AnaLssiClkCounterClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ee), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Disable Realign Counter, 1: Enable Realign Counter
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx2AnaLssiClkCounterEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1ee), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Disable Realign Counter, 1: Enable Realign Counter
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx2AnaLssiClkCounterEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ee), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Realign RX2 Analog Clock Divider Value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx2AnaLssiClkDivValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1ed), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1ec), (value >> 0));

    return status;
}

/**
 * (B0 New) Realign RX2 Analog Clock Divider Value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RealignRx2AnaLssiClkDivValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1ed), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1ec), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkClcnfg_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb2), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkClcnfg_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkClkRxEnValueForced_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb2), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkClkRxEnValueForced_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Internal REF Clock divider by N+1 (0:div1, 1:div2, 2:div3, 3:div4, ...)
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkInternalDivValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1dd), (value >> 0));

    return status;
}

/**
 * (B0 New) Internal REF Clock divider by N+1 (0:div1, 1:div2, 2:div3, 3:div4, ...)
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkInternalDivValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1dd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable ref_clk from monitor to core clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkInternalEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable ref_clk from monitor to core clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkInternalEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkMuxValueForced_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb2), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkMuxValueForced_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable muxed clock between ref_clk and fixed 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkOrClk184ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1e3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable muxed clock between ref_clk and fixed 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkOrClk184ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1e3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkOscAmpEnValueForced_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb2), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkOscAmpEnValueForced_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) External REF Clock divider by N+1 (0:div1, 1:div2, 2:div3, 3:div4, ...)
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkPadDivValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1de), (value >> 0));

    return status;
}

/**
 * (B0 New) External REF Clock divider by N+1 (0:div1, 1:div2, 2:div3, 3:div4, ...)
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkPadDivValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1de), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: refclk pad tristated , 1 : refclk pad in output mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkPadOe_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1dc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: refclk pad tristated , 1 : refclk pad in output mode
 */
static inline int32_t adrv9001_NvsRegmapCore1_RefclkPadOe_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1dc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkRf_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb4), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkRf_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb4), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkUseSpiForClkRxEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkUseSpiForClkRxEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkUseSpiForOscAmpEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkUseSpiForOscAmpEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkUseSpiForRefclkMux_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xb3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RefclkUseSpiForRefclkMux_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xb3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1EnFineM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1EnFineM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1EnFineP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16b), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1EnFineP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloDivReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloDivReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputDcBias_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16c), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputDcBias_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStageM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16d), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStageM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStageMFbres_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16d), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStageMFbres_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16d), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStageP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16e), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStageP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStagePFbres_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16e), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnInputStagePFbres_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16e), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnTermRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16c), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloEnTermRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16c), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInAmpBias_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16c), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInAmpBias_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16c), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInDivRatio_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x170), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x16f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInDivRatio_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x170), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x16f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInDivideMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x171), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInDivideMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x171), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInDriverMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x171), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInDriverMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x171), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInFiltByp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x171), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInFiltByp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x171), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x171), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x171), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInSwapInputPn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x171), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloInSwapInputPn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x171), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloIntLoHiR_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x171), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloIntLoHiR_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x171), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutDivRatio_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x173), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x172), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutDivRatio_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x173), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x172), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutDivReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x174), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutDivReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x174), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutInbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x174), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutInbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x174), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x174), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1ExtloOutPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x174), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LoBufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x174), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LoBufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x174), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenDivRatio_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x176), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x175), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenDivRatio_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x176), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x175), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenDivideMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x177), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenDivideMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x177), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenInbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x177), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenInbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x177), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x177), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x177), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenQuadDivPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x177), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenQuadDivPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x177), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x177), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x177), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenVcoBufHighR_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x177), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1LogenVcoBufHighR_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x177), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1PdExtloIn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x177), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1PdExtloIn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x177), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllCpCalOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c9), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllCpOverRangeHigh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ca), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllCpOverRangeLow_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ca), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ca), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllVcoAlcWordOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c8), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1c7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllVcoCalInProgress_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ca), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllVcoCompOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1ca), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllVcoFreqCoarseBandOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1c5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllVcoFreqFineBandOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c4), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf1PllVcoTcDacOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1c3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1c2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCkmInvB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x178), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCkmInvB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x178), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCkpInvB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x178), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCkpInvB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x178), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCoarseM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x179), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCoarseM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x179), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCoarseP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17a), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelCoarseP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17a), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelExtloIn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x171), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelExtloIn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x171), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFineM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17b), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFineM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFineMB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17b), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFineMB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFineP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17c), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFineP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17c), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFinePB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17c), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf1SelFinePB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2EnFineM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2EnFineM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2EnFineP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17d), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2EnFineP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloDivReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloDivReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputDcBias_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputDcBias_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStageM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17f), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStageM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17f), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStageMFbres_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17f), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStageMFbres_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17f), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStageP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x180), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStageP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x180), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStagePFbres_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x180), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnInputStagePFbres_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x180), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnTermRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17e), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloEnTermRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17e), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInAmpBias_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x17e), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInAmpBias_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x17e), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInDivRatio_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x182), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x181), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInDivRatio_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x182), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x181), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInDivideMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x183), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInDivideMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x183), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInDriverMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x183), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInDriverMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x183), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInFiltByp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x183), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInFiltByp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x183), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x183), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x183), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInSwapInputPn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x183), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloInSwapInputPn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x183), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloIntLoHiR_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x183), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloIntLoHiR_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x183), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutDivRatio_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x185), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x184), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutDivRatio_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x185), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x184), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutDivReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x186), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutDivReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x186), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutInbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x186), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutInbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x186), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x186), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2ExtloOutPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x186), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LoBufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x186), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LoBufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x186), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenDivRatio_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x188), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x187), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenDivRatio_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x188), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x187), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenDivideMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x189), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenDivideMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x189), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenInbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x189), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenInbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x189), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x189), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x189), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenQuadDivPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x189), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenQuadDivPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x189), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x189), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x189), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenVcoBufHighR_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x189), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2LogenVcoBufHighR_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x189), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2PdExtloIn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x189), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2PdExtloIn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x189), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllCpCalOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1d2), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllCpOverRangeHigh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1d3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllCpOverRangeLow_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1d3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1d3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllVcoAlcWordOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1d1), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllVcoCalInProgress_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1d3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllVcoCompOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1d3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllVcoFreqCoarseBandOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1cf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1ce), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllVcoFreqFineBandOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1cd), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_Rf2PllVcoTcDacOut_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1cc), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1cb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCkmInvB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCkmInvB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCkpInvB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18a), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCkpInvB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCoarseM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18b), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCoarseM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18b), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCoarseP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18c), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelCoarseP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18c), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelExtloIn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x183), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelExtloIn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x183), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFineM_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18d), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFineM_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18d), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFineMB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18d), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFineMB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFineP_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18e), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFineP_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18e), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFinePB_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x18e), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rf2SelFinePB_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x18e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcGainchangePulseGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x149), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcGainchangePulseGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x149), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcGainchangePulseGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x148), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcGainchangePulseGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x148), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcManaulGainLockGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x14b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcManaulGainLockGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x14b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcManaulGainLockGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x14a), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcManaulGainLockGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x14a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcSlowloopFreezeGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x147), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcSlowloopFreezeGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x147), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcSlowloopFreezeGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x146), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1AgcSlowloopFreezeGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x146), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1DecgainGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x141), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1DecgainGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x141), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1DecgainGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x140), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1DecgainGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x140), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1IncgainGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x141), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1IncgainGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x141), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1IncgainGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x140), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1IncgainGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x140), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1Lo1InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x163), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1Lo1InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x163), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1Lo2InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x163), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1Lo2InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x163), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1LomuxPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x163), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1LomuxPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x163), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1’b1:  configure RX1 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Rx1Mag13tapsCoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 1’b1:  configure RX1 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Rx1Mag13tapsCoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1SelLo2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x167), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx1SelLo2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x167), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcGainchangePulseGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x14f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcGainchangePulseGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x14f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcGainchangePulseGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x14e), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcGainchangePulseGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x14e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcManaulGainLockGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x151), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcManaulGainLockGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x151), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcManaulGainLockGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x150), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcManaulGainLockGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x150), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcSlowloopFreezeGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x14d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcSlowloopFreezeGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x14d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcSlowloopFreezeGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x14c), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2AgcSlowloopFreezeGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x14c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2DecgainGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x143), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2DecgainGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x143), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2DecgainGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x142), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2DecgainGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x142), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2IncgainGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x143), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2IncgainGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x143), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2IncgainGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x142), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2IncgainGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x142), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2Lo1InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x164), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2Lo1InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x164), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2Lo2InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x164), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2Lo2InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x164), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2LomuxPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x164), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2LomuxPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x164), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 1’b1:  configure RX2 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Rx2Mag13tapsCoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) 1’b1:  configure RX2 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Rx2Mag13tapsCoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2SelLo2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x168), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Rx2SelLo2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x168), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rxadc Cap Const Delay.  This is a fixed number of clock cycles that gets subtracted form the N1 N2 values in the digital.  This is for accounting for delays in the loop.
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcCapConstDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * Rxadc Cap Const Delay.  This is a fixed number of clock cycles that gets subtracted form the N1 N2 values in the digital.  This is for accounting for delays in the loop.
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcCapConstDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * start ccal.  Self clearing.
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcCcalStart_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * start ccal.  Self clearing.
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcCcalStart_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Rxadc G Measured
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcGMeasured_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Rxadc N1 Count value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcN1Count_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Rxadc N2 Count value
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcN2Count_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x5), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Rxadc Pd
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Rxadc Pd
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * start rcal.  Self clearing
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcRcalStart_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * start rcal.  Self clearing
 */
static inline int32_t adrv9001_NvsRegmapCore1_RxadcRcalStart_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RxtiaShiftSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x153), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_RxtiaShiftSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x153), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0BbicStreamErrorToSpi_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x53), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x52), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x51), (value >> 0));

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0BbicStreamErrorToSpi_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x53), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x52), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x51), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0BbicStreamStatus_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x50), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x4f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x4e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field displays the number of the last stream that completed execution (even if it failed and errored out). Each time a stream completes, this register field will get
 * reset with the new stream number value that just completed.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0CompletedStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x40), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0EccDataParityError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x4d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0EccDataParityError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x4d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0EccDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x4d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0EccDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x4d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0IrqSensitivity_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x4d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0IrqSensitivity_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x4d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0LastStreamNum_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x3f), (value >> 0));

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0LastStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x3f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0MemHrespMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x4d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0MemHrespMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x4d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Access Flex_SP0 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0Select_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x3b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1: Access Flex_SP0 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0Select_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x3b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamBase_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x3e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x3d), (value >> 0));

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamBase_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x3e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x3d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x4c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x4c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamProcAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x41), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamProcAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x41), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field gets populated with the contents of the register specified by the address in the field stream_proc_addr, when stream_proc_rden is 1'b1.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamProcData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x43), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x42), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamProcRden_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x41), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamProcRden_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x41), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x3c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x3c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamprocDebugData_Set(void *const device,
    const uint64_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x4b), (value >> 56));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x4a), (value >> 48));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x49), (value >> 40));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x48), (value >> 32));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x47), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x46), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x45), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x44), (value >> 0));

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp0StreamprocDebugData_Get(void *const device,
    uint64_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x4b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x4a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x49), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x48), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x47), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x46), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x45), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x44), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1BbicStreamErrorToSpi_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x6b), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x6a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x69), (value >> 0));

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1BbicStreamErrorToSpi_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x6b), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x6a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x69), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1BbicStreamStatus_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x68), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x67), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x66), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field displays the number of the last stream that completed execution (even if it failed and errored out). Each time a stream completes, this register field will get
 * reset with the new stream number value that just completed.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1CompletedStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x58), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1EccDataParityError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x65), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1EccDataParityError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x65), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1EccDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x65), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1EccDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x65), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1IrqSensitivity_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x65), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1IrqSensitivity_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x65), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1LastStreamNum_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x57), (value >> 0));

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1LastStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x57), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1MemHrespMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x65), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1MemHrespMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x65), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Access Flex_SP1 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1Select_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x3b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1: Access Flex_SP1 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1Select_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x3b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamBase_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x56), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x55), (value >> 0));

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamBase_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x56), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x55), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x64), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x64), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamProcAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x59), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamProcAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x59), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field gets populated with the contents of the register specified by the address in the field stream_proc_addr, when stream_proc_rden is 1'b1.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamProcData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x5b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x5a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamProcRden_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x59), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamProcRden_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x59), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x54), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x54), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamprocDebugData_Set(void *const device,
    const uint64_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x63), (value >> 56));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x62), (value >> 48));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x61), (value >> 40));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x60), (value >> 32));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x5f), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x5e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x5d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x5c), (value >> 0));

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp1StreamprocDebugData_Get(void *const device,
    uint64_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x63), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x62), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x61), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x60), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x5f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x5e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x5d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x5c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2BbicStreamErrorToSpi_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x83), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x82), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x81), (value >> 0));

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2BbicStreamErrorToSpi_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x83), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x82), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x81), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2BbicStreamStatus_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x80), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x7f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x7e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field displays the number of the last stream that completed execution (even if it failed and errored out). Each time a stream completes, this register field will get
 * reset with the new stream number value that just completed.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2CompletedStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x70), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2EccDataParityError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x7d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2EccDataParityError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x7d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2EccDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x7d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2EccDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x7d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2IrqSensitivity_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x7d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2IrqSensitivity_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x7d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2LastStreamNum_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x6f), (value >> 0));

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2LastStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x6f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2MemHrespMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x7d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2MemHrespMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x7d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Access Flex_SP2 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2Select_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x3b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1: Access Flex_SP2 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2Select_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x3b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamBase_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x6e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x6d), (value >> 0));

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamBase_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x6e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x6d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x7c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x7c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamProcAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x71), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamProcAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x71), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field gets populated with the contents of the register specified by the address in the field stream_proc_addr, when stream_proc_rden is 1'b1.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamProcData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x73), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x72), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamProcRden_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x71), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamProcRden_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x71), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x6c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x6c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamprocDebugData_Set(void *const device,
    const uint64_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x7b), (value >> 56));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x7a), (value >> 48));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x79), (value >> 40));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x78), (value >> 32));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x77), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x76), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x75), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x74), (value >> 0));

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp2StreamprocDebugData_Get(void *const device,
    uint64_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x7b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x7a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x79), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x78), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x77), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x76), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x75), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x74), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3BbicStreamErrorToSpi_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x9b), (value >> 16), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x9a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x99), (value >> 0));

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3BbicStreamErrorToSpi_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x9b), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x9a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x99), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3BbicStreamStatus_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x98), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x97), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x96), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field displays the number of the last stream that completed execution (even if it failed and errored out). Each time a stream completes, this register field will get
 * reset with the new stream number value that just completed.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3CompletedStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x88), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3EccDataParityError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x95), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Parity error flag (write to clear)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3EccDataParityError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x95), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3EccDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x95), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Do not correct parity errors
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3EccDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x95), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3IrqSensitivity_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x95), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Set to interrupt on all parity errors (even correctable ones). Clear to interrupt only for uncorrectable (double bit) errors.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3IrqSensitivity_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x95), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3LastStreamNum_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x87), (value >> 0));

    return status;
}

/**
 * this 8 bit register indicates the last valid stream number. eg: if we have 50 streams in the stream memory, this register should be programmed to a number greater than 50.
 * If a stream execution is requested, for a stream greater than the setting in last_stream_num, the stream error will immediately error out.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3LastStreamNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x87), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3MemHrespMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x95), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting this bit will mask all bus errors from the memory to the ARM '- this includes parity errors, key mismatch errors etc. (Thus a parity error will not generate a hard fault in the ARM). It is recommended to have the error mask setting on while loading program code into the instruction memories. Mem Hresp Mask
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3MemHrespMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x95), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1: Access Flex_SP3 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3Select_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x3b), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 1: Access Flex_SP3 from SPI_TO_AHB
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3Select_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x3b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamBase_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x86), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x85), (value >> 0));

    return status;
}

/**
 * this data memory address points to the beginning of the stream memory. eg : if stream_base is 0x6000, then stream memory sits at data memory address 0x20006000. 
 * the stream memory can only sit in the data memory (cannot reside in the program memory)
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamBase_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x86), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x85), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamError_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x94), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This error bit is set if any stream triggered by the ARM, command mailbox, radio event etc. or one triggered after an external timer completes, errors out. It can be cleared by writing 1 to it. The cause of the error, the stream number etc. can be accessed through AHB registers. Writing to this bit , also clears all the error related AHB registers.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x94), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamProcAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x89), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * This field provides the address for a stream processor readback interface. The architectural registers within the stream processor , as well as an error register can be read out. The addresses of the registers is specified below. 
 * r0_addr         4'h0 		16 bit register data.
 * r1_addr         4'h1 		16 bit register data.
 * r2_addr         4'h2 		16 bit register data.
 * r3_addr         4'h3 		16 bit register data.
 * r4_addr      	4'h4 		16 bit register data.
 * r5_addr      	4'h5 		16 bit register data.
 * r6_addr      	4'h6 		16 bit register data.
 * r7_addr      	4'h7 		16 bit register data.
 * error_reg_addr  4'h8 		7 bits output :
 * 				error_data[0] invalid spi address access
 * 				error_data[1] CHECK_INSTR error
 * 				error_data[2] TIMEOUT error
 * 				error_data[3] stack overflow error
 * 				error_data[4] invalid stream number
 * 				error_data[5] invalid ahb address access error
 * 				error_data[6] invalid stream proc instruction OR external timers error (ran out of external timers) 
 * 				
 * In order to read back the value of the register, stream_proc_rden should be set in the register stream_proc_readback_addr.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamProcAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x89), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * This field gets populated with the contents of the register specified by the address in the field stream_proc_addr, when stream_proc_rden is 1'b1.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamProcData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x8b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x8a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamProcRden_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x89), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * If this bit is set to 1'b1, then the field stream_proc_data gets populated with the contents of the register specified in the address field stream_proc_addr. This readback feature is meant for debug purposes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamProcRden_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x89), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x84), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * This bit resets the stream processor , set stream_reset to 1'b1 to reset.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x84), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamprocDebugData_Set(void *const device,
    const uint64_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x93), (value >> 56));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x92), (value >> 48));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x91), (value >> 40));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x90), (value >> 32));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x8f), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x8e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x8d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x8c), (value >> 0));

    return status;
}

/**
 * 64 bit stream processor debug data. Any debug data can be written to this fields by the ARM/stream processor.
 */
static inline int32_t adrv9001_NvsRegmapCore1_Sp3StreamprocDebugData_Get(void *const device,
    uint64_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x93), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x92), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x91), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x90), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x8f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x8e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x8d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x8c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Auto increment for bus address. Incremented by the size specified in bus_size on every transaction (read or write).
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpAutoIncr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x31), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Auto increment for bus address. Incremented by the size specified in bus_size on every transaction (read or write).
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpAutoIncr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x31), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Address input for DMA. Only bits [16:2] are used in legacy mode. On writing this bitfield, a read will be performed for the specified bus_size. Data can then be read back any time.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpBusAddr_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x35), (value >> 26), 0x3f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x34), (value >> 18));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x33), (value >> 10));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x32), (value >> 2));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x3a), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * Address input for DMA. Only bits [16:2] are used in legacy mode. On writing this bitfield, a read will be performed for the specified bus_size. Data can then be read back any time.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpBusAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x35), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x34), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x33), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x32), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x3a), &register_value, 0x3, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Flag indicating bus error response. Write to clear.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpBusResponse_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x31), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Flag indicating bus error response. Write to clear.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpBusResponse_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x31), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Size of read/write. 0 = byte, 1 = half-word, 2 = full-word, 3 = invalid. Legacy mode overrides this to full-word reads and byte writes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpBusSize_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x31), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * Size of read/write. 0 = byte, 1 = half-word, 2 = full-word, 3 = invalid. Legacy mode overrides this to full-word reads and byte writes.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpBusSize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x31), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * Flag indicating bus is stalled.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpBusWaiting_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x31), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Uses style of DMA access from Mykonos and previous projects. Only SRAM is accessible.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpLegacyMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x31), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Uses style of DMA access from Mykonos and previous projects. Only SRAM is accessible.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpLegacyMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x31), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable stream Proc Main clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpMainClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x1f3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable stream Proc Main clock
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpMainClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x1f3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Data input/output for DMA. Writing this register causes a bus write transaction to take place. In legacy mode, any byte written will cause that byte to be written to the bus. In non-legacy mode, only writing byte 0 will cause a write transaction for the size specified in bus_size. Reading byte 3 of this register in legacy mode with rd_wrb set will cause new data to be populated. Reading byte 0 of this register in non-legacy mode with rd_wrb set will cause new data to be populated.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpMemWriteData_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x39), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x38), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x37), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x36), (value >> 0));

    return status;
}

/**
 * Data input/output for DMA. Writing this register causes a bus write transaction to take place. In legacy mode, any byte written will cause that byte to be written to the bus. In non-legacy mode, only writing byte 0 will cause a write transaction for the size specified in bus_size. Reading byte 3 of this register in legacy mode with rd_wrb set will cause new data to be populated. Reading byte 0 of this register in non-legacy mode with rd_wrb set will cause new data to be populated.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpMemWriteData_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x39), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x38), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x37), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x36), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1 = read, 0 = write
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpRdWrb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x31), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 1 = read, 0 = write
 */
static inline int32_t adrv9001_NvsRegmapCore1_SpRdWrb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x31), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx1ChanControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx1ChanControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx1In_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xb0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx1MainControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx1MainControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx1Out_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xac), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx1Out_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xac), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx2ChanControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx2ChanControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx2In_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xb1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx2MainControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx2MainControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx2Out_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xad), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioRx2Out_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xad), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1ChanControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1ChanControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1In_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xae), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1MainControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1MainControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1Out_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xa9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1Out_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xa9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1RefclkGpioSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x145), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1RefclkGpioSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x145), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1RefclkIn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xab), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1RefclkOut_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa8), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx1RefclkOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa8), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2ChanControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2ChanControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2In_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xaf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2MainControlOutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x144), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2MainControlOutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x144), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2Out_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0xaa), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2Out_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0xaa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2RefclkGpioSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x145), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2RefclkGpioSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x145), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2RefclkIn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xab), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2RefclkOut_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa8), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiCmosGpioTx2RefclkOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa8), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiRx1PortDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiRx1PortDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiRx2PortDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa7), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiRx2PortDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiTx1PortDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiTx1PortDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiTx2PortDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xa7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SsiTx2PortDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xa7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio0PinSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13a), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio0PinSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio1PinSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13a), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio1PinSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13a), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio2PinSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13b), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio2PinSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio3PinSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13b), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpio3PinSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13b), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpioPinMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x139), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_StreamProcGpioPinMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x139), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1d4), (value >> 0));

    return status;
}

/**
 * General purpose SW spare bits
 */
static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1d5), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1d6), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister3_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1d7), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister3_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister4_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1d8), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister4_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister5_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1d9), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister5_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1d9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister6_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1da), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister6_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1da), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister7_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x200 + 0x1db), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_SwSpareRegister7_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x200 + 0x1db), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Powers down the MCS pulse associated with digital REF_CLK.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SysrefForcePdDigpath_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x194), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * Powers down the MCS pulse associated with digital REF_CLK.
 */
static inline int32_t adrv9001_NvsRegmapCore1_SysrefForcePdDigpath_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x194), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_TempSenseClkArmSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xc), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_TempSenseClkArmSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_TempSenseClkDiv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xd), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_TempSenseClkDiv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xd), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_TempSenseClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0xc), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_TempSenseClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0xc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1Lo1InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x165), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1Lo1InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x165), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1Lo2InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x165), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1Lo2InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x165), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1LomuxPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x165), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1LomuxPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x165), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  configure TX1 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx1Mag13tapsCoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * 1’b1:  configure TX1 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx1Mag13tapsCoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 2’b00: TX1 mag comp 21 taps PFIR select bank A coeff
 *                                                       2’b01: TX1 mag comp 21 taps PFIR select bank B coeff
 *                                                       2’b10: TX1 mag comp 21 taps PFIR select bank C coeff
 *                                                       2’b11: TX1 mag comp 21 taps PFIR select bank D coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx1Mag21tapsBankSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x155), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * 2’b00: TX1 mag comp 21 taps PFIR select bank A coeff
 *                                                       2’b01: TX1 mag comp 21 taps PFIR select bank B coeff
 *                                                       2’b10: TX1 mag comp 21 taps PFIR select bank C coeff
 *                                                       2’b11: TX1 mag comp 21 taps PFIR select bank D coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx1Mag21tapsBankSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x155), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1SelLo2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x169), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1SelLo2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x169), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcDecrAttenGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcDecrAttenGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcDecrAttenGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13c), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcDecrAttenGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13c), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcIncrAttenGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13d), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcIncrAttenGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcIncrAttenGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13c), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx1TpcIncrAttenGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2Lo1InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x166), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2Lo1InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x166), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2Lo2InbufPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x166), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2Lo2InbufPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x166), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2LomuxPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x166), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2LomuxPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x166), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  configure TX2 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx2Mag13tapsCoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * 1’b1:  configure TX2 mag comp 13 taps PFIR coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx2Mag13tapsCoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 2’b00: TX2 mag comp 21 taps PFIR select bank A coeff
 *                                                       2’b01: TX2 mag comp 21 taps PFIR select bank B coeff
 *                                                       2’b10: TX2 mag comp 21 taps PFIR select bank C coeff
 *                                                       2’b11: TX2 mag comp 21 taps PFIR select bank D coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx2Mag21tapsBankSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x155), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * 2’b00: TX2 mag comp 21 taps PFIR select bank A coeff
 *                                                       2’b01: TX2 mag comp 21 taps PFIR select bank B coeff
 *                                                       2’b10: TX2 mag comp 21 taps PFIR select bank C coeff
 *                                                       2’b11: TX2 mag comp 21 taps PFIR select bank D coeff
 */
static inline int32_t adrv9001_NvsRegmapCore1_Tx2Mag21tapsBankSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x155), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2SelLo2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x16a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2SelLo2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x16a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcDecrAttenGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcDecrAttenGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcDecrAttenGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13e), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcDecrAttenGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13e), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcIncrAttenGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcIncrAttenGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcIncrAttenGpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x13e), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore1_Tx2TpcIncrAttenGpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x13e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank A coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsACoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank A coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsACoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank B coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsBCoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank B coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsBCoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank C coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsCCoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank C coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsCCoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank D coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsDCoeffSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x200 + 0x154), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * 1’b1:  configure mag comp 21 taps PFIR bank D coefficients
 */
static inline int32_t adrv9001_NvsRegmapCore1_TxMag21tapsDCoeffSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x200 + 0x154), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_CORE_1_H__