//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_38.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot38(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[38] = {1.612702673482496e-02,1.451840623965648e-01,4.035162716683504e-01,7.915619649204380e-01,1.309983739894890e+00,
    1.959674771052835e+00,2.741767419118650e+00,3.657644364770256e+00,4.708952537591409e+00,5.897620190977973e+00,7.225877569992459e+00,8.696281737817396e+00,
    1.031174627493858e+01,1.207557675358126e+01,1.399151313203277e+01,1.606378052849600e+01,1.829715024902810e+01,2.069701349751276e+01,2.326947094342735e+01,
    2.602144234786216e+01,2.896080187349915e+01,3.209654671911066e+01,3.543900961869141e+01,3.900013000089935e+01,4.279380498833236e+01,4.683635123034369e+01,
    5.114712407453766e+01,5.574936588427845e+01,6.067139810983177e+01,6.594834725083705e+01,7.162473497065578e+01,7.775853867158189e+01,8.442791425946224e+01,
    9.174313520742761e+01,9.986988221096631e+01,1.090811431935787e+02,1.198994682789361e+02,1.336704180732151e+02};
  constexpr double aw[38] = {2.499300801393398e-01,2.197622105162462e-01,1.698744354394837e-01,1.153864382487449e-01,6.882525739412659e-02,
    3.601824635668120e-02,1.651928500999408e-02,6.630685725990292e-03,2.325492670823089e-03,7.112636244182827e-04,1.892976217867182e-04,4.372783157754550e-05,
    8.742083700807699e-06,1.507626466824516e-06,2.234525098112193e-07,2.834470735997166e-08,3.062683224651583e-09,2.803868677899601e-10,2.161805462329055e-11,
    1.394137712580660e-12,7.461785865948289e-14,3.285224408726859e-15,1.177709463373407e-16,3.397355176409182e-18,7.778858985385601e-20,1.391146358285056e-21,
    1.906452084392684e-23,1.956742973666213e-25,1.462832930242021e-27,7.695142746917200e-30,2.726617129645451e-32,6.148207274311863e-35,8.173445792984962e-38,
    5.753058385039598e-41,1.825256448013997e-44,2.004878007028095e-48,4.619586959159565e-53,6.270378448069565e-59};
  constexpr double x[14592] = {  8.322206759644798e-04, -5.401812209542431e-06,  2.628567628563713e-08, -1.136346937323156e-10,  4.602267904482250e-13,
 -1.787909380929331e-15,  6.746219942814528e-18, -2.490788573139583e-20,  9.041131747210796e-23, -3.236674206385594e-25,  1.145313803147371e-27, -4.012223787660130e-30,
  7.481888019044308e-03, -4.840428968043917e-05,  2.339885658806322e-07, -1.000410934320522e-09,  3.984434207095561e-12, -1.511581616260292e-14,  5.522778915521922e-17,
 -1.954381687481810e-19,  6.715981087289843e-22, -2.242096178347991e-24,  7.261211566838565e-27, -2.273000600141480e-29,  2.073808464403412e-02, -1.332844331905790e-04,
  6.357888099153418e-07, -2.657711587989285e-09,  1.022349407176396e-11, -3.686292929740626e-14,  1.252876429447180e-16, -4.002838300430188e-19,  1.187897476698084e-21,
 -3.182389930226320e-24,  7.148561455111271e-27, -1.000359547851643e-29,  4.051478204986419e-02, -2.578210962082437e-04,  1.205271415429888e-06, -4.865648262730874e-09,
  1.770313174567632e-11, -5.854429562056792e-14,  1.736286606819704e-16, -4.404776365093631e-19,  8.129896898241242e-22, -7.351147014191450e-26, -9.062521447704663e-27,
  5.877052527239649e-29,  6.668355589544671e-02, -4.187530848783499e-04,  1.904759439008017e-06, -7.324632524637996e-09,  2.454922610351552e-11, -7.043773774441755e-14,
  1.579649808309715e-16, -1.670993527596844e-19, -8.114779575797334e-22,  7.002760712035505e-24, -3.356754964215646e-26,  1.221293944085650e-28,  9.907432627697174e-02,
 -6.118619398884386e-04,  2.687525980614840e-06, -9.688173298669137e-09,  2.882969009287168e-11, -6.435354973060597e-14,  5.526379906652346e-17,  4.201119093277300e-19,
 -3.153892655389827e-21,  1.362020425312485e-23, -4.157617576077421e-26,  7.239384616403447e-29,  1.374763416914000e-01, -8.320792673661527e-04,  3.500546017651710e-06,
 -1.160115169312098e-08,  2.891624888324125e-11, -3.614347635315062e-14, -1.257071105894614e-16,  1.137886884942981e-18, -4.898142528441030e-21,  1.332514369472585e-23,
 -1.108748114953523e-26, -1.225799423736796e-28,  1.816394039584119e-01, -1.073616083023569e-03,  4.287632351406654e-06, -1.273960283679396e-08,  2.380520418137988e-11,
  1.269494975727343e-14, -3.423697498612021e-16,  1.671610652457548e-18, -4.588705157442619e-21,  2.326874807835329e-24,  5.277529951822749e-26, -3.356008179251415e-28,
  2.312753305759027e-01, -1.330111091985351e-03,  4.992777193137674e-06, -1.284784447226995e-08,  1.334207300672988e-11,  7.476099027631826e-14, -5.283585150724874e-16,
  1.699909123165169e-18, -1.508500844398130e-21, -1.654026921591058e-23,  1.107829529652612e-25, -3.448039701877993e-28,  2.860596501133651e-01, -1.594794345530187e-03,
  5.563507824548558e-06, -1.176902232193742e-08, -1.690213135846114e-12,  1.379709533345674e-13, -6.130954366360148e-16,  1.043131263322003e-18,  3.690912494732732e-21,
 -3.368252414087897e-23,  1.111979509679894e-25, -2.756143423921214e-29,  3.456335252918116e-01, -1.860662306463543e-03,  5.954062171203471e-06, -9.465774863772187e-09,
 -1.963829537136090e-11,  1.880358588045976e-13, -5.451020107205997e-16, -2.278040359963074e-19,  9.008871469336037e-21, -3.736231394225084e-23,  2.890525270117623e-26,
  4.754627696509037e-28,  4.096058973488380e-01, -2.120660027471026e-03,  6.128198344838622e-06, -6.028697491466932e-09, -3.819430228004426e-11,  2.116667344506707e-13,
 -3.116301606936009e-16, -1.774480344708657e-18,  1.185906479588554e-20, -2.087299095276882e-23, -1.060374056412960e-25,  7.975982685342958e-28,  4.775558441359760e-01,
 -2.367865911124659e-03,  6.061470999560296e-06, -1.671515271537443e-09, -5.472992920842487e-11,  1.997830135279540e-13,  5.208875526100693e-17, -3.083934451299463e-18,
  1.028025292502900e-20,  1.199131807573256e-23, -2.157328406918517e-25,  6.048895444018749e-28,  5.490351431383625e-01, -2.595674384625005e-03,  5.742835897684704e-06,
  3.286765217421793e-09, -6.669785715662317e-11,  1.499682143136804e-13,  4.677745898963742e-16, -3.645009088082739e-18,  4.024590910266007e-21,  4.698483625450388e-23,
 -2.195984456195041e-25, -1.052538724428339e-28,  6.235710292429733e-01, -2.797971793812149e-03,  5.175481033991338e-06,  8.451097085965621e-09, -7.203739351859410e-11,
  6.756147992558251e-14,  8.327435627521538e-16, -3.144921750661156e-18, -5.047817414241466e-21,  6.583048275179770e-23, -9.071302284215583e-26, -9.207993333623307e-28,
  7.006691356139048e-01, -2.969300904657982e-03,  4.376826159938512e-06,  1.338818498311910e-08, -6.951885933173268e-11, -3.493445295340071e-14,  1.047469644463853e-15,
 -1.609482045112347e-18, -1.354678020076604e-20,  5.601169031091274e-23,  1.158302449591383e-25, -1.261005928588594e-27,  7.798166044682827e-01, -3.105009599452768e-03,
  3.377680291766057e-06,  1.766904184270859e-08, -5.896945307570872e-11, -1.400718973747092e-13,  1.044223106536727e-15,  5.728040900514534e-19, -1.792105615031067e-20,
  1.852574864689138e-23,  2.868717797741349e-25, -8.020138144178935e-28,  8.604853528956433e-01, -3.201379669874649e-03,  2.220596163641253e-06,  2.091195679324945e-08,
 -4.134103014850198e-11, -2.288705246725575e-13,  8.082089785399231e-16,  2.760623086368905e-18, -1.603181492746272e-20, -3.115209744730014e-23,  3.173701143701893e-25,
  2.393767614270179e-28,  9.421354771432870e-01, -3.255732037971843e-03,  9.575087879770241e-07,  2.282139651079254e-08, -1.860481892349807e-11, -2.847022485778662e-13,
  3.845185474934997e-16,  4.270225797762091e-18, -8.200569194937924e-21, -7.006388433521565e-23,  1.780491897359702e-25,  1.207728480368818e-27,  1.024218777021382e+00,
 -3.266505273630565e-03, -3.532105488379982e-07,  2.321870684533748e-08,  6.514280723944533e-12, -2.967970800730772e-13, -1.317616063561733e-16,  4.612042746005755e-18,
  2.791661825297146e-21, -7.934676691004049e-23, -6.083415360985731e-26,  1.453513841563806e-27,  1.106182380290927e+00, -3.233304914898825e-03, -1.650116138752690e-06,
  2.206127076063044e-08,  3.092494685310371e-11, -2.625806293207923e-13, -6.199448820508599e-16,  3.665989620213490e-18,  1.280433135626372e-20, -5.417501576841823e-23,
 -2.681465400628909e-25,  8.009400945459166e-28,  1.187472445116600e+00, -3.156921823708795e-03, -2.872268683459951e-06,  1.944794069113145e-08,  5.161889144913800e-11,
 -1.883000752287337e-13, -9.658731700497800e-16,  1.728401365587280e-18,  1.806897123455808e-20, -6.498556847235722e-24, -3.303325468931670e-25, -3.167645884363140e-28,
  1.267537916931356e+00, -3.039318608745355e-03, -3.962821327327662e-06,  1.560998423158254e-08,  6.611199389734666e-11, -8.777295660510123e-14, -1.092532710910189e-15,
 -5.891710870258339e-19,  1.677489694203798e-20,  4.108105333154094e-23, -2.196746055687223e-25, -1.164836361926332e-27,  1.345834314411118e+00, -2.883584000740382e-03,
 -4.872392856629103e-06,  1.088831570176077e-08,  7.280677399637719e-11,  2.048301466950185e-14, -9.802179189929078e-16, -2.572995417766117e-18,  9.787607431875497e-21,
  6.699195683739735e-23, -8.355242754963606e-27, -1.227936927050954e-27,  1.421827517740405e+00, -2.693855951522467e-03, -5.562019105533369e-06,  5.699269336436423e-09,
  7.121768838775193e-11,  1.171092622434337e-13, -6.703593706835048e-16, -3.652943852528054e-18,  1.812425741847911e-22,  6.150436961615279e-23,  1.797847873022111e-25,
 -5.529852577678532e-28,  1.494997531010253e+00, -2.475215122238964e-03, -6.005495889481593e-06,  4.924393245984589e-10,  6.202248590658145e-11,  1.858942243141756e-13,
 -2.520327351210281e-16, -3.589696594150566e-18, -8.176640623089432e-21,  3.082341272905322e-23,  2.467014558804110e-25,  3.320669572715432e-28,  1.564842189477048e+00,
 -2.233551301747458e-03, -6.190961292238004e-06, -4.294977566773808e-09,  4.693110452370318e-11,  2.169968550790260e-13,  1.645997371950678e-16, -2.535484370071589e-18,
 -1.231083302851826e-20, -7.456319972910017e-24,  1.757173276318647e-25,  8.358110089253856e-28,  1.630880781573930e+00, -1.975406125423155e-03, -6.121610051194865e-06,
 -8.282459566969815e-09,  2.839369575273124e-11,  2.086897542113407e-13,  4.797407067908668e-16, -9.504165916804243e-19, -1.131198772133303e-20, -3.451791905010482e-23,
  3.127923082949818e-26,  7.195509871814274e-28,  1.692657555053957e+00, -1.707796219382337e-03, -5.815485545150004e-06, -1.118426897069768e-08,  9.196237196758638e-12,
  1.672529551107448e-13,  6.307685064124159e-16,  5.872770148701861e-19, -6.490856052615722e-21, -4.009237959719042e-23, -9.172491815322491e-26,  2.039199333552797e-28,
  1.749745076504791e+00, -1.438021547933769e-03, -5.304352294663123e-06, -1.283722543068569e-08, -7.988819384398603e-12,  1.050851226227580e-13,  6.065187651725724e-16,
  1.598921270704869e-18, -5.190699488207081e-22, -2.646288040825537e-23, -1.306359643303366e-25, -2.732981601755549e-28,  1.801747413761183e+00, -1.173464267331102e-03,
 -4.631710306905344e-06, -1.321507284369650e-08, -2.102172416485978e-11,  3.751880627541783e-14,  4.452691634437077e-16,  1.865414519486711e-18,  3.950453106857341e-21,
 -5.092369072913500e-24, -8.714238752019852e-26, -4.135831838614756e-28,  1.848303111529030e+00, -9.213837639021283e-04, -3.850068201342406e-06, -1.242782718543012e-08,
 -2.861440384782912e-11, -2.087186576137146e-14,  2.179149353398239e-16,  1.471508759443428e-18,  5.473425549718220e-21,  1.129521053908174e-23, -1.207336995105355e-26,
 -2.376663346990215e-28,  1.889087931988815e+00, -6.887137602664948e-04, -3.017641063236305e-06, -1.070615332610764e-08, -3.049643124779442e-11, -5.957369818335894e-14,
  2.493620912679678e-18,  7.264801075453520e-19,  4.257186694344629e-21,  1.597188648922570e-23,  3.908556507747133e-26,  1.634994299456126e-29,  1.923817334808026e+00,
 -4.818673932830288e-04, -2.194677932664685e-06, -8.372495993462889e-09, -2.740166740700217e-11, -7.426125634652133e-14, -1.412249581074456e-16,  4.643765693491522e-21,
  1.726476424814013e-21,  1.060528887915254e-23,  4.399605679060913e-26,  1.371386610023144e-28,  1.952248677189310e+00, -3.065559796067886e-04, -1.439649827568507e-06,
 -5.802190894004128e-09, -2.088045297391254e-11, -6.726691838759752e-14, -1.887478751825886e-16, -4.201581632916426e-19, -4.539268560118953e-22,  2.124373798874007e-24,
  1.909460819582093e-26,  9.629059019541195e-29,  1.974183137407513e+00, -1.676267031679739e-04, -8.055397732417463e-07, -3.378928798755654e-09, -1.297268260017209e-11,
 -4.633527382294636e-14, -1.542866844267276e-16, -4.744645259626859e-19, -1.311947232058416e-21, -3.037450902406949e-24, -4.435966570463496e-27,  6.994001629162906e-30,
  1.989467512537276e+00, -6.892298105857340e-05, -3.364669390642755e-07, -1.449584887670875e-09, -5.801347355448011e-12, -2.203627530077040e-14, -8.025039001335761e-17,
 -2.814247045248461e-19, -9.510767787741342e-22, -3.090196429978765e-24, -9.594837945278731e-27, -2.812926255609014e-29,  1.997998096509861e+00, -1.315706409551150e-05,
 -6.478976547635902e-08, -2.832207766426813e-10, -1.158757138919329e-12, -4.542125115750994e-15, -1.726894110905446e-17, -6.414039768518902e-20, -2.337777278300375e-22,
 -8.385777756520328e-25, -2.966097822337973e-27, -1.035779458483250e-29,  8.110255349248618e-04, -5.196858744491594e-06,  2.496508957453444e-08, -1.065485648914059e-10,
  4.260328495745206e-13, -1.634052683278702e-15,  6.087612818906731e-18, -2.219264806916214e-20,  7.954309892596699e-23, -2.811974028688360e-25,  9.826454194244666e-28,
 -3.399765752058987e-30,  7.291940146454608e-03, -4.657933962935091e-05,  2.223563922155757e-07, -9.390083183716648e-10,  3.694941540960129e-12, -1.385366057314344e-14,
  5.004465076277246e-17, -1.751843200437347e-19,  5.958782164454708e-22, -1.970720192445035e-24,  6.329776533757567e-27, -1.968242190858472e-29,  2.021492139941254e-02,
 -1.283229670659176e-04,  6.048539157429586e-07, -2.499874111200948e-09,  9.515418433726971e-12, -3.398632970387538e-14,  1.145950390838745e-16, -3.640498545048376e-19,
  1.078370382015569e-21, -2.905456760515327e-24,  6.693905652913513e-27, -1.058160516757423e-29,  3.950241890091778e-02, -2.484077482865323e-04,  1.148545219766556e-06,
 -4.591542970837964e-09,  1.657293288260575e-11, -5.452227330478779e-14,  1.616586378122143e-16, -4.145694323273352e-19,  8.044083999870873e-22, -3.878922945248179e-25,
 -6.741373908684133e-27,  4.711358738362822e-29,  6.503847232230708e-02, -4.038600200731523e-04,  1.819174748288125e-06, -6.942910599368956e-09,  2.317798975335731e-11,
 -6.670543396133907e-14,  1.529587677020767e-16, -1.892819697177035e-19, -5.822949227841867e-22,  5.762854539674775e-24, -2.854099473935322e-26,  1.065836720536324e-28,
  9.666915357418662e-02, -5.908190200163087e-04,  2.573993321817655e-06, -9.237118961169590e-09,  2.755677816518325e-11, -6.289702368418907e-14,  6.568544935490278e-17,
  3.267179359693767e-19, -2.692718901509244e-21,  1.202229829160445e-23, -3.829076384262640e-26,  7.630656629707410e-29,  1.342031627008197e-01, -8.046239452370807e-04,
  3.364083800389771e-06, -1.114442806960376e-08,  2.816570070958133e-11, -3.879538875757862e-14, -9.596919772642517e-17,  9.887261945572317e-19, -4.427609425669332e-21,
  1.278581492554851e-23, -1.559646909807700e-26, -8.377483689243153e-29,  1.774125826972048e-01, -1.039920033659379e-03,  4.137049392229305e-06, -1.235711921174522e-08,
  2.398064027504572e-11,  5.023235451962122e-15, -2.976050563179582e-16,  1.526491859235212e-18, -4.470354004236607e-21,  4.158333782799601e-24,  3.918074954412816e-26,
 -2.830173178255046e-28,  2.260337994745075e-01, -1.290781832690687e-03,  4.839931052913305e-06, -1.262308244697565e-08,  1.471431174590780e-11,  6.264558029032573e-14,
 -4.815204575807733e-16,  1.642935625117437e-18, -2.027818664125975e-21, -1.240954501278022e-23,  9.584183768550072e-26, -3.327000187910207e-28,  2.797685940317109e-01,
 -1.550851451171291e-03,  5.422205795019593e-06, -1.177477969934924e-08,  9.244931805540839e-13,  1.236194114916812e-13, -5.824104223124826e-16,  1.142694065967337e-18,
  2.557909938430701e-21, -2.928073440761972e-23,  1.083887055363579e-25, -9.664459535047383e-29,  3.382854144916977e-01, -1.813489226715758e-03,  5.838709393089132e-06,
 -9.750614263770755e-09, -1.600875622132266e-11,  1.749082105998240e-13, -5.476449373393852e-16,  3.922096549858468e-20,  7.689338801132924e-21, -3.582517828491022e-23,
  4.704768598157644e-26,  3.514063344008880e-28,  4.012208359856057e-01, -2.071933888029589e-03,  6.052325661320554e-06, -6.606362146880573e-09, -3.403956477635111e-11,
  2.036335456643644e-13, -3.561211594638581e-16, -1.407764468756468e-18,  1.103953511134944e-20, -2.443618609786149e-23, -7.273219303925012e-26,  7.139895120595486e-28,
  4.681812163767634e-01, -2.319468958433505e-03,  6.036290741310324e-06, -2.515189618700683e-09, -5.072856840256451e-11,  2.000344557188314e-13, -2.960252581040038e-17,
 -2.749671621360440e-18,  1.056319640448380e-20,  3.912357421174607e-24, -1.878386775223669e-25,  6.566756256692049e-28,  5.387445554617245e-01, -2.549591842786712e-03,
  5.775974946766829e-06,  2.244169976027634e-09, -6.359441222691209e-11,  1.599861364720270e-13,  3.677595122761735e-16, -3.490859753673558e-18,  5.557350556853899e-21,
  3.816630559185389e-23, -2.199504481395140e-25,  8.383395019468102e-29,  6.124625645293854e-01, -2.756181777452555e-03,  5.270026634795145e-06,  7.310364283799020e-09,
 -7.049352328611100e-11,  8.647454166705347e-14,  7.427751718420644e-16, -3.269309521561714e-18, -2.752452076868272e-21,  6.145169604350861e-23, -1.267257598087336e-25,
 -7.149708356787240e-28,  6.888629519617216e-01, -2.933662615934794e-03,  4.530791893078210e-06,  1.227164344234046e-08, -6.997005112943849e-11, -1.038306014227437e-14,
  9.966440750858403e-16, -2.009929877490723e-18, -1.146021963190628e-20,  5.954843661826849e-23,  6.142718945119758e-26, -1.203479480115607e-27,  7.674519288885172e-01,
 -3.077156286841684e-03,  3.583959701841392e-06,  1.670448505272632e-08, -6.151931036895365e-11, -1.148821895326507e-13,  1.052348622899405e-15,  1.214351688959714e-20,
 -1.705657325272658e-20,  2.924213769851962e-23,  2.477448267783733e-25, -9.671055482097179e-28,  8.477169367386463e-01, -3.182622712309496e-03,  2.467423334865829e-06,
  2.021496015719247e-08, -4.571851307342385e-11, -2.086048591064398e-13,  8.781731384124891e-16,  2.232126877592894e-18, -1.692303917902684e-20, -1.833364764017234e-23,
  3.214201264173497e-25, -5.313091275265491e-29,  9.291295958476954e-01, -3.246982030436474e-03,  1.229393313940874e-06,  2.247870855013864e-08, -2.419705752663977e-11,
 -2.740709397798999e-13,  5.000422140116451e-16,  3.968925804508722e-18, -1.058239785902833e-20, -6.193812628712099e-23,  2.266919157544333e-25,  9.955687743535690e-28,
  1.011148871085361e+00, -3.268215140237578e-03, -7.415701804672541e-08,  2.327532004129361e-08,  5.572173690909270e-13, -2.984022706799810e-13, -1.805788757370893e-18,
  4.655328569244736e-18, -9.307414934312516e-23, -8.048719187557967e-23,  4.028861039547363e-27,  1.483134192148936e-27,  1.093224446772256e+00, -3.245438895624952e-03,
 -1.382587919276584e-06,  2.251328431089127e-08,  2.553309333588115e-11, -2.761831078101696e-13, -5.118683639012364e-16,  4.042526934812119e-18,  1.067016758507795e-20,
 -6.411864168839883e-23, -2.271812141429121e-25,  1.055178795781960e-27,  1.174800299000420e+00, -3.178952725997365e-03, -2.634066291704113e-06,  2.024247306987505e-08,
  4.762533681971437e-11, -2.108352589768826e-13, -9.094365178487267e-16,  2.300292832337879e-18,  1.759458570947093e-20, -1.990662062141070e-23, -3.379403739980183e-25,
 -2.451275114229682e-29,  1.255318448913360e+00, -3.070254060352707e-03, -3.769217322805536e-06,  1.665230329751299e-08,  6.409330973399037e-11, -1.141297416869727e-13,
 -1.101304679803710e-15, -3.050606540523755e-20,  1.808357204726300e-20,  3.130010941914163e-23, -2.684870436681377e-25, -1.043252699835612e-27,  1.334222875622687e+00,
 -2.922020678286352e-03, -4.734734304888872e-06,  1.205519933420467e-08,  7.297553878576974e-11, -3.869126404081959e-15, -1.047515465571943e-15, -2.221377122649717e-18,
  1.217993080224757e-20,  6.553931708862905e-23, -6.513274377335692e-26, -1.345259741975122e-27,  1.410963562348011e+00, -2.738058996073062e-03, -5.486716609829655e-06,
  6.856580946423660e-09,  7.339071475246752e-11,  9.979599783283757e-14, -7.722181412682136e-16, -3.610381450370028e-18,  2.518337820149796e-21,  6.813837031618329e-23,
  1.501505684065257e-25, -7.950790563443255e-28,  1.485000644198722e+00, -2.523218301898846e-03, -5.993510927963306e-06,  1.514178832260870e-09,  6.567159290052163e-11,
  1.786108279398427e-13, -3.560268285081334e-16, -3.831664566830730e-18, -6.886292179732862e-21,  4.093466460289690e-23,  2.575686754206702e-25,  1.546258802734173e-28,
  1.555808620929099e+00, -2.283272054641528e-03, -6.237851791698310e-06, -3.509170700915464e-09,  5.130456414868650e-11,  2.200506123079076e-13,  8.806065697587484e-17,
 -2.932297241118096e-18, -1.244386059142917e-20,  3.096175335359296e-25,  2.125546594667336e-25,  8.322563133705241e-28,  1.622880593170946e+00, -2.024768519581854e-03,
 -6.218134036069397e-06, -7.794154290856711e-09,  3.268025682742581e-11,  2.198421490570623e-13,  4.478765523502885e-16, -1.331976815433217e-18, -1.252413171445663e-20,
 -3.259515344311417e-23,  6.580313876981695e-26,  8.490496674682874e-28,  1.685732476276557e+00, -1.754854187683268e-03, -5.948700868488982e-06, -1.100954102931561e-08,
  1.269388563370112e-11,  1.825638949317828e-13,  6.440824433599933e-16,  3.557880691400363e-19, -7.997720909834739e-21, -4.354421632770894e-23, -7.989215956344231e-26,
  3.377489462939491e-28,  1.743907142196657e+00, -1.481074561127412e-03, -5.459093966891534e-06, -1.294742684441648e-08, -5.737939643792912e-12,  1.201760166878555e-13,
  6.509054768687337e-16,  1.566037000526659e-18, -1.568593775396952e-21, -3.191799157997572e-23, -1.418121013072868e-25, -2.310041024149246e-28,  1.796978436989118e+00,
 -1.211157930301706e-03, -4.792282574183829e-06, -1.354481877700673e-08, -2.016017966322525e-11,  4.884613597378066e-14,  4.992380065170692e-16,  1.988186650565545e-18,
  3.699873683326000e-21, -8.955806394870489e-24, -1.063642632854212e-25, -4.594938859524702e-28,  1.844555019839987e+00, -9.527886581436633e-04, -4.001961926151180e-06,
 -1.288869861482406e-08, -2.897610032877062e-11, -1.512731659800335e-14,  2.616296166529186e-16,  1.653049677804448e-18,  5.868675045764669e-21,  1.058486519550040e-23,
 -2.391344945211317e-26, -3.021419486236943e-28,  1.886283969193139e+00, -7.133771696567479e-04, -3.149081849078157e-06, -1.120361756614369e-08, -3.168557723334694e-11,
 -5.925381787418126e-14,  2.483088081133483e-17,  8.722126217721912e-19,  4.860425864806334e-21,  1.754257898606933e-23,  3.925752690378194e-26, -9.978562707092675e-30,
  1.921854103405710e+00, -4.998342638784430e-04, -2.297828053219445e-06, -8.822988469170023e-09, -2.892074218524733e-11, -7.764248688294321e-14, -1.402615843602510e-16,
  6.635134226938642e-20,  2.141433502482681e-21,  1.248968191529962e-23,  5.031822552254678e-26,  1.501187478338273e-28,  1.950998969752199e+00, -3.183574667382207e-04,
 -1.511325846217373e-06, -6.147291004235971e-09, -2.227205191366697e-11, -7.193960578764483e-14, -2.007030652864308e-16, -4.333041544093974e-19, -3.626295287850205e-22,
  2.978506154255241e-24,  2.375672480805175e-26,  1.161669862429920e-28,  1.973499480083840e+00, -1.742368102654247e-04, -8.473635418941894e-07, -3.594111157564743e-09,
 -1.393751791726895e-11, -5.020242057671436e-14, -1.681761224358855e-16, -5.182299645129701e-19, -1.424401632307964e-21, -3.207223375188582e-24, -4.012438853987811e-27,
  1.252228136896240e-29,  1.989186324700815e+00, -7.168590880075346e-05, -3.544337774540869e-07, -1.546039638294089e-09, -6.261989446060459e-12, -2.406038795714027e-14,
 -8.857363072360167e-17, -3.137156733318221e-19, -1.069540445704310e-21, -3.499851713549915e-24, -1.091617801938548e-26, -3.200889881252188e-29,  1.997944409638199e+00,
 -1.368929905197022e-05, -6.830272793381877e-08, -3.025107757737971e-10, -1.253894147785229e-12, -4.979004952016684e-15, -1.917431161902746e-17, -7.212812666530519e-20,
 -2.662167226974645e-22, -9.668650551697569e-25, -3.461934243730811e-27, -1.223543083869931e-29,  7.906296040748415e-04, -5.002138911289148e-06,  2.372635262362807e-08,
 -9.998575569685959e-11,  3.947639378333282e-13, -1.495128167130121e-15,  5.500384578223252e-18, -1.980193561867408e-20,  7.009289309028192e-23, -2.447257661495198e-25,
  8.446717115095031e-28, -2.886640950347342e-30,  7.109110517199439e-03, -4.484457650852013e-05,  2.114340702903010e-07, -8.820422109953854e-10,  3.429492591465787e-12,
 -1.270936003875076e-14,  4.539611652386726e-17, -1.572041314719771e-19,  5.292883684353766e-22, -1.734047829402232e-24,  5.522974433001759e-27, -1.705456643903920e-29,
  1.971112079038270e-02, -1.236015922087954e-04,  5.757469503465773e-07, -2.352919193902887e-09,  8.862388733078408e-12, -3.135456495186073e-14,  1.048693918901481e-16,
 -3.311647839882563e-19,  9.784806338442454e-22, -2.647085028269962e-24,  6.223534427382749e-27, -1.074095274544738e-29,  3.852682193046731e-02, -2.394353542769218e-04,
  1.095002393160736e-06, -4.334892700133471e-09,  1.552036021768055e-11, -5.077886725224351e-14,  1.504086209508739e-16, -3.890999576495396e-19,  7.860629335596712e-22,
 -6.190409509825956e-25, -4.885656300527361e-27,  3.755233756434283e-29,  6.345162014507320e-02, -3.896336774878888e-04,  1.738041523613850e-06, -6.582538011982696e-09,
  2.188015179043415e-11, -6.309994381633238e-14,  1.474276739615960e-16, -2.048074232969029e-19, -3.942904067726860e-22,  4.710751953449508e-24, -2.416683114567923e-26,
  9.248363009427995e-29,  9.434636982270560e-02, -5.706630547404836e-04,  2.465752118495039e-06, -8.806185440293909e-09,  2.631529453314772e-11, -6.122014304041554e-14,
  7.369020882431054e-17,  2.471867645263844e-19, -2.286672493491857e-21,  1.055820041313819e-23, -3.490982297556954e-26,  7.691306623266992e-29,  1.310376560210589e-01,
 -7.782386060471724e-04,  3.233028585529320e-06, -1.070010013425154e-08,  2.736892180339340e-11, -4.078202690232647e-14, -7.020013376196369e-17,  8.542802945377407e-19,
 -3.979349232370915e-21,  1.209786604930565e-23, -1.857592358844164e-26, -5.285663013202606e-29,  1.733181654273258e-01, -1.007410252324572e-03,  3.991068200417492e-06,
 -1.197299908341351e-08,  2.401305893659219e-11, -1.622400884949863e-15, -2.568414782155107e-16,  1.386114723139832e-18, -4.295312405486466e-21,  5.490998853771866e-24,
  2.780236489222389e-26, -2.349895980788179e-28,  2.209471574571181e-01, -1.252664198713101e-03,  4.689905992025229e-06, -1.237824256507831e-08,  1.585534506640868e-11,
  5.163339604496326e-14, -4.364887724502259e-16,  1.571609114499879e-18, -2.409034971627408e-21, -8.863150357213791e-24,  8.162631202654400e-26, -3.123699248043919e-28,
  2.736510492330787e-01, -1.508038559752592e-03,  5.281076348780410e-06, -1.174095713313914e-08,  3.259738316479409e-12,  1.100338116622955e-13, -5.494215994387052e-16,
  1.208508948400811e-18,  1.580671678645890e-21, -2.504609924837083e-23,  1.029836874603204e-25, -1.460329655168735e-28,  3.311241300857539e-01, -1.767251674212733e-03,
  5.720278309684805e-06, -9.979482320121370e-09, -1.264179915011753e-11,  1.618045370054103e-13, -5.432930576617310e-16,  2.650359377818019e-19,  6.436927257069813e-21,
 -3.366740169045940e-23,  6.004268592274887e-26,  2.417974211462015e-28,  3.930294228935559e-01, -2.023841340441420e-03,  5.969914376310836e-06, -7.118890892312624e-09,
 -3.005535296192726e-11,  1.946527165065881e-13, -3.907287566781979e-16, -1.069076244018348e-18,  1.011479049040199e-20, -2.674427844650130e-23, -4.335671081913012e-26,
  6.201392482426240e-28,  4.589997109611070e-01, -2.271312856100911e-03,  6.001370351151429e-06, -3.294905290426078e-09, -4.674102237663248e-11,  1.984383816570379e-13,
 -1.018498544468293e-16, -2.410788941821068e-18,  1.057583029067434e-20, -3.016157057005472e-24, -1.584692187556033e-25,  6.729553510388959e-28,  5.286387501507275e-01,
 -2.503293374602737e-03,  5.796906977271994e-06,  1.252703864855320e-09, -6.031423546163590e-11,  1.676607403580880e-13,  2.726996384468033e-16, -3.292728616823750e-18,
  6.774304920434682e-21,  2.949018540446584e-23, -2.127280481981556e-25,  2.386218697730774e-28,  6.015226865449373e-01, -2.713689703547969e-03,  5.351043753229174e-06,
  6.197241139645284e-09, -6.859322410116748e-11,  1.031947126213525e-13,  6.503266699408078e-16, -3.323027998182789e-18, -6.384571447368722e-22,  5.581473354011572e-23,
 -1.536128997859973e-25, -5.078875657520561e-28,  6.772016999343828e-01, -2.896846281195463e-03,  4.671331792461351e-06,  1.115174110394606e-08, -6.994328198462355e-11,
  1.282161630442683e-14,  9.355569250029161e-16, -2.341984782567750e-18, -9.284765827112213e-21,  6.097387641572418e-23,  1.059736190723883e-26, -1.100331275253630e-27,
  7.552018927948310e-01, -3.047699692906160e-03,  3.778436289227371e-06,  1.570316621818783e-08, -6.356467733188093e-11, -8.968237994289333e-14,  1.045218697767043e-15,
 -5.149962218680494e-19, -1.583606851497947e-20,  3.826509992941979e-23,  2.026231308835749e-25, -1.074224954631783e-27,  8.350274430352802e-01, -3.161925752517079e-03,
  2.705479965089928e-06,  1.945125245029513e-08, -4.967510476177609e-11, -1.868404242040782e-13,  9.330095878619030e-16,  1.682501288322768e-18, -1.735294162585639e-20,
 -5.605631605374850e-24,  3.129980165968124e-25, -3.251386272865633e-28,  9.161630365654758e-01, -3.236074899680957e-03,  1.496636225904134e-06,  2.204839340436482e-08,
 -2.954967093946069e-11, -2.607766292214192e-13,  6.061089657448222e-16,  3.596444210220517e-18, -1.263904413446798e-20, -5.206610829703611e-23,  2.650726794922083e-25,
  7.436927679118166e-28,  9.980765925526673e-01, -3.267691482823710e-03,  2.050034831950011e-07,  2.323653307956306e-08, -5.400716235017134e-12, -2.968844288255047e-13,
  1.280670768836687e-16,  4.606147999228473e-18, -2.972040005964492e-21, -7.902790670279126e-23,  6.863477526413907e-26,  1.441903734603414e-27,  1.080222290038666e+00,
 -3.255412440271938e-03, -1.110161666804342e-06,  2.287699618177221e-08,  1.989594135588926e-11, -2.870732693910857e-13, -3.942563430753864e-16,  4.345380931446961e-18,
  8.210119263790571e-21, -7.221166987972670e-23, -1.759341919638584e-25,  1.265857707875239e-27,  1.162043899319765e+00, -3.199040991593031e-03, -2.386727512691381e-06,
  2.096958194636031e-08,  4.319590959814050e-11, -2.318259703920500e-13, -8.372722646130112e-16,  2.849247774534710e-18,  1.663519648826302e-20, -3.335487586120900e-23,
 -3.321986677004921e-25,  2.873959587645621e-28,  1.242978415141200e+00, -3.099591237800703e-03, -3.563316700975291e-06,  1.765810029190061e-08,  6.154667467644224e-11,
 -1.405049489517219e-13, -1.093903296563086e-15,  5.640375027685084e-19,  1.900645002335862e-20,  1.969258760799825e-23, -3.105385677303941e-25, -8.579053183061803e-28,
  1.322459981359363e+00, -2.959300068668171e-03, -4.583073295298190e-06,  1.322080260697295e-08,  7.264195125766227e-11, -2.970967843321228e-14, -1.103906980063781e-15,
 -1.794488769296991e-18,  1.447796566850138e-20,  6.172683235694008e-23, -1.259665580530243e-25, -1.410307435790151e-27,  1.399924088371691e+00, -2.781603505814047e-03,
 -5.397329619801901e-06,  8.045758592081629e-09,  7.519317083616902e-11,  8.006108680845982e-14, -8.718039948375565e-16, -3.489460500451323e-18,  5.070343309564373e-21,
  7.337305003919745e-23,  1.098202114237982e-25, -1.036932211574573e-27,  1.474812015465675e+00, -2.571075577775992e-03, -5.968920030476845e-06,  2.593000884852212e-09,
  6.914955015215974e-11,  1.687552769330948e-13, -4.661627210471301e-16, -4.026449456392899e-18, -5.226113115952540e-21,  5.131160639255006e-23,  2.596718198637096e-25,
 -6.589293824406110e-29,  1.546575480527594e+00, -2.333329019246207e-03, -6.274891074800931e-06, -2.653003469766178e-09,  5.571982821455982e-11,  2.211338899322370e-13,
  3.952715771234625e-19, -3.328610441213352e-18, -1.227093722351480e-20,  9.533938681420843e-24,  2.483248697109581e-25,  7.859240523266126e-28,  1.614681449586796e+00,
 -2.074878484358348e-03, -6.308379631893986e-06, -7.235524915626311e-09,  3.718133067783222e-11,  2.300972906103730e-13,  4.047980414304935e-16, -1.750940561069469e-18,
 -1.364084115888120e-20, -2.917928722894171e-23,  1.058739159290112e-25,  9.702328299475932e-28,  1.678617048834011e+00, -1.802968516895271e-03, -6.079473527083695e-06,
 -1.077638590443878e-08,  1.650039456029987e-11,  1.981110288671981e-13,  6.502216530105183e-16,  7.419446226735039e-20, -9.618851561673546e-21, -4.639821820728818e-23,
 -6.166778402314043e-26,  4.942588486295515e-28,  1.737894512488737e+00, -1.525370161815088e-03, -5.614931825174944e-06, -1.301914214266459e-08, -3.174684187047930e-12,
  1.363171631948518e-13,  6.938711272199633e-16,  1.496343594453809e-18, -2.822037109261068e-21, -3.777596160186860e-23, -1.505978569329828e-25, -1.638500924789920e-28,
  1.792056091702319e+00, -1.250151747194737e-03, -4.956721377237279e-06, -1.385889609937739e-08, -1.905886284590108e-11,  6.150892933158248e-14,  5.565102202862974e-16,
  2.100562636325234e-18,  3.295896454219226e-21, -1.362709054348187e-23, -1.274923731429176e-25, -4.995722384452226e-28,  1.840678843121251e+00, -9.854309132829729e-04,
 -4.159416850138175e-06, -1.335437930245541e-08, -2.921199529432736e-11, -8.271215149869740e-15,  3.105999863920035e-16,  1.846732292438638e-18,  6.229117024805769e-21,
  9.341261283401649e-24, -3.880885308069505e-26, -3.765716061952714e-28,  1.883379211444302e+00, -7.391163063824567e-04, -3.286606054454740e-06, -1.172002640602523e-08,
 -3.286262265396812e-11, -5.834664365388437e-14,  5.152739839963650e-17,  1.038152409348162e-18,  5.520029989754151e-21,  1.909425005657593e-23,  3.806319431811017e-26,
 -4.610117858357769e-29,  1.919817319291568e+00, -5.186483773937485e-04, -2.406532140532356e-06, -9.298325266703861e-09, -3.050706238458329e-11, -8.097829776409382e-14,
 -1.373739449918770e-16,  1.424728651483393e-19,  2.628916001727108e-21,  1.463811557710790e-23,  5.718979196101098e-26,  1.619547006532456e-28,  1.949700882778788e+00,
 -3.307493125434116e-04, -1.587279794486480e-06, -6.515420035889347e-09, -2.376000183059877e-11, -7.690327492997640e-14, -2.129805525727597e-16, -4.429988892382097e-19,
 -2.370068701103195e-22,  4.037617240290049e-24,  2.936916840716595e-26,  1.395617847215267e-28,  1.972788696419222e+00, -1.811921046983570e-04, -8.918647351848197e-07,
 -3.825368160789036e-09, -1.498313101962496e-11, -5.441803118325848e-14, -1.833422648929928e-16, -5.656879577920040e-19, -1.542599740721403e-21, -3.354685261810661e-24,
 -3.307165880237492e-27,  1.987433766955597e-29,  1.988893790172375e+00, -7.459732952145441e-05, -3.736036664226909e-07, -1.650199689192963e-09, -6.765186876517621e-12,
 -2.629555052059031e-14, -9.785638203919284e-17, -3.500439839464526e-19, -1.203745485660190e-21, -3.965915655939482e-24, -1.241883340507025e-26, -3.637761708938575e-29,
  1.997888536115843e+00, -1.425059018589927e-05, -7.205660013565905e-08, -3.233954306332725e-10, -1.358244783308250e-12, -5.464419265180501e-15, -2.131859375756201e-17,
 -8.123179251063729e-20, -3.036519062647930e-22, -1.116741647490306e-24, -4.048249466508220e-27, -1.448208114131821e-29,  7.709932198049259e-04, -4.817022257695793e-06,
  2.256345683799807e-08, -9.390176475325304e-11,  3.661378321806730e-13, -1.369526845143341e-15,  4.976052632549586e-18, -1.769364462693998e-20,  6.186153344695547e-23,
 -2.133468750034372e-25,  7.274090607545449e-28, -2.455818333893983e-30,  6.933049413013137e-03, -4.319452809126475e-05,  2.011705946148221e-07, -8.291460934761544e-10,
  3.185853571692969e-12, -1.167081611616048e-14,  4.122243305448392e-17, -1.412245037858547e-19,  4.706646819056753e-22, -1.527445383042495e-24,  4.823648695840305e-27,
 -1.478820967650485e-29,  1.922575089231744e-02, -1.191061929434774e-04,  5.483424498301135e-07, -2.216004045022588e-09,  8.259732924741092e-12, -2.894551908571062e-14,
  9.602114843177739e-17, -3.013310024332352e-19,  8.875527904292561e-22, -2.407573354487617e-24,  5.753058594438322e-27, -1.060383074689166e-29,  3.758627695944544e-02,
 -2.308792643710631e-04,  1.044440746614895e-06, -4.094499075939042e-09,  1.454001306086147e-11, -4.729697739459093e-14,  1.398623771686627e-16, -3.643371436303180e-19,
  7.606357812490305e-22, -7.838373074539933e-25, -3.411045394437116e-27,  2.973748752262458e-29,  6.192040210369799e-02, -3.760394503949510e-04,  1.661110533428566e-06,
 -6.242361302134318e-09,  2.065306432540398e-11, -5.963177046857710e-14,  1.415406334171274e-16, -2.148901626139065e-19, -2.411577783028888e-22,  3.821638757482440e-24,
 -2.038088754607731e-26,  7.984323997622421e-29,  9.210251035073402e-02, -5.513526693527641e-04,  2.362564073541068e-06, -8.394837649756980e-09,  2.510909666449271e-11,
 -5.937645014732822e-14,  7.964226674636394e-17,  1.798318644952468e-19, -1.930899874119022e-21,  9.229120393949721e-24, -3.155696429465471e-26,  7.516932188419090e-29,
  1.279756272738660e-01, -7.528806003667248e-04,  3.107227609357792e-06, -1.026880617170566e-08,  2.653829806354967e-11, -4.219378406819052e-14, -4.799860680349893e-17,
  7.337619968956383e-19, -3.557691440091396e-21,  1.131588855554341e-23, -2.034678219043537e-26, -2.865135873929816e-29,  1.693514807764047e-01, -9.760498837028287e-04,
  3.849695344779640e-06, -1.158937172707027e-08,  2.392203320297890e-11, -7.336203824728051e-15, -2.199234316591875e-16,  1.252022738084515e-18, -4.079991363267503e-21,
  6.409321666579649e-24,  1.842659946235970e-26, -1.920412020416254e-28,  2.160106045990605e-01, -1.215734718907704e-03,  4.542921469179097e-06, -1.211685008057100e-08,
  1.678677390018813e-11,  4.167674214601822e-14, -3.936065931884552e-16,  1.490018518968191e-18, -2.672584507883005e-21, -5.865750440151360e-24,  6.843014696515201e-26,
 -2.868062295228304e-28,  2.677025013693606e-01, -1.466352465601723e-03,  5.140568131280537e-06, -1.167190075853092e-08,  5.331320370820350e-12,  9.725866295845113e-14,
 -5.150051653249420e-16,  1.245445690860028e-18,  7.515121383925489e-22, -2.106598724211281e-23,  9.578434050408159e-26, -1.786987598071911e-28,  3.241458848652263e-01,
 -1.721971660101694e-03,  5.599415413120710e-06, -1.015656790702245e-08, -9.535382039480075e-12,  1.488767287682462e-13, -5.331670993013663e-16,  4.521077802101022e-19,
  5.270431261068187e-21, -3.108171342465403e-23,  6.855763459666726e-26,  1.478736479821865e-28,  3.850290239707035e-01, -1.976431614735791e-03,  5.881729165823529e-06,
 -7.569151146439435e-09, -2.625831298764702e-11,  1.849516915121829e-13, -4.162782910488073e-16, -7.610907077158607e-19,  9.127094846373486e-21, -2.796148715405991e-23,
 -1.821574012301590e-26,  5.224605935138893e-28,  4.500102134974151e-01, -2.223472461651413e-03,  5.957474827579436e-06, -4.011166583989726e-09, -4.280196931718718e-11,
  1.952220596329715e-13, -1.646386833052043e-16, -2.075265219907592e-18,  1.036027302120342e-20, -8.764620880168120e-24, -1.290484869268494e-25,  6.600830221543158e-28,
  5.187183995474950e-01, -2.456874137470252e-03,  5.806260980454565e-06,  3.148265221784076e-10, -5.690291010089339e-11,  1.731245935505000e-13,  1.836861484486499e-16,
 -3.060583932257300e-18,  7.685665289944164e-21,  2.122871673092824e-23, -1.994771763211314e-25,  3.578424310955221e-28,  5.907539892948765e-01, -2.670602381096004e-03,
  5.418896466393833e-06,  5.117077080614290e-09, -6.638079228606360e-11,  1.176855198380049e-13,  5.572892360335810e-16, -3.312535380527767e-18,  1.255427239522774e-21,
  4.928250751318192e-23, -1.715558113829450e-25, -3.099497701133877e-28,  6.656898768279250e-01, -2.858959340553642e-03,  4.798450482380326e-06,  1.003589714329142e-08,
 -6.946779252167836e-11,  3.445653076076571e-14,  8.661518124386241e-16, -2.603986967615277e-18, -7.093398318288263e-21,  6.046788634051369e-23, -3.489286284098119e-26,
 -9.626672911490040e-28,  7.430727178670269e-01, -3.016735867696694e-03,  3.960717283615293e-06,  1.467313924910516e-08, -6.510893080157097e-11, -6.482610668681927e-14,
  1.023921946502656e-15, -9.982391135729492e-19, -1.432420440751924e-20,  4.540606759198403e-23,  1.540660719401426e-25, -1.123600371514159e-27,  8.224244865602197e-01,
 -3.139362040325297e-03,  2.934006851832966e-06,  1.862778783769005e-08, -5.318449980273649e-11, -1.639457227501246e-13,  9.723322119528973e-16,  1.126362254132503e-18,
 -1.733350290415006e-20,  6.555188575959881e-24,  2.933059774130500e-25, -5.634704393580514e-28,  9.032443469612668e-01, -3.223051915579763e-03,  1.758210717499707e-06,
  2.153469816920269e-08, -3.461182391324043e-11, -2.450689688402756e-13,  7.008802670094841e-16,  3.164110320217508e-18, -1.431541217777819e-20, -4.088881535521565e-23,
  2.917789431296558e-25,  4.675661351481363e-28,  9.850108699864174e-01, -3.264938020327691e-03,  4.831281279001295e-07,  2.310283073438314e-08, -1.129728858734902e-11,
 -2.922765069448472e-13,  2.552845368340782e-16,  4.466175052842339e-18, -5.752578767438875e-21, -7.504105782619794e-23,  1.299108684848187e-25,  1.332619415189760e-27,
  1.067184623403411e+00, -3.263190665577667e-03, -8.339187216997387e-07,  2.314892728101932e-08,  1.406985283928939e-11, -2.950481336940690e-13, -2.693073903700575e-16,
  4.565264623023345e-18,  5.497710785779022e-21, -7.808530313905066e-23, -1.166262475758337e-25,  1.419643497456281e-27,  1.149211157515302e+00, -3.217116881803562e-03,
 -2.131102187105118e-06,  2.162256073358910e-08,  3.836521277940281e-11, -2.509042051107793e-13, -7.502393890586311e-16,  3.359827385403960e-18,  1.519913273939562e-20,
 -4.629690972616281e-23, -3.126098708127876e-25,  6.019527035059531e-28,  1.230524402479120e+00, -3.127233664702347e-03, -3.345608352952489e-06,  1.861894645864687e-08,
  5.847567579772239e-11, -1.664998165572068e-13, -1.069506280794505e-15,  1.181119627567568e-18,  1.948330933613849e-20,  6.584012220972444e-24, -3.431083657900347e-25,
 -6.134066406588216e-28,  1.310550484516055e+00, -2.995310352486590e-03, -4.417474352338852e-06,  1.437686466812009e-08,  7.177902925425977e-11, -5.675202635764991e-14,
 -1.147340109742757e-15, -1.296733467964551e-18,  1.659442291059300e-20,  5.544168412481541e-23, -1.883039787248006e-25, -1.411976889360693e-27,  1.388711957577287e+00,
 -2.824375379674123e-03, -5.293512904384438e-06,  9.260489408669199e-09,  7.657735073183392e-11,  5.798613527195896e-14, -9.668347727791616e-16, -3.284192190985330e-18,
  7.779222481512337e-21,  7.678494223886181e-23,  5.911963664915163e-26, -1.263869139391542e-27,  1.464432434388556e+00, -2.618683412932611e-03, -5.931056359137903e-06,
  3.725748006179738e-09,  7.240355448807924e-11,  1.561973652658500e-13, -5.809526679676317e-16, -4.162134957660982e-18, -3.193297017555026e-21,  6.156675017006251e-23,
  2.511952778298653e-25, -3.252757237848922e-28,  1.537141586404523e+00, -2.383640000251577e-03, -6.301232151387840e-06, -1.726136762431944e-09,  6.013482387133912e-11,
  2.199809789590043e-13, -9.823755019710293e-17, -3.713805576301931e-18, -1.174080502517293e-20,  2.013391476340416e-23,  2.809681829978648e-25,  6.889218065641154e-28,
  1.606280466418320e+00, -2.125682360196578e-03, -6.391482996765948e-06, -6.603297770136869e-09,  4.187619796111063e-11,  2.391738630005645e-13,  3.495090111263707e-16,
 -2.203351951396452e-18, -1.460448343238024e-20, -2.405848761819415e-23,  1.509187446045799e-25,  1.073393535919852e-27,  1.671307090924774e+00, -1.852116776889695e-03,
 -6.207072619863757e-06, -1.047983387717647e-08,  2.061865024248774e-11,  2.137049368089981e-13,  6.477356122350911e-16, -2.607646888535760e-19, -1.132788756757868e-20,
 -4.837923677487623e-23, -3.609280165847367e-26,  6.713550930618931e-28,  1.731702202539062e+00, -1.570915185602950e-03, -5.771373361884539e-06, -1.304720749049895e-08,
 -2.784763683043158e-13,  1.534613387424823e-13,  7.342916685861243e-16,  1.383104259827288e-18, -4.291905249963811e-21, -4.391787837288756e-23, -1.557932759832612e-25,
 -6.702068647310439e-29,  1.786975116706123e+00, -1.290475830927642e-03, -5.124814779527868e-06, -1.415325058127649e-08, -1.769029819179186e-11,  7.558239206965474e-14,
  6.167215167466386e-16,  2.197154286693446e-18,  2.708139587329287e-21, -1.917608219024439e-23, -1.501741949775649e-25, -5.292734324715673e-28,  1.836669542635131e+00,
 -1.019355213805217e-03, -4.322477851322362e-06, -1.382267160920583e-08, -2.929856952510981e-11, -1.734897516286760e-16,  3.651473591558105e-16,  2.051111160850958e-18,
  6.533248651118758e-21,  7.433418653836584e-24, -5.719710150804481e-26, -4.608365550825333e-28,  1.880369257064332e+00, -7.659807429187496e-04, -3.430439446348044e-06,
 -1.225508638918740e-08, -3.401472853027350e-11, -5.674056090980151e-14,  8.317404561805406e-17,  1.226080763809750e-18,  6.234220911198681e-21,  2.056298821782764e-23,
  3.502320048659731e-26, -9.426678917671578e-29,  1.917703502716575e+00, -5.383553762951718e-04, -2.521094743534150e-06, -9.799572394361715e-09, -3.215922370415585e-11,
 -8.421739234525931e-14, -1.321244995472862e-16,  2.354853603320995e-19,  3.198810086943184e-21,  1.707125395693320e-23,  6.453698273588436e-26,  1.715216352289364e-28,
  1.948351984599727e+00, -3.437668724998675e-04, -1.667797462440683e-06, -6.908166546774401e-09, -2.535019121204254e-11, -8.216437011610470e-14, -2.254671606729784e-16,
 -4.480182420915258e-19, -6.895688325455384e-23,  5.342950234476862e-24,  3.609677416546902e-26,  1.669318808221928e-28,  1.972049361572120e+00, -1.885147999590230e-04,
 -9.392442389898749e-07, -4.074049707548207e-09, -1.611680607197028e-11, -5.901400719302709e-14, -1.998909393103213e-16, -6.170071133226424e-19, -1.665514922917883e-21,
 -3.466822188662999e-24, -2.229264617535046e-27,  2.955236279579329e-29,  1.988589295128857e+00, -7.766724938389220e-05, -3.940732983394700e-07, -1.762780984476069e-09,
 -7.315400386520458e-12, -2.876620664077854e-14, -1.082190571764026e-16, -3.909472942480848e-19, -1.355858451030124e-21, -4.496082996228229e-24, -1.412519232990659e-26,
 -4.127405732148401e-29,  1.997830355738696e+00, -1.484294390068566e-05, -7.607143553052750e-08, -3.460302472628882e-10, -1.472839701271805e-12, -6.004495699262696e-15,
 -2.373539406097631e-17, -9.162444024561095e-20, -3.469297485572714e-22, -1.292173289593510e-24, -4.742941386505741e-27, -1.717587493218261e-29,  7.520791474539291e-04,
 -4.640924338553535e-06,  2.147090157322338e-08, -8.825635946894057e-11,  3.399025453914467e-13, -1.255829856359623e-15,  4.507228762399395e-18, -1.583155236920317e-20,
  5.467975999297739e-23, -1.863004032986862e-25,  6.275532511975322e-28, -2.093340179710609e-30,  6.763428215470199e-03, -4.162411319161826e-05,  1.915191512196953e-07,
 -7.799873273305299e-10,  2.962018921050904e-12, -1.072727674105623e-14,  3.747099649166281e-17, -1.270070405547565e-19,  4.189983303121734e-22, -1.346916559932288e-24,
  4.217027878626569e-27, -1.283300045387251e-29,  1.875793429817166e-02, -1.148236180893510e-04,  5.225246294999206e-07, -2.088357201643613e-09,  7.703200452390546e-12,
 -2.673912786941129e-14,  8.796878561375457e-17, -2.742725693544039e-19,  8.049106894713590e-22, -2.186694150249604e-24,  5.293394206863676e-27, -1.026269448699878e-29,
  3.667916526203098e-02, -2.227163901937483e-04,  9.966719643723071e-07, -3.869247422156922e-09,  1.362682826773539e-11, -4.405997411771476e-14,  1.299972863377538e-16,
 -3.404721826468043e-19,  7.302589135486275e-22, -8.960797157736840e-25, -2.247405299581770e-27,  2.337237793603931e-29,  6.044235546396678e-02, -3.630446712879020e-04,
  1.588146127253273e-06, -5.921270847085846e-09,  1.949390730990459e-11, -5.630774872369452e-14,  1.354352699106124e-16, -2.205566221100921e-19, -1.174375388771228e-22,
  3.073261243662394e-24, -1.711972754663674e-26,  6.861914583584948e-29,  8.993427221460067e-02, -5.328483688668034e-04,  2.264197647359415e-06, -8.002486891402749e-09,
  2.394105485111513e-11, -5.741129592614861e-14,  8.386076413319694e-17,  1.231218401192552e-19, -1.620583388945574e-21,  8.032100381235946e-24, -2.831848203855107e-26,
  7.182201197933410e-29,  1.250130501905589e-01, -7.285085282784699e-04,  2.986521579807687e-06, -9.851000239593022e-09,  2.568450197930006e-11, -4.311170047132400e-14,
 -2.898700747105025e-17,  6.262746366475065e-19, -3.165219082903611e-21,  1.048264601930194e-23, -2.118014054026958e-26, -1.007229964839716e-29,  1.655080047439415e-01,
 -9.458021169505737e-04,  3.712913660325893e-06, -1.120806811198375e-08,  2.372529176553327e-11, -1.220822190411572e-14, -1.866590219800507e-16,  1.125281203681401e-18,
 -3.837919832580975e-21,  6.988869545295357e-24,  1.082548785798001e-26, -1.543239561115649e-28,  2.112194381118563e-01, -1.179968329871915e-03,  4.399156680896956e-06,
 -1.184209267363166e-08,  1.752917181634227e-11,  3.272098923305504e-14, -3.531115121280219e-16,  1.401621228893840e-18, -2.837448476922477e-21, -3.372706944496505e-24,
  5.642925084181070e-26, -2.583834203857707e-28,  2.619184557693058e-01, -1.425786578139670e-03,  5.001079176764658e-06, -1.157169791644430e-08,  7.155728226839830e-12,
  8.531905152048425e-14, -4.799048367857697e-16,  1.258083741500352e-18,  6.014590944578175e-23, -1.739833134189178e-23,  8.746117593040878e-26, -1.975914086108670e-28,
  3.173468136033685e-01, -1.677666223881828e-03,  5.476717220660912e-06, -1.028600435906217e-08, -6.684688011203059e-12,  1.362506697868201e-13, -5.183113025917843e-16,
  6.033990396063608e-19,  4.202197491265459e-21, -2.823339799719028e-23,  7.328951962312921e-26,  6.979204400935653e-29,  3.772168202058938e-01, -1.929747965359105e-03,
  5.788498845382144e-06, -7.960241374254964e-09, -2.266074549557932e-11,  1.747373555672324e-13, -4.336519705432849e-16, -4.852268662448205e-19,  8.112645234371098e-21,
 -2.825896718228530e-23,  2.639077732970171e-27,  4.260458290189077e-28,  4.412113223527858e-01, -2.176016545915114e-03,  5.905359938274538e-06, -4.664996338965784e-09,
 -3.894155585965070e-11,  1.906105790996832e-13, -2.181589175463037e-16, -1.749724861387155e-18,  9.958751726980383e-21, -1.335471287888765e-23, -1.007154083380005e-25,
  6.245819567617033e-28,  5.089838055981275e-01, -2.410424150982122e-03,  5.804691179083439e-06, -5.677092059814801e-10, -5.340312853030603e-11,  1.765331481665105e-13,
  1.015370737007739e-16, -2.803922384787060e-18,  8.310323393381438e-21,  1.359186993777416e-23, -1.817494440020951e-25,  4.424229254341812e-28,  5.801586457631874e-01,
 -2.627023461793302e-03,  5.474008775810378e-06,  4.074509359236032e-09, -6.390081505935020e-11,  1.299535806230248e-13,  4.653578130252548e-16, -3.245322772335615e-18,
  2.903290802021810e-21,  4.220217455394095e-23, -1.811443530270592e-25, -1.292881743557634e-28,  6.543315508041214e-01, -2.820108849284182e-03,  4.912238671163503e-06,
  8.931029744054501e-09, -6.857681538148085e-11,  5.434558468156491e-14,  7.903872000928120e-16, -2.796495708745884e-18, -4.951469009116846e-21,  5.827102350862081e-23,
 -7.377915009548099e-26, -8.020505051504552e-28,  7.310702359104854e-01, -2.984363618284905e-03,  4.130506008897033e-06,  1.362234895805804e-08, -6.616223680871008e-11,
 -4.063763412413300e-14,  9.898076639445515e-16, -1.429367285373810e-18, -1.259060127097511e-20,  5.057758281836173e-23,  1.045444556214241e-25, -1.118931533149500e-27,
  8.099153774794645e-01, -3.115010558789603e-03,  3.152330523450482e-06,  1.775188204530826e-08, -5.622782264971428e-11, -1.402936721553820e-13,  9.961562668660494e-16,
  5.776780779616163e-19, -1.689286978766086e-20,  1.773084569591972e-23,  2.640584679732866e-25, -7.581156454578316e-28,  8.903818935330876e-01, -3.207962345165015e-03,
  2.013145655459806e-06,  2.094264107385068e-08, -3.933808882564425e-11, -2.272377445829922e-13,  7.828570290702111e-16,  2.684752947380430e-18, -1.557313144191887e-20,
 -2.888979143891000e-23,  3.061012559136134e-25,  1.834729482056226e-28,  9.719605988493878e-01, -3.259967574179796e-03,  7.590858480398742e-07,  2.287568487906388e-08,
 -1.707153910947912e-11, -2.846723020860158e-13,  3.773619623714058e-16,  4.239983813791550e-18, -8.346801200087674e-21, -6.871790168620725e-23,  1.850067186098662e-25,
  1.162514738705692e-27,  1.054120282168964e+00, -3.268747490379430e-03, -5.549766382381291e-07,  2.332652983364199e-08,  8.114702023515246e-12, -2.999603289849051e-13,
 -1.394453059675814e-16,  4.695437994094038e-18,  2.618011470746798e-21, -8.147035255860005e-23, -5.199153116277127e-26,  1.506698181844768e-27,  1.136310249889331e+00,
 -3.233117768614991e-03, -1.868117073930375e-06,  2.219531410687121e-08,  3.317496850881793e-11, -2.677277133031984e-13, -6.496224490774406e-16,  3.817176473206548e-18,
  1.331456799784963e-20, -5.818183757424046e-23, -2.794571144667604e-25,  9.008936451139958e-28,  1.217963375236248e+00, -3.153089178791734e-03, -3.116681704266851e-06,
  1.952653517820142e-08,  5.489204142311976e-11, -1.917005363616377e-13, -1.027689942276343e-15,  1.805681258515781e-18,  1.946754505081708e-20, -7.596675517137273e-24,
 -3.637799557684658e-25, -3.189690573791833e-28,  1.298499683595288e+00, -3.029940629945443e-03, -4.238103523296364e-06,  1.551474143821621e-08,  7.036600385282794e-11,
 -8.466209675961120e-14, -1.175925359248963e-15, -7.353519458492150e-19,  1.843990081972976e-20,  4.668216847228579e-23, -2.491630088084331e-25, -1.342050661828751e-27,
  1.377330493160718e+00, -2.866258070583336e-03, -5.175001503009403e-06,  1.049371332290258e-08,  7.749774081123314e-11,  3.370930954792462e-14, -1.054888896507759e-15,
 -2.990684983632694e-18,  1.057208937910711e-20,  7.797708186416973e-23, -9.399271274695213e-28, -1.459561514913326e-27,  1.453863115101471e+00, -2.665933101833902e-03,
 -5.879296114222834e-06,  4.908399089786611e-09,  7.537858269518431e-11,  1.408465934306818e-13, -6.985762052828349e-16, -4.226951743194789e-18, -8.002398343484220e-22,
  7.124476915385917e-23,  2.305900804075785e-25, -6.155556582265037e-28,  1.527506099034049e+00, -2.434116021994963e-03, -6.316028175376612e-06, -7.289468355116669e-10,
  6.450222724431734e-11,  2.163337330386370e-13, -2.073592258964683e-16, -4.075688210159354e-18, -1.080674766262752e-20,  3.193786666667138e-23,  3.081080511883543e-25,
  5.348964075028522e-28,  1.597674987962318e+00, -2.177119425740547e-03, -6.466543183549958e-06, -5.894576960769992e-09,  4.673828401613508e-11,  2.467681868885393e-13,
  2.811509924264891e-16, -2.683294138639782e-18, -1.535032005745363e-20, -1.705289637141307e-23,  1.998993217260244e-25,  1.147126905394493e-27,  1.663798522540644e+00,
 -1.902270451298113e-03, -6.330707463275278e-06, -1.011490127629138e-08,  2.504739555521435e-11,  2.291203951688303e-13,  6.350958433213159e-16, -6.513410605920289e-19,
 -1.308790039871026e-20, -4.917622004804945e-23, -2.347054946104287e-27,  8.647426626723818e-28,  1.725325208443607e+00, -1.617712274656818e-03, -5.927862164106829e-06,
 -1.302613891305088e-08,  2.970030724117880e-12,  1.715320383015409e-13,  7.708495327473656e-16,  1.219260203832850e-18, -5.985507971863203e-21, -5.017263702134320e-23,
 -1.559904615818524e-25,  6.405213655606830e-29,  1.781730134063997e+00, -1.332158396738242e-03, -5.296299508161318e-06, -1.442337688025157e-08, -1.602560629217210e-11,
  9.113106448765515e-14,  6.793427711918057e-16,  2.271564086015548e-18,  1.904011354075256e-21, -2.565420209951682e-23, -1.738316717206732e-25, -5.428749431819729e-28,
  1.832521900364266e+00, -1.054606491135444e-03, -4.491161091044788e-06, -1.429098037320256e-08, -2.920962895195349e-11,  9.303074912273244e-15,  4.255422110509214e-16,
  2.263973949003283e-18,  6.754539772877767e-21,  4.713153749032406e-24, -7.949562262490873e-26, -5.541002136272193e-28,  1.877249502500546e+00, -7.940218401237498e-04,
 -3.580802961511783e-06, -1.280827998974648e-08, -3.512667778413509e-11, -5.430918428103159e-14,  1.204104005922862e-16,  1.437681365347565e-18,  6.998549905719343e-21,
  2.186364515977492e-23,  2.955307033564113e-26, -1.569983965484768e-28,  1.915508986408686e+00, -5.590033901450160e-04, -2.641833032672289e-06, -1.032776458937829e-08,
 -3.387468509502511e-11, -8.729710431720882e-14, -1.240018146615285e-16,  3.481934405816111e-19,  3.861679761287429e-21,  1.980570657083567e-23,  7.222785557587906e-26,
  1.772843095635809e-28,  1.946949697428108e+00, -3.574478662668333e-04, -1.753184271875374e-06, -7.327214181806103e-09, -2.704860733531693e-11, -8.772617739326121e-14,
 -2.380115754960763e-16, -4.468537554161642e-19,  1.512307148050762e-22,  6.942744042396490e-24,  4.412445139269874e-26,  1.987282111291967e-28,  1.971279958527395e+00,
 -1.962287834525304e-04, -9.897198587610939e-07, -4.341627487377318e-09, -1.734649102993109e-11, -6.402484249747809e-14, -2.179321585821089e-16, -6.723149431363942e-19,
 -1.791580948379622e-21, -3.526507284490500e-24, -6.630747053025938e-28,  4.218473694742263e-29,  1.988272184119254e+00, -8.090648370707665e-05, -4.159484017898871e-07,
 -1.884574913352763e-09, -7.917609748940521e-12, -3.149987863407203e-14, -1.197981372825295e-16, -4.370372000210855e-19, -1.528339417908319e-21, -5.098976164905809e-24,
 -1.605919701795879e-26, -4.672939860966779e-29,  1.997769739943963e+00, -1.546853478154113e-05, -8.036925677336503e-08, -3.705882481471223e-10, -1.598840584771708e-12,
 -6.606229796147032e-15, -2.646356603287953e-17, -1.035086313864025e-19, -3.970532456045542e-22, -1.497915327711977e-24, -5.567721486871631e-27, -2.041265546565630e-29,
  7.338524050946669e-04, -4.473302849140135e-06,  2.044364569136588e-08, -8.301312133021894e-11,  3.158327733811447e-13, -1.152784073888186e-15,  4.087467095845140e-18,
 -1.418443884716275e-20,  4.840344634550446e-23, -1.629466821205550e-25,  5.423575020140035e-28, -1.787740640582306e-30,  6.599937906396868e-03, -4.012860969832651e-05,
  1.824367321436717e-07, -7.342637091041020e-10,  2.756186017687783e-12, -9.869175759588131e-15,  3.409544695760200e-17, -1.143434357616723e-19,  3.734142329049778e-22,
 -1.189013716590728e-24,  3.690400614068692e-27, -1.114549697670489e-29,  1.830684441010593e-02, -1.107416068394641e-04,  4.981865670690564e-07, -1.969272103195980e-09,
  7.188923092119165e-12, -2.471719333983434e-14,  8.063820554257002e-17, -2.497349736139714e-19,  7.298933074388090e-22, -1.983857339452497e-24,  4.851916969608177e-27,
 -9.786992349070356e-30,  3.580395753565566e-02, -2.149250977434687e-04,  9.515206316029038e-07, -3.658101443445497e-09,  1.277606946167955e-11, -4.105182766224768e-14,
  1.207862591064552e-16, -3.176354751031543e-19,  6.966150411969771e-22, -9.670080916987247e-25, -1.336613556028040e-27,  1.820656226322818e-29,  5.901514447451915e-02,
 -3.506185053785691e-04,  1.518925695401672e-06, -5.618203068406304e-09,  1.839975480017937e-11, -5.313173627836985e-14,  1.292227960041257e-16, -2.226708651576625e-19,
 -1.842622069671942e-23,  2.445853008222261e-24, -1.432268615933661e-26,  5.873167639283639e-29,  8.783850679170184e-02, -5.151124816410946e-04,  2.170428611657010e-06,
 -7.628505396659275e-09,  2.281320557665781e-11, -5.536286916281968e-14,  8.662410082363410e-17,  7.567715169325488e-20, -1.351066569929751e-21,  6.961334556402922e-24,
 -2.525173541723986e-26,  6.744541000518870e-29,  1.221460615228824e-01, -7.050822832135540e-04,  2.870746728763740e-06, -9.446978118431250e-09,  2.481667378568589e-11,
 -4.360806297250099e-14, -1.281377315532383e-17,  5.308615223794534e-19, -2.803159651034119e-21,  9.630983568601815e-24, -2.130161859998175e-26,  3.858560112718351e-30,
  1.617833601656463e-01, -9.166303617436724e-04,  3.580685653793731e-06, -1.083064969660313e-08,  2.343881057327567e-11, -1.632358671730850e-14, -1.568321907186919e-16,
  1.006564251994342e-18, -3.580071308402706e-21,  7.296041975857357e-24,  4.770512006223524e-27, -1.217273066832277e-28,  2.065690580933061e-01, -1.145338682128505e-03,
  4.258754509629381e-06, -1.155683786615182e-08,  1.810197026770135e-11,  2.470690030531669e-14, -3.151525681196275e-16,  1.309294111575552e-18, -2.920898093168783e-21,
 -1.334267173199445e-24,  4.570745136208591e-26, -2.289245969331397e-28,  2.562944501882637e-01, -1.386331314188807e-03,  4.862960067852067e-06, -1.144416903878673e-08,
  8.749784185022987e-12,  7.422371403946614e-14, -4.447409920375327e-16,  1.250644970866589e-18, -5.053461455664964e-22, -1.407679766899870e-23,  7.855828442905672e-26,
 -2.054881797898312e-28,  3.107229921476712e-01, -1.634347829821442e-03,  5.352731190726075e-06, -1.037182913210489e-08, -4.082626199628685e-12,  1.240282169473311e-13,
 -4.996822814000510e-16,  7.221775312863549e-19,  3.239123531263025e-21, -2.525997625155559e-23,  7.492374159929973e-26,  6.913444466575918e-30,  3.695898309914331e-01,
 -1.883827967998738e-03,  5.690914000854799e-06, -8.295424911070759e-09, -1.927102772601731e-11,  1.641950689718740e-13, -4.437564457354065e-16, -2.418439889075424e-19,
  7.101490453890271e-21, -2.780584065464955e-23,  1.935169006071867e-26,  3.347065547802782e-28,  4.326013728144162e-01, -2.129007890536632e-03,  5.845766430356190e-06,
 -5.257864034748434e-09, -3.518548666679467e-11,  1.848223976577164e-13, -2.627672047096460e-16, -1.439461724378599e-18,  9.411961842471360e-21, -1.684797835691107e-23,
 -7.432629755804443e-26,  5.727142280429651e-28,  4.994349207550604e-01, -2.364028128182005e-03,  5.792868837420632e-06, -1.393807701815092e-09, -4.985429892295526e-11,
  1.780583730625968e-13,  2.681405352401873e-17, -2.531527047021822e-18,  8.673627482023347e-21,  6.728899591366307e-24, -1.610167914809838e-25,  4.949709305942134e-28,
  5.697384214464328e-01, -2.583052994839876e-03,  5.516856060985711e-06,  3.073465028663431e-09, -6.119735793283846e-11,  1.400435915781932e-13,  3.760078276115332e-16,
 -3.129515655542797e-18,  4.291216358709327e-21,  3.489084186958984e-23, -1.832737697044148e-25,  2.834769091858687e-29,  6.431303637676676e-01, -2.780400814212890e-03,
  5.012866787032818e-06,  7.843499736257215e-09, -6.730663759935150e-11,  7.235926672343759e-14,  7.101779790116901e-16, -2.922014214218214e-18, -2.914881613359054e-21,
  5.466430107336096e-23, -1.053001896572243e-25, -6.296563086505689e-28,  7.191998793547490e-01, -2.950683747046516e-03,  4.287599942664211e-06,  1.255852745199241e-08,
 -6.674090551323661e-11, -1.740633631640866e-14,  9.444237160213518e-16, -1.802422388256949e-18, -1.070629624479921e-20,  5.378688913014253e-23,  5.630224475703254e-26,
 -1.066703511026252e-27,  7.975070998137433e-01, -3.088955323015662e-03,  3.359866863359164e-06,  1.683109329190846e-08, -5.879362134595707e-11, -1.162522455211245e-13,
  1.004873348522519e-15,  4.928965239103984e-20, -1.607290471469153e-20,  2.757972256525452e-23,  2.273323301702276e-25, -9.026554109957786e-28,  8.775838305709304e-01,
 -3.190862971756222e-03,  2.260534289067155e-06,  2.027791899332034e-08, -4.368916381060442e-11, -2.076042875424306e-13,  8.509139120860210e-16,  2.172146164745413e-18,
 -1.639157727452806e-20, -1.656666600040859e-23,  3.080416830379895e-25, -9.272808160271599e-29,  9.589346053566025e-01, -3.252801927286715e-03,  1.031769018012127e-06,
  2.255752455786049e-08, -2.266496748814823e-11, -2.742233948187123e-13,  4.919809854851896e-16,  3.934829346370887e-18, -1.067566808087891e-20, -6.035616831126703e-23,
  2.314768277458138e-25,  9.426295626235637e-28,  1.041038187911210e+00, -3.272065879752955e-03, -2.744777092025145e-07,  2.340823441276701e-08,  2.092715207247038e-12,
 -3.017226035882715e-13, -7.243197614718126e-18,  4.732016418252979e-18, -3.362804054013642e-22, -8.221442715875138e-23,  1.489579165875569e-26,  1.521513832311468e-27,
  1.123349587981513e+00, -3.246988718803751e-03, -1.598767850645107e-06,  2.268246724139583e-08,  2.767340254668832e-11, -2.819899457903318e-13, -5.371063695190571e-16,
  4.207654945101142e-18,  1.102910930484641e-20, -6.848624181723169e-23, -2.338297842866345e-25,  1.166070883767051e-27,  1.205302656314005e+00, -3.177070728102979e-03,
 -2.877224459459036e-06,  2.037281409980828e-08,  5.081584276444196e-11, -2.156883451081346e-13, -9.684706737590037e-16,  2.421436840779234e-18,  1.892962431373663e-20,
 -2.233329213658587e-23, -3.706393421005433e-25,  1.185855082390749e-29,  1.286313317377780e+00, -3.063081749668375e-03, -4.045232349958620e-06,  1.662551237597614e-08,
  6.838922298797611e-11, -1.130632237108800e-13, -1.188015866860158e-15, -1.204231024014441e-19,  1.992716064223884e-20,  3.557199272632244e-23, -3.052841819051167e-25,
 -1.196303274674589e-27,  1.365783488191809e+00, -2.907133262819723e-03, -5.041619443788671e-06,  1.173766733993641e-08,  7.791217936050163e-11,  7.427924957848395e-15,
 -1.133470561762797e-15, -2.607599113089921e-18,  1.336267109985179e-20,  7.660758758762723e-23, -6.861103429039862e-26, -1.607069145564215e-27,  1.443105716214572e+00,
 -2.712711156648284e-03, -5.813069083250200e-06,  6.136040662809855e-09,  7.801826487699587e-11,  1.226600471708543e-13, -8.168914263939933e-16, -4.209800626981794e-18,
  1.923250538854050e-21,  7.983655427023427e-23,  1.967451283473926e-25, -9.247831369358912e-28,  1.517668548295241e+00, -2.484661365365182e-03, -6.318441526886693e-06,
  3.373923121065488e-10,  6.876969489493621e-11,  2.099497516776853e-13, -3.261298628507898e-16, -4.400686726252459e-18, -9.430001788933642e-21,  4.467412972933949e-23,
  3.271400727530863e-25,  3.200119068090790e-28,  1.588862616025435e+00, -2.229121620751159e-03, -6.532627249445064e-06, -5.106941436009530e-09,  5.173474921594299e-11,
  2.525582075055527e-13,  1.990611013272475e-16, -3.182684068374898e-18, -1.580801004926338e-20, -8.034642160426715e-24,  2.512451619182524e-25,  1.178735887886213e-27,
  1.656087390767635e+00, -1.953394459764770e-03, -6.449527845549878e-06, -9.676662592354983e-09,  2.978049769502908e-11,  2.440948844267822e-13,  6.107290917960309e-16,
 -1.098419532842408e-18, -1.485022547144969e-20, -4.844984090012901e-23,  4.014366619797626e-26,  1.067465564167496e-27,  1.718758525056334e+00, -1.665759351473837e-03,
 -6.083774210169696e-06, -1.295015691137694e-08,  6.588321564593110e-12,  1.904187431087989e-13,  8.020272362463496e-16,  9.976285296234241e-19, -7.902934678336689e-21,
 -5.630897244549098e-23, -1.495946155064674e-25,  2.332041296494173e-28,  1.776315657544446e+00, -1.375225329476259e-03, -5.470855413520668e-06, -1.466429800988612e-08,
 -1.403475904752921e-11,  1.082045189370225e-13,  7.436508838688450e-16,  2.316326941741016e-18,  8.495490620342658e-22, -3.308434984442322e-23, -1.976077550142804e-25,
 -5.334136537386543e-28,  1.828230518514579e+00, -1.091229674086128e-03, -4.665448982430630e-06, -1.475626904316649e-08, -2.891617581981639e-11,  2.030134126436241e-14,
  4.919803628726192e-16,  2.482170869589451e-18,  6.860836391332086e-21,  1.016594112837797e-24, -1.060641550242050e-25, -6.545257957961322e-28,  1.874015135267278e+00,
 -8.232926971717200e-04, -3.737909779390632e-06, -1.337882513719979e-08, -3.618056840863206e-11, -5.091023190084620e-14,  1.639206971942909e-16,  1.674441756006679e-18,
  7.805054688930525e-21,  2.288540337955848e-23,  2.095221878896991e-26, -2.370379468568195e-28,  1.913229905425350e+00, -5.806431347456650e-04, -2.769076307705674e-06,
 -1.088388521129282e-08, -3.564952287757621e-11, -9.014151190797405e-14, -1.124111133169238e-16,  4.837481746702730e-19,  4.628574398190102e-21,  2.285131051938842e-23,
  8.005197324349803e-26,  1.771911417624509e-28,  1.945491287581378e+00, -3.718325393250514e-04, -1.843766424592386e-06, -7.774342695777221e-09, -2.886126327365771e-11,
 -9.358780765976403e-14, -2.504156244639290e-16, -4.376569911691773e-19,  4.351406469146750e-22,  8.893021715735720e-24,  5.365619964905429e-26,  2.353604556541608e-28,
  1.970478871120433e+00, -2.043597578839101e-04, -1.043527846462094e-06, -4.629706020685296e-09, -1.868085038744667e-11, -6.948770787506686e-14, -2.375787048859108e-16,
 -7.316780252793273e-19, -1.918524689652320e-21, -3.511390941277898e-24,  1.538008401137956e-27,  5.855480997392228e-29,  1.987941756677512e+00, -8.432673302290136e-05,
 -4.393446988456406e-07, -2.016457128926556e-09, -8.577379372766570e-12, -3.452757904967935e-14, -1.327483782978826e-16, -4.890091733247653e-19, -1.723976408324476e-21,
 -5.784199263761256e-24, -1.824589080507990e-26, -5.276132169642823e-29,  1.997706551104540e+00, -1.612972222694620e-05, -8.497427909710892e-08, -3.972622146473786e-10,
 -1.737558831429570e-12, -7.277621433692190e-15, -2.954811122202743e-17, -1.171219386232801e-19, -4.552132896973608e-22, -1.739682037638241e-24, -6.548984788432545e-27,
 -2.431025477635598e-29,  7.162801020443718e-04, -4.313654125179332e-06,  1.947706424808625e-08, -7.813904430574819e-11,  2.937267957949461e-13, -1.059281082462539e-15,
  3.711134668524889e-18, -1.272534791393377e-20,  4.290963234328574e-23, -1.427464504469252e-25,  4.695334584990779e-28, -1.529579234624790e-30,  6.442287690230964e-03,
 -3.870362553421525e-05,  1.738837889383797e-07, -6.917004052331754e-10,  2.566732893016830e-12, -9.087992717179348e-15,  3.105488308692030e-17, -1.030514946349183e-19,
  3.331527157582930e-22, -1.050761269940969e-24,  3.232831377868903e-27, -9.688282422313742e-30,  1.787170201500096e-02, -1.068487208753645e-04,  4.752294593321068e-07,
 -1.858101263261569e-09,  6.713379360755762e-12, -2.286321273629202e-14,  7.396214406454038e-17, -2.274844656402975e-19,  6.618654888711515e-22, -1.798233371446624e-24,
  4.433353984040132e-27, -9.228431930174977e-30,  3.495920828409149e-02, -2.074851078593442e-04,  9.088233247906361e-07, -3.460098098188714e-09,  1.198331409398266e-11,
 -3.825719650147898e-14,  1.121992510136137e-16, -2.959096209600175e-19,  6.610215425338700e-22, -1.005745615009109e-24, -6.306638613136016e-28,  1.402968823896673e-29,
  5.763655324109418e-02, -3.387318485053229e-04,  1.453239108139957e-06, -5.332141682903264e-09,  1.736762851502583e-11, -5.010519568629579e-14,  1.229922339601847e-16,
 -2.219573685772047e-19,  5.991082071757006e-23,  1.921996997761115e-24, -1.193311367905764e-26,  5.008010798124664e-29,  8.581221260676598e-02, -4.981090992294131e-04,
  2.081040442802274e-06, -7.272238573221600e-09,  2.172688532235665e-11, -5.326312394248682e-14,  8.817410133752253e-17,  3.626352630829235e-20, -1.117937566681519e-21,
  6.009184692231620e-24, -2.239200477298124e-26,  6.247379086294232e-29,  1.193709558094566e-01, -6.825630805663089e-04,  2.759736569957661e-06, -9.056900461611566e-09,
  2.394259016725984e-11, -4.374704578445828e-14,  8.454872949597805e-19,  4.465439421267168e-19, -2.471710596858911e-21,  8.785547932417418e-24, -2.089637184915140e-26,
  1.400191269490125e-29,  1.581733155259293e-01, -8.884983984361785e-04,  3.452956572852008e-06, -1.045843565777658e-08,  2.307691613037559e-11, -1.976205548131912e-14,
 -1.302125729946547e-16,  8.962313582407196e-19, -3.315191734103179e-21,  7.388252172674196e-24,  4.214927074968182e-29, -9.396562345730304e-29,  2.020549721146487e-01,
 -1.111818415587507e-03,  4.121825253329936e-06, -1.126365192275892e-08,  1.852338640682199e-11,  1.757256727871978e-14, -2.798057122234984e-16,  1.215390512066233e-18,
 -2.938371115600514e-21,  3.012158113031912e-25,  3.627909124548407e-26, -1.997780451365661e-28,  2.508260660397342e-01, -1.347974464707398e-03,  4.726517160173676e-06,
 -1.129286477235666e-08,  1.013034573713793e-11,  6.396787260264108e-14, -4.100212903127343e-16,  1.226954411046975e-18, -9.577321934243364e-22, -1.111565960349081e-23,
  6.950315415578586e-26, -2.049004327118851e-28,  3.042704549439570e-01, -1.592024754243767e-03,  5.227957076260360e-06, -1.041795114698553e-08, -1.720290667123999e-12,
  1.122893869438928e-13, -4.781427675581119e-16,  8.118578065794094e-19,  2.383641280938998e-21, -2.227229265460489e-23,  7.410475930157251e-26, -4.194559268881253e-29,
  3.621449362153833e-01, -1.838703832299767e-03,  5.589625372374116e-06, -8.578070654204370e-09, -1.609404758636282e-11,  1.534884147762270e-13, -4.474958704485582e-16,
 -3.043577981577590e-20,  6.117731728893591e-21, -2.676247149851175e-23,  3.220754349181407e-26,  2.510858274174239e-28,  4.241784607737616e-01, -2.082503428381516e-03,
  5.779415092087637e-06, -5.791615984966987e-09, -3.155519410024897e-11,  1.780657795146267e-13, -2.989505659421502e-16, -1.148508943542791e-18,  8.757831705973897e-21,
 -1.933485348885558e-23, -5.047353139991534e-26,  5.101742421697065e-28,  4.900713694272670e-01, -2.317765369863088e-03,  5.771474699604700e-06, -2.162975712793922e-09,
 -4.629227470804878e-11,  1.778828615503481e-13, -4.015511461138373e-17, -2.251294992464388e-18,  8.805270341597069e-21,  7.328562743514167e-25, -1.386090135472110e-25,
  5.192567810529319e-28,  5.594946895320869e-01, -2.538787049806905e-03,  5.547956631294140e-06,  2.117175091145710e-09, -5.831325702874985e-11,  1.480328893491920e-13,
  2.904826223429433e-16, -2.973509572969292e-18,  5.416003323247091e-21,  2.762543526180439e-23, -1.790411362218155e-25,  1.595057841597663e-28,  6.320895367920575e-01,
 -2.739939583470797e-03,  5.100578027152486e-06,  6.779069105213510e-09, -6.569568354527626e-11,  8.841298923651168e-14,  6.273454627955724e-16, -2.984667816732431e-18,
 -1.028991351695983e-21,  4.994962026175942e-23, -1.291651344126376e-25, -4.555986933845442e-28,  7.074666747603138e-01, -2.915798310258218e-03,  4.431887597711634e-06,
  1.148910164597368e-08, -6.686665087927265e-11,  4.617307437778128e-15,  8.894531370763589e-16, -2.113698363754828e-18, -8.740524772750315e-21,  5.512463935527831e-23,
  1.125155675807819e-26, -9.753759053035788e-28,  7.852062927555864e-01, -3.061284655687784e-03,  3.556123312107666e-06,  1.587310478188435e-08, -6.087768111899085e-11,
 -9.217586525904171e-14,  9.992141118198338e-16, -4.474819790537984e-19, -1.492621486584206e-20,  3.584783558912410e-23,  1.854055319865857e-25, -9.943552289694182e-28,
  8.648580711708971e-01, -3.171817549035825e-03,  2.499541786612860e-06,  1.954680488432147e-08, -4.763241215057464e-11, -1.865122508195149e-13,  9.043178048506411e-16,
  1.640438759138980e-18, -1.676787336528410e-20, -4.403411552874066e-24,  2.982696727397755e-25, -3.467308792249187e-28,  9.459416110761928e-01, -3.243471591303427e-03,
  1.300104667140761e-06,  2.215168761807423e-08, -2.802264354264859e-11, -2.611342935915435e-13,  5.970600494047196e-16,  3.560306604914954e-18, -1.267249364845230e-20,
 -5.034077242044155e-23,  2.674283486878854e-25,  6.868684942608844e-28,  1.027947311973813e+00, -3.273137995412504e-03,  6.422959857192473e-09,  2.339347778634104e-08,
 -3.932760882787711e-12, -3.003104262418482e-13,  1.246592394286927e-16,  4.674145267349762e-18, -3.269239669618126e-21, -8.029155813993797e-23,  8.082374818979025e-26,
  1.463377219251158e-27,  1.110337786744191e+00, -3.258683008989233e-03, -1.324109868093546e-06,  2.307946364870678e-08,  2.191443728154674e-11, -2.934291854417809e-13,
 -4.147339060565645e-16,  4.519437669362489e-18,  8.408232978743178e-21, -7.674589595366358e-23, -1.775866914943399e-25,  1.380894737175508e-27,  1.192549905214968e+00,
 -3.199097142724384e-03, -2.628018748555691e-06,  2.115011883611044e-08,  4.627548495151529e-11, -2.380504340346052e-13, -8.923312024108215e-16,  3.011466630656380e-18,
  1.785982082133427e-20, -3.704615419493097e-23, -3.624520981171423e-25,  3.618848651523518e-28,  1.273997556222651e+00, -3.094627163926691e-03, -3.839240475927061e-06,
  1.770010081955968e-08,  6.584293869119256e-11, -1.415429135453098e-13, -1.182285212388990e-15,  5.352792232707472e-19,  2.097579621364115e-20,  2.236757737629726e-23,
 -3.533269596213608e-25, -9.753990294386441e-28,  1.354075211213067e+00, -2.946881616656848e-03, -4.893287817505379e-06,  1.298394870948507e-08,  7.778305134516044e-11,
 -2.060067653019193e-14, -1.200086846771839e-15, -2.136537526583087e-18,  1.605382405005483e-20,  7.241928036059123e-23, -1.414110835169324e-25, -1.690150502765088e-27,
  1.432162359017602e+00, -2.758899779070201e-03, -5.731869445915411e-06,  7.402853364313343e-09,  8.026591145249288e-11,  1.016498223142356e-13, -9.334618115835659e-16,
 -4.100837001817181e-18,  4.928375620139944e-21,  8.680023098526681e-23,  1.491615689923117e-25, -1.237126593112436e-27,  1.507628860235731e+00, -2.535173681242050e-03,
 -6.307653855072079e-06,  1.470831629259491e-09,  7.288026841285661e-11,  2.006114822755700e-13, -4.533138123790483e-16, -4.674165939359995e-18, -7.583491142247627e-21,
  5.796445632033320e-23,  3.353653140350124e-25,  4.397572198851835e-29,  1.579841239753096e+00, -2.281613314663553e-03, -6.588776566771099e-06, -4.238547889957685e-09,
  5.682617340931887e-11,  2.562089349187552e-13,  1.028348913037810e-16, -3.691127353129404e-18, -1.590387673049339e-20,  3.049913360849812e-24,  3.028105821693413e-25,
  1.154907671110668e-27,  1.648169896988017e+00, -2.005446685895819e-03, -6.562625217478552e-06, -9.160334500553135e-09,  3.480619483797034e-11,  2.583280170371651e-13,
  5.730609926045061e-16, -1.601128483875218e-18, -1.655365065261325e-20, -4.584479723051861e-23,  9.158171674639777e-26,  1.269524438263371e-27,  1.711997165971279e+00,
 -1.715049064387231e-03, -6.238414525443031e-06, -1.281322196502833e-08,  1.059128979799351e-11,  2.099721091622201e-13,  8.261074756606166e-16,  7.111693100874120e-19,
 -1.003476340134279e-20, -6.202880236075849e-23, -1.348695800954466e-25,  4.429090292762303e-28,  1.770726102888840e+00, -1.419699705662628e-03, -5.648099709990546e-06,
 -1.487054961880170e-08, -1.168692802310917e-11,  1.268323417849945e-13,  8.086984439649363e-16,  2.322885002518416e-18, -4.893401389752637e-22, -4.144865232118838e-23,
 -2.203119999283900e-25, -4.927121530461488e-28,  1.823789820100336e+00, -1.129269396914241e-03, -4.845284621176009e-06, -1.521501402254844e-08, -2.838631589630605e-11,
  3.296769128282040e-14,  5.645541307230016e-16,  2.701426219199555e-18,  6.813848863641449e-21, -3.832538569410044e-24, -1.371535208113036e-25, -7.589394986829566e-28,
  1.870661127137897e+00, -8.538480760416169e-04, -3.901961879156991e-06, -1.396562965799998e-08, -3.715548533479931e-11, -4.638453315257886e-14,  2.144266136848325e-16,
  1.937525206602636e-18,  8.641249641750901e-21,  2.348696606524207e-23,  8.396436525387554e-27, -3.372400828292828e-28,  1.910862186618938e+00, -6.033280063109988e-04,
 -2.903165239330020e-06, -1.146884188697736e-08, -3.747814483599364e-11, -9.265931971894575e-14, -9.666439786901515e-17,  6.456580658355844e-19,  5.510722627044258e-21,
  2.620750140722248e-23,  8.769504680696664e-26,  1.685516832382534e-28,  1.943973855038267e+00, -3.869638338303438e-04, -1.939892055232255e-06, -8.251427633603769e-09,
 -3.079410233997972e-11, -9.974295078581013e-14, -2.624238741545755e-16, -4.181749220689276e-19,  7.965254861913014e-22,  1.125830360520520e-23,  6.491219947884510e-26,
  2.771438807389049e-28,  1.969644376470418e+00, -2.129353954050820e-04, -1.100924565103279e-06, -4.940034554652622e-09, -2.012931922695909e-11, -7.544249424147678e-14,
 -2.589440767925200e-16, -7.950761220173225e-19, -2.043154093535722e-21, -3.392517020393676e-24,  4.559083729362792e-27,  7.963509286316321e-29,  1.987597263615145e+00,
 -8.794066723318553e-05, -4.643889747394417e-07, -2.159397485460826e-09, -9.300932690211358e-12, -3.788427866589072e-14, -1.472453117772770e-16, -5.476536294087885e-19,
 -1.945921359131941e-21, -6.562367889581863e-24, -2.071064366624642e-26, -5.936528312668303e-29,  1.997640641753109e+00, -1.682906898000303e-05, -8.991316248158264e-08,
 -4.262672514911585e-10, -1.890477198700102e-12, -8.027834855241659e-15, -3.304124917161995e-17, -1.327435489813623e-19, -5.228268095948534e-22, -2.024354807647938e-24,
 -7.718890970989050e-27, -2.901385992569183e-29,  6.993312907114320e-04, -4.161509970889694e-06,  1.856690971471005e-08, -7.360417963996137e-11,  2.734037675844576e-13,
 -9.743390279935549e-16,  3.373300999119583e-18, -1.143096441808052e-20,  3.809321902283593e-23, -1.252441840481655e-25,  4.071706256748885e-28, -1.311065607378578e-30,
  6.290203727224995e-03, -3.734507224624859e-05,  1.658239209045834e-07, -6.520472220277801e-10,  2.392198570645353e-12, -8.376130225520375e-15,  2.831318015406511e-17,
 -9.297169933106963e-20,  2.975537345145278e-22, -9.295897251725166e-25,  2.834913195862119e-27, -8.429170470914704e-30,  1.745177212004902e-02, -1.031342821582137e-04,
  4.535619454719708e-07, -1.754250984239403e-09,  6.273362205341776e-12, -2.116222136585749e-14,  6.787960218956557e-17, -2.073071107110281e-19,  6.002248367575115e-22,
 -1.628844837978076e-24,  4.040470195453292e-27, -8.625090920260960e-30,  3.414355058450103e-02, -2.003774037224980e-04,  8.684277623507213e-07, -3.274342690788008e-09,
  1.124443907183850e-11, -3.566148345637211e-14,  1.042044481505821e-16, -2.753399658798469e-19,  6.244997919853977e-22, -1.019669791797131e-24, -9.002796668321043e-29,
  1.066585660727751e-29,  5.630447900009357e-02, -3.273572295744058e-04,  1.390888144610155e-06, -5.062118184448901e-09,  1.639454071739440e-11, -4.722768236574608e-14,
  1.168140370165946e-16, -2.190211043542590e-19,  1.210209010651168e-22,  1.486449848496706e-24, -9.899049163723654e-27,  4.255352706890034e-29,  8.385252840412900e-02,
 -4.818040136372120e-04,  1.995824580473839e-06, -6.933015253866044e-09,  2.068284680763637e-11, -5.113860958719526e-14,  8.871996398830217e-17,  3.783233535537514e-21,
 -9.170806227982410e-22,  5.166948625599990e-24, -1.975802310044646e-26,  5.722924844906355e-29,  1.166841800541951e-01, -6.609134733121609e-04,  2.653323394831966e-06,
 -8.680813349760493e-09,  2.306881995808617e-11, -4.358536652296985e-14,  1.228779625334045e-17,  3.723497045568026e-19, -2.170306592194877e-21,  7.964302303944602e-24,
 -2.011427563513425e-26,  2.110127940030223e-29,  1.546737832168339e-01, -8.613705049437391e-04,  3.329657158733130e-06, -1.009252840616737e-08,  2.265239574396482e-11,
 -2.259776564783368e-14, -1.065633580127544e-16,  7.943935295645823e-19, -3.050114869948998e-21,  7.314419706609040e-24, -3.563979833506044e-27, -7.064590809578466e-29,
  1.976727987640847e-01, -1.079379406095601e-03,  3.988450122501998e-06, -1.096481961655160e-08,  1.881038605250627e-11,  1.125499586394408e-14, -2.470876382871841e-16,
  1.121799517883731e-18, -2.903448860226526e-21,  1.584898471848751e-24,  2.810819103733425e-26, -1.718956054919680e-28,  2.455089382116837e-01, -1.310701535665853e-03,
  4.592015814717737e-06, -1.112106743495921e-08,  1.131406141344109e-11,  5.453580415471123e-14, -3.761520650282485e-16,  1.190423380765554e-18, -1.310012261666568e-21,
 -8.514210430346353e-24,  6.061960476176611e-26, -1.980238413083811e-28,  2.979852110352961e-01, -1.550701460539789e-03,  5.102848627383863e-06, -1.042812511924888e-08,
  4.126255768292569e-13,  1.010946434777413e-13, -4.544593610133129e-16,  8.758732576020255e-19,  1.634642657384141e-21, -1.935656651391211e-23,  7.141695652759968e-26,
 -7.830081646734256e-29,  3.548788970814735e-01, -1.794402724781776e-03,  5.485242908228261e-06, -8.811600706899978e-09, -1.313163674358242e-11,  1.427595283538166e-13,
 -4.457502758267559e-16,  1.501853387742660e-19,  5.179927882921053e-21, -2.527579027545251e-23,  4.158547990478964e-26,  1.768137709811181e-28,  4.159404657752895e-01,
 -2.036554420149611e-03,  5.707002633759995e-06, -6.268408769807211e-09, -2.806807057423488e-11,  1.705360792262044e-13, -3.272924775335095e-16, -8.797421335624583e-19,
  8.030665903908141e-21, -2.092467170167336e-23, -2.951514055083981e-26,  4.418966585058746e-28,  4.808924697365424e-01, -2.271709716661509e-03,  5.741192108570849e-06,
 -2.875264072091379e-09, -4.274919612100892e-11,  1.761945307695665e-13, -9.925001657515549e-17, -1.970129455216323e-18,  8.737379296880811e-21, -4.352849358582539e-24,
 -1.156733426220884e-25,  5.197341446849580e-28,  5.494284474515646e-01, -2.494317406226197e-03,  5.567863511944664e-06,  1.208199086139706e-09, -5.528952239711848e-11,
  1.540258272294154e-13,  2.097904675144096e-16, -2.785651705428071e-18,  6.283599700613808e-21,  2.063658867549199e-23, -1.696489093029555e-25,  2.628004418399312e-28,
  6.212118778724207e-01, -2.698827293601103e-03,  5.175680995522224e-06,  5.742873845191942e-09, -6.378364238798801e-11,  1.024643360826770e-13,  5.435767815678241e-16,
 -2.989857921186798e-18,  6.718209782963649e-22,  4.443204093105243e-23, -1.454956721076360e-25, -2.884532725940595e-28,  6.958752392343963e-01, -2.879809905874933e-03,
  4.563344367152790e-06,  1.042111318045146e-08, -6.656578540254196e-11,  2.522420906911327e-14,  8.266523051273374e-16, -2.361638462794011e-18, -6.757975465204918e-21,
  5.475013353247323e-23, -2.909557989469374e-26, -8.545369078569429e-28,  7.730192349106756e-01, -3.032090450557669e-03,  3.740699682769036e-06,  1.488561150542925e-08,
 -6.248267562794234e-11, -6.839781223533654e-14,  9.802013847300526e-16, -9.031277389913852e-19, -1.351289126721001e-20,  4.237367961336157e-23,  1.405987112318252e-25,
 -1.033952527357937e-27,  8.522122605456341e-01, -3.150896199888722e-03,  2.729411495453765e-06,  1.875603808525093e-08, -5.114221406106215e-11, -1.643181336753175e-13,
  9.427304753050268e-16,  1.103599151680503e-18, -1.671593868979518e-20,  7.154698232012056e-24,  2.780327243304266e-25, -5.666954915858537e-28,  9.329901986364769e-01,
 -3.232015486820657e-03,  1.563065008706199e-06,  2.166235544970928e-08, -3.309420388342780e-11, -2.456560124711572e-13,  6.908139510768451e-16,  3.127909398294012e-18,
 -1.428565892612091e-20, -3.911951396330423e-23,  2.916223584778030e-25,  4.108497794407937e-28,  1.014856638553428e+00, -3.271965249706660e-03,  2.865695909255640e-07,
  2.328271075088455e-08, -9.898522566687748e-12, -2.957625586818182e-13,  2.536413186158788e-16,  4.524029705053285e-18, -6.086313369627967e-21, -7.580344753561447e-23,
  1.426560630444041e-25,  1.336414089929625e-27,  1.097283630812531e+00, -3.268162562262177e-03, -1.045247814624315e-06,  2.338264870142869e-08,  1.595671365094335e-11,
 -3.018364628507639e-13, -2.848471826311024e-16,  4.743046417231522e-18,  5.532620052061967e-21, -8.258475704616057e-23, -1.132568562937095e-25,  1.531702950932361e-27,
  1.179713093036514e+00, -3.219093869326284e-03, -2.369935677365632e-06,  2.185130474029507e-08,  4.130747496208943e-11, -2.583912804495029e-13, -8.002291692456081e-16,
  3.558881538566124e-18,  1.626997554727871e-20, -5.112217076110136e-23, -3.388008545601154e-25,  7.113729781940213e-28,  1.261558989914449e+00, -3.124473798746121e-03,
 -3.620616739046173e-06,  1.872940574154941e-08,  6.272994077397963e-11, -1.696614118224441e-13, -1.157799094285203e-15,  1.216581530978410e-18,  2.151701634350868e-20,
  7.456802580693588e-24, -3.900986393732908e-25, -6.854516808948626e-28,  1.342210408735944e+00, -2.985383574245667e-03, -4.730031978670730e-06,  1.422359724451373e-08,
  7.707848138671696e-11, -5.006022052258933e-14, -1.252334479872786e-15, -1.582339367729893e-18,  1.854110123423472e-20,  6.526804487538882e-23, -2.161854406844546e-25,
 -1.694755099695814e-27,  1.421035643622662e+00, -2.804377418941071e-03, -5.635266637921851e-06,  8.702116002932893e-09,  8.206568086068884e-11,  7.788960436693874e-14,
 -1.045600005729344e-15, -3.892092356809349e-18,  8.146647748449587e-21,  9.158894750738519e-23,  8.811402342135929e-26, -1.533379849787243e-27,  1.497387383215224e+00,
 -2.585544187865270e-03, -6.282877003688889e-06,  2.668377674008302e-09,  7.677296853390965e-11,  1.881360298038337e-13, -5.872557058566843e-16, -4.880862881174071e-18,
 -5.255691329884872e-21,  7.132364708342498e-23,  3.301680405935414e-25, -2.889879124240138e-28,  1.570609066275307e+00, -2.334511130647126e-03, -6.634014395031420e-06,
 -3.288237761159145e-09,  6.196636453588794e-11,  2.573794325713734e-13, -7.607868614090227e-18, -4.195858766549635e-18, -1.556399842404533e-20,  1.615688990649369e-23,
  3.518678868978421e-25,  1.062684642823681e-27,  1.640042425944818e+00, -2.058377518973236e-03, -6.669034963962934e-06, -8.561371967802624e-09,  4.010634273260484e-11,
  2.714821467532167e-13,  5.205709379052985e-16, -2.156432204919097e-18, -1.812414192988895e-20, -4.100744541351783e-23,  1.516579689164089e-25,  1.457649366085229e-27,
  1.705036185773147e+00, -1.765568208227015e-03, -6.391014337263718e-06, -1.260908245591771e-08,  1.499041428968868e-11,  2.299992562312333e-13,  8.411817605029139e-16,
  3.533293996867111e-19, -1.235957000862222e-20, -6.696298891432096e-23, -1.100142654270739e-25,  6.935062314346995e-28,  1.764955800084215e+00, -1.465601268822628e-03,
 -5.827581064912085e-06, -1.503617068594652e-08, -8.950940477965573e-12,  1.470183837624002e-13,  8.732833136582726e-16,  2.281609654612984e-18, -2.145158823665224e-21,
 -5.067409492238221e-23, -2.403700724144655e-25, -4.115382308945065e-28,  1.819194050789579e+00, -1.168769660611388e-03, -5.030565661087476e-06, -1.566315790885563e-08,
 -2.758521559156565e-11,  4.744914151491027e-14,  6.432179911442828e-16,  2.916135854373563e-18,  6.568798887449278e-21, -1.001728500990265e-23, -1.728384791802463e-25,
 -8.624454412834641e-28,  1.867182227697551e+00, -8.857442961844429e-04, -4.073146017924932e-06, -1.456724031892958e-08, -3.802715449438186e-11, -4.055525636398214e-14,
  2.726759948635523e-16,  2.227607452507765e-18,  9.488938761382721e-21,  2.349155914958081e-23, -9.063472951878594e-27, -4.603952143378888e-28,  1.908401537739592e+00,
 -6.271141683207041e-04, -3.044450789656703e-06, -1.208343722930790e-08, -3.935295956034379e-11, -9.474150105972534e-14, -7.597042391372488e-17,  8.377879376509357e-19,
  6.519075974668356e-21,  2.985855768614085e-23,  9.470785833352481e-26,  1.478996965846770e-28,  1.942394322293917e+00, -4.028875686465285e-04, -2.041932370228094e-06,
 -8.760438268130853e-09, -3.285287496437570e-11, -1.061783572853954e-13, -2.737112837815782e-16, -3.856755503578801e-19,  1.251622022068530e-21,  1.411215072364601e-23,
  7.812305494675355e-26,  3.242218176830254e-28,  1.968774636769475e+00, -2.219855056638501e-04, -1.162188301235499e-06, -5.274519827914317e-09, -2.170215757904859e-11,
 -8.193179711931945e-14, -2.821396087745282e-16, -8.623686547220294e-19, -2.161090521490348e-21, -3.132605259048739e-24,  8.632927169128396e-27,  1.066273063551799e-28,
  1.987237902959325e+00, -9.176201882206913e-05, -4.912202742478776e-07, -2.314471244086427e-09, -1.009523652971567e-11, -4.160943835533972e-14, -1.634880718133654e-16,
 -6.138681550226619e-19, -2.197726505348036e-21, -7.445099289851879e-24, -2.347791618303463e-26, -6.650206189802163e-29,  1.997571853727887e+00, -1.756936180637495e-05,
 -9.521529678452198e-08, -4.578437246515190e-10, -2.059274922275694e-12, -8.867386741729000e-15, -3.700369053288897e-17, -1.507022162119924e-19, -6.015832440801429e-22,
 -2.360238672153770e-24, -9.116710858214786e-27, -3.470276309974304e-29,  6.829768305354802e-04, -4.016434780917055e-06,  1.770927721429277e-08, -6.938132121544735e-11,
  2.547013484446573e-13, -8.970869194493547e-16,  3.069643710116557e-18, -1.028108809691274e-20,  3.386420951752978e-23, -1.100543394250485e-25,  3.536706539709206e-28,
 -1.125756961784507e-30,  6.143427967500979e-03, -3.604914096382367e-05,  1.582235942793266e-07, -6.150761714680017e-10,  2.231265701817734e-12, -7.726806595497658e-15,
  2.583839763720581e-17, -8.396424333243929e-20,  2.660433022582975e-22, -8.232789225903571e-25,  2.488553339053327e-27, -7.340499818532426e-30,  1.704636102674356e-02,
 -9.958831588830399e-05,  4.330994907901838e-07, -1.657176564569767e-09,  5.865949701106407e-12, -1.960064877436894e-14,  6.233530664983484e-17, -1.890076695526166e-19,
  5.444057579669188e-22, -1.474633966197361e-24,  3.674594758864723e-27, -8.004618714601212e-30,  3.335569121125954e-02, -1.935841449209074e-04,  8.301920127273798e-07,
 -3.100004201434689e-09,  1.055560552592414e-11, -3.325086665941065e-14,  9.676918666948602e-17, -2.559431304223141e-19,  5.878322513872431e-22, -1.014722795080015e-24,
  3.177464074251302e-28,  7.968542435641721e-30,  5.501692577322111e-02, -3.164687175820494e-04,  1.331685919780873e-06, -4.807211713245511e-09,  1.547752816089381e-11,
 -4.449725215533228e-14,  1.107431839001357e-16, -2.143651190397511e-19,  1.678387986238463e-22,  1.125947796774057e-24, -8.173492589349733e-27,  3.603836675109835e-29,
  8.195672647438661e-02, -4.661646529703822e-04,  1.914580573951264e-06, -6.610156213141452e-09,  1.968135955909356e-11, -4.901120890830078e-14,  8.844194652132466e-17,
 -2.273488388044085e-20, -7.447035868864635e-22,  4.425430636398910e-24, -1.735638116101485e-26,  5.194513001169054e-29,  1.140823283646829e-01, -6.400973566038831e-04,
  2.551339536265530e-06, -8.318666458872098e-09,  2.220086673330818e-11, -4.317293832119754e-14,  2.178329733149384e-17,  3.073339605853728e-19, -1.897835964381455e-21,
  7.179835819244811e-24, -1.907496904541964e-26,  2.578880403390384e-29,  1.512808173315814e-01, -8.352115628003852e-04,  3.210706103394461e-06, -9.733837308083168e-09,
  2.217661093748981e-11, -2.489915705021926e-14, -8.564743459657783e-17,  7.009697277164194e-19, -2.790056171422548e-21,  7.115654600889183e-24, -6.233563921376735e-27,
 -5.131874765509026e-29,  1.934182702585416e-01, -1.047992984965650e-03,  3.858684497490673e-06, -1.066236435126046e-08,  1.897867516906799e-11,  5.691378432518260e-15,
 -2.169679557032848e-16,  1.030004726957023e-18, -2.827906089875687e-21,  2.565760377953955e-24,  2.112422758977491e-26, -1.459074418954790e-28,  2.403387635708739e-01,
 -1.274496063196717e-03,  4.459683590910880e-06, -1.093179598183188e-08,  1.231717525739977e-11,  4.590313294167891e-14, -3.434499361071043e-16,  1.144049921679924e-18,
 -1.574950181636992e-21, -6.260625299481312e-24,  5.214214715789235e-26, -1.867216614831168e-28,  2.918632585899089e-01, -1.510378959436806e-03,  4.977815563858212e-06,
 -1.040593214546697e-08,  2.327462567418601e-12,  9.048719875429432e-14, -4.293034583834878e-16,  9.175765327561527e-19,  9.883198113734633e-22, -1.657703434986582e-23,
  6.737391116254171e-26, -1.038303153487559e-28,  3.477883756260191e-01, -1.750947096928558e-03,  5.378335405752199e-06, -8.999444872522511e-09, -1.038299234474211e-11,
  1.321298856857851e-13, -4.393589000862881e-16,  3.017192441311924e-19,  4.301635905765581e-21, -2.347639882174944e-23,  4.791699540903341e-26,  1.126832426885003e-28,
  4.078850732978389e-01, -1.991206660813149e-03,  5.629198343430259e-06, -6.690646777398170e-09, -2.473774734273729e-11,  1.624138020306965e-13, -3.484421735607280e-16,
 -6.350044924270274e-19,  7.260625319782978e-21, -2.173699256341223e-23, -1.161062910892946e-26,  3.719623169414139e-28,  4.718972553597965e-01, -2.225929553365721e-03,
  5.702700836153048e-06, -3.531207696498487e-09, -3.925343120620478e-11,  1.731819856219191e-13, -1.505289617007287e-16, -1.693889056850922e-18,  8.502866697474792e-21,
 -8.526669978154574e-24, -9.315375914465935e-26,  5.011261895936796e-28,  5.395403345455529e-01, -2.449731307557967e-03,  5.577156578571079e-06,  3.484583246298775e-10,
 -5.216485382615062e-11,  1.581481811921429e-13,  1.347097585425304e-16, -2.573975421966272e-18,  6.907380797023801e-21,  1.410615613353488e-23, -1.563209618462945e-25,
  3.385843288755436e-28,  6.104997917704058e-01, -2.657163376633183e-03,  5.238542096898952e-06,  4.739410283668361e-09, -6.161065955776540e-11,  1.145094531499914e-13,
  4.603940636802042e-16, -2.943912050126567e-18,  2.163982898654923e-21,  3.840472978458905e-23, -1.547515248926188e-25, -1.349796733214815e-28,  6.844297796233443e-01,
 -2.842820998167808e-03,  4.682027487238309e-06,  9.361151542853293e-09, -6.586837946368450e-11,  4.424772843004199e-14,  7.577931471917354e-16, -2.546653377492882e-18,
 -4.816616621903018e-21,  5.287456387213848e-23, -6.365894820495481e-26, -7.141008646050823e-28,  7.609518314898315e-01, -3.001467434737627e-03,  3.913287656220223e-06,
  1.387621376957418e-08, -6.361767824741552e-11, -4.522384641844088e-14,  9.490965816294456e-16, -1.310136694193774e-18, -1.189718459770026e-20,  4.708699934188200e-23,
  9.513177093614791e-26, -1.025195959527968e-27,  8.396537518311165e-01, -3.128174770508218e-03,  2.949469858149340e-06,  1.791271050200883e-08, -5.420012955974901e-11,
 -1.413819243248283e-13,  9.661962359703964e-16,  5.749044765984032e-19, -1.626470623951227e-20,  1.772183215675016e-23,  2.490328532461888e-25, -7.438811540514170e-28,
  9.200887788754269e-01, -3.218480542713433e-03,  1.819677094650968e-06,  2.109447287943256e-08, -3.783470688273210e-11, -2.280783770274633e-13,  7.717999555784771e-16,
  2.650517205040723e-18, -1.548038989096026e-20, -2.717577597624473e-23,  3.035220695270051e-25,  1.306650624552691e-28,  1.001775127763298e+00, -3.268558262459487e-03,
  5.648178465182194e-07,  2.307738576963603e-08, -1.574276361320563e-11, -2.881795805213654e-13,  3.771857371326829e-16,  4.286818233917259e-18, -8.698811800641912e-21,
 -6.897226383635661e-23,  1.975382137099001e-25,  1.149209748807660e-27,  1.084196039199482e+00, -3.275398298394524e-03, -7.633244767914338e-07,  2.358933632333162e-08,
  9.862469932410628e-12, -3.070619007445826e-13, -1.500156790273421e-16,  4.871780719853063e-18,  2.494533462869933e-21, -8.573883839857032e-23, -4.388431485303945e-26,
  1.608913235108129e-27,  1.166800474623455e+00, -3.236993655846346e-03, -2.103928326226560e-06,  2.246987315230828e-08,  3.595596239755446e-11, -2.763439564963026e-13,
 -6.935864739908575e-16,  4.047526021305501e-18,  1.419408772762539e-20, -6.394936742902661e-23, -3.001670212653258e-25,  1.039461394494842e-27,  1.249004612022492e+00,
 -3.152522926270033e-03, -3.389958627888221e-06,  1.970444218179837e-08,  5.906200272786624e-11, -1.969618741408199e-13, -1.114076616055422e-15,  1.906356444326303e-18,
  2.149821244973992e-20, -8.651769354853852e-24, -4.127983865385479e-25, -3.381369342067356e-28,  1.330194304405059e+00, -3.022520218831466e-03, -4.551987645326511e-06,
  1.544719643678479e-08,  7.577348343558814e-11, -8.057876163267812e-14, -1.287993077273462e-15, -9.532435884465801e-19,  2.071727902765014e-20,  5.514732673805024e-23,
 -2.892379155210691e-25, -1.610568208691967e-27,  1.409728662699439e+00, -2.849019419258902e-03, -5.522916049879267e-06,  1.002622928749340e-08,  8.336386693185328e-11,
  5.151998705345641e-14, -1.150429152505430e-15, -3.578100950613913e-18,  1.149030138153318e-20,  9.368453458518675e-23,  1.477964470877793e-26, -1.791921047156576e-27,
  1.486944913079702e+00, -2.635657958759422e-03, -6.243364705125949e-06,  3.926034377423045e-09,  8.038359014252280e-11,  1.723853812595774e-13, -7.258704159426247e-16,
 -5.005445017919768e-18, -2.454369973367574e-21,  8.416710498707011e-23,  3.092328138511490e-25, -6.693449626178999e-28,  1.561164651926873e+00, -2.387723835418875e-03,
 -6.667354750443170e-06, -2.255646089287160e-09,  6.710232287266496e-11,  2.557313925404404e-13, -1.319572601202688e-16, -4.681795016097395e-18, -1.471813124744871e-20,
  3.112227154043987e-23,  3.951497270843287e-25,  8.907247690297400e-28,  1.631701576595544e+00, -2.112129418657800e-03, -6.767739900534485e-06, -7.875576241449395e-09,
  4.565568757473112e-11,  2.831844320940426e-13,  4.518583769443458e-16, -2.758725786747671e-18, -1.947530624233706e-20, -3.360915316341727e-23,  2.194072658780255e-25,
  1.615319519276482e-27,  1.697870704646807e+00, -1.817297124751627e-03, -6.540728887109688e-06, -1.233133651445034e-08,  1.979284385447625e-11,  2.502593887023005e-13,
  8.451698070633781e-16, -8.153226582058849e-20, -1.484134839497335e-20, -7.067087489732769e-23, -7.327583178090095e-26,  9.823081127115831e-28,  1.758999007829827e+00,
 -1.512945857217067e-03, -6.008773623582486e-06, -1.515470247162774e-08, -5.795857602763553e-12,  1.687342944320629e-13,  9.359196792720456e-16,  2.181887221763788e-18,
 -4.146547369198312e-21, -6.061632379355812e-23, -2.557841410112897e-25, -2.799491138826173e-28,  1.814437282205955e+00, -1.209773442946768e-03, -5.221137626431374e-06,
 -1.609606255521523e-08, -2.647512548331424e-11,  6.388956493614287e-14,  7.277484518641990e-16,  3.119157173993492e-18,  6.074322181754400e-21, -1.771876910990234e-23,
 -2.129328501705573e-25, -9.580085217740969e-28,  1.863572958385604e+00, -9.190390944752245e-04, -4.251629063817001e-06, -1.518178622825051e-08, -3.876758453633276e-11,
 -3.322746648535116e-14,  3.394264439947978e-16,  2.544672571273714e-18,  1.032284981383724e-20,  2.268206046059774e-23, -3.249328898015688e-26, -6.089582670118305e-28,
  1.905843436210286e+00, -6.520606282393031e-04, -3.193292747974200e-06, -1.272833387505075e-08, -4.126399624084148e-11, -9.625870184739299e-14, -4.942493731608275e-17,
  1.064340225265012e-18,  7.663657445660769e-21,  3.376747822775604e-23,  1.004689333647022e-25,  1.108472059155117e-28,  1.940749422476871e+00, -4.196526283550752e-04,
 -2.150282749137136e-06, -9.303433308217238e-09, -3.504298206720936e-11, -1.128719975193536e-13, -2.838686316841598e-16, -3.368631415175715e-19,  1.819482139641601e-21,
  1.753740063840359e-23,  9.351993955679320e-26,  3.764554285007227e-28,  1.967867690369611e+00, -2.315422189802884e-04, -1.227621235815105e-06, -5.635239698418752e-09,
 -2.341050369885588e-11, -8.900081968398919e-14, -3.072705222786972e-16, -9.332515498753152e-19, -2.266432204571332e-21, -2.683929368724593e-24,  1.405106823938188e-26,
  1.410084269348834e-28,  1.986862815498098e+00, -9.580568620112741e-05, -5.199912410058696e-07, -2.482871717380880e-09, -1.096809683313024e-11, -4.574761303600246e-14,
 -1.817025805244575e-16, -6.886708846264355e-19, -2.483379374588298e-21, -8.444940721875292e-24, -2.656936832599801e-26, -7.408016008708266e-29,  1.997500017230854e+00,
 -1.835363460142169e-05, -1.009131246682411e-07, -4.922606329515254e-10, -2.245856920422491e-12, -9.808367687480992e-15, -4.150615513177255e-17, -1.713858591056699e-19,
 -6.935012961574324e-22, -2.757379131928718e-24, -1.079050705380843e-26, -4.159886978675128e-29,  6.671892629065611e-04, -3.878022925897511e-06,  1.690057331573761e-08,
 -6.544572645087883e-11,  2.374736247057508e-13, -8.267510286018639e-16,  2.796367714459863e-18, -9.258188319890784e-21,  3.014540090324386e-23, -9.684997807973620e-26,
  3.076936147851360e-28, -9.683134916754022e-31,  6.001717076957621e-03, -3.481228049129113e-05,  1.510518890349583e-07, -5.805792983996572e-10,  2.082745212495344e-12,
 -7.133961739392981e-15,  2.360226403438223e-17, -7.590646905801230e-20,  2.381218134543961e-22, -7.299092611139352e-25,  2.186788180405596e-27, -6.398513193114808e-30,
  1.665481362352358e-02, -9.620149817243616e-05,  4.137638252302368e-07, -1.566377952470616e-09,  5.488478499161152e-12, -1.816618747538433e-14,  5.727920327626925e-17,
 -1.724083845604572e-19,  4.938814260158322e-22, -1.334511651628470e-24,  3.336022871078364e-27, -7.386723987712336e-30,  3.259440609119618e-02, -1.870885876294861e-04,
  7.939837570552266e-07, -2.936310863433860e-09,  9.913243161063600e-12, -3.101231111956024e-14,  8.986065744605854e-17, -2.377138806762589e-19,  5.516093462618801e-22,
 -9.956700187970709e-25,  6.192270947986839e-28,  5.816103086040282e-30,  5.377199838488708e-02, -3.060418332060712e-04,  1.275456315969382e-06, -4.566548443283168e-09,
  1.461367858936478e-11, -4.191080024418126e-14,  1.048218135616957e-16, -2.084058331229666e-19,  2.028544351080692e-22,  8.290075508142240e-25, -6.714402682360076e-27,
  3.042346207810372e-29,  8.012220624018203e-02, -4.511600162962251e-04,  1.837116135388157e-06, -6.302981188367483e-09,  1.872229657593652e-11, -4.689879143492211e-14,
  8.749476314240153e-17, -4.414596320645646e-20, -5.973478241955344e-22,  3.775355034469271e-24, -1.518499113351659e-26,  4.678546725836853e-29,  1.115621365910606e-01,
 -6.200799630923166e-04,  2.453618427542545e-06, -7.970329050489786e-09,  2.134329851939095e-11, -4.255350392805062e-14,  2.957623824950765e-17,  2.505938149273833e-19,
 -1.652813550771857e-21,  6.440477504877596e-24, -1.787256334444202e-26,  2.859438493434847e-29,  1.479906110714450e-01, -8.099871446657624e-04,  3.096012232932304e-06,
 -9.383100587730620e-09,  2.165961106877016e-11, -2.672902362434786e-14, -6.723208467095641e-17,  6.157343049297231e-19, -2.538879986629101e-21,  6.826042784877370e-24,
 -8.131979562797709e-27, -3.551539774273204e-29,  1.892872342279079e-01, -1.017630133414257e-03,  3.732560944281005e-06, -1.035806823139982e-08,  1.904271401358943e-11,
  8.200942504489845e-16, -1.893797473105132e-16,  9.411405632036172e-19, -2.721811030952686e-21,  3.289484973202647e-24,  1.523476502775447e-26, -1.221899504189604e-28,
  2.353113082572323e-01, -1.239339903488186e-03,  4.329713362795656e-06, -1.072781374879306e-08,  1.315537437154017e-11,  3.803884597358231e-14, -3.121532204989422e-16,
  1.090432099845531e-18, -1.764734115524590e-21, -4.335241618866867e-24,  4.423053139343086e-26, -1.725314618967406e-28,  2.859005980208939e-01, -1.471055152652016e-03,
  4.853225746700183e-06, -1.035476581155363e-08,  4.036270972834405e-12,  8.049526218220997e-14, -4.032546082711136e-16,  9.401652482067102e-19,  4.389041841625385e-22,
 -1.397888401332113e-23,  6.241424514187824e-26, -1.202448366582721e-28,  3.408699529200356e-01, -1.708355014079799e-03,  5.269430658389823e-06, -9.145001749989263e-09,
 -7.845079343779017e-12,  1.217014369931325e-13, -4.291079940832279e-16,  4.262277973033791e-19,  3.492028300301138e-21, -2.147714819509291e-23,  5.165333117633679e-26,
  5.882766052835625e-29,  4.000097961613555e-01, -1.946500709889449e-03,  5.546641464245251e-06, -7.060924477332195e-09, -2.157440500489075e-11,  1.538633572830905e-13,
 -3.630876394456503e-16, -4.152438317169042e-19,  6.473492781542273e-21, -2.189442170536156e-23,  3.240863746622631e-27,  3.035824813038002e-28,  4.630844972599649e-01,
 -2.180487859695707e-03,  5.656671635937200e-06, -4.131765344402027e-09, -3.582960257719785e-11,  1.690305819002819e-13, -1.941995972177105e-16, -1.427385212950200e-18,
  8.134071077415024e-21, -1.182065857914287e-23, -7.178677422515408e-26,  4.680921796817873e-28,  5.298306505903275e-01, -2.405111276363372e-03,  5.576435133452708e-06,
 -4.607240153606320e-10, -4.897526671496683e-11,  1.605417635663933e-13,  6.580086578504124e-17, -2.345990725663301e-18,  7.306395167958493e-21,  8.167775784911444e-24,
 -1.402343032618835e-25,  3.885708113803336e-28,  5.999552917083331e-01, -2.615044128447461e-03,  5.289577841725743e-06,  3.772533727783604e-09, -5.921660700678955e-11,
  1.245788157325233e-13,  3.791332644933699e-16, -2.853747278653589e-18,  3.434078358496618e-21,  3.213707732063664e-23, -1.576478475908832e-25, -2.694014456259101e-32,
  6.731340943211399e-01, -2.804933285640048e-03,  4.788070278793970e-06,  8.315300735097444e-09, -6.480741296773955e-11,  6.156341131766843e-14,  6.846113186076175e-16,
 -2.670879649968664e-18, -2.966140506445533e-21,  4.974366992655809e-23, -9.178867380742731e-26, -5.636104207989047e-28,  7.490096044358595e-01, -2.969512439999905e-03,
  4.073669049690480e-06,  1.285231949794607e-08, -6.429755898556653e-11, -2.292716422174993e-14,  9.073423785872722e-16, -1.663077631000761e-18, -1.014432306131948e-20,
  5.000228709551385e-23,  5.100487343711780e-26, -9.742100952576373e-28,  8.271895845469722e-01, -3.103734150666174e-03,  3.159129953303603e-06,  1.702415166423791e-08,
 -5.679487827446604e-11, -1.180582033341072e-13,  9.751162067732237e-16,  6.649760624758131e-20, -1.545568981588245e-20,  2.698693730587326e-23,  2.132820079805231e-25,
 -8.729678124148177e-28,  9.072455597408144e-01, -3.202921222317583e-03,  2.069031432194889e-06,  2.045365567120529e-08, -4.220532388873505e-11, -2.087214014140929e-13,
  8.389488945267346e-16,  2.141841078461450e-18, -1.623953120859401e-20, -1.500038405244204e-23,  3.032867889212665e-25, -1.383265704467157e-28,  9.887116790618594e-01,
 -3.262936721839333e-03,  8.400466752397986e-07,  2.277992488491426e-08, -2.140628023596299e-11, -2.777204442008621e-13,  4.929577283624553e-16,  3.970348230352224e-18,
 -1.102799690615471e-20, -6.012564576260747e-23,  2.430781967468295e-25,  9.140498684416965e-28,  1.071084028774353e+00, -3.280370391247745e-03, -4.795088112831385e-07,
  2.369785682270599e-08,  3.696311835475197e-12, -3.090191991779516e-13, -1.295389758172066e-17,  4.902020336591106e-18, -6.065410358255556e-22, -8.607295262618965e-23,
  2.717068098971127e-26,  1.607834912572966e-27,  1.153820558103342e+00, -3.252737174246998e-03, -1.831023285283156e-06,  2.300008850868834e-08,  3.027205824085878e-11,
 -2.915809450538647e-13, -5.742588648234329e-16,  4.462679495738727e-18,  1.168761985787875e-20, -7.495335953591944e-23, -2.479450660654023e-25,  1.325784903110581e-27,
  1.236341800790296e+00, -3.178681025928410e-03, -3.147970017196699e-06,  2.061648711196627e-08,  5.486011059404691e-11, -2.229818419509977e-13, -1.051137116178547e-15,
  2.586106567253300e-18,  2.088696265421845e-20, -2.534938294645201e-23, -4.192550006759771e-25,  4.971235146177850e-29,  1.318032594636081e+00, -3.058174177608714e-03,
 -4.359405677642356e-06,  1.664499232250665e-08,  7.385102255515297e-11, -1.117342204486409e-13, -1.305120809318911e-15, -2.608947330427984e-19,  2.247765568145986e-20,
  4.220607097241734e-23, -3.565274200952217e-25, -1.432445699466932e-27,  1.398245012461522e+00, -2.892698745282328e-03, -5.394569314612141e-06,  1.136676092062766e-08,
  8.411027650059332e-11,  2.275211091410599e-14, -1.244961402419814e-15, -3.156493029365396e-18,  1.485399767284602e-20,  9.263534926447334e-23, -6.868502994302817e-26,
 -1.990122011772533e-27,  1.476302716992718e+00, -2.685394306774688e-03, -6.188424890174287e-06,  5.238759170855461e-09,  8.364570283787666e-11,  1.532766702767625e-13,
 -8.666502702815568e-16, -5.033182062132168e-18,  7.901090556023802e-22,  9.582768602662351e-23,  2.707898543039450e-25, -1.081784434494517e-27,  1.551506933758183e+00,
 -2.441152305234230e-03, -6.687812579243937e-06, -1.141309486633128e-09,  7.217439241371240e-11,  2.509392605495248e-13, -2.694506363787051e-16, -5.131725632410884e-18,
 -1.330440155019751e-20,  4.764216984401608e-23,  4.289525330429227e-25,  6.308059269314247e-28,  1.623144194642652e+00, -2.166636513041747e-03, -6.857675133889695e-06,
 -7.099214051545517e-09,  5.142119697009841e-11,  2.930306246364858e-13,  3.657201174517943e-16, -3.399459376773834e-18, -2.050979803009504e-20, -2.337532230549669e-23,
  2.930719954740328e-25,  1.723129130377147e-27,  1.690495935415014e+00, -1.870209088801000e-03, -6.686636075590416e-06, -1.197350918115097e-08,  2.500040006968258e-11,
  2.704600340882466e-13,  8.358519922257183e-16, -5.976375008426794e-19, -1.742700517454848e-20, -7.264515832671876e-23, -2.310394520669237e-26,  1.302636568035565e-27,
  1.752849930388241e+00, -1.561744783890456e-03, -6.191071081564727e-06, -1.521919779161254e-08, -2.191688776790084e-12,  1.919123994442503e-13,  9.948126094970205e-16,
  2.012286968682471e-18, -6.515404646924111e-21, -7.104223341162647e-23, -2.641135040178399e-25, -8.787634017475551e-29,  1.809513416900925e+00, -1.252322252768377e-03,
 -5.416786665948901e-06, -1.650846316717141e-08, -2.501548951254999e-11,  8.242487910253636e-14,  8.176980503021006e-16,  3.301601678079790e-18,  5.272749188168199e-21,
 -2.710375332243740e-23, -2.568861045030659e-25, -1.036035520415310e-27,  1.859827607177361e+00, -9.537914450148064e-04, -4.437552615232523e-06, -1.580691645697645e-08,
 -3.934470412396287e-11, -2.418815024454054e-14,  4.154225616536263e-16,  2.887762437728747e-18,  1.110910236640629e-20,  2.079673742752853e-23, -6.305246610505481e-26,
 -7.846559975846302e-28,  1.903183117621246e+00, -6.782293007356508e-04, -3.350057808710330e-06, -1.340401301157326e-08, -4.319847025249662e-11, -9.705841905041359e-14,
 -1.600176218236700e-17,  1.329811593912484e-18,  8.952661264922421e-21,  3.786823776537651e-23,  1.041407698886672e-25,  5.193975477893327e-29,  1.939035686692784e+00,
 -4.373111608238743e-04, -2.265363778154369e-06, -9.882553786429449e-09, -3.736927792017092e-11, -1.197908414513474e-13, -2.923854194514790e-16, -2.677828202265784e-19,
  2.522303820564427e-21,  2.162590031518156e-23,  1.113189834174179e-25,  4.332702538293470e-28,  1.966921442104375e+00, -2.416401859584931e-04, -1.297551583635992e-06,
 -6.024457602613516e-09, -2.526642435120547e-11, -9.669716524482487e-14, -3.344306055974111e-16, -1.007202003838254e-18, -2.351332830822145e-21, -1.985709845264696e-24,
  2.117701842851131e-26,  1.845823046311321e-28,  1.986471079889780e+00, -1.000878484029216e-04, -5.508696181573477e-07, -2.665924546338089e-09, -1.192826724741379e-11,
 -5.034913669190654e-14, -2.021451232526134e-16, -7.732149389311831e-19, -2.807333636900698e-21, -9.575204753553987e-24, -3.000104628751877e-26, -8.193112609755875e-29,
  1.997424949788127e+00, -1.918519425087847e-05, -1.070425079420137e-07, -5.298194844489760e-10, -2.452387815044601e-12, -1.086470355089865e-14, -4.663118602578374e-17,
 -1.952531721708632e-19, -8.009983986309323e-22, -3.227954306589304e-24, -1.279923619856946e-26, -4.997744436367867e-29,  6.519426960631940e-04, -3.745896374815824e-06,
  1.613748798628579e-08, -6.177486837391741e-11,  2.215892848031513e-13, -7.626430876697485e-16,  2.550135894058122e-18, -8.347026535132247e-21,  2.687044934942559e-23,
 -8.535333895851233e-26,  2.681139785596882e-28, -8.343002298414845e-31,  5.864841446915623e-03, -3.363117732582611e-05,  1.442802703379231e-07, -5.483667389691883e-10,
  1.945562714348336e-12, -6.592174617180501e-15,  2.157972844976191e-17, -6.869065239037680e-20,  2.133539969068272e-22, -6.478198045299000e-25,  1.923623631510386e-27,
 -5.582814460589511e-30,  1.627651087908534e-02, -9.296510798151680e-05,  3.954824315915659e-07, -1.481395804156483e-09,  5.138519780808584e-12, -1.684767342469933e-14,
  5.266598499568333e-17, -1.573477285547411e-19,  4.481642431986468e-22, -1.207392432216382e-24,  3.024320956466399e-27, -6.785102699272657e-30,  3.185853606664767e-02,
 -1.808750104808537e-04,  7.596796033856115e-07, -2.782545991911692e-09,  9.314034529969355e-12, -2.893356552263118e-14,  8.344643802945063e-17, -2.206306389556753e-19,
  5.162678459705235e-22, -9.663147533892094e-25,  8.361040531406872e-28,  4.107858684425217e-30,  5.256789682420666e-02, -2.960534649091787e-04,  1.222033424045193e-06,
 -4.339300596738685e-09,  1.380015105672423e-11, -3.946434177093793e-14,  9.908146077476329e-17, -2.014862888986315e-19,  2.281734377265596e-22,  5.857311187320288e-25,
 -5.484514547568250e-27,  2.560328048699192e-29,  7.834648810290075e-02, -4.367606083926391e-04,  1.763247116736124e-06, -6.010814614173646e-09,  1.780520872207807e-11,
 -4.481578868257665e-14,  8.601068367382467e-17, -6.119977898389313e-20, -4.718855367724938e-22,  3.207657222666994e-24, -1.323577495187475e-26,  4.186086615300963e-29,
  1.091204769994032e-01, -6.008278505085418e-04,  2.359995481477460e-06, -7.635603986569963e-09,  2.049986508834703e-11, -4.176524189744445e-14,  3.588629116505054e-17,
  2.012780124129268e-19, -1.433516738723807e-21,  5.751230521355511e-24, -1.657990652490596e-26,  2.995649296426157e-29,  1.447994938359070e-01, -7.856635853855691e-04,
  2.985476439023393e-06, -9.040905425542109e-09,  2.111024488990845e-11, -2.814466277423129e-14, -5.109246392166914e-17,  5.383563514373403e-19, -2.299337671397898e-21,
  6.473467233929734e-24, -9.404046914754327e-27, -2.277370687856435e-29,  1.852756547682517e-01, -9.882616538310189e-04,  3.610091991429493e-06, -1.005349175926420e-08,
  1.901574887966335e-11, -3.418525151287856e-15, -1.642286006613192e-16,  8.560448387032692e-19, -2.593657286377629e-21,  3.797788254720816e-24,  1.033528163362842e-26,
 -1.009251395247410e-28,  2.304224138678640e-01, -1.205213498158384e-03,  4.202266328937100e-06, -1.051163832691496e-08,  1.384367407008861e-11,  3.090704022644245e-14,
 -2.824328351332726e-16,  1.031790392224045e-18, -1.890744821683265e-21, -2.713268537688906e-24,  3.698363161954766e-26, -1.566873487786166e-28,  2.800932437670227e-01,
 -1.432725158590707e-03,  4.729407487012162e-06, -1.027782310490973e-08,  5.551533696216891e-12,  7.113418615790910e-14, -3.768056316051510e-16,  9.466296375820064e-19,
 -2.070177767853711e-23, -1.159125169371997e-23,  5.690236612801898e-26, -1.291943114490249e-28,  3.341201459609431e-01, -1.666640481386444e-03,  5.159016031783432e-06,
 -9.251606070537492e-09, -5.513007558174750e-12,  1.115579848001699e-13, -4.157225531775406e-16,  5.260048626969187e-19,  2.756539794529827e-21, -1.937287882612331e-23,
  5.324019579801651e-26,  1.488839203293848e-29,  3.923119949748392e-01, -1.902472140010284e-03,  5.459939233962564e-06, -7.381973827821979e-09, -1.858510277432289e-11,
  1.450324133827155e-13, -3.719325105945059e-16, -2.206532652751480e-19,  5.690669719491764e-21, -2.151695255222300e-23,  1.516305741372962e-26,  2.391410993638521e-28,
  4.544527251312085e-01, -2.135442301780749e-03,  5.603761513975270e-06, -4.678260393567328e-09, -3.249868588020830e-11,  1.639191909048825e-13, -2.305900140352644e-16,
 -1.174418257691467e-18,  7.661695510721254e-21, -1.429230525585750e-23, -5.211001810320658e-26,  4.249787564622537e-28,  5.202993749477767e-01, -2.360534986849028e-03,
  5.566310995297722e-06, -1.218577651701255e-09, -4.575382238623553e-11,  1.613593852128012e-13,  3.423072683252367e-18, -2.108530009953566e-18,  7.503675975466102e-21,
  2.909827487071597e-24, -1.224677481137735e-25,  4.154471632931919e-28,  5.895800126669358e-01, -2.572562338573937e-03,  5.329247201998933e-06,  2.845468084965848e-09,
 -5.664044245344346e-11,  1.327325981572220e-13,  3.009320672002368e-16, -2.726560731605276e-18,  4.477828089923890e-21,  2.586615445103679e-23, -1.550719647425689e-25,
  1.134075639712024e-28,  6.619915775103742e-01, -2.766247117341273e-03,  4.881675829726201e-06,  7.289099407777284e-09, -6.341794408557363e-11,  7.708757002539275e-14,
  6.087617504199139e-16, -2.737898219524876e-18, -1.247023941050909e-21,  4.562102618252214e-23, -1.132361302537854e-25, -4.116835301278252e-28,  7.371976854303123e-01,
 -2.936323692446018e-03,  4.221712973887117e-06,  1.182105691133797e-08, -6.454229443354252e-11, -1.744747789934370e-15,  8.565044887232346e-16, -1.958583409862824e-18,
 -8.317642971218824e-21,  5.120811301074375e-23,  9.909755113414161e-27, -8.887657559476893e-28,  8.148264658236705e-01, -3.077659571154937e-03,  3.357893664772245e-06,
  1.609781549047792e-08, -5.892214845320963e-11, -9.468800428111618e-14,  9.702113395533726e-16, -4.109702661915961e-19, -1.434010540581661e-20,  3.472310049552094e-23,
  1.729501776705638e-25, -9.520702519714669e-28,  8.944685172162398e-01, -3.185398985287937e-03,  2.310289429909268e-06,  1.974608838239466e-08, -4.617385178484566e-11,
 -1.879261071288563e-13,  8.915805545714749e-16,  1.615860852733822e-18, -1.656332373644592e-20, -3.064733179254466e-24,  2.917156554852996e-25, -3.825587507337645e-28,
  9.756750954245198e-01, -3.255129152325246e-03,  1.111169659211474e-06,  2.239366900228234e-08, -2.683358884331580e-11, -2.645972300158028e-13,  5.988753484285959e-16,
  3.584770613006682e-18, -1.300850958287887e-20, -4.967523759843667e-23,  2.774870327238669e-25,  6.458664661938622e-28,  1.057956676905753e+00, -3.283068428801227e-03,
 -1.949835635266401e-07,  2.370758443953075e-08, -2.476086747829876e-12, -3.076880593609171e-13,  1.235674070475603e-16,  4.833380185865409e-18, -3.668706070243552e-21,
 -8.358890986965751e-23,  9.645697530400864e-26,  1.529051463476302e-27,  1.140782072074791e+00, -3.266273570135263e-03, -1.552310856838357e-06,  2.343708286825325e-08,
  2.431294616754940e-11, -3.038239938422864e-13, -4.444863972455740e-16,  4.791714534793351e-18,  8.825496807363268e-21, -8.363294547135175e-23, -1.843839293106703e-25,
  1.552137927115761e-27,  1.223578296627693e+00, -3.202860620444453e-03, -2.895457138739930e-06,  2.145722707058290e-08,  5.015445247346773e-11, -2.472656323780875e-13,
 -9.695289799278711e-16,  3.236662878724816e-18,  1.967413281440854e-20, -4.195657505901337e-23, -4.081350860941872e-25,  4.570441861451921e-28,  1.305731440575162e+00,
 -3.092230556819569e-03, -4.152655332251745e-06,  1.780702832616046e-08,  7.130294309476746e-11, -1.430621987364499e-13, -1.302147769419610e-15,  4.798295247836243e-19,
  2.372583943581754e-20,  2.675760337974816e-23, -4.139220645615775e-25, -1.161560220092000e-27,  1.386588800575667e+00, -2.935286793389058e-03, -5.250083919039071e-06,
  1.271451320848529e-08,  8.425965964080075e-11, -8.130774170996163e-15, -1.326192059002209e-15, -2.628511235526806e-18,  1.811793069532983e-20,  8.809583096067143e-23,
 -1.591381697285595e-25, -2.106148456888854e-27,  1.465462555530652e+00, -2.734627268423967e-03, -6.117432421488803e-06,  6.600436748598624e-09,  8.649185347820854e-11,
  1.307920315608870e-13, -1.006692451336674e-15, -4.950711887083967e-18,  4.422268484581881e-21,  1.055826466424414e-22,  2.138710658352827e-25, -1.505224357826460e-27,
  1.541635261011130e+00, -2.494689578389900e-03, -6.694415205182708e-06,  5.323001195309799e-11,  7.711662924577296e-11,  2.427017811521596e-13, -4.188175902402571e-16,
 -5.526664453805648e-18, -1.127461796068571e-20,  6.525860073132785e-23,  4.493098539818612e-25,  2.794790045297499e-28,  1.614367406584749e+00, -2.221824241482955e-03,
 -6.937734414243886e-06, -6.229146807322112e-09,  5.736148603696643e-11,  3.005908327018968e-13,  2.612373533437646e-16, -4.066825177294613e-18, -2.112186383628895e-20,
 -1.011942292437000e-23,  3.699911702755125e-25,  1.759595618663378e-27,  1.682907213046938e+00, -1.924269687589969e-03, -6.827736131438802e-06, -1.152914607781105e-08,
  3.060851384359364e-11,  2.902542396902156e-13,  8.109170950267158e-16, -1.197205613444816e-18, -2.004415118296795e-20, -7.232378859575640e-23,  4.165249127027738e-26,
  1.642872769435836e-27,  1.746502737010056e+00, -1.612004169948139e-03, -6.373780941658804e-06, -1.522224289036220e-08,  1.889746051431658e-12,  2.164380346334379e-13,
  1.047838702628955e-15,  1.760831366292581e-18, -9.263374870382926e-21, -8.161237703754827e-23, -2.624872555177263e-25,  1.739944108949198e-28,  1.804416195228146e+00,
 -1.296455624170388e-03, -5.617231769891010e-06, -1.689442497844620e-08, -2.316316191993433e-11,  1.031770620251777e-13,  9.123437427240328e-16,  3.452644511017574e-18,
  4.100912595754884e-21, -3.830769863536433e-23, -3.036623477251648e-25, -1.084003669225967e-27,  1.855940224077571e+00, -9.900613327931988e-04, -4.631026836871187e-06,
 -1.643973189309154e-08, -3.972200579530903e-11, -1.320687742693525e-14,  5.013654613942743e-16,  3.254674914158566e-18,  1.180354341522447e-20,  1.752628881943253e-23,
 -1.019507441498475e-25, -9.879438531937086e-28,  1.900415564005566e+00, -7.056850534128869e-04, -3.515117108112571e-06, -1.411072549031366e-08, -4.514029028610377e-11,
 -9.696198334538647e-14,  2.545444877682187e-17,  1.638915938156012e-18,  1.039124079900052e-20,  4.205616801881887e-23,  1.046200271286941e-25, -3.546983497494315e-29,
  1.937249430561952e+00, -4.559187826455775e-04, -2.387622177813053e-06, -1.050001241405108e-08, -3.983582427693462e-11, -1.268881948637248e-13, -2.986299588314381e-16,
 -1.737148628180120e-19,  3.385739518535189e-21,  2.647746391288509e-23,  1.316977251559182e-25,  4.934466381683193e-28,  1.965933652776710e+00, -2.523167949211458e-04,
 -1.372335910938310e-06, -6.444637778498361e-09, -2.728295953499078e-11, -1.050704818698326e-13, -3.636951434964628e-16, -1.083408154025309e-18, -2.405476189315921e-21,
 -9.609308461581053e-25,  3.046187014089227e-26,  2.395354642385145e-28,  1.986061707288455e+00, -1.046260924956586e-04, -5.840399312219604e-07, -2.865103829209987e-09,
 -1.298557230808969e-11, -5.547089815518636e-14, -2.251063408023549e-16, -8.688037317721801e-19, -3.174531714638315e-21, -1.084966768513624e-23, -3.377928115486345e-26,
 -8.977517777756866e-29,  1.997346455100717e+00, -2.006764961800761e-05, -1.136431438675600e-07, -5.708587614550182e-10, -2.681331642824314e-12, -1.205246450852724e-14,
 -5.247532202408597e-17, -2.228477022917431e-19, -9.269759318475867e-22, -3.786761422999275e-24, -1.521538426191139e-26, -6.018070775891965e-29,  6.372126990704059e-04,
 -3.619702530322299e-06,  1.541696935148340e-08, -5.834821508514477e-11,  2.069300149788652e-13, -7.041500305137461e-16,  2.328009531672149e-18, -7.534335524310275e-21,
  2.398224496134289e-23, -7.532800895261169e-26,  2.339844628410144e-28, -7.200261285919205e-31,  5.732584280177334e-03, -3.250273741400807e-05,  1.378823820544356e-07,
 -5.182649838383698e-10,  1.818746464044893e-12, -6.096590735334108e-15,  1.974856993027980e-17, -6.222208576356310e-20,  1.913602675683536e-22, -5.755723139113493e-25,
  1.693897881979313e-27, -4.875896521508295e-30,  1.591086751996560e-02, -8.987098301960101e-05,  3.781880788134569e-07, -1.401807908267934e-09,  4.813857491921910e-12,
 -1.563497740192737e-14,  4.845465489641518e-17, -1.436791566947450e-19,  4.068052442008280e-22, -1.092218814884248e-24,  2.738557040339439e-27, -6.208928440391197e-30,
  3.114698294436742e-02, -1.749286457263427e-04,  7.271644494629714e-07, -2.638044062987293e-09,  8.754899486834290e-12, -2.700314798452815e-14,  7.749488637853335e-17,
 -2.046598825408932e-19,  4.821222001822766e-22, -9.296758868648617e-25,  9.860354248698384e-28,  2.760708539717749e-30,  5.140291093372663e-02, -2.864817894602165e-04,
  1.171260998235484e-06, -4.124685175359933e-09,  1.303419114243146e-11, -3.715324300713051e-14,  9.354494688069631e-17, -1.938875711070919e-19,  2.455708367216401e-22,
  3.876203533504577e-25, -4.451045807111317e-27,  2.147983130937046e-29,  7.662720754959083e-02, -4.229383749377869e-04,  1.692797424629038e-06, -5.732990254867688e-09,
  1.692938833257097e-11, -4.277369860424940e-14,  8.410233694249675e-17, -7.455116632758315e-20, -3.655083810292448e-22,  2.713680274530297e-24, -1.149672250525727e-26,
  3.724133905912548e-29,  1.067543530078144e-01, -5.823088828547696e-04,  2.270308812227545e-06, -7.314239962822906e-09,  1.967360346460993e-11, -4.084133829705462e-14,
  4.091008810034167e-17,  1.585927771713385e-19, -1.238090826386019e-21,  5.114545572285333e-24, -1.525235656954214e-26,  3.023353144049390e-29,  1.417039280579940e-01,
 -7.622080385350940e-04,  2.878993379783918e-06, -8.707706299621798e-09,  2.053626836943517e-11, -2.919809588641795e-14, -3.701408295489169e-17,  4.684318961035429e-19,
 -2.073276217089186e-21,  6.080418807328086e-24, -1.017472556413448e-26, -1.265530008128009e-29,  1.813796128529095e-01, -9.598583197680548e-04,  3.491272674147396e-06,
 -9.749992912850956e-09,  1.890985709770108e-11, -7.081630192527965e-15, -1.414002297667833e-16,  7.753067788889134e-19, -2.450513446187159e-21,  4.128090933051164e-24,
  6.316583101982182e-27, -8.215094397687035e-29,  2.256680026269339e-01, -1.172096116053039e-03,  4.077474893915603e-06, -1.028555300919233e-08,  1.439633541367743e-11,
  2.446841644680452e-14, -2.544024831448988e-16,  9.699960331245081e-19, -1.963411728847521e-21, -1.366963692584410e-24,  3.045213135980604e-26, -1.401513610694880e-28,
  2.744372348082712e-01, -1.395381619210095e-03,  4.606651938533977e-06, -1.017809944474710e-08,  6.885929057064869e-12,  6.240847355717473e-14, -3.503689409182598e-16,
  9.397187034664277e-19, -3.983993617162204e-22, -9.430116500917426e-24,  5.113262218873749e-26, -1.322052602340205e-28,  3.275354232720064e-01, -1.625813763689921e-03,
  5.047539396565716e-06, -9.322501837322265e-09, -3.380379462704536e-12,  1.017667191003405e-13, -3.998613987249617e-16,  6.034669910857773e-19,  2.097506938777369e-21,
 -1.724102945095552e-23,  5.309946947685917e-26, -1.983624980143978e-29,  3.847888975625157e-01, -1.859151798740974e-03,  5.369665523643930e-06, -7.656617025591829e-09,
 -1.577411542400235e-11,  1.360517600279842e-13, -3.756768832343131e-16, -5.080903078248361e-20,  4.929350084371628e-21, -2.071775831982763e-23,  2.436780701766608e-26,
  1.802761231595912e-28,  4.460002484069918e-01, -2.090845358660291e-03,  5.544609698699095e-06, -5.172323674729387e-09, -2.927816613127486e-11,  1.580176418125423e-13,
 -2.601212960407462e-16, -9.378429252844510e-19,  7.114031244032106e-21, -1.601691208136035e-23, -3.447996696247282e-26,  3.756521300533524e-28,  5.109461861182176e-01,
 -2.316075190456022e-03,  5.547402154511630e-06, -1.924836428691978e-09, -4.253045477140104e-11,  1.607602700463846e-13, -5.224490514447092e-17, -1.867645784724050e-18,
  7.524691713575468e-21, -1.619892151209864e-24, -1.039672117041795e-25,  4.225099629007813e-28,  5.793752260425686e-01, -2.529806980514817e-03,  5.358044140995998e-06,
  1.960824981883854e-09, -5.391966345610179e-11,  1.390558530750899e-13,  2.267259512331638e-16, -2.569556994888620e-18,  5.298821383716691e-21,  1.979141065180646e-23,
 -1.480054072367148e-25,  2.040025442164580e-28,  6.510052256341713e-01, -2.726860961411813e-03,  4.963110277821444e-06,  6.287514012138357e-09, -6.173631639933869e-11,
  9.077489445008760e-14,  5.317824097145590e-16, -2.752432265844769e-18,  3.098358323750376e-22,  4.077293248192310e-23, -1.281040899865460e-25, -2.656246006063233e-28,
  7.255208116897234e-01, -2.902000128917666e-03,  4.357372010697326e-06,  1.078919875760828e-08, -6.437621858704357e-11,  1.812490357817903e-14,  7.982150988773078e-16,
 -2.195250265504353e-18, -6.476159458260901e-21,  5.085356033993936e-23, -2.682620829215046e-26, -7.775330110052210e-28,  8.025707544661306e-01, -3.050039889246891e-03,
  3.545352515593608e-06,  1.514117136002605e-08, -6.058425281715117e-11, -7.159167124192467e-14,  9.524767668335419e-16, -8.486007045916655e-19, -1.297576428993172e-20,
  4.079090525045822e-23,  1.302190491370810e-25, -9.824796044950825e-28,  8.817653685109235e-01, -3.165981694916213e-03,  2.542689574968773e-06,  1.897841550266937e-08,
 -4.971503949951646e-11, -1.660451598683962e-13,  9.294035491674173e-16,  1.086284425930586e-18, -1.646826577796835e-20,  8.202965268884431e-24,  2.701495968317293e-25,
 -5.910848393766867e-28,  9.626740486208530e-01, -3.245172594623806e-03,  1.377145649352735e-06,  2.192281021777633e-08, -3.197392293214589e-11, -2.490683520218155e-13,
  6.931678413745836e-16,  3.142078191133869e-18, -1.459093485250412e-20, -3.809059400919347e-23,  2.996684700691121e-25,  3.610032802710406e-28,  1.044823083664121e+00,
 -3.283491473163573e-03,  8.906731832368627e-08,  2.361894383375259e-08, -8.589309903612909e-12, -3.031144425516249e-13,  2.568121489419841e-16,  4.668708359764067e-18,
 -6.592593939531334e-21, -7.842450392321280e-23,  1.606643758633464e-25,  1.378333690722705e-27,  1.127693930761681e+00, -3.277560929240413e-03, -1.268934094988201e-06,
  2.377694471283048e-08,  1.814081011500723e-11, -3.128525677874072e-13, -3.068265484530980e-16,  5.024671127514703e-18,  5.698883183446936e-21, -8.959191841677507e-23,
 -1.124574754575566e-25,  1.704008295936532e-27,  1.210722176334588e+00, -3.224981072543412e-03, -2.633322789831284e-06,  2.221890361716819e-08,  4.498415496317129e-11,
 -2.693771746901556e-13, -8.703376774011364e-16,  3.838963859418935e-18,  1.787577750245646e-20, -5.776001314524326e-23, -3.790989713127097e-25,  8.600112410634857e-28,
  1.293297456276493e+00, -3.124577896174759e-03, -3.932225814904508e-06,  1.892329358493105e-08,  6.813071865048319e-11, -1.740659563967128e-13, -1.277961887396683e-15,
  1.251179127162706e-18,  2.437966236711010e-20,  9.277463506993460e-24, -4.574941135797518e-25, -8.060855300307785e-28,  1.374764650687527e+00, -2.976654273193535e-03,
 -5.089431866812397e-06,  1.405961367674084e-08,  8.377314744840453e-11, -4.077416693425306e-14, -1.391206579373687e-15, -1.999404948161893e-18,  2.115234201391893e-20,
  7.986462005932633e-23, -2.525323818131423e-25, -2.121026706880663e-27,  1.454426702635357e+00, -2.783226191005273e-03, -6.029842020085871e-06,  8.003873604792525e-09,
  8.885495745777598e-11,  1.049875322452607e-13, -1.142748809630448e-15, -4.746869502264083e-18,  8.360153349079482e-21,  1.126906580462318e-22,  1.385529738424679e-25,
 -1.913418842768963e-27,  1.531549426194137e+00, -2.548221004173239e-03, -6.686214980003774e-06,  1.325328908426535e-09,  8.185741313693843e-11,  2.307547259491785e-13,
 -5.782372104287328e-16, -5.846377807400832e-18, -8.599952999030307e-21,  8.335366199673425e-23,  4.522390534723045e-25, -1.602800632463331e-28,  1.605368655084773e+00,
 -2.277609054605995e-03, -7.006778088957476e-06, -5.262967937547844e-09,  6.342638032647379e-11,  3.054174685142116e-13,  1.378701266395519e-16, -4.745546252651139e-18,
 -2.120118209198501e-20,  6.219394858790948e-24,  4.465362423657234e-25,  1.702485549448942e-27,  1.675100026647291e+00, -1.979436202142902e-03, -6.962952508279289e-06,
 -1.099192447412952e-08,  3.660511873731406e-11,  3.092391185651596e-13,  7.680272831289194e-16, -1.879807928038451e-18, -2.259947270920572e-20, -6.911053819374573e-23,
  1.215092817304095e-25,  1.985643690533980e-27,  1.739951584115423e+00, -1.663724233185466e-03, -6.556119121273952e-06, -1.515599436132778e-08,  6.473796701879328e-12,
  2.421415197410715e-13,  1.092535969155517e-15,  1.415388730153454e-18, -1.238772054759486e-20, -9.186475510062583e-23, -2.476629822397185e-25,  5.130052486851092e-28,
  1.799139204368897e+00, -1.342210546385803e-03, -5.822116492160657e-06, -1.724730442419619e-08, -2.087275666563729e-11,  1.262468689086962e-13,  1.010630420896614e-15,
  3.559370567599498e-18,  2.491655520781100e-21, -5.141268630548085e-23, -3.516052971220699e-25, -1.086209596912971e-27,  1.851904617623209e+00, -1.027909474674526e-03,
 -4.832123444391190e-06, -1.707671154607385e-08, -3.985821108131971e-11, -3.730129106329666e-17,  5.978730757682994e-16,  3.641607461316448e-18,  1.235001397285905e-20,
  1.251315063867245e-23, -1.503770309603477e-25, -1.217284514240641e-27,  1.897535491975234e+00, -7.344957303465745e-04, -3.688843124954714e-06, -1.484843456293449e-08,
 -4.706950359115150e-11, -9.576139837160839e-14,  7.623270999212436e-17,  1.996462659351164e-18,  1.197991309195343e-20,  4.617624634360388e-23,  1.004830439353167e-25,
 -1.593020533324871e-28,  1.935386739921145e+00, -4.755347914154844e-04, -2.517531577496893e-06, -1.115807854898463e-08, -4.244558620365608e-11, -1.341005210680020e-13,
 -3.018263677227508e-16, -4.905992302510560e-20,  4.439147659815308e-21,  3.219768438225574e-23,  1.547608297235596e-25,  5.548386588222697e-28,  1.964901927738816e+00,
 -2.636124086272143e-04, -1.452361639721018e-06, -6.898461137483421e-09, -2.947415823337533e-11, -1.141719116809939e-13, -3.951116241625854e-16, -1.160679979939154e-18,
 -2.415424392471448e-21,  4.875166416937821e-25,  4.246239250506962e-26,  3.084941424060250e-28,  1.985633635431605e+00, -1.094395552696885e-04, -6.197053768627772e-07,
 -3.082050350761545e-09, -1.415104713157254e-11, -6.117721791549345e-14, -2.509156585250078e-16, -9.769067919577119e-19, -3.590413185703349e-21, -1.228207006096706e-23,
 -3.789479836212845e-26, -9.717357365161048e-29,  1.997264321772320e+00, -2.100494408680510e-05, -1.207590390705592e-07, -6.157590733523953e-10, -2.935498302438354e-12,
 -1.339023130445247e-14, -5.915170531652244e-17, -2.548149541448428e-19, -1.074924005685885e-21, -4.451821688831466e-24, -1.812827700127290e-26, -7.263507614439687e-29,
  6.229762040688208e-04, -3.499112255805470e-06,  1.473620095409565e-08, -5.514703332408872e-11,  1.933890865607717e-13, -6.507250613221157e-16,  2.127397036055619e-18,
 -6.808546418617209e-21,  2.143154407587873e-23, -6.657240715364799e-26,  2.045062786047372e-28, -6.224130793761726e-31,  5.604740746883705e-03, -3.142406948015777e-05,
  1.318338599879192e-07, -4.901153229419234e-10,  1.701416682996004e-12, -5.642858407585285e-15,  1.808905678876045e-17, -5.641741829582922e-20,  1.718092791860089e-22,
 -5.119203741778013e-25,  1.493163492165527e-27, -4.262732485890626e-30,  1.555732987744492e-02, -8.691147916079518e-05,  3.618183961461692e-07, -1.327225941729924e-09,
  4.512468647644982e-12, -1.451890646205297e-14,  4.460812385348896e-17, -1.312698898328661e-19,  3.693927750046686e-22, -9.879775918937702e-25,  2.477473371494287e-27,
 -5.664001116882877e-30,  3.045870580988714e-02, -1.692356153107972e-04,  6.963308910696227e-07, -2.502187038934097e-09,  8.232980010940342e-12, -2.521032372517761e-14,
  7.197542455539131e-17, -1.897596357592889e-19,  4.493900527367679e-22, -8.881345937051856e-25,  1.083355636914484e-27,  1.706235258122995e-30,  5.027541540744573e-02,
 -2.773061967522742e-04,  1.122991927469701e-06, -3.921962483031840e-09,  1.231314197214143e-11, -3.497241081189832e-14,  8.822797382591239e-17, -1.858386136609447e-19,
  2.565383155705187e-22,  2.274046314584465e-25, -3.585340561667582e-27,  1.796363706729238e-29,  7.496210951743414e-02, -4.096666385864849e-04,  1.625598885463740e-06,
 -5.468854896255982e-09,  1.609392338043358e-11, -4.078152621521871e-14,  8.186522837177670e-17, -8.476998159124887e-20, -2.757103616445599e-22,  2.285299681108102e-24,
 -9.953443836424627e-27,  3.296654727653666e-29,  1.044608940084168e-01, -5.644922063800903e-04,  2.184399820063301e-06, -7.005942143365815e-09,  1.886693237761463e-11,
 -3.981051996113311e-14,  4.482287664831546e-17,  1.218046976016451e-19, -1.064629137136855e-21,  4.530953360415426e-24, -1.393105744540417e-26,  2.971498072112038e-29,
  1.387005058392968e-01, -7.395885202072959e-04,  2.776452970726906e-06, -8.383841640261749e-09,  1.994444757793334e-11, -2.993633830045676e-14, -2.479447596217982e-17,
  4.055098912866021e-19, -1.861818352076970e-21,  5.664766231810728e-24, -1.055041288382523e-26, -4.756094883896223e-30,  1.775953061828907e-01, -9.323910064795796e-04,
  3.376082854111446e-06, -9.448745422743894e-09,  1.873600162779229e-11, -1.022345479506807e-14, -1.207668205522572e-16,  6.993101244211111e-19, -2.298179672279588e-21,
  4.313445485239911e-24,  3.070198440781553e-27, -6.580269083616110e-29,  2.210440816335635e-01, -1.139966072560902e-03,  3.955445405486717e-06, -1.005161933065164e-08,
  1.482681024213237e-11,  1.868153846273407e-14, -2.281279930187450e-16,  9.066028075909628e-19, -1.992138587745604e-21, -2.673317589207145e-25,  2.464971625231702e-26,
 -1.236492441192718e-28,  2.689286439924677e-01, -1.359014987565617e-03,  4.485215528393711e-06, -1.005838718884099e-08,  8.052132538493558e-12,  5.431362399532781e-14,
 -3.242835874734454e-16,  9.219215469368048e-19, -7.024689508611130e-22, -7.500981595115430e-24,  4.533563658116944e-26, -1.306433457167633e-28,  3.211122192390949e-01,
 -1.585881696741962e-03,  4.935410351119617e-06, -9.360820778673442e-09, -1.439606335509436e-12,  9.237983612351677e-14, -3.821150381351887e-16,  6.610640901850750e-19,
  1.514774129984113e-21, -1.514285320553978e-23,  5.161697716478190e-26, -4.626456123628206e-29,  3.774376173244130e-01, -1.816566079113635e-03,  5.276360010989796e-06,
 -7.887724645202108e-09, -1.314326868936199e-11,  1.270355854624748e-13, -3.750018854325704e-16,  9.519941727948201e-20,  4.202821687989199e-21, -1.960029360825649e-23,
  3.112451113957687e-26,  1.279834863433983e-28,  4.377251767019542e-01, -2.046744478327675e-03,  5.479834280248859e-06, -5.615839180674454e-09, -2.618223877982483e-11,
  1.514847983020608e-13, -2.832822104768016e-16, -7.196544330619394e-19,  6.516441491662051e-21, -1.708080282570298e-23, -1.909543549649997e-26,  3.234019708759002e-28,
  5.017704814931033e-01, -2.271799689825500e-03,  5.520327027400187e-06, -2.579687480609485e-09, -3.933188367717712e-11,  1.589059909437351e-13, -1.011822041819894e-16,
 -1.628555049162774e-18,  7.395986460027089e-21, -5.408415735411232e-24, -8.552614418894197e-26,  4.133443782566926e-28,  5.693418554252543e-01, -2.486862960770479e-03,
  5.376490421648385e-06,  1.120630844289866e-09, -5.108985825082032e-11,  1.436536832427734e-13,  1.572513004913483e-16, -2.389718578687903e-18,  5.907111030640592e-21,
  1.407231038218262e-23, -1.374555296419266e-25,  2.718592211871556e-28,  6.401776458847181e-01, -2.686870928441569e-03,  5.032695845761456e-06,  5.314924211142678e-09,
 -5.979942183328999e-11,  1.026152958006355e-13,  4.550666046274816e-16, -2.720041687495068e-18,  1.682980914288132e-21,  3.545559160801299e-23, -1.367834159261184e-25,
 -1.312002776208612e-28,  7.139833244295739e-01, -2.866640747416239e-03,  4.480677554831247e-06,  9.763098818759529e-09, -6.382724159972151e-11,  3.652272664119434e-14,
  7.341201380767085e-16, -2.373467551069005e-18, -4.672657944083292e-21,  4.913307068332940e-23, -5.826392727022163e-26, -6.493829122507022e-28,  7.904284478807050e-01,
 -3.020966872607060e-03,  3.721187232335011e-06,  1.416160177214004e-08, -6.178965305340011e-11, -4.906288832219053e-14,  9.231302425582927e-16, -1.239408856959594e-18,
 -1.142394729752352e-20,  4.513623060228377e-23,  8.715200908334687e-26, -9.681897546750694e-28,  8.691435477106827e-01, -3.144742981330809e-03,  2.765552278890383e-06,
  1.815762886161065e-08, -5.281072848573554e-11, -1.434336862621227e-13,  9.525006831955342e-16,  5.660563414219721e-19, -1.598519784773276e-20,  1.843686909071115e-23,
  2.403431037981229e-25, -7.561166536197186e-28,  9.497170459367785e-01, -3.233112204012348e-03,  1.636988497606110e-06,  2.137230935335110e-08, -3.678208120598834e-11,
 -2.314305300358347e-13,  7.744197944418811e-16,  2.655567542875672e-18, -1.574337635504147e-20, -2.587060801477059e-23,  3.092527428708829e-25,  7.592885620431515e-29,
  1.031692333985562e+00, -3.281648019944692e-03,  3.714712201584032e-07,  2.343339543179393e-08, -1.457950931004268e-11, -2.954086652810366e-13,  3.841675808589497e-16,
  4.413928375546213e-18, -9.286106638321956e-21, -7.084343715399467e-23,  2.168415166363896e-25,  1.166096479899892e-27,  1.114565197483129e+00, -3.286566652250231e-03,
 -9.820768878828923e-07,  2.401678932917921e-08,  1.182161009479103e-11, -3.185105158510620e-13, -1.640728604539395e-16,  5.154710619038272e-18,  2.410924345936894e-21,
 -9.256442183663640e-23, -3.567337688189609e-26,  1.771816591876250e-27,  1.197781824241474e+00, -3.244969328439015e-03, -2.362558830187572e-06,  2.289445251254201e-08,
  3.939676273138467e-11, -2.889127722840967e-13, -7.551713415688489e-16,  4.374873157140433e-18,  1.553361875592110e-20, -7.205419703513657e-23, -3.328852351832082e-25,
  1.233768842390260e-27,  1.280737693048877e+00, -3.155109128388005e-03, -3.698725988167302e-06,  1.998388156798248e-08,  6.434598279550761e-11, -2.042283079017115e-13,
 -1.231982120812405e-15,  2.033078046148624e-18,  2.437679811953456e-20, -9.610993816541989e-24, -4.838321963641488e-25, -3.812769149777541e-28,  1.362777703287745e+00,
 -3.016672154227275e-03, -4.912707116566322e-06,  1.539162841088030e-08,  8.261964618023067e-11, -7.475585561869859e-14, -1.437296392949493e-15, -1.278658996593654e-18,
  2.382332782348392e-20,  6.791762950495965e-23, -3.440879204213305e-25, -2.020790649217965e-27,  1.443197963011640e+00, -2.831056423006799e-03, -5.925201118172943e-06,
  9.440816186857428e-09,  9.066985475561969e-11,  7.600062555725129e-14, -1.271299286168569e-15, -4.413536554416853e-18,  1.249546590561577e-20,  1.164378064149012e-22,
  4.615808778692046e-26, -2.276249507041436e-27,  1.521249695351930e+00, -2.601624497439402e-03, -6.662303019139200e-06,  2.671158073182122e-09,  8.632032264352508e-11,
  2.148844495219092e-13, -7.453126892814230e-16, -6.070095811220188e-18, -5.276639527439940e-21,  1.011549889485179e-22,  4.340570440582780e-25, -6.776213211898007e-28,
  1.596145735400341e+00, -2.333898184630502e-03, -7.063642740557221e-06, -4.199145827693313e-09,  6.955666075889159e-11,  3.070555182543455e-13, -4.444223824566466e-18,
 -5.416810245614669e-18, -2.063808760552785e-20,  2.553745049914011e-23,  5.181173887439831e-25,  1.530692975283924e-27,  1.667070053896489e+00, -2.035657001536331e-03,
 -7.091134221104909e-06, -1.035578220286521e-08,  4.296953229396388e-11,  3.269561771875669e-13,  7.049017776346213e-16, -2.641683924901851e-18, -2.497802123272213e-20,
 -6.240565719662329e-23,  2.160810414357428e-25,  2.307309431962321e-27,  1.733190640404096e+00, -1.716898535637738e-03, -6.737205106061209e-06, -1.501223367522620e-08,
  1.158180111689540e-11,  2.687900366906801e-13,  1.126106641005082e-15,  9.642066980636086e-19, -1.586666794738402e-20, -1.012021282499029e-22, -2.161469052289152e-25,
  9.329509728695861e-28,  1.793675889773195e+00, -1.389620825699152e-03, -6.031000245127730e-06, -1.755971714532006e-08, -1.809715638800923e-11,  1.517051478067940e-13,
  1.111110922403294e-15,  3.606682638644223e-18,  3.762338804760032e-22, -6.641977447496945e-23, -3.982966545359985e-25, -1.023739197867976e-27,  1.847714352620290e+00,
 -1.067396980633401e-03, -5.040867773740487e-06, -1.771363378864317e-08, -3.970697599961415e-11,  1.558026234364758e-14,  7.054297074164497e-16,  4.042745494970018e-18,
  1.267865004502670e-20,  5.354339196381508e-24, -2.093922037961825e-25, -1.468226648016118e-27,  1.894537340817159e+00, -7.647321479240964e-04, -3.871605838719026e-06,
 -1.561674923104845e-08, -4.896167723243518e-11, -9.321611916046642e-14,  1.377560093674419e-16,  2.407176716233012e-18,  1.371250190452986e-20,  5.000915606674475e-23,
  8.992952956200539e-26, -3.287452297674716e-28,  1.933443455665208e+00, -4.962223833962201e-04, -2.655593078168884e-06, -1.185905775730971e-08, -4.520005855805494e-11,
 -1.413436711284632e-13, -3.010282536934405e-16,  1.127822394582880e-19,  5.715737473464439e-21,  3.889410155620056e-23,  1.804915466714278e-25,  6.140039930350309e-28,
  1.963823704483864e+00, -2.755706217948081e-04, -1.538049745543620e-06, -7.388841607127424e-09, -3.185510070474772e-11, -1.240532846888258e-13, -4.286876374861140e-16,
 -1.237336981210319e-18, -2.363813624381646e-21,  2.481464934560819e-24,  5.786157077770330e-26,  3.945771742954170e-28,  1.985185722129333e+00, -1.145490809485155e-04,
 -6.580899444133284e-07, -3.318592192818986e-09, -1.543709574262753e-11, -6.754083655561084e-14, -2.799461591268765e-16, -1.099175516455506e-18, -4.060900414900982e-21,
 -1.388533473217304e-23, -4.231435453392383e-26, -1.034629372845148e-28,  1.997178321898946e+00, -2.200139215704792e-05, -1.284390499981149e-07, -6.649491147393307e-10,
 -3.218097993435113e-12, -1.489953023017735e-14, -6.679321846138871e-17, -2.919232241624496e-19, -1.249050594904982e-21, -5.245134042108890e-24, -2.164824716752303e-26,
 -8.787305396059958e-29,  6.092114160660059e-04, -3.383818075335736e-06,  1.409258124029268e-08, -5.215421327412025e-11,  1.808701101566866e-13, -6.018798669068964e-16,
  1.946009731605875e-18, -6.159555947074856e-21,  1.917581602159718e-23, -5.891435147393715e-26,  1.790045900631935e-28, -5.388890638968052e-31,  5.481117204183904e-03,
 -3.039246977693401e-05,  1.261121627947195e-07, -4.637724513598488e-10,  1.592776073752277e-12, -5.227072660144996e-15,  1.658364922770362e-17, -5.120321733077459e-20,
  1.544115076767574e-22, -4.557828941713365e-25,  1.317586217044949e-27, -3.730422817205956e-30,  1.521537389012919e-02, -8.407943314228269e-05,  3.463154844243866e-07,
 -1.257292525480422e-09,  4.232505514223800e-12, -1.349111464046266e-14,  4.109284154866357e-17, -1.199997483030319e-19,  3.355506972803948e-22, -8.937101799168592e-25,
  2.239614601181865e-27, -5.153629414964996e-30,  2.979271758838627e-02, -1.637828715083137e-04,  6.670786730275292e-07, -2.374400932253056e-09,  7.745625537411813e-12,
 -2.354507701958239e-14,  6.685873531445592e-17, -1.758822248899356e-19,  4.182129550376093e-22, -8.435551162972906e-25,  1.139665841039194e-27,  8.882436196692733e-31,
  4.918386508122018e-02, -2.685072187763981e-04,  1.077087725392804e-06, -3.730434500336402e-09,  1.163445181044980e-11, -3.291644695966241e-14,  8.314046386624158e-17,
 -1.775245908026705e-19,  2.623255223452541e-22,  9.888341971256057e-26, -2.862485828922819e-27,  1.497405391077494e-29,  7.334904301149260e-02, -3.969200362890695e-04,
  1.561491071098469e-06, -5.217771238105407e-09,  1.529774341294600e-11, -3.884616707686357e-14,  7.937998693282788e-17, -9.235045492548154e-20, -2.002672496604973e-22,
  1.914994358212318e-24, -8.590319637619168e-27,  2.905388508720300e-29,  1.022373502940214e-01, -5.473482213636274e-04,  2.102113657245610e-06, -6.710381367273469e-09,
  1.808173645182332e-11, -3.869754730656280e-14,  4.778022381473881e-17,  9.024138763415839e-20, -9.112326076942386e-22,  3.999575635411882e-24, -1.264573854368859e-26,
  2.863185672791434e-29,  1.357859454324682e-01, -7.177739416450827e-04,  2.677741685557859e-06, -8.069548883423298e-09,  1.934065582944951e-11, -3.040170122241997e-14,
 -1.424421840384212e-17,  3.491128671322230e-19, -1.665515955660322e-21,  5.240466465747026e-24, -1.062059066267361e-26,  1.288128214112366e-30,  1.739190485508737e-01,
 -9.058308037648735e-04,  3.264489325430139e-06, -9.150756119633653e-09,  1.850409219345607e-11, -1.289505630975416e-14, -1.021922397282236e-16,  6.282712185694142e-19,
 -2.141343441371939e-21,  4.382645017311325e-24,  4.921340259091391e-28, -5.174640188306650e-29,  2.165467462752885e-01, -1.108800927646933e-03,  3.836260736775334e-06,
 -9.811690298317362e-09,  1.514770922535311e-11,  1.350387925327111e-14, -2.036357428062643e-16,  8.428803288689738e-19, -1.985282595906369e-21,  6.145927449462971e-25,
  1.956266205906715e-26, -1.077071471398290e-28,  2.635635862506888e-01, -1.323613795890726e-03,  4.365322387933559e-06, -9.921277026265367e-09,  9.062653733604733e-12,
  4.683780613121776e-14, -2.988226550703066e-16,  8.954607929608532e-19, -9.412370038370965e-22, -5.801275124173075e-24,  3.968584007040108e-26, -1.256955032447762e-28,
  3.148469472236468e-01, -1.546847987691610e-03,  4.823001673624275e-06, -9.369565598708087e-09,  3.178082933065395e-13,  8.343618059503162e-14, -3.630057618486324e-16,
  7.012087036041464e-19,  1.006248330423372e-21, -1.312501852018325e-23,  4.913530174696245e-26, -6.542881498782414e-29,  3.702551705046301e-01, -1.774737194855115e-03,
  5.180527824048108e-06, -8.078179081562614e-09, -1.069226571258563e-11,  1.180820814831466e-13, -3.705577416639361e-16,  2.186504000574613e-19,  3.520850997127309e-21,
 -1.825652456980451e-23,  3.573434338606121e-26,  8.273047574289625e-29,  4.296254395798830e-01, -2.003182258110696e-03,  5.410029480825625e-06, -6.010893267925187e-09,
 -2.322204336937586e-11,  1.444672120392373e-13, -3.006065044912142e-16, -5.210873604385209e-19,  5.891071916611452e-21, -1.757553851016784e-23, -6.023943228984257e-27,
  2.709047232944748e-28,  4.927713971238241e-01, -2.227771356272864e-03,  5.485699326151070e-06, -3.183719627707149e-09, -3.618160378054275e-11,  1.559569647975144e-13,
 -1.435021168391604e-16, -1.395623737837605e-18,  7.144038104229133e-21, -8.471334648147363e-24, -6.777886405300441e-26,  3.915599330938014e-28,  5.594804932677817e-01,
 -2.443810923983746e-03,  5.385128779824299e-06,  3.263603970906067e-10, -4.818435191335402e-11,  1.466465598849753e-13,  9.305429997317357e-17, -2.193622198809131e-18,
  6.317769582409749e-21,  8.828466995433569e-24, -1.243993190622946e-25,  3.182063980196301e-28,  6.295110664860876e-01, -2.646370351053571e-03,  5.090803769637794e-06,
  4.375119545413196e-09, -5.764403266867411e-11,  1.126301873661795e-13,  3.798437153166525e-16, -2.646828948476213e-18,  2.859838444010974e-21,  2.990497084366188e-23,
 -1.398832666427849e-25, -1.256545635791332e-29,  7.025891698475236e-01, -2.830343997623335e-03,  4.591734468960761e-06,  8.748641003453235e-09, -6.292606170826659e-11,
  5.332884546789012e-14,  6.658320851931817e-16, -2.495195264657516e-18, -2.952341239452400e-21,  4.627092060966270e-23, -8.384782548748548e-26, -5.127880610112888e-28,
  7.784051718519567e-01, -2.990534491465309e-03,  3.885166130717241e-06,  1.316630850006969e-08, -6.255237757939920e-11, -2.736398945414675e-14,  8.835574611913766e-16,
 -1.578386486425577e-18, -9.746446435878701e-21,  4.778331460924387e-23,  4.558842992975995e-26, -9.152793673197351e-28,  8.566101840450471e-01, -3.121761571359535e-03,
  2.978283364664311e-06,  1.729095423434350e-08, -5.544981412385784e-11, -1.204405994446456e-13,  9.613015124216489e-16,  6.693767681306284e-20, -1.515679396893187e-20,
  2.734717815596794e-23,  2.043190708530494e-25, -8.732550900664339e-28,  9.368123986525084e-01, -3.219000775000830e-03,  1.889775723638661e-06,  2.074780125928124e-08,
 -4.121910578174161e-11, -2.120098874558655e-13,  8.415996764178599e-16,  2.139267117705303e-18, -1.645199148768776e-20, -1.351470816114604e-23,  3.065748927373672e-25,
 -1.939765615607610e-28,  1.018573460197179e+00, -3.277555858389671e-03,  6.510790987471277e-07,  2.315340023782236e-08, -2.038565491969525e-11, -2.847414362486186e-13,
  5.032264898901765e-16,  4.077737177418180e-18, -1.166864319452899e-20, -6.121713069017204e-23,  2.625808692274460e-25,  9.064631959604107e-28,  1.101405046819661e+00,
 -3.293267731269426e-03, -6.929513169721589e-07,  2.415480864734069e-08,  5.423745140592974e-12, -3.207106489610009e-13, -1.916290701379515e-17,  5.178420333439392e-18,
 -9.282756906454418e-22, -9.243168785680631e-23,  4.216348721568803e-26,  1.751725370603127e-27,  1.184765900506399e+00, -3.262760594774907e-03, -2.084237066925189e-06,
  2.347763255702130e-08,  3.344746817161164e-11, -3.055132434845002e-13, -6.261234666332582e-16,  4.827988058954758e-18,  1.271398247510809e-20, -8.418488481698645e-23,
 -2.713108697731172e-25,  1.554480452192809e-27,  1.268059619981074e+00, -3.183722528632627e-03, -3.452882132888401e-06,  2.097915519410995e-08,  5.997080565790947e-11,
 -2.330250719805948e-13, -1.164213925052850e-15,  2.803839766360478e-18,  2.367963745340839e-20, -2.916335694341448e-23, -4.903420639235621e-25,  9.113816270586475e-29,
  1.350633612681459e+00, -3.055212666312040e-03, -4.720131529075485e-06,  1.669969698335212e-08,  8.077713237269219e-11, -1.095922933264231e-13, -1.462078354140818e-15,
 -4.800190170772209e-19,  2.599968940329849e-20,  5.243232595277057e-23, -4.285578769479728e-25, -1.798474149334858e-27,  1.431779686559465e+00, -2.877980106029344e-03,
 -5.803162340169024e-06,  1.090199503449283e-08,  9.187499551880892e-11,  4.405555898459928e-14, -1.388648801120684e-15, -3.946458584297686e-18,  1.669548595007334e-20,
  1.161903039419876e-22, -6.061600821797255e-26, -2.561714246927829e-27,  1.510736837091207e+00, -2.654770906855308e-03, -6.621823854376654e-06,  4.085634773321609e-09,
  9.042528571116387e-11,  1.949417954553172e-13, -9.170683513629134e-16, -6.177400264463087e-18, -1.331229095255808e-21,  1.177550020882611e-22,  3.917509178522429e-25,
 -1.252816536644451e-27,  1.586696832567618e+00, -2.390589499717658e-03, -7.107152557294574e-06, -3.037169066254931e-09,  7.568403763588799e-11,  3.050551769768534e-13,
 -1.651933072404788e-16, -6.058392435505421e-18, -1.933016877118686e-20,  4.752974558648366e-23,  5.792841870901917e-25,  1.226640024653863e-27,  1.658813197866241e+00,
 -2.092870962324353e-03, -7.211059836541020e-06, -9.615064305654527e-09,  4.967136556033672e-11,  3.428938823181215e-13,  6.194198034353721e-16, -3.475054397524493e-18,
 -2.704380243171854e-20, -5.164748308127988e-23,  3.238029620538729e-25,  2.577950024907837e-27,  1.726214115048223e+00, -1.771513195310275e-03, -6.916057876657175e-06,
 -1.478244190508073e-08,  1.722974325334324e-11,  2.960797717496185e-13,  1.145437064633253e-15,  3.966008912240863e-19, -1.965439997187471e-20, -1.088856239407397e-22,
 -1.643908537396314e-25,  1.432170119535478e-27,  1.788019569294748e+00, -1.438716376334066e-03, -6.243349265342742e-06, -1.782351560453248e-08, -1.478820960605204e-11,
  1.795826943078646e-13,  1.211884702691444e-15,  3.577303445755957e-18, -2.312184607749590e-21, -8.321575603424985e-23, -4.404203476639833e-25, -8.747882986476383e-28,
  1.843362749368718e+00, -1.108584947689820e-03, -5.257229879042679e-06, -1.834549336887599e-08, -3.921666120257775e-11,  3.391490090563997e-14,  8.243233147455186e-16,
  4.449798921827424e-18,  1.270437346585496e-20, -4.390546108310500e-24, -2.797768137227303e-25, -1.732276881709861e-27,  1.891415260672625e+00, -7.964680565771076e-04,
 -4.063768026453241e-06, -1.641484718205241e-08, -5.078721529032790e-11, -8.904989159301529e-14,  2.115755759823985e-16,  2.875444391425152e-18,  1.557353877338170e-20,
  5.325513669755323e-23,  7.072941017453656e-26, -5.541064468845507e-28,  1.931415157710703e+00, -5.180488745956415e-04, -2.802335531378473e-06, -1.260526475986355e-08,
 -4.809881047985576e-11, -1.485084413609787e-13, -2.950889606183941e-16,  3.195360494154862e-19,  7.252536723690679e-21,  4.667007246943454e-23,  2.086845772067371e-25,
  6.657258560939231e-28,  1.962696239163185e+00, -2.882385409956271e-04, -1.629857652994445e-06, -7.918942684640429e-09, -3.444190147550490e-11, -1.347659813775753e-13,
 -4.643752418096948e-16, -1.311067289680844e-18, -2.228367881869239e-21,  5.172964820669479e-24,  7.749122287095170e-26,  5.014356293402150e-28,  1.984716738087173e+00,
 -1.199773969059402e-04, -6.994408006040183e-07, -3.576768042709854e-09, -1.685767037535638e-11, -7.464402534711137e-14, -3.126198854026907e-16, -1.237457942780967e-18,
 -4.592349257778735e-21, -1.567038592261773e-23, -4.696897263474128e-26, -1.076650842904430e-28,  1.997088209503047e+00, -2.306172066448808e-05, -1.367375004009793e-07,
 -7.189125684899348e-10, -3.532805157361937e-12, -1.660535088564209e-14, -7.555626689685783e-17, -3.350890351385683e-19, -1.454441056836057e-21, -6.193616502088081e-24,
 -2.591189070453842e-26, -1.065610830736708e-28,  5.958977296126725e-04, -3.273532529637537e-06,  1.348370503353813e-08, -4.935411210972047e-11,  1.692859354990892e-13,
 -5.571778158399097e-16,  1.781823676516778e-18, -5.578527639517911e-21,  1.717826888901491e-23, -5.220651888780959e-26,  1.569082319198544e-28, -4.673008011481864e-31,
  5.361530474299617e-03, -2.940540812418317e-05,  1.206964187547276e-07, -4.391032183267316e-10,  1.492101390072173e-12, -4.845725812980750e-15,  1.521673950329123e-17,
 -4.651472079809111e-20,  1.389137192584596e-22, -4.062213581974520e-25,  1.163858251509338e-27, -3.267891582654164e-30,  1.488450324975657e-02, -8.136812823055080e-05,
  3.316255610187847e-07, -1.191678551472691e-09,  3.972279490792293e-12, -1.254402212845094e-14,  3.787845929065274e-17, -1.097600482063553e-19,  3.049363040984691e-22,
 -8.085185437648437e-25,  2.023421877624291e-27, -4.679306240853663e-30,  2.914808183448999e-02, -1.585581417889889e-04,  6.393141800422182e-07, -2.254152599734521e-09,
  7.290378890251456e-12, -2.199807928534523e-14,  6.211689021154512e-17, -1.629764354563594e-19,  3.886731313976382e-22, -7.973839784220030e-25,  1.164324649911281e-27,
  2.606810687720506e-31,  4.812679049924091e-02, -2.600664625953339e-04,  1.033418040516286e-06, -3.549443160651510e-09,  1.099567887033274e-11, -3.097977299006932e-14,
  7.828768199554831e-17, -1.690940740008909e-19,  2.639759916885260e-22, -3.215677162765153e-27, -2.260924171278873e-27,  1.243915438862020e-29,  7.178595597018732e-02,
 -3.846744581315842e-04,  1.500321094007791e-06, -4.979120110139534e-09,  1.453965833672040e-11, -3.697273991961284e-14,  7.671435976986877e-17, -9.771985153405343e-20,
 -1.372141919930593e-22,  1.595878199288591e-24, -7.391336394136843e-27,  2.550478901988452e-29,  1.000810881044507e-01, -5.308485505904244e-04,  2.023299591188450e-06,
 -6.427202084714597e-09,  1.731944094980767e-11, -3.752366623373914e-14,  4.991971429702604e-17,  6.329051480885876e-20, -7.760528855968923e-22,  3.518533201417352e-24,
 -1.141707418738502e-26,  2.716621934831164e-29,  1.329570876128961e-01, -6.967341321638333e-04,  2.582743685451125e-06, -7.764978019402112e-09,  1.872996458446574e-11,
 -3.063211165456466e-14, -5.187431350099624e-18,  2.987530726700009e-19, -1.484479132993978e-21,  4.818205432569905e-24, -1.045963416337855e-26,  5.799709085332573e-30,
  1.703472687862306e-01, -8.801491127792212e-04,  3.156447718459237e-06, -8.856881268526265e-09,  1.822305045021179e-11, -1.514416821768795e-14, -8.553624620747912e-17,
  5.622721997721362e-19, -1.983728998964291e-21,  4.360455183215872e-24, -1.514674972691749e-27, -3.980486773321138e-29,  2.121721828896834e-01, -1.078577663870131e-03,
  3.719982707298857e-06, -9.567423975660579e-09,  1.537078888946273e-11,  8.892676053301031e-15, -1.809201496537392e-16,  7.798473158581896e-19, -1.950173186890058e-21,
  1.306814161256757e-24,  1.515783250916016e-26, -9.268689839714806e-29,  2.583382257790631e-01, -1.289164904338797e-03,  4.247166752242092e-06, -9.769161721101184e-09,
  9.929704954404214e-12,  3.996335143724241e-14, -2.742007013191660e-16,  8.622953488848367e-19, -1.122823899327442e-21, -4.322438763384432e-24,  3.430945274556064e-26,
 -1.183666010998567e-28,  3.087360114980841e-01, -1.508713503226500e-03,  4.710650948964282e-06, -9.351597501123327e-09,  1.901017864724247e-12,  7.496286385583408e-14,
 -3.429894809989771e-16,  7.262220716199991e-19,  5.683920051383841e-22, -1.122141405754045e-23,  4.595060083829295e-26, -7.839565192039715e-29,  3.632384923556498e-01,
 -1.733683456798283e-03,  5.082639592720978e-06, -8.230843104296656e-09, -8.418998784719753e-12,  1.092742963558278e-13, -3.629549889844617e-16,  3.210841504476292e-19,
  2.890114295460052e-21, -1.676608960961274e-23,  3.850948935083113e-26,  4.456848770746619e-29,  4.216988055602564e-01, -1.960196644516422e-03,  5.335763511396834e-06,
 -6.359727783791917e-09, -2.040591890858750e-11,  1.370982869595408e-13, -3.126530701617835e-16, -3.427206664535586e-19,  5.256750112819000e-21, -1.759320537621027e-23,
  4.771366186920516e-27,  2.202329366448396e-28,  4.839478273424516e-01, -2.184048185827266e-03,  5.444123546907092e-06, -3.737872125949934e-09, -3.309993802073654e-11,
  1.520695175865271e-13, -1.794284371036262e-16, -1.172384061915207e-18,  6.794344471751759e-21, -1.084647655878072e-23, -5.120417497876597e-26,  3.605875476900145e-28,
  5.497914182276713e-01, -2.400727111000682e-03,  5.384516530533042e-06, -4.210249099795347e-10, -4.523394362896838e-11,  1.481659111042796e-13,  3.450433340456794e-17,
 -1.987300772468418e-18,  6.549487714353519e-21,  4.141759761165793e-24, -1.097405023678557e-25,  3.450955790044408e-28,  6.190073485455774e-01, -2.605449420043555e-03,
  5.137847249055671e-06,  3.471306169496314e-09, -5.530621191239797e-11,  1.208683993410337e-13,  3.071678619001922e-16, -2.539167959415285e-18,  3.835851990572810e-21,
  2.432948143481474e-23, -1.381609110900278e-25,  8.768514133570578e-29,  6.913419024554743e-01, -2.793207216410139e-03,  4.690715203266107e-06,  7.751200949584333e-09,
 -6.170539293093111e-11,  6.846126920309918e-14,  5.948895284955555e-16, -2.563707138207444e-18, -1.352026022943041e-21,  4.250637991433813e-23, -1.033774850510946e-25,
 -3.753538815123027e-28,  7.665061731180178e-01, -2.958838228043140e-03,  4.037142433845415e-06,  1.216222873957579e-08, -6.289135871542538e-11, -6.722591274760476e-15,
  8.352568942530351e-16, -1.862475091053300e-18, -8.002925548151703e-21,  4.882415909102641e-23,  7.066955045370524e-27, -8.312237646476266e-28,  8.441720828821319e-01,
 -3.097120595914777e-03,  3.180376202456519e-06,  1.638573991301775e-08, -5.762804112576148e-11, -9.740071487269220e-14,  9.565443296634691e-16, -4.008270481891477e-19,
 -1.403466689642288e-20,  3.472788664650420e-23,  1.642200698495407e-25, -9.414264134420130e-28,  9.239681925530742e-01, -3.202898201376298e-03,  2.134655986045509e-06,
  2.005549072135035e-08, -4.525277680659790e-11, -1.911525573034624e-13,  8.940722772058087e-16,  1.607364535751257e-18, -1.672051770136723e-20, -1.495943615492041e-24,
  2.926033854140026e-25, -4.354513527847066e-28,  1.005475405294507e+00, -3.271241835640507e-03,  9.267771791967215e-07,  2.278236537224070e-08, -2.595068741404214e-11,
 -2.713380366256574e-13,  6.118591514540054e-16,  3.671179682859154e-18, -1.367454975017877e-20, -5.000005063403079e-23,  2.961558403446235e-25,  6.160435813532015e-28,
  1.088222725879076e+00, -3.297650923129615e-03, -4.027845491729603e-07,  2.419029907626512e-08, -9.833526195592017e-13, -3.194370254440504e-13,  1.249199417331074e-16,
  5.095949735591955e-18, -4.207101341730005e-21, -8.922874753136685e-23,  1.172120541393348e-25,  1.645930192604940e-27,  1.171683306859482e+00, -3.278298936689455e-03,
 -1.799498675285644e-06,  2.396314021680514e-08,  2.719810900076339e-11, -3.188749007427471e-13, -4.857136796849812e-16,  5.184389087365090e-18,  9.505192816661481e-21,
 -9.359074374182245e-23, -1.971823395234191e-25,  1.801326955730229e-27,  1.255271100717763e+00, -3.210322638109877e-03, -3.195533710790938e-06,  2.189991415746868e-08,
  5.503768990155486e-11, -2.599395955259810e-13, -1.075282666656363e-15,  3.541021115365248e-18,  2.227899230151757e-20, -4.855220192857566e-23, -4.755050319489765e-25,
  5.842685994342262e-28,  1.338338539871889e+00, -3.092150340692195e-03, -4.512059075668194e-06,  1.797268692700905e-08,  7.823379185852165e-11, -1.447478232500885e-13,
 -1.463611720191533e-15,  3.787141780518518e-19,  2.756044652981909e-20,  3.379975267839836e-23, -5.005728913661762e-25, -1.455690260383126e-27,  1.420175779442771e+00,
 -2.923857063972385e-03, -5.663495289101936e-06,  1.237719661933952e-08,  9.241420874563401e-11,  9.466191243553412e-15, -1.491045874058885e-15, -3.345969657857865e-18,
  2.080695883459413e-20,  1.114504221780576e-22, -1.776691486700467e-25, -2.738534534250003e-27,  1.500012149894188e+00, -2.707524503293505e-03, -6.563990782563678e-06,
  5.562375330590696e-09,  9.409000700057888e-11,  1.708557570736065e-13, -1.089973773729595e-15, -6.149266781351756e-18,  3.175118456453140e-21,  1.321456757052911e-22,
  3.233782479906994e-25, -1.856956745008598e-27,  1.577020558974864e+00, -2.447571456239982e-03, -7.136132440407082e-06, -1.777689959439230e-09,  8.173140040490389e-11,
  2.989867632566287e-13, -3.431985191661667e-16, -6.645010104683510e-18, -1.719008997088548e-20,  7.165944698020168e-23,  6.239414288398924e-25,  7.790822211262556e-28,
  1.650325626082037e+00, -2.151006927216959e-03, -7.321443325398056e-06, -8.764686575054405e-09,  5.666951019461410e-11,  3.564929258693052e-13,  5.097422668227105e-16,
 -4.367479563203327e-18, -2.864206186505009e-20, -3.636499637534539e-23,  4.416669805116048e-25,  2.762069638963700e-27,  1.719016289097177e+00, -1.827546069286026e-03,
 -7.091592866054043e-06, -1.445789714941656e-08,  2.342676024848653e-11,  3.236287847749507e-13,  1.147139142598205e-15, -2.961942038928792e-19, -2.367598168923620e-20,
 -1.140379836969957e-22, -8.907914270237243e-26,  2.001387790417078e-27,  1.782163450308330e+00, -1.489522438197716e-03, -6.458527384529177e-06, -1.802977956063810e-08,
 -1.089764547205623e-11,  2.098586488282096e-13,  1.310538318824187e-15,  3.451909804005875e-18, -5.633731592369498e-21, -1.015349055326100e-22, -4.736514343586540e-25,
 -6.154906904096794e-28,  1.838842884660223e+00, -1.151533978587735e-03, -5.481114615436251e-06, -1.896641546044679e-08, -3.833019693876866e-11,  5.523950486588086e-14,
  9.545691967782717e-16,  4.851496268098170e-18,  1.232579297782622e-20, -1.718417771933537e-23, -3.618248953289102e-25, -1.995584140100644e-27,  1.888163100951190e+00,
 -8.297800609992987e-04, -4.265679567254080e-06, -1.724138630455029e-08, -5.251061485345668e-11, -8.294782480441666e-14,  2.993567746942583e-16,  3.404966195457908e-18,
  1.753504651366179e-20,  5.551589811923846e-23,  4.018079756972529e-26, -8.464401590511616e-28,  1.929297148073015e+00, -5.410859226473280e-04, -2.958315446837841e-06,
 -1.339898833990115e-08, -5.113893361231500e-11, -1.554553756657025e-13, -2.826284147581002e-16,  5.801682817498997e-19,  9.090085044031696e-21,  5.561549976843840e-23,
  2.388551920985863e-25,  7.024087461259265e-28,  1.961516591936318e+00, -3.016670885066722e-04, -1.728282329267723e-06, -8.492193834491138e-09, -3.725168549379549e-11,
 -1.463593689986209e-13, -5.020509129687926e-16, -1.378751878363992e-18, -1.980698246019751e-21,  8.750713359224423e-24,  1.023558121701590e-25,  6.332645626347742e-28,
  1.984225358986027e+00, -1.257493096303229e-04, -7.440309719584795e-07, -3.858853555265832e-09, -1.842847429115593e-11, -8.257982885415483e-14, -3.494135274249655e-16,
 -1.393811164577085e-18, -5.191447742868290e-21, -1.764440930932881e-23, -5.173751651370912e-26, -1.083637105972907e-28,  1.996993718792327e+00, -2.419111529046361e-05,
 -1.457148881492376e-07, -7.781961198997359e-10, -3.883833742720658e-12, -1.853676387618719e-14, -8.562535048367722e-17, -3.854082607175247e-19, -1.697255636454654e-21,
 -7.330284384731059e-24, -3.108870928342226e-26, -1.295350201623499e-28,  5.830156517700531e-04, -3.167986673049913e-06,  1.290734678462806e-08, -4.673241410605146e-11,
  1.585576785767717e-13, -5.162280105345190e-16,  1.633046634287968e-18, -5.057721739389941e-21,  1.540702500994620e-23, -4.632264500072928e-26,  1.377329108260563e-28,
 -4.058421816104228e-31,  5.245807176074221e-03, -2.846051511579631e-05,  1.155672867761675e-07, -4.159855035402633e-10,  1.398735935733457e-12, -4.495663897220549e-15,
  1.397442466350326e-17, -4.229475413540411e-20,  1.250941981634425e-22, -3.624202934923799e-25,  1.029123876971784e-27, -2.865625520547569e-30,  1.456424767885586e-02,
 -7.877126260396536e-05,  3.176986353681720e-07, -1.130080755066398e-09,  3.730246529188351e-12, -1.167074217790211e-14,  3.493752277838399e-17, -1.004525671347161e-19,
  2.772380834365842e-22, -7.315679004473299e-25,  1.827300903983057e-27, -4.241223501780752e-30,  2.852390973469211e-02, -1.535498776088079e-04,  6.129499646890752e-07,
 -2.140946756337991e-09,  6.864962879779324e-12, -2.056065476297135e-14,  5.772342430864101e-17, -1.509891865595930e-19,  3.608070049031304e-22, -7.507312983034364e-25,
  1.164854832857894e-27, -2.141108500665711e-31,  4.710279374091067e-02, -2.519665471521861e-04,  9.918601874398658e-07, -3.378368567876929e-09,  1.039449387939043e-11,
 -2.915673039908646e-14,  7.367117332729434e-17, -1.606651181329481e-19,  2.623582333288581e-22, -8.336356900688273e-26, -1.762078155431678e-27,  1.029532865912839e-29,
  7.027089037198520e-02, -3.729069879110342e-04,  1.441943379357617e-06, -4.752302118173360e-09,  1.381839100980078e-11, -3.516487422327451e-14,  7.392497446899480e-17,
 -1.012464041916103e-19, -8.482272354850405e-23,  1.321703327874529e-24, -6.340676757193897e-27,  2.230960524612493e-29,  9.798958480419359e-02, -5.149660052833062e-04,
  1.947811279272201e-06, -6.156029167300413e-09,  1.658107788194603e-11, -3.630701973822566e-14,  5.136260432449567e-17,  4.039766683122186e-20, -6.573223392444035e-22,
  3.085267601693225e-24, -1.025864807099505e-26,  2.545961121676871e-29,  1.302108919757595e-01, -6.764398536658111e-04,  2.491341794256113e-06, -7.470203738746575e-09,
  1.811672786752110e-11, -3.066143945169780e-14,  2.538111670202211e-18,  2.539448414839668e-19, -1.318483540167423e-21,  4.405965410738198e-24, -1.012865237560339e-26,
  9.059547849098077e-30,  1.668765093420541e-01, -8.553177283804553e-04,  3.051904213943216e-06, -8.567841841872093e-09,  1.790087716190852e-11, -1.701514328483338e-14,
 -7.065783870837832e-17,  5.012895620506777e-19, -1.828236958257625e-21,  4.267923114777638e-24, -3.038920353649991e-27, -2.977752776098339e-29,  2.079166707516149e-01,
 -1.049272845687537e-03,  3.606654340265071e-06, -9.320297147263574e-09,  1.550695402256625e-11,  4.805616794183049e-15, -1.599502405968275e-16,  7.183037916345584e-19,
 -1.893158954952000e-21,  1.835734037201311e-24,  1.138918461154657e-26, -7.881839156036911e-29,  2.532487822636693e-01, -1.255653730742007e-03,  4.130915303103035e-06,
 -9.604241729060356e-09,  1.066509794089573e-11,  3.366807115016958e-14, -2.505810195749183e-16,  8.241300906141643e-19, -1.254961215697957e-21, -3.051697332069521e-24,
  2.929237422677112e-26, -1.094862921454214e-28,  3.027758180555495e-01, -1.471476544165776e-03,  4.598662322337712e-06, -9.309627469399746e-09,  3.319613821841725e-12,
  6.697682147686979e-14, -3.224588644438449e-16,  7.382949081985975e-19,  1.966495758155728e-22, -9.455017264880330e-24,  4.231245683489792e-26, -8.620739114716284e-29,
  3.563844522001003e-01, -1.693419547455300e-03,  4.983131848289087e-06, -8.348533253037809e-09, -6.319842153300759e-12,  1.006811645537668e-13, -3.527584607786815e-16,
  4.042110791474532e-19,  2.314645290704334e-21, -1.519619320461472e-23,  3.975719818827350e-26,  1.323819956908343e-29,  4.139429002945789e-01, -1.917821148043048e-03,
  5.257576965891007e-06, -6.664697388215053e-09, -1.773967143568544e-11,  1.294978840901594e-13, -3.199890710166009e-16, -1.845834161131940e-19,  4.629035535841996e-21,
 -1.722276080415016e-23,  1.340598656918295e-26,  1.728975407576835e-28,  4.752984440900023e-01, -2.140683388925280e-03,  5.396191065879233e-06, -4.243384709986592e-09,
 -3.010414406832727e-11,  1.473935082278268e-13, -2.092726672405871e-16, -9.615774969548025e-19,  6.370732465688562e-21, -1.258788829466655e-23, -3.613657971979503e-26,
  3.235365583917598e-28,  5.402746129776098e-01, -2.357683266172451e-03,  5.375219657607836e-06, -1.121034960162589e-09, -4.226672869148387e-11,  1.483500732167644e-13,
 -1.818936928144468e-17, -1.776148742041487e-18,  6.623276473260136e-21,  5.990109248981355e-26, -9.427982063822528e-26,  3.551108107250283e-28,  6.086679992484249e-01,
 -2.564194876441284e-03,  5.174274531940405e-06,  2.606122356342285e-09, -5.282080749119286e-11,  1.274019094108524e-13,  2.379137387935160e-16, -2.403464435350138e-18,
  4.613399110300459e-21,  1.890538972501007e-23, -1.324560248325281e-25,  1.683700539985996e-28,  6.802446905728843e-01, -2.755326112025740e-03,  4.777853527330845e-06,
  6.775619725079267e-09, -6.019922792081572e-11,  8.187370800560208e-14,  5.227242001496808e-16, -2.583316305805185e-18,  1.001513808543910e-22,  3.808037441212507e-23,
 -1.169618297988507e-25, -2.434945324993501e-28,  7.547363146592213e-01, -2.925974411274560e-03,  4.177050649843904e-06,  1.115596232991835e-08, -6.282971564516455e-11,
  1.267046827646756e-14,  7.797865007089827e-16, -2.090461200199737e-18, -6.248710284699601e-21,  4.840547630015372e-23, -2.722068417576026e-26, -7.242058645583733e-28,
  8.318357095197675e-01, -3.070906885574330e-03,  3.371412532844991e-06,  1.544934976074213e-08, -5.934765107907221e-11, -7.462787970841386e-14,  9.392301550623962e-16,
 -8.287470036899067e-19, -1.267629994807957e-20,  4.045872049789835e-23,  1.221681790897911e-25, -9.625658419927140e-28,  9.111922607101335e-01, -3.184870881594355e-03,
  2.370855263194152e-06,  1.930204196801389e-08, -4.885791749663848e-11, -1.692151795575654e-13,  9.315954652368926e-16,  1.073663913122294e-18, -1.656889152853937e-20,
  9.762241495620977e-24,  2.688289532134632e-25, -6.381196330587419e-28,  9.924069873444920e-01, -3.262741530336357e-03,  1.197497892369080e-06,  2.232457219162074e-08,
 -3.122253802083870e-11, -2.554709280347673e-13,  7.082719654022906e-16,  3.207128088164973e-18, -1.525559615728480e-20, -3.770068122585309e-23,  3.166002075560892e-25,
  3.125581330404273e-28,  1.075027515080367e+00, -3.299712816885595e-03, -1.128055310694999e-07,  2.412366660796308e-08, -7.330645816933306e-12, -3.147448529069298e-13,
  2.652461050599091e-16,  4.910970451727283e-18, -7.317924548995712e-21, -8.314060505351200e-23,  1.858568683715984e-25,  1.462404013755102e-27,  1.158543150132743e+00,
 -3.291537786033094e-03, -1.509542347052095e-06,  2.434670653944099e-08,  2.071596213372405e-11, -3.287588672701105e-13, -3.368089105080581e-16,  5.433283083210005e-18,
  6.013552099609792e-21, -9.983972216604177e-23, -1.141221174674665e-25,  1.958304299408055e-27,  1.242380366621717e+00, -3.234821145709799e-03, -2.927627129247405e-06,
  2.273755982995439e-08,  4.958927020980058e-11, -2.844777804734091e-13, -9.664416893861722e-16,  4.222370839271223e-18,  2.019625977740274e-20, -6.691413172978110e-23,
 -4.390647374138879e-25,  1.067989380818579e-27,  1.325899141224228e+00, -3.127363077124841e-03, -4.288978090188978e-06,  1.919936480669219e-08,  7.498894681231468e-11,
 -1.796466148104499e-13, -1.440505959984023e-15,  1.276134798864321e-18,  2.840252036539414e-20,  1.262155226188715e-23, -5.550416241777889e-25, -1.003548329664321e-27,
  1.408390711419127e+00, -2.968545782578707e-03, -5.506097299796104e-06,  1.385536377298521e-08,  9.223849727640503e-11, -2.736426519329240e-14, -1.574819489156825e-15,
 -2.617560384317246e-18,  2.466198789196627e-20,  1.019110860593860e-22, -2.995962468921825e-25, -2.779198774455077e-27,  1.489077487229991e+00, -2.759743592879350e-03,
 -6.488101636507002e-06,  7.093672760609221e-09,  9.723166020080215e-11,  1.426461948886816e-13, -1.259998797408483e-15, -5.969221064545444e-18,  8.143886139467228e-21,
  1.432693240480812e-22,  2.284608226699142e-25, -2.452588360834304e-27,  1.567115991906397e+00, -2.504723162706580e-03, -7.149422799360329e-06, -4.226615482937145e-10,
  8.761338664130228e-11,  2.884576734130686e-13, -5.365374584179916e-16, -7.148942887326614e-18, -1.415432674574229e-20,  9.713854483905404e-23,  6.456933965018089e-25,
  1.860967937526203e-28,  1.641603811644466e+00, -2.209983218695232e-03, -7.420941970961376e-06, -7.800314295876746e-09,  6.391126147943072e-11,  3.671546156242190e-13,
  3.744500834896337e-16, -5.301322548479671e-18, -2.960364281859268e-20, -1.624005110951113e-23,  5.650086300438243e-25,  2.820228201669078e-27,  1.711591550190638e+00,
 -1.884965917584952e-03, -7.262620233868391e-06, -1.402979691925478e-08,  3.017351894063451e-11,  3.509711771108787e-13,  1.127617838737346e-15, -1.120016244092462e-18,
 -2.782263257306797e-20, -1.156602225413660e-22,  1.248710986905453e-26,  2.621479590814418e-27,  1.776100650104184e+00, -1.542058720602893e-03, -6.675786781988281e-06,
 -1.816882311128448e-08, -6.378234462993626e-12,  2.424475292115337e-13,  1.404092027858938e-15,  3.209442836492323e-18, -9.635602619480307e-21, -1.209171985266876e-22,
 -4.925957805301740e-25, -2.214271928831160e-28,  1.834147594866825e+00, -1.196303616983207e-03, -5.712350681584817e-06, -1.956956855267987e-08, -3.698507949956616e-11,
  7.982316258596594e-14,  1.095819115270006e-15,  5.233054073903587e-18,  1.142481334870377e-20, -3.348690595104938e-23, -4.550767821737890e-25, -2.237497314520096e-27,
  1.884774399161850e+00, -8.647474903460850e-04, -4.477670611648056e-06, -1.809440385315830e-08, -5.408966769467900e-11, -7.455393098536009e-14,  4.028537410775977e-16,
  3.998296138002764e-18,  1.955264608979748e-20,  5.627526777460610e-23, -4.908962368105366e-27, -1.216851338582819e-27,  1.927084433060299e+00, -5.654097461089803e-04,
 -3.124116422345849e-06, -1.424244654633957e-08, -5.431437815259631e-11, -1.620087339057325e-13, -2.619968550786880e-16,  9.049903173628414e-19,  1.127172128421076e-20,
  6.579335256716453e-23,  2.701187126855719e-25,  7.133338330631265e-28,  1.960281611054902e+00, -3.159113316886150e-04, -1.833863571101187e-06, -9.112306226380160e-09,
 -4.030252777483616e-11, -1.588786930128229e-13, -5.414899971565282e-16, -1.436246460570977e-18, -1.584853597275074e-21,  1.344743162831903e-23,  1.336557649526510e-25,
  7.947641665334135e-28,  1.983710156733249e+00, -1.318919234704973e-04, -7.921623638489327e-07, -4.167391166256407e-09, -2.016719083968019e-11, -9.145344777241343e-14,
 -3.908644015937939e-16, -1.570509364702832e-18, -5.865038873491771e-21, -1.980833437647589e-23, -5.642390521668356e-26, -1.035364237641000e-28,  1.996894562220573e+00,
 -2.539527313216529e-05, -1.554386958710070e-07, -8.434187801729810e-10, -4.276025995487200e-12, -2.072765943965188e-14, -9.721860177638570e-17, -4.441943031892183e-19,
 -1.984974570345325e-21, -8.695728142215624e-24, -3.738952008979080e-26, -1.578453883615223e-28,  5.705467308317042e-04, -3.066928698027856e-06,  1.236144541080992e-08,
 -4.427600540425601e-11,  1.486138601688853e-13, -4.786800777214028e-16,  1.498089457968428e-18, -4.590349435918842e-21,  1.383442187983091e-23, -4.115433654775975e-26,
  1.210672642018218e-28, -3.529955145814911e-31,  5.133783105553211e-03, -2.755557038656668e-05,  1.107068301924006e-07, -3.943072068019032e-10,  1.312082882823635e-12,
 -4.174048179554637e-15,  1.284430757618201e-17, -3.849278922477699e-20,  1.127586266519144e-22, -3.236704935304430e-25,  9.109157522298469e-28, -2.515450261416859e-30,
  1.425416132986216e-02, -7.628292021842025e-05,  3.044882122902114e-07, -1.072219509397351e-09,  3.504993944243043e-12, -1.086501504029645e-14,  3.224519281091525e-17,
 -9.198858253617692e-20,  2.521734282424486e-22, -6.620871149714476e-25,  1.649670198409309e-27, -3.838662500123724e-30,  2.791935730728805e-02, -1.487472068359007e-04,
  5.879043099693618e-07, -2.034323197939354e-09,  6.467267600839003e-12, -1.922474491951895e-14,  5.365336963840163e-17, -1.398668162254239e-19,  3.346160710844574e-22,
 -7.044372856656870e-25,  1.147279489485780e-27, -5.668608075659590e-31,  4.611054449312241e-02, -2.441910437432026e-04,  9.522986996445164e-07, -3.216627187964582e-09,
  9.828680854000342e-12, -2.744166026959152e-14,  6.928954332565368e-17, -1.523304229255938e-19,  2.581925267326955e-22, -1.453417188334150e-25, -1.349996418578827e-27,
  8.486716737002278e-30,  6.880197757602460e-02, -3.615958456046132e-04,  1.386219420272872e-06, -4.536738812563325e-09,  1.313260448753913e-11, -3.342495808515978e-14,
  7.105888950250293e-17, -1.032465124363596e-19, -4.157803901773707e-23,  1.086843658478938e-24, -5.423122184152895e-27,  1.945129823275790e-29,  9.596042420023691e-02,
 -4.996745491457610e-04,  1.875506968014572e-06, -5.896473724401376e-09,  1.586734427545301e-11, -3.506302064542106e-14,  5.221540395463879e-17,  2.106342863862567e-20,
 -5.533738151366535e-22,  2.696791329557801e-24, -9.178570464455737e-27,  2.362040478031509e-29,  1.275444331897395e-01, -6.568628079134667e-04,  2.403418335840551e-06,
 -7.185236279851613e-09,  1.750466014417986e-11, -3.051982315676542e-14,  9.081178947829589e-18,  2.142138356610011e-19, -1.167058598656689e-21,  4.009519728698895e-24,
 -9.677270797180434e-27,  1.130915664350964e-29,  1.635034245790881e-01, -8.313089084771462e-04,  2.950797080352193e-06, -8.284237712880542e-09,  1.754471977274855e-11,
 -1.854896795695718e-14, -5.741786446480371e-17,  4.452184357374562e-19, -1.677071933914906e-21,  4.122728219663820e-24, -4.160234124481924e-27, -2.145518700633408e-29,
  2.037765834583604e-01, -1.020862761354099e-03,  3.496301956551144e-06, -9.071618843426852e-09,  1.556627230439610e-11,  1.201379474716968e-15, -1.406753459491659e-16,
  6.588614582851250e-19, -1.819673329462386e-21,  2.225742227820997e-24,  8.202928179200787e-27, -6.622828503564039e-29,  2.482915362234208e-01, -1.223064461922376e-03,
  4.016709435467424e-06, -9.428532265418293e-09,  1.128016519146811e-11,  2.792640279411546e-14, -2.280825569461141e-16,  7.824304367311341e-19, -1.344867128924213e-21,
 -1.973521014286736e-24,  2.468761507034436e-26, -9.972249294418142e-29,  2.969627843499106e-01, -1.435133105662815e-03,  4.487308337494505e-06, -9.246210805727099e-09,
  4.583436959055095e-12,  5.948628388578368e-14, -3.017473930807870e-16,  7.394607518115162e-19, -1.141929296974170e-22, -7.839722820367742e-24,  3.842590041275636e-26,
 -8.984142502366630e-29,  3.496898674025296e-01, -1.653956791195704e-03,  4.882407714785704e-06, -8.433997745889518e-09, -4.389922990998456e-12,  9.235865168154432e-14,
 -3.404836387809036e-16,  4.698343110352802e-19,  1.796276147302470e-21, -1.360204838269566e-23,  3.976821093661065e-26, -1.173718277876581e-29,  4.063552238609152e-01,
 -1.876085068862875e-03,  5.175981701651891e-06, -6.928231198865531e-09, -1.522684567517357e-11,  1.217722961066045e-13, -3.231759881404698e-16, -4.625699882539036e-20,
  4.020382962553263e-21, -1.654736453585632e-23,  2.005067645490580e-26,  1.299113025127302e-28,  4.668217158272157e-01, -2.097725508970121e-03,  5.342476823249782e-06,
 -4.701749690539842e-09, -2.720856295641994e-11,  1.420704827227579e-13, -2.334127057743353e-16, -7.652165101903671e-19,  5.894874385832571e-21, -1.376037656532515e-23,
 -2.278256240246978e-26,  2.831061315137248e-28,  5.309297822953601e-01, -2.314746589884067e-03,  5.357807421183558e-06, -1.773606804725304e-09, -3.930799728920830e-11,
  1.473406688719261e-13, -6.495899412350523e-17, -1.564866667166347e-18,  6.561316345839096e-21, -3.399054109185883e-24, -7.869741411757292e-26,  3.511106389426279e-28,
  5.984941861749952e-01, -2.522689758018138e-03,  5.200562231125638e-06,  1.781661408349949e-09, -5.022103231111709e-11,  1.323215498337180e-13,  1.727786527960293e-16,
 -2.245953041570063e-18,  5.200589258646223e-21,  1.377470613622311e-23, -1.236329653394807e-25,  2.295104506699592e-28,  6.693003237813189e-01, -2.716794299495744e-03,
  4.853438015638921e-06,  5.826188933229780e-09, -5.844215178626949e-11,  9.355269062301269e-14,  4.506357543067363e-16, -2.559098860096028e-18,  1.384585119186178e-21,
  3.322422395174177e-23, -1.249622228249205e-25, -1.222516772093599e-28,  7.431000735846380e-01, -2.892039583801548e-03,  4.304902146117386e-06,  1.015371070894515e-08,
 -6.239400866086441e-11,  3.066195513542921e-14,  7.187142863077515e-16, -2.262808766608507e-18, -4.533074050832042e-21,  4.671438163496827e-23, -5.644659881263002e-26,
 -6.024839175785884e-28,  8.196071757994969e-01, -3.043210264603825e-03,  3.551062044873548e-06,  1.448906294205521e-08, -6.061690410173107e-11, -5.240927499149163e-14,
  9.105714641480468e-16, -1.210223935284700e-18, -1.114200608942579e-20,  4.450180774376848e-23,  8.014319605952210e-26, -9.411095285919377e-28,  8.984921587326078e-01,
 -3.164991080096108e-03,  2.597681685115229e-06,  1.849446480807581e-08, -5.201651110214351e-11, -1.465556529151853e-13,  9.543024878893501e-16,  5.510998374327732e-19,
 -1.603111885110817e-20,  1.990420114582375e-23,  2.371263732039903e-25, -7.949499318783412e-28,  9.793768653632313e-01, -3.252098842430381e-03,  1.462229856948164e-06,
  2.178508934563804e-08, -3.615498764148685e-11, -2.374511361870201e-13,  7.910505639420036e-16,  2.699699136223904e-18, -1.638236514273435e-20, -2.485054467833780e-23,
  3.237262698385021e-25,  1.345133284130485e-29,  1.061828688880385e+00, -3.299459795007586e-03,  1.757682415461450e-07,  2.395640922082178e-08, -1.355089402539342e-11,
 -3.067580331774714e-13,  3.990358293440870e-16,  4.630464512219662e-18, -1.016228179068267e-20, -7.448832057416810e-23,  2.449471246192984e-25,  1.214129567619936e-27,
  1.145354703953572e+00, -3.302440350462601e-03, -1.215611397568254e-06,  2.462517338926296e-08,  1.407237152293787e-11, -3.349983013652648e-13, -1.825285424973720e-16,
  5.567498182995895e-18,  2.358154322770741e-21, -1.026570085435154e-22, -2.632449550134371e-26,  2.015610761479629e-27,  1.229395986521479e+00, -3.257137711979564e-03,
 -2.650207566001989e-06,  2.348425294965460e-08,  4.367771248073776e-11, -3.061829793320525e-13, -8.395531145584658e-16,  4.826819065520326e-18,  1.748378015345297e-20,
 -8.340243833951712e-23, -3.821181900638787e-25,  1.511328536274748e-27,  1.313322552838464e+00, -3.160733220541086e-03, -4.051511387426090e-06,  2.036858007796227e-08,
  7.105371936300891e-11, -2.136870083684637e-13, -1.392012553896053e-15,  2.187923257478518e-18,  2.844801327762369e-20, -1.030959485538434e-23, -5.875731976675506e-25,
 -4.627084343374392e-28,  1.396429519087458e+00, -3.011904469697319e-03, -5.331002815366992e-06,  1.532472461015379e-08,  9.130779361659866e-11, -6.594695409851922e-14,
 -1.636528936541039e-15, -1.772226950902302e-18,  2.808578899236256e-20,  8.750381473760505e-23, -4.199234168643100e-25, -2.663158424135095e-27,  1.477935279960451e+00,
 -2.811281256799580e-03, -6.393554653608323e-06,  8.670503441005713e-09,  9.976881882236319e-11,  1.104348371217143e-13, -1.422701849902214e-15, -5.624550923019845e-18,
  1.343855313508268e-20,  1.500842595111518e-22,  1.083264108573574e-25, -2.995459761315211e-27,  1.556982710583971e+00, -2.561914568445975e-03, -7.145895925173200e-06,
  1.024537285239663e-09,  9.323730716238900e-11,  2.731309571632508e-13, -7.424877113272463e-16, -7.540940870109266e-18, -1.019231780864139e-20,  1.229248955251992e-22,
  6.383177651109409e-25, -5.420767870161543e-28,  1.632644576155647e+00, -2.269707224697048e-03, -7.508166500232495e-06, -6.718553490622017e-09,  7.133164347442568e-11,
  3.742527482133121e-13,  2.126952290054873e-16, -6.253389657032897e-18, -2.975171779427662e-20,  8.823616174443953e-24,  6.873892096156537e-25,  2.711762758309060e-27,
  1.703934430633928e+00, -1.943731559541962e-03, -7.427844768644988e-06, -1.348940733598077e-08,  3.746049432297004e-11,  3.775532350621479e-13,  1.083168940720182e-15,
 -2.076627503315565e-18, -3.194789863888669e-20, -1.126655957211395e-22,  1.419103205796941e-25,  3.261427513265552e-27,  1.769824219854493e+00, -1.596338472683241e-03,
 -6.894258941718238e-06, -1.823022244782041e-08, -1.185220410267038e-12,  2.771851098720359e-13,  1.488958093339316e-15,  2.827642111274134e-18, -1.434429228671297e-20,
 -1.406656850893535e-22, -4.908143006709968e-25,  3.300131283657656e-28,  1.829269481470472e+00, -1.242951690802751e-03, -5.950678621943958e-06, -2.014707862414226e-08,
 -3.511354278651708e-11,  1.079211952950419e-13,  1.247255533285354e-15,  5.575650133315929e-18,  9.867337673126814e-21, -5.372019570683840e-23, -5.579877851836451e-25,
 -2.429118674551297e-27,  1.881242370380684e+00, -9.014522087286073e-04, -4.700043462806862e-06, -1.897120248421779e-08, -5.547461995113548e-11, -6.346944347471876e-14,
  5.238692664386463e-16,  4.656245192623151e-18,  2.156096163666993e-20,  5.487981659106597e-23, -6.820209294266787e-26, -1.675344020298148e-27,  1.924771704603041e+00,
 -5.911013368598903e-04, -3.300347968275149e-06, -1.513773026053217e-08, -5.761515934842675e-11, -1.679495585156992e-13, -2.312360996422349e-16,  1.305728833094387e-18,
  1.384229054904163e-20,  7.722066854444544e-23,  3.010340371888476e-25,  6.837698284902364e-28,  1.958987915575311e+00, -3.310308393952426e-04, -1.947187473269854e-06,
 -9.783287134681821e-09, -4.361334422096102e-11, -1.723622766273795e-13, -5.823343664981699e-16, -1.478112586934909e-18, -9.955895504856430e-22,  1.954811896491054e-23,
  1.728073610778999e-25,  9.910160210210627e-28,  1.983169589788079e+00, -1.384348850296293e-04, -8.441691602407103e-07, -4.505223799912650e-09, -2.209374162608090e-11,
 -1.013837672331500e-13, -4.375765602602970e-16, -1.770044536496408e-18, -6.619834460476340e-21, -2.215324114924484e-23, -6.072568184389743e-26, -9.032685965455609e-29,
  1.996790428324487e+00, -2.668046223086283e-05, -1.659843225087929e-07, -9.152827563405424e-10, -4.714957442743364e-12, -2.321763275759703e-14, -1.105945115638658e-16,
 -5.130250348680458e-19, -2.326702958933559e-21, -1.033997087851440e-23, -4.507712097012263e-26, -1.928151531696241e-28,  5.584734903139298e-04, -2.970122675146082e-06,
  1.184409055833844e-08, -4.197286176266010e-11,  1.393896420196625e-13, -4.442195991500557e-16,  1.375541259224079e-18, -4.170447733542417e-21,  1.243641838584079e-23,
 -3.660839306094236e-26,  1.065612671079701e-28, -3.074831986307081e-31,  5.025302661552231e-03, -2.668849184193609e-05,  1.060984020661739e-07, -3.739653386595597e-10,
  1.231599313848733e-12, -3.878321160123300e-15,  1.181532254851785e-17, -3.506412597858010e-20,  1.017365253988493e-22, -2.893546025698418e-25,  8.071003268046890e-28,
 -2.210338669927325e-30,  1.395382129618549e-02, -7.389754394412047e-05,  2.919510205359371e-07, -1.017836820568039e-09,  3.295228480398255e-12, -1.012114829385020e-14,
  2.977899189755647e-17, -8.428798324556202e-20,  2.294863631326570e-22, -5.993674791911221e-25,  1.488994380318881e-27, -3.470288280491545e-30,  2.733362278580992e-02,
 -1.441398895464437e-04,  5.641008239974959e-07, -1.933854221579343e-09,  6.095338448241308e-12, -1.798287244378106e-14,  4.988325720826759e-17, -1.295560546227541e-19,
  3.100756048907260e-22, -6.591265062635475e-25,  1.116399265970540e-27, -8.225897840967510e-31,  4.514877635362875e-02, -2.367244199813109e-04,  9.146249040120523e-07,
 -3.063670039833302e-09,  9.296136456893270e-12, -2.582896581740026e-14,  6.513910493312711e-17, -1.441616988195056e-19,  2.520739308860581e-22, -1.923405548260364e-25,
 -1.011026918417781e-27,  6.964551528117550e-30,  6.737743388886965e-02, -3.507203318458272e-04,  1.333017521542151e-06, -4.331873458427490e-09,  1.248092466731014e-11,
 -3.175435121493729e-14,  6.815495316868952e-17, -1.039912267358046e-19, -6.157109695673586e-24,  8.862653284188569e-25, -4.624313459804587e-27,  1.690823753616480e-29,
  9.399129200649124e-02, -4.849492610753419e-04,  1.806249627800136e-06, -5.648138044762729e-09,  1.517865336150236e-11, -3.380468741577165e-14,  5.257136994470366e-17,
  4.839959485231640e-21, -4.626524768637418e-22,  2.349879502657618e-24, -8.180795504332384e-27,  2.173009798177867e-29,  1.249548972342385e-01, -6.379756376039893e-04,
  2.318855848524824e-06, -6.910031082318891e-09,  1.689690774729966e-11, -3.023398837081263e-14,  1.457749676216659e-17,  1.791037382549959e-19, -1.029559159548415e-21,
  3.632858281578030e-24, -9.145300468085022e-27,  1.275368870262121e-29,  1.602247787958116e-01, -8.080954317410384e-04,  2.853058047366088e-06, -8.006560773164363e-09,
  1.716093911805543e-11, -1.978333165497920e-14, -4.568100332630576e-17,  3.938929900975681e-19, -1.531857196706039e-21,  3.939548801399759e-24, -4.949053594842941e-27,
 -1.463053498507465e-29,  1.997483897796090e-01, -9.933235487151492e-04,  3.388937108124476e-06, -8.822543551541961e-09,  1.555799842457376e-11, -1.959955152988079e-15,
 -1.230299735606737e-16,  6.019717720678515e-19, -1.734311548482401e-21,  2.498990292121021e-24,  5.541510132530940e-27, -5.496470197308747e-29,  2.434628335434051e-01,
 -1.191380247230005e-03,  3.904667432286170e-06, -9.243871457091404e-09,  1.178570259860350e-11,  2.271039597215129e-14, -2.067863759186550e-16,  7.384401237686475e-19,
 -1.399169254984594e-21, -1.070803488613566e-24,  2.052204216473770e-26, -8.959868331031183e-29,  2.912933480247107e-01, -1.399677122489025e-03,  4.376831823350114e-06,
 -9.163744458560762e-09,  5.702417156762649e-12,  5.249214197622439e-14, -2.811340089827530e-16,  7.315797906863628e-19, -3.697122070504019e-22, -6.382059041620482e-24,
  3.445487988316715e-26, -9.018458497071568e-29,  3.431515162731049e-01, -1.615303417905040e-03,  4.780837840225326e-06, -8.489898536147187e-09, -2.623368757785388e-12,
  8.435096249975463e-14, -3.265949794815318e-16,  5.197859981788517e-19,  1.335055210271272e-21, -1.202770407191005e-23,  3.880898558038761e-26, -3.097280879728828e-29,
  3.989331671405916e-01, -1.835013729694434e-03,  5.091460154111861e-06, -7.152798769589118e-09, -1.286899408290252e-11,  1.140145231109008e-13, -3.227584419776984e-16,
  7.302924636520595e-20,  3.440385908661214e-21, -1.564258499630996e-23,  2.491115883810060e-26,  9.186356485828153e-29,  4.585159259216186e-01, -2.055218565163362e-03,
  5.283536566508279e-06, -5.114666698058444e-09, -2.442479966233957e-11,  1.362323174790129e-13, -2.522734519131645e-16, -5.846587535145229e-19,  5.385988250051329e-21,
 -1.443476368369148e-23, -1.123971942939253e-26,  2.415428808095442e-28,  5.217563712606640e-01, -2.271979732081238e-03,  5.332847502560418e-06, -2.379059433194488e-09,
 -3.638020112658447e-11,  1.452794494899234e-13, -1.058583442579517e-16, -1.357439934786507e-18,  6.385978718269203e-21, -6.241709593859511e-24, -6.354565068646066e-26,
  3.360126419263136e-28,  5.884867525268997e-01, -2.481013198054543e-03,  5.217208953368751e-06,  9.995006051022817e-10, -4.753812924892896e-11,  1.357328271928038e-13,
  1.122896942023281e-16, -2.072533795478921e-18,  5.610024920225165e-21,  9.045185737146626e-24, -1.125331644979489e-25,  2.720854951527238e-28,  6.585112221323005e-01,
 -2.677702888669787e-03,  4.917805418207192e-06,  4.906646305440264e-09, -5.646871899040958e-11,  1.035141686252842e-13,  3.797741607255304e-16, -2.496628239316976e-18,
  2.489687029199791e-21,  2.815077673808286e-23, -1.279304929419788e-25, -1.524209822998699e-29,  7.316015414754692e-01, -2.857129907101894e-03,  4.420780063005825e-06,
  9.161227869516680e-09, -6.161348836055321e-11,  4.713593975042967e-14,  6.535742457795835e-16, -2.381445027661800e-18, -2.898044740471939e-21,  4.396393885217875e-23,
 -8.013791085984247e-26, -4.738583660904925e-28,  8.074922295303083e-01, -3.014122853029348e-03,  3.719080800333324e-06,  1.351198215059106e-08, -6.144949910402150e-11,
 -3.100098415057263e-14,  8.719383649764732e-16, -1.540596552260268e-18, -9.492088804960358e-21,  4.689396520843382e-23,  3.988612031444272e-26, -8.833659735535954e-28,
  8.858751426406839e-01, -3.143336255453317e-03,  2.814528993833501e-06,  1.764000034907733e-08, -5.471763821609187e-11, -1.235244663789896e-13,  9.626717079944910e-16,
  5.132887303311760e-20, -1.515259374634108e-20,  2.865444185012807e-23,  1.996030710548639e-25, -9.023968375199968e-28,  9.663935069872364e-01, -3.239365507543554e-03,
  1.720026741567568e-06,  2.116967351717484e-08, -4.070834464845492e-11, -2.176187997175989e-13,  8.591861486879155e-16,  2.163644797801897e-18, -1.704452759441886e-20,
 -1.197368830633098e-23,  3.180842289668833e-25, -2.653723932830125e-28,  1.048635476865555e+00, -3.296907889951310e-03,  4.617436103832884e-07,  2.369107736368494e-08,
 -1.957998436929201e-11, -2.956644916844735e-13,  5.237470653161048e-16,  4.264356717634700e-18, -1.265538731807528e-20, -6.370633878142811e-23,  2.919922737566405e-25,
  9.179119126447481e-28,  1.132127369013366e+00, -3.310979916115595e-03, -9.189800940148124e-07,  2.479654670041770e-08,  7.341255297217439e-12, -3.375031976655914e-13,
 -2.613816498231767e-17,  5.583798719734334e-18, -1.335118727158779e-21, -1.019421591125846e-22,  6.173766792301206e-26,  1.970469164831805e-27,  1.216326833305703e+00,
 -3.277200720306397e-03, -2.364408969032960e-06,  2.413305934759569e-08,  3.736382196302554e-11, -3.246500979410551e-13, -6.970410648401450e-16,  5.335447395511272e-18,
  1.422325955781488e-20, -9.724122205323069e-23, -3.070959529117583e-25,  1.885076478410190e-27,  1.300616370627866e+00, -3.192148629671562e-03, -3.800414121363609e-06,
  2.146945715581389e-08,  6.645138798061077e-11, -2.462578053408704e-13, -1.318094308330921e-15,  3.087755785421457e-18,  2.765048227814270e-20, -3.404619438557500e-23,
 -5.948807498342622e-25,  1.375417464541155e-28,  1.384297804755170e+00, -3.053792183899362e-03, -5.138391051167622e-06,  1.677294875327309e-08,  8.959260495786493e-11,
 -1.057147693962856e-13, -1.673119707700536e-15, -8.265464943079750e-19,  3.090596732673991e-20,  6.843443852887275e-23, -5.314815175455575e-25, -2.379813664428818e-27,
  1.466588555534092e+00, -2.861986217198801e-03, -6.279864072270626e-06,  1.028256630560225e-08,  1.016235830521654e-10,  7.445375318245797e-14, -1.573352120727813e-15,
 -5.107498697199056e-18,  1.888653621829121e-20,  1.516422396550903e-22, -3.365210114982097e-26, -3.437437842086494e-27,  1.546620832182337e+00, -2.619006789000342e-03,
 -7.124473763732498e-06,  2.558994550264758e-09,  9.850445391574846e-11,  2.527449042758036e-13, -9.575001514575738e-16, -7.791423365055261e-18, -5.315353356269306e-21,
  1.477405848688014e-22,  5.963535456685411e-25, -1.380770215324213e-27,  1.623445134126044e+00, -2.330075074696705e-03, -7.581693566418426e-06, -5.517150862868896e-09,
  7.885300856067706e-11,  3.771492015095673e-13,  2.435846757675061e-17, -7.194826449570208e-18, -2.891105721627419e-20,  3.862939842122609e-23,  8.006230856829761e-25,
  2.398662554172824e-27,  1.696039648837381e+00, -2.003791037038026e-03, -7.585867747905399e-06, -1.282824035235549e-08,  4.526619699869239e-11,  4.027323178125788e-13,
  1.010110457005288e-15, -3.162468290982820e-18, -3.586541321967411e-20, -1.039344135171823e-22,  2.991378573805172e-25,  3.876848442908118e-27,  1.763327172440189e+00,
 -1.652367483208971e-03, -7.112946089547219e-06, -1.820286883072742e-08,  4.721956409467395e-12,  3.138135092468984e-13,  1.560917754373387e-15,  2.283852399109590e-18,
 -1.975633989701589e-20, -1.598071938461280e-22, -4.609724493190362e-25,  1.056283710554269e-27,  1.824200919417643e+00, -1.291533555562883e-03, -6.195737822618862e-06,
 -2.068994779858330e-08, -3.264295573794842e-11,  1.397624806514823e-13,  1.407471635954744e-15,  5.855942948666442e-18,  7.505539499373423e-21, -7.821557850189263e-23,
 -6.675367384415159e-25, -2.532059294751373e-27,  1.877559897615395e+00, -9.399783550564147e-04, -4.933063008596233e-06, -1.986822263557974e-08, -5.660730923527029e-11,
 -4.925231529912475e-14,  6.641958182280211e-16,  5.377126835245712e-18,  2.346835698563430e-20,  5.052151303527462e-23, -1.537457564900737e-25, -2.229062687050640e-27,
  1.922353320757429e+00, -6.182466601588127e-04, -3.487643573942997e-06, -1.608673290655774e-08, -6.102641589754164e-11, -1.730077931043239e-13, -1.880395238094573e-16,
  1.795542887187171e-18,  1.684604485546250e-20,  8.984247457912632e-23,  3.294050955852966e-25,  5.939545333357966e-28,  1.957631876589097e+00, -3.470900667877856e-04,
 -2.068890057399617e-06, -1.050945209807941e-08, -4.720371802633992e-11, -1.868378471757816e-13, -6.240517241301200e-16, -1.497288453056696e-18, -1.563275445313611e-22,
  2.739895839309622e-23,  2.214544184105615e-25,  1.227223845316455e-27,  1.982601992452444e+00, -1.454106564475897e-04, -9.004216537455786e-07, -4.875532959609084e-09,
 -2.423057670638686e-11, -1.125050308171117e-13, -4.902267720459280e-16, -1.995115714422949e-18, -7.461974353846425e-21, -2.465528724991708e-23, -6.419087905947628e-26,
 -6.473683004631915e-29,  1.996680979306632e+00, -2.805358910429852e-05, -1.774361560072730e-07, -9.945861518033704e-10, -5.207061309096631e-12, -2.605304761908259e-14,
 -1.260601160212218e-16, -5.938006528798110e-19, -2.733550840741748e-21, -1.232480774966605e-23, -5.447983622866077e-26, -2.361135376429520e-28,  5.467793677746347e-04,
 -2.877347397815437e-06,  1.135351014160374e-08, -3.981194782931778e-11,  1.308261487127516e-13, -4.125640982498820e-16,  1.264147828932013e-18, -3.792771864814214e-21,
  1.119208959624268e-23, -3.260455235910341e-26,  9.391657239791927e-29, -2.682278905625118e-31,  4.920218312537893e-03, -2.585732576322856e-05,  1.017265408559255e-07,
 -3.548652011560190e-10,  1.156790903824628e-12, -3.606176492956566e-15,  1.087758234252894e-17, -3.196917993510362e-20,  9.187817548966098e-23, -2.589347234585099e-25,
  7.158310629563605e-28, -1.944246881251127e-30,  1.366282622653719e-02, -7.160991078085538e-05,  2.800467642947178e-07, -9.666945045467375e-10,  3.099765512940744e-12,
 -9.433962961657955e-15,  2.751857473499744e-17, -7.727845282423790e-20,  2.089453361115421e-22, -5.427603950479644e-25,  1.343806202403454e-27, -3.134370050904336e-30,
  2.676594417298453e-02, -1.397182769424391e-04,  5.414680645185821e-07, -1.839142231710226e-09,  5.747364850733393e-12, -1.682810549061690e-14,  4.639109537616706e-17,
 -1.200047478763971e-19,  2.871416013551124e-22, -6.152520703198646e-25,  1.076020436262046e-27, -1.001628124185803e-30,  4.421628335188676e-02, -2.295519870769271e-04,
  8.787365169534128e-07, -2.918980905765974e-09,  8.794868249634128e-12, -2.431316079314323e-14,  6.121441324737922e-17, -1.362133507409967e-19,  2.444919794103804e-22,
 -2.270454037889638e-25, -7.335200015331552e-28,  5.686467850114297e-30,  6.599555634920888e-02, -3.402607744821056e-04,  1.282212536118618e-06, -4.137171475917723e-09,
  1.186195898517274e-11, -3.015356741553216e-14,  6.524499060563151e-17, -1.037120512071646e-19,  2.259197513387807e-23,  7.154889344982902e-25, -3.930905219342185e-27,
  1.465625820852935e-29,  9.207997145916275e-02, -4.707662970230054e-04,  1.739907033009043e-06, -5.410619770941469e-09,  1.451517939657593e-11, -3.254294530794968e-14,
  5.251189844567822e-17, -8.672708061753451e-21, -3.837216281926273e-22,  2.041214092656686e-24, -7.266183227511847e-27,  1.984863598996144e-29,  1.224395776430259e-01,
 -6.197519221727982e-04,  2.237537690324696e-06, -6.644497347834028e-09,  1.629611404967854e-11, -2.982755413165693e-14,  1.915032304624461e-17,  1.481808849805441e-19,
 -9.052230170584290e-22,  3.278549131733724e-24, -8.564261023846248e-27,  1.356548025208719e-29,  1.570374440486761e-01, -7.856506449432371e-04,  2.758613528297677e-06,
 -7.735206996499242e-09,  1.675517431713316e-11, -2.075273723582518e-14, -3.531722996347467e-17,  3.471033783745469e-19, -1.393736134662744e-21,  3.730425859362652e-24,
 -5.466873011840059e-27, -9.105330015158916e-30,  1.958286540342333e-01, -9.666313061585007e-04,  3.284558355494957e-06, -8.574083981636203e-09,  1.549060534697459e-11,
 -4.716598731416330e-15, -1.069379324745925e-16,  5.479514535970332e-19, -1.640913172534635e-21,  2.675303706067815e-24,  3.346600024899502e-27, -4.501795406790447e-29,
  2.387590892682277e-01, -1.160583375088111e-03,  3.794886536634526e-06, -9.051929263068820e-09,  1.219193029122462e-11,  1.799054929307006e-14, -1.867415897188163e-16,
  6.932008224696235e-19, -1.423865237693821e-21, -3.257860988064854e-25,  1.680231896473920e-26, -7.951290766114776e-29,  2.857639746913135e-01, -1.365100699138010e-03,
  4.267447798164290e-06, -9.064466702123380e-09,  6.686439281065059e-12,  4.598919671623884e-14, -2.608480940528273e-16,  7.163311896196650e-19, -5.756110602351696e-22,
 -5.082746679460669e-24,  3.052658599677993e-26, -8.801939876411732e-29,  3.367661499328503e-01, -1.577464818397822e-03,  4.678761520207652e-06, -8.518797131928176e-09,
 -1.013530137709789e-12,  7.669176919809174e-14, -3.115058414962464e-16,  5.558764699811132e-19,  9.296301460174515e-22, -1.050711815977080e-23,  3.711707914113061e-26,
 -4.515778734253066e-29,  3.916740272549253e-01, -1.794628712596867e-03,  5.004465034122452e-06, -7.340880315764742e-09, -1.066593790490285e-11,  1.063047854908511e-13,
 -3.192555739625924e-16,  1.743110778768193e-19,  2.896070809713869e-21, -1.457535033940733e-23,  2.821121022026244e-26,  5.899845124795840e-29,  4.503791904225224e-01,
 -2.013202215268680e-03,  5.219904618712340e-06, -5.484000508176688e-09, -2.176192634115560e-11,  1.300003022664691e-13, -2.663095970284330e-16, -4.206882641082500e-19,
  4.860694792292092e-21, -1.468393428422186e-23, -1.516910160995082e-27,  2.006353160270248e-28,  5.127535834038000e-01, -2.229440822462804e-03,  5.300901693029177e-06,
 -2.938048488789846e-09, -3.350297841465331e-11,  1.423056166546367e-13, -1.410428559670300e-16, -1.157145865508653e-18,  6.119030297808355e-21, -8.494217953198633e-24,
 -4.925040682534923e-26,  3.126249943642557e-28,  5.786462330584291e-01, -2.439240273600950e-03,  5.224729305175325e-06,  2.607348532285253e-10, -4.480111767940486e-11,
  1.377519647575583e-13,  5.681493614749904e-17, -1.888647765777430e-18,  5.857594401515956e-21,  4.792013658009834e-24, -9.993855488133862e-26,  2.977792318203217e-28,
  6.478794468967961e-01, -2.638140125351353e-03,  4.971334035839827e-06,  4.020180699793100e-09, -5.431290179986287e-11,  1.117997851991598e-13,  3.111292612776945e-16,
 -2.401730649058065e-18,  3.411099562711697e-21,  2.304803550524127e-23, -1.265470927259993e-25,  7.528806589950466e-29,  7.202444270231055e-01, -2.821340609458494e-03,
  4.524833710615677e-06,  8.183783225536291e-09, -6.051936090045174e-11,  6.201251612016335e-14,  5.858287580158897e-16, -2.449516396093805e-18, -1.377720149765342e-21,
  4.037949231005135e-23, -9.814714270386031e-26, -3.452633123729432e-28,  7.954962466721197e-01, -2.983738385556896e-03,  3.875308615127797e-06,  1.252495175116420e-08,
 -6.186391838710837e-11, -1.062485819338678e-14,  8.248047575913427e-16, -1.817099196295166e-18, -7.784343289363757e-21,  4.773569709764186e-23,  2.831620176270178e-27,
 -7.968386243863240e-28,  8.733481494739543e-01, -3.119988366286456e-03,  3.020878643921020e-06,  1.674600906252245e-08, -5.695724885242093e-11, -1.004568843589655e-13,
  9.574861621313913e-16, -4.155871962735926e-19, -1.398708226660867e-20,  3.582388546450093e-23,  1.584480678457226e-25, -9.602502371613810e-28,  9.534651582212906e-01,
 -3.224600545355740e-03,  1.970014877083909e-06,  2.048466085838843e-08, -4.484992872133950e-11, -1.963332916575718e-13,  9.120848057502297e-16,  1.613751300266995e-18,
 -1.725006148543212e-20,  4.411528247728867e-25,  3.008707310879161e-25, -5.105800211268670e-28,  1.035457025620001e+00, -3.292082539885263e-03,  7.439640428760570e-07,
  2.333121400831415e-08, -2.535814854316828e-11, -2.817095368229662e-13,  6.371511624703565e-16,  3.825017041967561e-18, -1.472970285579610e-20, -5.131313269341255e-23,
  3.252985874582675e-25,  5.929073403900982e-28,  1.118870632347676e+00, -3.317140038767547e-03, -6.209394906770286e-07,  2.486002521705886e-08,  5.975429748446540e-13,
 -3.362625548448937e-13,  1.290627257299081e-16,  5.483000457162303e-18, -4.939999813133508e-21, -9.777396057469098e-23,  1.456281720032125e-25,  1.827294888736179e-27,
  1.203182047683466e+00, -3.294947941368096e-03, -2.071442402398349e-06,  2.467807921832815e-08,  3.071588272597861e-11, -3.395382571385957e-13, -5.418187225830116e-16,
  5.732377729073652e-18,  1.052228639537890e-20, -1.077764172068301e-22, -2.176276903789640e-25,  2.164339596028491e-27,  1.287788626171934e+00, -3.221503719247030e-03,
 -3.536569315415496e-06,  2.249159049782389e-08,  6.121740359986182e-11, -2.767558948623623e-13, -1.219466608170501e-15,  3.948390917547459e-18,  2.599963029170559e-20,
 -5.753719994765590e-23, -5.751226313088859e-25,  7.611877544569241e-28,  1.372001730680674e+00, -3.094070016471920e-03, -4.928591631657201e-06,  1.818732849096618e-08,
  8.707547291307548e-11, -1.460334812597463e-13, -1.682077174005500e-15,  1.975618256249153e-19,  3.296278071166330e-20,  4.520139780763599e-23, -6.268990383830286e-25,
 -1.930885161938706e-27,  1.455040953470762e+00, -2.911703825375628e-03, -6.146675048750437e-06,  1.191835725352515e-08,  1.027238440988319e-10,  3.505050393659287e-14,
 -1.707083824347739e-15, -4.416345373821528e-18,  2.428405750834359e-20,  1.471725838845637e-22, -1.919702144890881e-25, -3.730499609408045e-27,  1.536031046251244e+00,
 -2.675852578469446e-03, -7.084146837759590e-06,  4.174181961785547e-09,  1.033118031270008e-10,  2.271328378814007e-13, -1.177209654130546e-15, -7.871946812938875e-18,
  4.156426058004154e-22,  1.701155282598645e-22,  5.157672744813208e-25, -2.289678113390714e-27,  1.614003138461927e+00, -2.390971425325621e-03, -7.640080658227027e-06,
 -4.195197447135174e-09,  8.638498674045469e-11,  3.752133115702745e-13, -1.897945424650746e-16, -8.091350747416863e-18, -2.691978996983471e-20,  7.262165807705725e-23,
  8.949995580020180e-25,  1.850507159379316e-27,  1.687902154058877e+00, -2.065080801600918e-03, -7.735191095159265e-06, -1.203825932884766e-08,  5.355541279058604e-11,
  4.257793238386519e-13,  9.049495931962361e-16, -4.367374711798235e-18, -3.934904644366507e-20, -8.839222187699452e-23,  4.818600009945205e-25,  4.409576767792323e-27,
  1.756602514410786e+00, -1.710143014933967e-03, -7.330713441305431e-06, -1.807505154224570e-08,  1.137763441315084e-11,  3.519660302993729e-13,  1.615125132557914e-15,
  1.556147744101736e-18, -2.582780639634562e-20, -1.770622695661086e-22, -3.951600049579368e-25,  1.965290387138818e-27,  1.818934068714746e+00, -1.342101229880419e-03,
 -6.447052578131517e-06, -2.118798154878725e-08, -2.949650311917354e-11,  1.755337453640079e-13,  1.574339212268289e-15,  6.045696418705520e-18,  4.182266637287287e-21,
 -1.071469758318482e-22, -7.787897534309534e-25, -2.497708966408100e-27,  1.873719523373609e+00, -9.804119999758379e-04, -5.176945539283526e-06, -2.078090110437348e-08,
 -5.742030768357701e-11, -3.141840630409169e-14,  8.255329892146465e-16,  6.155824977560055e-18,  2.515112925887895e-20,  4.222552543613013e-23, -2.657936363552882e-25,
 -2.879760087175346e-27,  1.919823285445161e+00, -6.469368355904605e-04, -3.686657834741018e-06, -1.709106378267432e-08, -6.452730111831987e-11, -1.768534433088568e-13,
 -1.297126531411840e-16,  2.388957181831872e-18,  2.032345091016694e-20,  1.034968405656469e-22,  3.520354604566601e-25,  4.179957703932207e-28,  1.956209596855272e+00,
 -3.641587697102541e-04, -2.199661027425942e-06, -1.129543365756001e-08, -5.109364205649889e-11, -2.023177675322548e-13, -6.658847288706031e-16, -1.484689203789178e-18,
  1.003211835377169e-21,  3.741640612079892e-23,  2.814642963568110e-25,  1.508245699128834e-27,  1.982005563004338e+00, -1.528548212336336e-04, -9.613305617517549e-07,
 -5.281881737178677e-09, -2.660299966501405e-11, -1.249686527024277e-13, -5.495699731650454e-16, -2.248600816925494e-18, -8.396368465993403e-21, -2.726860957226043e-23,
 -6.615911283623514e-26, -2.121240322776912e-29,  1.996565848330069e+00, -2.952227550573940e-05, -1.898888110897479e-07, -1.082237838977452e-09, -5.759776309953817e-12,
 -2.928831747136693e-14, -1.439809875137756e-16, -6.888151550788007e-19, -3.219108071826948e-21, -1.472675782956620e-23, -6.600874338558597e-26, -2.898503524687945e-28,
  5.354486580613421e-04, -2.788395322029885e-06,  1.088805902844931e-08, -3.778312664957989e-11,  1.228698648681477e-13, -3.834595103021936e-16,  1.162792855567931e-18,
 -3.452702642728351e-21,  1.008319615968040e-23, -2.907358952633768e-26,  8.287844557752810e-29, -2.343196202234421e-31,  4.818390101478586e-03, -2.506023770963129e-05,
  9.757687542181257e-08, -3.369196490440885e-10,  1.087207168803201e-12, -3.355532349404947e-15,  1.002224382348935e-17, -2.917286155986046e-20,  8.305195452665309e-23,
 -2.319417595485658e-25,  6.355083346998518e-28, -1.711974172564010e-30,  1.338079503455372e-02, -6.941510897658077e-05,  2.687378955743623e-07, -9.185725285174463e-10,
  2.917519273599108e-12, -8.798744871888638e-15,  2.544552057525817e-17, -7.089472207823276e-20,  1.903411073830737e-22, -4.916743527121248e-25,  1.212720185921148e-27,
 -2.828944935349599e-30,  2.621559695319031e-02, -1.354732731614651e-04,  5.199391910929318e-07, -1.749817521012735e-09,  5.421669713373484e-12, -1.575402266377899e-14,
  4.315633084179534e-17, -1.111623835546523e-19,  2.657562793965792e-22, -5.731315397285924e-25,  1.029142138924395e-27, -1.120460027472586e-30,  4.331191667445281e-02,
 -2.226598502643823e-04,  8.445372618146369e-07, -2.782074576847901e-09,  8.322992097389068e-12, -2.288890622120635e-14,  5.750870542680556e-17, -1.285255788949640e-19,
  2.358474885218984e-22, -2.517111566871961e-25, -5.075619160533760e-28,  4.615814461962544e-30,  6.465471872208102e-02, -3.301984772567184e-04,  1.233685598016952e-06,
 -3.952120609048289e-09,  1.127431173501700e-11, -2.862243045200134e-14,  6.235483737194883e-17, -1.026061080401971e-19,  4.566921629194062e-23,  5.705472245786141e-25,
 -3.330642807267382e-27,  1.267015415039087e-29,  9.022433908566889e-02, -4.571028514000468e-04,  1.676351796162342e-06, -5.183515403007329e-09,  1.387689678631239e-11,
 -3.128689537745413e-14,  5.210781218411570e-17, -1.983048014521564e-20, -3.152640545489691e-22,  1.767490091097642e-24, -6.433347119370463e-27,  1.801885562537442e-29,
  1.199958717737275e-01, -6.021661691487466e-04,  2.159348547520413e-06, -6.388505606513463e-09,  1.570447865628757e-11, -2.932132416470519e-14,  2.291112684808197e-17,
  1.210372523076362e-19, -7.932164627608561e-22,  2.948042377899976e-24, -7.958742892756579e-27,  1.388777526433248e-29,  1.539383978016653e-01, -7.639485010725989e-04,
  2.667385703901597e-06, -7.470487483723248e-09,  1.633240514256542e-11, -2.148864120753898e-14, -2.620284511492910e-17,  3.046096431165959e-19, -1.263460867311983e-21,
  3.505111312854154e-24, -5.766751890055510e-27, -4.694996193337669e-30,  1.920140360507348e-01, -9.407621899507446e-04,  3.183152895166480e-06, -8.327123288050986e-09,
  1.537182073776252e-11, -7.104841142403552e-15, -9.231577958628001e-17,  4.970053283550265e-19, -1.542645818623553e-21,  2.772196382154244e-24,  1.561247073908341e-27,
 -3.633752887729103e-29,  2.341767907216382e-01, -1.130655433398676e-03,  3.687444913560054e-06, -8.854216895009051e-09,  1.250846883619184e-11,  1.373651155387539e-14,
 -1.679707354485425e-16,  6.475725271261796e-19, -1.424312532691633e-21,  2.792387190450243e-25,  1.352000120144379e-26, -6.975695319097555e-29,  2.803711648170751e-01,
 -1.331394324715542e-03,  4.159345365495775e-06, -8.950458768124421e-09,  7.545232867559793e-12,  3.996728749573064e-14, -2.410745657167834e-16,  6.952121250048261e-19,
 -7.375346698032192e-22, -3.938075484989315e-24,  2.673617259687079e-26, -8.401939839594580e-29,  3.305305031762029e-01, -1.540443790219776e-03,  4.576487971093770e-06,
 -8.523143786631376e-09,  4.468204989015630e-13,  6.940542567462548e-14, -2.955796711147400e-16,  5.798549953869398e-19,  5.775897722657217e-22, -9.065362839800793e-24,
  3.489904797526923e-26, -5.500495509725570e-29,  3.845750220520983e-01, -1.754948096826631e-03,  4.915419357891618e-06, -7.494941024116576e-09, -8.616016102204179e-12,
  9.871121549814389e-14, -3.131547262529787e-16,  2.588122928455706e-19,  2.392217615543176e-21, -1.340350743718078e-23,  3.017915740891589e-26,  3.129076839521207e-29,
  4.424094751523846e-01, -1.971711934261675e-03,  5.152092132797853e-06, -5.811742243978147e-09, -1.922669995634226e-11,  1.234846085029582e-13, -2.759907335301999e-16,
 -2.735991195495893e-19,  4.333002292062570e-21, -1.457968422398708e-23,  6.445983960712900e-27,  1.617356729784939e-28,  5.039203986678188e-01, -2.187183532999626e-03,
  5.262522122028315e-06, -3.451521786339518e-09, -3.069322766777336e-11,  1.385536180262979e-13, -1.707501426203087e-16, -9.665833587689821e-19,  5.781018906019730e-21,
 -1.019735636531037e-23, -3.611872371047548e-26,  2.835247501906577e-28,  5.689728705216821e-01, -2.397441900013989e-03,  5.223648324193633e-06, -4.339862256834277e-10,
 -4.203661620796402e-11,  1.385022510946101e-13,  6.577584555231301e-18, -1.699190170811300e-18,  5.961348964849305e-21,  1.060732868895921e-24, -8.654594016209105e-26,
  3.087390674659911e-28,  6.374067126447729e-01, -2.598191085041354e-03,  5.014437205813915e-06,  3.169445316097569e-09, -5.200761532490079e-11,  1.184729724358760e-13,
  2.455267909076850e-16, -2.280268870572533e-18,  4.150722967849593e-21,  1.807518405846725e-23, -1.215635059033543e-25,  1.483289286982654e-28,  7.090320607831155e-01,
 -2.784765480338821e-03,  4.617272589581393e-06,  7.226135982313835e-09, -5.914408732724633e-11,  7.524570236653742e-14,  5.168380508554323e-16, -2.471130055158519e-18,
  1.949864716987044e-24,  3.618650387353947e-23, -1.106075722010485e-25, -2.224919981460688e-28,  7.836242261957257e-01, -2.952151555187527e-03,  4.019665523104389e-06,
  1.153448684019068e-08, -6.188272232828756e-11,  8.533349470069010e-15,  7.706967073092832e-16, -2.038747348083618e-18, -6.071995125622197e-21,  4.717808801338826e-23,
 -2.992983014872827e-26, -6.895643888486662e-28,  8.609177807010908e-01, -3.095033165677699e-03,  3.216300586692727e-06,  1.581986369068203e-08, -5.873778859363379e-11,
 -7.766619773176343e-14,  9.397856266625005e-16, -8.413991466493293e-19, -1.259358722291766e-20,  4.131029803926064e-23,  1.157930979543895e-25, -9.712429022793501e-28,
  9.405998155061230e-01, -3.207869652426182e-03,  2.211399526178487e-06,  1.973685227245500e-08, -4.855435622131717e-11, -1.739633155469064e-13,  9.495604886811243e-16,
  1.064278395322312e-18, -1.702354466054983e-20,  1.196391381799798e-23,  2.737986005380720e-25, -7.121334050420806e-28,  1.022302361762351e+00, -3.285018249309990e-03,
  1.021321088891534e-06,  2.288127638578573e-08, -3.083103004308238e-11, -2.651875817431597e-13,  7.373931971844457e-16,  3.326666639203952e-18, -1.633736821146921e-20,
 -3.787772758777157e-23,  3.440376938858572e-25,  2.590297482182371e-28,  1.105594026079949e+00, -3.320914620718819e-03, -3.227830703118634e-07,  2.481600402923661e-08,
 -6.084403584197645e-12, -3.313438326429140e-13,  2.798533746805311e-16,  5.269880584388158e-18, -8.336186702035526e-21, -9.040273378344511e-23,  2.212553411808779e-25,
  1.597198188412068e-27,  1.189970999482591e+00, -3.310327098479587e-03, -1.772582960271549e-06,  2.511455589949575e-08,  2.380826334597586e-11, -3.505814194374197e-13,
 -3.771923292153795e-16,  6.005521476920852e-18,  6.509134031653774e-21, -1.145192728919615e-22, -1.183018552767420e-25,  2.330753010229887e-27,  1.274847758486863e+00,
 -3.248700457099564e-03, -3.260981061892901e-06,  2.342523708184501e-08,  5.539904585432408e-11, -3.046044902793921e-13, -1.097606441171560e-15,  4.742874115365722e-18,
  2.352392891915546e-20, -7.969098637491358e-23, -5.281405892141380e-25,  1.368238007859794e-27,  1.359548008512046e+00, -3.132602309432320e-03, -4.702087921217817e-06,
  1.955498131467976e-08,  8.375217458233681e-11, -1.862164326336825e-13, -1.661568906529700e-15,  1.273410724508893e-18,  3.411968402487838e-20,  1.859250800610175e-23,
 -6.991785975434731e-25, -1.331783280479817e-27,  1.443296736661363e+00, -2.960277165119617e-03, -5.993777461003364e-06,  1.356528040075698e-08,  1.030056121644233e-10,
 -7.310754184958743e-15, -1.819078179634343e-15, -3.556290173499093e-18,  2.940405794347103e-20,  1.361659756941034e-22, -3.590998785046544e-25, -3.831523204608674e-27,
  1.525214646939681e+00, -2.732296956730007e-03, -7.023993990517636e-06,  5.861902144422155e-09,  1.075541082744729e-10,  1.962421309145264e-13, -1.396490125614484e-15,
 -7.756891384941090e-18,  6.884388247740908e-21,  1.884583617997395e-22,  3.946401615280567e-25, -3.213188257701899e-27,  1.604316726556350e+00, -2.452269375025639e-03,
 -7.681883444387679e-06, -2.753329769081174e-09,  9.382485918381124e-11,  3.678448731665076e-13, -4.279692793041608e-16, -8.903897927934728e-18, -2.364333122416359e-20,
  1.098330420640950e-22,  9.597403439878037e-25,  1.050169867939315e-27,  1.679517174315176e+00, -2.127524945103336e-03, -7.874224170462652e-06, -1.111211215168730e-08,
  6.227753464687142e-11,  4.458855922806256e-13,  7.645851078208982e-16, -5.673350899557575e-18, -4.213630326049398e-20, -6.511200133061948e-23,  6.849227321363430e-25,
  4.788848304789870e-27,  1.749643282323741e+00, -1.769652681483712e-03, -7.546282650773194e-06, -1.783457564580572e-08,  1.880760634783410e-11,  3.911525114292289e-13,
  1.646147470033845e-15,  6.248067240265735e-19, -3.246294854183373e-20, -1.908320575752174e-22, -2.854255566365951e-25,  3.050053356071885e-27,  1.813460889709640e+00,
 -1.394702416232883e-03, -6.704017360923953e-06, -2.162972948178838e-08, -2.559421292755857e-11,  2.153605791681592e-13,  1.744868391617400e-15,  6.111587847088872e-18,
 -2.617989931311350e-22, -1.404451738853201e-22, -8.844509364296045e-25, -2.267456133245467e-27,  1.869713442793405e+00, -1.022840706331213e-03, -5.431845787068550e-06,
 -2.170351622039811e-08, -5.783611078412683e-11, -9.444986026120556e-15,  1.009376192669975e-15,  6.982670680476299e-18,  2.644742104311164e-20,  2.884765326835571e-23,
 -4.084961069923661e-25, -3.620332098157327e-27,  1.917175227522458e+00, -6.772682905535828e-04, -3.898062426796772e-06, -1.815194218671163e-08, -6.808968809600824e-11,
 -1.790868270785422e-13, -5.313725824904696e-17,  3.101671056229302e-18,  2.430655144358168e-20,  1.178691471630626e-22,  3.644345839730908e-25,  1.227943625922415e-28,
  1.954716888714439e+00, -3.823124494500954e-04, -2.340247601804003e-06, -1.214618513920363e-08, -5.530315269403672e-11, -2.187929033624663e-13, -7.067878194229453e-16,
 -1.428726344211295e-18,  2.569694177645848e-21,  5.009562643951568e-23,  3.548968959656180e-25,  1.837814365295236e-27,  1.981378350535418e+00, -1.608064267837873e-04,
 -1.027351891091347e-06, -5.728263320206160e-09, -2.923953016633038e-11, -1.389451485509019e-13, -6.164435936980510e-16, -2.533502852755600e-18, -9.425736108695048e-21,
 -2.991546708444635e-23, -6.568152947200174e-26,  4.790960640091125e-29,  1.996444636484967e+00, -3.109494584136318e-05, -2.034485605841151e-07, -1.179274915339917e-09,
 -6.381722635018261e-12, -3.298745208612878e-14, -1.647934564454892e-16, -8.008448539159740e-19, -3.800038941149402e-21, -1.764079530579811e-23, -8.017960344257219e-26,
 -3.566965076816656e-28,  5.244664606258411e-04, -2.703071592446068e-06,  1.044620875578274e-08, -3.587707827737561e-11,  1.154720986304347e-13, -3.566770737372670e-16,
  1.070481554679658e-18, -3.146166556818374e-21,  9.093816666894024e-24, -2.595571131447992e-26,  7.322901732130154e-29, -2.049885966878956e-31,  4.719685185621851e-03,
 -2.429550414591893e-05,  9.363603845804584e-08, -3.200484229329239e-10,  1.022437216244938e-12, -3.124507806742027e-15,  9.241389850038666e-18, -2.664403495032405e-20,
  7.514202898237189e-23, -2.079662435953944e-25,  5.647450303300540e-28, -1.509043330967858e-30,  1.310736569642667e-02, -6.730851688993125e-05,  2.579894055779268e-07,
 -8.732675011016699e-10,  2.747494000761431e-12, -8.211200757526792e-15,  2.354314559434699e-17, -6.507788730178315e-20,  1.734847551559305e-22, -4.455714938305052e-25,
  1.094440044363748e-27, -2.551938522976118e-30,  2.568189195227468e-02, -1.313962997652468e-04,  4.994516429201826e-07, -1.665536214587781e-09,  5.116699549793145e-12,
 -1.475467909275609e-14,  4.015979720551341e-17, -1.029804593422911e-19,  2.458524192257043e-22, -5.329760445177471e-25,  9.781097289859196e-28, -1.192423580893581e-30,
  4.243458158268247e-02, -2.160348622056398e-04,  8.119365070659687e-07, -2.652495145261937e-09,  7.878728937762348e-12, -2.155103756443828e-14,  5.401426091409960e-17,
 -1.211269827120521e-19,  2.264668616639853e-22, -2.682268735942247e-25, -3.247380736984907e-28,  3.720992806700900e-30,  6.335336769409203e-02, -3.205156706316860e-04,
  1.187323854556344e-06, -3.776230873057259e-09,  1.071659650703297e-11, -2.716020678168575e-14,  5.950523679645334e-17, -1.008407121038976e-19,  6.394034892467276e-23,
  4.479408914656688e-25, -2.812383494386718e-27,  1.092473282477614e-29,  8.842236062822097e-02, -4.439371183698081e-04,  1.615461363606595e-06, -4.966423217659807e-09,
  1.326361412965092e-11, -3.004405386523138e-14,  5.142054083639424e-17, -2.894900159194994e-20, -2.560801077897580e-22,  1.525491449143992e-24, -5.679323506341167e-27,
  1.627015610820502e-29,  1.176212771194779e-01, -5.851938017882957e-04,  2.084174857922801e-06, -6.141894381864119e-09,  1.512381094052514e-11, -2.873356097768271e-14,
  2.596033262180347e-17,  9.729215265437632e-20, -6.926698417809285e-22,  2.641922814962974e-24, -7.347605889952312e-27,  1.383840711891636e-29,  1.509247204399064e-01,
 -7.429635892970628e-04,  2.579293479535454e-06, -7.212638533379866e-09,  1.589701136764307e-11, -2.201961433112805e-14, -1.822115532984104e-17,  2.661529821422992e-19,
 -1.141468732882267e-21,  3.271392464804681e-24, -5.893980448129593e-27, -1.231261814653464e-30,  1.883012907634686e-01, -9.156924991303694e-04,  3.084698044052783e-06,
 -8.082426678289200e-09,  1.520866689957294e-11, -9.158911699033260e-15, -7.907566409137867e-17,  4.492465113305621e-19, -1.442086989271619e-21,  2.804957542747983e-24,
  1.313653734079044e-28, -2.884570679249949e-29,  2.297125000152008e-01, -1.101577454710952e-03,  3.582403497039388e-06, -8.652096513235571e-09,  1.274432822023716e-11,
  9.917660832749371e-15, -1.504745752784631e-16,  6.022539043557118e-19, -1.405240047628924e-21,  7.614111529633425e-25,  1.065580464750290e-26, -6.053466987229290e-29,
  2.751114597841255e-01, -1.298547072768554e-03,  4.052689580709186e-06, -8.823648068646047e-09,  8.288283150173981e-12,  3.441229847296106e-14, -2.219589245114735e-16,
  6.695419430928248e-19, -8.609329882868911e-22, -2.941089920381278e-24,  2.315153102371973e-26, -7.875099135671582e-29,  3.244413043714802e-01, -1.504240772797967e-03,
  4.474297714639906e-06, -8.505269672405128e-09,  1.765314551519201e-12,  6.250814137349476e-14, -2.791321399828794e-16,  5.933807772458789e-19,  2.757614806776981e-22,
 -7.719873642576740e-24,  3.233026945266342e-26, -6.121351723476103e-29,  3.776333036449409e-01, -1.715986695288190e-03,  4.824716761787642e-06, -7.617409227141676e-09,
 -6.716319095956897e-12,  9.129067579149178e-14, -3.049071338013485e-16,  3.278780836214664e-19,  1.931687329501892e-21, -1.217585580510326e-23,  3.103758847794090e-26,
  8.515695567413772e-30,  4.346046120585026e-01, -1.930779205142788e-03,  5.080585790279268e-06, -6.099974126802321e-09, -1.682378716044186e-11,  1.167840868634664e-13,
 -2.817887969033500e-16, -1.432779136317756e-19,  3.814390904863107e-21, -1.419033455491076e-23,  1.275970053449286e-26,  1.258003745295688e-28,  4.952555910637029e-01,
 -2.145257168516338e-03,  5.218248010628348e-06, -3.920676338546498e-09, -2.796522099066062e-11,  1.341513981792218e-13, -1.952816176735139e-16, -7.877194250406013e-19,
  5.390829861175966e-21, -1.140200268412876e-23, -2.435085509446908e-26,  2.509791009949926e-28,  5.594666324473321e-01, -2.355684768218469e-03,  5.214496370333690e-06,
 -1.084418935911792e-09, -3.926873485854135e-11,  1.381107535200554e-13, -3.832792457451165e-17, -1.508457544769358e-18,  5.940501314675748e-21, -2.129008630175526e-24,
 -7.295146539618782e-26,  3.073600742096801e-28,  6.270944004467303e-01, -2.557937418038670e-03,  5.047556989154695e-06,  2.356577882667281e-09, -4.958432109715092e-11,
  1.236150221280203e-13,  1.836299977306404e-16, -2.137959056023667e-18,  4.715639304832557e-21,  1.336078174011597e-23, -1.137518288948646e-25,  2.039195533989875e-28,
  6.979674018543643e-01, -2.747496413651394e-03,  4.698360170027534e-06,  6.292520344355802e-09, -5.752073163889368e-11,  8.682069568237398e-14,  4.478369355548524e-16,
 -2.451095222856704e-18,  1.222978056536819e-21,  3.160037830572429e-23, -1.178793991379063e-25, -1.100519840445015e-28,  7.718807875065861e-01, -2.919457388332697e-03,
  4.152147457337561e-06,  1.054671382347052e-08, -6.153181885680140e-11,  2.632465464166075e-14,  7.111448745982024e-16, -2.206164957590807e-18, -4.402131207979767e-21,
  4.540874680594432e-23, -5.766204342414607e-26, -5.695202151441022e-28,  8.485902884564308e-01, -3.068559494339292e-03,  3.400452809420184e-06,  1.486884915049128e-08,
 -6.006770169915375e-11, -5.543818717529414e-14,  9.108139854122636e-16, -1.219788554607483e-18, -1.103329283992058e-20,  4.509356522221533e-23,  7.359508746271928e-26,
 -9.404839751241153e-28,  9.278052003063043e-01, -3.189244550426307e-03,  2.443469755436527e-06,  1.893339569957643e-08, -5.180363040862424e-11, -1.508773514499344e-13,
  9.718131846612057e-16,  5.284656497553413e-19, -1.640370729508843e-20,  2.224081035231177e-23,  2.389422334355861e-25, -8.636697326305094e-28,  1.009180356517043e+00,
 -3.275758162057579e-03,  1.292764801523105e-06,  2.234654204456923e-08, -3.595057274279705e-11, -2.464326255063461e-13,  8.230347642581617e-16,  2.784725744348140e-18,
 -1.745139431408423e-20, -2.398488515318304e-23,  3.482453386501079e-25, -6.460101268840065e-29,  1.092307086087119e+00, -3.322307873070652e-03, -2.579249384216391e-08,
  2.466605307652574e-08, -1.263233165240374e-11, -3.228897582003457e-13,  4.231991097265813e-16,  4.952891251863740e-18, -1.141520084831375e-20, -8.023094430838125e-23,
  2.851444442178417e-25,  1.296887662006846e-27,  1.176703246903687e+00, -3.323296323424890e-03, -1.469155516065647e-06,  2.543896077408054e-08,  1.671983469570965e-11,
 -3.575964801193429e-13, -2.067467561149107e-16,  6.147139450608626e-18,  2.326193249825812e-21, -1.171784321608986e-22, -1.434025675348542e-26,  2.374099865722624e-27,
  1.261802581930866e+00, -3.273649297741793e-03, -2.974765456783192e-06,  2.426150046544934e-08,  4.905471518672498e-11, -3.292711701465429e-13, -9.547268704010062e-16,
  5.445788456256987e-18,  2.029083366319062e-20, -9.944523306694158e-23, -4.555627314788837e-25,  1.918069681295095e-27,  1.346943883816166e+00, -3.169257890164037e-03,
 -4.459517819513558e-06,  2.086306914148666e-08,  7.963259702940550e-11, -2.255424207435105e-13, -1.610566252619983e-15,  2.370449703817799e-18,  3.427333089783951e-20,
 -1.034217230160927e-23, -7.423057095013555e-25, -6.116642033983023e-28,  1.431360798042715e+00, -3.007548260505592e-03, -5.821118154087291e-06,  1.520979651076885e-08,
  1.024153209879398e-10, -5.205279676277128e-14, -1.904766027392966e-15, -2.540029892633336e-18,  3.400699769002207e-20,  1.184495866468105e-22, -5.258178578114406e-25,
 -3.707421748712841e-27,  1.514173562392175e+00, -2.788177996541311e-03, -6.943202549874954e-06,  7.612272278197471e-09,  1.111263562642097e-10,  1.601513170050041e-13,
 -1.609558900356728e-15, -7.425284675237499e-18,  1.391655831276100e-20,  2.011539842281435e-22,  2.337994053280239e-25, -4.082641412264361e-27,  1.594384566428894e+00,
 -2.513830526976418e-03, -7.705675480464491e-06, -1.193921168217350e-09,  1.010584246076587e-10,  3.545003267810158e-13, -6.872229532869087e-16, -9.589738226518457e-18,
 -1.898981592955140e-20,  1.488552291906179e-22,  9.837153877567414e-25, -2.533404653374195e-31,  1.670880267243459e+00, -2.191034496416598e-03, -8.001293513089120e-06,
 -1.004338966091207e-08,  7.136508384593028e-11,  4.621750575360748e-13,  5.865419385879700e-16, -7.053513250940732e-18, -4.393580552612896e-20, -3.343821850572486e-23,
  8.998379528179262e-25,  4.934629709024649e-27,  1.742442583671229e+00, -1.830873278133322e-03, -7.758226903339375e-06, -1.746891921187418e-08,  2.702651516135650e-11,
  4.307461800153350e-13,  1.648051787638432e-15, -5.258469074384548e-19, -3.950286438763577e-20, -1.992114839486714e-22, -1.245614730023977e-25,  4.282733087279763e-27,
  1.807773162529871e+00, -1.449379401342138e-03, -6.965881492041979e-06, -2.200244578455883e-08, -2.085439747040159e-11,  2.592850468286615e-13,  1.915065699555427e-15,
  6.015297755006599e-18, -5.977585017058528e-21, -1.776949206033323e-22, -9.744537839591704e-25, -1.774419201565816e-27,  1.865533498751443e+00, -1.067352978296362e-03,
 -5.697842032634768e-06, -2.262902075744546e-08, -5.776642563610401e-11,  1.722269268954236e-14,  1.216871183149470e-15,  7.842125285654830e-18,  2.715130265520569e-20,
  9.087503603086454e-24, -5.854151625409782e-25, -4.430304831095755e-27,  1.914402379308098e+00, -7.093428760970399e-04, -4.122540680253332e-06, -1.927006921916858e-08,
 -7.167667174402832e-11, -1.792280457908201e-13,  4.525685983973127e-17,  3.950190342351162e-18,  2.881245762508428e-20,  1.324336992225473e-22,  3.604803377107461e-25,
 -3.328260392358549e-28,  1.953149250162443e+00, -4.016328282286327e-04, -2.491458351634062e-06, -1.306697751012926e-08, -5.985182472585143e-11, -2.362248026968487e-13,
 -7.453493355424670e-16, -1.314736675354808e-18,  4.649128544096462e-21,  6.601687867388040e-23,  4.439299571115126e-25,  2.217303136256740e-27,  1.980718240336859e+00,
 -1.693083682455080e-04, -1.098992420891364e-06, -6.219155614150590e-09, -3.217230602081908e-11, -1.546261483252119e-13, -6.917698892212336e-16, -2.852859039758380e-18,
 -1.054922651271581e-20, -3.247264427605462e-23, -6.141256701442101e-26,  1.531370589635403e-28,  1.996316909381245e+00, -3.278092692646848e-05, -2.182349941906365e-07,
 -1.286883239497976e-09, -7.082912010766267e-12, -3.722592957127415e-14, -1.890195993463751e-16, -9.332582473829207e-19, -4.496828259742702e-21, -2.118507316607055e-23,
 -9.764079747620829e-26, -4.400378234420902e-28,  5.138186305759509e-04, -2.621193146972661e-06,  1.002653817233052e-08, -3.408522649389971e-11,  1.085885035767309e-13,
 -3.320105887541013e-16,  9.863263792991752e-19, -2.869566758694802e-21,  8.210033230864445e-24, -2.319919795742475e-26,  6.478162632246321e-29, -1.795826913789559e-31,
  4.623977408424850e-03, -2.356150473183109e-05,  8.989158753460144e-08, -3.041775467995804e-10,  9.621059404588924e-13, -2.911401897577830e-15,  8.527925334532146e-18,
 -2.435504535838318e-20,  6.804635316563209e-23, -1.866504426617123e-25,  5.023370212837303e-28, -1.331598652568703e-30,  1.284219412985611e-02, -6.528578345159078e-05,
  2.477686333764817e-07, -8.305912973909894e-10,  2.588775924176009e-12, -7.667418637290853e-15,  2.179633347565126e-17, -5.977479030798355e-20,  1.582058093333759e-22,
 -4.039639736141085e-25,  9.877615555917194e-28, -2.301252737247717e-30,  2.516417333441509e-02, -1.274792627095895e-04,  4.799468404079761e-07, -1.585978366674591e-09,
  4.831015279817766e-12, -1.382457385332041e-14,  3.738365499808520e-17, -9.541272856176034e-20,  2.273567548881979e-22, -4.949138442316817e-25,  9.247400558222721e-28,
 -1.228290502748255e-30,  4.158323451115509e-02, -2.096645792074473e-04,  7.808489246567567e-07, -2.529814352182749e-09,  7.460401087145418e-12, -2.029458406877789e-14,
  5.072269482083589e-17, -1.140367424886696e-19,  2.166142319016443e-22, -2.781714897852778e-25, -1.779245474159402e-28,  2.974836504112663e-30,  6.209001926106509e-02,
 -3.111954647470266e-04,  1.143020200345323e-06, -3.609034322861511e-09,  1.018744617688862e-11, -2.576571822271157e-14,  5.671261690350333e-17, -9.855740648034570e-20,
  7.815289023776645e-23,  3.445943406491896e-25, -2.366079015018080e-27,  9.395533678573249e-30,  8.667208712196145e-02, -4.312482533051205e-04,  1.557117979284199e-06,
 -4.758945679437881e-09,  1.267500374991988e-11, -2.882056452483059e-14,  5.050319623764287e-17, -3.630735572210127e-20, -2.050835020612737e-22,  1.312143267053358e-24,
 -5.000094564293290e-27,  1.462149865187006e-29,  1.153133876763222e-01, -5.688111436293244e-04,  2.011905159121624e-06, -5.904476042033662e-09,  1.455557828042116e-11,
 -2.808024164328059e-14,  2.838809735822802e-17,  7.659292837459661e-20, -6.027048376005224e-22,  2.360117842252014e-24, -6.745019591628034e-27,  1.351328977627959e-29,
  1.479935926780078e-01, -7.226711577351901e-04,  2.494253327061988e-06, -6.961830789282480e-09,  1.545282876278355e-11, -2.237151501683861e-14, -1.126286981149367e-17,
  2.314647484706802e-19, -1.027947597674490e-21,  3.035387984446224e-24, -5.886827735627852e-27,  1.436643828985560e-30,  1.846872674921796e-01, -8.913987490717268e-04,
  2.989162588500911e-06, -7.840652364228683e-09,  1.500750284345341e-11, -1.091090211487262e-14, -6.712764287813392e-17,  4.047140335152364e-19, -1.341301840920433e-21,
  2.786786917324533e-24, -9.933136847184448e-28, -2.244823457947086e-29,  2.253628560051000e-01, -1.073330047081878e-03,  3.479807719887768e-06, -8.446791012434593e-09,
  1.290790730733612e-11,  6.503575132451647e-15, -1.342363356582282e-16,  5.578020034057682e-19, -1.370775486397388e-21,  1.136942727655530e-24,  8.183098148903273e-27,
 -5.197878615010813e-29,  2.699814471784219e-01, -1.266546786359488e-03,  3.947623270909031e-06, -8.685812688086196e-09,  8.924761017345995e-12,  2.930704563555317e-14,
 -2.036121297507275e-16,  6.404700752375260e-19, -9.509624169853485e-22, -2.082586995882973e-24,  1.981787682347830e-26, -7.267981119012063e-29,  3.184952844434299e-01,
 -1.468854071183890e-03,  4.372444040558342e-06, -8.467381661548762e-09,  2.949835548794174e-12,  5.600909510629376e-14, -2.624339684493486e-16,  5.980027463882734e-19,
  2.046393074909583e-23, -6.481676143443555e-24,  2.955615505196585e-26, -6.444286089008600e-29,  3.708459710095210e-01, -1.677756287480942e-03,  4.732722057167152e-06,
 -7.710658181488325e-09, -4.962905252829372e-12,  8.408966015840320e-14, -2.949253364223966e-16,  3.829187824046187e-19,  1.515741635698429e-21, -1.093253415737422e-23,
  3.099594785110877e-26, -9.690081603259368e-30,  4.269623147832290e-01, -1.890431718530036e-03,  5.005846901268990e-06, -6.350837841927576e-09, -1.455599039479334e-11,
  1.099863389479231e-13, -2.841677673625455e-16, -2.928229726897128e-20,  3.313970135407278e-21, -1.357904048763372e-23,  1.756928585649722e-26,  9.344154768913121e-29,
  4.867577459144726e-01, -2.103706781215795e-03,  5.168602928747296e-06, -4.346917451220012e-09, -2.533074805139284e-11,  1.292190733956258e-13, -2.149855955254100e-16,
 -6.219474071273531e-19,  4.965395816517777e-21, -1.216515134864495e-23, -1.405494034435469e-26,  2.169036986906147e-28,  5.501272280976300e-01, -2.314031320926704e-03,
  5.197804497446463e-06, -1.690684927848931e-09, -3.651902902741162e-11,  1.367054321458165e-13, -7.791877617970107e-17, -1.320124692043344e-18,  5.814567964215469e-21,
 -4.779269548843059e-24, -5.964384157651751e-26,  2.961037659145494e-28,  6.169435719955043e-01, -2.517457143971639e-03,  5.071158135626813e-06,  1.583226560967797e-09,
 -4.707270844735310e-11,  1.273212530682202e-13,  1.259459037294036e-16, -1.980222622727228e-18,  5.117005684861824e-21,  9.002799959868889e-24, -1.038632865057940e-25,
  2.429330681866559e-28,  6.870530462846917e-01, -2.709623001307599e-03,  4.768407553707206e-06,  5.386640687082883e-09, -5.568236874823064e-11,  9.675065484815299e-14,
  3.799186507929543e-16, -2.394675781351701e-18,  2.274828147138306e-21,  2.681853424844918e-23, -1.204921377681643e-25, -1.113534306063160e-29,  7.602701702948204e-01,
 -2.885750657132273e-03,  4.272821288722680e-06,  9.567322729523923e-09, -6.083973049525338e-11,  4.263643548802857e-14,  6.476424063152324e-16, -2.321369688702513e-18,
 -2.814637917731877e-21,  4.263784022754097e-23, -7.996930014275785e-26, -4.441342645998080e-28,  8.363715645891107e-01, -3.040658582129698e-03,  3.573079724522954e-06,
  1.390007120401834e-08, -6.096083632397991e-11, -3.402687854802818e-14,  8.719646236648525e-16, -1.546391844051563e-18, -9.366757778366714e-21,  4.722680010155270e-23,
  3.354602334598390e-26, -8.747927904965536e-28,  9.150887363742035e-01, -3.168802301056402e-03,  2.665601892398604e-06,  1.808166845513989e-08, -5.458704689212580e-11,
 -1.274347824759183e-13,  9.793944399636431e-16,  1.812598087725559e-20, -1.544046480586845e-20,  3.100553128958074e-23,  1.985737847921820e-25, -9.625432953868318e-28,
  9.960996921529004e-01, -3.264353555660908e-03,  1.557312951723498e-06,  2.173300226393159e-08, -4.067571031946117e-11, -2.258079295086361e-13,  8.930781627940858e-16,
  2.215143310605120e-18, -1.806561982655260e-20, -1.020165664725515e-23,  3.387555571492906e-25, -3.610213621462356e-28,  1.079019311041880e+00, -3.321334165444054e-03,
  2.687762465640457e-07,  2.441287163592719e-08, -1.897755022985590e-11, -3.111126729178884e-13,  5.563481566632234e-16,  4.543698797403265e-18, -1.408536491474218e-20,
 -6.778402956017788e-23,  3.346510590716523e-25,  9.471093153669825e-28,  1.163388494184691e+00, -3.333824494648451e-03, -1.162519609466321e-06,  2.564905171680637e-08,
  9.532254517440946e-12, -3.604884486299600e-13, -3.421849577843680e-17,  6.154175752338177e-18, -1.877500630804847e-21, -1.156777874551057e-22,  8.878202100652022e-26,
  2.293152912011057e-27,  1.248662250533908e+00, -3.296270034809211e-03, -2.679139405539798e-06,  2.499250067775638e-08,  4.225287309663113e-11, -3.502848878972726e-13,
 -7.937167731271658e-16,  6.034471456707724e-18,  1.640444566077754e-20, -1.158378812320139e-22, -3.607524594417288e-25,  2.373020525315270e-27,  1.334197115673542e+00,
 -3.203911301683088e-03, -4.201671854516512e-06,  2.209902851818585e-08,  7.474122718435422e-11, -2.632761572961304e-13, -1.528936274463005e-15,  3.455469708549302e-18,
  3.336216365514415e-20, -4.034144305161685e-23, -7.518276689516030e-25,  1.879986395338694e-28,  1.419238662257468e+00, -3.053359373906789e-03, -5.628811186359145e-06,
  1.683760746444143e-08,  1.009120121072120e-10, -9.849387499345306e-14, -1.960041444933816e-15, -1.387952336802157e-18,  3.785407033540437e-20,  9.424457724877803e-23,
 -6.817566227103254e-25, -3.340015303744232e-27,  1.502910380673768e+00, -2.843327772055206e-03, -6.841088442021696e-06,  9.413749627239544e-09,  1.139265365955431e-10,
  1.190840767774845e-13, -1.810132843422118e-15, -6.862650506497625e-18,  2.128103496167946e-20,  2.066837409817782e-22,  3.730340246306993e-26, -4.820726124749548e-27,
  1.584205902284253e+00, -2.575505218584409e-03, -7.710070110613305e-06,  4.787450754250968e-10,  1.079614152260160e-10,  3.347213793266673e-13, -9.633834172144009e-16,
 -1.010409872843883e-17, -1.292600795012191e-20,  1.878434278581490e-22,  9.564105323217619e-25, -1.274071842517608e-27,  1.661987373600199e+00, -2.255506808791986e-03,
 -8.114655818262427e-06, -8.826905478940460e-09,  8.073253283987817e-11,  4.737223583120723e-13,  3.692313416713519e-16, -8.471348990820854e-18, -4.443955063989095e-20,
  6.873195456078284e-24,  1.114495742879906e-24,  4.763528340633539e-27,  1.734993642549324e+00, -1.893769581609182e-03, -7.964968154627354e-06, -1.696543418204635e-08,
  3.603501212591176e-11,  4.699732445996900e-13,  1.614548050323132e-15, -1.905254404788684e-18, -4.671524246419393e-20, -2.000391562010991e-22,  9.284476712407834e-26,
  5.608624101030593e-27,  1.801862511167051e+00, -1.506167832452081e-03, -7.231733490882220e-06, -2.229207649253068e-08, -1.519557585348756e-11,  3.072399653602577e-13,
  2.079799935924199e-15,  5.713999740034998e-18, -1.309309719681267e-20, -2.180177916432466e-22, -1.035674067323044e-24, -9.473526367052155e-28,  1.861171179425812e+00,
 -1.114037583155912e-03, -5.974919143297551e-06, -2.354886471117381e-08, -5.711162869157786e-11,  4.916086528572191e-14,  1.448629154163951e-15,  8.711285921270748e-18,
  2.700772874641448e-20, -1.847464245175030e-23, -7.988172633269541e-25, -5.270264058090543e-27,  1.911497554745270e+00, -7.432679327650008e-04, -4.360780463326333e-06,
 -2.044547390183231e-08, -7.524085448124620e-11, -1.767059274812176e-13,  1.695065259184390e-16,  4.951214674135314e-18,  3.383448844075106e-20,  1.463811983827674e-22,
  3.320531313459655e-25, -9.984785061681202e-28,  1.951501838961088e+00, -4.222083550956262e-04, -2.654166947061632e-06, -1.406338679418289e-08, -6.475808977965598e-11,
 -2.545358036517146e-13, -7.796962947436541e-16, -1.124313610539253e-18,  7.369986263704913e-21,  8.584765531119010e-23,  5.507166139342582e-25,  2.643844464711875e-27,
  1.980022937657730e+00, -1.784078189794493e-04, -1.176815880824259e-06, -6.759582621656698e-09, -3.543752583324556e-11, -1.722264290571484e-13, -7.765550298282181e-16,
 -3.209597045976140e-18, -1.176046355879833e-20, -3.475281312972042e-23, -5.146441652246795e-26,  3.087919669587014e-28,  1.996182193313994e+00, -3.459056205767328e-05,
 -2.343829451503474e-07, -1.406421648420428e-09, -7.874999064126845e-12, -4.209296787651665e-14, -2.172856647765379e-16, -1.090152715247700e-18, -5.334719353240314e-21,
 -2.550691139894818e-23, -1.192089224213782e-25, -5.441709767145360e-28,  5.034917331646035e-04, -2.542587892826180e-06,  9.627724916622506e-09, -3.239967275514798e-11,
  1.021786521735746e-13, -3.092739967947067e-16,  9.095345289495015e-19, -2.619723368510594e-21,  7.419662116340483e-24, -2.075925264546670e-26,  5.737606537042604e-29,
 -1.575487778979585e-31,  4.531146901108382e-03, -2.285671521520056e-05,  8.633193301695707e-08, -2.892387831525966e-10,  9.058706131441304e-13, -2.714675002052399e-15,
  7.875485677451182e-18, -2.228130641779116e-20,  6.167493218769166e-23, -1.676815591418751e-25,  4.472377766358776e-28, -1.176319137203255e-30,  1.258495314819883e-02,
 -6.334281009240409e-05,  2.380450903374669e-07, -7.903698061005045e-10,  2.440526002745478e-12, -7.163832060867268e-15,  2.019138253616802e-17, -5.493745607083902e-20,
  1.443505173754506e-22, -3.664102776426699e-25,  8.915721314969960e-28, -2.074829285040887e-30,  2.466181672646634e-02, -1.237145216128582e-04,  4.613699087178339e-07,
 -1.510846199474524e-09,  4.563283663786596e-12, -1.295861889833900e-14,  3.481132623478178e-17, -8.841534978523501e-20,  2.101926029332051e-22, -4.590093576708342e-25,
  8.704234922070635e-28, -1.236746324210266e-30,  4.075688033588752e-02, -2.035372200933805e-04,  7.511941678294475e-07, -2.413629997502047e-09,  7.066428225857032e-12,
 -1.911478175757274e-14,  4.762519537561481e-17, -1.072664430000398e-19,  2.065017425630742e-22, -2.828617140280744e-25, -6.110583474852955e-29,  2.354038664674690e-30,
  6.086325529961839e-02, -3.022218044944608e-04,  1.100673014932905e-06, -3.450084678736139e-09,  9.685520819140892e-12, -2.443743727565865e-14,  5.398976129470537e-17,
 -9.587550975710943e-20,  8.895061431878089e-23,  2.578127083137061e-25, -1.982732376484275e-27,  8.059290862750239e-30,  8.497165112651972e-02, -4.190163346436033e-04,
  1.501208622268500e-06, -4.560691412037512e-09,  1.211062722912673e-11, -2.762138637088072e-14,  4.940154613456438e-17, -4.215160335504987e-20, -1.612955772079966e-22,
  1.124545527060530e-24, -4.390992325233193e-27,  1.308383122994448e-29,  1.130698903775481e-01, -5.529954005270758e-04,  1.942430370984083e-06, -5.676041919188420e-09,
  1.400094936679211e-11, -2.737529478951480e-14,  3.027509599317219e-17,  5.861488465110908e-20, -5.224549849107718e-22,  2.102066751569328e-24, -6.161356018273717e-27,
  1.298962890628429e-29,  1.451422928901066e-01, -7.030471299166054e-04,  2.412180022240219e-06, -6.718177520315473e-09,  1.500320154801461e-11, -2.256766944722146e-14,
 -5.226272961210719e-18,  2.002735249790928e-19, -9.228910583550728e-22,  2.801813240570544e-24, -5.777318519452479e-27,  3.441818942725414e-30,  1.811689089480512e-01,
 -8.678577347709276e-04,  2.896508005980526e-06, -7.602361830716141e-09,  1.477406738426897e-11, -1.239073939659352e-14, -5.638153643903675e-17,  3.633880641654511e-19,
 -1.241915505619308e-21,  2.728959411967301e-24, -1.858702003190757e-27, -1.704249764530381e-29,  2.211245757524425e-01, -1.045893511566397e-03,  3.379689126481334e-06,
 -8.239393746074167e-09,  1.300700173568136e-11,  3.464407795366973e-15, -1.192254086597822e-16,  5.146509088922603e-19, -1.324483358258462e-21,  1.420880469079028e-24,
  6.070696715844422e-27, -4.416587138031264e-29,  2.649777653672574e-01, -1.235380248814522e-03,  3.844268794811294e-06, -8.538586860149555e-09,  9.463469558920228e-12,
  2.463204982863271e-14, -1.861152146668790e-16,  6.089865595345738e-19, -1.012420178486153e-21, -1.351937159837176e-24,  1.676199002907647e-26, -6.617986938689149e-29,
  3.126891849845499e-01, -1.434280067885165e-03,  4.271154517866715e-06, -8.411559359810654e-09,  4.008389065489327e-12,  4.991147519727172e-14, -2.457142080312765e-16,
  5.951467467663875e-19, -1.922832931070560e-22, -5.356543980301134e-24,  2.669430391163527e-26, -6.529568486037129e-29,  3.642100816621253e-01, -1.640265847190386e-03,
  4.639771983683970e-06, -7.776991163125514e-09, -3.350998856541423e-12,  7.714523858652903e-14, -2.835820252876925e-16,  4.253635592262593e-19,  1.144343901596114e-21,
 -9.705652157395318e-24,  3.024561107953064e-26, -2.377688561084025e-29,  4.194801934237322e-01, -1.850693577994446e-03,  4.928310862491793e-06, -6.566506497690620e-09,
 -1.242447025926745e-11,  1.031680103408105e-13, -2.835754918240995e-16,  6.908637241363699e-20,  2.838686008432946e-21, -1.280270559787191e-23,  2.104017855144765e-26,
  6.498342599434695e-29,  4.784252766003623e-01, -2.062573305223413e-03,  5.114092528597152e-06, -4.731820312642940e-09, -2.279928263966422e-11,  1.238679915557026e-13,
 -2.302421318270272e-16, -4.701523080886153e-19,  4.519539105546677e-21, -1.254654351350471e-23, -5.262823416599141e-27,  1.828510513471878e-28,  5.409541254435727e-01,
 -2.272539763928301e-03,  5.174100314548714e-06, -2.253230320735486e-09, -3.380650700349298e-11,  1.344126702846073e-13, -1.123063431395615e-16, -1.137246636044024e-18,
  5.602665437217517e-21, -6.909504367937991e-24, -4.700470789153463e-26,  2.773551587967189e-28,  6.069549844554698e-01, -2.476824493285306e-03,  5.085722387669626e-06,
  8.505803444899892e-10, -4.450045071930830e-11,  1.296973743782499e-13,  7.283521895655071e-17, -1.812073241161324e-18,  5.368976382632996e-21,  5.070125819783737e-24,
 -9.259640461769241e-26,  2.668557841534245e-28,  6.762912370007887e-01, -2.671232177562136e-03,  4.827767132851175e-06,  4.511675667583505e-09, -5.366156012327439e-11,
  1.050731760234553e-13,  3.140253641005310e-16, -2.307363400541172e-18,  3.153659262910337e-21,  2.201477646629600e-23, -1.190878435132821e-25,  7.231750121468547e-29,
  7.487962366532022e-01, -2.851125333554359e-03,  4.381819362253296e-06,  8.601531132367059e-09, -5.983687913911293e-11,  5.739109062080286e-14,  5.816092411997409e-16,
 -2.387532083482822e-18, -1.341627278231988e-21,  3.908507371809263e-23, -9.676372190936188e-26, -3.199218876566966e-28,  8.242671324736583e-01, -3.011423366672266e-03,
  3.734009522475209e-06,  1.292037525331701e-08, -6.143577795379226e-11, -1.365160706135296e-14,  8.247263536221338e-16, -1.818740269509708e-18, -7.651485977088294e-21,
  4.782444513666020e-23, -2.987012374180822e-27, -7.820052269071531e-28,  9.024575298007019e-01, -3.146624598914736e-03,  2.877261585447592e-06,  1.718916245181395e-08,
 -5.690093074818219e-11, -1.039779742044667e-13,  9.731628852313249e-16, -4.566606768936564e-19, -1.419166537105872e-20,  3.808393417639944e-23,  1.550043165646708e-25,
 -1.009566915956175e-27,  9.830688305833174e-01, -3.250863267293642e-03,  1.814058904612136e-06,  2.104724611347583e-08, -4.497284491808287e-11, -2.036953374369885e-13,
  9.469720080923556e-16,  1.633746679706178e-18, -1.819352477535363e-20,  2.952314501464693e-24,  3.170812447557682e-25, -6.164828439387507e-28,  1.065740122273639e+00,
 -3.318017767493627e-03,  5.597059929472463e-07,  2.406022059430001e-08, -2.505624747462095e-11, -2.962867275452837e-13,  6.769134915640865e-16,  4.056582001848420e-18,
 -1.627559391129794e-20, -5.367416237815001e-23,  3.680988253596542e-25,  5.708031982853043e-28,  1.150036548158232e+00, -3.341891452210683e-03, -8.540537996645913e-07,
  2.574390343299685e-08,  2.328179465955112e-12, -3.592524970839146e-13,  1.366372727036365e-16,  6.028345239454132e-18, -5.954103139882627e-21, -1.101586445411745e-22,
  1.857347822439503e-25,  2.095648717925236e-27,  1.235436219109248e+00, -3.316492556107539e-03, -2.375407502846957e-06,  2.561152452365903e-08,  3.507065936349088e-11,
 -3.672511371891942e-13, -6.180479356250346e-16,  6.490116902568508e-18,  1.200069371450980e-20, -1.280729040747329e-22, -2.486013320109985e-25,  2.701822894213349e-27,
  1.321315951400224e+00, -3.236444006497392e-03, -3.929488479912371e-06,  2.325080528232898e-08,  6.911721336187319e-11, -2.986905012362681e-13, -1.417496416526008e-15,
  4.494048908861040e-18,  3.137276597169172e-20, -7.000552166175268e-23, -7.253367941356838e-25,  1.016314238963370e-27,  1.406936481972872e+00, -3.097554376543702e-03,
 -5.417145658887494e-06,  1.843387403168731e-08,  9.846929679697451e-11, -1.458614015045021e-13, -1.981474578314034e-15, -1.278784389646932e-19,  4.072204079598736e-20,
  6.419750295254453e-23, -8.161513064530035e-25, -2.729956288213140e-27,  1.491428371582175e+00, -2.897573466237394e-03, -6.717115724478389e-06,  1.125320339191661e-08,
  1.158586486357700e-10,  7.341886513848104e-14, -1.991634984340580e-15, -6.062745152307790e-18,  2.869578229328319e-20,  2.037605258943827e-22, -1.873126400150744e-25,
 -5.347935715720129e-27,  1.573780598789869e+00, -2.637132934066731e-03, -7.693744291740015e-06,  2.258329938411769e-09,  1.144015006018117e-10,  3.081649689289595e-13,
 -1.251020539519495e-15, -1.040228395055211e-17, -5.492296879873151e-21,  2.245639322185519e-22,  8.691016118800767e-25, -2.716161852762866e-27,  1.652834872981193e+00,
 -2.320825064778142e-03, -8.212514371771095e-06, -7.458991430777127e-09,  9.027555414508832e-11,  4.795773900928466e-13,  1.122255290800613e-16, -9.880449305764773e-18,
 -4.334034652348150e-20,  5.550936991180724e-23,  1.313197472595814e-24,  4.197468789941265e-27,  1.727289850155792e+00, -1.958293138228546e-03, -8.164777058516164e-06,
 -1.631159416023440e-08,  4.581674631492339e-11,  5.079066939239005e-13,  1.539197908909755e-15, -3.514141554668113e-18, -5.378672644772346e-20, -1.909944136796006e-22,
  3.691110679766034e-25,  6.941067286885483e-27,  1.795720432706703e+00, -1.565095368356324e-03, -7.500485474248759e-06, -2.248328180281514e-08, -8.538941715119854e-12,
  3.590201834281392e-13,  2.232688926656214e-15,  5.161384642925733e-18, -2.169451305538960e-20, -2.599478052613985e-22, -1.051875338363414e-24,  2.825725699316491e-28,
  1.856617618856800e+00, -1.162982728755300e-03, -6.262949440199512e-06, -2.445281134104516e-08, -5.576048191970716e-11,  8.695177048095510e-14,  1.704497971875183e-15,
  9.558256809923283e-18,  2.570939289798971e-20, -5.530749562493843e-23, -1.048700702817864e-24, -6.075410544814764e-27,  1.908453127426279e+00, -7.791562916450953e-04,
 -4.613465047867473e-06, -2.167733008547972e-08, -7.872240882212073e-11, -1.708468587417444e-13,  3.241083091682462e-16,  6.120696639509734e-18,  3.933043402179956e-20,
  1.585315114255797e-22,  2.686736819990093e-25, -1.931594154839920e-27,  1.949769444666577e+00, -4.441347409897291e-04, -2.829315680286769e-06, -1.514126886910470e-08,
 -7.003833248632261e-11, -2.735966208085370e-13, -8.073790459209779e-16, -8.345387345683657e-19,  1.088627200099262e-20,  1.103372225848051e-22,  6.771414210560459e-25,
  3.107549475108918e-27,  1.979289949637812e+00, -1.881567135169135e-04, -1.261449909738157e-06, -7.355183226787783e-09, -3.907593172218501e-11, -1.919858697168274e-13,
 -8.718831785554230e-16, -3.606316714805824e-18, -1.304480373010117e-20, -3.647913806647465e-23, -3.321255387668803e-26,  5.342760695997096e-28,  1.996039970939858e+00,
 -3.653534173287433e-05, -2.520447332318909e-07, -1.539450585321344e-09, -8.771582866928736e-12, -4.769428805182057e-14, -2.503447814147123e-16, -1.276524972783942e-18,
 -6.344895469008552e-21, -3.079039618392193e-23, -1.459141299848483e-25, -6.745523731543341e-28,  4.934730014432106e-04, -2.467093947704843e-06,  9.248537648204101e-09,
 -3.081313659259570e-11,  9.620565477699295e-14, -2.882992406822469e-16,  8.393970153665696e-19, -2.393821773733035e-21,  6.712022554302931e-24, -1.859702571921377e-26,
  5.087457604032845e-29, -1.384172667361930e-31,  4.441079711525220e-03, -2.217970087647139e-05,  8.294627220846186e-08, -2.751691398852482e-10,  8.534178250162124e-13,
 -2.532932304973712e-15,  7.278356016694956e-18, -2.040093922923517e-20,  5.594831229774141e-23, -1.507858748246134e-25,  3.985365009243120e-28, -1.040344836479855e-30,
  1.233533148418738e-02, -6.147573401784672e-05,  2.287902989130016e-07, -7.524417873909124e-10,  2.301973341970068e-12, -6.697187840311195e-15,  1.871586784174325e-17,
 -5.052258374664103e-20,  1.317802418261075e-22, -3.325116060303453e-25,  8.048480103261274e-28, -1.870695231558883e-30,  2.417422746094157e-02, -1.200948611538369e-04,
  4.436694216430680e-07, -1.439862474141303e-09,  4.312269342256753e-12, -1.215210960065703e-14,  3.242742586038657e-17, -8.194696254254089e-20,  1.942818746123122e-22,
 -4.252785087593175e-25,  8.162066941470881e-28, -1.224788801001955e-30,  3.995456980202401e-02, -1.976416275781509e-04,  7.228965676238323e-07, -2.303564415577763e-09,
  6.695323176434153e-12, -1.800708130424532e-14,  4.471271466729301e-17, -1.008215943636802e-19,  1.962982288138801e-22, -2.833931267015574e-25,  3.078327782574600e-29,
  1.838629080662030e-30,  5.967172031428194e-02, -2.935794266699251e-04,  1.060185905651104e-06, -3.298956839788755e-09,  9.209513867444336e-12, -2.317356748503446e-14,
  5.134638696112013e-17, -9.289522451342698e-20,  9.688651505036654e-23,  1.852409533172240e-25, -1.654338756365833e-27,  6.894202790355538e-30,  8.331926310900661e-02,
 -4.072223263306374e-04,  1.447624922974487e-06, -4.371276789883800e-09,  1.156995741306422e-11, -2.645045922484668e-14,  4.815489157757600e-17, -4.669812173355388e-20,
 -1.238386143424983e-22,  9.599926502693629e-25, -3.847007021077447e-27,  1.166202562862684e-29,  1.108885616040205e-01, -5.377246406644185e-04,  1.875644020725270e-06,
 -5.456366772857022e-09,  1.346083295957434e-11, -2.663081883161685e-14,  3.169329661563361e-17,  4.306065686683667e-20, -4.510806976302165e-22,  1.866857039430771e-24,
 -5.603948135728363e-27,  1.232880464872701e-29,  1.423681943852637e-01, -6.840681157267462e-04,  2.332987287674986e-06, -6.481742089976400e-09,  1.455103121663662e-11,
 -2.262905365516700e-14, -1.722216928484569e-20,  1.723105794213203e-19, -8.261446513311660e-22,  2.574214634500398e-24, -5.592001350752243e-27,  4.900213758720373e-30,
  1.777432500053937e-01, -8.450465848393664e-04,  2.806689567697694e-06, -7.368029412577271e-09,  1.451352236603249e-11, -1.362619841969851e-14, -4.674839004224980e-17,
  3.252029171197555e-19, -1.145179177011995e-21,  2.641004803995712e-24, -2.506127832039861e-27, -1.252361879603275e-29,  2.169944555386641e-01, -1.019247947270087e-03,
  3.282066869777116e-06, -8.030878069056819e-09,  1.304881847619851e-11,  7.711802090881699e-16, -1.054005492019549e-16,  4.731290617139136e-19, -1.269409619408117e-21,
  1.626970206101319e-24,  4.285039752286975e-27, -3.712931455232004e-29,  2.600971074214984e-01, -1.205033340669138e-03,  3.742729732250614e-06, -8.383467182317742e-09,
  9.912804990948592e-12,  2.036620276599619e-14, -1.695235817592905e-16,  5.759342216212134e-19, -1.049705290199882e-21, -7.377441557249923e-25,  1.399601561813505e-26,
 -5.954421063786747e-29,  3.070197655434397e-01, -1.400513422497854e-03,  4.170632530022098e-06, -8.339754058981339e-09,  4.948992629215605e-12,  4.421343726379230e-14,
 -2.291637949104926e-16,  5.861087805392213e-19, -3.665900051298095e-22, -4.346058215017356e-24,  2.383722762976810e-26, -6.430861001300522e-29,  3.577226624385882e-01,
 -1.603521763489785e-03,  4.546176123078139e-06, -7.818629577762860e-09, -1.875169000611236e-12,  7.048601552781617e-14, -2.712100546930250e-16,  4.566233543592323e-19,
  8.164344109613422e-22, -8.520076770628182e-24,  2.895700843720241e-26, -3.424036936620677e-29,  4.121557684637912e-01, -1.811585508445390e-03,  4.848386930668413e-06,
 -6.749160085645782e-09, -1.042896021883983e-11,  9.639525631488202e-14, -2.804374421012375e-16,  1.527175353190780e-19,  2.393557910046584e-21, -1.191140271180910e-23,
  2.334679297675308e-26,  4.051890901498733e-29,  4.702564407324065e-01, -2.021893707466831e-03,  5.055202722510197e-06, -5.077094379151468e-09, -2.037816453956301e-11,
  1.182001334477231e-13, -2.414497462386264e-16, -3.327793457474782e-19,  4.065923956798787e-21, -1.260593290476638e-23,  2.054146322840746e-27,  1.500217810819324e-28,
  5.319465680337898e-01, -2.231264108533693e-03,  5.143904335296638e-06, -2.772785318184450e-09, -3.114768271359735e-11,  1.313552201900887e-13, -1.416790999033912e-16,
 -9.622806208771282e-19,  5.322959990593449e-21, -8.552381312022259e-24, -3.531443624086820e-26,  2.533180633039868e-28,  5.971291058570525e-01, -2.436109792777161e-03,
  5.091743170166898e-06,  1.594027902674630e-10, -4.189303160142666e-11,  1.308561209117065e-13,  2.452494695833548e-17, -1.638037222484018e-18,  5.487699670341070e-21,
  1.605146598486846e-24, -8.057471487125462e-26,  2.775771712021924e-28,  6.656838750597635e-01, -2.632407913748176e-03,  4.876826346324227e-06,  3.670290150971509e-09,
 -5.148990169165267e-11,  1.118466138993925e-13,  2.509446599668108e-16, -2.194677649796214e-18,  3.861407767819982e-21,  1.733586067961444e-23, -1.143687602627641e-25,
  1.394848133247201e-28,  7.374624752888660e-01, -2.815674088744395e-03,  4.479333668002795e-06,  7.654059258887655e-09, -5.855490568616103e-11,  7.054392308115325e-14,
  5.143633473556515e-16, -2.408723581546717e-18, -7.304799405673877e-24,  3.496825925433222e-23, -1.082194929459727e-25, -2.022515695943282e-28,  8.122821414978459e-01,
 -2.980947836863182e-03,  3.883150615951971e-06,  1.193627620026135e-08, -6.151513692161485e-11,  5.504649297675089e-15,  7.706320412454301e-16, -2.036129423131379e-18,
 -5.939961694877656e-21,  4.704857960914530e-23, -3.499185900830480e-26, -6.703152812545103e-28,  8.899183519187821e-01, -3.122797053313792e-03,  3.078004516629623e-06,
  1.626337483433674e-08, -5.874822653543386e-11, -8.082551255837304e-14,  9.542326573498617e-16, -8.877481209722067e-19, -1.271977935166216e-20,  4.339268919659764e-23,
  1.104417999050570e-25, -1.008516380159100e-27,  9.700959843797379e-01, -3.235353062378864e-03,  2.062178065600989e-06,  2.029633856407160e-08, -4.881611231698028e-11,
 -1.804846738078693e-13,  9.845993194603759e-16,  1.055645314953843e-18, -1.786607132921632e-20,  1.502888754489363e-23,  2.852561847210566e-25, -8.211375433308783e-28,
  1.052478824868412e+00, -3.312392488694497e-03,  8.458306532867431e-07,  2.361283499146855e-08, -3.081063382073013e-11, -2.787383274696270e-13,  7.829363486114720e-16,
  3.507730802694328e-18, -1.793780256225133e-20, -3.856016481400090e-23,  3.848336088359992e-25,  1.911812397402560e-28,  1.136657274201138e+00, -3.347488086601416e-03,
 -5.451398269566095e-07,  2.572390903602940e-08, -4.810531862266006e-12, -3.539728172486596e-13,  3.021785670416999e-16,  5.775972066450210e-18, -9.764589868941283e-21,
 -1.009662377866712e-22,  2.717107827018843e-25,  1.797411392920353e-27,  1.222134201565580e+00, -3.334257486881935e-03, -2.064947251069195e-06,  2.611315146846003e-08,
  2.759223065987824e-11, -3.798645368549161e-13, -4.316537980567823e-16,  6.798686507683915e-18,  7.240332954627366e-21, -1.355749063523787e-22, -1.251817491073716e-25,
  2.882478683863153e-27,  1.308309096547332e+00, -3.266745541599109e-03, -3.644046565533951e-06,  2.430708659315734e-08,  6.281397239130355e-11, -3.310894973079168e-13,
 -1.278026262845250e-15,  5.452156515506558e-18,  2.834328981994354e-20, -9.788498872996607e-23, -6.627973802859270e-25,  1.817125400801732e-27,  1.394461028609345e+00,
 -3.139980170704131e-03, -5.186590753182189e-06,  1.998346257025047e-08,  9.507699407672711e-11, -1.933106030102055e-13, -1.966510479486027e-15,  1.205682445699667e-18,
  4.241863823382623e-20,  2.937881689722104e-23, -9.187261455790059e-25, -1.899041588145000e-27,  1.479731503724350e+00, -2.950738630273105e-03, -6.570914962743437e-06,
  1.311603593219378e-08,  1.168358480397500e-10,  2.369302177004780e-14, -2.147446392086767e-15, -5.029026448233311e-18,  3.583868802948281e-20,  1.914674983209869e-22,
 -4.291135705823849e-25, -5.590670403075136e-27,  1.563109183311797e+00, -2.698542914036102e-03, -7.655463955083476e-06,  4.136329723205979e-09,  1.202408925829515e-10,
  2.746331519217654e-13, -1.543483348588766e-15, -1.044223957404963e-17,  3.184897096173680e-21,  2.564913330656723e-22,  7.161441937666988e-25, -4.241721918734843e-27,
  1.643419641236284e+00, -2.386857926960200e-03, -8.293039084363169e-06, -5.937800694103353e-09,  9.987082645402668e-11,  4.787964707160052e-13, -1.834688135101597e-16,
 -1.122488314073032e-17, -4.035436067807836e-20,  1.114647620987377e-22,  1.477128419824638e-24,  3.174915847497313e-27,  1.719324820116468e+00, -2.024381064183693e-03,
 -8.355776160811392e-06, -1.549529106811488e-08,  5.633528591204089e-11,  5.434659632198583e-13,  1.415695716654845e-15, -5.341860209478038e-18, -6.031975842403611e-20,
 -1.697502865133734e-22,  7.019809695213785e-25,  8.158587637785943e-27,  1.789338332200913e+00, -1.626180207405155e-03, -7.770858079475111e-06, -2.255950260310475e-08,
 -8.114298580152705e-13,  4.142515594141950e-13,  2.366024094809534e-15,  4.309361143049227e-18, -3.180283922541936e-20, -3.013118123157367e-22, -1.004027595495264e-24,
  1.971503276056490e-27,  1.851863601118050e+00, -1.214275079006686e-03, -6.561671341990075e-06, -2.532875146248007e-08, -5.359021731680928e-11,  1.311621188734844e-13,
  1.983286833718861e-15,  1.034046850991883e-17,  2.289688442361764e-20, -1.028136870733431e-22, -1.331528574608749e-24, -6.748737961993443e-27,  1.905261008773888e+00,
 -8.171261930087999e-04, -4.881261584513613e-06, -2.296374059085703e-08, -8.204692062221337e-11, -1.608641433382816e-13,  5.139795483470787e-16,  7.472472395045642e-18,
  4.520742821137951e-20,  1.672329244785661e-22,  1.572015893405167e-25, -3.195144588557722e-27,  1.947946458463631e+00, -4.675155205075536e-04, -3.017918590670295e-06,
 -1.630671765819046e-08, -7.570570888750180e-11, -2.932108942342564e-13, -8.252330752442230e-16, -4.171203755869521e-19,  1.538019015344457e-20,  1.402986224697807e-22,
  8.244285446128866e-25,  3.587510896043885e-27,  1.978516565191849e+00, -1.986122896221992e-04, -1.353593887298008e-06, -8.012288005560632e-09, -4.313332916567635e-11,
 -2.141711798072989e-13, -9.789030808726762e-16, -4.044967800834982e-18, -1.437552548163917e-20, -3.725088598631578e-23, -3.037797550373188e-27,  8.557023738215012e-28,
  1.995889676392336e+00, -3.862805377566050e-05, -2.713927821255181e-07, -1.687766025690542e-09, -9.788569605244733e-12, -5.415548431023359e-14, -2.891050118732213e-16,
 -1.498484079176988e-18, -7.565970202591344e-21, -3.726603000345646e-23, -1.790578126542409e-25, -8.381127920208227e-28,  4.837502968304233e-04, -2.394558940352425e-06,
  8.887828958831735e-09, -2.931890178127765e-11,  9.063581891865431e-14, -2.689343706148238e-16,  7.752790773524410e-19, -2.189367793428130e-21,  6.077737958101144e-24,
 -1.667878628508991e-26,  4.515846353474186e-29, -1.217893038788091e-31,  4.353667458233004e-03, -2.152911047721433e-05,  7.972452912744965e-08, -2.619104235178790e-10,
  8.044607397018872e-13, -2.364909074975229e-15,  6.731399936685173e-18, -1.869445654429824e-20,  5.079626704041737e-23, -1.357237081168937e-25,  3.554392547106111e-28,
 -9.212146799755227e-31,  1.209303287805622e-02, -5.968091271910671e-05,  2.199776445231305e-07, -7.166578310235775e-10,  2.172409224795447e-12, -6.264516925339758e-15,
  1.735851687519768e-17, -4.649108691710266e-20,  1.203699855431237e-22, -3.019084059504697e-25,  7.266497379706156e-28, -1.686995989488255e-30,  2.370083892942447e-02,
 -1.166134644424939e-04,  4.267971642897701e-07, -1.372768984512837e-09,  4.076827448260182e-12, -1.140069695995102e-14,  3.021769189715465e-17, -7.596870687205937e-20,
  1.795465911789594e-22, -3.937010920366604e-25,  7.628593431145254e-28, -1.198059941937284e-30,  3.917539710128714e-02, -1.919672319978752e-04,  6.958848472625901e-07,
 -2.199263019555382e-09,  6.345687566955172e-12, -1.696715180806404e-14,  4.197612047940596e-17, -9.470289758834490e-20,  1.861365281445265e-22, -2.806753981334710e-25,
  1.019939201149727e-28,  1.411499678186174e-30,  5.851411835192898e-02, -2.852538191584349e-04,  1.021467456836458e-06, -3.155246311003598e-09,  8.758156799391565e-12,
 -2.197211093217640e-14,  4.878964064721960e-17, -8.970035407951822e-20,  1.024343413240470e-22,  1.248255046353462e-25, -1.373817891144780e-27,  5.880056071448702e-30,
  8.171320797578374e-02, -3.958480410033078e-04,  1.396263062277475e-06, -4.190327202995969e-09,  1.105239730863028e-11, -2.531084930051236e-14,  4.679685390749736e-17,
 -5.013672050272009e-20, -9.192864999312803e-23,  8.159822981460657e-25, -3.363019505411344e-27,  1.035640301630774e-29,  1.087672637777519e-01, -5.229777729655687e-04,
  1.811442417998317e-06, -5.245212667085854e-09,  1.293591246387240e-11, -2.585728186150164e-14,  3.270671192719506e-17,  2.965916998160951e-20, -3.877799061601163e-22,
  1.653332814232815e-24, -5.077729148804834e-27,  1.157890577376354e-29,  1.396687626488176e-01, -6.657114175535522e-04,  2.256588350699033e-06, -6.252544673820153e-09,
  1.409882172939504e-11, -2.257447387554547e-14,  4.450987659042718e-18,  1.473139698461808e-19, -7.374441722270878e-22,  2.355173817792095e-24, -5.352683066297073e-27,
  5.911594694334475e-30,  1.744074162742892e-01, -8.229428071243073e-04,  2.719657330420024e-06, -7.138051183819449e-09,  1.423049531332828e-11, -1.464294543517767e-14,
 -3.814159935055465e-17,  2.900580471275987e-19, -1.052029623790993e-21,  2.530891668775033e-24, -2.972338893136468e-27, -8.788879408898616e-30,  2.129693714839607e-01,
 -9.933733448792901e-04,  3.186949095398936e-06, -7.822106604610306e-09,  1.303999551627203e-11, -1.603996566960720e-15, -9.271260791508934e-17,  4.334750884323028e-19,
 -1.208129799668222e-21,  1.767596162820450e-24,  2.791841647905790e-27, -3.087034283343027e-29,  2.553362244365867e-01, -1.175491183405559e-03,  3.643092495784346e-06,
 -8.221819354443801e-09,  1.028072989809770e-11,  1.648733416585933e-14, -1.538709429639789e-16,  5.420217526535488e-19, -1.066800671510568e-21, -2.283624564873002e-25,
  1.152078027257842e-26, -5.299611067081898e-29,  3.014838101392251e-01, -1.367547259035965e-03,  4.071058812671989e-06, -8.253789302421444e-09,  5.779583917642473e-12,
  3.890897502231286e-14, -2.129392221315279e-16,  5.720530943433249e-19, -5.065618341412320e-22, -3.448551259084832e-24,  2.105535515206247e-26, -6.194857338256432e-29,
  3.513807194050717e-01, -1.567528053908023e-03,  4.452217939097687e-06, -7.837703780582902e-09, -5.294893976827159e-13,  6.413307639391196e-14, -2.581033728080043e-16,
  4.780621464564640e-19,  5.301756335106756e-22, -7.394299792511403e-24,  2.727837464493720e-26, -4.158915858253486e-29,  4.049864838702059e-01, -1.773125065208577e-03,
  4.766458270097461e-06, -6.900964293985455e-09, -8.567970642106575e-12,  8.972433620393244e-14, -2.751521983699393e-16,  2.226337608019862e-19,  1.981928650590907e-21,
 -1.094820242860342e-23,  2.466353036214306e-26,  1.996290026660447e-29,  4.622493556959897e-01, -1.981701151473736e-03,  4.992398270337725e-06, -5.384550749810654e-09,
 -1.807279034561330e-11,  1.123078096114825e-13, -2.490140721859643e-16, -2.099025821523322e-19,  3.615095928753895e-21, -1.240096860616705e-23,  7.970185197381624e-27,
  1.192919321058972e-28,  5.231035916382956e-01, -2.190254241300749e-03,  5.107726805725365e-06, -3.250324974273681e-09, -2.855666551174812e-11,  1.276505496248647e-13,
 -1.662863764259344e-16, -7.971233662246649e-19,  4.992262698285944e-21, -9.749913953840497e-24, -2.476175051026131e-26,  2.259457440379094e-28,  5.874661308667591e-01,
 -2.395379391953378e-03,  5.089720699501402e-06, -4.899319921150790e-10, -3.927363556272037e-11,  1.309142144008882e-13, -1.887721495888071e-17, -1.462104364311187e-18,
  5.490421571898593e-21, -1.372952781321324e-24, -6.833323484296514e-26,  2.772025464699670e-28,  6.552325320229346e-01, -2.593230962273424e-03,  4.916001619861173e-06,
  2.864653778919722e-09, -4.919764572908532e-11,  1.171463823078359e-13,  1.913111976977478e-16, -2.061997077914108e-18,  4.404781575920144e-21,  1.290002067186569e-23,
 -1.070518828955056e-25,  1.904861276731182e-28,  7.262720076427169e-01, -2.779487840019641e-03,  4.565609777198638e-06,  6.729115608483348e-09, -5.702603831685318e-11,
  8.208041880009179e-14,  4.470990151515278e-16, -2.389666524052213e-18,  1.171786224392084e-21,  3.049388330256783e-23, -1.147195283795298e-25, -9.523361243998468e-29,
  8.004213641145634e-01, -2.949326407997070e-03,  4.020487311578397e-06,  1.095389990713948e-08, -6.122481459177138e-11,  2.329575387634540e-14,  7.112116917686550e-16,
 -2.199433926227320e-18, -4.278192305534526e-21,  4.509458418782445e-23, -6.181401598528072e-26, -5.477002475605129e-28,  8.774776250831156e-01, -3.097408469522099e-03,
  3.267475845691509e-06,  1.531170618705316e-08, -6.013796583955465e-11, -5.826673511527784e-14,  9.239176685982141e-16, -1.269020522416908e-18, -1.108873402294956e-20,
  4.693273211306219e-23,  6.687472356914284e-26, -9.654754909630234e-28,  9.571890904044874e-01, -3.217894957535512e-03,  2.300932845327212e-06,  1.948769603131256e-08,
 -5.218743923167498e-11, -1.565636201798748e-13,  1.006250001278040e-15,  4.947162364139065e-19, -1.712879711097056e-20,  2.566871375408985e-23,  2.456556352995432e-25,
 -9.693273288121577e-28,  1.039244570398223e+00, -3.304501224769237e-03,  1.126046280564732e-06,  2.307631987819449e-08, -3.618988038985268e-11, -2.588352968087181e-13,
  8.729292323819289e-16,  2.914491315365392e-18, -1.904785078309250e-20, -2.310692539505942e-23,  3.851950347764193e-25, -1.700757017315703e-28,  1.123260552081536e+00,
 -3.350616301256363e-03, -2.371469266171049e-07,  2.559075322608795e-08, -1.180456189401730e-11, -3.448183936130925e-13,  4.590006397130941e-16,  5.407594688792441e-18,
 -1.318563940796926e-20, -8.862212110503258e-23,  3.427485466172412e-25,  1.420744948341791e-27,  1.208766126891502e+00, -3.349516709261285e-03, -1.749192935349602e-06,
  2.649335109304601e-08,  1.990687849641060e-11, -3.879182264440217e-13, -2.387860845222765e-16,  6.951568994949363e-18,  2.300256295582195e-21, -1.380275446105945e-22,
  2.708131780357734e-27,  2.904234550421518e-27,  1.295185680418214e+00, -3.294714602384864e-03, -3.346555156351942e-06,  2.525752299057054e-08,  5.589833684233435e-11,
 -3.598311485566278e-13, -1.113233349422883e-15,  6.297812875644394e-18,  2.436349162219078e-20, -1.225788759109429e-22, -5.666697258313618e-25,  2.533999312554346e-27,
  1.381819677318900e+00, -3.180488140007992e-03, -4.937797664418528e-06,  2.147121469701082e-08,  9.074234992010022e-11, -2.399476394761283e-13, -1.913640253547548e-15,
  2.572761948825865e-18,  4.279723772280606e-20, -8.755519306223250e-24, -9.806369635741370e-25, -8.903765629856505e-28,  1.467824456271835e+00, -3.002644583307356e-03,
 -6.402299848591417e-06,  1.498635464971546e-08,  1.167836118194934e-10, -2.939961321842461e-14, -2.271193585729680e-15, -3.775697379193173e-18,  4.236325469923125e-20,
  1.693862724667498e-22, -6.742201658700364e-25, -5.490206037842297e-27,  1.552192885299225e+00, -2.759554972453589e-03, -7.594110405392957e-06,  6.102013514761031e-09,
  1.253395330323195e-10,  2.341011957003706e-13, -1.833013921548385e-15, -1.018744713315725e-17,  1.288515087674717e-20,  2.809574268366574e-22,  4.962427194281676e-25,
 -5.738596521615160e-27,  1.633739108937529e+00, -2.453459363528357e-03, -8.354390160844091e-06, -4.263608713500503e-09,  1.093765284151179e-10,  4.704798588836860e-13,
 -5.151582800033923e-16, -1.244036609585950e-17, -3.524809074002477e-20,  1.729348046982669e-22,  1.585367154449047e-24,  1.663870896735018e-27,  1.711092448535676e+00,
 -2.091954886450308e-03, -8.535946947299519e-06, -1.450518072113522e-08,  6.753110635522469e-11,  5.754242440559247e-13,  1.238224486685118e-15, -7.363728522140100e-18,
 -6.583601553826674e-20, -1.341871615284413e-22,  1.083095852744739e-24,  9.105851710862407e-27,  1.782707563663882e+00, -1.689429498972679e-03, -8.041366501034775e-06,
 -2.250308111079647e-08,  8.050582886841616e-12,  4.723587888628482e-13,  2.470753730130000e-15,  3.110568804107898e-18, -4.334661124092877e-20, -3.391327792694801e-22,
 -8.711610759869030e-25,  4.148829306303381e-27,  1.846899568781414e+00, -1.267998589688471e-03, -6.870665803541190e-06, -2.616252291118008e-08, -5.046712191774694e-11,
  1.823143933762071e-13,  2.282444631921212e-15,  1.100307882065212e-17,  1.816397174674587e-20, -1.621580942987398e-22, -1.638669815116980e-24, -7.154789518421554e-27,
  1.901912626749757e+00, -8.573011017893697e-04, -5.164806773658597e-06, -2.430148520385386e-08, -8.512303225297414e-11, -1.458488144665425e-13,  7.443736966004906e-16,
  9.016348081865989e-18,  5.130300752948178e-20,  1.702520313526934e-22, -1.831265102047910e-26, -4.852767356370315e-27,  1.946026840706195e+00, -4.924626363206965e-04,
 -3.221063963902899e-06, -1.756600175574755e-08, -8.176862065647677e-11, -3.130961234773441e-13, -8.292156186086654e-16,  1.625393863556037e-19,  2.106383487484644e-20,
  1.765710445196261e-22,  9.925404458161353e-25,  4.046210253067802e-27,  1.977699832594193e+00, -2.098376968388783e-04, -1.454027738333572e-06, -8.738004609767532e-09,
 -4.766113739301273e-11, -2.390771828281785e-13, -1.098803722450079e-15, -4.526383817844832e-18, -1.570857643436424e-20, -3.649715913068292e-23,  4.401279536310819e-26,
  1.307964137422209e-27,  1.995730689751989e+00, -4.088295613134439e-05, -2.926226811142353e-07, -1.853439783954868e-09, -1.094460989528683e-11, -6.162614468010292e-14,
 -3.346640940241483e-16, -1.763518171786024e-18, -9.045870402148232e-21, -4.522298865255989e-23, -2.202858486243057e-25, -1.043652515486294e-27,  4.743120723691790e-04,
 -2.324839365338502e-06,  8.544528898153536e-09, -2.791076766833358e-11,  8.543834426979470e-14, -2.510418658301404e-16,  7.166117662764616e-19, -2.004148751552523e-21,
  5.508564653555173e-24, -1.497521865931650e-26,  4.012522409041120e-29, -1.073262127093705e-31,  4.268807007842421e-03, -2.090367066970611e-05,  7.665729939124097e-08,
 -2.494088341126222e-10,  7.587366256332341e-13, -2.209457553128920e-15,  6.229996458000871e-18, -1.714448622832581e-20,  4.615665199120744e-23, -1.222850748061458e-25,
  3.172525831501901e-28, -8.168144606224517e-31,  1.185777522533067e-02, -5.795490962067202e-05,  2.115822393868805e-07, -6.828794055199292e-10,  2.051181696130688e-12,
 -5.863108113330730e-15,  1.610909743544945e-17, -4.280767906542684e-20,  1.100070381789640e-22, -2.742771112385238e-25,  6.561163921127103e-28, -1.522020152212028e-30,
  2.324111103881322e-02, -1.132638882189653e-04,  4.107079131418447e-07, -1.309325164691208e-09,  3.855896758641351e-12, -1.070036148751453e-14,  2.816891566079181e-17,
 -7.044420101689508e-20,  1.659099987155175e-22, -3.642307441585399e-25,  7.109274881539093e-28, -1.161125185991941e-30,  3.841849759004678e-02, -1.865040172565712e-04,
  6.700918535867711e-07, -2.100392915493840e-09,  6.016207452549496e-12, -1.599088132581259e-14,  3.940631578098111e-17, -8.890729546166416e-20,  1.761196161550990e-22,
 -2.754624630287352e-25,  1.560794477794374e-28,  1.057973774233226e-30,  5.738921007550063e-02, -2.772311820964971e-04,  9.844309863342483e-07, -3.018568565504929e-09,
  8.330222584671684e-12, -2.083092468779583e-14,  4.632452410956790e-17, -8.636067172962331e-20,  1.059988012361803e-22,  7.477868759461779e-26, -1.134943553108184e-27,
  4.998238747872093e-30,  8.015184174979365e-02, -3.848761040371846e-04,  1.347023657174712e-06, -4.017478041791892e-09,  1.055729625138334e-11, -2.420487692253621e-14,
  4.535607774965878e-17, -5.263352434149289e-20, -6.486812554107900e-23,  6.902161132392896e-25, -2.933974396380035e-27,  9.163912499227360e-30,  1.067039420443380e-01,
 -5.087345242860876e-04,  1.749724786649215e-06, -5.042332325390740e-09,  1.242667668602398e-11, -2.506370388688845e-14,  3.337211735123399e-17,  1.816431523586956e-20,
 -3.317952263443755e-22,  1.460179758148626e-24, -4.585768029817218e-27,  1.077691269166135e-29,  1.370415525675834e-01, -6.479550322815132e-04,  2.182896424866029e-06,
 -6.030568282439287e-09,  1.364872114275694e-11, -2.242074239802069e-14,  8.257858427504157e-18,  1.250315358401844e-19, -6.564471613537574e-22,  2.146483462210310e-24,
 -5.077114915617949e-27,  6.560750588179326e-30,  1.711586225059638e-01, -8.015243268100228e-04,  2.635357025692738e-06, -6.912753172739645e-09,  1.392912096630740e-11,
 -1.546460510534611e-14, -3.047775381196108e-17,  2.578272473099843e-19, -9.631421271100374e-22,  2.405207704353438e-24, -3.289669741911772e-27, -5.740818781269484e-30,
  2.090462798130470e-01, -9.682496695577042e-04,  3.094334216545393e-06, -7.613840164194585e-09,  1.298662535511076e-11, -3.687760620583454e-15, -8.110684258519230e-17,
  3.958520676304302e-19, -1.142798227227835e-21,  1.853777429680100e-24,  1.557298484745138e-27, -2.536720697215174e-29,  2.506919283038558e-01, -1.146738270627276e-03,
  3.545427859222773e-06, -8.054885259738969e-09,  1.057475690305579e-11,  1.297268876511493e-14, -1.391728882472692e-16,  5.078370864535495e-19, -1.067271609327154e-21,
  1.877081157486734e-25,  9.328617327087959e-27, -4.670014354384408e-29,  2.960781330511911e-01, -1.335373341009760e-03,  3.972592976365086e-06, -8.155362784903749e-09,
  6.507945488526281e-12,  3.398870277107529e-14, -1.971662104801214e-16,  5.540140199770998e-19, -6.161984316471000e-22, -2.659928794698484e-24,  1.840009686292195e-26,
 -5.861351675284755e-29,  3.451812469334499e-01, -1.532286568879477e-03,  4.358155912861943e-06, -7.836246302954968e-09,  6.923204569715804e-13,  5.810090291743110e-14,
 -2.445186517854923e-16,  4.909755626004587e-19,  2.831656830838569e-22, -6.341329467545904e-24,  2.533573317804993e-26, -4.632092250347679e-29,  3.979697193551906e-01,
 -1.735326841760992e-03,  4.682882235298494e-06, -7.024052485120255e-09, -6.838979994477456e-12,  8.320229770364507e-14, -2.680884348393012e-16,  2.799411159857131e-19,
  1.605714781146808e-21, -9.949315732444791e-24,  2.515802356878084e-26,  3.100220093455487e-30,  4.544020135190081e-01, -1.942025170956759e-03,  4.926121739880406e-06,
 -5.656072628500924e-09, -1.588680777251996e-11,  1.062736067370632e-13, -2.533383999233210e-16, -1.012911842982145e-19,  3.175587136507643e-21, -1.198564761306346e-23,
  1.259158868954109e-26,  9.125031124174349e-29,  5.144240405655193e-01, -2.149556017283044e-03,  5.066064993151914e-06, -3.687031640011146e-09, -2.604527922960763e-11,
  1.234095644780984e-13, -1.864233162672962e-16, -6.431591310043575e-19,  4.625756222615382e-21, -1.055002919287027e-23, -1.545570233385878e-26,  1.969022744638782e-28,
  5.779659967762983e-01, -2.354695626759840e-03,  5.080157533052093e-06, -1.097402065516831e-09, -3.666309551458461e-11,  1.299896835980902e-13, -5.736748216300926e-17,
 -1.287705488270123e-18,  5.394716149904632e-21, -3.864507911655183e-24, -5.631255136614284e-26,  2.678956035938082e-28,  6.449384632582356e-01, -2.553778648105771e-03,
  4.945732562993609e-06,  2.096464999779323e-09, -4.681339597364217e-11,  1.210613477029734e-13,  1.356126429262466e-16, -1.914422988456731e-18,  4.794232197927463e-21,
  8.797148787151124e-24, -9.783188454463113e-26,  2.261828998763602e-28,  7.152275957229844e-01, -2.742655346897799e-03,  4.640940664495894e-06,  5.830392218822018e-09,
 -5.528251985403220e-11,  9.201308690482854e-14,  3.808719924982701e-16, -2.335496988768325e-18,  2.186220141413276e-21,  2.584987324470481e-23, -1.167996585584476e-25,
 -1.715312261539135e-30,  7.886891953197713e-01, -2.916653334128556e-03,  4.146074849778899e-06,  9.978936416438172e-09, -6.059327067562772e-11,  3.961183657509957e-14,
  6.479512992193137e-16, -2.310883721026553e-18, -2.704763335294132e-21,  4.217716954528492e-23, -8.313654414932119e-26, -4.214613279201814e-28,  8.651414113082665e-01,
 -3.070550139187143e-03,  3.445408487096228e-06,  1.434136806233604e-08, -6.108463898070974e-11, -3.655762123422829e-14,  8.836745463657263e-16, -1.596392390589634e-18,
 -9.361060583998616e-21,  4.877866672809550e-23,  2.598653056281291e-26, -8.881028849050618e-28,  9.443557862218007e-01, -3.198566509779718e-03,  2.529676132158637e-06,
  1.862896258133013e-08, -5.507640585803666e-11, -1.323084136788761e-13,  1.012580302029054e-15, -3.680897434908464e-20, -1.603841730225227e-20,  3.461120791700893e-23,
  2.008125840704445e-25, -1.059498361136428e-27,  1.026046321633803e+00, -3.294395420719540e-03,  1.399320819352144e-06,  2.245703294216347e-08, -4.115083208616096e-11,
 -2.369752659629322e-13,  9.458975843424857e-16,  2.294603604155308e-18, -1.960506714128999e-20, -7.947467849489248e-24,  3.704144794638811e-25, -4.943335142363864e-28,
  1.109856232204168e+00, -3.351288851338615e-03,  6.858337134994507e-08,  2.534735841533511e-08, -1.857876375687402e-11, -3.320359561485547e-13,  6.040460388136639e-16,
  4.937368858724913e-18, -1.611530857676832e-20, -7.378523365021669e-23,  3.959719502747277e-25,  9.922962478777840e-28,  1.195342093326880e+00, -3.362233748550402e-03,
 -1.429618515503034e-06,  2.674954912554211e-08,  1.210699499208582e-11, -3.913096320013402e-13, -4.385705329798309e-17,  6.945942678249725e-18, -2.636231523530213e-21,
 -1.353923262243496e-22,  1.280621295078725e-25,  2.768427788976194e-27,  1.281955217430270e+00, -3.320260034255259e-03, -3.038340663466697e-06,  2.609293322645108e-08,
  4.844925875751599e-11, -3.843488136926377e-13, -9.266730128928464e-16,  7.002693707340119e-18,  1.957120209046327e-20, -1.428331964942905e-22, -4.418061897147483e-25,
  3.115498642886232e-27,  1.369020386152501e+00, -3.218935601898592e-03, -4.671598197509007e-06,  2.288223255703661e-08,  8.549075606189617e-11, -2.848563661839525e-13,
 -1.822531464664540e-15,  3.929602550998383e-18,  4.176948599158055e-20, -4.843956108440390e-23, -9.953676859720421e-25,  2.339018260962500e-28,  1.455712624865529e+00,
 -3.053111936026466e-03, -6.211281454751989e-06,  1.684719374586102e-08,  1.156427846921847e-10, -8.501827128095477e-14, -2.357057471696285e-15, -2.328178006065406e-18,
  4.791848195473807e-20,  1.376989574909353e-22, -9.066591152215755e-25, -5.011439514689190e-27,  1.541033671975327e+00, -2.819980526868190e-03, -7.508707146620591e-06,
  8.142415959128781e-09,  1.295588093896661e-10,  1.867419420976467e-13, -2.110945021696948e-15, -9.609978520790951e-18,  2.329230499759508e-20,  2.953476312469602e-22,
  2.135257531315991e-25, -7.073839520379498e-27,  1.623791320143783e+00, -2.520468677449690e-03, -8.394745306949400e-06, -2.439099895228938e-09,  1.186336401530641e-10,
  4.538148330898405e-13, -8.782558225119435e-16, -1.345634471304586e-17, -2.786829684794561e-20,  2.372615955860733e-22,  1.616480925816962e-24, -3.247764500878120e-28,
  1.702586978542847e+00, -2.160919457472925e-03, -8.703141321456021e-06, -1.333107493546888e-08,  7.931881604397802e-11,  6.024252108903312e-13,  1.001883543695453e-15,
 -9.538615849765423e-18, -6.978861500493397e-20, -8.266521383810644e-23,  1.496624684683826e-24,  9.600146148200134e-27,  1.775819477634374e+00, -1.754837650063090e-03,
 -8.310308351339015e-06, -2.229544586962281e-08,  1.809693555242345e-11,  5.325337764476196e-13,  2.536549323484516e-15,  1.521812566737945e-18, -5.613188552386864e-20,
 -3.695807031638546e-22, -6.319201861106240e-25,  6.799535932287465e-27,  1.841715636429043e+00, -1.324233147294355e-03, -7.189330664736942e-06, -2.693774439377909e-08,
 -4.624777749354146e-11,  2.408499183385991e-13,  2.597696927206520e-15,  1.147765418568516e-17,  1.107025042423893e-20, -2.340288095863276e-22, -1.954605862801989e-24,
 -7.115565143566320e-27,  1.898398905550300e+00, -8.998093956771045e-04, -5.464689280458454e-06, -2.568572962132190e-08, -8.783992704852601e-11, -1.247631938797379e-13,
  1.020732998984769e-15,  1.075551604070607e-17,  5.736216042113527e-20,  1.646630169786187e-22, -2.764821576958455e-25, -6.960077496853225e-27,  1.944004086085928e+00,
 -5.190970400987188e-04, -3.439915910906703e-06, -1.892547336749234e-08, -8.822876664427565e-11, -3.328603620965778e-13, -8.142156328841160e-16,  9.463049611272944e-19,
  2.817902816967464e-20,  2.199526615472186e-22,  1.179287727534105e-24,  4.421912222603888e-27,  1.976836534481694e+00, -2.219026797207089e-04, -1.563621815362133e-06,
 -9.540312125878653e-09, -5.271695844138521e-11, -2.670273382672769e-13, -1.232774311277005e-15, -5.049618342733950e-18, -1.697538756481967e-20, -3.341510032953572e-23,
  1.146668275691063e-25,  1.937300508701143e-27,  1.995562330773237e+00, -4.331597621660365e-05, -3.159567752808364e-07, -2.038867524468080e-09, -1.226162749221151e-11,
 -7.028490230921899e-14, -3.883525649971923e-16, -2.080829114447596e-18, -1.084421749696674e-20, -5.502468293875678e-23, -2.716812924546042e-25, -1.302332702183420e-27,
  4.651473384646229e-04, -2.257799987377504e-06,  8.217639055237148e-09, -2.658300512420989e-11,  8.058504923755359e-14, -2.344971457354417e-16,  6.628845484499548e-19,
 -1.836199646937079e-21,  4.997243975398131e-24, -1.346082500983204e-26,  3.568609370610601e-29, -9.474085519775110e-32,  4.186400173875087e-03, -2.030218082864467e-05,
  7.373579973262441e-08, -2.376145976595989e-10,  7.160046356534360e-13, -2.065535264891938e-15,  5.769984279582428e-18, -1.573552899443579e-20,  4.197440444326052e-23,
 -1.102859606727678e-25,  2.833692278974017e-28, -7.253340271091682e-31,  1.162928977991694e-02, -5.629448077306324e-05,  2.035807972604058e-07, -6.509779899044916e-10,
  1.937690647177355e-12, -5.490484315249741e-15,  1.495831655424574e-17, -3.944050053362909e-20,  1.005897356282938e-22, -2.493271333660835e-25,  5.924588201607914e-28,
 -1.374220120087870e-30,  2.279452876335255e-02, -1.100400397470059e-04,  3.953592321945512e-07, -1.249306802113536e-09,  3.648493351021137e-12, -1.004738875465249e-14,
  2.626887304921828e-17, -6.533948880160424e-20,  1.532973595503814e-22, -3.368030145854708e-25,  6.607755397962631e-28, -1.117712009601394e-30,  3.768304563940972e-02,
 -1.812424888558390e-04,  6.454543047015626e-07, -2.006641586486122e-09,  5.705648952678637e-12, -1.507437486756356e-14,  3.699433138421502e-17, -8.342884361160848e-20,
  1.663257353410917e-22, -2.683784101295342e-25,  1.959936400405622e-28,  7.654122078962180e-31,  5.629580998923474e-02, -2.694983909510221e-04,  9.489943099510635e-07,
 -2.888558360149665e-09,  7.924528101052343e-12, -1.974776781862814e-14,  4.395425742093169e-17, -8.293398328732253e-20,  1.079245362975774e-22,  3.354595576010638e-26,
 -9.322744211676737e-28,  4.231666811112570e-30,  7.863358838980469e-02, -3.742899185508726e-04,  1.299811636100009e-06, -3.852375442756958e-09,  1.008396368104457e-11,
 -2.313422831515354e-14,  4.385685658241967e-17, -5.433362119016925e-20, -4.203862298397900e-23,  5.805944811669578e-25, -2.555008016743500e-27,  8.079014785754256e-30,
  1.046966210484965e-01, -4.949754157017824e-04,  1.690393359047504e-06, -4.847472021846432e-09,  1.193344711410501e-11, -2.425782230366858e-14,  3.373972930953817e-17,
  8.353442433189703e-21, -2.824184331632119e-22,  1.285990486905080e-24, -4.129716604842384e-27,  9.950536032418019e-30,  1.344842056543386e-01, -6.307776497118199e-04,
  2.111825123049156e-06, -5.815764146196319e-09,  1.320255978258884e-11, -2.218284689922358e-14,  1.147599373614695e-17,  1.052229782879486e-19, -5.827585423317352e-22,
  1.949296682354482e-24, -4.779623149519810e-27,  6.918788942690993e-30,  1.679941708593744e-01, -7.807695177883419e-04,  2.553730854413210e-06, -6.692398924213719e-09,
  1.361308129244826e-11, -1.611284487618506e-14, -2.367724527212209e-17,  2.283662549505967e-19, -8.789770767411637e-22,  2.269330952237538e-24, -3.486322263445695e-27,
 -3.289325737476228e-30,  2.052222168090592e-01, -9.438569340652488e-04,  3.004212084211500e-06, -7.406746268575524e-09,  1.289428119942259e-11, -5.505388864833735e-15,
 -7.052485214984031e-17,  3.603602276023099e-19, -1.075196604432574e-21,  1.895205118074644e-24,  5.489274547501350e-28, -2.058272663710461e-29,  2.461610939810621e-01,
 -1.118758587348949e-03,  3.449792399919843e-06, -7.883790235252825e-09,  1.080194105007738e-11,  9.799322175242738e-15, -1.254300809375741e-16,  4.738606193215454e-19,
 -1.054276512093347e-21,  5.215311706649424e-25,  7.405715997585015e-27, -4.077268347029631e-29,  2.907995839322943e-01, -1.303982234432888e-03,  3.875374999739033e-06,
 -8.046049336340609e-09,  7.141644284345621e-12,  2.944055073176505e-14, -1.819432865000274e-16,  5.329006225346459e-19, -6.993190793143717e-22, -1.974370716935749e-24,
  1.590680727763306e-26, -5.463612203795270e-29,  3.391212359775229e-01, -1.497797186822878e-03,  4.264224746549338e-06, -7.816187193623119e-09,  1.796771993297568e-12,
  5.239824294582297e-14, -2.306774259754319e-16,  4.965758072443465e-19,  7.261989942951430e-23, -5.369563918835303e-24,  2.323376805345503e-26, -4.890577319307366e-29,
  3.911028018136472e-01, -1.698202674390560e-03,  4.597990852032701e-06, -7.120510619387751e-09, -5.238611729826496e-12,  7.686771773874095e-14, -2.595831840875178e-16,
  3.257874139236733e-19,  1.265647403115395e-21, -8.944466551244978e-24,  2.498634634973810e-26, -1.037314923569602e-29,  4.467122950312290e-01, -1.902891850349965e-03,
  4.856792803122744e-06, -5.893588891828172e-09, -1.382230891538121e-11,  1.001705391948150e-13, -2.548160201035112e-16, -6.471527053560735e-21,  2.754067889183973e-21,
 -1.140927218402263e-23,  1.604501447675475e-26,  6.624084142123355e-29,  5.059065835657732e-01, -2.109211373198532e-03,  5.019400913510894e-06, -4.084259499847448e-09,
 -2.362320327813868e-11,  1.187356753621297e-13, -2.024172849837211e-16, -5.013146388052305e-19,  4.236836177871306e-21, -1.100364046715140e-23, -7.438774335710350e-27,
  1.675489669780421e-28,  5.686283995684167e-01, -2.314116817117689e-03,  5.063554569312589e-06, -1.663299961363208e-09, -3.407989033821172e-11,  1.281995587503548e-13,
 -9.103028483746830e-17, -1.117712454934559e-18,  5.217851016081269e-21, -5.885585385814597e-24, -4.485911375755923e-26,  2.517538201229076e-28,  6.348026219857617e-01,
 -2.514124705452583e-03,  4.966476481255274e-06,  1.366979408792977e-09, -4.436387315699902e-11,  1.236904070693268e-13,  8.419895580696738e-17, -1.756675736738613e-18,
  5.042957842613632e-21,  5.090281787979146e-24, -8.735294296221644e-26,  2.479761156279644e-28,  7.043316514556711e-01, -2.705262856623859e-03,  4.705660526271250e-06,
  4.961068571131594e-09, -5.335610135729891e-11,  1.003780207648011e-13,  3.165909806945774e-16, -2.251548788331462e-18,  3.032923953699168e-21,  2.120057402434635e-23,
 -1.150945517297313e-25,  7.663904559370760e-29,  7.770896543983684e-01, -2.883022162162399e-03,  4.260033953054174e-06,  9.016604750135563e-09, -5.965081139599260e-11,
  5.437780957953677e-14,  5.822583088245777e-16, -2.373817978703998e-18, -1.250377471547082e-21,  3.851757527333755e-23, -9.894260383118038e-26, -2.978950366670999e-28,
  8.529154037108571e-01, -3.042315148804130e-03,  3.611620340167469e-06,  1.335930114504229e-08, -6.160749816619275e-11, -1.591804167530258e-14,  8.350467903029818e-16,
 -1.867723943294217e-18, -7.595476446044849e-21,  4.906539597227387e-23, -1.089736752596389e-26, -7.848959565344294e-28,  9.316033893982658e-01, -3.177450083837072e-03,
  2.747853298322417e-06,  1.772788976758058e-08, -5.747993298771267e-11, -1.080756447047615e-13,  1.004562275646523e-15, -5.286440984684349e-19, -1.465919825822828e-20,
  4.169734383101275e-23,  1.532450085518481e-25, -1.093798111784932e-27,  1.012892819551941e+00, -3.282134461695323e-03,  1.664702383185233e-06,  2.176195760348901e-08,
 -4.565848495686220e-11, -2.135737923264987e-13,  1.001340519369129e-15,  1.665475639511247e-18, -1.963049529299403e-20,  6.349679109956761e-24,  3.424549997565394e-25,
 -7.671131119268615e-28,  1.096454092739075e+00, -3.349529063935801e-03,  3.707516446133662e-07,  2.499780604328627e-08, -2.506362505165366e-11, -3.159405113678762e-13,
  7.346956330902165e-16,  4.382313099106332e-18, -1.847715713207621e-20, -5.720536331090479e-23,  4.297287400461001e-25,  5.406424429460439e-28,  1.181872321266997e+00,
 -3.372384020048563e-03, -1.107719923946683e-06,  2.688066021128553e-08,  4.285961827445097e-12, -3.900423596735131e-13,  1.487239750612734e-16,  6.784820033856003e-18,
 -7.389438168517664e-21, -1.279063112947914e-22,  2.441942980934765e-25,  2.488117627556920e-27,  1.268627564730359e+00, -3.343301712294780e-03, -2.720831735308438e-06,
  2.680548505164941e-08,  4.055610823249565e-11, -4.041701578018816e-13, -7.226254270424110e-16,  7.543565868938974e-18,  1.414537926816212e-20, -1.576307360570161e-22,
 -2.951206766041812e-25,  3.520104420054009e-27,  1.356071669461808e+00, -3.255187235055755e-03, -4.388999889109423e-06,  2.420217115825351e-08,  7.936590627806534e-11,
 -3.271276215641687e-13, -1.694106586260616e-15,  5.230681283330723e-18,  3.931459350792551e-20, -8.770603993398380e-23, -9.594729149727812e-25,  1.397310677183732e-27,
  1.443402121216051e+00, -3.101962216821189e-03, -5.998079543674259e-06,  1.868078278383788e-08,  1.133723591581691e-10, -1.421923254515713e-13, -2.400086086513500e-15,
 -7.228896787334245e-19,  5.217172058863232e-20,  9.724884838040766e-23, -1.109569572274410e-24, -4.150134115237766e-27,  1.529634279478861e+00, -2.879623842562750e-03,
 -7.398446422411103e-06,  1.024239310237417e-08,  1.327657031367788e-10,  1.329444016947137e-13, -2.367982920152801e-15, -8.693485171060551e-18,  3.400049386520881e-20,
  2.973333332382349e-22, -1.217646517240630e-25, -8.104659692516052e-27,  1.613574990592087e+00, -2.587710766635171e-03, -8.412330222361640e-06, -4.696263370362659e-10,
  1.274681507363287e-10,  4.281229267666441e-13, -1.266145799248520e-15, -1.419905643215532e-17, -1.817260164352615e-20,  3.009548214934463e-22,  1.550679679024455e-24,
 -2.725592127391949e-27,  1.693803068965922e+00, -2.231161981218617e-03, -8.855098040862442e-06, -1.196437476767027e-08,  9.158482442362336e-11,  6.230107691799492e-13,
  7.031767844784926e-16, -1.180708504293530e-17, -7.158502676224797e-20, -1.434397579921637e-23,  1.918328567071011e-24,  9.444870459765612e-27,  1.768665475690174e+00,
 -1.822384544911545e-03, -8.575754178836798e-06, -2.191737115932754e-08,  2.935873264294196e-11,  5.937068636278599e-13,  2.551981681740872e-15, -4.915277968808731e-19,
 -6.981177810135795e-20, -3.880020522501686e-22, -2.669537926000634e-25,  9.844113099956220e-27,  1.836301610032560e+00, -1.383052995094024e-03, -7.516853150421808e-06,
 -2.763567556760657e-08, -4.078112871150117e-11,  3.070828271780108e-13,  2.922653062182802e-15,  1.168140764816016e-17,  1.163721048982602e-21, -3.183238928587507e-22,
 -2.255045660603354e-24, -6.410895527912336e-27,  1.894710246854627e+00, -9.447838978714112e-04, -5.781428412135548e-06, -2.710969333574848e-08, -9.006472659674289e-11,
 -9.643894152001554e-14,  1.348457955626092e-15,  1.268317478520766e-17,  6.301060051243300e-20,  1.467518468002465e-22, -6.379454392658997e-25, -9.550702521129067e-27,
  1.941871186379459e+00, -5.475493011254172e-04, -3.675714650760851e-06, -2.039144208991264e-08, -9.507868054508595e-11, -3.519740319407836e-13, -7.738373694027868e-16,
  1.984216055812013e-18,  3.699401234316149e-20,  2.710904835232187e-22,  1.379052651723411e-24,  4.618651977512565e-27,  1.975923159958156e+00, -2.348843448071612e-04,
 -1.683347968204525e-06, -1.042816456337266e-08, -5.836514539933229e-11, -2.983730519944438e-13, -1.381942097023852e-15, -5.611012146048971e-18, -1.807311674015843e-20,
 -2.688805181820408e-23,  2.179917551739805e-25,  2.804378493270789e-27,  1.995383851752451e+00, -4.594494144717453e-05, -3.416483861279675e-07, -2.246826099631632e-09,
 -1.376546018054538e-11, -8.034564334193085e-14, -4.517874117409528e-16, -2.461753071570551e-18, -1.303534128190548e-20, -6.712849212772889e-23, -3.358810810313964e-25,
 -1.628277806768052e-27,  4.562456309133039e-04, -2.193313290953366e-06,  7.906227143388642e-09, -2.533031663943464e-11,  7.605012563732483e-14, -2.191872477291846e-16,
  6.136387915827193e-19, -1.683773730317186e-21,  4.537374190630220e-24, -1.211341895685864e-26,  3.176393922136229e-29, -8.379067795551078e-32,  4.106353435513939e-03,
 -1.972350826967353e-05,  7.095182172203067e-08, -2.264816321898013e-10,  6.760438075330256e-13, -1.932194592336013e-15,  5.347612375649732e-18, -1.445374610735015e-20,
  3.820066742315948e-23, -9.956513052993684e-26,  2.532555307859215e-28, -6.452331408049561e-31,  1.140732040848129e-02, -5.469656250728658e-05,  1.959515181375602e-07,
 -6.208342804295372e-10,  1.831383351003363e-12, -5.144381126621246e-15,  1.389772931822440e-17, -3.636078349829050e-20,  9.202632271704531e-23, -2.267981406619214e-25,
  5.349519914558134e-28, -1.242232389770041e-30,  2.236060078592578e-02, -1.069361552782887e-04,  3.807112839381157e-07, -1.192504848288212e-09,  3.453704733435168e-12,
 -9.438346569859493e-15,  2.450625761785567e-17, -6.062296602806047e-20,  1.416364809221978e-22, -3.113419571546323e-25,  6.126184419405202e-28, -1.070919713247984e-30,
  3.696825260925121e-02, -1.761736438813961e-04,  6.219125529954779e-07, -1.917715646149839e-09,  5.412853948856408e-12, -1.421395044363371e-14,  3.473139637522192e-17,
 -7.825943163451988e-20,  1.568126584590261e-22, -2.599397817327354e-25,  2.241722086502493e-28,  5.228468177233084e-31,  5.523278380786310e-02, -2.620429614491751e-04,
  9.150795143226409e-07, -2.764869019530679e-09,  7.539935692906922e-12, -1.872034033643981e-14,  4.168058836830819e-17, -7.946792090456577e-20,  1.085039647822963e-22,
 -2.241987734546694e-28, -7.610898188813418e-28,  3.564637926370004e-30,  7.715693674759111e-02, -3.640736314402537e-04,  1.254536106541596e-06, -3.694676830800080e-09,
  9.631680825491231e-12, -2.210005324097913e-14,  4.231968737472184e-17, -5.536348195578689e-20, -2.289387272608987e-23,  4.852068749518218e-25, -2.221543198271657e-27,
  7.094309985083948e-30,  1.027434018057520e-01, -4.816817381745608e-04,  1.633353438236431e-06, -4.660374061293753e-09,  1.145640204827929e-11, -2.344624161034951e-14,
  3.385383960862377e-17,  2.574341259771218e-23, -2.389928847864179e-22,  1.129313544702967e-24, -3.710183154273285e-27,  9.119719593130251e-30,  1.319944472848419e-01,
 -6.141586479260638e-04,  2.043288809477155e-06, -5.608056515854562e-09,  1.276188510862230e-11, -2.187411184674009e-14,  1.417145129047881e-17,  8.766120000763030e-20,
 -5.159513217715455e-22,  1.764252374596478e-24, -4.471682832658682e-27,  7.044402736679972e-30,  1.649114490544667e-01, -7.606572280248402e-04,  2.474718194441117e-06,
 -6.477196436021320e-09,  1.328564368120652e-11, -1.660747156371299e-14, -1.766468358943895e-17,  2.015189625020146e-19, -7.998206252536748e-22,  2.127588191942125e-24,
 -3.586721162405693e-27, -1.352998596556742e-30,  2.014942984930682e-01, -9.201752629168890e-04,  2.916565057737182e-06, -7.201407234520457e-09,  1.276804492926618e-11,
 -7.080729039713473e-15, -6.090617667708079e-17,  3.270481168754596e-19, -1.006780717674001e-21,  1.900306883695914e-24, -2.638938736166826e-28, -1.647042923011985e-29,
  2.417406613082787e-01, -1.091535718098472e-03,  3.356229853335069e-06, -7.709550404921443e-09,  1.096887936850930e-11,  6.944424444166248e-15, -1.126310891721653e-16,
  4.404779352237272e-19, -1.030586565566807e-21,  7.835274839836474e-25,  5.734025708047482e-27, -3.529159995092627e-29,  2.856450522942880e-01, -1.273363459042662e-03,
  3.779526681539825e-06, -7.927304766799458e-09,  7.687984196882039e-12,  2.525037632703583e-14, -1.673452006667222e-16,  5.095033478669208e-19, -7.595114430317785e-22,
 -1.384917522662092e-24,  1.359753510974859e-26, -5.028959694075903e-29,  3.331976815884828e-01, -1.464057999399283e-03,  4.170636611719550e-06, -7.779351196321759e-09,
  2.790501126102723e-12,  4.702892448205118e-14, -2.167685754509990e-16,  4.959819067182497e-19, -1.044782271999375e-22, -4.483616997429099e-24,  2.105728610745381e-26,
 -4.977583669934841e-29,  3.843830159505753e-01, -1.661761842330958e-03,  4.512091462752735e-06, -7.192364888607524e-09, -3.762796038490203e-12,  7.075147181458463e-14,
 -2.499411648266779e-16,  3.613279195137192e-19,  9.614965346754368e-22, -7.957421744710256e-24,  2.428988030067218e-26, -2.081599371245422e-29,  4.391779832921796e-01,
 -1.864324009758992e-03,  4.784807831230382e-06, -6.099050715549416e-09, -1.188001877963821e-11,  9.406236403293254e-14, -2.538242332770637e-16,  7.521607010447254e-20,
  2.355527881159960e-21, -1.071583803952719e-23,  1.846766453325221e-26,  4.440595995489879e-29,  4.975497292483217e-01, -2.069258457116973e-03,  4.968199470146211e-06,
 -4.443501497968033e-09, -2.129812928248302e-11,  1.137241714728569e-13, -2.146158723860303e-16, -3.721174958114605e-19,  3.837048336107280e-21, -1.116225096270232e-23,
 -7.001370054926719e-28,  1.389499962162991e-28,  5.594528099314576e-01, -2.273697294650843e-03,  5.040407499238126e-06, -2.188195284660631e-09, -3.154018476638175e-11,
  1.256579406492194e-13, -1.200228343584521e-16, -9.544563120693199e-19,  4.976287820540612e-21, -7.464304936366908e-24, -3.423028509121539e-26,  2.307165139237404e-28,
  6.248256738910337e-01, -2.474339156923354e-03,  4.978703248762154e-06,  6.770413053080778e-10, -4.187374653156132e-11,  1.251393200426442e-13,  3.729414577675462e-17,
 -1.593021871504657e-18,  5.165978168788413e-21,  1.818038026752635e-24, -7.618926461266050e-26,  2.576153395941711e-28,  6.935862473544721e-01, -2.667393798830678e-03,
  4.760138692095313e-06,  4.123823038662444e-09, -5.127760606251907e-11,  1.072313245960172e-13,  2.550148113503882e-16, -2.143164432215975e-18,  3.714269392498534e-21,
  1.668379779476466e-23, -1.102885854983211e-25,  1.392071878793943e-28,  7.656263887640670e-01, -2.848525231055967e-03,  4.362545019066892e-06,  8.071628818211000e-09,
 -5.842891506091620e-11,  6.755113812919353e-14,  5.154341094513778e-16, -2.392431313971223e-18,  6.217568983357494e-23,  3.433251733057176e-23, -1.094664499124718e-25,
 -1.820961932391184e-28,  8.408049206675929e-01, -3.012797714078447e-03,  3.766010605686943e-06,  1.237210493472578e-08, -6.172981880255175e-11,  3.469688272693228e-15,
  7.796123073381471e-16, -2.082667157066747e-18, -5.844979262156666e-21,  4.797326774108218e-23, -4.283130449666078e-26, -6.645145140555345e-28,  9.189388797571209e-01,
 -3.154632109076546e-03,  2.955002799304842e-06,  1.679222271763110e-08, -5.940181781920380e-11, -8.419535518114818e-14,  9.834264754472563e-16, -9.726318436372550e-19,
 -1.305934988085155e-20,  4.686597080139951e-23,  1.053063869494093e-25, -1.077436258447167e-27,  9.997925529019847e-01, -3.267785003848047e-03,  1.921325971086471e-06,
  2.099857036731031e-08, -4.968622739964779e-11, -1.890526998927855e-13,  1.039232185937172e-15,  1.043530841290366e-18, -1.916409150361791e-20,  1.930586971967189e-23,
  3.038127195374710e-25, -9.787286964164938e-28,  1.083063798093415e+00, -3.345370447197904e-03,  6.681139027929336e-07,  2.454723609812042e-08, -3.119652218170731e-11,
 -2.969039556383261e-13,  8.488369206400526e-16,  3.761449851730257e-18, -2.022262323740209e-20, -3.967321368737591e-23,  4.436217964207409e-25,  9.387205043509988e-29,
  1.168367105464336e+00, -3.379954933254237e-03, -7.849971736111428e-07,  2.688708681601468e-08, -3.463959526532977e-12, -3.842241870405527e-13,  3.347108879905805e-16,
  6.476776845663476e-18, -1.179285194819307e-20, -1.160593558362226e-22,  3.452252474037003e-25,  2.086571523075633e-27,  1.255212876546595e+00, -3.363771291734010e-03,
 -2.395542134681813e-06,  2.738884592166268e-08,  3.231662560745845e-11, -4.189326975205384e-13, -5.059360153955958e-16,  7.903452068080770e-18,  8.296217173675008e-21,
 -1.662635300763698e-22, -1.350604650003151e-25,  3.720184440148521e-27,  1.342982565691546e+00, -3.289116453755510e-03, -4.091177626213416e-06,  2.541752843806315e-08,
  7.242935282833854e-11, -3.658896880780938e-13, -1.530561251115860e-15,  6.430962897402094e-18,  3.548423571210396e-20, -1.245199678083171e-22, -8.730678897411171e-25,
  2.515724228554748e-27,  1.430899766039953e+00, -3.149019574801379e-03, -5.763130399236529e-06,  2.046885659656680e-08,  1.099518400441563e-10, -1.998457093710571e-13,
 -2.396490800273488e-15,  9.937171411009888e-19,  5.483277235100108e-20,  4.954720747914141e-23, -1.266671844774007e-24, -2.937391555210610e-27,  1.517998238610417e+00,
 -2.938283485189399e-03, -7.262714677270902e-06,  1.238474718325870e-08,  1.348372356383095e-10,  7.332458574649375e-14, -2.594569923469984e-15, -7.435856134323561e-18,
  4.452890985660524e-20,  2.851209902171178e-22, -4.931524757560010e-25, -8.693173025483473e-27,  1.603089564341779e+00, -2.654996639796628e-03, -8.405451954907228e-06,
  1.636576464008567e-09,  1.356942352294165e-10,  3.929092648009113e-13, -1.670148172671948e-15, -1.459553912208340e-17, -6.257671724501783e-21,  3.598080523558374e-22,
  1.372399904789787e-24, -5.411154349209860e-27,  1.684735866603799e+00, -2.302551192105408e-03, -8.989464555942651e-06, -1.039853597253580e-08,  1.041856859534283e-10,
  6.356610522233350e-13,  3.405409158833845e-16, -1.409045793618376e-17, -7.062200033449316e-20,  7.047483294932229e-23,  2.315390459215658e-24,  8.450881660849821e-27,
  1.761237072214184e+00, -1.892033702570040e-03, -8.835541592394951e-06, -2.134931994160575e-08,  4.184287112504160e-11,  6.545238731051056e-13,  2.504833853026325e-15,
 -2.950150625805573e-18, -8.385899982093559e-20, -3.890627418437458e-22,  2.377975280777742e-25,  1.311838150793840e-26,  1.830647013077738e+00, -1.444524933113112e-03,
 -7.852180921906373e-06, -2.823511809416347e-08, -3.391156749578951e-11,  3.811444372642037e-13,  3.248403850684334e-15,  1.151735413579668e-17, -1.198402028364737e-20,
 -4.137650303218008e-22, -2.505210954583241e-24, -4.786379708536136e-27,  1.890836513308876e+00, -9.923612226009830e-04, -6.115448559817480e-06, -2.856427589910380e-08,
 -9.163991252994901e-11, -5.958187334604429e-14,  1.732569694658743e-15,  1.477824477316990e-17,  6.772521541477543e-20,  1.119601772033288e-22, -1.123968671246500e-24,
 -1.261546952437858e-26,  1.939620590767245e+00, -5.779602104054370e-04, -3.929775023055551e-06, -2.197000449195537e-08, -1.022986509224396e-10, -3.697362538315382e-13,
 -7.001606542100951e-16,  3.335216434114125e-18,  4.779514494198370e-20,  3.303095689714412e-22,  1.581014126296765e-24,  4.493568643974581e-27,  1.974955873445697e+00,
 -2.488680212762525e-04, -1.814291909268821e-06, -1.141160323398989e-08, -6.467733962449449e-11, -3.334911427114868e-13, -1.547279223550929e-15, -6.202896337982734e-18,
 -1.885150505181029e-20, -1.537825317439385e-23,  3.661060091028833e-25,  3.987821313380140e-27,  1.995194429401783e+00, -4.878984646696934e-05, -3.699867861163716e-07,
 -2.480542209691598e-09, -1.548663871137844e-11, -9.206515531042028e-14, -5.269389613657703e-16, -2.920289844707338e-18, -1.571209484122327e-20, -8.211073088851852e-23,
 -4.162218830373288e-25, -2.039298685163141e-27,  4.475969810501702e-04, -2.131258971415045e-06,  7.609422041104540e-09, -2.414780014330802e-11,  7.180991830983109e-14,
 -2.050096519084825e-16,  5.684620203322291e-19, -1.545316903839793e-21,  4.123299203358502e-24, -1.091369787165563e-26,  2.829142111483715e-29, -7.427229951985435e-32,
  4.028577674763704e-03, -1.916658382263075e-05,  6.829768931108044e-08, -2.159672442737283e-10,  6.386512616503593e-13, -1.808573463784131e-15,  4.959496161064608e-18,
 -1.328677337518453e-20,  3.479201985102458e-23, -8.998141359179473e-26,  2.264401509865431e-28, -5.752159578553295e-31,  1.119162289242515e-02, -5.315825997478757e-05,
  1.886739820549546e-07, -5.923374654176934e-10,  1.731750405553660e-12, -4.822727478226033e-15,  1.291965657643279e-17, -3.354255183392221e-20,  8.423390811104380e-23,
 -2.064576621232528e-25,  4.829263869608239e-28, -1.124901786566064e-30,  2.193885822255342e-02, -1.039467799733122e-04,  3.667266540637337e-07, -1.138724319891817e-09,
  3.270684414542578e-12, -8.870063735759293e-15,  2.287061591866561e-17, -5.626529352013254e-20,  1.308580273413383e-22, -2.877656135624286e-25,  5.665450260541474e-28,
 -1.023412536148293e-30,  3.627336493860180e-02, -1.712889428267915e-04,  5.994103627075289e-07, -1.833339660236548e-09,  5.136735876774464e-12, -1.340613364880406e-14,
  3.260899014680537e-17, -7.338938004192130e-20,  1.476212039597262e-22, -2.505749300497344e-25,  2.425985529791677e-28,  3.206284220137141e-31,  5.419904596251009e-02,
 -2.548530162905497e-04,  8.826127384988438e-07, -2.647171700888638e-09,  7.175354021091200e-12, -1.774631529681468e-14,  3.950405497957312e-17, -7.600150270291070e-20,
  1.079840863802239e-22, -2.770791356263718e-26, -6.173334015740529e-28,  2.982616113737262e-30,  7.572043765882100e-02, -3.542121004947854e-04,  1.211110217211202e-06,
 -3.544051289587376e-09,  9.199710559728407e-12, -2.110305011659175e-14,  4.076176054721977e-17, -5.583316271049825e-20, -6.953171208249944e-24,  4.023188903039721e-25,
 -1.929361613281451e-27,  6.200934018872219e-30,  1.008424586722702e-01, -4.688355278337921e-04,  1.578513432540968e-06, -4.480778896603748e-09,  1.099559788540713e-11,
 -2.263456844761643e-14,  3.375340372262062e-17, -6.999416588419734e-21, -2.009144367533850e-22,  9.886886801187835e-25, -3.327047177209110e-27,  8.297811644989381e-30,
  1.295700839586784e-01, -5.980780860548380e-04,  1.977202897404776e-06, -5.407346930731133e-09,  1.232799343808877e-11, -2.150635106566269e-14,  1.640412422232274e-17,
  7.213305186927742e-20, -4.555831767355033e-22,  1.591578687151218e-24, -4.162438415203940e-27,  6.985008151149388e-30,  1.619079284347779e-01, -7.411667995868545e-04,
  2.398256228574013e-06, -6.267304499995604e-09,  1.294969712053865e-11, -1.696653597005858e-14, -1.236915571802802e-17,  1.771224160419365e-19, -7.258199088762224e-22,
  1.983398079115129e-24, -3.611917761482281e-27,  1.399802009191132e-31,  1.978597200634826e-01, -8.971849483575386e-04,  2.831368981038560e-06, -6.998327805143447e-09,
  1.261253606434533e-11, -8.436166526689584e-15, -5.218960511980498e-17,  2.959223208389369e-19, -9.387244979759086e-22,  1.876327975573759e-24, -9.096321802324159e-28,
 -1.297954160928290e-29,  2.374276364124968e-01, -1.065052944534177e-03,  3.264772379758874e-06, -7.533079971401669e-09,  1.108171625647271e-11,  4.385579861618641e-15,
 -1.007548708607380e-16,  4.079917970681838e-19, -9.986115434883247e-22,  9.833366337853227e-25,  4.292753367299001e-27, -3.030506265519664e-29,  2.806114714108907e-01,
 -1.243505628100746e-03,  3.685153042336421e-06, -7.800470377071562e-09,  8.153970052943656e-12,  2.140249582195820e-14, -1.534261394992082e-16,  4.845019928589188e-19,
 -8.000995222660971e-22, -8.839522171747080e-25,  1.148348786970191e-26, -4.579476148600759e-29,  3.274075897094958e-01, -1.431065486675734e-03,  4.077582421812554e-06,
 -7.727456503512358e-09,  3.680177480046460e-12,  4.199260736149584e-14, -2.029510194586420e-16,  4.902143197244146e-19, -2.512547130230539e-22, -3.685078031870637e-24,
  1.887302278955605e-26, -4.931989532979015e-29,  3.778076141191500e-01, -1.626011262182055e-03,  4.425467505431842e-06, -7.241571813943466e-09, -2.406916120561028e-12,
  6.487750877250709e-14, -2.394349724101658e-16,  3.876979084837942e-19,  6.922744838011273e-22, -7.006618555906282e-24,  2.319352251349134e-26, -2.861496269281842e-29,
  4.317967762744589e-01, -1.826341392080047e-03,  4.710539752163200e-06, -6.274411159794538e-09, -1.005947619856908e-11,  8.800402135643041e-14, -2.507198640540864e-16,
  1.445666847930442e-19,  1.983472796294839e-21, -9.943777469706404e-24,  1.999934341862731e-26,  2.572808661064470e-29,  4.893518409523733e-01, -2.029731771492946e-03,
  4.912906974086218e-06, -4.766358855839968e-09, -1.907592749351452e-11,  1.084618626165137e-13, -2.233765463858195e-16, -2.557553391786728e-19,  3.436102672666856e-21,
 -1.107607776945928e-23,  4.811659391149322e-27,  1.118915606190160e-28,  5.504384891090537e-01, -2.233487457021430e-03,  5.011203701293891e-06, -2.672898246150283e-09,
 -2.905790423017016e-11,  1.224744323041285e-13, -1.445604020204210e-16, -7.997593551300354e-19,  4.685310615403886e-21, -8.637435442878477e-24, -2.460276555271234e-26,
  2.065029239292423e-28,  6.150080121420280e-01, -2.434488232155861e-03,  4.982890573613152e-06,  2.711745465805511e-11, -3.936552578571363e-11,  1.255178443657865e-13,
 -4.990333994672996e-18, -1.427229346483184e-18,  5.179308824249114e-21, -1.002328665386010e-24, -6.483356865399702e-26,  2.570291224329739e-28,  6.829931283156638e-01,
 -2.629128528245100e-03,  4.804773713082660e-06,  3.320850738432520e-09, -4.907656505537875e-11,  1.126455324603869e-13,  1.967544962874320e-16, -2.015536475350761e-18,
  4.237092539505394e-21,  1.240970189056297e-23, -1.030738340585499e-25,  1.862300716729049e-28,  7.543026797079704e-01, -2.813253218453575e-03,  4.453842087793548e-06,
  7.148223727840710e-09, -5.695960824928656e-11,  7.911903613242935e-14,  4.486535885592663e-16, -2.371525004793193e-18,  1.217689042124795e-21,  2.982523237546253e-23,
 -1.151384740022382e-25, -7.788182281738356e-29,  8.288149025718462e-01, -2.982092546927906e-03,  3.908555330329890e-06,  1.138597941152464e-08, -6.147814407920256e-11,
  2.146105462532086e-14,  7.189360299031727e-16, -2.242459493477830e-18, -4.155484421955398e-21,  4.571291900232512e-23, -6.924350278888131e-26, -5.352099677134328e-28,
  9.063688846059396e-01, -3.130202336980809e-03,  3.150755455163599e-06,  1.582959467500678e-08, -6.085214583695912e-11, -6.096556094531793e-14,  9.506010966655391e-16,
 -1.362815181595854e-18, -1.130765099440598e-20,  5.014476205239901e-23,  5.906782767244560e-26, -1.017902136454839e-27,  9.867537305462497e-01, -3.251420257867017e-03,
  2.168418576761305e-06,  2.017470615240870e-08, -5.321585405982168e-11, -1.638290745182343e-13,  1.059986239224875e-15,  4.436583450496686e-19, -1.826115668520533e-20,
  3.054936407657615e-23,  2.573006533622132e-25, -1.124451618523114e-27,  1.069694859151821e+00, -3.338856198027168e-03,  9.594935933587185e-07,  2.400172847135708e-08,
 -3.692273253958721e-11, -2.753423445851392e-13,  9.449074963194841e-16,  3.094899408144256e-18, -2.133160401770721e-20, -2.197129459830286e-23,  4.384384608851038e-25,
 -3.225921351889863e-28,  1.154836767098935e+00, -3.384945853555209e-03, -4.629366795570529e-07,  2.677068489990984e-08, -1.105365973072529e-11, -3.740613326792616e-13,
  5.101693297628101e-16,  6.035391880875998e-18, -1.570155942197933e-20, -1.005535287120628e-22,  4.264803157106397e-25,  1.594816870488636e-27,  1.241721555822895e+00,
 -3.381612814773556e-03, -2.064052013488983e-06,  2.783829866866576e-08,  2.383460350309435e-11, -4.283951627935739e-13, -2.818280445844020e-16,  8.072441696174478e-18,
  2.253064070260075e-21, -1.683811179251190e-22,  2.906625173977607e-26,  3.704516254022776e-27,  1.329762599830342e+00, -3.320606701422324e-03, -3.779461846651128e-06,
  2.651592335721524e-08,  6.475945448367499e-11, -4.003384208789456e-13, -1.335317963510421e-15,  7.488229740606753e-18,  3.040236694204436e-20, -1.569254980101023e-22,
 -7.399918961879404e-25,  3.505371216991536e-27,  1.418213075082976e+00, -3.194112529985174e-03, -5.507090729903944e-06,  2.219299874478650e-08,  1.053830522317862e-10,
 -2.568280315885707e-13, -2.343904548480306e-15,  2.766898496380731e-18,  5.567713855450964e-20, -3.281577142940817e-24, -1.363852029926146e-24, -1.440309953525334e-27,
  1.506129894371946e+00, -2.995753969881767e-03, -7.101116087873089e-06,  1.455042379551109e-08,  1.356650378970606e-10,  8.726806005176589e-15, -2.781313365887321e-15,
 -5.851260610922494e-18,  5.434545750285310e-20,  2.576922274010602e-22, -8.785161426481668e-25, -8.723578140561945e-27,  1.592335267806436e+00, -2.722124208551997e-03,
 -8.372534505645545e-06,  3.868232637098457e-09,  1.431184174667144e-10,  3.479113147839601e-13, -2.079606824998816e-15, -1.457845495077766e-17,  7.618710465770385e-21,
  4.091231090551317e-22,  1.073074517203320e-24, -8.191461273400387e-27,  1.675381081397717e+00, -2.374936731367697e-03, -9.103824564524771e-06, -8.629553862679509e-09,
  1.169473722070470e-10,  6.388472720115918e-13, -8.511764164278566e-17, -1.629119530783078e-17, -6.633270892573655e-20,  1.700187322508930e-22,  2.647353113511859e-24,
  6.465337935083574e-27,  1.753525963595973e+00, -1.963730405470378e-03, -9.087274040124058e-06, -2.057187758639665e-08,  5.552619602694732e-11,  7.133325537039752e-13,
  2.382575109230311e-15, -5.854715867618121e-18, -9.754611295399742e-20, -3.670395791551892e-22,  8.869924575884167e-25,  1.635707315304534e-26,  1.824741120358657e+00,
 -1.508706282702664e-03, -8.193992275615371e-06, -2.871237546306193e-08, -2.548322537884030e-11,  4.629181620769979e-13,  3.563141560863120e-15,  1.087582675139021e-17,
 -2.872755996339164e-20, -5.174526276534354e-22, -2.658704891003294e-24, -1.972607536738447e-27,  1.886767015066782e+00, -1.042680897548476e-03, -6.467048912756078e-06,
 -3.003764318918558e-08, -9.238093597791059e-11, -1.278643000115978e-14,  2.177238932247539e-15,  1.700011895168203e-17,  7.080374447496960e-20,  5.490582601566620e-23,
 -1.753955485244589e-24, -1.607337561370875e-26,  1.937244163774015e+00, -6.104813637986463e-04, -4.203482636297073e-06, -2.366681871112804e-08, -1.098529088446723e-10,
 -3.852352163387108e-13, -5.834855122669748e-16,  5.067503699762120e-18,  6.087102590842191e-20,  3.973593169335059e-22,  1.766758256495781e-24,  3.841711681699057e-27,
  1.973930479886907e+00, -2.639482260552732e-04, -1.957666976856479e-06, -1.250187718638845e-08, -7.173293173218976e-11, -3.727785858186626e-13, -1.729466759497260e-15,
 -6.811807311995769e-18, -1.909532003546803e-20,  3.212095710768741e-24,  5.750511093922799e-25,  5.587935972625748e-27,  1.994993155568965e+00, -5.187316369325918e-05,
 -4.013030772435416e-07, -2.743774841796815e-09, -1.746133603656969e-11, -1.057525734183932e-13, -6.162144455160486e-16, -3.473769857972321e-18, -1.899068128557924e-20,
 -1.006981219616212e-22, -5.169203910035045e-25, -2.557732710495763e-27,  4.391918878545049e-04, -2.071523464065933e-06,  7.326409246794867e-09, -2.303091616792695e-11,
  6.784272692142170e-14, -1.918712354303159e-16,  5.269828410225726e-19, -1.419445449403379e-21,  3.750011387479986e-24, -9.844884340826106e-27,  2.520936151326814e-29,
 -6.601759833343476e-32,  3.952987930661470e-03, -1.863039773035781e-05,  6.576621985109055e-08, -2.060318529229149e-10,  6.036405747668973e-13, -1.693887035676243e-15,
  4.602578534117387e-18, -1.222355829755138e-20,  3.170979655027555e-23, -8.141142035175210e-26,  2.025037049749952e-28, -5.142147764092709e-31,  1.098196427405488e-02,
 -5.167683650323150e-05,  1.817290512218627e-07, -5.653845620250087e-10,  1.638322044558278e-12, -4.523628164674144e-15,  1.201711059595305e-17, -3.096235310773547e-20,
  7.713749901089953e-23, -1.880990592593849e-25,  4.357581403884811e-28, -1.021315005777884e-30,  2.152885342448496e-02, -1.010667491733586e-04,  3.533701888489002e-07,
 -1.087783283427264e-09,  3.098646883379650e-12, -8.339610327737313e-15,  2.135228538538861e-17, -5.223930316747129e-20,  1.208956503326529e-22, -2.659907306955921e-25,
  5.225329853256375e-28, -9.776099757341820e-31,  3.559766234526828e-02, -1.665802831411540e-04,  5.778947012349093e-07, -1.753255034638149e-09,  4.876275637940475e-12,
 -1.264765118624216e-14,  3.061887919032082e-17, -6.880793538533118e-20,  1.387780982110592e-22, -2.406410525869681e-25,  2.528540313318583e-28,  1.500715811255557e-31,
  5.319355723630417e-02, -2.479172535711924e-04,  8.515239644111682e-07, -2.535154650233696e-09,  6.829738330436769e-12, -1.682336509763961e-14,  3.742420728190417e-17,
 -7.256649018782391e-20,  1.065723288618666e-22, -4.993158258487387e-26, -4.975679574144618e-28,  2.471939473321797e-30,  7.432270116324936e-02, -3.446908626316664e-04,
  1.169451016661430e-06, -3.400179787132415e-09,  8.787305675266120e-12, -2.014354008563892e-14,  3.919739114679022e-17, -5.583830425000564e-20,  6.204686257454343e-24,
  3.303566706235362e-25, -1.674663588501717e-27,  5.388730682673637e-30,  9.899203641396923e-02, -4.564195410768442e-04,  1.525784866725292e-06, -4.308426926243230e-09,
  1.055098784025361e-11, -2.182753308198335e-14,  3.347258211891240e-17, -1.288417884082828e-20, -1.676313013291551e-22,  8.626704632823804e-25, -2.979730038604470e-27,
  7.492396020864553e-30,  1.272090005934806e-01, -5.825166948614464e-04,  1.913484098511811e-06, -5.213518003179147e-09,  1.190195871093671e-11, -2.109001095942524e-14,
  1.822813640268150e-17,  5.843960378888452e-20, -4.012096805463652e-22,  1.431176609793245e-24, -3.859178801588652e-27,  6.777659326372607e-30,  1.589811619595064e-01,
 -7.222780839423890e-04,  2.324280499832047e-06, -6.062838481379646e-09,  1.260778622962226e-11, -1.720644216075420e-14, -7.724359860828036e-18,  1.550107659225897e-19,
 -6.570134145312619e-22,  1.839397453806532e-24, -3.580025831426056e-27,  1.251225416767550e-30,  1.943157551266034e-01, -8.748664988854498e-04,  2.748594070072475e-06,
 -6.797942313095797e-09,  1.243194110137747e-11, -9.592619441084594e-15, -4.431423029118803e-17,  2.669558169844727e-19, -8.719610015269322e-22,  1.829419983405986e-24,
 -1.414502547744345e-27, -1.005911643305866e-29,  2.332190927414741e-01, -1.039293333276405e-03,  3.175441744214038e-06, -7.355198383325581e-09,  1.114615349095704e-11,
  2.100971056912887e-15, -8.977293512715151e-17,  3.766332431586424e-19, -9.604296123353158e-22,  1.129731034844455e-24,  3.059492129614269e-27, -2.583950569754307e-29,
  2.756958216838218e-01, -1.214396577205645e-03,  3.592343668988678e-06, -7.666777964517370e-09,  8.546281480620846e-12,  1.788014165332792e-14, -1.402227026214078e-16,
  4.584744421497588e-19, -8.241272511303853e-22, -4.635901347439107e-25,  9.567165841874379e-27, -4.132792493250599e-29,  3.217479832900512e-01, -1.398814682072668e-03,
  3.985233111373025e-06, -7.662114845807985e-09,  4.472427991698107e-12,  3.728546889280973e-14, -1.893565099746688e-16,  4.801930395177706e-19, -3.708487434132345e-22,
 -2.973195904545494e-24,  1.673159011440083e-26, -4.788214046079912e-29,  3.713738253942769e-01, -1.590955675663038e-03,  4.338379397686239e-06, -7.270010560674633e-09,
 -1.165939068321901e-12,  5.926361246685590e-14, -2.283059500589641e-16,  4.059913612578363e-19,  4.564156091785901e-22, -6.105842123452303e-24,  2.180492507871706e-26,
 -3.416450113569046e-29,  4.245662987977796e-01, -1.788960850326582e-03,  4.634338136205954e-06, -6.421607573127153e-09, -8.359204977792479e-12,  8.204216606240672e-14,
 -2.458361046461878e-16,  2.024665149298023e-19,  1.640124872534245e-21, -9.125984681739827e-24,  2.077625845109743e-26,  1.006704458383379e-29,  4.813111510245177e-01,
 -1.990662326619226e-03,  4.853950013938702e-06, -5.054513296689316e-09, -1.696081800941378e-11,  1.030269497800121e-13, -2.290579472398654e-16, -1.521335516236192e-19,
  3.041946033477526e-21, -1.079266402497148e-23,  9.177038535461756e-27,  8.690945760463348e-29,  5.415845044855382e-01, -2.193533845376998e-03,  4.976419565958433e-06,
 -3.118424624072857e-09, -2.664483761826810e-11,  1.187529119210517e-13, -1.649026440183860e-16, -6.549771893030121e-19,  4.358770113647442e-21, -9.447374420558766e-24,
 -1.608315502014769e-26,  1.805761041741920e-28,  6.053497726585509e-01, -2.394634322673391e-03,  4.979519676976483e-06, -5.826678610869803e-10, -3.685950694868766e-11,
  1.249372049798916e-13, -4.264129080489948e-17, -1.262547312891644e-18,  5.099252487204772e-21, -3.371556018900989e-24, -5.369245235670416e-26,  2.481824046199222e-28,
  6.725537243490745e-01, -2.590544113736700e-03,  4.839987697087358e-06,  2.553886643354778e-09, -4.678092373159446e-11,  1.167061261983663e-13,  1.422792766176167e-16,
 -1.873580576604819e-18,  4.611701347407502e-21,  8.461183551100386e-24, -9.411636801777306e-26,  2.186159258078068e-28,  7.431214498632809e-01, -2.777294736075530e-03,
  4.534206702341999e-06,  6.250091600605166e-09, -5.527490243409259e-11,  8.909525321229202e-14,  3.829514594765977e-16, -2.316273520945291e-18,  2.207925046947099e-21,
  2.517875570882217e-23, -1.165292280743223e-25,  1.218254422723359e-29,  8.169499110467978e-01, -2.950294260724092e-03,  4.039302323578892e-06,  1.040667876830419e-08,
 -6.088153551584431e-11,  3.794852710646231e-14,  6.545288387981690e-16, -2.349682662951941e-18, -2.564998230176832e-21,  4.251081868315265e-23, -8.990796338425960e-26,
 -4.043877176525777e-28,  8.938996669151581e-01, -3.104253109260253e-03,  3.334832526158634e-06,  1.484743174756788e-08, -6.184660784418062e-11, -3.864824681602676e-14,
  9.076505782914483e-16, -1.695406752545600e-18, -9.470476938814567e-21,  5.163715853833584e-23,  1.623608331372037e-26, -9.241307398543973e-28,  9.737842567378080e-01,
 -3.233119238093714e-03,  2.405302687503530e-06,  1.929842510690627e-08, -5.623736933709570e-11, -1.383052831342005e-13,  1.064406600307417e-15, -1.212144267349035e-19,
 -1.698831179498307e-20,  3.982369054721743e-23,  2.058349762909828e-25, -1.204246676768769e-27,  1.056356595668710e+00, -3.330038619671419e-03,  1.243792095178824e-06,
  2.336817020248083e-08, -4.219618370857466e-11, -2.517024242062142e-13,  1.021913149965201e-15,  2.402982823585375e-18, -2.181134109902720e-20, -4.829438230889699e-24,
  4.159931324169350e-25, -6.877311595151349e-28,  1.141291606281456e+00, -3.387367924682025e-03, -1.429941831740834e-07,  2.653469818559128e-08, -1.839906466171448e-11,
 -3.598493778069469e-13,  6.716060304339314e-16,  5.478443428367475e-18, -1.899894322963285e-20, -8.224896380837557e-23,  4.847651224361820e-25,  1.048573997670431e-27,
  1.228164203733726e+00, -3.396783162699632e-03, -1.727988028600867e-06,  2.815081851952909e-08,  1.521738820605462e-11, -4.324441335360294e-13, -5.569814999563039e-17,
  8.048092632145812e-18, -3.748890003767166e-21, -1.640101778857208e-22,  1.878361152364618e-25,  3.479064731445480e-27,  1.316421740896824e+00, -3.349552636768262e-03,
 -3.455323523079709e-06,  2.748635242399810e-08,  5.644973834941534e-11, -4.297654883121050e-13, -1.112915457978887e-15,  8.365320523757119e-18,  2.425971621944345e-20,
 -1.831921121461765e-22, -5.676087434872182e-25,  4.291162437448212e-27,  1.405350238106833e+00, -3.237075737785147e-03, -5.230837298424416e-06,  2.383500860180078e-08,
  9.969126848603278e-11, -3.119512224551362e-13, -2.241581435239262e-15,  4.536052703272478e-18,  5.456615799364243e-20, -5.861752616059241e-23, -1.390679918381730e-24,
  2.417557203043693e-28,  1.494034418550083e+00, -3.051827587912622e-03, -6.913493290722096e-06,  1.671878179694257e-08,  1.351598391903650e-10, -5.978591424088612e-14,
 -2.919459937086096e-15, -3.971301294638791e-18,  6.289844270518824e-20,  2.150050224733136e-22, -1.251447922207698e-24, -8.119622275998915e-27,  1.581313160037474e+00,
 -2.788879370700669e-03, -8.312155886350690e-06,  6.210943205433255e-09,  1.495446753370406e-10,  2.931438262833266e-13, -2.482121463984054e-15, -1.409147003465406e-17,
  2.302562971501680e-20,  4.440432078635535e-22,  6.537354652476794e-25, -1.082243174556879e-26,  1.665735063619294e+00, -2.448148767244566e-03, -9.195731417464503e-06,
 -6.656450665064404e-09,  1.296657280588179e-10,  6.310971470174687e-13, -5.699193216219091e-16, -1.829496487326625e-17, -5.824472408797634e-20,  2.807806245720399e-22,
  2.868456784405151e-24,  3.405976945145442e-27,  1.745524104903389e+00, -2.037399840642567e-03, -9.328325360764746e-06, -1.956628059995788e-08,  7.034951288684785e-11,
  7.681825165086875e-13,  2.173013224588482e-15, -9.179297668045590e-18, -1.099393927732884e-19, -3.162882778930908e-22,  1.671235481508498e-24,  1.918649223777185e-26,
  1.818573000391674e+00, -1.575642612038919e-03, -8.540666316204184e-06, -2.904129238528992e-08, -1.534565437238863e-11,  5.519660091007264e-13,  3.851847313202544e-15,
  9.637863268594744e-18, -4.928085509940336e-20, -6.243967534789336e-22, -2.657546396975809e-24,  2.280462745771987e-27,  1.882490500357435e+00, -1.095884223505729e-03,
 -6.836367989930282e-06, -3.151477840836611e-08, -9.207424191061054e-11,  4.543667752990388e-14,  2.685154626584627e-15,  1.928247665895958e-17,  7.133731782644079e-20,
 -3.046900970536378e-23, -2.541485462075266e-24, -1.973374901259215e-26,  1.934733140956975e+00, -6.452757024229837e-04, -4.498286918237284e-06, -2.548681137557918e-08,
 -1.176849611473462e-10, -3.973023645377664e-13, -4.120756210908640e-16,  7.258205222188102e-18,  7.648560424858297e-20,  4.710502258770907e-22,  1.907178999668402e-24,
  2.379201329753217e-27,  1.972842385857041e+00, -2.802297449349845e-04, -2.114829383846558e-06, -1.371156998013448e-08, -7.961938043153730e-11, -4.166433258808195e-13,
 -1.928700080076417e-15, -7.416052792409274e-18, -1.850113009965658e-20,  3.171788346266790e-23,  8.658224864968740e-25,  7.730067578153656e-27,  1.994779026614204e+00,
 -5.522020512085166e-05, -4.359771566232123e-07, -3.040914523855270e-09, -1.973252713163063e-11, -1.217810750287807e-13, -7.225625833934320e-16, -4.143695193241301e-18,
 -2.301675249146784e-20, -1.238072485550414e-22, -6.432926402008024e-25, -3.211368787230051e-27,  4.310212918692016e-04, -2.013999508091703e-06,  7.056426709179986e-09,
 -2.197545802251500e-11,  6.412862750782422e-14, -1.796873415360829e-16,  4.888664482913024e-19, -1.304926672124949e-21,  3.413066188959645e-24, -8.892429924350726e-27,
  2.246524991693047e-29, -5.889139350304098e-32,  3.879503169288689e-03, -1.811399584653777e-05,  6.335068827397358e-08, -1.966387382294478e-10,  5.708403111723884e-13,
 -1.587420257075607e-15,  4.274095186324211e-18, -1.125421773703297e-20,  2.891948313541886e-23, -7.374766260620426e-26,  1.810688900698405e-28, -4.613846853615908e-31,
  1.077812224381160e-02, -5.024970370438683e-05,  1.750987797660417e-07, -5.398798093285179e-10,  1.550664780616349e-12, -4.245348070618904e-15,  1.118372779963295e-17,
 -2.859902037519994e-20,  7.066910136840907e-23, -1.715399261053695e-25,  3.928573666844287e-28, -9.308509480938317e-31,  2.113015885267629e-02, -9.829117092596820e-05,
  3.406088442576546e-07, -1.039511917130576e-09,  2.936862968848119e-12, -7.844279431442161e-15,  1.994233488288003e-17, -4.851990243563732e-20,  1.116859570935763e-22,
 -2.459370493832489e-25,  4.804552220508534e-28, -9.358919646068813e-31,  3.494045612800759e-02, -1.620399743942063e-04,  5.573155433965360e-07, -1.677218967727458e-09,
  4.630517648596079e-12, -1.193542366498544e-14,  2.875314121671193e-17, -6.450368324514218e-20,  1.302982568221694e-22, -2.304395355341188e-25,  2.561520815112413e-28,
  3.070637726913065e-33,  5.221532252299730e-02, -2.412249168481472e-04,  8.217468162760145e-07, -2.428522458118430e-09,  6.502090241523795e-12, -1.594918289117842e-14,
  3.543979353555194e-17, -6.918857300853189e-20,  1.044415013798544e-22, -6.779595941130959e-26, -3.989451534320023e-28,  2.019427755872826e-30,  7.296239384969827e-02,
 -3.354961032697513e-04,  1.129479309942794e-06, -3.262755280384525e-09,  8.393715767092433e-12, -1.922153139420039e-14,  3.763839666397753e-17, -5.546194692493217e-20,
  1.694687009009481e-23,  2.678890222449503e-25, -1.454125525524645e-27,  4.646183412146091e-30,  9.719044737527643e-02, -4.444172296617315e-04,  1.475082373298781e-06,
 -4.143060011048463e-09,  1.012243836313768e-11, -2.102909846085629e-14,  3.304123472269496e-17, -1.777385495101819e-20, -1.386432436557416e-22,  7.498417024446143e-25,
 -2.667437056245962e-27,  6.705751390691939e-30,  1.249091578605283e-01, -5.674558655044648e-04,  1.852050629556934e-06, -5.026436765224531e-09,  1.148465848588591e-11,
 -2.063430419724846e-14,  1.969223984394411e-17,  4.639603705032497e-20, -3.523948525038947e-22,  1.282685277645350e-24, -3.567778965416848e-27,  6.449634802851761e-30,
  1.561287821428440e-01, -7.039714530850617e-04,  2.252725400584950e-06, -5.863875571282937e-09,  1.226214308224378e-11, -1.734205874001294e-14, -3.668641949662263e-18,
  1.350183150125423e-19, -5.933571198760449e-22,  1.697549695638772e-24, -3.506683236440886e-27,  2.031554502396735e-30,  1.908597547467510e-01, -8.532006810117411e-04,
  2.668205717158109e-06, -6.600621374872212e-09,  1.223004271461675e-11, -1.056955638173241e-14, -3.722028776907936e-17,  2.400950702854556e-19, -8.072201683134541e-22,
  1.764729974322943e-24, -1.802540804392370e-27, -7.661605904367579e-30,  2.291121717645954e-01, -1.014239814640874e-03,  3.088250411436922e-06, -7.176637312452674e-09,
  1.116746382572190e-11,  6.953484017972701e-17, -7.965120681002109e-17,  3.465716884215258e-19, -9.178195006158978e-22,  1.230568328004053e-24,  2.011015257879356e-27,
 -2.190692513943063e-29,  2.708951335147113e-01, -1.186023482596170e-03,  3.501173996825796e-06, -7.527355177677108e-09,  8.871255227701794e-12,  1.466585129194223e-14,
 -1.277566298449051e-16,  4.319057208682711e-19, -8.343546815699641e-22, -1.159904954047166e-25,  7.844137564539678e-27, -3.702927881542869e-29,  3.162159077609534e-01,
 -1.367299327101590e-03,  3.893740907308132e-06, -7.584832697717217e-09,  5.173773551359918e-12,  3.290082214188880e-14, -1.760924388363537e-16,  4.667383999352873e-19,
 -4.663395560876571e-22, -2.345485147070048e-24,  1.466940332920669e-26, -4.576428376576291e-29,  3.650788639098158e-01, -1.556597829958103e-03,  4.251065501054046e-06,
 -7.279477226544219e-09, -3.453176929328836e-14,  5.392213600106257e-14, -2.167655798259376e-16,  4.172450146650093e-19,  2.519313384620905e-22, -5.264917664959300e-24,
  2.021447558924080e-26, -3.785315757514551e-29,  4.174841137163434e-01, -1.752196533472840e-03,  4.556529476583500e-06, -6.542546646132350e-09, -6.776873744197177e-12,
  7.621576117606347e-14, -2.394805087658873e-16,  2.498549606743852e-19,  1.326618473171453e-21, -8.290057740241847e-24,  2.092634981833247e-26, -2.808012633544566e-30,
  4.734257744663128e-01, -1.952077801834474e-03,  4.791734642604726e-06, -5.309702019424296e-09, -1.495554262580884e-11,  9.748908555309274e-14, -2.320127583638156e-16,
 -6.092993869770855e-20,  2.660876686134084e-21, -1.035593117895819e-23,  1.249506700339717e-26,  6.432061163108302e-29,  5.328897448213810e-01, -2.153879241549566e-03,
  4.936518230067790e-06, -3.525962548989443e-09, -2.431076139448658e-11,  1.145906191214109e-13, -1.813412029897493e-16, -5.210473197027104e-19,  4.008928758128303e-21,
 -9.939575304675771e-24, -8.719629550159774e-27,  1.541275054050333e-28,  5.958508494957289e-01, -2.354835969615838e-03,  4.969071396368622e-06, -1.152497313003475e-09,
 -3.437376544955372e-11,  1.235079105540407e-13, -7.572922998163790e-17, -1.101706631778772e-18,  4.941813236205650e-21, -5.304931983986570e-24, -4.308739564894428e-26,
  2.329628315234279e-28,  6.622691640640822e-01, -2.551714171500997e-03,  4.866220947154347e-06,  1.824232842902639e-09, -4.441681617724734e-11,  1.195082376250387e-13,
  9.192578544595852e-17, -1.721839846047501e-18,  4.850919543747816e-21,  4.895449004350836e-24, -8.403123952294526e-26,  2.377438105964294e-28,  7.320852721901163e-01,
 -2.740735974273133e-03,  4.603961771487317e-06,  5.380425874002420e-09, -5.340629762905751e-11,  9.751660962885691e-14,  3.192148179690343e-16, -2.232014109607208e-18,
  3.030800611167352e-21,  2.055138994461764e-23, -1.142964452387084e-25,  8.667683780697045e-29,  8.052141304530533e-01, -2.917496818216985e-03,  4.158365590664099e-06,
  9.439476952005453e-09, -5.997084915974275e-11,  5.285983927390381e-14,  5.878135345959361e-16, -2.408003005436667e-18, -1.103287044132753e-21,  3.859627797378462e-23,
 -1.049002540781054e-25, -2.783133422562690e-28,  8.815371163863858e-01, -3.076878645742711e-03,  3.507042713313545e-06,  1.385286914456695e-08, -6.240575150952343e-11,
 -1.746681464400886e-14,  8.562163184665474e-16, -1.968671234168235e-18, -7.609347393631963e-21,  5.150676376703140e-23, -2.189213445586177e-26, -8.056988926801821e-28,
  9.608917094477748e-01, -3.212965989969548e-03,  2.631398210121231e-06,  1.837788409676735e-08, -5.874860398764405e-11, -1.128603035813889e-13,  1.053628084024102e-15,
 -6.404172101656144e-19, -1.541932228180101e-20,  4.698779892459296e-23,  1.522407858923483e-25, -1.222166296638486e-27,  1.043058101147774e+00, -3.318978461924467e-03,
  1.519997556022061e-06,  2.265411290651367e-08, -4.697993095058331e-11, -2.264480235877922e-13,  1.079421576746910e-15,  1.705384761026537e-18, -2.169383504850761e-20,
  1.111201886275362e-23,  3.789055041460257e-25, -9.861028741797563e-28,  1.127741855533958e+00, -3.387243758207509e-03,  1.734213605761068e-07,  2.618366390989666e-08,
 -2.542280782908785e-11, -3.419613763423441e-13,  8.160729438874932e-16,  4.826924552404041e-18, -2.160126568759456e-20, -6.210148952171598e-23,  5.184993496400032e-25,
  4.849420175212352e-28,  1.214551567713404e+00, -3.409252345917714e-03, -1.389002776887319e-06,  2.832510934372534e-08,  6.573298055516421e-12, -4.310956824879075e-13,
  1.670933601118197e-16,  7.835401529361767e-18, -9.482092267302554e-21, -1.535441843805560e-22,  3.324505283470367e-25,  3.065949353378604e-27,  1.302970354940228e+00,
 -3.375861187978366e-03, -3.120356244062664e-06,  2.831941565428897e-08,  4.760672838661274e-11, -4.535832294928649e-13, -8.688386145220191e-16,  9.032111000374284e-18,
  1.730325114302066e-20, -2.019456365617556e-22, -3.662531095971140e-25,  4.814285109781197e-27,  1.392320090852225e+00, -3.277751732662453e-03, -4.935462063199738e-06,
  2.537728038413895e-08,  9.292556232354636e-11, -3.640300845759156e-13, -2.090519830529133e-15,  6.237721515589582e-18,  5.146187233220379e-20, -1.135187207779574e-22,
 -1.341665168400941e-24,  1.985286292911491e-27,  1.481717814683400e+00, -3.106296385014912e-03, -6.699944448356982e-06,  1.886793287515071e-08,  1.332556480919202e-10,
 -1.309530796494473e-13, -3.001387101391790e-15, -1.845049751125017e-18,  6.965434473227360e-20,  1.581256348015999e-22, -1.583340179241423e-24, -6.859714881044671e-27,
  1.570025178077495e+00, -2.855037392475112e-03, -8.223085651134127e-06,  8.647191874548772e-09,  1.547803768201979e-10,  2.289363651390116e-13, -2.863933601352884e-15,
 -1.309480755600111e-17,  3.936077087854281e-20,  4.599797327942089e-22,  1.270171695641150e-25, -1.302472515193041e-26,  1.655794882006589e+00, -2.521997905578510e-03,
 -9.262747283507205e-06, -4.481744477195318e-09,  1.421083514413316e-10,  6.110714998230660e-13, -1.106593137549467e-15, -1.997469539986809e-17, -4.604543507627613e-20,
  3.973793689306655e-22,  2.931532841803753e-24, -7.032960856706320e-28,  1.737223793873998e+00, -2.112945304346137e-03, -9.555851251731918e-06, -1.831504025089398e-08,
  8.621177036433226e-11,  8.168430309482028e-13,  1.865130040231600e-15, -1.286494642923012e-17, -1.199129297330207e-19, -2.318999957868444e-22,  2.562417003873610e-24,
  2.113266709483223e-26,  1.812131567399292e+00, -1.645365226558295e-03, -8.890254197490972e-06, -2.919339721159720e-08, -3.361043910015567e-12,  6.474489702392470e-13,
  4.096105750083212e-15,  7.680997249216585e-18, -7.363397201191852e-20, -7.270849090426692e-22, -2.434110222412097e-24,  8.150885757163552e-27,  1.877995151216750e+00,
 -1.152112828240044e-03, -7.223342615048876e-06, -3.297700677900752e-08, -9.047601243528762e-11,  1.166154982395412e-13,  3.256708158420586e-15,  2.152633813660868e-17,
  6.819160716959185e-20, -1.505553481628155e-22, -3.488509841075501e-24, -2.325071266643130e-26,  1.932078082567753e+00, -6.825179820510660e-04, -4.815690169955272e-06,
 -2.743380219904044e-08, -1.257119471917804e-10, -4.044606507640521e-13, -1.719250315721326e-16,  9.991958865564436e-18,  9.483579709812365e-20,  5.487518087888867e-22,
  1.958639345163094e-24, -2.730233381985281e-28,  1.971686556098029e+00, -2.978288418294295e-04, -2.287295011323129e-06, -1.505472981252246e-08, -8.843229492224188e-11,
 -4.654895102842697e-13, -2.144414676639441e-15, -7.982424455199583e-18, -1.664693032258935e-20,  7.393198413668143e-23,  1.265520150797007e-24,  1.056644046519076e-26,
  1.994550931220414e+00, -5.885954494926446e-05, -4.744459926371175e-07, -3.377103151471739e-09, -2.235140983552516e-11, -1.406023901597281e-13, -8.496046720529850e-16,
 -4.956800282992054e-18, -2.797309593471155e-20, -1.525936017302378e-22, -8.020144295426518e-25, -4.034369438671805e-27,  4.230765507998146e-04, -1.958585742460531e-06,
  6.798760999059635e-09, -2.097752467977678e-11,  6.064931160134507e-14, -1.683809502121839e-16,  4.538106369830513e-19, -1.200662117265761e-21,  3.108506336816510e-24,
 -8.043777166957354e-27,  2.001181117829668e-29, -5.279100146785531e-32,  3.808046068437279e-03, -1.761647610840940e-05,  6.104479415321788e-08, -1.877538123613992e-10,
  5.400926945260306e-13, -1.488521221045861e-15,  3.971543635965232e-18, -1.036991394738949e-20,  2.639017149013124e-23, -6.689706767567207e-26,  1.617905486095296e-28,
 -4.161123142847917e-31,  1.057988456567012e-02, -4.887441227579975e-05,  1.687663304503706e-07, -5.157341126861565e-10,  1.468378348136536e-12, -3.986297934432457e-15,
  1.041370777842764e-17, -2.643346194193850e-20,  6.476686870068449e-23, -1.566210076618746e-25,  3.536537083410673e-28, -8.532591532096054e-31,  2.074236601982034e-02,
 -9.561540967381908e-05,  3.284115458642601e-07, -9.937516442804620e-10,  2.784655550400683e-12, -7.381570275273162e-15,  1.863250789315515e-17, -4.508398231867901e-20,
  1.031683270683912e-22, -2.275315293404351e-25,  4.400764032981811e-28, -9.008437031926920e-31,  3.430108756498692e-02, -1.576607149579465e-04,  5.376256878940445e-07,
 -1.605003464736027e-09,  4.398566037578058e-12, -1.126655794953638e-14,  2.700417865453523e-17, -6.046489682547102e-20,  1.221865339574293e-22, -2.202302866078990e-25,
  2.533541403663519e-28, -1.283514666534533e-31,  5.126338870217306e-02, -2.347657667731377e-04,  7.932183688953173e-07, -2.326995321936465e-09,  6.191457156310592e-12,
 -1.512149990749768e-14,  3.354891538442658e-17, -6.588840889810071e-20,  1.017338973331739e-22, -8.209943417934340e-26, -3.191955376092668e-28,  1.611844098363793e-30,
  7.163823632124244e-02, -3.266146268534505e-04,  1.091119514625907e-06, -3.131482719449850e-09,  8.018192919798948e-12, -1.833677528916734e-14,  3.609442638329255e-17,
 -5.477618136040725e-20,  2.559129440264875e-23,  2.136070926160463e-25, -1.264966436628109e-27,  3.960057497803639e-30,  9.543606874726702e-02, -4.328127159378168e-04,
  1.426323667126888e-06, -3.984422745136277e-09,  9.709743491394690e-12, -2.024255795620607e-14,  3.248536921398304e-17, -2.179855907332203e-20, -1.135004654512396e-22,
  6.488174578932654e-25, -2.389388762353223e-27,  5.934867957330894e-30,  1.226685895683596e-01, -5.528776368008400e-04,  1.792822381280975e-06, -4.845957620139422e-09,
  1.107679735767681e-11, -2.014733393620845e-14,  2.084020469020767e-17,  3.583123328521363e-20, -3.087196695364951e-22,  1.145530000393779e-24, -3.293125473839332e-27,
  6.018554549670599e-30,  1.533484989562476e-01, -6.862278069896681e-04,  2.183524601631069e-06, -5.670459547787933e-09,  1.191471680236511e-11, -1.738683006836470e-14,
 -1.449579245675380e-19,  1.169817892521415e-19, -5.347470716609085e-22,  1.559234040493467e-24, -3.405543950625045e-27,  2.520153276817914e-30,  1.874891463417254e-01,
 -8.321685548987705e-04,  2.590165217755105e-06, -6.406678121777353e-09,  1.201024841544612e-11, -1.138503206388980e-14, -3.084981256897590e-17,  2.152659707819276e-19,
 -7.450634610007001e-22,  1.686483674547589e-24, -2.095827589972348e-27, -5.746252302671130e-30,  2.251040833757943e-01, -9.898752529431877e-04,  3.003202558533495e-06,
 -6.998047390658257e-09,  1.115050728084618e-11, -1.728923428100380e-15, -7.035162275836466e-17,  3.179239743008895e-19, -8.722938866923932e-22,  1.292769234916587e-24,
  1.123758140981467e-27, -1.851182067280577e-29,  2.662064897238959e-01, -1.158372969458738e-03,  3.411706526117378e-06, -7.383231095038574e-09,  9.134874623394372e-12,
  1.174179370051960e-14, -1.160372746578049e-16,  4.051970030261422e-19, -8.332641944908051e-22,  1.663955340416143e-25,  6.304435582839867e-27, -3.301178299846791e-29,
  3.108084359105887e-01, -1.336512016006882e-03,  3.803240579990273e-06, -7.497013401841812e-09,  5.790577339968877e-12,  2.882966736027758e-14, -1.632445927233492e-16,
  4.505738866917904e-19, -5.406937869056981e-22, -1.798257699017578e-24,  1.271045011753043e-26, -4.323055232764484e-29,  3.589199364902416e-01, -1.522938650104198e-03,
  4.163743143165661e-06, -7.271680869035373e-09,  9.928375082382867e-13,  4.886069775948429e-14, -2.049972544049506e-16,  4.224269764563618e-19,  7.654038283540923e-23,
 -4.490393170068370e-24,  1.849574778716439e-26, -4.005585040890806e-29,  4.105477323684082e-01, -1.716060069377619e-03,  4.477417634486570e-06, -6.639091925385978e-09,
 -5.309443529069058e-12,  7.055670729058816e-14, -2.319339611667727e-16,  2.876927918793538e-19,  1.043183907757360e-21, -7.458701057625591e-24,  2.056588559518366e-26,
 -1.319317595830941e-29,  4.656937219258642e-01, -1.914002712082557e-03,  4.726645847876378e-06, -5.533695403709399e-09, -1.306153388821185e-11,  9.190958772234212e-14,
 -2.325820522142939e-16,  1.835472845031778e-20,  2.297685888599379e-21, -9.805616457585112e-24,  1.487452626654444e-26,  4.425473841108313e-29,  5.243529350660533e-01,
 -2.114562781820639e-03,  4.891947697274489e-06, -3.896841404991457e-09, -2.206357912799880e-11,  1.100775219197954e-13, -1.941887262160931e-16, -3.985413086466471e-19,
  3.646389882822868e-21, -1.016045049815566e-23, -2.513942833525311e-27,  1.280766871750061e-28,  5.865109102169254e-01, -2.315147880940443e-03,  4.952022714581296e-06,
 -1.682825214548881e-09, -3.192418936225607e-11,  1.213379173375948e-13, -1.043940506383535e-16, -9.469371613530233e-19,  4.722232955844000e-21, -6.828985268382914e-24,
 -3.326014809348917e-26,  2.130948276980477e-28,  6.521402887392492e-01, -2.512708739770079e-03,  4.883926946622807e-06,  1.132788898838790e-09, -4.200840310682895e-11,
  1.211535993718246e-13,  4.590947029063814e-17, -1.564418707137239e-18,  4.969202972756612e-21,  1.746412985037452e-24, -7.336589014578547e-26,  2.452788089854549e-28,
  7.211963802844180e-01, -2.703660395347267e-03,  4.663465529162684e-06,  4.541922982444965e-09, -5.138435666184922e-11,  1.044394201746115e-13,  2.581812035702794e-16,
 -2.124064676190984e-18,  3.689445687669019e-21,  1.607418131523661e-23, -1.091380465828646e-25,  1.451641803796907e-28,  7.936113715131435e-01, -2.883793025456082e-03,
  4.265919420212664e-06,  8.489144468771770e-09, -5.877805375415226e-11,  6.615553996781565e-14,  5.200981588814075e-16, -2.421908401454907e-18,  2.080205250040010e-22,
  3.419044572679243e-23, -1.145434885731177e-25, -1.619589622206516e-28,  8.692867433150926e-01, -3.048174360072350e-03,  3.667278227110478e-06,  1.285267972123619e-08,
 -6.255419579274100e-11,  2.395093668082775e-15,  7.979616955463423e-16, -2.182738514451650e-18, -5.779060567971350e-21,  4.996059468994803e-23, -5.444236018404261e-26,
 -6.721163489121801e-28,  9.480833218040166e-01, -3.191048808127814e-03,  2.846222896995445e-06,  1.742121563593107e-08, -6.075467316436531e-11, -8.784256359349849e-14,
  1.029050615483330e-15, -1.105700082094299e-18, -1.363104972974487e-20,  5.200905425915345e-23,  9.909007568702199e-26, -1.185511178261932e-27,  1.029808210491069e+00,
 -3.305744197579242e-03,  1.787191982285552e-06,  2.186762472295844e-08, -5.124636590327568e-11, -2.000468693454850e-13,  1.117533992005220e-15,  1.020418478063094e-18,
 -2.103210484213580e-20,  2.532933053945743e-23,  3.303406351296465e-25, -1.208402394274289e-27,  1.114197634762685e+00, -3.384606999104132e-03,  4.849626126471469e-07,
  2.572329384552188e-08, -3.205564231097116e-11, -3.208338109979533e-13,  9.412421027927174e-16,  4.103948344406875e-18, -2.345994581498045e-20, -4.109781253355814e-23,
  5.277061636848640e-25, -6.079016744551875e-29,  1.200894488656075e+00, -3.419003628429462e-03, -1.048754043308717e-06,  2.836159860485441e-08, -1.990941017428887e-12,
 -4.244920435461445e-13,  3.814254259531903e-16,  7.446354323934038e-18, -1.473921669352386e-20, -1.377048786149465e-22,  4.553931236011643e-25,  2.500776190458332e-27,
  1.289419154127255e+00, -3.399452453325486e-03, -2.776255807728352e-06,  2.900750405064033e-08,  3.834732187955369e-11, -4.713448066291686e-13, -6.092983098982064e-16,
  9.467086927757596e-18,  9.821400446110238e-21, -2.122708718715474e-22, -1.483774661963552e-25,  5.038068840613315e-27,  1.379132080133838e+00, -3.315992614685034e-03,
 -4.622262764616447e-06,  2.680318120897956e-08,  8.515832738733555e-11, -4.119247415570537e-13, -1.893495779742563e-15,  7.808958026589766e-18,  4.643483190158334e-20,
 -1.649369399713875e-22, -1.217074031036264e-24,  3.654301724680385e-27,  1.469186914870689e+00, -3.158954258832492e-03, -6.460835855476903e-06,  2.097514397261544e-08,
  1.299133914054392e-10, -2.033496278892754e-13, -3.021077993715900e-15,  4.621855667485222e-19,  7.413868686856024e-20,  8.926509283773368e-23, -1.846034038012540e-24,
 -4.986943336656297e-27,  1.558474176186907e+00, -2.920364589099513e-03, -8.104321765749352e-06,  1.115645124683611e-08,  1.586428615746571e-10,  1.559597394014948e-13,
 -3.210464832525049e-15, -1.157048594382339e-17,  5.586873083517803e-20,  4.530995679143187e-22, -4.818914732816706e-25, -1.451249047342240e-26,  1.645558401596379e+00,
 -2.596275435611895e-03, -9.302487708962136e-06, -2.111875389040262e-09,  1.540180950084969e-10,  5.776492910963043e-13, -1.684201754729502e-15, -2.119677147478500e-17,
 -2.964931426809872e-20,  5.126064965289923e-22,  2.793382051619539e-24, -5.701676553308408e-27,  1.728617761854925e+00, -2.190246529927761e-03, -9.766808763701168e-06,
 -1.680265527737246e-08,  1.029648135494478e-10,  8.568429634840425e-13,  1.450087169446875e-15, -1.681411522406470e-17, -1.261895815886190e-19, -1.105310644719160e-22,
  3.509874008864685e-24,  2.165150039333773e-26,  1.805405643778690e+00, -1.717888438241198e-03, -9.240452818397018e-06, -2.913817274044050e-08,  1.058694028823051e-11,
  7.480452249134092e-13,  4.274121362342510e-15,  4.887942648391435e-18, -1.014562708491191e-19, -8.151793694836904e-22, -1.915804753081714e-24,  1.567305554285084e-26,
  1.873268585696360e+00, -1.211506869079635e-03, -7.627661100564000e-06, -3.440150845779223e-08, -8.731202133391296e-11,  2.022499029965712e-13,  3.888976789235753e-15,
  2.359276191669074e-17,  6.000497928779956e-20, -3.114612933088405e-22, -4.577443290206426e-24, -2.607410952608943e-26,  1.929268825542707e+00, -7.223951353044898e-04,
 -5.157231538231265e-06, -2.951002971632294e-08, -1.338179087374247e-10, -4.048678345857320e-13,  1.534134485577079e-16,  1.335781734892099e-17,  1.159881064443710e-19,
  6.257237182581129e-22,  1.858507030425111e-24, -4.600405249877885e-27,  1.970457464936872e+00, -3.168746086283305e-04, -2.476757760640177e-06, -1.654699821021567e-08,
 -9.827514810305375e-11, -5.196949202620735e-13, -2.374905052465870e-15, -8.461802344464605e-18, -1.295297552285685e-20,  1.348729347013650e-22,  1.808510967972181e-24,
  1.427439398238453e-26,  1.994307636370825e+00, -6.282351458049329e-05, -5.172134855701135e-07, -3.758379051562825e-09, -2.537914991855454e-11, -1.627648440413981e-13,
 -1.001799100028685e-15, -5.946388920945264e-18, -3.408928419132733e-20, -1.885118176298925e-22, -1.001418995562082e-24, -5.067998164255686e-27,  };
  constexpr double w[14592] = {  8.154963321546213e-02, -2.811954192770734e-04,  1.021022504948982e-06, -3.851762649345345e-09,  1.489503891910817e-11,
 -5.841458846364859e-14,  2.305739692005181e-16, -9.116286163604409e-19,  3.599830571745387e-21, -1.417450325539196e-23,  5.560735363736921e-26, -2.172700832350250e-28,
  8.114997578958850e-02, -4.103890096689552e-04,  2.414278335578741e-06, -1.420064082264241e-08,  8.090552025808234e-11, -4.464094722262895e-13,  2.396894263473899e-15,
 -1.257844371583211e-17,  6.473267651022011e-20, -3.275204421407986e-22,  1.632376858450198e-24, -8.026659089634917e-27,  8.035895908761528e-02, -6.641778501783889e-04,
  5.755919513316935e-06, -4.564869525630858e-08,  3.372558677381095e-10, -2.362063039769665e-12,  1.585665014042268e-14, -1.027785805699464e-16,  6.466080924057475e-19,
 -3.964052553278839e-21,  2.375367697564500e-23, -1.394653512894773e-25,  7.919280615384783e-02, -1.033608195879714e-03,  1.209624784045728e-05, -1.230417849668717e-07,
  1.137979429916883e-09, -9.805745108752963e-12,  7.988801956285995e-14, -6.214928021759330e-16,  4.649707676695276e-18, -3.363233248456145e-20,  2.361642659733794e-22,
 -1.615082250400053e-24,  7.767494528069141e-02, -1.505837680708530e-03,  2.286732360998171e-05, -2.911464481736580e-07,  3.297166295072995e-09, -3.423043955695676e-11,
  3.318316932524993e-13, -3.040984054444825e-15,  2.657766935000591e-17, -2.229805619671726e-19,  1.804899745747494e-21, -1.415086049932655e-23,  7.583499495608953e-02,
 -2.064789832923499e-03,  3.972825052343287e-05, -6.213949661348231e-07,  8.470638857357705e-09, -1.043017358042335e-10,  1.185647993200877e-12, -1.262462395192521e-14,
  1.272203618137091e-16, -1.222629854898551e-18,  1.127171225204177e-20, -1.001452661477179e-22,  7.370752339430521e-02, -2.691947009194195e-03,  6.438541130413046e-05,
 -1.217602828310941e-06,  1.970070260181813e-08, -2.840910748015545e-10,  3.742807978082194e-12, -4.579964115382047e-14,  5.266527483952603e-16, -5.740474765186827e-18,
  5.970680449618925e-20, -5.956583750061308e-22,  7.133066483020103e-02, -3.367224312506848e-03,  9.840597574311581e-05, -2.218704297827744e-06,  4.209875034386222e-08,
 -7.033360352792946e-10,  1.063364026712385e-11, -1.481635996038089e-13,  1.927298536626119e-15, -2.363002375924825e-17,  2.750951963045979e-19, -3.058315198093188e-21,
  6.874467930795479e-02, -4.069864584237307e-03,  1.430428826629012e-04, -3.796924769444486e-06,  8.358825194909599e-08, -1.602602619642013e-09,  2.756487169323186e-11,
 -4.338235319775638e-13,  6.335484368053293e-15, -8.675047367526777e-17,  1.122692592987951e-18, -1.381760001684942e-20,  6.599053970600922e-02, -4.779297591875014e-03,
  1.990873379067188e-04, -6.150488159180615e-06,  1.555766472203503e-07, -3.393739020091909e-09,  6.589137184054427e-11, -1.162914318904787e-12,  1.893814627367818e-14,
 -2.877603446751065e-16,  4.114791758546685e-18, -5.573925737764806e-20,  6.310862015285371e-02, -5.475914292019842e-03,  2.667610914290939e-04, -9.490816208750956e-06,
  2.733850628861520e-07, -6.731815727709882e-09,  1.464854786495546e-10, -2.880114249995878e-12,  5.198108870400599e-14, -8.713962353876050e-16,  1.369184999512069e-17,
 -2.030597379461874e-19,  6.013754538807620e-02, -6.141718278259121e-03,  3.456559597262113e-04, -1.402506032341564e-05,  4.562539244342692e-07, -1.258929039787603e-08,
  3.049937614335837e-10, -6.639648549616388e-12,  1.320531724499025e-13, -2.429199884498300e-15,  4.172792941007908e-17, -6.742557956168789e-19,  5.711324296851759e-02,
 -6.760829709703208e-03,  4.347229217727025e-04, -1.993556572298159e-05,  7.267688548144330e-07, -2.231752583812148e-08,  5.982194441865001e-10, -1.433721998433046e-11,
  3.125485762448513e-13, -6.277615963284536e-15,  1.173299808393228e-16, -2.056232969405129e-18,  5.406822155213632e-02, -7.319830610120951e-03,  5.323082810560045e-04,
 -2.735838419823073e-05,  1.109614819565504e-06, -3.767656038964202e-08,  1.110866982369607e-09, -2.915196672366091e-11,  6.930745487117178e-13, -1.512730393980032e-14,
  3.062510084152409e-16, -5.796274570513957e-18,  5.103108067511054e-02, -7.807953051082662e-03,  6.362303755349033e-04, -3.636315749273542e-05,  1.629658764219985e-06,
 -6.081276161967818e-08,  1.961313980599113e-09, -5.606923932256437e-11,  1.446825911610418e-12, -3.416220944883506e-14,  7.459532411850950e-16, -1.518541054925804e-17,
  4.802624195614964e-02, -8.217122323966730e-03,  7.438874753838615e-04, -4.693657684306790e-05,  2.309466756405463e-06, -9.416685381456858e-08,  3.304574326454932e-09,
 -1.024092390454178e-10,  2.855119586460466e-12, -7.261605136910877e-14,  1.703245929391418e-15, -3.714913021387001e-17,  4.507387950946067e-02, -8.541875100476192e-03,
  8.523859804475567e-04, -5.897122616166037e-05,  3.166462359957864e-06, -1.403021586792461e-07,  5.330357584132167e-09, -1.782348070487871e-10,  5.345244811406901e-12,
 -1.458345154116531e-13,  3.660019325128252e-15, -8.520982530201171e-17,  4.219001899754212e-02, -8.779177522068466e-03,  9.586777752008574e-04, -7.226101602487499e-05,
  4.210010797443959e-06, -2.016540783816727e-07,  8.254274146052450e-09, -2.964672991937149e-10,  9.523822741797358e-12, -2.776260802243687e-13,  7.427141172462947e-15,
 -1.839070681026445e-16,  3.938677020537178e-02, -8.928170248609103e-03,  1.059696431714067e-03, -8.650371267424864e-05,  5.438754836314000e-06, -2.802152735979763e-07,
  1.230088125855977e-08, -4.725196545826204e-10,  1.619380884760261e-11, -5.024407685537253e-13,  1.427572898663833e-14, -3.746541965218148e-16,  3.667265688978436e-02,
 -8.989867113985139e-03,  1.152483589742191e-03, -1.013103617903548e-04,  6.838526350501734e-06, -3.771843781933572e-07,  1.767840464485247e-08, -7.232769363833289e-10,
  2.634044017732538e-11, -8.666212371256357e-13,  2.605890601522137e-14, -7.223923306075648e-16,  3.405300932019072e-02, -8.966831731782464e-03,  1.234298968254769e-03,
 -1.162207876546913e-04,  8.381112713209165e-06, -4.926169810231122e-07,  2.454647317187935e-08, -1.065327070402495e-09,  4.107139258678431e-11, -1.427734749320859e-12,
  4.527851441418876e-14, -1.321484528674547e-15,  3.153038862216556e-02, -8.862852788048879e-03,  1.302709765660658e-03, -1.307238763797231e-04,  1.002407684770138e-05,
 -6.251238419754632e-07,  3.297982809512112e-08, -1.512467320474376e-09,  6.150051015180468e-11, -2.250937743116828e-12,  7.503589875339029e-14, -2.298241172079322e-15,
  2.910501699348483e-02, -8.682634454975604e-03,  1.355657424588660e-03, -1.442810596806567e-04,  1.171172601106885e-05, -7.716614889034796e-07,  4.293240437340876e-08,
 -2.072670436662413e-09,  8.857326356991871e-11, -3.401563719750258e-12,  1.188019605170747e-13, -3.806644097794641e-15,  2.677519338483160e-02, -8.431513884328919e-03,
  1.391501677254457e-03, -1.563513073600100e-04,  1.337721164152042e-05, -9.274540693412770e-07,  5.420711569038837e-08, -2.744860635180578e-09,  1.228449172471389e-10,
 -4.933727185538209e-12,  1.799575321579634e-13, -6.013750158557903e-15,  2.453767975318796e-02, -8.115213502159416e-03,  1.409043329832333e-03, -1.664159932542070e-04,
  1.494563507938196e-05, -1.086073268326778e-06,  6.643685765496150e-08, -3.515987635445113e-09,  1.642371621887033e-10, -6.875673340381534e-12,  2.610957357449296e-13,
 -9.072410596301878e-15,  2.238804808492416e-02, -7.739632107583043e-03,  1.407528339474982e-03, -1.740021860692938e-04,  1.633794359353178e-05, -1.239686815324993e-06,
  7.908154650860549e-08, -4.358960380737390e-09,  2.118124637836063e-10, -9.213725924171500e-12,  3.631414765689781e-13, -1.308160989053986e-14,  2.032098277971887e-02,
 -7.310675736471724e-03,  1.386636393738967e-03, -1.787031907561234e-04,  1.747533618049294e-05, -1.379467749042773e-06,  9.144445753836057e-08, -5.231982578781816e-09,
  2.636138288321329e-10, -1.187773343595137e-11,  4.844185432016659e-13, -1.803869717977590e-14,  1.833053655279300e-02, -6.834126939742433e-03,  1.346457468355601e-03,
 -1.801954846633649e-04,  1.828386315264083e-05, -1.496138566641259e-06,  1.027088955926477e-07, -6.079707547208887e-09,  3.166177909778621e-10, -1.473156624358766e-11,
  6.198623915262566e-13, -2.379223184878373e-14,  1.641034072729156e-02, -6.315549520352771e-03,  1.287459789109333e-03, -1.782515173007311e-04,  1.869889772986841e-05,
 -1.580608878756964e-06,  1.119936208904073e-07, -6.836408241955017e-09,  3.668382328028356e-10, -1.757217862077009e-11,  7.606126544440797e-13, -3.000773433861646e-14,
  1.455377270579471e-02, -5.760224794902086e-03,  1.210452340272756e-03, -1.727481430201943e-04,  1.866917860782103e-05, -1.624653997590651e-06,  1.184228401824018e-07,
 -7.431068599319498e-09,  4.095984407820765e-10, -2.013984724314414e-11,  8.942024996322026e-13, -3.615976741525461e-14,  1.275408463635666e-02, -5.173114988179516e-03,
  1.116544627156250e-03, -1.636707118608962e-04,  1.816016452080909e-05, -1.621576135152383e-06,  1.212043393584218e-07, -7.793989460679854e-09,  4.399611758257213e-10,
 -2.214045810303685e-11,  1.005481623171755e-12, -4.156125119447721e-14,  1.100449796315273e-02, -4.558849318552359e-03,  1.007105886597464e-03, -1.511130444326290e-04,
  1.715649879206760e-05, -1.566790006500477e-06,  1.197078104225967e-07, -7.864219606684871e-09,  4.532762740184400e-10, -2.327839547284382e-11,  1.078272304026023e-12,
 -4.543441392291867e-14,  9.298268848864278e-03, -3.921728591930404e-03,  8.837254086211221e-04, -1.352736600185553e-04,  1.566344734911928e-05, -1.458280375317828e-06,
  1.135348446685346e-07, -7.596921369069010e-09,  4.457783113161518e-10, -2.329614658555560e-11,  1.097588609329182e-12, -4.701823987961449e-14,  7.628729670465515e-03,
 -3.265744664726716e-03,  7.481751453541935e-04, -1.164487196163424e-04,  1.370724214510679e-05, -1.296889672844963e-06,  1.025725270263474e-07, -6.969701183147980e-09,
  4.151490768153397e-10, -2.201473572519530e-11,  1.052087109677997e-12, -4.569687423526428e-14,  5.989312888338608e-03, -2.594612254745174e-03,  6.023754575523013e-04,
 -9.502220993303112e-05,  1.133433034205318e-05, -1.086408236284036e-06,  8.702404715327352e-08, -5.987000266042673e-09,  3.609555813134938e-10, -1.936807400986458e-11,
  9.363079236722506e-13, -4.112511405861698e-14,  4.373571387604503e-03, -1.911814736142369e-03,  4.483653012446901e-04, -7.145403775591779e-05,  8.609606292028891e-06,
 -8.334576826470731e-07,  6.741216557308722e-08, -4.681853731856210e-09,  2.848865445547680e-10, -1.542463470100081e-11,  7.522453518544747e-13, -3.332372311187550e-14,
  2.775283166909575e-03, -1.220698858471772e-03,  2.882856022330090e-04, -4.626793949911908e-05,  5.613908202300995e-06, -5.471899377984289e-07,  4.455544514466074e-08,
 -3.114731102952234e-09,  1.907419841001946e-10, -1.039184474561561e-11,  5.098863122729168e-13, -2.272112424344607e-14,  1.190273717598659e-03, -5.253367239069971e-04,
  1.245463805353513e-04, -2.006721992522140e-05,  2.444291724243302e-06, -2.391529487727576e-07,  1.954576888344266e-08, -1.371353666033057e-09,  8.427800688341733e-11,
 -4.607463674934880e-12,  2.268332289184219e-13, -1.014113058524437e-14,  8.044090076951303e-02, -2.732081592729726e-04,  9.761936740467304e-07, -3.622496142743048e-09,
  1.378008265600129e-11, -5.317456003335069e-14,  2.065873353600405e-16, -8.041872717137439e-19,  3.127386233818681e-21, -1.213004663459866e-23,  4.688311120883336e-26,
 -1.804989304391296e-28,  7.954599915356921e-02, -3.917350662560869e-04,  2.251352752532866e-06, -1.297456813471682e-08,  7.252522260670276e-11, -3.928867542405849e-13,
  2.072011538857017e-15, -1.068370710950574e-17,  5.403690680582015e-20, -2.687710498980183e-22,  1.317149938401132e-24, -6.369487868163600e-27,  7.779099803445008e-02,
 -6.202333585389674e-04,  5.239017174655808e-06, -4.061079240002317e-08,  2.935986483728521e-10, -2.013824493790315e-12,  1.324831793624975e-14, -8.419839396758837e-17,
  5.196234374318736e-19, -3.126074005558443e-21,  1.838853146083064e-23, -1.060148224146552e-25,  7.524298031166202e-02, -9.424489445443682e-04,  1.072284263323420e-05,
 -1.063044871618017e-07,  9.597104798672822e-10, -8.081497721419897e-12,  6.439950796244687e-14, -4.903815838955216e-16,  3.593151999473854e-18, -2.546686829829488e-20,
  1.753030876069645e-22, -1.175692299509391e-24,  7.199654549366057e-02, -1.336026648121158e-03,  1.966882862552034e-05, -2.434632607120306e-07,  2.685767088725508e-09,
 -2.719909232521561e-11,  2.574768756024276e-13, -2.306134100723185e-15,  1.971268348500132e-17, -1.618515937710966e-19,  1.282780793912554e-21, -9.852220427083442e-24,
  6.816731728367406e-02, -1.774635831966453e-03,  3.302055174553656e-05, -5.011193390373904e-07,  6.642742604972198e-09, -7.966578799726281e-11,  8.831102005409436e-13,
 -9.178732058627371e-15,  9.036096689690460e-17, -8.489501848021734e-19,  7.656032907268985e-21, -6.657411806018528e-23,  6.388439733481542e-02, -2.230352206326143e-03,
  5.149264043504246e-05, -9.433695808560581e-07,  1.482236939151421e-08, -2.079236435998208e-10,  2.668302494309059e-12, -3.183913261007474e-14,  3.573374536570211e-16,
 -3.804468622398919e-18,  3.867729759637979e-20, -3.773790468395881e-22,  5.928250361150086e-02, -2.676008961737345e-03,  7.540014615776273e-05, -1.645086295602120e-06,
  3.028100701168822e-08, -4.916586705419619e-10,  7.234345558474952e-12, -9.821519685457046e-14,  1.246032895365815e-15, -1.491256481352703e-17,  1.695890816701572e-19,
 -1.842931568518902e-21,  5.449449810794840e-02, -3.087259283688024e-03,  1.045526065500090e-04, -2.683736534493171e-06,  5.727504971759584e-08, -1.066504188344346e-09,
  1.784214108663456e-11, -2.734537163755332e-13,  3.892918167716736e-15, -5.200880446248270e-17,  6.572245639923377e-19, -7.903827223807049e-21,  4.964489169353686e-02,
 -3.444156078168916e-03,  1.382277649838145e-04, -4.128288909956173e-06,  1.011953871052941e-07, -2.143149784630238e-09,  4.045811501774189e-11, -6.951281015291325e-13,
  1.103196488299469e-14, -1.635095886179577e-16,  2.282490970261038e-18, -3.020571770429953e-20,  4.484473999506249e-02, -3.732138912639627e-03,  1.752245011064947e-04,
 -6.027102929045349e-06,  1.682340721889759e-07, -4.021518101759305e-09,  8.507691779900378e-11, -1.628265823202041e-12,  2.863670859718064e-14, -4.682323854566521e-16,
  7.181848283918506e-18, -1.040526898165442e-19,  4.018814555969367e-02, -3.942406446245881e-03,  2.139808946048647e-04, -8.397122905309109e-06,  2.647705532925930e-07,
 -7.093436576948051e-09,  1.670955759278641e-10, -3.541362261372715e-12,  6.864161906711406e-14, -1.231749954113255e-15,  2.065713627797680e-17, -3.261247617137698e-19,
  3.575038920155123e-02, -4.071730344368949e-03,  2.527340082792371e-04, -1.121653503556935e-05,  3.965341979311695e-07, -1.182772897983500e-08,  3.083829760541709e-10,
 -7.197615497106794e-12,  1.529640697949724e-13, -2.997905645270584e-15,  5.471988667628631e-17, -9.372466220002777e-19,  3.158755225976578e-02, -4.121823487892398e-03,
  2.896941488024514e-04, -1.442236681933544e-05,  5.676641658190739e-07, -1.873423793305366e-08,  5.375850174220817e-10, -1.374590400496889e-11,  3.187477325398055e-13,
 -6.791796031319065e-15,  1.343421444231900e-16, -2.486133697114398e-18,  2.773737688149002e-02, -4.098406357496950e-03,  3.232078881378000e-04, -1.791352126552542e-05,
  7.798272939854881e-07, -2.830760296259857e-08,  8.892083951342154e-10, -2.478594061330130e-11,  6.242309677405058e-13, -1.439808087242936e-14,  3.073589616538636e-16,
 -6.121514056100572e-18,  2.422104863117369e-02, -4.010121305191083e-03,  3.518897682477693e-04, -2.155870983332590e-05,  1.031557294043850e-06, -4.095661829303085e-08,
  1.401170680488513e-09, -4.237534057256753e-11,  1.153984735484773e-12, -2.869294735701086e-14,  6.584453846790404e-16, -1.406059176310640e-17,  2.104557116972618e-02,
 -3.867429628422353e-03,  3.747105396914611e-04, -2.520791877563898e-05,  1.317943222688249e-06, -5.692928451437177e-08,  2.110783376496699e-09, -6.894698362697641e-11,
  2.021647719923123e-12, -5.397087550332165e-14,  1.326359761920795e-15, -3.025845943750665e-17,  1.820642677927279e-02, -3.681597852971786e-03,  3.910381094542764e-04,
 -2.870556984117912e-05,  1.630731707237047e-06, -7.624597349783791e-08,  3.049491337485986e-09, -1.071155004370873e-10,  3.367969943758373e-12, -9.616647240494803e-14,
  2.521689078493545e-15, -6.124358238342250e-17,  1.569026645942142e-02, -3.463844818927788e-03,  4.006345559319962e-04, -3.190346498834268e-05,  1.958832535489831e-06,
 -9.865272535600343e-08,  4.237035242306189e-09, -1.593715693073917e-10,  5.352207326823582e-12, -1.628412469663115e-13,  4.539982019060873e-15, -1.169855900095965e-16,
  1.347743632195539e-02, -3.224686516243177e-03,  4.036176563665916e-04, -3.467188318642253e-05,  2.289149007537506e-06, -1.236036447741273e-07,  5.675937025278398e-09,
 -2.276882444597381e-10,  8.135816764321422e-12, -2.628021192748377e-13,  7.763139418732720e-15, -2.115378362391904e-16,  1.154421204712135e-02, -2.973485800030586e-03,
  4.003980385078579e-04, -3.690770720460102e-05,  2.607607109930297e-06, -1.502764384432780e-07,  7.347261099971293e-09, -3.130885337372223e-10,  1.185890994021967e-11,
 -4.052559257771367e-13,  1.264123957595736e-14, -3.630853344498686e-16,  9.864672192062373e-03, -2.718191730214885e-03,  3.916035088677680e-04, -3.853905806873802e-05,
  2.900238342374328e-06, -1.776195514367200e-07,  9.208455778863223e-09, -4.152410562851476e-10,  1.661174001157708e-11, -5.984851368726299e-13,  1.964853334000918e-14,
 -5.929827742337383e-16,  8.412189359778756e-03, -2.465239051733141e-03,  3.780008539528982e-04, -3.952647747795828e-05,  3.154179574542045e-06, -2.044243879490355e-07,
  1.119376280996852e-08, -5.321555639393055e-10,  2.240517130712554e-11, -8.481430585451234e-13,  2.921159034551732e-14, -9.234420993345912e-16,  7.160553739557071e-03,
 -2.219571584717943e-03,  3.604231225773911e-04, -3.986113511998233e-05,  3.358483324023328e-06, -2.294127185102116e-07,  1.321727353193252e-08, -6.600403855874127e-10,
  2.914514940961523e-11, -1.155387118175374e-12,  4.161412267312963e-14, -1.373755737532165e-15,  6.084766610832433e-03, -1.984752515626934e-03,  3.397077121603894e-04,
 -3.956080638637731e-05,  3.504673803906138e-06, -2.513280616296573e-07,  1.517830044964474e-08, -7.933612674879860e-10,  3.661630455019489e-11, -1.515164371698882e-12,
  5.689054752100059e-14, -1.955305150664300e-15,  5.161553757221778e-03, -1.763127935207949e-03,  3.166480016959541e-04, -3.866446640717037e-05,  3.587028153342792e-06,
 -2.690205341673490e-07,  1.696840680783586e-08, -9.251106192733124e-10,  4.447887730545369e-11, -1.915004369680215e-12,  7.472690864703022e-14, -2.666034441738459e-15,
  4.369652736975713e-03, -1.556015690401029e-03,  2.919591237285586e-04, -3.722630820533729e-05,  3.602600501663121e-06, -2.815169283857824e-07,  1.847924881135421e-08,
 -1.047264421285950e-09,  5.228131180606285e-11, -2.334643036162934e-12,  9.439128029397574e-14, -3.485450189309950e-15,  3.689926088351574e-03, -1.363898242787994e-03,
  2.662568999476544e-04, -3.530986064334085e-05,  3.551034054351928e-06, -2.880709099065749e-07,  1.961035262225477e-08, -1.151377333417539e-09,  5.948849412315975e-11,
 -2.746697052675008e-12,  1.147146988946996e-13, -4.371412636611835e-15,  3.105347054409765e-03, -1.186604699279571e-03,  2.400479953311160e-04, -3.298270217596546e-05,
  3.434221554220504e-06, -2.881915333431915e-07,  2.027605329002693e-08, -1.229249407243068e-09,  6.552320400277457e-11, -3.118449389776251e-12,  1.341375579073254e-13,
 -5.259908830456642e-15,  2.600897097845323e-03, -1.023472848246325e-03,  2.137288987206413e-04, -3.031207870163765e-05,  3.255878186280868e-06, -2.816511662936827e-07,
  2.041102340551096e-08, -1.273592177346450e-09,  6.981635525624301e-11, -3.414624290952919e-12,  1.508261002431062e-13, -6.068609484836455e-15,  2.163406661687127e-03,
 -8.734865837457640e-04,  1.875912920679239e-04, -2.736156598144342e-05,  3.021085819702254e-06, -2.684760355500878e-07,  1.997406371576129e-08, -1.278627128512916e-09,
  7.186035329231271e-11, -3.600860224204603e-12,  1.628511036179098e-13, -6.704356895661030e-15,  1.781363182981893e-03, -7.353874711274291e-04,  1.618315949011440e-04,
 -2.418878490927843e-05,  2.735856631226701e-06, -2.489238242277390e-07,  1.895006756986772e-08, -1.240562979987950e-09,  7.125954151586046e-11, -3.647464052396165e-12,
  1.684086462402428e-13, -7.073937863506935e-15,  1.444703782202668e-03, -6.077615013693327e-04,  1.365628468861084e-04, -2.084408668155414e-05,  2.406750729621543e-06,
 -2.234531035848305e-07,  1.735026941687765e-08, -1.157916288398239e-09,  6.777220020683004e-11, -3.532970073929672e-12,  1.660535077091288e-13, -7.096737735519078e-15,
  1.144604569529862e-03, -4.891034941021012e-04,  1.118275287273779e-04, -1.737007268598684e-05,  2.040568920059441e-06, -1.926890518603484e-07,  1.521102449023570e-08,
 -1.031658940143143e-09,  6.133972032091968e-11, -3.247040841944666e-12,  1.549112322122288e-13, -6.717327179163488e-15,  8.732742765628924e-04, -3.778624061356292e-04,
  8.761036743838679e-05, -1.380179590744550e-05,  1.644130109840766e-06, -1.573891413856962e-07,  1.259143926644974e-08, -8.651934009504091e-10,  5.210015099974701e-11,
 -2.792326936005756e-12,  1.348360998269790e-13, -5.915839061552495e-15,  6.237576483082797e-04, -2.724715398513157e-04,  6.385067036605843e-05, -1.016751162326953e-05,
  1.224135555612729e-06, -1.184116481461885e-07,  9.570200647309821e-09, -6.641712265983135e-10,  4.038510528455458e-11, -2.185036930288717e-12,  1.064891680071718e-13,
 -4.714216923394208e-15,  3.897617964757485e-04, -1.713721335043671e-04,  4.045512661653478e-05, -6.490035521028223e-06,  7.871363421164106e-07, -7.669080351473976e-08,
  6.242086795076653e-09, -4.361912094232845e-10,  2.670136965886761e-11, -1.454167176795226e-12,  7.132355656742967e-14, -3.177103146861030e-15,  1.657316261209041e-04,
 -7.313344442833819e-05,  1.733476671192212e-05, -2.792420179420588e-06,  3.400583100543192e-07, -3.326470912991876e-08,  2.718125540105192e-09, -1.906673102119308e-10,
  1.171527127018884e-11, -6.403429989420701e-13,  3.151892534058726e-14, -1.408856159869388e-15,  7.936341710864829e-02, -2.655688206252917e-04,  9.340123652443002e-07,
 -3.410260817417976e-09,  1.276440529737191e-11, -4.847575320726924e-14,  1.854080062359590e-16, -7.107508502867726e-19,  2.722631917404046e-21, -1.040425432922949e-23,
  3.962591977040299e-26, -1.503532167711273e-28,  7.801412154926093e-02, -3.743278767705902e-04,  2.102369533520600e-06, -1.187442285513982e-08,  6.514151282817205e-11,
 -3.465613954120053e-13,  1.795691127897094e-15, -9.099693328413241e-18,  4.524568077617799e-20, -2.212856534963761e-22,  1.066549526311781e-24, -5.073495524585599e-27,
  7.539091129773498e-02, -5.801936329647818e-04,  4.778597861227919e-06, -3.621891918617179e-08,  2.563200800855596e-10, -1.722375692595916e-12,  1.110759753996156e-14,
 -6.923774410541807e-17,  4.192731890515213e-19, -2.475930942121087e-21,  1.430071200044332e-23, -8.097910608895596e-26,  7.163702386819384e-02, -8.615195381599421e-04,
  9.534247012541864e-06, -9.216262723048739e-08,  8.124879444198883e-10, -6.688486040192885e-12,  5.214982209765031e-14, -3.888113270411114e-16,  2.791022821326442e-18,
 -1.938910661406357e-20,  1.308729333694543e-22, -8.609830591710515e-25,  6.694961639977559e-02, -1.189670992277255e-03,  1.698818227512521e-05, -2.045278298187540e-07,
  2.198696149533266e-09, -2.172827698261299e-11,  2.009264442470891e-13, -1.759441264070312e-15,  1.471393064629423e-17, -1.182631097108989e-19,  9.180303694028870e-22,
 -6.908896586963984e-24,  6.156141779950042e-02, -1.532832341719865e-03,  2.759574844921736e-05, -4.065122527174680e-07,  5.242132023136916e-09, -6.125471186080538e-11,
  6.623832859597576e-13, -6.722360548656323e-15,  6.467139248891794e-17, -5.941585395277527e-19,  5.242889918708059e-21, -4.463221004047404e-23,  5.572047652660064e-02,
 -1.859955992087630e-03,  4.146841865676669e-05, -7.362813706328796e-07,  1.123825530389654e-08, -1.534068288587368e-10,  1.918258609734444e-12, -2.232682702807668e-14,
  2.446382273643955e-16, -2.544781197666602e-18,  2.529365564862967e-20, -2.414288474247750e-22,  4.967055807978541e-02, -2.144225866122690e-03,  5.826977780945127e-05,
 -1.230681853297974e-06,  2.198266397121282e-08, -3.469819193398748e-10,  4.970325468140030e-12, -6.576627262570100e-14,  8.139732048620568e-16, -9.511466886618022e-18,
  1.056869244286856e-19, -1.122900109020583e-21,  4.363437083862288e-02, -2.365560866967965e-03,  7.721109693750048e-05, -1.917080778324541e-06,  3.967290651346231e-08,
 -7.176606088565918e-10,  1.168057364674396e-11, -1.743740382853926e-13,  2.420437403857931e-15, -3.155701403062080e-17,  3.894636349054068e-19, -4.577454857966935e-21,
  3.780112073591229e-02, -2.511911671262551e-03,  9.714297703624370e-05, -2.805273167196196e-06,  6.665097650751122e-08, -1.370694374927591e-09,  2.516394989440439e-11,
 -4.209754061578184e-13,  6.512053876958675e-15, -9.416214970723486e-17,  1.283389570635379e-18, -1.659468138469007e-20,  3.231908166495516e-02, -2.579346142526378e-03,
  1.167166310096463e-04, -3.881680095966705e-06,  1.050048972677487e-07, -2.437013398996932e-09,  5.012945313755408e-11, -9.340232623391491e-13,  1.600915308353194e-14,
 -2.553424676434808e-16,  3.823594481813675e-18, -5.412365205118627e-20,  2.729308818690291e-02, -2.571120896454591e-03,  1.345751265622025e-04, -5.107573285297122e-06,
  1.561005842070984e-07, -4.060729706932320e-09,  9.301524115579155e-11, -1.919265231084055e-12,  3.625680975752760e-14, -6.346997788159112e-16,  1.039253836121963e-17,
 -1.603138544306546e-19,  2.278624131910093e-02, -2.496063980664744e-03,  1.495333951588686e-04, -6.422006394840398e-06,  2.201519561843808e-07, -6.378221702611942e-09,
  1.617536618403268e-10, -3.676548123432471e-12,  7.617017360584076e-14, -1.456669859156443e-15,  2.596556028167165e-17, -4.346578287163458e-19,  1.882473902577564e-02,
 -2.366635383413186e-03,  1.607143771683422e-04, -7.748899102755553e-06,  2.959419038182660e-07, -9.491765786400669e-09,  2.650554102839263e-10, -6.603079189882637e-12,
  1.493305674021871e-13, -3.106069004703215e-15,  6.002341153484535e-17, -1.086036787250894e-18,  1.540461055589549e-02, -2.196998999057471e-03,  1.676231977067308e-04,
 -9.006718857323434e-06,  3.807755796217238e-07, -1.344302202820311e-08,  4.112175058474817e-10, -1.117456867328427e-11,  2.746356724137852e-13, -6.187105247727460e-15,
  1.291066839222018e-16, -2.515393034065580e-18,  1.249920878911225e-02, -2.001356505198686e-03,  1.701569058270896e-04, -1.011871539022599e-05,  4.706908095368984e-07,
 -1.819263117034981e-08,  6.066073859406224e-10, -1.789915151373626e-11,  4.760268077508766e-13, -1.156880884029383e-14,  2.596883058476375e-16, -5.428389366095270e-18,
  1.006652988632988e-02, -1.792689497007074e-03,  1.685600589334995e-04, -1.102175513308093e-05,  5.608874346152543e-07, -2.361127479514219e-08,  8.541047773774142e-10,
 -2.724554278034634e-11,  7.808823389373796e-13, -2.039349822375578e-14,  4.906460517577444e-16, -1.096561016028383e-17,  8.055710972312441e-03, -1.581956657995316e-03,
  1.633440424813188e-04, -1.167235539141626e-05,  6.462879661278666e-07, -2.948502041588696e-08,  1.151844112732705e-09, -3.955479088633685e-11,  1.216909391508336e-12,
 -3.402429503365676e-14,  8.742552039295101e-16, -2.081992919858601e-17,  6.412340794259513e-03, -1.377714747399047e-03,  1.551901177705258e-04, -1.204929903147116e-05,
  7.221192482660358e-07, -3.553443495362984e-08,  1.492565361673690e-09, -5.495161541326498e-11,  1.807747516244266e-12, -5.391565503966326e-14,  1.474475348581742e-15,
 -3.729270850777416e-17,  5.082461346111604e-03, -1.186083116062328e-03,  1.448538605644865e-04, -1.215297446347187e-05,  7.844117243349833e-07, -4.144385349442737e-08,
  1.863756982255372e-09, -7.327415752371051e-11,  2.567911204572196e-12, -8.140738042659548e-14,  2.361542696555220e-15, -6.323073545382329e-17,  4.015317892073971e-03,
 -1.010950566670581e-03,  1.330836820378818e-04, -1.200215208396858e-05,  8.303428459635751e-07, -4.689521069932099e-08,  2.248599343289987e-09, -9.403874170234203e-11,
  3.498004704110084e-12, -1.174639960584840e-13,  3.602562087997609e-15, -1.017927947159204e-16,  3.165026512321687e-03, -8.543247124287386e-04,  1.205603392885793e-04,
 -1.162919538322407e-05,  8.583922517191359e-07, -5.160039791647312e-08,  2.627543844579387e-09, -1.164494147877235e-10,  4.581226955094664e-12, -1.624013255688860e-13,
  5.248813796930638e-15, -1.560231562211996e-16,  2.491380523005185e-03, -7.167395384370655e-04,  1.078591500356605e-04, -1.107472401394190e-05,  8.683162265744372e-07,
 -5.532709637441763e-08,  2.980240326107709e-09, -1.394526095546834e-10,  5.782002104561816e-12, -2.156537436861972e-13,  7.321579756690950e-15, -2.282562161283272e-16,
  1.960024490314420e-03, -5.976589424714245e-04,  9.543282055031708e-05, -1.038256999289155e-05,  8.609786095666115e-07, -5.791496382270030e-08,  3.287480513136485e-09,
 -1.618280274110745e-10,  7.047166638988731e-12, -2.756343057066341e-13,  9.799104357417158e-15, -3.194309500079877e-16,  1.542202981032210e-03, -4.958366819060873e-04,
  8.361060099053714e-05, -9.595592203281534e-06,  8.380906901311397e-07, -5.928127316986535e-08,  3.532858948634868e-09, -1.823002177389540e-10,  8.309633189016589e-12,
 -3.397252725486627e-13,  1.260754089261453e-14, -4.284392809412541e-16,  1.214254668316519e-03, -4.096126536631576e-04,  7.260871470575390e-05, -8.752624865909453e-06,
  8.019142943859307e-07, -5.941704427056432e-08,  3.703944030420097e-09, -1.996527610099910e-10,  9.493975290060687e-12, -4.044122729882054e-13,  1.561826894455547e-14,
 -5.516529193423523e-16,  9.569814818542486e-04, -3.371400845255652e-04,  6.254727487103077e-05, -7.886592341453421e-06,  7.549738195979748e-07, -5.837601576701895e-08,
  3.792868384809978e-09, -2.128285147530674e-10,  1.052305549072604e-11, -4.655481069289670e-13,  1.865289277267411e-14, -6.827592530836811e-16,  7.549839807385805e-04,
 -2.765478100383549e-04,  5.346976715142206e-05, -7.023654342282986e-06,  6.998091694407132e-07, -5.625936490037322e-08,  3.796358651539003e-09, -2.210040213276495e-10,
  1.132471235723158e-11, -5.187090478793375e-13,  2.149582288488293e-14, -8.129893453566966e-16,  5.960216578208678e-04, -2.260470698298535e-04,  4.536226912212357e-05,
 -6.183155512902310e-06,  6.387867072750176e-07, -5.319899431804819e-08,  3.715307736155080e-09, -2.236322917015255e-10,  1.183762465972710e-11, -5.595926541893077e-13,
  2.391296310730667e-14, -9.317510591666227e-16,  4.704317154816386e-04, -1.839942291603194e-04,  3.817063528766791e-05, -5.378128175714336e-06,  5.739725343051078e-07,
 -4.934167540087535e-08,  3.554037997332314e-09, -2.204541588554124e-10,  1.201572537571453e-11, -5.844035967633850e-13,  2.567399793951963e-14, -1.027605046084392e-15,
  3.706217401469372e-04, -1.489206637023048e-04,  3.181475431292951e-05, -4.616116611101306e-06,  5.070631733617213e-07, -4.483560281774165e-08,  3.319413109093621e-09,
 -2.114830521746845e-10,  1.183086079470994e-11, -5.901816922984840e-13,  2.657529539162815e-14, -1.089458583977536e-15,  2.906396090594472e-04, -1.195396601559817e-04,
  2.619962808888374e-05, -3.900135315203093e-06,  4.393633926049320e-07, -3.982017290015112e-08,  3.019938185610780e-09, -1.969708008605973e-10,  1.127370023223378e-11,
 -5.750407641993045e-13,  2.646053960945023e-14, -1.107815032658927e-15,  2.258165648156356e-04, -9.473828710501927e-05,  2.122343746858550e-05, -3.229626015508481e-06,
  3.717989033904972e-07, -3.441917938768636e-08,  2.664953737113979e-09, -1.773629177182040e-10,  1.035314123109754e-11, -5.383038409991266e-13,  2.523677288844666e-14,
 -1.075910273785370e-15,  1.724753965731808e-04, -7.356023491282264e-05,  1.678298684799963e-05, -2.601328009385847e-06,  3.049520974249360e-07, -2.873718469953727e-08,
  2.263989994242209e-09, -1.532511262885214e-10,  9.094595605333256e-12, -4.805356866901852e-13,  2.288436213489446e-14, -9.905893812383561e-16,  1.276939758319624e-04,
 -5.518387346777223e-05,  1.277701175780116e-05, -2.010018088835537e-06,  2.391109139843250e-07, -2.285858066236990e-08,  1.826312340615852e-09, -1.253292479920467e-10,
  7.537584062611850e-12, -4.034851975661198e-13,  1.946030249585345e-14, -8.528189079606161e-16,  8.911424803177689e-05, -3.889839332442766e-05,  9.107850464710628e-06,
 -1.449109850470273e-06,  1.743237600008920e-07, -1.684879123395088e-08,  1.360662361777319e-09, -9.435664044907900e-11,  5.733038333964748e-12, -3.099571580055345e-13,
  1.509508238908002e-14, -6.677830503313991e-16,  5.478868374665339e-05, -2.408040488628821e-05,  5.682081823142644e-06, -9.111474132416260e-07,  1.104589165746293e-07,
 -1.075737572266356e-08,  8.752026350579222e-10, -6.113293128907162e-11,  3.740719469406704e-12, -2.036399603932593e-13,  9.984181064597903e-15, -4.445756857451625e-16,
  2.308683927498926e-05, -1.018572642554578e-05,  2.413789659017173e-06, -3.887457357525845e-07,  4.733058559168164e-08, -4.628888580235890e-09,  3.781535773863331e-10,
 -2.652051606533448e-11,  1.629170315890016e-12, -8.903004867332607e-14,  4.381335893164490e-15, -1.958008863448020e-16,  7.831583165049369e-02, -2.582570144495893e-04,
  8.942833894390078e-07, -3.213551274684925e-09,  1.183782562254200e-11, -4.425526376810024e-14,  1.666725220585152e-16, -6.293260426844022e-19,  2.375085343201939e-21,
 -8.943881800247546e-24,  3.357310198709110e-26, -1.255690109356189e-28,  7.654956983706288e-02, -3.580616862866605e-04,  1.965908669153338e-06, -1.088535066896252e-08,
  5.862142803995891e-11, -3.063657738402784e-13,  1.560028451174808e-15, -7.771475613793749e-18,  3.799643567655111e-20, -1.827710136937807e-22,  8.665862358798728e-25,
 -4.055967370881455e-27,  7.314393678374512e-02, -5.436361662068193e-04,  4.367485971640129e-06, -3.237952659283022e-08,  2.243888581633340e-10, -1.477619719861676e-12,
  9.344123894178405e-15, -5.714334333660433e-17,  3.396322116823973e-19, -1.969232336116316e-21,  1.117119521638798e-23, -6.214694474906195e-26,  6.833678843471144e-02,
 -7.894581137982582e-04,  8.502090514501733e-06, -8.016850234834484e-08,  6.904019044595425e-10, -5.558049166570999e-12,  4.241534528896987e-14, -3.097260560157207e-16,
  2.178780498859337e-18, -1.483971061955476e-20,  9.824581769402057e-23, -6.341822095592437e-25,  6.244800203518024e-02, -1.063016228725294e-03,  1.473138763073987e-05,
 -1.725790483155622e-07,  1.808621701668894e-09, -1.744770350454419e-11,  1.576611731330503e-13, -1.350182296927595e-15,  1.105021950618395e-17, -8.696946246100490e-20,
  6.614051460516919e-22, -4.878712771625437e-24,  5.584262240176606e-02, -1.330240879273127e-03,  2.318305062893700e-05, -3.316351756721678e-07,  4.161893150386261e-09,
 -4.740078107771864e-11,  5.001821460705247e-13, -4.958187482567103e-15,  4.662685336256160e-17, -4.190243733332117e-19,  3.618871617081786e-21, -3.016757937735027e-23,
  4.889221719308536e-02, -1.560711264258220e-03,  3.361822424766252e-05, -5.787106247644645e-07,  8.584100000499035e-09, -1.140639745103017e-10,  1.390213461023090e-12,
 -1.578797111007762e-14,  1.689382265085840e-16, -1.717444708169009e-18,  1.669380696440325e-20, -1.559179403739313e-22,  4.194023472433089e-02, -1.731649298484641e-03,
  4.540232636284079e-05, -9.285719568547514e-07,  1.610071373758537e-08, -2.471376934227733e-10,  3.447355195673135e-12, -4.446958109581526e-14,  5.370803408610724e-16,
 -6.129127458600452e-18,  6.655837917796730e-20, -6.915574055642149e-22,  3.527571830295698e-02, -1.830100470324501e-03,  5.758622526051021e-05, -1.383423540578368e-06,
  2.776869261242452e-08, -4.881154427585580e-10,  7.731021260105703e-12, -1.124445489569289e-13,  1.522189755459186e-15, -1.937153423746362e-17,  2.335377520899782e-19,
 -2.683064717974217e-21,  2.911765421177498e-02, -1.853180473665630e-03,  6.906981542005148e-05, -1.928975785915071e-06,  4.443125523620825e-08, -8.874701299573622e-10,
  1.584757588334708e-11, -2.581913306142326e-13,  3.893627591050176e-15, -5.493575601442907e-17,  7.311793900066274e-19, -9.239131800544310e-21,  2.361007939037854e-02,
 -1.806692234930384e-03,  7.879825122485982e-05, -2.534104745433976e-06,  6.644397162438389e-08, -1.497392542537810e-09,  2.995320467852981e-11, -5.433965094645376e-13,
  9.078116121414125e-15, -1.412600853289865e-16,  2.065342621435487e-18, -2.856619489508463e-20,  1.882632842614768e-02, -1.702690319258462e-03,  8.593793420539321e-05,
 -3.154546202710192e-06,  9.345417349408826e-08, -2.360685020133950e-09,  5.258472568773738e-11, -1.056443563296610e-12,  1.945217235939141e-14, -3.322149532662224e-16,
  5.311353267819263e-18, -8.005995794376151e-20,  1.477973964574517e-02, -1.556651916111985e-03,  8.999259685913883e-05, -3.739766072920976e-06,  1.243112411023358e-07,
 -3.498140015073484e-09,  8.628903538412449e-11, -1.909988566838596e-12,  3.857640417709832e-14, -7.198604284882572e-16,  1.253131468955868e-17, -2.050166464775541e-19,
  1.143782163421801e-02, -1.384830037010361e-03,  9.084207536573946e-05, -4.241202507120114e-06,  1.571499922013294e-07, -4.897899986092742e-09,  1.330896955889255e-10,
 -3.230047870639761e-12,  7.123830614372206e-14, -1.446360931171333e-15,  2.730518514258761e-17, -4.830119682351023e-19,  8.737174397973160e-03, -1.202178306854803e-03,
  8.870883378652514e-05, -4.619804697460877e-06,  1.896368504941001e-07, -6.510268815856384e-09,  1.939019987807529e-10, -5.136173786159541e-12,  1.231679454202223e-13,
 -2.709869411468092e-15,  5.526889458441126e-17, -1.053258096158016e-18,  6.597132227576395e-03, -1.021020724523996e-03,  8.407327770119527e-05, -4.851205306778874e-06,
  2.193197445184555e-07, -8.250107209144234e-09,  2.680530796222710e-10, -7.715426467811174e-12,  2.003497713398526e-13, -4.758287942848697e-15,  1.044623388067369e-16,
 -2.137183779219501e-18,  4.930902538757121e-03, -8.504530306990541e-04,  7.756548063506760e-05, -4.927706091990378e-06,  2.439957916972053e-07, -1.000677314629377e-08,
  3.530569788062598e-10, -1.099578657502045e-11,  3.079697890709883e-13, -7.866181643495886e-15,  1.852326659536600e-16, -4.054778333405979e-18,  3.653720752637741e-03,
 -6.963378106879859e-04,  6.985893678348487e-05, -4.857175266891886e-06,  2.620130918077835e-07, -1.165939919549992e-08,  4.447334887113733e-10, -1.492606908677416e-11,
  4.491753049169876e-13, -1.229410737387842e-14,  3.094623778689242e-16, -7.224470619992676e-18,  2.688109113350620e-03, -5.616997396440832e-04,  6.158444291077450e-05,
 -4.659652237012064e-06,  2.724495880870053e-07, -1.309392023974091e-08,  5.376654254865810e-10, -1.936849398543711e-11,  6.239297271091143e-13, -1.823531554471769e-14,
  4.890240175319549e-16, -1.213644760199206e-17,  1.966678783710949e-03, -4.473281383956574e-04,  5.327287268165352e-05, -4.362781850039152e-06,  2.751502147731186e-07,
 -1.421808104279558e-08,  6.258965294180221e-10, -2.410700600082886e-11,  8.282685901523296e-13, -2.576020487492490e-14,  7.335845672402525e-16, -1.929371359045925e-17,
  1.433068790921028e-03, -3.524302402103313e-04,  4.532736881932685e-05, -3.997165783118816e-06,  2.706393849910234e-07, -1.497156800598517e-08,  7.037136222357134e-10,
 -2.887028099554569e-11,  1.054186709529596e-12, -3.477179790102247e-14,  1.048125277457260e-15, -2.912358154126131e-17,  1.041622581475618e-03, -2.752292520768698e-04,
  3.801993314305615e-05, -3.592438646315229e-06,  2.599493997618977e-07, -1.532995641162764e-08,  7.663481174507159e-10, -3.336458339741077e-11,  1.290232496362245e-12,
 -4.498440385103556e-14,  1.430713881110555e-15, -4.187240562666633e-17,  7.563209423894811e-04, -2.134506055426823e-04,  3.150484244309018e-05, -3.174500080282079e-06,
  2.444131993708966e-07, -1.530275887661531e-08,  8.104695258214878e-10, -3.730947165679750e-11,  1.522706971266838e-12, -5.593262854911992e-14,  1.871089910597555e-15,
 -5.750462224740540e-17,  5.493690812503339e-04, -1.646787607246021e-04,  2.584119336980571e-05, -2.763986516826080e-06,  2.254643622515058e-07, -1.492703958388717e-08,
  8.344082653347598e-10, -4.046929943338261e-11,  1.737221689194831e-12, -6.701059406109604e-14,  2.350477086090653e-15, -7.563015466579654e-17,  3.997113966716275e-04,
 -1.265925972716856e-04,  2.101825486350840e-05, -2.375819643877350e-06,  2.044738434532622e-07, -1.425860768254276e-08,  8.381130224334178e-10, -4.267524310592411e-11,
  1.920303546833683e-12, -7.753406942414649e-14,  2.842761563055191e-15, -9.548029226882139e-17,  2.916404199324082e-04, -9.710087237218618e-05,  1.697928748378139e-05,
 -2.019542053688099e-06,  1.826374646445728e-07, -1.336275422307496e-08,  8.228998719553660e-10, -4.383537233611445e-11,  2.060755714421747e-12, -8.681339669645330e-14,
  3.316860121630289e-15, -1.159421720460905e-16,  2.135848698742121e-04, -7.440348280585813e-05,  1.364142494479497e-05, -1.700125912330278e-06,  1.609149507640969e-07,
 -1.230604081791082e-08,  7.910768808249349e-10, -4.393310714808294e-11,  2.150573164117530e-12, -9.422380256649064e-14,  3.739846091679714e-15, -1.356490520137753e-16,
  1.571059690049959e-04, -5.700276029973710e-05,  1.091074829083781e-05, -1.418982663935215e-06,  1.400125113199400e-07, -1.115002281463763e-08,  7.455294518808909e-10,
 -4.301653055691644e-11,  2.185331783187244e-12, -9.926179435108300e-14,  4.080272247821116e-15, -1.531116505842278e-16,  1.160970828783801e-04, -4.368466432883985e-05,
  8.692705800765100e-06, -1.174974997562603e-06,  1.203968311374234e-07, -9.947194192622365e-09,  6.893353054256522e-10, -4.118210533212204e-11,  2.164084215378063e-12,
 -1.015807133939058e-13,  4.311148911168275e-15, -1.668682492215226e-16,  8.616384991520865e-05, -3.348455808594264e-05,  6.898586141912342e-06, -9.653092927244721e-07,
  1.023279142293285e-07, -8.738994733470325e-09,  6.254531623042143e-10, -3.855641565630576e-11,  2.088876953315727e-12, -1.010035993446147e-13,  4.412174135182046e-15,
 -1.756295866402071e-16,  6.415495052766603e-05, -2.564746000461087e-05,  5.448954681815162e-06, -7.862514647639823e-07,  8.590011495453433e-08, -7.555460651140403e-09,
  5.565041465724293e-10, -3.527890694205670e-11,  1.964041457684785e-12, -9.751591711805954e-14,  4.371014201799269e-15, -1.783983816968771e-16,  4.781320303155420e-05,
 -1.958879810982549e-05,  4.274941567356578e-06, -6.336552512623718e-07,  7.108358245171118e-08, -6.416008286046392e-09,  4.846449837364990e-10, -3.148760107505821e-11,
  1.795410997510765e-12, -9.124356746295805e-14,  4.183635125541561e-15, -1.745506996322887e-16,  3.551964670010504e-05, -1.485887501281831e-05,  3.318133098533436e-06,
 -5.033197885200138e-07,  5.776128727804153e-08, -5.330868378403841e-09,  4.115193756913170e-10, -2.730874476621459e-11,  1.589586734977071e-12, -8.242272021919557e-14,
  3.853842636889587e-15, -1.638748423235196e-16,  2.610763719898111e-05, -1.111236578428070e-05,  2.529641056981958e-06, -3.912064730518746e-07,  4.575925639632297e-08,
 -4.302782785186850e-09,  3.382682120969584e-10, -2.285051798910053e-11,  1.353335827436666e-12, -7.136764401875280e-14,  3.392276252113073e-15, -1.465708142745277e-16,
  1.872853317081524e-05, -8.083017104851158e-06,  1.868753600888392e-06, -2.935482477599711e-07,  3.486942040553271e-08, -3.328693144911412e-09,  2.655789406911879e-10,
 -1.820038075956920e-11,  1.093163323927123e-12, -5.844138521368845e-14,  2.815122737717792e-15, -1.232183513147948e-16,  1.275468573960201e-05, -5.563088594169477e-06,
  1.301429559148468e-06, -2.068820539708338e-07,  2.486562990687226e-08, -2.401266307280229e-09,  1.937576941808132e-10, -1.342538364242057e-11,  8.150671995054962e-13,
 -4.403248210387280e-14,  2.142783732447810e-15, -9.472372367738154e-17,  7.709055384965916e-06, -3.386864637172069e-06,  7.988085457805723e-07, -1.280331144113873e-07,
  1.551438760787670e-08, -1.510231791083828e-09,  1.228154699409162e-10, -8.574935261663663e-12,  5.244764363529818e-13, -2.853994134218804e-14,  1.398703670150936e-15,
 -6.225676674845487e-17,  3.217593293419906e-06, -1.419294712837071e-06,  3.362653266704486e-07, -5.414375400500345e-08,  6.590598692432870e-09, -6.444080262825832e-10,
  5.263261115252876e-11, -3.690392525671971e-12,  2.266534962502155e-13, -1.238338456975579e-14,  6.092809285920971e-16, -2.722298231689275e-17,  7.729687235581016e-02,
 -2.512538437917740e-04,  8.568286849469918e-07, -3.031015406349949e-09,  1.099133759702791e-11, -4.045827698375025e-14,  1.500688139677562e-16, -5.582262275145476e-19,
  2.076004580922891e-21, -7.705158563098774e-24,  2.851178355947362e-26, -1.051364799704331e-28,  7.514797225685561e-02, -3.428414215540675e-04,  1.840716310000679e-06,
 -9.994463655167789e-09,  5.285157880698246e-11, -2.714047605768848e-13,  1.358506130779762e-15, -6.654509571078853e-18,  3.199991238893637e-20, -1.514269334162328e-22,
  7.064531545539468e-25, -3.254013897247452e-27,  7.103689435114555e-02, -5.101916313731997e-04,  3.999535788478913e-06, -2.901406199898883e-08,  1.969555322933627e-10,
 -1.271395348219924e-12,  7.886193263692701e-15, -4.732822352273967e-17,  2.761654134693962e-19, -1.572595145983948e-21,  8.764207870924888e-24, -4.791197791209471e-26,
  6.530915103304062e-02, -7.251097914532694e-04,  7.602850190459811e-06, -6.995886304849613e-08,  5.887568622157595e-10, -4.636738167308458e-12,  3.464390404398660e-14,
 -2.478456723605000e-16,  1.709045719050241e-18, -1.141572653625405e-20,  7.414892049420758e-23, -4.697558184384110e-25,  5.841918446831588e-02, -9.529822227183056e-04,
  1.282318374301838e-05, -1.462393136678330e-07,  1.494638962792671e-09, -1.408025928262764e-11,  1.243699980552315e-13, -1.041955684196739e-15,  8.347985141455498e-18,
 -6.435413740728981e-20,  4.796107243980185e-22, -3.468379913734548e-24,  5.086889166337022e-02, -1.159630961996592e-03,  1.957367647624997e-05, -2.720211104915400e-07,
  3.323491730615870e-09, -3.690675814083450e-11,  3.801590645977824e-13, -3.681952609729572e-15,  3.385656250724734e-17, -2.977019699986755e-19,  2.517087312185541e-21,
 -2.055263191773187e-23,  4.314636340354934e-02, -1.317371008394404e-03,  2.742797465924302e-05, -4.579424222540955e-07,  6.603595082978454e-09, -8.544556219118037e-11,
  1.015386349094806e-12, -1.125463821779566e-14,  1.176415990245636e-16, -1.169127251574506e-18,  1.111623375135844e-20, -1.016174329922333e-22,  3.567522507994551e-02,
 -1.408971159127839e-03,  3.565550416326392e-05, -7.063980685907114e-07,  1.189370235228104e-08, -1.775877470004156e-10,  2.412993377527734e-12, -3.035370721844871e-14,
  3.578251941624633e-16, -3.988964149107663e-18,  4.234450417769744e-20, -4.303538812008177e-22,  2.878131730400986e-02, -1.428943291296337e-03,  4.335873357227202e-05,
 -1.008120784298523e-06,  1.963273448258466e-08, -3.354332686220441e-10,  5.171305744233138e-12, -7.329772152772177e-14,  9.679181472180190e-16, -1.202600380095601e-17,
  1.416530728740530e-19, -1.591116114676904e-21,  2.267888569787078e-02, -1.382353430567372e-03,  4.966256271575329e-05, -1.341631928138691e-06,  2.996537876864021e-08,
 -5.814448929662804e-10,  1.010131395427037e-11, -1.603034817138859e-13,  2.357156652165303e-15, -3.245701574533037e-17,  4.219269325633156e-19, -5.210872282987299e-21,
  1.747429519385763e-02, -1.281916243401404e-03,  5.389302480688920e-05, -1.676162602598212e-06,  4.260407447674551e-08, -9.324547082189384e-10,  1.814145493630819e-11,
 -3.204916395873638e-13,  5.219434531377445e-15, -7.924520272030269e-17,  1.131418451807354e-18, -1.529252374390384e-20,  1.318249006611110e-02, -1.144373514785096e-03,
  5.569433017597425e-05, -1.977338783424164e-06,  5.678625837091334e-08, -1.393016746279614e-09,  3.017764908835808e-11, -5.903560594033180e-13,  1.059591073397448e-14,
 -1.765612641812377e-16,  2.756424509412843e-18, -4.060193855490461e-20,  9.750338354088348e-03, -9.870744386064386e-04,  5.506074762126445e-05, -2.213917044315412e-06,
  7.135657879613136e-08, -1.950345862578525e-09,  4.679501937787315e-11, -1.008722539288944e-12,  1.986176248839303e-14, -3.616625310013952e-16,  6.148538300090767e-18,
 -9.831373770345649e-20,  7.081427831821562e-03, -8.253794058191037e-04,  5.228952847067274e-05, -2.363582797713655e-06,  8.495937244423894e-08, -2.572937354305139e-09,
  6.802723478523276e-11, -1.608349884533295e-12,  3.459144285731333e-14, -6.855120726357227e-16,  1.264229178540370e-17, -2.186305880157435e-19,  5.058279174834593e-03,
 -6.711437191600638e-04,  4.788201902683214e-05, -2.416314107642340e-06,  9.628745678323059e-08, -3.213868277382427e-09,  9.318859786029868e-11, -2.405842519641585e-12,
  5.628724361569599e-14, -1.209307440531834e-15,  2.410451424572893e-17, -4.492712040870560e-19,  3.559687430246253e-03, -5.322245957763942e-04,  4.242746371098289e-05,
 -2.374758466060793e-06,  1.043162257901789e-07, -3.818187022679443e-09,  1.208590955267200e-10, -3.392754478904397e-12,  8.600755278579302e-14, -1.995872202696461e-15,
  4.284695866019211e-17, -8.578295152224431e-19,  2.472492210946866e-03, -4.127600273930823e-04,  3.649923810594323e-05, -2.252025269803920e-06,  1.084622471753360e-07,
 -4.332408453390049e-09,  1.490465831393723e-10, -4.530984184336626e-12,  1.239837801970641e-13, -3.096526849841299e-15,  7.135334806219972e-17, -1.529541476017935e-18,
  1.698223380528109e-03, -3.139003859990938e-04,  3.058158641512425e-05, -2.067918060267835e-06,  1.086353984846850e-07, -4.713527124990149e-09,  1.754920237778254e-10,
 -5.754525884784660e-12,  1.693423667628009e-13, -4.536051462415492e-15,  1.118245242062136e-16, -2.558487294807475e-18,  1.155698626532707e-03, -2.347028832165455e-04,
  2.503216627256717e-05, -1.844790447851341e-06,  1.051885170926699e-07, -4.935313264334125e-09,  1.980380542511879e-10, -6.977707998467959e-12,  2.200329685318109e-13,
 -6.299787821438206e-15,  1.656164606927949e-16, -4.031916666723673e-18,  7.808377210858635e-04, -1.729800935722743e-04,  2.007592958247993e-05, -1.603986146474506e-06,
  9.879511424052179e-08, -4.990704124953253e-09,  2.149658029735744e-10, -8.108005784338707e-12,  2.730077026783967e-13, -8.327020237018769e-15,  2.327065394798482e-16,
 -6.009836478791626e-18,  5.248499031727806e-04, -1.259861960101869e-04,  1.582072790292169e-05, -1.363404535692861e-06,  9.029696520753685e-08, -4.890348471406729e-09,
  2.252226382624428e-10, -9.060188480191202e-12,  3.246207422849626e-13, -1.051330221161538e-14,  3.113436693730513e-16, -8.504321319378846e-18,  3.516938440479202e-04,
 -9.090207595807717e-05,  1.228412334510007e-05, -1.136308631915254e-06,  8.055988064465979e-08, -4.658335637758902e-09,  2.285031829037539e-10, -9.768400052268670e-12,
  3.711526889407501e-13, -1.272186102600443e-14,  3.980028950157286e-16, -1.146412726257196e-17,  2.354184682977776e-04, -6.513200625906225e-05,  9.422741446066613e-06,
 -9.311856350472486e-07,  7.036319634400438e-08, -4.326590429708809e-09,  2.251898315324880e-10, -1.019369578995386e-11,  4.093338671426023e-13, -1.480159502299135e-14,
  4.876847708337274e-16, -1.476944794547331e-17,  1.577366644255198e-04, -4.645067723458544e-05,  7.158499351393157e-06, -7.523213198834945e-07,  6.033325349683701e-08,
 -3.929343683416924e-09,  2.161918374112252e-10, -1.032607334110791e-11,  4.367522822996469e-13, -1.660745363792690e-14,  5.745037867281655e-16, -1.823917391680575e-17,
  1.059920874883141e-04, -3.304617565485647e-05,  5.398963155327508e-06, -6.007356456380100e-07,  5.091854114293595e-08, -3.498673095775682e-09,  2.027363072893424e-10,
 -1.018153480588065e-11,  4.520755351049654e-13, -1.801868800426069e-14,  6.524339702175270e-16, -2.164967831342788e-17,  7.155429270220438e-05, -2.349985401627328e-05,
  4.051287488039362e-06, -4.751962615403397e-07,  4.239664810352380e-08, -3.061579542336378e-09,  1.861610778707864e-10, -9.795735382488108e-12,  4.550716655627193e-13,
 -1.895149790294861e-14,  7.160483087858304e-16, -2.476116331319645e-17,  4.860770786646991e-05, -1.673440475803666e-05,  3.030506943839313e-06, -3.731269130495734e-07,
  3.490069777853809e-08, -2.638603920940297e-09,  1.677447770945487e-10, -9.216137372900450e-12,  4.464620165454928e-13, -1.936442523766278e-14,  7.611069240158824e-16,
 -2.734595258511176e-17,  3.326934860895598e-05, -1.195119130154802e-05,  2.263513897762315e-06, -2.913221070970121e-07,  2.845408428023346e-08, -2.243692711795876e-09,
  1.485910928576801e-10, -8.494382496837959e-12,  4.276675600457995e-13, -1.925674536693428e-14,  7.849035247505553e-16, -2.921319063684413e-17,  2.296375159401627e-05,
 -8.569240217158572e-06,  1.690114532027292e-06, -2.264493571539560e-07,  2.300530087713011e-08, -1.884897692199541e-09,  1.295683842766591e-10, -7.680053898436249e-12,
  4.005162401934343e-13, -1.866152129719025e-14,  7.863474662057628e-16, -3.022593433758881e-17,  1.598992175851273e-05, -6.172014667864600e-06,  1.262341843033432e-06,
 -1.753621536099833e-07,  1.845798262957671e-08, -1.565505709573775e-09,  1.112953299751286e-10, -6.816373722137869e-12,  3.669677961783325e-13, -1.763565290215357e-14,
  7.658177078086142e-16, -3.030888947087838e-17,  1.122658717171897e-05, -4.464050749944577e-06,  9.428969101069507e-07, -1.352651704380325e-07,  1.469408768258821e-08,
 -1.285280073597746e-09,  9.415868199246536e-11, -5.937856233573273e-12,  3.288926005820737e-13, -1.624921522221987e-14,  7.248615134815509e-16, -2.944727178448424e-17,
  7.934343124820515e-06, -3.237256649765295e-06,  7.032927558923739e-07, -1.037757960549745e-07,  1.159007092950990e-08, -1.041604845510993e-09,  7.834909167866539e-11,
 -5.069596638396885e-12,  2.879201549459258e-13, -1.457586620577321e-14,  6.658217757917031e-16, -2.767888294135388e-17,  5.624198803132695e-06, -2.345595948488244e-06,
  5.220365313263294e-07, -7.892011272493372e-08,  9.026980165044015e-09, -8.304234469433782e-10,  6.390353493064187e-11, -4.227726138064593e-12,  2.453562310267411e-13,
 -1.268539610433634e-14,  5.914673871329963e-16, -2.508224883210289e-17,  3.970847813487843e-06, -1.686530784033415e-06,  3.830164606853359e-07, -5.909227935140729e-08,
  6.895826704048760e-09, -6.469378443289021e-10,  5.074641829812771e-11, -3.420560190252077e-12,  2.021573482280531e-13, -1.063881860960705e-14,  5.046799582269189e-16,
 -2.176363814323630e-17,  2.755641260462112e-06, -1.187647141344767e-06,  2.741518729625923e-07, -4.299711958126557e-08,  5.099588523330782e-09, -4.860815072085511e-10,
  3.872486347570222e-11, -2.650050363608314e-12,  1.589470800845009e-13, -8.485902891578062e-15,  4.082261242442837e-16, -1.784521448919375e-17,  1.829052398861597e-06,
 -7.971045210760642e-07,  1.863029077544403e-07, -2.958814435676105e-08,  3.553001447040545e-09, -3.428034197210135e-10,  2.763640759704164e-11, -1.913270614239080e-12,
  1.160591710314956e-13, -6.264764418149553e-15,  3.046242302012411e-16, -1.345578842785247e-17,  1.085801607626371e-06, -4.768284171253460e-07,  1.124082986225394e-07,
 -1.800804678461686e-08,  2.181069455715210e-09, -2.122132447584828e-10,  1.724963906857711e-11, -1.203815978855449e-12,  7.359729607829002e-14, -4.003131541021198e-15,
  1.961045293607032e-16, -8.725056803997423e-18,  4.486553182612692e-07, -1.978631952171899e-07,  4.686763857077395e-08, -7.544593304497720e-09,  9.181403440265342e-10,
 -8.975174581049796e-11,  7.328852544722063e-12, -5.137528125745956e-13,  3.154613748481825e-14, -1.723164743268922e-15,  8.476376591879491e-17, -3.786477602894547e-18,
  7.630534002359658e-02, -2.445417736589211e-04,  8.214855857054955e-07, -2.861436821845493e-09,  1.021696025232079e-11, -3.703693128148940e-14,  1.353283477717750e-16,
 -4.960208736414443e-19,  1.818080301505722e-21, -6.652002908047407e-24,  2.426894122404042e-26, -8.824627357666505e-29,  7.380531821759698e-02, -3.285814510323288e-04,
  1.725682940669372e-06, -9.190552995745636e-09,  4.773500996710788e-11, -2.409256657599192e-13,  1.185733621549930e-15, -5.712548487559198e-18,  2.702450154543828e-20,
 -1.258348362699071e-22,  5.777680107012573e-25, -2.619614848789695e-27,  6.905798849412281e-02, -4.795363160118454e-04,  3.669467776674097e-06, -2.605634638742470e-08,
  1.733179187914613e-10, -1.097080368902496e-12,  6.676673750894448e-15, -3.933300122395727e-17,  2.253854932171398e-19, -1.260791658413777e-21,  6.904607696687025e-24,
 -3.710100568763957e-26,  6.252525774325014e-02, -6.674916391071691e-04,  6.816944391777240e-06, -6.123770868587547e-08,  5.038049205399590e-10, -3.882740931400140e-12,
  2.841195431775129e-14, -1.991973353178900e-16,  1.346836905891254e-18, -8.825118509062356e-21,  5.625329872610601e-23, -3.498585195358874e-25,  5.480185932376262e-02,
 -8.570300934965273e-04,  1.120300383387406e-05, -1.244251557738564e-07,  1.240666803709845e-09, -1.141730545250236e-11,  9.861161670446657e-14, -8.084646221498576e-16,
  6.342701520682539e-18, -4.790593880483972e-20,  3.499692255685363e-22, -2.481874336030898e-24,  4.652407914931363e-02, -1.015247616803098e-03,  1.660563495162755e-05,
 -2.242875666315204e-07,  2.668837159914944e-09, -2.890690075119762e-11,  2.907499007762100e-13, -2.752227348304975e-15,  2.475297559896254e-17, -2.130212247616931e-19,
  1.763753017141447e-21, -1.410976012202048e-23,  3.828329811071764e-02, -1.118254046926060e-03,  2.251423027978320e-05, -3.647320874949899e-07,  5.114895015314027e-09,
 -6.446848127093195e-11,  7.471972707251233e-13, -8.085749197821431e-15,  8.258477016775149e-17, -8.025338224434835e-19,  7.466095546095614e-21, -6.681592652212744e-23,
  3.056037766091147e-02, -1.154649982234462e-03,  2.821277032467224e-05, -5.416336071361013e-07,  8.858387376042828e-09, -1.287027127416650e-10,  1.703939363505465e-12,
 -2.090780796453212e-14,  2.406381112004727e-16, -2.621147411801083e-18,  2.720595226112028e-20, -2.705163959780159e-22,  2.368958470709146e-02, -1.125592389145576e-03,
  3.294471881881162e-05, -7.415625627200052e-07,  1.401546636274819e-08, -2.328140506453257e-10,  3.494581321695104e-12, -4.828146454310397e-14,  6.220813170269961e-16,
 -7.547671391678749e-18,  8.688005062148835e-20, -9.542979690380691e-22,  1.785254969434317e-02, -1.042105894814822e-03,  3.609474157234736e-05, -9.434304446778417e-07,
  2.043708794848723e-08, -3.853252616183613e-10,  6.514024863085705e-12, -1.007138018162659e-13,  1.444279133350342e-15, -1.941200548764305e-17,  2.465099684969291e-19,
 -2.976083950188977e-21,  1.309619823496596e-02, -9.209170555699756e-04,  3.732268695880183e-05, -1.122776163766044e-06,  2.766944989915343e-08, -5.882250040284610e-10,
  1.113251538675425e-11, -1.915470050227660e-13,  3.041400190339459e-15, -4.506189032094962e-17,  6.283399589469277e-19, -8.300424070534758e-21,  9.365132944948904e-03,
 -7.801723362675931e-04,  3.661197770332861e-05, -1.257288913667699e-06,  3.500524110133553e-08, -8.339887682668918e-10,  1.757270365104189e-11, -3.347732265318321e-13,
  5.857574478742055e-15, -9.524006104745625e-17,  1.452016641158140e-18, -2.090243990161879e-20,  6.538694237975068e-03, -6.360584815335594e-04,  3.423097466582701e-05,
 -1.331696253734357e-06,  4.161837654671029e-08, -1.104897800714633e-09,  2.578649172588202e-11, -5.413469691202062e-13,  1.039182403451825e-14, -1.846508561557328e-16,
  3.065868616058608e-18, -4.791353267716201e-20,  4.465021704563433e-03, -5.008085374535822e-04,  3.063484937356978e-05, -1.340517535938451e-06,  4.674045906916289e-08,
 -1.375335918976916e-09,  3.538045329030297e-11, -8.148544620502600e-13,  1.708990699773218e-14, -3.305663415819810e-16,  5.955267008513476e-18, -1.006811429219721e-19,
  2.987582200211840e-03, -3.820764883345134e-04,  2.634754991779441e-05, -1.288114282866927e-06,  4.982156710955575e-08, -1.616591224402068e-09,  4.562858641254476e-11,
 -1.148007884495859e-12,  2.620189940642427e-14, -5.496655981600291e-16,  1.070666452450460e-17, -1.951579500347416e-19,  1.962670854557689e-03, -2.833392700292667e-04,
  2.185879636605393e-05, -1.186459348021912e-06,  5.062731720721641e-08, -1.802700404264732e-09,  5.558103733764202e-11, -1.521461760836308e-12,  3.764724283616080e-14,
 -8.534937361838357e-16,  1.791453907702976e-17, -3.509355420579861e-19,  1.268617094413595e-03, -2.048695910596292e-04,  1.755651828571584e-05, -1.051675752972825e-06,
  4.925136547550342e-08, -1.915522194576330e-09,  6.424099956754358e-11, -1.905772840402444e-12,  5.093777799284293e-14, -1.243699306731881e-15,  2.803859823871164e-17,
 -5.884631087304702e-19,  8.086231041275411e-04, -1.448698565806504e-04,  1.369907366393475e-05, -9.005082772869574e-07,  4.605309164488726e-08, -1.947626372722938e-09,
  7.075677479774663e-11, -2.266208517548111e-12,  6.519624180378620e-14, -1.708651376256273e-15,  4.124329553823337e-17, -9.245797371249820e-19,  5.094707301839978e-04,
 -1.004878895105787e-04,  1.041987432494492e-05, -7.475906230611930e-07,  4.155110946454300e-08, -1.902468867425979e-09,  7.457304929363767e-11, -2.569070318196593e-12,
  7.927648439476649e-14, -2.222842371112798e-15,  5.726887081388648e-17, -1.367256843973504e-18,  3.180654692516803e-04, -6.857812389170188e-05,  7.751789912722227e-06,
 -6.038940786516279e-07,  3.630879670655752e-08, -1.792247431637954e-09,  7.550393688316482e-11, -2.787709195473735e-12,  9.195596122686098e-14, -2.749652568427110e-15,
  7.538212388635420e-17, -1.911041783146935e-18,  1.972597137337657e-04, -4.618403254099241e-05,  5.658948887325187e-06, -4.763121110617022e-07,  3.084047096538449e-08,
 -1.634428069092709e-09,  7.371960194208858e-11, -2.906639152546194e-12,  1.021469142126647e-13, -3.246926539624171e-15,  9.443362500686659e-17, -2.534773819048801e-18,
  1.218453663724550e-04, -3.078402569610750e-05,  4.066926243486174e-06, -3.680726842834613e-07,  2.555284547642729e-08, -1.448061418108667e-09,  6.966489306012202e-11,
 -2.922923057223704e-12,  1.090696860057637e-13, -3.673884371222888e-15,  1.130141761276983e-16, -3.202589619514222e-18,  7.515604597536046e-05, -2.036890015566282e-05,
  2.886479845912619e-06, -2.795922400942176e-07,  2.072280678290050e-08, -1.250757227802079e-09,  6.394313853288433e-11, -2.844922454217282e-12,  1.123487420419272e-13,
 -3.997539869897429e-15,  1.296714699662445e-16, -3.868238974828951e-18,  4.641247624888271e-05, -1.341768041259036e-05,  2.029464819120048e-06, -2.094395479892034e-07,
  1.650353980375524e-08, -1.056757438768329e-09,  5.719901218961692e-11, -2.689203107027323e-12,  1.120195879901851e-13, -4.197107744510012e-15,  1.431310184648334e-16,
 -4.481702611626954e-18,  2.876935776408141e-05, -8.824226320860784e-06,  1.417735185870681e-06, -1.551917547885235e-07,  1.294755685897080e-08, -8.761414891389464e-10,
  5.002502619978814e-11, -2.476678879243865e-12,  1.084608157364242e-13, -4.265641855502854e-15,  1.524687634227223e-16, -4.996455146512834e-18,  1.794370614962042e-05,
 -5.809361732978219e-06,  9.868035381112982e-07, -1.140809085273569e-07,  1.003601079707513e-08, -7.149281867230160e-10,  4.290300421298602e-11, -2.228975575279712e-12,
  1.022813774797679e-13, -4.209003442562092e-15,  1.572023987350242e-16, -5.375661694156306e-18,  1.128666178279511e-05, -3.838040096127314e-06,  6.861428884887021e-07,
 -8.341567955710100e-08,  7.706724526085848e-09, -5.757319558542919e-10,  3.618020622792460e-11, -1.965656348238761e-12,  9.419637922684795e-14, -4.042900342676539e-15,
  1.572946186057126e-16, -5.596079470211587e-18,  7.173949256728123e-06, -2.550186960365280e-06,  4.776845028236755e-07, -6.081224062738510e-08,  5.876844448163275e-09,
 -4.586505446350359e-10,  3.007244831314718e-11, -1.702554091284108e-12,  8.491796171214618e-14, -3.789013859474360e-15,  1.530841803854964e-16, -5.649199944331564e-18,
  4.615174741690932e-06, -1.707225659311071e-06,  3.335965591343053e-07, -4.428663805231644e-08,  4.458840458520429e-09, -3.621473076623117e-10,  2.468390405033626e-11,
 -1.451138168967016e-12,  7.507640915024610e-14, -3.471159747578925e-15,  1.451735654074572e-16, -5.539907096058003e-18,  3.008197948558209e-06, -1.152892573098165e-06,
  2.339964618579938e-07, -3.225973026389370e-08,  3.370353874660891e-09, -2.837922374533709e-10,  2.003406108807181e-11, -1.218660485760513e-12,  6.517537459483176e-14,
 -3.112142968622510e-15,  1.343040022410819e-16, -5.283421664919021e-18,  1.987030969370170e-06, -7.856385348737718e-07,  1.649254745358226e-07, -2.351523684940317e-08,
  2.539224022669031e-09, -2.208103339571066e-10,  1.608485015651639e-11, -1.008772571998386e-12,  5.557701312542104e-14, -2.731615775213046e-15,  1.212424698969435e-16,
 -4.901472658860807e-18,  1.328717824192448e-06, -5.397620902840058e-07,  1.167048884326100e-07, -1.713873398217281e-08,  1.905190342126060e-09, -1.704417407877397e-10,
  1.276386158143587e-11, -8.223403383063218e-13,  4.650872851459781e-14, -2.344951127219682e-15,  1.066953970860347e-16, -4.418535417816258e-18,  8.967747962493805e-07,
 -3.727983783184594e-07,  8.267584300311711e-08, -1.245432039599859e-08,  1.419570587684113e-09, -1.301466353010812e-10,  9.981978890885708e-12, -6.582596195292126e-13,
  3.808253432036587e-14, -1.962953846435165e-15,  9.125402386613999e-17, -3.858716569244389e-18,  6.069980631101882e-07, -2.572266386119995e-07,  5.827076672255876e-08,
 -8.967501389460024e-09,  1.043884478279018e-09, -9.769647784419529e-11,  7.645381449147429e-12, -5.141574814582837e-13,  3.031944116388379e-14, -1.592153233445441e-15,
  7.536916409495847e-17, -3.243570824885750e-18,  4.068214379244341e-07, -1.750766870841000e-07,  4.034768875583994e-08, -6.317553833810682e-09,  7.480620166391620e-10,
 -7.119015820617611e-11,  5.662736004901581e-12, -3.869312061916185e-13,  2.317357324051333e-14, -1.235425780564951e-15,  5.934914697443752e-17, -2.590888281895131e-18,
  2.628219236491602e-07, -1.144388563033756e-07,  2.672115942060023e-08, -4.239621712320998e-09,  5.086089734503845e-10, -4.902544426367529e-11,  3.948710626848729e-12,
 -2.731224247689632e-13,  1.655303369829082e-14, -8.927500182324518e-16,  4.337366978773416e-17, -1.914334703317411e-18,  1.530948119781274e-07, -6.720130692778144e-08,
  1.583415543682190e-08, -2.535369703452582e-09,  3.069194877220723e-10, -2.984774082245448e-11,  2.424975365633778e-12, -1.691532361746464e-13,  1.033664387084988e-14,
 -5.619783830400323e-16,  2.751781349087643e-17, -1.223787652277964e-18,  6.259178392390868e-08, -2.759795883519725e-08,  6.535515246454091e-09, -1.051805187709049e-09,
  1.279680507147760e-10, -1.250631888840145e-11,  1.020982064423777e-12, -7.155392199862878e-14,  4.392625178205831e-15, -2.398861183350984e-16,  1.179751545092550e-17,
 -5.268895702970888e-19,  7.534010307964066e-02, -2.381045141001441e-04,  7.881052866560441e-07, -2.703719505259037e-09,  9.507608515932851e-12, -3.394935452713101e-14,
  1.222195557106339e-16, -4.414938344885536e-19,  1.595185668301564e-21, -5.754591229142043e-24,  2.070353824188524e-26, -7.424774083934015e-29,  7.251792271825272e-02,
 -3.152045065525742e-04,  1.619824718800214e-06, -8.463847423589682e-09,  4.318860449596074e-11, -2.142937862431091e-13,  1.037238764128017e-15, -4.916000844350922e-18,
  2.288410395883001e-20, -1.048727061645486e-22,  4.740035839241121e-25, -2.115951527654098e-27,  6.719663885676405e-02, -4.513857487498122e-04,  3.372733280487024e-06,
 -2.345044646970155e-08,  1.528935465970514e-10, -9.492812027088370e-13,  5.669861330788863e-15, -3.279661269357719e-17,  1.845987682235078e-19, -1.014666673298229e-21,
  5.461643683789383e-24, -2.885272262061710e-26,  5.995989420344813e-02, -6.157641291832359e-04,  6.128009584495355e-06, -5.376283166940097e-08,  4.325411695983668e-10,
 -3.263192916261328e-12,  2.339298055010614e-14, -1.607759502832434e-16,  1.066182403985718e-18, -6.855006395198007e-21,  4.289163253801196e-23, -2.619398730487965e-25,
  5.154398524275952e-02, -7.730575644022512e-04,  9.821867012449763e-06, -1.062799696909196e-07,  1.034265990597022e-09, -9.300837538493289e-12,  7.857496336245070e-14,
 -6.305901781999730e-16,  4.845803256062970e-18, -3.586907809191800e-20,  2.569230922727996e-22, -1.787208800152052e-24,  4.271270284201069e-02, -8.924840157791855e-04,
  1.415247418923061e-05, -1.858568153922973e-07,  2.154671264629874e-09, -2.277077233721345e-11,  2.237144698173436e-13, -2.070343928138968e-15,  1.821751477091945e-17,
 -1.534830581302546e-19,  1.244765980953952e-21, -9.758692355057365e-24,  3.414463242645643e-02, -9.543481167527459e-04,  1.858888401455478e-05, -2.923063054290613e-07,
  3.987951388486695e-09, -4.897870063990750e-11,  5.538308344585286e-13, -5.852954533889585e-15,  5.842876092474161e-17, -5.553517115197558e-19,  5.056416363764873e-21,
 -4.431089164080421e-23,  2.635517865447309e-02, -9.527188720333408e-04,  2.248531741226446e-05, -4.184543408075997e-07,  6.650012315430207e-09, -9.404326345649439e-11,
  1.213513550702202e-12, -1.452840269060430e-14,  1.632992781869449e-16, -1.738429701846227e-18,  1.764688197130582e-20, -1.717103873626252e-22,  1.966292197167741e-02,
 -8.941438341201238e-04,  2.525139162984036e-05, -5.504305794119654e-07,  1.009902377039115e-08, -1.631461985045294e-10,  2.384889566907378e-12, -3.212595923868903e-14,
  4.039646231121917e-16, -4.787282209047136e-18,  5.386298999976956e-20, -5.786684374728165e-22,  1.419708105282581e-02, -7.936086485838770e-04,  2.650632687749119e-05,
 -6.704672757592013e-07,  1.409000916231213e-08, -2.581895168035748e-10,  4.248233175241204e-12, -6.400489527144531e-14,  8.953200374773529e-16, -1.174839834089873e-17,
  1.457659056470561e-19, -1.720591846233141e-21,  9.933916933000851e-03, -6.695108242466410e-04,  2.615989050815255e-05, -7.613074559054951e-07,  1.819338085403162e-08,
 -3.757484249930923e-10,  6.918713771613974e-12, -1.159618702014499e-13,  1.795444983826545e-15, -2.596320023672737e-17,  3.536219121893908e-19, -4.566166533036974e-21,
  6.746621918046837e-03, -5.392381487562232e-04,  2.440093639722378e-05, -8.105713873385975e-07,  2.188099960192495e-08, -5.063544579919102e-10,  1.037838235362871e-11,
 -1.925626336037717e-13,  3.284937797880396e-15, -5.212150039904511e-17,  7.760881514595082e-19, -1.091942059007816e-20,  4.454961203992391e-03, -4.162959778876172e-04,
  2.161306297406786e-05, -8.135089594593384e-07,  2.465232380225440e-08, -6.357258215954659e-10,  1.443249296921183e-11, -2.950915504958642e-13,  5.522855011657100e-15,
 -9.576728457096407e-17,  1.553003201757454e-18, -2.372230628440379e-20,  2.865593450085369e-03, -3.091863886747178e-04,  1.825865105902515e-05, -7.733596719239816e-07,
  2.615503574361362e-08, -7.477432231946445e-10,  1.871532885713804e-11, -4.198806292108172e-13,  8.587201159880650e-15, -1.621207358953678e-16,  2.853045929413661e-18,
 -4.715336358592407e-20,  1.799260363841759e-03, -2.216928309952918e-04,  1.477261721012176e-05, -6.995566975699928e-07,  2.625855398208812e-08, -8.281877492457826e-10,
  2.275235745492975e-11, -5.578297755485688e-13,  1.241944582628562e-14, -2.543764168960859e-16,  4.841698505406068e-18, -8.630254467503795e-20,  1.105227880433495e-03,
 -1.539806322438484e-04,  1.149211261952172e-05, -6.047321674195392e-07,  2.506102038400410e-08, -8.679385430423441e-10,  2.606160281967562e-11, -6.955556708277731e-13,
  1.679701572371217e-14, -3.719753284688662e-16,  7.632802337519467e-18, -1.462833249225999e-19,  6.657793410648126e-04, -1.039471020045391e-04,  8.629034165481094e-06,
 -5.016590412193707e-07,  2.283745125346939e-08, -8.646130440684754e-10,  2.826036599208764e-11, -8.179594992207118e-13,  2.135061924341825e-14, -5.095297557243117e-16,
  1.123657709816621e-17, -2.308543764089924e-19,  3.943139834068439e-04, -6.842827355674028e-05,  6.277386667230301e-06, -4.009750433666841e-07,  1.995551961621867e-08,
 -8.223187283026055e-10,  2.914231697806962e-11, -9.114140339771306e-13,  2.562670407432257e-14, -6.569556625299971e-16,  1.552299916268759e-17, -3.408899935819710e-19,
  2.302327087704751e-04, -4.407466237296138e-05,  4.440857080429011e-06, -3.100368121529480e-07,  1.678975983881065e-08, -7.498940073611940e-10,  2.870382440292158e-11,
 -9.665391670501416e-13,  2.917732686446603e-14, -8.009533561578351e-16,  2.021747098395902e-17, -4.732208788371094e-19,  1.329064910720114e-04, -2.787025889253868e-05,
  3.066440140106541e-06, -2.328077350061135e-07,  1.365705414822500e-08, -6.584340018100585e-10,  2.711882997530380e-11, -9.797520330653192e-13,  3.164926467161841e-14,
 -9.274619447174960e-16,  2.493539709517579e-17, -6.203397166094226e-19,  7.608090881122150e-05, -1.736110865151376e-05,  2.074374426218835e-06, -1.704330179523905e-07,
  1.078296671087088e-08, -5.589232887287300e-10,  2.467851634992869e-11, -9.532929650618603e-13,  3.284593795695193e-14, -1.024348394759103e-15,  2.924805694791958e-17,
 -7.712064585426356e-19,  4.332082915651550e-05, -1.069054341757414e-05,  1.379834996933717e-06, -1.221098954685234e-07,  8.296611745884657e-09, -4.605337889998711e-10,
  2.171925272792910e-11, -8.939701041541481e-13,  3.274761737914772e-14, -1.083542183306681e-15,  3.276077632404701e-17, -9.130026672381173e-19,  2.461407856279578e-05,
 -6.530084325316032e-06,  9.058372506632957e-07, -8.594868407966962e-08,  6.244965889897023e-09, -3.697833290381944e-10,  1.855957285363772e-11, -8.112062593382932e-13,
  3.149083310125705e-14, -1.102084053478070e-15,  3.518094531336462e-17, -1.033350159927046e-18,  1.399998291042600e-05, -3.970486995449591e-06,  5.890286125147093e-07,
 -5.965453632425870e-08,  4.616126761070651e-09, -2.904531149546365e-10,  1.545827066308903e-11, -7.150294677597929e-13,  2.931995902078208e-14, -1.081970220967155e-15,
  3.635869355057890e-17, -1.122373389189411e-18,  7.996812396906878e-06, -2.411383820414431e-06,  3.807467728774565e-07, -4.097785310997468e-08,  3.363170372953233e-09,
 -2.240068582759642e-10,  1.259615648763098e-11, -6.144836466921283e-13,  2.652880164952178e-14, -1.029048498205943e-15,  3.629364536071751e-17, -1.174087241376926e-18,
  4.601628083324816e-06, -1.467701771177712e-06,  2.454989065348632e-07, -2.795653047820150e-08,  2.423724385942146e-09, -1.702338146599275e-10,  1.007715247854648e-11,
 -5.166773415635208e-13,  2.340790960381639e-14, -9.514279999311276e-16,  3.511203948496136e-17, -1.186858786359686e-18,  2.675527287328750e-06, -8.981289329309450e-07,
  1.584151333383942e-07, -1.900578511018506e-08,  1.733516404455881e-09, -1.279012280821191e-10,  7.941395463091510e-12, -4.264561704072197e-13,  2.020713133383693e-14,
 -8.578718492145151e-16,  3.302556402310155e-17, -1.162992216908445e-18,  1.576172503648445e-06, -5.541626240018522e-07,  1.026073076954246e-07, -1.291431222627721e-08,
  1.234239513297992e-09, -9.529236663163152e-11,  6.183195059970954e-12, -3.465425630422031e-13,  1.711611371538914e-14, -7.565097394041148e-16,  3.028506252429158e-17,
 -1.107705553882026e-18,  9.430289417963779e-07, -3.456470234138037e-07,  6.688368084797573e-08, -8.793746856004480e-09,  8.770608044571617e-10, -7.058594791851569e-11,
  4.768625538200534e-12, -2.779417362589612e-13,  1.426033649222798e-14, -6.540238381122173e-16,  2.713977471691488e-17, -1.027852234688705e-18,  5.740632953432457e-07,
 -2.183613067753351e-07,  4.396365895454637e-08, -6.012702755979657e-09,  6.232882321662927e-10, -5.208501654261521e-11,  3.649873945291824e-12, -2.204373044372648e-13,
  1.170776173445543e-14, -5.553020199646747e-16,  2.380817597101850e-17, -9.307026007329887e-19,  3.559027174018306e-07, -1.398775016961341e-07,  2.917417037731884e-08,
 -4.132937770764291e-09,  4.434749821076903e-10, -3.832827763695153e-11,  2.775399283867564e-12, -1.730561118498091e-13,  9.480892861739921e-15, -4.634543459405600e-16,
  2.046189972528552e-17, -8.229908178622694e-19,  2.246524971176921e-07, -9.083954915426556e-08,  1.954220813849969e-08, -2.855481312033988e-09,  3.158626471915918e-10,
 -2.812225135830298e-11,  2.096180843992548e-12, -1.344402994520944e-13,  7.570094856591737e-15, -3.800545239274652e-16,  1.722096977554624e-17, -7.103088676579118e-19,
  1.440446010645400e-07, -5.967649537435065e-08,  1.318489168264356e-08, -1.978724510863143e-09,  2.247085858575218e-10, -2.052733016104137e-11,  1.568900749312180e-12,
 -1.031094190497443e-13,  5.945546564212996e-15, -3.054797327335822e-16,  1.415699541116174e-17, -5.968308905583424e-19,  9.328244933071872e-08, -3.943555107059798e-08,
  8.909865308612484e-09, -1.367529131264183e-09,  1.587749170912009e-10, -1.482174949091580e-11,  1.157017676204546e-12, -7.762238816599302e-14,  4.566585074583098e-15,
 -2.392564618108235e-16,  1.130079890476852e-17, -4.852945176755729e-19,  6.027385684246413e-08, -2.589854798724674e-08,  5.958142841353554e-09, -9.312839707536007e-10,
  1.100838039023103e-10, -1.045863859345439e-11,  8.305567931311953e-13, -5.666090729382769e-14,  3.388194894650727e-15, -1.803583257678291e-16,  8.651596948845786e-18,
 -3.771482533109081e-19,  3.784639168932637e-08, -1.646408620835961e-08,  3.840369706929727e-09, -6.086880500826893e-10,  7.294704101708122e-11, -7.024418290889463e-12,
  5.652226818857423e-13, -3.905779363442644e-14,  2.364964703674387e-15, -1.274336572631659e-16,  6.185829424564661e-18, -2.727835803260918e-19,  2.160997514212378e-08,
 -9.481282331752944e-09,  2.232821713460991e-09, -3.573283013017249e-10,  4.323345071671903e-11, -4.202234032068366e-12,  3.412354003929891e-13, -2.379084697489621e-14,
  1.453104689646439e-15, -7.896408247124179e-17,  3.864749334757955e-18, -1.717972355870531e-19,  8.736811203795389e-09, -3.851381161187410e-09,  9.118223627731286e-10,
 -1.467082195039173e-10,  1.784472127960603e-11, -1.743524160449840e-12,  1.423011329168126e-13, -9.970504178793888e-15,  6.119317268795075e-16, -3.341033409129746e-17,
  1.642724959707000e-18, -7.334905176885475e-20,  7.440009280931072e-02, -2.319269148616603e-04,  7.565514814523227e-07, -2.556874393069291e-09,  8.856981829592092e-12,
 -3.115884478765122e-14,  1.105423312609529e-16, -3.936088790493447e-19,  1.402172486730639e-21, -4.988208018586578e-24,  1.770028936546529e-26, -6.261625666152364e-29,
  7.128239480091153e-02, -3.026407433436049e-04,  1.522267478760215e-06, -7.805809553110664e-09,  3.914092990165159e-11, -1.909724452924730e-13,  9.093003198899657e-16,
 -4.240631399676582e-18,  1.942867925746137e-20, -8.764988137371393e-23,  3.900577306467280e-25, -1.714680055565192e-27,  6.544333422775835e-02, -4.254893132669321e-04,
  3.105402302114187e-06, -2.114894184982239e-08,  1.351976183987157e-10, -8.235889871325162e-13,  4.829051872410242e-15, -2.743409830783642e-17,  1.517154724301701e-19,
 -8.196088334096818e-22,  4.337233072842954e-24, -2.253160429333373e-26,  5.759095966193917e-02, -5.692077864241833e-04,  5.522320640091146e-06, -4.733524340954766e-08,
  3.725459853262537e-10, -2.752143508028712e-12,  1.933404076344072e-14, -1.302967607132158e-16,  8.476959507651018e-19, -5.349336359769966e-21,  3.286325537728671e-23,
 -1.971194039321543e-25,  4.860120690259126e-02, -6.993162466592325e-04,  8.639974583108327e-06, -9.112308867821363e-08,  8.657627942622849e-10, -7.610520157369423e-12,
  6.290853274933209e-14, -4.943457729454975e-16,  3.722003755207955e-18, -2.700768970479061e-20,  1.897251976959369e-22, -1.294873902623720e-24,  3.935586528273386e-02,
 -7.876320883417212e-04,  1.211490596914315e-05, -1.547522617472449e-07,  1.748571721932148e-09, -1.803616767890726e-11,  1.731395748003736e-13, -1.566961183881226e-15,
  1.349371716148035e-17, -1.113259104826808e-19,  8.846028495935055e-22, -6.798015786252160e-24,  3.060388563512583e-02, -8.186530420673273e-04,  1.543392153507316e-05,
 -2.356656224824513e-07,  3.129040595210729e-09, -3.745924144055426e-11,  4.133763095621538e-13, -4.267599620970784e-15,  4.165118890229429e-17, -3.873124081302999e-19,
  3.452151983357040e-21, -2.963079131664468e-23,  2.287464301892915e-02, -7.912466485754942e-04,  1.804496996845736e-05, -3.256470265328016e-07,  5.030262857074974e-09,
 -6.926329013862445e-11,  8.713598952860667e-13, -1.018144902551735e-14,  1.117892527683791e-16, -1.163393496227301e-18,  1.155256850034545e-20, -1.100281928989045e-22,
  1.645211097677734e-02, -7.160356301948872e-04,  1.951735167138855e-05, -4.121211562747107e-07,  7.342535582797269e-09, -1.153879589086239e-10,  1.643129219119336e-12,
 -2.158592176571779e-14,  2.649605398494011e-16, -3.067640160458640e-18,  3.374372416329344e-20, -3.546467666920177e-22,  1.140072723843227e-02, -6.102672421629267e-04,
  1.965936504581243e-05, -4.813534734442621e-07,  9.815840604888736e-09, -1.748540396796449e-10,  2.800856703708189e-12, -4.112955765339632e-14,  5.613200401793334e-16,
 -7.192435554544110e-18,  8.720597221375902e-20, -1.006595452556174e-21,  7.622873452474919e-03, -4.923434228580833e-04,  1.854923872631439e-05, -5.223084337780397e-07,
  1.210611703439689e-08, -2.429451130026715e-10,  4.353028581257533e-12, -7.108255446560500e-14,  1.073369320731301e-15, -1.515139853902278e-17,  2.016011716333442e-19,
 -2.544912344313731e-21,  4.925969060027742e-03, -3.776764899134151e-04,  1.647976102709392e-05, -5.295984588500501e-07,  1.386273308677511e-08, -3.116367363903127e-10,
  6.214022505835611e-12, -1.123044318109365e-13,  1.868055454546516e-15, -2.892776729792169e-17,  4.207230606040378e-19, -5.786159083862286e-21,  3.082090719306209e-03,
 -2.765911210848101e-04,  1.385207011431031e-05, -5.044548723112033e-07,  1.482344355410110e-08, -3.713287454499196e-10,  8.200813456937306e-12, -1.633167893370333e-13,
  2.980264621239515e-15, -5.043450928354248e-17,  7.988405170051464e-19, -1.192743208090810e-20,  1.870934010999338e-03, -1.941200827983675e-04,  1.106504783600539e-05,
 -4.536139001958547e-07,  1.487972887849792e-08, -4.132993210619619e-10,  1.006460211977319e-11, -2.199562304873559e-13,  4.386612406020048e-15, -8.083245657689124e-17,
  1.389584826165929e-18, -2.245157424566554e-20,  1.104322375965029e-03, -1.310377993288671e-04,  8.435482253103626e-06, -3.868599446055933e-07,  1.409072870058152e-08,
 -4.319420954227490e-10,  1.154916108331035e-11, -2.759081599965727e-13,  5.991729649973917e-15, -1.198152708787227e-16,  2.228311954689573e-18, -3.883950859990579e-20,
  6.353463410465303e-04, -8.538168052281625e-05,  6.162658777312818e-06, -3.143106228543918e-07,  1.264768588865270e-08, -4.259705299102631e-10,  1.245480410769017e-11,
 -3.240461054207121e-13,  7.636292979724260e-15, -1.651696494663978e-16,  3.312973375385519e-18, -6.211158558746644e-20,  3.572266742412788e-04, -5.389115532941289e-05,
  4.331896190130679e-06, -2.443344745964916e-07,  1.080951384053679e-08, -3.982729832537633e-10,  1.268452113927862e-11, -3.581275454050649e-13,  9.127393704997305e-15,
 -2.128701617488058e-16,  4.591258405993430e-18, -9.232269320911500e-20,  1.968455021571244e-04, -3.306827550224576e-05,  2.941552851650405e-06, -1.825085429782217e-07,
  8.835938349625694e-09, -3.546710494709568e-10,  1.225770175184923e-11, -3.742379048095074e-13,  1.028191038979471e-14, -2.577686196461670e-16,  5.960937362762253e-18,
 -1.282064100059837e-19,  1.066280415339431e-04, -1.979842876380870e-05,  1.937327478461806e-06, -1.315506633204775e-07,  6.938380826077936e-09, -3.021847137686294e-10,
  1.129118576757588e-11, -3.715069035510275e-13,  1.096783775946091e-14, -2.946846470418280e-16,  7.285675583417238e-18, -1.671476221933567e-19,  5.696142373617690e-05,
 -1.160899529293657e-05,  1.242535873953453e-06, -9.188631128025809e-08,  5.256737904461834e-09, -2.474316544718824e-10,  9.959311845633720e-12, -3.519503023741930e-13,
  1.112993073686562e-14, -3.195330979744312e-16,  8.422259886844943e-18, -2.055520834668547e-19,  3.011136428510173e-05, -6.692101043424665e-06,  7.792286312814506e-07,
 -6.245943971464507e-08,  3.859360032889047e-09, -1.955658450158953e-10,  8.449248697052744e-12, -3.196279790110098e-13,  1.079322296067027e-14, -3.301218653762717e-16,
  9.250480911770868e-18, -2.395249818475384e-19,  1.580761568170393e-05, -3.807434905671875e-06,  4.798018343014636e-07, -4.149387877025146e-08,  2.757659782639130e-09,
 -1.498627160066392e-10,  6.925105517292165e-12, -2.795014156137926e-13,  1.004675162248195e-14, -3.264075473089069e-16,  9.696185821159272e-18, -2.656479777143756e-19,
  8.271661637386962e-06, -2.146527698199049e-06,  2.912783223183199e-07, -2.705598327622022e-08,  1.926079691997238e-09, -1.118286145011248e-10,  5.507512226714506e-12,
 -2.363738702441659e-13,  9.015949418027371e-15, -3.102137912571335e-16,  9.741283077379465e-18, -2.816148773535047e-19,  4.330681029644923e-06, -1.204008562031804e-06,
  1.750736130140304e-07, -1.738956125893056e-08,  1.320648106398514e-09, -8.161102976573739e-11,  4.268562777126458e-12, -1.941602589259431e-13,  7.833693745934159e-15,
 -2.845909869591537e-16,  9.419727752709168e-18, -2.865560346858510e-19,  2.277325893121686e-06, -6.746422221167480e-07,  1.046190425983391e-07, -1.106361669479897e-08,
  8.927439974570836e-10, -5.849636099335920e-11,  3.237761539744617e-12, -1.555584265246717e-13,  6.617611100676341e-15, -2.530645016231936e-16,  8.803134886532055e-18,
 -2.810064661428219e-19,  1.207433430164550e-06, -3.791519100110451e-07,  6.241111477110460e-08, -6.996642648649777e-09,  5.974449732857060e-10, -4.135144818935437e-11,
  2.413401565518048e-12, -1.220577837391563e-13,  5.457078762553978e-15, -2.189838672638102e-16,  7.981936354385865e-18, -2.665903993425386e-19,  6.478782909333502e-07,
 -2.145577607029869e-07,  3.731636659426875e-08, -4.415715017458327e-09,  3.974034573061085e-10, -2.894370943444926e-11,  1.774750849489592e-12, -9.415751793397355e-14,
  4.409572442295088e-15, -1.850924204793356e-16,  7.047681082185292e-18, -2.455608229232529e-19,  3.530630917954935e-07, -1.227066326891680e-07,  2.244639202632863e-08,
 -2.791629817812458e-09,  2.637219024123269e-10, -2.013356417222608e-11,  1.292252222542500e-12, -7.166623770830735e-14,  3.503749561442222e-15, -1.533388816892115e-16,
  6.080089115934990e-18, -2.203359494392363e-19,  1.960320648149801e-07, -7.115926324865699e-08,  1.362906389907674e-08, -1.773863702987259e-09,  1.751816349887671e-10,
 -1.396421604148421e-11,  9.346733897251246e-13, -5.399024795340748e-14,  2.746051775807204e-15, -1.248842731706859e-16,  5.140065799055175e-18, -1.931332467780485e-19,
  1.111908856004068e-07, -4.196050735007997e-08,  8.376736115525356e-09, -1.136053156446970e-09,  1.168025502374437e-10, -9.683043022590910e-12,  6.733126928652170e-13,
 -4.036147461475854e-14,  2.128134945646439e-15, -1.002293317399376e-16,  4.268008868768148e-18, -1.657447988521635e-19,  6.454578350349255e-08, -2.520786711368340e-08,
  5.221797226125176e-09, -7.347340269446658e-10,  7.831684290005860e-11, -6.725099243283173e-12,  4.839274485637571e-13, -2.999154938472375e-14,  1.633421926150138e-15,
 -7.939092509676909e-17,  3.485776433161977e-18, -1.394491961183428e-19,  3.836669569988182e-08, -1.543816872459344e-08,  3.303571162406636e-09, -4.801586424110913e-10,
  5.283797877699081e-11, -4.680578812815600e-12,  3.471700413123118e-13, -2.215999702527728e-14,  1.242023825272007e-15, -6.207587930379666e-17,  2.800535224961032e-18,
 -1.150264882715312e-19,  2.331689401509538e-08, -9.625089012195314e-09,  2.118129912528268e-09, -3.166182148974049e-10,  3.581603033746627e-11, -3.259417456725583e-12,
  2.481979998738613e-13, -1.625333470932461e-14,  9.339480405248612e-16, -4.782384683992212e-17,  2.209059752777809e-18, -9.283404551075702e-20,  1.441613529154536e-08,
 -6.079022865461065e-09,  1.369613162033018e-09, -2.096240852138551e-10,  2.427088823412240e-11, -2.259598674357543e-12,  1.759264901885195e-13, -1.177252245577793e-14,
  6.908710088886362e-16, -3.610962110285635e-17,  1.701579973246097e-18, -7.290620139038420e-20,  8.963659707883896e-09, -3.845149324329525e-09,  8.829772866088856e-10,
 -1.377582394436207e-10,  1.625430931632486e-11, -1.541515635533110e-12,  1.222051857029446e-13, -8.322842184163648e-15,  4.968720560575135e-16, -2.640707485301354e-17,
  1.264758668812730e-18, -5.505178849757634e-20,  5.462186941737229e-09, -2.373874819520881e-09,  5.531224865238515e-10, -8.757245384212733e-11,  1.048362614077640e-11,
 -1.008451954489166e-12,  8.106184509015940e-14, -5.595875877357546e-15,  3.385009568020102e-16, -1.822239669734386e-17,  8.837234874778364e-19, -3.893548853578598e-20,
  3.053912301024892e-09, -1.339227021329739e-09,  3.152092998925581e-10, -5.041588731526522e-11,  6.096456870160003e-12, -5.922427853718370e-13,  4.806628355610189e-14,
 -3.349411459613588e-15,  2.044715507596409e-16, -1.110575721795173e-17,  5.432848869251687e-19, -2.413880603495918e-20,  1.220192732408318e-09, -5.377645613294931e-10,
  1.272836462227912e-10, -2.047393563194936e-11,  2.489668802897702e-12, -2.431901420601618e-13,  1.984331173555596e-14, -1.389992564372038e-15,  8.528834819796870e-17,
 -4.655440230233336e-18,  2.288441504521984e-19, -1.021566380825222e-20,  7.348429899090959e-02, -2.259948703250211e-04,  7.266991510608741e-07, -2.420007609776720e-09,
  8.259467905460207e-12, -2.863317233744112e-14,  1.001234036435193e-16, -3.514811291627744e-19,  1.234704591083113e-21, -4.332318713175013e-24,  1.516470206120855e-26,
 -5.292758668838641e-29,  7.009560952254518e-02, -2.908269188090862e-04,  1.432232985120078e-06, -7.208963681482739e-09,  3.553044641205613e-11, -1.705066471289189e-13,
  7.988129718516841e-16, -3.666530255342498e-18,  1.653685924612226e-20, -7.345686681211512e-23,  3.219274260819948e-25, -1.393895182758121e-27,  6.378950640735799e-02,
 -4.016256825078754e-04,  2.864070109871318e-06, -1.911150875012589e-08,  1.198253143466888e-10, -7.163871087155911e-13,  4.124657878229511e-15, -2.301966051588906e-17,
  1.251074863071192e-19, -6.644229796710607e-22,  3.457454091984247e-24, -1.766642009102714e-26,  5.539902590942924e-02, -5.272040058812629e-04,  4.988324124717758e-06,
 -4.179082648688831e-08,  3.218628902781310e-10, -2.329010245266319e-12,  1.603826377327901e-14, -1.060140387726345e-16,  6.768313162577509e-19, -4.193086768818795e-21,
  2.529862096580433e-23, -1.490762174001153e-25,  4.593557399997197e-02, -6.343459282202148e-04,  7.624841229419395e-06, -7.841100951374044e-08,  7.275951894677272e-10,
 -6.254205434581767e-12,  5.059797420769642e-14, -3.894379703958138e-16,  2.873633620873548e-18, -2.044621053151529e-20,  1.409013650460544e-22, -9.437437752735858e-25,
  3.638805132154407e-02, -6.976913564337408e-04,  1.041453043893704e-05, -1.294492117801350e-07,  1.426085299338051e-09, -1.436199628226732e-11,  1.347528501573911e-13,
 -1.193001678662358e-15,  1.005686116235819e-17, -8.127110599239855e-20,  6.328836195551059e-22, -4.768633534671998e-24,  2.755943628545239e-02, -7.056961477915562e-04,
  1.288324013660395e-05, -1.910934828870993e-07,  2.470114147990759e-09, -2.883350303810027e-11,  3.106233143443401e-13, -3.133559357684727e-15,  2.990839035588381e-17,
 -2.721654671698634e-19,  2.375327839360331e-21, -1.997405042146068e-23,  1.997542833306309e-02, -6.612480659542201e-04,  1.457782938252077e-05, -2.551988148308079e-07,
  3.832967700965110e-09, -5.140311976402313e-11,  6.306495465202265e-13, -7.193801559874654e-15,  7.717670542503536e-17, -7.853696719894743e-19,  7.630791971426660e-21,
 -7.115241513870230e-23,  1.387152954087688e-02, -5.778438862583745e-04,  1.520704306076906e-05, -3.111495015911529e-07,  5.384720750633493e-09, -8.234106204505227e-11,
  1.142517932051310e-12, -1.464138705766008e-14,  1.754768286298659e-16, -1.985266714673048e-18,  2.135443856275773e-20, -2.196057901494653e-22,  9.241071807170884e-03,
 -4.736712347610406e-04,  1.472088302010160e-05, -3.489822327098867e-07,  6.907239497899544e-09, -1.196404403545990e-10,  1.866115645557302e-12, -2.671499100867611e-14,
  3.557895824332958e-16, -4.452557021358404e-18,  5.276599861218715e-20, -5.956992260217626e-22,  5.914796698854316e-03, -3.660629486533807e-04,  1.330007421347290e-05,
 -3.624182550520405e-07,  8.148833287232569e-09, -1.589281960251494e-10,  2.771531276535376e-12, -4.410116708117770e-14,  6.495896734161925e-16, -8.952206850912703e-18,
  1.163848111306190e-19, -1.436501849699708e-21,  3.643448948585745e-03, -2.679143609181969e-04,  1.127331620663708e-05, -3.505124054992479e-07,  8.897870565357686e-09,
 -1.943369736509048e-10,  3.770388411435333e-12, -6.638162402338032e-14,  1.076793400430413e-15, -1.627587663462592e-17,  2.312394332477086e-19, -3.108905253518145e-21,
  2.164047810264246e-03, -1.864583598907585e-04,  9.007401156253791e-06, -3.173789113848695e-07,  9.043965603562302e-09, -2.200872086708853e-10,  4.728806348969483e-12,
 -9.173097589358976e-14,  1.632257712521466e-15, -2.695948446826930e-17,  4.171093046528569e-19, -6.087879311249183e-21,  1.242001338106818e-03, -1.238781747792631e-04,
  6.814767600932474e-06, -2.703815118683209e-07,  8.602210159708799e-09, -2.321404440876385e-10,  5.500132945738075e-12, -1.170928040568734e-13,  2.277181294051895e-15,
 -4.095728345437033e-17,  6.878070069903936e-19, -1.086406376849596e-20,  6.903918153272771e-04, -7.886086582739080e-05,  4.903235837152095e-06, -2.177413609189356e-07,
  7.694986105193547e-09, -2.292455863612164e-10,  5.965231716007872e-12, -1.388541372177929e-13,  2.941135114294997e-15, -5.741736610422659e-17,  1.043359246575200e-18,
 -1.778228232270825e-20,  3.726540058474960e-04, -4.828262541206600e-05,  3.369207267828297e-06, -1.665123319112933e-07,  6.504832691736557e-09, -2.130187776082652e-10,
  6.064074657700641e-12, -1.537885163099577e-13,  3.536143610332965e-15, -7.469661527573655e-17,  1.464422088962629e-18, -2.685504562810004e-20,  1.958729581015530e-04,
 -2.853656026018686e-05,  2.220253425841355e-06, -1.214605352115525e-07,  5.220682956507632e-09, -1.871570011169354e-10,  5.806986502566628e-12, -1.598991581705807e-13,
  3.978446202114344e-15, -9.066145175710745e-17,  1.912175095042743e-18, -3.762833338376150e-20,  1.005609213301391e-04, -1.634344898940671e-05,  1.409058894434286e-06,
 -8.488628128017915e-08,  3.996572985068934e-09, -1.562176566982660e-10,  5.263786907023509e-12, -1.568479024154637e-13,  4.209741691280482e-15, -1.031886406647717e-16,
  2.334925934783872e-18, -4.917451086968266e-20,  5.059456648365330e-05, -9.105706667519269e-06,  8.648712758817046e-07, -5.709392575662730e-08,  2.931683639981886e-09,
 -1.244617186341685e-10,  4.538250602122202e-12, -1.458586302320489e-13,  4.210088440678913e-15, -1.106843007376810e-16,  2.679662648381277e-18, -6.024170943487277e-20,
  2.503441227001567e-05, -4.955244727907614e-06,  5.156415136334661e-07, -3.712346671237057e-08,  2.070249639059567e-09, -9.509674222417325e-11,  3.739289461626960e-12,
 -1.292090537037561e-13,  3.998728160975504e-15, -1.124340651793165e-16,  2.904500412308979e-18, -6.952133345837965e-20,  1.222843167075576e-05, -2.644934006404133e-06,
  2.999431920166455e-07, -2.344217391755035e-08,  1.413934000582859e-09, -7.001150548471479e-11,  2.958459368642116e-12, -1.095559917732537e-13,  3.624330528081147e-15,
 -1.086802373177832e-16,  2.987658538007343e-18, -7.594270877635504e-20,  5.920259304288929e-06, -1.390734061946593e-06,  1.709980659846094e-07, -1.444292193262819e-08,
  9.383891371217088e-10, -4.990104529243288e-11,  2.258330721948998e-12, -8.933717963177854e-14,  3.149753607059666e-15, -1.004398541175820e-16,  2.930309190621637e-18,
 -7.889467935191126e-20,  2.852792051237008e-06, -7.235939735955221e-07,  9.598751810955442e-08, -8.723061176425365e-09,  6.080687631187138e-10, -3.459887539469855e-11,
  1.671203803611840e-12, -7.039616992904208e-14,  2.637093148322754e-15, -8.916790609809099e-17,  2.753267275669883e-18, -7.830993218783199e-20,  1.374211046777575e-06,
 -3.742493530794083e-07,  5.330361504260250e-08, -5.189357863379125e-09,  3.865652473190388e-10, -2.344822367084680e-11,  1.204664309528285e-12, -5.385764578789043e-14,
  2.137065173227729e-15, -7.639790170137560e-17,  2.489646177538332e-18, -7.460589210023630e-20,  6.647170179377930e-07, -1.933177982998400e-07,  2.942296731683044e-08,
 -3.055452824278073e-09,  2.422598302043616e-10, -1.560748852943423e-11,  8.498870323680058e-13, -4.019484917949099e-14,  1.684118570932898e-15, -6.346256866473011e-17,
  2.176439370483624e-18, -6.852572719886152e-20,  3.243325224068433e-07, -1.002001876476435e-07,  1.622087271278944e-08, -1.789090563226922e-09,  1.503833580305268e-10,
 -1.025148732843023e-11,  5.895877159041082e-13, -2.939848893557388e-14,  1.296484251377900e-15, -5.134077721913307e-17,  1.847511981513303e-18, -6.094482915037270e-20,
  1.603511939648963e-07, -5.235646433391712e-08,  8.973423223092538e-09, -1.046697753703995e-09,  9.289706789732039e-11, -6.675344534780221e-12,  4.040191930845073e-13,
 -2.116671198531422e-14,  9.792843154894409e-16, -4.062433523769992e-17,  1.529298120965413e-18, -5.270076505053548e-20,  8.068216735270381e-08, -2.770302704684914e-08,
  5.003792487932201e-09, -6.146042315586910e-10,  5.736164514492109e-11, -4.328122507716653e-12,  2.746598256259437e-13, -1.506579694244397e-14,  7.287768024135897e-16,
 -3.156787228246633e-17,  1.239296859139456e-18, -4.448009733621143e-20,  4.148331603857386e-08, -1.490579787725318e-08,  2.824346218806864e-09, -3.637152210458963e-10,
  3.555004933556872e-11, -2.805525069491640e-12,  1.859690151663053e-13, -1.064175919631966e-14,  5.363569850929292e-16, -2.417823954125257e-17,  9.866808115294526e-19,
 -3.676866923174359e-20,  2.187285590296503e-08, -8.185493487646634e-09,  1.619585198240112e-09, -2.177159230740549e-10,  2.219219005156446e-11, -1.824418203602132e-12,
  1.258360905773039e-13, -7.484125152615767e-15,  3.916204580826047e-16, -1.830863837624479e-17,  7.740702528102131e-19, -2.985316934509831e-20,  1.185944174118258e-08,
 -4.600748141294556e-09,  9.462034328088695e-10, -1.321865634005114e-10,  1.399186098089962e-11, -1.193346454071391e-12,  8.530674645564430e-14, -5.253207371611135e-15,
  2.843359336949223e-16, -1.373708120119298e-17,  5.996432556543493e-19, -2.385402527530146e-20,  6.621866192087208e-09, -2.650790870742135e-09,  5.640560151168620e-10,
 -8.152501139807759e-11,  8.922182387523602e-12, -7.861524723445878e-13,  5.800944684381780e-14, -3.684194073408337e-15,  2.054872388853115e-16, -1.022171813367647e-17,
  4.590394701919756e-19, -1.877065149230923e-20,  3.805251638421529e-09, -1.564772413433371e-09,  3.429046502092386e-10, -5.104255542384728e-11,  5.750231234710362e-12,
 -5.212007295904365e-13,  3.953387401676833e-14, -2.579104696344058e-15,  1.476567262978614e-16, -7.534014978414333e-18,  3.468062304904661e-19, -1.452554556019383e-20,
  2.241143876758808e-09, -9.425074682096747e-10,  2.117179549879272e-10, -3.230779380157490e-11,  3.729764975923851e-12, -3.462485398054585e-13,  2.688328952003858e-14,
 -1.794111526287186e-15,  1.050121334214785e-16, -5.474710745067825e-18,  2.573466753939531e-19, -1.099999933588813e-20,  1.338338790554641e-09, -5.731018895233278e-10,
  1.313474052780526e-10, -2.045216005983160e-11,  2.408539335994809e-12, -2.279902511241660e-13,  1.804107628430182e-14, -1.226509024140416e-15,  7.309566641575719e-17,
 -3.878257157177325e-18,  1.854445020837854e-19, -8.059160281871022e-21,  7.902112270926846e-10, -3.430739298345669e-10,  7.984577642359912e-11, -1.262685884148961e-11,
  1.509884662677544e-12, -1.450783472734679e-13,  1.164906070083332e-14, -8.033074316279090e-16,  4.854283527342413e-17, -2.610563787474868e-18,  1.264796220281702e-19,
 -5.567212310308130e-21,  4.321094532421022e-10, -1.893933545761911e-10,  4.455071031898163e-11, -7.121398115565151e-12,  8.606378414186597e-13, -8.355885321829799e-14,
  6.777793771913063e-15, -4.720380518025615e-16,  2.880101039574680e-17, -1.563489259150637e-18,  7.644546210983255e-20, -3.394870454464049e-21,  1.705112501437045e-10,
 -7.512993819870902e-11,  1.777770639047573e-11, -2.858804885085698e-12,  3.475403906784366e-13, -3.393841534810036e-14,  2.768492509168314e-15, -1.938773812943455e-16,
  1.189300948966711e-17, -6.490111320357309e-19,  3.189498909927793e-20, -1.423451593185111e-21,  7.259176589075159e-02, -2.202952335970021e-04,  6.984334847366828e-07,
 -2.292310137525754e-09,  7.710059393899876e-12, -2.634398365224915e-14,  9.081244220155769e-17, -3.143533305503733e-19,  1.089121294635127e-21, -3.769820039966930e-24,
  1.301912062189554e-26, -4.483770926862010e-29,  6.895468300414578e-02, -2.797056734750043e-04,  1.349027090746174e-06, -6.666749810304492e-09,  3.230401187834692e-11,
 -1.525096501818723e-13,  7.031781371414896e-16, -3.177291738563413e-18,  1.411015343909360e-20, -6.172655390210011e-23,  2.664606405365722e-25, -1.136603193232509e-27,
  6.222742094443034e-02, -3.795989365836129e-04,  2.645779262316284e-06, -1.730375838624022e-08,  1.064375290525707e-10, -6.246987202905727e-13,  3.532741527485535e-15,
 -1.937368563536542e-17,  1.035011373934809e-19, -5.404942361264826e-22,  2.766340628502259e-24, -1.390609504656538e-26,  5.336696606235674e-02, -4.892192349059551e-04,
  4.516260987801553e-06, -3.699371492756359e-08,  2.789035100271300e-10, -1.977398010693374e-12,  1.335171967661968e-14, -8.658748776107458e-17,  5.426186829305423e-19,
 -3.301030282442437e-21,  1.956450696675416e-23, -1.132853977751910e-25,  4.351449589157223e-02, -5.769221163524640e-04,  6.749834505405821e-06, -6.770770843938639e-08,
  6.138223010525412e-10, -5.160957304472193e-12,  4.087775315096067e-14, -3.082472514105801e-16,  2.229753278878920e-18, -1.556042536959260e-20,  1.052196146699436e-22,
 -6.917930966586131e-25,  3.375460045041022e-02, -6.202215223385227e-04,  8.989104835187018e-06, -1.087647847796742e-07,  1.168657405590975e-09, -1.149494919763282e-11,
  1.054470317650241e-13, -9.134911246769938e-16,  7.540378680778694e-18, -5.970213676757816e-20,  4.557454095518584e-22, -3.367700422379087e-24,  2.492915431660995e-02,
 -6.111721787390963e-04,  1.080945419413594e-05, -1.558079597953600e-07,  1.961409537827039e-09, -2.233170856608243e-11,  2.349310682537216e-13, -2.316511541304888e-15,
  2.162812416194325e-17, -1.926535563090530e-19,  1.646784569714192e-21, -1.356972955308126e-23,  1.754566141588602e-02, -5.559055173887880e-04,  1.185197057921865e-05,
 -2.013372429802947e-07,  2.941284283011270e-09, -3.842973761377681e-11,  4.599348619383442e-13, -5.123232902378906e-15,  5.371826775973977e-17, -5.346608771690318e-19,
  5.084164759369442e-21, -4.642284419549054e-23,  1.178173344509845e-02, -4.697742012236933e-04,  1.194030802228785e-05, -2.368074576626740e-07,  3.981916276810337e-09,
 -5.926619372107690e-11,  8.015027072431115e-13, -1.002199851811639e-14,  1.173067364078834e-16, -1.297169648409619e-18,  1.364711454413077e-20, -1.373531564146650e-22,
  7.557829447569915e-03, -3.709437671936144e-04,  1.112446794149016e-05, -2.554084001025663e-07,  4.907778561251277e-09, -8.267808864930801e-11,  1.256024395116356e-12,
 -1.753333949037093e-14,  2.279168493997250e-16, -2.786318954479755e-18,  3.227995273518269e-20, -3.564910981491916e-22,  4.638640190248785e-03, -2.750619640892150e-04,
  9.639104329181396e-06, -2.542324613207059e-07,  5.546399143919194e-09, -1.051490012210457e-10,  1.785019685500384e-12, -2.768293847841954e-14,  3.978143801159139e-16,
 -5.353423229445726e-18,  6.801311183650056e-20, -8.209146173285768e-22,  2.728589676984379e-03, -1.923985306619264e-04,  7.807454589039068e-06, -2.348920625187556e-07,
  5.783509235981124e-09, -1.227418237744534e-10,  2.317349599053496e-12, -3.975128748839244e-14,  6.289051695269069e-16, -9.279812085250318e-18,  1.288086933487439e-19,
 -1.693135580004103e-21,  1.541289469733297e-03, -1.274717908559911e-04,  5.939638393103405e-06, -2.025005915580712e-07,  5.596168247063620e-09, -1.323086464995965e-10,
  2.765925668738006e-12, -5.226764900765154e-14,  9.069659233602169e-16, -1.462173322833220e-17,  2.209920027594857e-19, -3.153212914739062e-21,  8.378665656781348e-04,
 -8.030978970580283e-05,  4.263297673106016e-06, -1.636987781776271e-07,  5.051264847559857e-09, -1.324395627330945e-10,  3.053098105048874e-12, -6.331804182501852e-14,
  1.200832390398130e-15, -2.108171726439657e-17,  3.458517835719794e-19, -5.340611421247912e-21,  4.394037420305596e-04, -4.829730686420678e-05,  2.899753760722293e-06,
 -1.246746735156231e-07,  4.274606446145210e-09, -1.237556976673647e-10,  3.133823256154283e-12, -7.107371009219698e-14,  1.468323003521635e-15, -2.798385301102841e-17,
  4.968379745308163e-19, -8.279690304701056e-21,  2.229036979138672e-04, -2.783109230028229e-05,  1.877036706129779e-06, -8.987274157754264e-08,  3.407888964037383e-09,
 -1.084985011103336e-10,  3.006849230730134e-12, -7.432215257066027e-14,  1.667309594602569e-15, -3.439340091545449e-17,  6.589984944735830e-19, -1.181996774583016e-20,
  1.097033187893287e-04, -1.542652083118642e-05,  1.161306500499826e-06, -6.159984646295064e-08,  2.571812321418032e-09, -8.968791107881458e-11,  2.710518575548055e-12,
 -7.277951447561216e-14,  1.767542538470401e-15, -3.935133174701381e-17,  8.115115651494708e-19, -1.562560977013276e-20,  5.255063548786957e-05, -8.257743898447517e-06,
  6.897198848286117e-07, -4.032965499207782e-08,  1.845952363380364e-09, -7.024468268814913e-11,  2.307064022270986e-12, -6.707856678125443e-14,  1.758409513289201e-15,
 -4.213381787351749e-17,  9.327109491974589e-19, -1.923123953751966e-20,  2.458806874861185e-05, -4.286486271543903e-06,  3.949859274201622e-07, -2.533845697639658e-08,
  1.266207326115570e-09, -5.238179435773269e-11,  1.863305884487431e-12, -5.848165756545545e-14,  1.649936522813213e-15, -4.243364224273444e-17,  1.005730022280121e-18,
 -2.215056373517531e-20,  1.128026297066770e-05, -2.166994489359097e-06,  2.191094224383149e-07, -1.534990469487806e-08,  8.340599005347240e-10, -3.737407622460650e-11,
  1.435103878069560e-12, -4.847190295809881e-14,  1.467563112561134e-15, -4.040106721532326e-17,  1.022588032739448e-18, -2.399824477643751e-20,  5.095064825768641e-06,
 -1.071735811644043e-06,  1.182947027916809e-07, -9.009748954423030e-09,  5.302048251447911e-10, -2.564188390432631e-11,  1.059338676663554e-12, -3.838649007610313e-14,
  1.243638835855206e-15, -3.654801540927115e-17,  9.853457984134695e-19, -2.457946762064074e-20,  2.275763290986339e-06, -5.210027220379111e-07,  6.246274322622677e-08,
 -5.149579861946549e-09,  3.269173754374067e-10, -1.700289767498041e-11,  7.532597917334033e-13, -2.919358282466657e-14,  1.009149409739090e-15, -3.157255651534496e-17,
  9.043181165133283e-19, -2.391818753258985e-20,  1.009901958148723e-06, -2.501806496447199e-07,  3.242112626405850e-08, -2.880805570793547e-09,  1.965277568592410e-10,
 -1.095302335928303e-11,  5.186218032349718e-13, -2.143100467390289e-14,  7.881164774333295e-16, -2.617719610177008e-17,  7.944597853501401e-19, -2.222290417692926e-20,
  4.474437189329876e-07, -1.192755390730290e-07,  1.662853199786286e-08, -1.585717454003432e-09,  1.157952419375320e-10, -6.890715858044329e-12,  3.475510301895049e-13,
 -1.526473890928371e-14,  5.954170561858890e-16, -2.093633691714350e-17,  6.714456576040782e-19, -1.981221856518025e-20,  1.989403284829440e-07, -5.675766236983332e-08,
  8.472685568505250e-09, -8.634516207348403e-10,  6.722987483585495e-11, -4.256190773844488e-12,  2.278935368770910e-13, -1.060434589142320e-14,  4.373943626629123e-16,
 -1.623434938553513e-17,  5.486516796806630e-19, -1.703137242627598e-20,  8.922972319211998e-08, -2.710256470419545e-08,  4.312070616115992e-09, -4.676324168645007e-10,
  3.867026014779314e-11, -2.594884459540731e-12,  1.469853467615142e-13, -7.222276064017618e-15,  3.140194109411467e-16, -1.226582181224053e-17,  4.355720803854627e-19,
 -1.418536337268296e-20,  4.058794879498607e-08, -1.305743496437628e-08,  2.203968588963603e-09, -2.532628089053405e-10,  2.215425859086781e-11, -1.569803707085873e-12,
  9.373403070644210e-14, -4.846979754328005e-15,  2.214310617159608e-16, -9.074190180358331e-18,  3.375797950640959e-19, -1.150098197738760e-20,  1.882148943188684e-08,
 -6.380846763905406e-09,  1.137340590979457e-09, -1.378890901739846e-10,  1.270759437360075e-11, -9.471643007312669e-13,  5.939918119334479e-14, -3.221119937581532e-15,
  1.540996512526926e-16, -6.603895716414100e-18,  2.565820077023703e-19, -9.117212897610385e-21,  8.942272898786424e-09, -3.178901165581563e-09,  5.955782362759101e-10,
 -7.584928654630156e-11,  7.333816796371286e-12, -5.727283503835997e-13,  3.758077267023145e-14, -2.129470253084870e-15,  1.063120452720313e-16, -4.748487468439354e-18,
  1.920593303991668e-19, -7.095662637613295e-21,  4.372677120405648e-09, -1.622020621336933e-09,  3.179356517570300e-10, -4.234418278446960e-11,  4.277335583840568e-12,
 -3.485646228414544e-13,  2.383792712830324e-14, -1.406129823750513e-15,  7.299347894287953e-17, -3.386242725250658e-18,  1.420988166729578e-19, -5.440714221836872e-21,
  2.208920874445158e-09, -8.508936082812977e-10,  1.736733841903831e-10, -2.408035748372621e-11,  2.530198026482742e-12, -2.142592762556361e-13,  1.521053039829576e-14,
 -9.303931556293082e-16,  5.003172118385572e-17, -2.401970436729574e-18,  1.042101923520313e-19, -4.121072972703099e-21,  1.155627980004972e-09, -4.600814813892522e-10,
  9.731998946354619e-11, -1.398307603235210e-11,  1.521495690996518e-12, -1.333099562132869e-13,  9.783234380960896e-15, -6.180532426009115e-16,  3.429558195206153e-17,
 -1.697521835043939e-18,  7.586571761845927e-20, -3.087788419821517e-21,  6.263599197325359e-10, -2.565222590014244e-10,  5.596477640422356e-11, -8.293624285414670e-12,
  9.302649002303105e-13, -8.396245463861782e-14,  6.342504706747852e-15, -4.121208433776927e-16,  2.350309588716672e-17, -1.194717550393060e-18,  5.479509853299709e-20,
 -2.286940066821713e-21,  3.505959079510913e-10, -1.470213559752476e-10,  3.292189855750337e-11, -5.008001992452924e-12,  5.763603966677779e-13, -5.334451217148422e-14,
  4.129615154309054e-15, -2.748139078804803e-16,  1.604084207129166e-17, -8.340320731230994e-19,  3.910285797601557e-20, -1.667198475431103e-21,  2.006644831886815e-10,
 -8.576843918687928e-11,  1.961641234562956e-11, -3.048150026847397e-12,  3.582327379322851e-13, -3.384256336705540e-14,  2.672808535110280e-15, -1.813669026263180e-16,
  1.078907174993952e-17, -5.714221057259684e-19,  2.727624637258519e-20, -1.183407283346634e-21,  1.146076681399397e-10, -4.970324864560447e-11,  1.155368071896436e-11,
 -1.824868771747529e-12,  2.179495390808413e-13, -2.091713576720303e-14,  1.677609104172986e-15, -1.155566846277255e-16,  6.975333707681261e-18, -3.747258430248479e-19,
  1.813643816451639e-20, -7.975076330766074e-22,  6.122011694487288e-11, -2.681798304272798e-11,  6.304452789306937e-12, -1.007132422401213e-12,  1.216391646572915e-13,
 -1.180272251822863e-14,  9.567986834440903e-16, -6.659746761053669e-17,  4.061093082140404e-18, -2.203386049552587e-19,  1.076747127560723e-20, -4.779229748744202e-22,
  2.384166468800106e-11, -1.050240183256901e-11,  2.484442264100672e-12, -3.994045722049444e-13,  4.854110662646683e-14, -4.738853493880257e-15,  3.864597236408215e-16,
 -2.705634816054414e-17,  1.659269714737991e-18, -9.052376393467362e-20,  4.447543312685254e-21, -1.984403746847774e-22,  7.172158858536974e-02, -2.148157387576221e-04,
  6.716489173409049e-07, -2.173048728544322e-09,  7.204281587781449e-12, -2.426629139499181e-14,  8.247876786466955e-17, -2.815760905325404e-19,  9.623251808256218e-22,
 -3.286432167694585e-24,  1.119956088059988e-26, -3.806688262253145e-29,  6.785695017714889e-02, -2.692249000525743e-04,  1.272029511524257e-06, -6.173399575448583e-09,
  2.941563076768956e-11, -1.366519046760350e-13,  6.202153718067439e-16, -2.759358160758696e-18,  1.206838712183895e-20, -5.200414073282603e-23,  2.211667067351219e-25,
 -9.295718074535400e-28,  6.075008223738710e-02, -3.592352523814968e-04,  2.447954297388263e-06, -1.569628094879322e-08,  9.474933371786976e-11, -5.460654659562786e-13,
  3.033867287122152e-15, -1.635275889114841e-17,  8.589605767407351e-20, -4.411653915241064e-22,  2.221333392643304e-24, -1.098786105164809e-26,  5.147964105011024e-02,
 -4.547918800483736e-04,  4.097860290309466e-06, -3.283102217373630e-08,  2.423732755277843e-10, -1.684192662464896e-12,  1.115352092993572e-14, -7.098327813536778e-17,
  4.367447308400520e-19, -2.609691703355143e-21,  1.519731451393564e-23, -8.648963263806962e-26,  4.130988477677140e-02, -5.260139629892387e-04,  5.993027697999859e-06,
 -5.866179601101357e-08,  5.197542853459234e-10, -4.275889485963148e-12,  3.316701055749598e-14, -2.451016466338135e-16,  1.738534813317201e-18, -1.190259124160983e-20,
  7.899428435854726e-23, -5.099388062196434e-25,  3.140970071830094e-02, -5.532281387553099e-04,  7.788954636595840e-06, -9.177618537365098e-08,  9.621268347180385e-10,
 -9.245754403680303e-12,  8.294776260543252e-14, -7.033397064073012e-16,  5.686418918232510e-18, -4.412357768905877e-20,  3.302595257194098e-22, -2.393926401576124e-24,
  2.264628627250357e-02, -5.316738817679967e-04,  9.114250372922083e-06, -1.277128544247377e-07,  1.566283533755054e-09, -1.739948472822762e-11,  1.787998019911930e-13,
 -1.723749241966832e-15,  1.574723454957376e-17, -1.373382961832521e-19,  1.150076355998508e-21, -9.288689340520172e-24,  1.549742631429505e-02, -4.700086564283735e-04,
  9.694740769150389e-06, -1.598711906241347e-07,  2.272387631256316e-09, -2.893493653067710e-11,  3.379148220620001e-13, -3.676637885003907e-15,  3.768695971771117e-17,
 -3.669633697621232e-19,  3.415948800495267e-21, -3.055010406604428e-23,  1.007710249902430e-02, -3.846191525671144e-04,  9.444908895934482e-06, -1.816225244203582e-07,
  2.968245116479018e-09, -4.301299469437081e-11,  5.671076923925450e-13, -6.920782868723793e-15,  7.913331611594922e-17, -8.554746774498648e-19,  8.804818627637305e-21,
 -8.674617778632496e-23,  6.234366188535328e-03, -2.929885131014315e-04,  8.481028982407031e-06, -1.886277766807354e-07,  3.519793194564500e-09, -5.768503732232330e-11,
  8.537315602440404e-13, -1.162348188572332e-14,  1.475077807697182e-16, -1.761960195713437e-18,  1.995904710054876e-20, -2.156644669898066e-22,  3.675233005606027e-03,
 -2.087895815181824e-04,  7.058248276092183e-06, -1.802260201070657e-07,  3.815780758602561e-09, -7.033241594823384e-11,  1.162515889324261e-12, -1.757477271701106e-14,
  2.464428079495037e-16, -3.238936074421085e-18,  4.021884450781880e-20, -4.747860573517475e-22,  2.068060546726119e-03, -1.398092588002689e-04,  5.471802114110393e-06,
 -1.593139315741197e-07,  3.805242570009213e-09, -7.848417984853102e-11,  1.442166735289557e-12, -2.410665726205271e-14,  3.720333196207069e-16, -5.359650245860828e-18,
  7.269199371778037e-20, -9.343007591058824e-22,  1.112957025405863e-03, -8.833248124752522e-05,  3.969992982796381e-06, -1.309687795811086e-07,  3.510362165541153e-09,
 -8.064026291228379e-11,  1.640371898193263e-12, -3.019987456130220e-14,  5.110809339810009e-16, -8.043076170328806e-18,  1.187618393509952e-19, -1.656721829973176e-21,
  5.741026171836100e-04, -5.286515186686701e-05,  2.707843100779851e-06, -1.006204234920367e-07,  3.011391399571559e-09, -7.671393755002711e-11,  1.720737105497952e-12,
 -3.476556181731512e-14,  6.429991993577542e-16, -1.101900686912429e-17,  1.766007656492324e-19, -2.666152293037994e-21,  2.845585079161643e-04, -3.008553598256713e-05,
  1.743936046191253e-06, -7.258717722903682e-08,  2.414352800400050e-09, -6.792478118112715e-11,  1.673821867834288e-12, -3.698614499277710e-14,  7.452509515703848e-16,
 -1.386568889856575e-17,  2.405254783520374e-19, -3.919236111308693e-21,  1.359010625079195e-04, -1.634430631063008e-05,  1.065112198765135e-06, -4.939747194700640e-08,
  1.817893448196659e-09, -5.626193744579603e-11,  1.517761537098024e-12, -3.656137786705645e-14,  8.001681143812565e-16, -1.611755165537061e-17,  3.018039785746789e-19,
 -5.294225511802855e-21,  6.272961966761075e-05, -8.509715620049114e-06,  6.196086067582500e-07, -3.185907261749073e-08,  1.291711779656150e-09, -4.381231580080211e-11,
  1.289491808725610e-12, -3.375779173204441e-14,  8.001484086486594e-16, -1.740149682275760e-17,  3.508334854371258e-19, -6.609200246752517e-21,  2.807944298160010e-05,
 -4.263696913851808e-06,  3.448549095305351e-07, -1.956505948793033e-08,  8.703542129878192e-10, -3.223509152048147e-11,  1.031701423922218e-12, -2.926384458504705e-14,
  7.491058087640523e-16, -1.754322087005550e-17,  3.798617708762616e-19, -7.666672330324940e-21,  1.223439519662794e-05, -2.064654310934376e-06,  1.844815526933476e-07,
 -1.149556634494952e-08,  5.588499764061439e-10, -2.252099486116562e-11,  7.812952894367902e-13, -2.394005693285868e-14,  6.600115646790960e-16, -1.660119704485342e-17,
  3.851137783593795e-19, -8.307763180026435e-21,  5.209746628287284e-06, -9.706561622397945e-07,  9.531163735057595e-08, -6.494198555488780e-09,  3.436761791895237e-10,
 -1.501708643851724e-11,  5.629040931705694e-13, -1.857810002918095e-14,  5.501129375525027e-16, -1.482317400776503e-17,  3.675045448280886e-19, -8.453913716448976e-21,
  2.177737405343669e-06, -4.451640085193658e-07,  4.779535435861556e-08, -3.545591066006092e-09,  2.034744344251507e-10, -9.607061234748090e-12,  3.878706535401280e-13,
 -1.374794877846604e-14,  4.360356029372764e-16, -1.255423510883140e-17,  3.318322042860208e-19, -8.120741718361959e-21,  8.978773167847433e-07, -2.001752437942437e-07,
  2.338529129329555e-08, -1.880736369709176e-09,  1.166010685171713e-10, -5.928347988871457e-12,  2.569815617027512e-13, -9.753422947650381e-15,  3.304255556845550e-16,
 -1.013879182314875e-17,  2.849986999952930e-19, -7.402361099087435e-21,  3.670017431118011e-07, -8.872732247060040e-08,  1.122514030185076e-08, -9.746358131874867e-10,
  6.503287267242020e-11, -3.548262335521847e-12,  1.646145148984601e-13, -6.670073833441456e-15,  2.406906019407289e-16, -7.849822711208234e-18,  2.340691018174312e-19,
 -6.436754576430968e-21,  1.495258168029345e-07, -3.898521755907813e-08,  5.316291094172597e-09, -4.962719625132564e-10,  3.550458756953697e-11, -2.071597244453033e-12,
  1.025256667115829e-13, -4.421605662894550e-15,  1.694615619236644e-16, -5.858327532872595e-18,  1.848219061580032e-19, -5.367667223226811e-21,  6.107207390030332e-08,
 -1.707981887171835e-08,  2.498971058510200e-09, -2.497624798794479e-10,  1.908576042571216e-11, -1.186671618678788e-12,  6.244431894736210e-14, -2.857380788781364e-15,
  1.159673307048945e-16, -4.237549224819502e-18,  1.410647985633364e-19, -4.315531998625457e-21,  2.515522220028213e-08, -7.506497479857877e-09,  1.172974090295236e-09,
 -1.249949165204219e-10,  1.016273998991674e-11, -6.709048511942622e-13,  3.740929571823952e-14, -1.810433333823426e-15,  7.757018924675060e-17, -2.987300799881648e-18,
  1.046377266328280e-19, -3.362905925628266e-21,  1.051272516845236e-08, -3.329994693859361e-09,  5.531834906130439e-10, -6.258527814079441e-11,  5.392765897102708e-12,
 -3.765976945556577e-13,  2.217310362763754e-14, -1.131115107803006e-15,  5.100111247865133e-17, -2.063684322256292e-18,  7.583768108359786e-20, -2.553261912524927e-21,
  4.484935572525074e-09, -1.500322602855561e-09,  2.637388045492213e-10, -3.154322568268529e-11,  2.868856920474099e-12, -2.111195062658623e-13,  1.307757085175964e-14,
 -7.007719974206777e-16,  3.314106923728789e-17, -1.404506580453725e-18,  5.398390364968980e-20, -1.898329106484791e-21,  1.964891026239312e-09, -6.906745436957141e-10,
  1.278777961821050e-10, -1.609709535970636e-11,  1.538887222047247e-12, -1.188668919086658e-13,  7.717357410894614e-15, -4.328289124602847e-16,  2.139509984067552e-17,
 -9.464844505155604e-19,  3.792738797959416e-20, -1.388688195612666e-21,  8.889579543789265e-10, -3.267010908595247e-10,  6.340833170436101e-11, -8.363058251534910e-12,
  8.367944895461732e-13, -6.756587004342404e-14,  4.579706802007349e-15, -2.678205804089501e-16,  1.378707544278214e-17, -6.344411594265018e-19,  2.641555743350738e-20,
 -1.003771019587112e-21,  4.173354299271425e-10, -1.595644633743410e-10,  3.230846639895100e-11, -4.444245959634415e-12,  4.633667370180037e-13, -3.894417810832056e-14,
  2.744607341157057e-15, -1.666996382530714e-16,  8.903126648548248e-18, -4.246069297372250e-19,  1.830382122675757e-20, -7.193604644670672e-22,  2.040361137954045e-10,
 -8.076157038148132e-11,  1.697640500061240e-11, -2.424012166552186e-12,  2.621512189972564e-13, -2.283318342929098e-14,  1.666042290090028e-15, -1.046660589495094e-16,
  5.776564700380757e-18, -2.844271763580352e-19,  1.264724102113314e-20, -5.122301686160148e-22,  1.040379869979620e-10, -4.242471626802329e-11,  9.212177418887414e-12,
 -1.358784044467167e-12,  1.517097966328640e-13, -1.363158436743352e-14,  1.025256838822683e-15, -6.633822082034247e-17,  3.767796179127376e-18, -1.907677160751529e-19,
  8.715878054462122e-21, -3.624172415663233e-22,  5.520945704079852e-11, -2.308175243964306e-11,  5.151363490077520e-12, -7.809985516233439e-13,  8.958929178638832e-14,
 -8.265408572963678e-15,  6.378752943265792e-16, -4.232100633206840e-17,  2.463057056279338e-18, -1.277021228098726e-19,  5.970749188461308e-21, -2.538934013637828e-22,
  3.022072644306374e-11, -1.289148429600776e-11,  2.942000809058633e-12, -4.561465771820234e-13,  5.349275610366146e-14, -5.042865316255118e-15,  3.974579246387907e-16,
 -2.691632499886930e-17,  1.598090004268109e-18, -8.448081739171008e-20,  4.025255203360482e-21, -1.743315689780928e-22,  1.666638985517827e-11, -7.219556233574609e-12,
  1.676045818010685e-12, -2.643830704139605e-13,  3.153575054407055e-14, -3.022784354481013e-15,  2.421404115270042e-16, -1.665932115727642e-17,  1.004447085373628e-18,
 -5.390008353163344e-20,  2.605883812358424e-21, -1.144668203438991e-22,  8.685363716763754e-12, -3.802486719223583e-12,  8.933171975452870e-13, -1.426128785321766e-13,
  1.721325167911621e-14, -1.669146575854031e-15,  1.352265087414687e-16, -9.406637505116764e-18,  5.732730514963370e-19, -3.108547108963150e-20,  1.518221407924880e-21,
 -6.735046990158326e-23,  3.335718940485511e-12, -1.469024782051537e-12,  3.474097514168046e-13, -5.583370606315434e-14,  6.783659408540011e-15, -6.620642771079387e-16,
  5.397660639861270e-17, -3.777870695031014e-18,  2.316187083357846e-19, -1.263281577976914e-20,  6.204986071899005e-22, -2.767809487594832e-23,  7.087290957999211e-02,
 -2.095449303923349e-04,  6.462482690921500e-07, -2.061557896819378e-09,  6.738129580631355e-12, -2.237803707267098e-14,  7.500857081025316e-17, -2.525913794342835e-19,
  8.516896573964364e-22, -2.870204483568542e-24,  9.653170118955802e-27, -3.238702537204899e-29,  6.679994489897068e-02, -2.593371886721682e-04,  1.200684976771631e-06,
 -5.723830532607331e-09,  2.682540454852188e-11, -1.226519115511231e-13,  5.480902595270377e-16, -2.401493602789836e-18,  1.034609712962337e-20, -4.392371399709856e-23,
  1.840708244049029e-25, -7.624604708916256e-28,  5.935115090015748e-02, -3.403800727365823e-04,  2.268346861573250e-06, -1.426385619322588e-08,  8.452060960267727e-11,
 -4.784506623360242e-13,  2.612200884014407e-15, -1.384194993733057e-17,  7.150349196137320e-20, -3.612709991879918e-22,  1.789929218099377e-24, -8.714159713223567e-27,
  4.972363394816487e-02, -4.235214299828080e-04,  3.726089623625369e-06, -2.920862481989535e-08,  2.112130854424562e-10, -1.438862063925319e-12,  9.348322397223882e-15,
 -5.840036116744204e-17,  3.528793396036838e-19, -2.071560589220333e-21,  1.185586382436036e-23, -6.633140082983409e-26,  3.929745042860896e-02, -4.807503639513704e-04,
  5.336294453687629e-06, -5.098884511175708e-08,  4.416715732866998e-10, -3.556324007387997e-12,  2.702271759688662e-14, -1.957559055684819e-16,  1.361897424549516e-18,
 -9.149642363981013e-21,  5.961303089880236e-23, -3.779260563484425e-25,  2.931478822199041e-02, -4.950734426775344e-04,  6.774235317664937e-06, -7.775965663910690e-08,
  7.956243909794453e-10, -7.472149574749370e-12,  6.558002029846096e-14, -5.444324907280108e-16,  4.312391484963295e-18, -3.280163918785045e-20,  2.407898461861160e-22,
 -1.712535460527724e-24,  2.065628097231047e-02, -4.644890766053737e-04,  7.721288435808403e-06, -1.052185216793777e-07,  1.257572322012303e-09, -1.363479693560166e-11,
  1.369052640165677e-13, -1.290807989626532e-15,  1.154124960303709e-17, -9.857778907278842e-20,  8.088988283800193e-22, -6.404950510930239e-24,  1.376117534723228e-02,
 -3.995477406096800e-04,  7.976675930319531e-06, -1.277346348305769e-07,  1.767105573364725e-09, -2.193538014538677e-11,  2.500405256953456e-13, -2.658077104468928e-15,
  2.664291335587492e-17, -2.538601909513846e-19,  2.313832018387493e-21, -2.027304670301658e-23,  8.677000404138888e-03, -3.170312825079139e-04,  7.524228640161536e-06,
 -1.403342529900274e-07,  2.229761111531693e-09, -3.146784617882354e-11,  4.045922276381394e-13, -4.820121317068757e-15,  5.385205518585532e-17, -5.692767774687623e-19,
  5.733246050462111e-21, -5.530352973332517e-23,  5.185017373284012e-03, -2.333179920663599e-04,  6.520649061836714e-06, -1.405291848000575e-07,  2.547152557286205e-09,
 -4.062110968856581e-11,  5.858214645559845e-13, -7.780867872837919e-15,  9.642021564664630e-17, -1.125552584308745e-18,  1.246914022518531e-20, -1.318497952406286e-22,
  2.940645253879609e-03, -1.600343783658469e-04,  5.219920694617835e-06, -1.290633513538171e-07,  2.652462392088415e-09, -4.754359449345638e-11,  7.652969699921640e-13,
 -1.128048115970764e-14,  1.543808114979276e-16, -1.981946028675015e-18,  2.405794367250759e-20, -2.778174064075325e-22,  1.585582527327390e-03, -1.027550109895356e-04,
  3.879056963347310e-06, -1.093143270869860e-07,  2.533268241084018e-09, -5.078678867196542e-11,  9.084235463868929e-13, -1.479923828465364e-14,  2.228229121539488e-16,
 -3.134561472123135e-18,  4.154604884480034e-20, -5.222024553367621e-22,  8.143956503876547e-04, -6.201419958509970e-05,  2.688356355985221e-06, -8.582376636474184e-08,
  2.231277525871344e-09, -4.980840852399148e-11,  9.860042219177048e-13, -1.768719724779198e-14,  2.919548809294594e-16, -4.485559285797676e-18,  6.471276528815319e-20,
 -8.826687485365912e-22,  3.993395315978188e-04, -3.531660425323653e-05,  1.745315807756451e-06, -6.276194403740008e-08,  1.821863035191097e-09, -4.509532306479268e-11,
  9.842641625504819e-13, -1.937396152760558e-14,  3.494700691821701e-16, -5.846203101425188e-18,  9.154033058814073e-20, -1.351192003625966e-21,  1.874096494855695e-04,
 -1.905216310500012e-05,  1.066050594410083e-06, -4.295177420868087e-08,  1.385877243496912e-09, -3.788791446074336e-11,  9.085505239297269e-13, -1.956019447473940e-14,
  3.844041551974286e-16, -6.982022604740202e-18,  1.183353623215709e-19, -1.885370189715536e-21,  8.441106365029908e-05, -9.774218219142502e-06,  6.152992422667148e-07,
 -2.763606368781879e-08,  9.869453482066540e-10, -2.968976345638563e-11,  7.795855828517489e-13, -1.830069103582194e-14,  3.907171106813696e-16, -7.684521028387308e-18,
  1.406170879817906e-19, -2.412350807215753e-21,  3.660346338229271e-05, -4.787814031245085e-06,  3.370675021014412e-07, -1.679604004368171e-08,  6.611897485294679e-10,
 -2.180825750778766e-11,  6.250075748779832e-13, -1.595086281140786e-14,  3.689487483560356e-16, -7.837211347808283e-18,  1.544580474321521e-19, -2.846564073383231e-21,
  1.533453859091178e-05, -2.248709246163758e-06,  1.760525981263082e-07, -9.688086028261251e-09,  4.187483872971864e-10, -1.509118521235400e-11,  4.705829242606929e-13,
 -1.301918461096079e-14,  3.253826112879388e-16, -7.446356655149488e-18,  1.576854666319230e-19, -3.114786599067505e-21,  6.230426516565453e-06, -1.017173497021643e-06,
  8.808775772054694e-08, -5.329641745866900e-09,  2.519726913661997e-10, -9.888493494988304e-12,  3.344735716885827e-13, -1.000313301155568e-14,  2.694253769643141e-16,
 -6.626349682112972e-18,  1.504217098211669e-19, -3.177670804070692e-21,  2.465513623508705e-06, -4.452136874453190e-07,  4.243148486809021e-08, -2.810606789956978e-09,
  1.448030927385171e-10, -6.167605198827817e-12,  2.256078762566549e-13, -7.273528259908264e-15,  2.105774926387716e-16, -5.552313947293899e-18,  1.348013928357574e-19,
 -3.038755059243435e-21,  9.546890088397456e-07, -1.895119285070719e-07,  1.978010151078525e-08, -1.428429416691187e-09,  7.990352846685806e-11, -3.681587289747725e-12,
  1.452015484305664e-13, -5.032334675764303e-15,  1.561964326608285e-16, -4.404488750103381e-18,  1.141014603621468e-19, -2.738617219573417e-21,  3.635686066768721e-07,
 -7.887333538823318e-08,  8.972904357994031e-09, -7.035630056519407e-10,  4.257549390269958e-11, -2.115090618449351e-12,  8.967064561832460e-14, -3.331475452553683e-15,
  1.105682970775222e-16, -3.326129101142066e-18,  9.172464662077739e-20, -2.338757768933378e-21,  1.369207018553904e-07, -3.228011959580294e-08,  3.984140084039463e-09,
 -3.378188412907952e-10,  2.203490555298969e-11, -1.176361033457519e-12,  5.344627446376366e-14, -2.122520544979344e-15,  7.512298662078759e-17, -2.404709426662578e-18,
  7.042249448639133e-20, -1.903112079253923e-21,  5.129522876762831e-08, -1.307048736535370e-08,  1.742222456888251e-09, -1.591023556865984e-10,  1.114512365313818e-11,
 -6.372559357369842e-13,  3.093069372934371e-14, -1.309186764685101e-15,  4.927775289555122e-17, -1.674112644971918e-18,  5.193389231585994e-20, -1.483942898103736e-21,
  1.923725297757751e-08, -5.269720167201214e-09,  7.551645346749644e-10, -7.397321384929011e-11,  5.544364465835728e-12, -3.383673565978432e-13,  1.748918675520139e-14,
 -7.865886834373043e-16,  3.139669090736235e-17, -1.128964777017609e-18,  3.700283797594807e-20, -1.115141442867402e-21,  7.270173082539382e-09, -2.129799254292842e-09,
  3.266362999797040e-10, -3.418005283078767e-11,  2.730697836636271e-12, -1.772492910440873e-13,  9.723676936672724e-15, -4.632475225468623e-16,  1.954980758182038e-17,
 -7.419373011576887e-19,  2.562287076922268e-20, -8.122942758665307e-22,  2.787844843308829e-09, -8.688774868344271e-10,  1.419620983561716e-10, -1.580299029782186e-11,
  1.340523632199645e-12, -9.220924681844187e-14,  5.350427012177051e-15, -2.691252866777803e-16,  1.197077455600734e-17, -4.780559100584902e-19,  1.734605041060423e-20,
 -5.768693964351938e-22,  1.092340038597197e-09, -3.603366366589806e-10,  6.243128951110811e-11, -7.361530947045929e-12,  6.603809925754810e-13, -4.795545437844438e-14,
  2.932634474819866e-15, -1.552096172684128e-16,  7.252714481314033e-18, -3.038241628279395e-19,  1.154758113916539e-20, -4.016897617315155e-22,  4.403890362770111e-10,
 -1.529762941263005e-10,  2.797410256291021e-11, -3.478639127406045e-12,  3.286409235059961e-13, -2.509539769346865e-14,  1.611332466952344e-15, -8.940800369732562e-17,
  4.373930579518665e-18, -1.915647180408139e-19,  7.602208013176819e-21, -2.757517408827944e-22,  1.839078851627135e-10, -6.692825603173068e-11,  1.285572518941359e-11,
 -1.678286373244677e-12,  1.662606104228959e-13, -1.329538482771794e-14,  8.927897374047852e-16, -5.173990161527943e-17,  2.640289797138108e-18, -1.204733987225940e-19,
  4.975048925711635e-21, -1.875554520716726e-22,  8.003114641511577e-11, -3.035849066343363e-11,  6.095266296837066e-12, -8.314617803198607e-13,  8.598588506967532e-14,
 -7.169809299543988e-15,  5.014359194816080e-16, -3.023054992588053e-17,  1.602998403858469e-18, -7.591997731609795e-20,  3.250758118240998e-21, -1.269291631508907e-22,
  3.646685395904090e-11, -1.434588116383641e-11,  2.995615029565078e-12, -4.249240042375305e-13,  4.565944325027182e-14, -3.952089672424029e-15,  2.866226447880861e-16,
 -1.790097256733606e-17,  9.823514095007711e-19, -4.810303106187782e-20,  2.127532198181615e-21, -8.572391176664290e-23,  1.744608252611194e-11, -7.081675081306672e-12,
  1.530070806085536e-12, -2.245634038255975e-13,  2.495098477405220e-14, -2.231328272405944e-15,  1.670527278258553e-16, -1.076091760066671e-17,  6.085512646735892e-19,
 -3.068293755974769e-20,  1.396180561712572e-21, -5.782772985763063e-23,  8.754928572109378e-12, -3.648440187977950e-12,  8.113742250889302e-13, -1.225774006804977e-13,
  1.401224973880218e-14, -1.288388997380967e-15,  9.910405120097121e-17, -6.554309900791677e-18,  3.802792535042344e-19, -1.965731617898055e-20,  9.164154812629473e-22,
 -3.885921027807384e-23,  4.572805585262710e-12, -1.946560049229769e-12,  4.431969961989640e-13, -6.855595541136963e-14,  8.021227345151685e-15, -7.544891257772077e-16,
  5.933668315005801e-17, -4.009881268006485e-18,  2.375896496818405e-19, -1.253491005406710e-20,  5.960997449621537e-22, -2.576860891921697e-23,  2.430496015703808e-12,
 -1.051552199372289e-12,  2.437878639543080e-13, -3.840277029698642e-14,  4.574507960627295e-15, -4.378992976216625e-16,  3.503282323469882e-17, -2.407250063530269e-18,
  1.449646802542445e-19, -7.769815696938092e-21,  3.752122414520411e-22, -1.646333194062567e-23,  1.233979127287277e-12, -5.399095457113940e-13,  1.267534908561748e-13,
 -2.022139440894871e-14,  2.439030304822231e-15, -2.363505390802168e-16,  1.913544120918130e-17, -1.330247646067932e-18,  8.101920979124109e-20, -4.390552375990169e-21,
  2.143081840296735e-22, -9.501528560007711e-24,  4.670062707679533e-13, -2.056104922477231e-13,  4.860998341971506e-14, -7.809890298075130e-15,  9.485892881083090e-16,
 -9.255113169175329e-17,  7.543217621868291e-18, -5.278005984700760e-19,  3.234971456997785e-20, -1.763897378135179e-21,  8.661489448926840e-23, -3.862506158839758e-24,
  7.004491569571046e-02, -2.044720996382604e-04,  6.221419756621510e-07, -1.957232848744062e-09,  6.308013539639408e-12, -2.065971524440890e-14,  6.830255121079336e-17,
 -2.269187241587229e-19,  7.549826000613889e-22, -2.511112678304282e-24,  8.336182870807824e-27, -2.761169144528762e-29,  6.578138215366479e-02, -2.499993381118420e-04,
  1.134495553201410e-06, -5.313555863349408e-09,  2.449864871999392e-11, -1.102686475365956e-13,  4.852555387935727e-16, -2.094360598895451e-18,  8.889674532303474e-21,
 -3.718995147495924e-23,  1.536020052633129e-25, -6.271600551669477e-28,  5.802487163012620e-02, -3.228956790857535e-04,  2.104989473090650e-06, -1.298479950843033e-08,
  7.554841802860253e-11, -4.201617208948387e-13,  2.254798992671088e-15, -1.174882815458421e-17,  5.969919264397438e-20, -2.967871754396160e-22,  1.447201290131993e-24,
 -6.935809809796246e-27,  4.808702412557783e-02, -3.950593875672366e-04,  3.394950954631101e-06, -2.604777703659959e-08,  1.845533031941329e-10, -1.232914608017816e-12,
  7.860611873859042e-15, -4.821532955034544e-17,  2.861802208858708e-19, -1.650903834649431e-21,  9.287798784657837e-24, -5.109543425877407e-26,  3.745611728436311e-02,
 -4.403925238007570e-04,  4.764590866585663e-06, -4.445765289558459e-08,  3.766107880111118e-10, -2.968916818664366e-12,  2.210526640504340e-14, -1.570158215420806e-16,
  1.071706516583073e-18, -7.067131993136210e-21,  4.521320223922173e-23, -2.815610830654032e-25,  2.743726369783335e-02, -4.444064405332283e-04,  5.912831255161658e-06,
 -6.614460976804579e-08,  6.607620220909671e-10, -6.066592923808445e-12,  5.210278557662421e-14, -4.236087653332389e-16,  3.288161392973558e-18, -2.452361796631210e-20,
  1.765994116102763e-22, -1.232641293082279e-24,  1.891432564698441e-02, -4.074468216166639e-04,  6.570940583961263e-06, -8.711198514260630e-08,  1.015008633430604e-09,
 -1.074411767537965e-11,  1.054411388756892e-13, -9.725364522837516e-16,  8.512787261649910e-18, -7.122710073286876e-20,  5.728542409400158e-22, -4.447939047814726e-24,
  1.228154050068076e-02, -3.414162853067136e-04,  6.600016074294262e-06, -1.026682274470238e-07,  1.382843440701484e-09, -1.673902710480602e-11,  1.862944170273570e-13,
 -1.935474445241105e-15,  1.897519483356246e-17, -1.769643470175527e-19,  1.579690878101966e-21, -1.356254638650965e-23,  7.519394751857465e-03, -2.630116203155112e-04,
  6.035097443166608e-06, -1.092079543444166e-07,  1.687505723219819e-09, -2.319992877288167e-11,  2.909636062834344e-13, -3.384856779032502e-15,  3.695978787251650e-17,
 -3.821409076471182e-19,  3.766684528551058e-21, -3.558149536617005e-23,  4.346298105810874e-03, -1.872624998008146e-04,  5.054301789234045e-06, -1.055784591849036e-07,
  1.859335215038113e-09, -2.886137091280160e-11,  4.056876621113503e-13, -5.257786904542005e-15,  6.363555906071102e-17, -7.261139471036121e-19,  7.868442712811754e-21,
 -8.143628993876232e-23,  2.375148487523202e-03, -1.238148616871428e-04,  3.897379740049803e-06, -9.333111124310347e-08,  1.862305354811535e-09, -3.246830267361616e-11,
  5.090772251649381e-13, -7.317713933660545e-15,  9.776052159673488e-17, -1.226177485688823e-18,  1.455240029174667e-20, -1.644142667672899e-22,  1.229199411051980e-03,
 -7.635073869033976e-05,  2.780443925447924e-06, -7.585096084856245e-08,  1.705749540145139e-09, -3.324526356039046e-11,  5.789555017600895e-13, -9.193830508032478e-15,
  1.350704785604564e-16, -1.855685406949924e-18,  2.403928425785677e-20, -2.955275368088770e-22,  6.035965299816358e-04, -4.408810235677320e-05,  1.843546934834720e-06,
 -5.695805980412509e-08,  1.436518164853292e-09, -3.116455993517888e-11,  6.004477205352265e-13, -1.049601238683683e-14,  1.690063388458774e-16, -2.535244492326861e-18,
  3.574021255179246e-20, -4.766973914221659e-22,  2.818469722915012e-04, -2.393214187030672e-05,  1.141011749068253e-06, -3.970787511996576e-08,  1.118029028052132e-09,
 -2.689076273684008e-11,  5.711520349278108e-13, -1.095367785979376e-14,  1.927130378571335e-16, -3.147278588657918e-18,  4.814921013126748e-20, -6.949142133650629e-22,
  1.254583998697649e-04, -1.225920965054874e-05,  6.620507146963697e-07, -2.581894280924134e-08,  8.081139359850882e-10, -2.146812600601323e-11,  5.009707151065163e-13,
 -1.050838318126929e-14,  2.014228656317425e-16, -3.571602494155918e-18,  5.914482446076453e-20, -9.213962985964704e-22,  5.338550241718249e-05, -5.949202033560546e-06,
  3.616896631486913e-07, -1.573045436134588e-08,  5.450880545494705e-10, -1.593730697056950e-11,  4.073004228097901e-13, -9.317137757279423e-15,  1.940420600656257e-16,
 -3.726238761240277e-18,  6.663036765808022e-20, -1.117852490498951e-21,  2.178483600693381e-05, -2.746160669324204e-06,  1.868721617636694e-07, -9.022128803818947e-09,
  3.447762472084170e-10, -1.105688909242913e-11,  3.085212198978463e-13, -7.675021462804257e-15,  1.732221480211023e-16, -3.593669107144566e-18,  6.922826584632970e-20,
 -1.248014216584511e-21,  8.555167852991657e-06, -1.210908062761012e-06,  9.172912311133765e-08, -4.894627930953275e-09,  2.055062010082031e-10, -7.205067553199607e-12,
  2.188543587611550e-13, -5.904697939354212e-15,  1.440580311079543e-16, -3.221107032956192e-18,  6.669952859018452e-20, -1.289303788143914e-21,  3.246092425701519e-06,
 -5.123648103144000e-07,  4.298440952052846e-08, -2.524249228246795e-09,  1.160209779851559e-10, -4.432745843605419e-12,  1.461491640086402e-13, -4.265127165513961e-15,
  1.122056900933704e-16, -2.697793602119104e-18,  5.991642519823898e-20, -1.239268784037670e-21,  1.195247297804753e-06, -2.090432664390541e-07,  1.932691635125956e-08,
 -1.243971535428897e-09,  6.236926007175789e-11, -2.588560314470589e-12,  9.237299113333059e-14, -2.908241520589181e-15,  8.229861640864375e-17, -2.122819546807625e-18,
  5.045725594010842e-20, -1.114363628795082e-21,  4.291693772700916e-07, -8.267009746809904e-08,  8.383183220947608e-09, -5.890381666219641e-10,  3.210243808673503e-11,
 -1.442831070812766e-12,  5.556811626140236e-14, -1.882421931269055e-15,  5.715986966500863e-17, -1.578100258252139e-18,  4.005595786260595e-20, -9.426381538308241e-22,
  1.510760511499128e-07, -3.186834093998489e-08,  3.528205913514449e-09, -2.695644114216821e-10,  1.591399216928265e-11, -7.721166186316947e-13,  3.200136206113843e-14,
 -1.163347283673533e-15,  3.781066589603204e-17, -1.114707198748727e-18,  3.014723412429176e-20, -7.543521923261459e-22,  5.244431593567536e-08, -1.204760321682768e-08,
  1.449673982536811e-09, -1.199647625234188e-10,  7.644976301491220e-12, -3.991433663184241e-13,  1.775095943654457e-14, -6.906094664658287e-16,  2.396408712208745e-17,
 -7.525994016418678e-19,  2.163761628661591e-20, -5.744227136603023e-22,  1.806739854846539e-08, -4.495695575026132e-09,  5.853376432935859e-10, -5.225931587836256e-11,
  3.582279409672083e-12, -2.006126229773381e-13,  9.544629418964424e-15, -3.963006786087985e-16,  1.464308046814155e-17, -4.886607211929832e-19,  1.489972934293792e-20,
 -4.187016938228596e-22,  6.219524896297632e-09, -1.667491478163849e-09,  2.338751773502030e-10, -2.243876582217345e-11,  1.648566006917203e-12, -9.869850943715148e-14,
  5.008145897133940e-15, -2.212773497664377e-16,  8.682241330081465e-18, -3.070758386077944e-19,  9.905117794019352e-21, -2.939343067963017e-22,  2.154999729051383e-09,
 -6.192889475515820e-10,  9.315078603973414e-11, -9.565624306103076e-12,  7.504626851263207e-13, -4.786839751890810e-14,  2.582166792621663e-15, -1.210376854736432e-16,
  5.028657635658072e-18, -1.879802192014520e-19,  6.397753799282728e-21, -1.999787765657278e-22,  7.573422458441267e-10, -2.320745709361634e-10,  3.726760218015054e-11,
 -4.079267814932252e-12,  3.404469939533293e-13, -2.305335321461556e-14,  1.317579316976482e-15, -6.531360769032064e-17,  2.864519851828630e-18, -1.128485736230539e-19,
  4.041119771341626e-21, -1.326956857564753e-22,  2.721012303336210e-10, -8.845239197766412e-11,  1.509474057478638e-11, -1.753710320571812e-12,  1.550795886430805e-13,
 -1.110661423331998e-14,  6.701841918758806e-16, -3.501450171073369e-17,  1.615897771931799e-18, -6.688070321185470e-20,  2.512503880466047e-21, -8.642029689669627e-23,
  1.007478840364443e-10, -3.456295866344991e-11,  6.238686081005700e-12, -7.659471650769078e-13,  7.147063487414170e-14, -5.392538317365310e-15,  3.422574804866529e-16,
 -1.877944175812423e-17,  9.088231840522791e-19, -3.938941628659430e-20,  1.547420065916414e-21, -5.558280108803924e-23,  3.874403815810881e-11, -1.395472581151236e-11,
  2.651351389018569e-12, -3.424237653491527e-13,  3.356935869175304e-14, -2.657378038222359e-15,  1.767031871763728e-16, -1.014388113024002e-17,  5.129192981226878e-19,
 -2.319729886826672e-20,  9.497661652870734e-22, -3.550981973586193e-23,  1.558801350356757e-11, -5.863884685797703e-12,  1.166890057752775e-12, -1.577805122268744e-13,
  1.617744955446032e-14, -1.337749439071346e-15,  9.280723495653571e-17, -5.551684873342715e-18,  2.921688541099337e-19, -1.373676907315470e-20,  5.840395847018115e-22,
 -2.264915705861470e-23,  6.601675887995669e-12, -2.580208531764238e-12,  5.350150060609908e-13, -7.536438640201072e-14,  8.043265464253409e-15, -6.916095199033291e-16,
  4.983857866214402e-17, -3.093432654651496e-18,  1.687428979695504e-19, -8.215018184266959e-21,  3.613012726774430e-22, -1.447888032763045e-23,  2.955045058448295e-12,
 -1.193686826208298e-12,  2.565479816954774e-13, -3.745487634761522e-14,  4.140185874941116e-15, -3.684007749058762e-16,  2.744737735262712e-17, -1.759754510059046e-18,
  9.906481132120721e-20, -4.972797018911275e-21,  2.253133413078711e-22, -9.293629201564171e-24,  1.398612708209124e-12, -5.808486101658398e-13,  1.286894107580463e-13,
 -1.936867271423487e-14,  2.205964129435687e-15, -2.021069587493258e-16,  1.549225572898307e-17, -1.021138932443697e-18,  5.905273581242445e-20, -3.042880393413192e-21,
  1.414225683155216e-22, -5.979023695740009e-24,  6.953851046609720e-13, -2.953516417815552e-13,  6.708022641945934e-14, -1.035064130386041e-14,  1.208112424168990e-15,
 -1.133680581086729e-16,  8.895308999804105e-18, -5.997891314349991e-19,  3.546115115697481e-20, -1.866951495286205e-21,  8.860224034248608e-23, -3.822606893928520e-24,
  3.555059994048775e-13, -1.536089416395059e-13,  3.556043656387368e-14, -5.593504220890103e-15,  6.653386349262910e-16, -6.360104495152303e-17,  5.081277293779648e-18,
 -3.486929587875690e-19,  2.097127025738467e-20, -1.122612435515481e-21,  5.414624466453246e-23, -2.373000851730705e-24,  1.755854134219752e-13, -7.677499485619453e-14,
  1.801120209101312e-14, -2.871276855506120e-15,  3.460720780633948e-16, -3.351180123695176e-17,  2.711306843703501e-18, -1.883558685130524e-19,  1.146432751183779e-20,
 -6.208704915521495e-22,  3.028649937028388e-23, -1.341961441275106e-24,  6.542565854518252e-14, -2.879708451376668e-14,  6.805976044531496e-15, -1.093123504258980e-15,
  1.327280329119064e-16, -1.294577764075805e-17,  1.054793014028264e-18, -7.378143135796366e-20,  4.520814516259544e-21, -2.464285587063782e-22,  1.209718197045157e-23,
 -5.393087675770610e-25,  6.923683520066272e-02, -1.995872260646573e-04,  5.992473980882793e-07, -1.859523232219866e-09,  5.910710958225658e-12, -1.909404997583456e-14,
  6.227391442632613e-17, -2.041436280413056e-19,  6.703031297471771e-22, -2.200729412432095e-24,  7.212271226822275e-27, -2.358808276561715e-29,  6.479914209138644e-02,
 -2.411719243291718e-04,  1.073013972410290e-06, -4.938607069636032e-09,  2.240514811959430e-11, -9.929527069285912e-14,  4.304028960339684e-16, -1.830178526609251e-18,
  7.655091895091172e-21, -3.156377516132374e-23,  1.285064535544163e-25, -5.172896064715473e-28,  5.676601009258285e-02, -3.066591045908382e-04,  1.956156448126015e-06,
 -1.184041852510631e-08,  6.766076420046675e-11, -3.697877662254311e-13,  1.951047158217554e-15, -9.998801382661085e-18,  4.998730148844623e-20, -2.445672106230581e-22,
  1.173955520058460e-24, -5.539681660132531e-27,  4.655919463843285e-02, -3.691016843701792e-04,  3.099313016037130e-06, -2.328238135604183e-08,  1.616773296144739e-10,
 -1.059477902995343e-12,  6.630343522966057e-15, -3.994095651003994e-17,  2.329266135340036e-19, -1.320719908247029e-21,  7.305545947583081e-24, -3.952736717811187e-26,
  3.576754075742269e-02, -4.043116586985937e-04,  4.265383632243210e-06, -3.887950967334606e-08,  3.222006777652163e-10, -2.487495626476797e-12,  1.815305557640515e-14,
 -1.264656945182599e-16,  8.470645211194970e-19, -5.483973991048740e-21,  3.445898859568391e-23, -2.108376938404997e-25,  2.574945835322705e-02, -4.001078034847676e-04,
  5.178734697071846e-06, -5.647895907932121e-08,  5.510322443972395e-10, -4.947338136396942e-12,  4.159125324386378e-14, -3.312492711241072e-16,  2.520396437218705e-18,
 -1.843576127490037e-20,  1.302657641330770e-22, -8.925289786373274e-25,  1.738342220287451e-02, -3.588000714626391e-04,  5.616367829093326e-06, -7.246214419204097e-08,
  8.233760201623966e-10, -8.511740519806377e-12,  8.166780993706711e-14, -7.370879140480575e-16,  6.317891087871185e-18, -5.179643457850500e-20,  4.083991361780956e-22,
 -3.110217587180476e-24,  1.101417218049781e-02, -2.931920499628907e-04,  5.490441934773327e-06, -8.299531140330677e-08,  1.088715031158677e-09, -1.285514398233350e-11,
  1.397249135029476e-13, -1.419083114385842e-15,  1.361135030406132e-17, -1.242773447636088e-19,  1.086743901361772e-21, -9.144789390243070e-24,  6.556214455790179e-03,
 -2.195467706223255e-04,  4.872437023291933e-06, -8.557040736868117e-08,  1.286301877019652e-09, -1.723221048087410e-11,  2.108682930003931e-13, -2.395986930145064e-15,
  2.557543722582942e-17, -2.586958205798586e-19,  2.496194635758760e-21, -2.309651318530331e-23,  3.670753164196728e-03, -1.514307773505042e-04,  3.948394145327388e-06,
 -7.996410193408882e-08,  1.368642285822407e-09, -2.068352067003498e-11,  2.834442380231481e-13, -3.585326021805222e-15,  4.239148269968817e-17, -4.729140341692063e-19,
  5.013794498869374e-21, -5.080012804487540e-23,  1.935809050850037e-03, -9.665453070319394e-05,  2.936732877995727e-06, -6.812910754140683e-08,  1.320188701399494e-09,
 -2.239279464676766e-11,  3.420677033114399e-13, -4.796088457990478e-15,  6.255795575341656e-17, -7.667334778639279e-19,  8.898506080942637e-21, -9.837818553489333e-23,
  9.631129586493340e-04, -5.733009883111452e-05,  2.014268385798352e-06, -5.320272055815691e-08,  1.161226519779611e-09, -2.200671591446440e-11,  3.731858776262583e-13,
 -5.777643089906747e-15,  8.283783589004363e-17, -1.111647032502411e-18,  1.407707131995934e-20, -1.692842681967901e-22,  4.529070803444124e-04, -3.172571885116936e-05,
  1.279674912344244e-06, -3.826703272245060e-08,  9.363628963841106e-10, -1.974474466638458e-11,  3.703059046124083e-13, -6.308617986434658e-15,  9.910337012342123e-17,
 -1.451685479668119e-18,  1.999965497239119e-20, -2.608747636128041e-22,  2.017377480098629e-04, -1.644242823209284e-05,  7.562552471648577e-07, -2.547011341810420e-08,
  6.956485112485735e-10, -1.625944589238991e-11,  3.360909652818772e-13, -6.280600017094880e-15,  1.077819116330730e-16, -1.718553271447798e-18,  2.568997508759669e-20,
 -3.625538649621520e-22,  8.532422512679524e-05, -8.011141808431764e-06,  4.175046521523764e-07, -1.575906572057023e-08,  4.784651035820990e-10, -1.235155272920164e-11,
  2.804907114365794e-13, -5.732615363554676e-15,  1.071755887231271e-16, -1.855340870874911e-18,  3.001991839786959e-20, -4.572962731364296e-22,  3.436145473673091e-05,
 -3.683650749939835e-06,  2.162393769745082e-07, -9.105394425591044e-09,  3.061230596335473e-10, -8.698690868289480e-12,  2.163607889763568e-13, -4.822766835907765e-15,
  9.797530901038049e-17, -1.836969191004812e-18,  3.209772793887283e-20, -5.266076015973364e-22,  1.321760129011507e-05, -1.604980879374976e-06,  1.055352692561245e-07,
 -4.935658883967135e-09,  1.830684077464006e-10, -5.707611073321588e-12,  1.550414295516717e-13, -3.759217841162437e-15,  8.278026926437540e-17, -1.677130898531030e-18,
  3.157743603381800e-20, -5.568109362971001e-22,  4.873720908242380e-06, -6.654623857343229e-07,  4.875757993559071e-08, -2.522005353535157e-09,  1.028346697286004e-10,
 -3.506787097117378e-12,  1.037421834503888e-13, -2.729134013913817e-15,  6.498775665900196e-17, -1.419577653671454e-18,  2.874030121399243e-20, -5.435838280198831e-22,
  1.729554666124422e-06, -2.637708769699788e-07,  2.142756624401957e-08, -1.220884352876128e-09,  5.453733658226925e-11, -2.028024297699049e-12,  6.516043714995299e-14,
 -1.855178234738334e-15,  4.766070674623210e-17, -1.120028715903417e-18,  2.433259316902246e-20, -4.926669774413054e-22,  5.933662188825005e-07, -1.004446383013914e-07,
  9.003950609819425e-09, -5.628953664512279e-10,  2.745402399982920e-11, -1.109932247388838e-12,  3.862775476669813e-14, -1.187290859517089e-15,  3.283221504434035e-17,
 -8.282691585834681e-19,  1.926947248526988e-20, -4.168472134714094e-22,  1.977890438995606e-07, -3.694484114679500e-08,  3.637721819680188e-09, -2.485711127615676e-10,
  1.319289778912526e-11, -5.781655018949857e-13,  2.173586665173056e-14, -7.194708999566628e-16,  2.136590548263466e-17, -5.773675404600745e-19,  1.435478826570151e-20,
 -3.311255414952433e-22,  6.441542786075667e-08, -1.320210611978367e-08,  1.421520776107476e-09, -1.057689818223983e-10,  6.088596513265713e-12, -2.883743996514078e-13,
  1.167945987049043e-14, -4.152854206627757e-16,  1.321298858333873e-17, -3.816212021153107e-19,  1.011842831984568e-20, -2.483862029718854e-22,  2.062320509834981e-08,
 -4.612665223086249e-09,  5.407514164226952e-10, -4.364681293641857e-11,  2.716009384514992e-12, -1.386076789628973e-13,  6.031030053242567e-15, -2.297662711601767e-16,
  7.813410254237555e-18, -2.406492809906526e-19,  6.789887098382245e-21, -1.770094681023618e-22,  6.534782198426782e-09, -1.586609061096782e-09,  2.016370733268938e-10,
 -1.758871260414424e-11,  1.179130590911853e-12, -6.463882646858378e-14,  3.012988773997286e-15, -1.226614711211511e-16,  4.447094585396736e-18, -1.457150598445999e-19,
  4.365163594752136e-21, -1.205909535267723e-22,  2.064448176871562e-09, -5.412821726539314e-10,  7.425014563780861e-11, -6.972792371770296e-12,  5.018545368375923e-13,
 -2.945783680385716e-14,  1.466623172947111e-15, -6.362670210412023e-17,  2.452919195767443e-18, -8.529321345738955e-20,  2.706430255539747e-21, -7.904967690941051e-23,
  6.554081785712561e-10, -1.846158177357999e-10,  2.721549418680023e-11, -2.740760732484896e-12,  2.110233829540351e-13, -1.321918150133204e-14,  7.007916779630328e-16,
 -3.230361590205496e-17,  1.320589890364024e-18, -4.860228377756975e-20,  1.629405111727087e-21, -5.019571300994669e-23,  2.108693685351125e-10, -6.348447562755305e-11,
  1.001279406228139e-11, -1.076969357394503e-12,  8.837579325785944e-14, -5.887735560561217e-15,  3.312675248856431e-16, -1.617475885895583e-17,  6.991146170163387e-19,
 -2.715639768628094e-20,  9.593170391240875e-22, -3.108881977280438e-23,  6.936534327237311e-11, -2.220469168752658e-11,  3.729847344626663e-12, -4.266913859011879e-13,
  3.717237679404943e-14, -2.624121516125303e-15,  1.561544265067630e-16, -8.049661721339410e-18,  3.667027775757936e-19, -1.498864351991729e-20,  5.563011321656892e-22,
 -1.891214310814543e-23,  2.354140055388316e-11, -7.971074540329641e-12,  1.419313758252420e-12, -1.719406547545664e-13,  1.583721510316380e-14, -1.180060866377906e-15,
  7.399640610149351e-17, -4.012978884313405e-18,  1.920269585364440e-19, -8.232369753566227e-21,  3.200162275663692e-22, -1.137835548263338e-23,  8.317656205541289e-12,
 -2.963327947693434e-12,  5.565971588234789e-13, -7.107729397146606e-14,  6.891958252500651e-15, -5.398072010971151e-16,  3.552786118917977e-17, -2.019378482907126e-18,
  1.011335761113624e-19, -4.531627221347313e-21,  1.838803803726016e-22, -6.815574054478613e-24,  3.085882020719754e-12, -1.150638937687979e-12,  2.268319772291938e-13,
 -3.038765798479229e-14,  3.087662952932988e-15, -2.530996050877044e-16,  1.741078624140304e-17, -1.033003946394709e-18,  5.393473878150546e-20, -2.516454629119182e-21,
  1.061999593516355e-22, -4.089043583050756e-24,  1.211291931166804e-12, -4.701659624801038e-13,  9.676966088918242e-14, -1.353142586926816e-14,  1.433812350341957e-15,
 -1.224321726296518e-16,  8.763347258836280e-18, -5.403920491331388e-19,  2.929201866252190e-20, -1.417347313842247e-21,  6.196782960634824e-23, -2.469155310401173e-24,
  5.058535589465685e-13, -2.032861891623356e-13,  4.344608093651536e-14, -6.307647754305005e-15,  6.934434797540977e-16, -6.137776905712927e-17,  4.549472336013104e-18,
 -2.902364652350577e-19,  1.626026406283669e-20, -8.124257245110386e-22,  3.664449502097234e-23, -1.504917145166387e-24,  2.251812367550714e-13, -9.317803117676720e-14,
  2.056164397807866e-14, -3.082356585412320e-15,  3.496921508810842e-16, -3.191679028966971e-17,  2.437541270337795e-18, -1.600923720981797e-19,  9.226193990777761e-21,
 -4.738175582284288e-22,  2.194998052976286e-23, -9.250864015139684e-25,  1.063071913767598e-13, -4.504462703614493e-14,  1.020367254356378e-14, -1.570314389905681e-15,
  1.828125884399437e-16, -1.711188507335676e-17,  1.339392181571856e-18, -9.009826552816139e-20,  5.314628777736612e-21, -2.791809671039271e-22,  1.322085808446062e-23,
 -5.692037746424376e-25,  5.216463098863928e-14, -2.250833662547234e-14,  5.202642534232617e-15, -8.170868367898359e-16,  9.704337536016166e-17, -9.262799706562352e-18,
  7.389638720693036e-19, -5.063881512784411e-20,  3.041394538608967e-21, -1.625933570900561e-22,  7.832186281794564e-24, -3.428246912145451e-25,  2.502461152715013e-14,
 -1.093453606256160e-14,  2.563238383469784e-15, -4.083046938339563e-16,  4.917490091684018e-17, -4.758272338698969e-18,  3.846914788466503e-19, -2.670566844958791e-20,
  1.624318931961408e-21, -8.790833726375034e-23,  4.285407932746206e-24, -1.897603582255907e-25,  9.172297232302035e-15, -4.035998840010743e-15,  9.535613396636538e-16,
 -1.531019742883911e-16,  1.858353996187834e-17, -1.811966352268984e-18,  1.475869013615381e-19, -1.032021590985161e-20,  6.321529062958874e-22, -3.444790656509517e-23,
  1.690537985629531e-24, -7.534423646802068e-26,  6.844793516310940e-02, -1.948809247865631e-04,  5.774882033184444e-07, -1.767927600458433e-09,  5.543324923492872e-12,
 -1.766571573601921e-14,  5.684666381257463e-17, -1.839078362148339e-19,  5.960291381572074e-22, -1.931954441936771e-24,  6.251209880801591e-27, -2.019066746436382e-29,
  6.385125569257033e-02, -2.328189188559062e-04,  1.015837818500901e-06, -4.595467636053336e-09,  2.051852728454260e-11, -8.955387590035932e-14,  3.824233787495249e-16,
 -1.602447088203357e-18,  6.606089653609020e-21, -2.685106355206957e-23,  1.077803674914206e-25, -4.278113416231584e-28,  5.556979756652104e-02, -2.915603353750339e-04,
  1.820330788003935e-06, -1.081456021271128e-08,  6.071148369611922e-11, -3.261493002892348e-13,  1.692213389145443e-15, -8.531471382724287e-18,  4.197254316136849e-20,
 -2.021411144146533e-22,  9.553537662298510e-25, -4.439629769439473e-27,  4.513066747765484e-02, -3.453823143755803e-04,  2.834773210907545e-06, -2.085678020684433e-08,
  1.419926414971058e-10, -9.129695543130538e-13,  5.609583357759799e-15, -3.319487334706944e-17,  1.902470824572118e-19, -1.060512124687577e-21,  5.769019012409723e-24,
 -3.070532863356557e-26,  3.421570434482664e-02, -3.719708004825843e-04,  3.828192550736717e-06, -3.409977763788000e-08,  2.765357634706065e-10, -2.091425119073731e-12,
  1.496361829446651e-14, -1.022695097522713e-16,  6.723686489716561e-19, -4.274642847922785e-21,  2.638701277796384e-23, -1.586606231022241e-25,  2.422779660100161e-02,
 -3.612462177828634e-04,  4.550788483669212e-06, -4.840277931782915e-08,  4.613607330260753e-10, -4.051913166162704e-12,  3.335238534134808e-14, -2.602819976057201e-16,
  1.941751187175103e-18, -1.393322228207288e-20,  9.662422546877800e-23, -6.500093102101829e-25,  1.603287662917692e-02, -3.171356326713490e-04,  4.820575183094961e-06,
 -6.055013859751853e-08,  6.711809162996355e-10, -6.778145648489246e-12,  6.360045941246068e-14, -5.618467589034212e-16,  4.717027679156399e-18, -3.790146519254825e-20,
  2.930407935956276e-22, -2.189385507773940e-24,  9.923337126238855e-03, -2.529745786634503e-04,  4.591085752510930e-06, -6.746316697035075e-08,  8.621655094955730e-10,
 -9.933191742836129e-12,  1.054714288413123e-13, -1.047442377487970e-15,  9.831664992885840e-18, -8.790483452395397e-20,  7.531750715819958e-22, -6.213188515576686e-24,
  5.749944541210679e-03, -1.843492932124697e-04,  3.958536017159631e-06, -6.749300852918263e-08,  9.872757561284040e-10, -1.289190475781157e-11,  1.539650707916553e-13,
 -1.709137531059135e-15,  1.783895666935199e-17, -1.765660893995016e-19,  1.668184979309490e-21, -1.512186847887608e-23,  3.122614029091595e-03, -1.233388269075725e-04,
  3.107673689935503e-06, -6.103714054964981e-08,  1.015597139762381e-09, -1.494668909251254e-11,  1.997396301033465e-13, -2.466477683340240e-15,  2.849555210060445e-17,
 -3.108646965460128e-19,  3.225103615916509e-21, -3.199591127428509e-23,  1.591466311791669e-03, -7.610312378330301e-05,  2.232471726437895e-06, -5.018477224424787e-08,
  9.446206964047875e-10, -1.559168898358747e-11,  2.320983653087088e-13, -3.174837107053978e-15,  4.043994372405477e-17, -4.844251380974684e-19,  5.498812556852045e-21,
 -5.949791900915134e-23,  7.623829341922391e-04, -4.348437001864082e-05,  1.474227113072138e-06, -3.770758855333132e-08,  7.989573458393019e-10, -1.472542639238344e-11,
  2.432048285653762e-13, -3.671542185474625e-15,  5.138233371504972e-17, -6.736215109296083e-19,  8.339803998399994e-21, -9.811849226882115e-23,  3.438943211100376e-04,
 -2.309759517504553e-05,  8.987441709630448e-07, -2.601568571739507e-08,  6.176990534229924e-10, -1.266201894929288e-11,  2.311894250925098e-13, -3.839064506184422e-15,
  5.884537073293388e-17, -8.418181829511797e-19,  1.133529786286667e-20, -1.446157470772637e-22,  1.463701914801612e-04, -1.144787301323242e-05,  5.079365977208047e-07,
 -1.655643355934342e-08,  4.386722066072794e-10, -9.964583410714529e-12,  2.004712187280674e-13, -3.650663806110930e-15,  6.111513682794569e-17, -9.514721709021523e-19,
  1.389885048036300e-20, -1.918173536475583e-22,  5.892371520906954e-05, -5.314040425611971e-06,  2.672273749538587e-07, -9.762430815046218e-09,  2.875185644414945e-10,
 -7.212698585705709e-12,  1.594000871417328e-13, -3.174320100012908e-15,  5.788708758654032e-17, -9.783640989887458e-19,  1.546803780746603e-20, -2.304078914175783e-22,
  2.249684985313375e-05, -2.319122727258273e-06,  1.314235757637532e-07, -5.357324088448283e-09,  1.747384471740252e-10, -4.825455582452543e-12,  1.168090798684919e-13,
 -2.537096858598537e-15,  5.027583210871594e-17, -9.203453795777269e-19,  1.571413329334803e-20, -2.521156586959005e-22,  8.171453587147231e-06, -9.553358502248614e-07,
  6.068357799427594e-08, -2.748647926920860e-09,  9.893878375636047e-11, -2.998509791816059e-12,  7.928687026848474e-14, -1.873582659664764e-15,  4.025113113344581e-17,
 -7.963362066002439e-19,  1.465363054821629e-20, -2.527237273655275e-22,  2.833749236395551e-06, -3.730520900773228e-07,  2.642738050394257e-08, -1.324745410631612e-09,
  5.244703843945147e-11, -1.739280050285562e-12,  5.010449659201541e-14, -1.285028601656804e-15,  2.986284485223822e-17, -6.371875403877429e-19,  1.261145771940526e-20,
 -2.333653208990069e-22,  9.420049220769113e-07, -1.387257649504102e-07,  1.090756472454314e-08, -6.027809698813852e-10,  2.616185288070523e-11, -9.466337218332219e-13,
  2.963353367943180e-14, -8.229305606162762e-16,  2.064185231054292e-17, -4.740410311827915e-19,  1.007221304359438e-20, -1.996024863328615e-22,  3.015417370031677e-07,
 -4.937288381899145e-08,  4.288982269197560e-09, -2.603235097194857e-10,  1.234676636214149e-11, -4.860800443861067e-13,  1.649307811572973e-14, -4.947848046426455e-16,
  1.336697355590504e-17, -3.297266937725059e-19,  7.506616581447993e-21, -1.590241295233339e-22,  9.342559686943059e-08, -1.690978608482945e-08,  1.615773241411432e-09,
 -1.073190359295810e-10,  5.544665010114096e-12, -2.368397697898606e-13,  8.688427694352256e-15, -2.809188432810489e-16,  8.156244252783829e-18, -2.156670644810773e-19,
  5.250747142137126e-21, -1.186918491100426e-22,  2.817730229280911e-08, -5.606761529709692e-09,  5.867655884334468e-10, -4.249408545522554e-11,  2.384059757244094e-12,
 -1.101790568161980e-13,  4.358803772228347e-15, -1.515333115849177e-16,  4.717976331722687e-18, -1.334517650459059e-19,  3.467831703605928e-21, -8.348823158580455e-23,
  8.325806087012693e-09, -1.811637454236834e-09,  2.067759725050605e-10, -1.626921058798653e-11,  9.880206284403429e-13, -4.926165277414844e-14,  2.096156115436715e-15,
 -7.816537487958158e-17,  2.603858526433953e-18, -7.862017956250314e-20,  2.176126096711480e-21, -5.568985303032482e-23,  2.427315103504589e-09, -5.745789504370578e-10,
  7.122512741452915e-11, -6.066328385377641e-12,  3.974952016666552e-13, -2.131871545046323e-14,  9.730803599133647e-16, -3.882377541570194e-17,  1.380483515269709e-18,
 -4.439425607439224e-20,  1.306083333553469e-21, -3.545710251471985e-23,  7.036992906191422e-10, -1.802874065926213e-10,  2.416992829422429e-11, -2.220190426333222e-12,
  1.564436339573113e-13, -8.998095300171186e-15,  4.393249638394165e-16, -1.870454258028892e-17,  7.081589702458806e-19, -2.419805157231627e-20,  7.549896574168692e-22,
 -2.169575112534592e-23,  2.045984241342837e-10, -5.644436762080079e-11,  8.148978069053240e-12, -8.042510445611755e-13,  6.073240246566117e-14, -3.734147842599039e-15,
  1.944386192254838e-16, -8.809296794774860e-18,  3.541811962129756e-19, -1.282729445306435e-20,  4.234146149513456e-22, -1.284973525458536e-23,  6.020755227566319e-11,
 -1.779453102578080e-11,  2.754509170092211e-12, -2.909354720311486e-13,  2.345927961360638e-14, -1.536743022611811e-15,  8.506971373984562e-17, -4.089155934297028e-18,
  1.740946752082926e-19, -6.664655269488001e-21,  2.321400254800187e-22, -7.421393511340481e-24,  1.810747465982620e-11, -5.703822343213502e-12,  9.424124932750322e-13,
 -1.060890388073703e-13,  9.099525528143088e-15, -6.327985121332261e-16,  3.711531535561655e-17, -1.886762414669253e-18,  8.480201910905357e-20, -3.421424272457329e-21,
  1.253997044804401e-22, -4.211701884756520e-24,  5.622398989927194e-12, -1.877696305371881e-12,  3.295979337232805e-13, -3.937417793371367e-14,  3.577908988018934e-15,
 -2.631320543905793e-16,  1.629284934532895e-17, -8.728930877640559e-19,  4.128060456461964e-20, -1.749731119459112e-21,  6.727370157221070e-23, -2.366706666859721e-24,
  1.820958718417717e-12, -6.413326460850786e-13,  1.190158364685086e-13, -1.501909003384009e-14,  1.439643947720697e-15, -1.115102842528647e-16,  7.260607026011330e-18,
 -4.084211698423867e-19,  2.025000804990409e-20, -8.986057400401229e-22,  3.612224205481772e-23, -1.326803740658212e-24,  6.213450612873598e-13, -2.295286910110839e-13,
  4.480227919235597e-14, -5.943573873409495e-15,  5.982056714633172e-16, -4.858612626264422e-17,  3.312615287712962e-18, -1.948566835009873e-19,  1.008944088514292e-20,
 -4.669735870918970e-22,  1.955449763244794e-23, -7.472737700989251e-25,  2.254073706209070e-13, -8.685428720893679e-14,  1.773658499408564e-14, -2.460920802148754e-15,
  2.587945273334575e-16, -2.193645284607065e-17,  1.559017724406913e-18, -9.547748672491666e-20,  5.141031328359970e-21, -2.471613524763976e-22,  1.073901880472209e-23,
 -4.253377296573644e-25,  8.756427554580954e-14, -3.499662103811044e-14,  7.435086620396935e-15, -1.073089327806673e-15,  1.172931753160615e-16, -1.032377734390802e-17,
  7.610796146444238e-19, -4.829897048324820e-20,  2.692178608396274e-21, -1.338509650044688e-22,  6.008648051663526e-24, -2.456302093303449e-25,  3.655548067869297e-14,
 -1.506772081196996e-14,  3.310911747174765e-15, -4.942353064115290e-16,  5.583901957861060e-17, -5.076005243128307e-18,  3.861522183491923e-19, -2.526584283583756e-20,
  1.450755525698726e-21, -7.424064456379279e-23,  3.427460120391107e-24, -1.439723332544656e-25,  1.634306130919975e-14, -6.907368581790665e-15,  1.560312757082018e-15,
 -2.394567678111791e-16,  2.780072658101817e-17, -2.595308144731742e-18,  2.026159222191921e-19, -1.359536958471944e-20,  7.999997717526228e-22, -4.192545630046202e-23,
  1.980881143073884e-24, -8.509550303030425e-26,  7.680101308684498e-15, -3.308972048922545e-15,  7.635918102320271e-16, -1.197266245612684e-16,  1.419666672376033e-17,
 -1.352938578419591e-18,  1.077688327434261e-19, -7.374063187635488e-21,  4.422506022111200e-22, -2.360964271477143e-23,  1.135739281959989e-24, -4.964732835694168e-26,
  3.572603793900757e-15, -1.559917799917967e-15,  3.653729762731394e-16, -5.815341330269524e-17,  6.998143624009513e-18, -6.766198461054600e-19,  5.466036097293925e-20,
 -3.791722395170902e-21,  2.304550242469262e-22, -1.246336268532641e-23,  6.071498982678875e-25, -2.686685027368179e-26,  1.286844522260129e-15, -5.660642961892853e-16,
  1.336942373996133e-16, -2.145812514742825e-17,  2.603678529425592e-18, -2.537809989607045e-19,  2.066376262035040e-20, -1.444460648342834e-21,  8.844986831907384e-23,
 -4.818354834160267e-24,  2.363875012915866e-25, -1.053213288864837e-26,  6.767751900654954e-02, -1.903443982792789e-04,  5.567938073612905e-07, -1.681988500984435e-09,
  5.203247577148535e-12, -1.636109617730513e-14,  5.195414398046339e-17, -1.659011344895020e-19,  5.307736316808221e-22, -1.698792921195327e-24,  5.427792986045218e-27,
 -1.731606686516279e-29,  6.293589187034181e-02, -2.249073506710401e-04,  9.626044546131597e-07, -4.281015976242878e-09,  1.881571679733220e-11, -8.089111372349483e-14,
  3.403747962420093e-16, -1.405721813764264e-18,  5.712724286840710e-21, -2.289374119357746e-23,  9.061762448859185e-26, -3.547350249298090e-28,  5.443188228823985e-02,
 -2.775007562405847e-04,  1.696176041727150e-06, -9.893232287998221e-09,  5.457603630682760e-11, -2.882574501086410e-13,  1.471092353189650e-15, -7.297773539527598e-18,
  3.533873304436174e-20, -1.675630046220002e-22,  7.798812291095497e-25, -3.569792285669909e-27,  4.379296222982522e-02, -3.236679738492719e-04,  2.597543442357201e-06,
 -1.872396225000998e-08,  1.250076756790431e-10, -7.888388453216048e-13,  4.759920966121311e-15, -2.767579801795110e-17,  1.559162788502395e-19, -8.546525924027936e-22,
  4.573111655759023e-24, -2.394853329228051e-26,  3.278658279312722e-02, -3.429098885321786e-04,  3.444222959349510e-06, -2.999125249934453e-08,  2.380785695412750e-10,
 -1.764364783079977e-12,  1.237953576410492e-14, -8.302510578205009e-17,  5.359106007277979e-19, -3.346556336762551e-21,  2.029869313333227e-23, -1.199701611218420e-25,
  2.285211511839257e-02, -3.270436413567529e-04,  4.011705901204911e-06, -4.162817943183780e-08,  3.877711361521331e-10, -3.332327424183618e-12,  2.686399835020992e-14,
 -2.054780987195905e-16,  1.503344097579417e-18, -1.058486531721878e-20,  7.205831620993630e-23, -4.760521723659373e-25,  1.483710628874168e-02, -2.813046659708822e-04,
  4.154188050366861e-06, -5.081786953894042e-08,  5.496909271563018e-10, -5.424642664135890e-12,  4.979195585308779e-14, -4.306466654670565e-16,  3.542244658932151e-18,
 -2.790166683018575e-20,  2.115870533836434e-22, -1.551197698569468e-24,  8.980081216549675e-03, -2.192638675695829e-04,  3.858159458393725e-06, -5.512966230323153e-08,
  6.866112606873447e-10, -7.720995480636078e-12,  8.011043876313210e-14, -7.781433693654323e-16,  7.149375004281770e-18, -6.261112210225812e-20,  5.257517910902931e-22,
 -4.252706444793212e-24,  5.071109304439435e-03, -1.556704980975012e-04,  3.235498258863911e-06, -5.357371213726088e-08,  7.628229838297295e-10, -9.711950744899896e-12,
  1.132302900538845e-13, -1.228312346642419e-15,  1.253889036700020e-17, -1.214695358382688e-19,  1.123948618585672e-21, -9.983688609111733e-24,  2.674704711888426e-03,
 -1.011521139669927e-04,  2.463644246424695e-06, -4.694034735090333e-08,  7.594985774894654e-10, -1.088814872239607e-11,  1.419246036484615e-13, -1.711296073605564e-15,
  1.932289921335344e-17, -2.061815708621644e-19,  2.093621269756500e-21, -2.034161276452982e-23,  1.319293116113214e-03, -6.041715528444904e-05,  1.711551242391488e-06,
 -3.729064106805390e-08,  6.819825012310091e-10, -1.095655665713026e-11,  1.589736822066380e-13, -2.121979634786381e-15,  2.640048080035770e-17, -3.091474715052189e-19,
  3.432866677653540e-21, -3.635938117369067e-23,  6.094470000249551e-04, -3.330368407102145e-05,  1.089656430537418e-06, -2.699507641213298e-08,  5.553638228445378e-10,
 -9.956648772370201e-12,  1.601896251558360e-13, -2.358525863457433e-15,  3.222320300423107e-17, -4.127686136944521e-19,  4.997000992276572e-21, -5.752545756723240e-23,
  2.641207399425801e-04, -1.700583527089559e-05,  6.383832920522428e-07, -1.789000270427069e-08,  4.122284883502781e-10, -8.215770025976883e-12,  1.460609149470671e-13,
 -2.364494210931570e-15,  3.536863698417535e-17, -4.942013970499073e-19,  6.504864012157959e-21, -8.117942755230949e-23,  1.075978238824255e-04, -8.073375675156951e-06,
  3.455558880014597e-07, -1.090174620462761e-08,  2.802344988679900e-10, -6.187091185574050e-12,  1.211617237268483e-13, -2.150328440879402e-15,  3.512018775848920e-17,
 -5.339191849446809e-19,  7.622188578817846e-21, -1.028787995247241e-22,  4.129873447620521e-05, -3.576361985722630e-06,  1.735185756281569e-07, -6.135139916675884e-09,
  1.752790500023007e-10, -4.273068044908281e-12,  9.190634515936726e-14, -1.783438505282231e-15,  3.172487625357994e-17, -5.235186222048052e-19,  8.087926935469006e-21,
 -1.178130338657358e-22,  1.497452360737213e-05, -1.483809777847188e-06,  8.116028002117895e-08, -3.202498583013214e-09,  1.013332451723273e-10, -2.719465120104085e-12,
  6.406651117041317e-14, -1.355917643782950e-15,  2.620946867893056e-17, -4.684440605360043e-19,  7.815670289607932e-21, -1.226234086267356e-22,  5.144883254851790e-06,
 -5.788559798297336e-07,  3.551071781083213e-08, -1.557520213841869e-09,  5.440112116331114e-11, -1.602526196659572e-12,  4.124505480239495e-14, -9.498150037056463e-16,
  1.990660353688007e-17, -3.845677825600264e-19,  6.915775872667877e-21, -1.166520634531305e-22,  1.680821515981730e-06, -2.132281452844989e-07,  1.459978822711323e-08,
 -7.090728813893936e-10,  2.725144718979399e-11, -8.787128406212555e-13,  2.464651519190538e-14, -6.161766987750925e-16,  1.397292187683774e-17, -2.911971486543429e-19,
  5.633894651110824e-21, -1.019846560807407e-22,  5.242352234531685e-07, -7.450460516272231e-08,  5.667559972732025e-09, -3.036796854959161e-10,  1.280256668225360e-11,
 -4.506550301909687e-13,  1.374192244874744e-14, -3.721559564046737e-16,  9.112698563457941e-18, -2.044765537145243e-19,  4.248508566089020e-21, -8.239301724620875e-23,
  1.568075822825692e-07, -2.481763208726679e-08,  2.088196638030972e-09, -1.230043452808523e-10,  5.671172927408748e-12, -2.173504988006555e-13,  7.188325203093435e-15,
 -2.104221466630183e-16,  5.552410899272711e-18, -1.338930584364113e-19,  2.982294272439412e-21, -6.185790256504833e-23,  4.521587211992799e-08, -7.924555973652541e-09,
  7.344132260142536e-10, -4.739220270784292e-11,  2.382513452054446e-12, -9.915664681007522e-14,  3.548332110196929e-15, -1.120295389221771e-16,  3.179195311901916e-18,
 -8.223459030180740e-20,  1.960070613275563e-21, -4.340773998518374e-23,  1.264270155206302e-08, -2.440520736702149e-09,  2.480894331148331e-10, -1.747825417184432e-11,
  9.552334755002263e-13, -4.305725404532836e-14,  1.663199753784500e-15, -5.651214177607572e-17,  1.721203514706551e-18, -4.766456537057229e-20,  1.213520314814987e-21,
 -2.864424796174628e-23,  3.450457942515170e-09, -7.298362609660209e-10,  8.104869075010209e-11, -6.212510181633024e-12,  3.680068210269041e-13, -1.791734943668658e-14,
  7.452508715688830e-16, -2.718978299123708e-17,  8.869200209572158e-19, -2.624278846532434e-20,  7.123213459699306e-22, -1.788860712082140e-23,  9.259913008228762e-10,
 -2.135300405199268e-10,  2.579985777049968e-11, -2.144187115141934e-12,  1.372444255252167e-13, -7.197616823965317e-15,  3.215460364737202e-16, -1.256686728970537e-17,
  4.380598270237315e-19, -1.382018492236729e-20,  3.991460285664166e-22, -1.064426012106544e-23,  2.463738035719227e-10, -6.162696639014428e-11,  8.068590595188106e-12,
 -7.244820204161889e-13,  4.994872041774014e-14, -2.813442644042581e-15,  1.346350140454173e-16, -5.622637197288997e-18,  2.089563999561604e-19, -7.013357523228200e-21,
  2.150681262012843e-22, -6.077980742712186e-24,  6.557955235306865e-11, -1.770476971192084e-11,  2.501404818259947e-12, -2.417730758700220e-13,  1.789489884261779e-14,
 -1.079290485118934e-15,  5.516864680177882e-17, -2.455371339989160e-18,  9.703986515703592e-20, -3.456784318611838e-21,  1.122955090797890e-22, -3.355759151621262e-24,
  1.763651580538928e-11, -5.113079644063458e-12,  7.762270987945307e-13, -8.045384870557295e-14,  6.370496692290261e-15, -4.100800257061772e-16,  2.232221182434090e-17,
 -1.055748090602318e-18,  4.425165229325299e-20, -1.668693431724748e-21,  5.728316339254307e-23, -1.805760178804826e-24,  4.843226135141557e-12, -1.500097895841105e-12,
  2.436197242687829e-13, -2.696849097910488e-14,  2.275997641261521e-15, -1.558267341525055e-16,  9.003284657389463e-18, -4.510990723505287e-19,  1.999357680594866e-20,
 -7.958496411622793e-22,  2.879114167886750e-23, -9.548938712526366e-25,  1.373407811537925e-12, -4.520836856592185e-13,  7.817769624801658e-14, -9.203636780915244e-15,
  8.245790453863463e-16, -5.982003423833481e-17,  3.655530088433419e-18, -1.933734014276811e-19,  9.033504606355992e-21, -3.783889481300624e-22,  1.438276274685628e-23,
 -5.004310233635058e-25,  4.068350281117911e-13, -1.415581521650160e-13,  2.593877479331181e-14, -3.232825551131473e-15,  3.061616482200203e-16, -2.343923439802641e-17,
  1.509068431276857e-18, -8.396935833368023e-20,  4.119801914029334e-21, -1.809728141506639e-22,  7.203755766581091e-24, -2.621074712714170e-25,  1.273410732248619e-13,
 -4.657827139037677e-14,  8.997248189070606e-15, -1.181369931231036e-15,  1.177180283320654e-16, -9.468881010872119e-18,  6.395760793529511e-19, -3.728283367862430e-20,
  1.913664049555674e-21, -8.782597501413703e-23,  3.647798897329555e-24, -1.383059888558769e-25,  4.257061922980388e-14, -1.627650675303729e-14,  3.296349427434563e-15,
 -4.536205809183511e-16,  4.732331512533328e-17, -3.980325856980204e-18,  2.807663723910795e-19, -1.707044389375460e-20,  9.127431416877576e-22, -4.358471087026212e-23,
  1.881352615992673e-24, -7.404411420686640e-26,  1.533665274587161e-14, -6.093898875900548e-15,  1.286515952992187e-15, -1.845205065856317e-16,  2.004596420223240e-17,
 -1.753948523383603e-18,  1.285623586940589e-19, -8.113496853256490e-21,  4.498206809367762e-22, -2.224839431680192e-23,  9.937313228223005e-25, -4.042637438772896e-26,
  5.986408173542448e-15, -2.457340512389065e-15,  5.375322915891224e-16, -7.987988070480774e-17,  8.985284541636669e-18, -8.133185457161586e-19,  6.161673601587256e-20,
 -4.015433926857146e-21,  2.296716103901971e-22, -1.170909684856294e-23,  5.386107212965403e-25, -2.254534724826308e-26,  2.527471925614694e-15, -1.065348342453873e-15,
  2.399372747159143e-16, -3.671310510147429e-17,  4.249958092905109e-18, -3.956271925778229e-19,  3.080179046470699e-20, -2.061272264911241e-21,  1.209796572590998e-22,
 -6.324317662187311e-24,  2.980861658853131e-25, -1.277536341485078e-26,  1.134776065693487e-15, -4.881499512148375e-16,  1.124509705662581e-16, -1.760080584349448e-17,
  2.083445120606523e-18, -1.982195511689417e-19,  1.576357582661798e-20, -1.076917186318377e-21,  6.448790921570818e-23, -3.437587344124595e-24,  1.651265520281801e-25,
 -7.208230156923297e-27,  5.109570320417774e-16, -2.229286274315050e-16,  5.217054990394528e-17, -8.296339186041155e-18,  9.975210680282649e-19, -9.636517474167281e-20,
  7.778451319747913e-21, -5.391527061924916e-22,  3.274352021711867e-23, -1.769487526687806e-24,  8.613709308551760e-26, -3.808926726440946e-27,  1.806783775155905e-16,
 -7.945230921008545e-17,  1.875840708330233e-17, -3.009644041283221e-18,  3.650496552329156e-19, -3.556863517701393e-20,  2.895101296439883e-21, -2.023062273334445e-22,
  1.238376976855927e-23, -6.743875673972635e-25,  3.307450091945942e-26, -1.473148087536630e-27,  6.692492424902863e-02, -1.859693924215089e-04,  5.370988740138636e-07,
 -1.601288112492732e-09,  4.888128069027124e-12, -1.516807527210401e-14,  4.753779527172584e-17, -1.498544254712202e-19,  4.733483278711503e-22, -1.496172845165197e-24,
  4.720953018633129e-27, -1.487894810390951e-29,  6.205134584839994e-02, -2.174070060618269e-04,  9.129865856270935e-07, -3.992476257284727e-09,  1.727649991340370e-11,
 -7.317452119336464e-14,  3.034548013206709e-16, -1.235431270045771e-18,  4.950202537818927e-21, -1.956272199551447e-23,  7.636891444681321e-26, -2.948901627432226e-28,
  5.334828658911103e-02, -2.643918043987721e-04,  1.582512333286668e-06, -9.064285839812459e-09,  4.914803563689168e-11, -2.552808666087555e-13,  1.281720805316568e-15,
 -6.257723838086803e-18,  2.983210156739033e-20, -1.392944516161716e-22,  6.385687149468105e-25, -2.879617687177875e-27,  4.253847447973982e-02, -3.037535343877251e-04,
  2.384355408235091e-06, -1.684410039984647e-08,  1.103133086565402e-10, -6.833632331342258e-13,  4.050463992429535e-15, -2.314541422297476e-17,  1.282024854590640e-19,
 -6.911743267102638e-22,  3.638607462446999e-24, -1.875187001579684e-26,  3.146785948503453e-02, -3.167335083487688e-04,  3.106069203710413e-06, -2.644890774473172e-08,
  2.055836238449069e-10, -1.493320470065544e-12,  1.027786938085798e-14, -6.765664510855065e-17,  4.288614733984549e-19, -2.631080945405526e-21,  1.568476924468247e-23,
 -9.113827706304393e-26,  2.160510660718641e-02, -2.968475198862907e-04,  3.547302795600593e-06, -3.592384565899333e-08,  3.271325926202233e-10, -2.751529187720121e-12,
  2.173056535590237e-14, -1.629502019413682e-16,  1.169491790571228e-18, -8.081546755227338e-21,  5.402005044248537e-23, -3.505549689805838e-25,  1.377469319354093e-02,
 -2.503687464507891e-04,  3.593763329901890e-06, -4.282970947010604e-08,  4.522338981388595e-10, -4.362397109444327e-12,  3.918068697166322e-14, -3.318574708999507e-16,
  2.674999226879257e-18, -2.066055622960651e-20,  1.537043616435313e-22, -1.105968121267041e-24,  8.160815441359649e-03, -1.908691496252273e-04,  3.257741544376672e-06,
 -4.528174552830413e-08,  5.497782975297044e-10, -6.035895137203982e-12,  6.121344087787944e-14, -5.817082681760256e-16,  5.232775817135673e-18, -4.489676623171441e-20,
  3.695623254855683e-22, -2.931780902552202e-24,  4.496398284695920e-03, -1.321644201485183e-04,  2.659883022660159e-06, -4.278573088094241e-08,  5.931916717076315e-10,
 -7.365546464080233e-12,  8.385479284270849e-14, -8.891494465808230e-16,  8.879458647820236e-18, -8.421000476568799e-20,  7.632712549069623e-22, -6.645023822186109e-24,
  2.306218346906244e-03, -8.350493672206892e-05,  1.966643584054793e-06, -3.636052117650797e-08,  5.722502640019937e-10, -7.993403242619624e-12,  1.016549473236812e-13,
 -1.197163375852413e-15,  1.321433856962094e-17, -1.379427905917211e-19,  1.371234318380266e-21, -1.305027410284920e-23,  1.102416732551295e-03, -4.834459776572460e-05,
  1.322922714986887e-06, -2.794327514072658e-08,  4.966453530278974e-10, -7.768117384180252e-12,  1.098848052198095e-13, -1.431574142827316e-15,  1.740022869304670e-17,
 -1.992191727251830e-19,  2.164471411658647e-21, -2.244474458693562e-23,  4.918100304939800e-04, -2.574501784567122e-05,  8.130790316566596e-07, -1.951395184095663e-08,
  3.898757981733860e-10, -6.800507883478882e-12,  1.066017776912833e-13, -1.531023973150762e-15,  2.042445115453483e-17, -2.556807582593466e-19,  3.027150025264701e-21,
 -3.410412698701816e-23,  2.050951554864999e-04, -1.265671654921498e-05,  4.584153550459140e-07, -1.243880988490024e-08,  2.782022663296840e-10, -5.391687911597004e-12,
  9.334684846518845e-14, -1.473387283351767e-15,  2.151065773178502e-17, -2.936159344417034e-19,  3.778254381571994e-21, -4.612950025507857e-23,  8.010107309954853e-05,
 -5.764459586908975e-06,  2.380148603740720e-07, -7.268328677663622e-09,  1.812825151551645e-10, -3.890582372455621e-12,  7.417004008178450e-14, -1.283026898879273e-15,
  2.044606700482324e-17, -3.035602373476051e-19,  4.235583983141083e-21, -5.591614032319414e-23,  2.936294422505924e-05, -2.440817250914160e-06,  1.142498045177533e-07,
 -3.909637506628481e-09,  1.083567393155757e-10, -2.567243789782340e-12,  5.374208026862430e-14, -1.016261590115862e-15,  1.763542751107028e-17, -2.841572097580951e-19,
  4.290027092773310e-21, -6.111311878757631e-23,  1.012853431955452e-05, -9.643334372779290e-07,  5.090249663004764e-08, -1.944121877281214e-09,  5.967545322387391e-11,
 -1.556344396183500e-12,  3.568328552198693e-14, -7.358919803250643e-16,  1.387548882212858e-17, -2.421379487932814e-19,  3.947727706001713e-21, -6.057010401139595e-23,
  3.297328937344562e-06, -3.568606635109101e-07,  2.113762251939589e-08, -8.976169895462807e-10,  3.041918813589659e-11, -8.709063377734946e-13,  2.181649285950975e-14,
 -4.895850928967003e-16,  1.000973863116884e-17, -1.888169990752899e-19,  3.318291750794905e-21, -5.473980873665438e-23,  1.016551079537301e-06, -1.242056020247420e-07,
  8.217126388220049e-09, -3.865720465601558e-10,  1.441992143340182e-11, -4.520301625283341e-13,  1.234312717647161e-14, -3.007758664202339e-16,  6.654989404208597e-18,
 -1.354481215658940e-19,  2.561428609295106e-21, -4.535537740134243e-23,  2.979589343744917e-07, -4.084247892641972e-08,  3.004641061043286e-09, -1.560508907689366e-10,
  6.388678977280938e-12, -2.187255918651003e-13,  6.495666467804479e-15, -1.715244810071833e-16,  4.099376697813247e-18, -8.986304573862888e-20,  1.825572149454511e-21,
 -3.464247970377022e-23,  8.340815714432264e-08, -1.275183614999682e-08,  1.038775356492412e-09, -5.935997310696070e-11,  2.659609098466173e-12, -9.920093425872583e-14,
  3.197024241209606e-15, -9.129738010552483e-17,  2.352495395951781e-18, -5.544639230079097e-20,  1.208050628961801e-21, -2.452879630875724e-23,  2.241491342623664e-08,
 -3.801251090152762e-09,  3.414896557418763e-10, -2.140009182371074e-11,  1.046410579759132e-12, -4.241728174933927e-14,  1.480206850160248e-15, -4.562170409633121e-17,
  1.265063356339906e-18, -3.200228789418158e-20,  7.465715868611070e-22, -1.619423287390201e-23,  5.817187080849915e-09, -1.088572243966647e-09,  1.074214366988020e-10,
 -7.358330181193840e-12,  3.915729186233608e-13, -1.720770854339527e-14,  6.487611076244936e-16, -2.153696933981581e-17,  6.414657002076322e-19, -1.738582375041215e-20,
  4.335454764318704e-22, -1.003052998483098e-23,  1.467775285737982e-09, -3.015543973694620e-10,  3.256034514537058e-11, -2.430030184574704e-12,  1.403338719181839e-13,
 -6.668806706301080e-15,  2.710188789735665e-16, -9.670227451336135e-18,  3.087615515882404e-19, -8.949496473277298e-21,  2.381382373217477e-22, -5.866691651175800e-24,
  3.628129593644221e-10, -8.143370997727804e-11,  9.583611968181666e-12, -7.766987657037615e-13,  4.853568582300707e-14, -2.487656183083772e-15,  1.087171364801524e-16,
 -4.160222211761158e-18,  1.421042369329187e-19, -4.396359208634797e-21,  1.245989032243773e-22, -3.262764013457877e-24,  8.861306964842916e-11, -2.162251183758413e-11,
  2.762665274611904e-12, -2.423161007185104e-13,  1.633582195429483e-14, -9.005917500652157e-16,  4.221832392374279e-17, -1.728565927331888e-18,  6.302710478240669e-20,
 -2.076932581638132e-21,  6.257127530612113e-23, -1.738316382234128e-24,  2.158965260095476e-11, -5.699089532741395e-12,  7.873749807086294e-13, -7.448003276486349e-14,
  5.399763680367891e-15, -3.192725589445794e-16,  1.601157465203239e-17, -6.996715220699694e-19,  2.716796097983530e-20, -9.514441791037663e-22,  3.040421220913367e-23,
 -8.942760790794147e-25,  5.302683136913212e-12, -1.506753713384013e-12,  2.241654293053839e-13, -2.278389275039196e-14,  1.770430661063580e-15, -1.119222673005624e-16,
  5.987267849221170e-18, -2.784698470360257e-19,  1.148520083767092e-20, -4.264076227312078e-22,  1.441940891090975e-23, -4.480028899921560e-25,  1.328080087613962e-12,
 -4.041520691971833e-13,  6.446667396129575e-14, -7.012849327853074e-15,  5.819626328059923e-16, -3.920335760102208e-17,  2.229987158534872e-18, -1.100630897438223e-19,
  4.807981367752418e-21, -1.887236688425168e-22,  6.735738242486627e-24, -2.205047394582310e-25,  3.433677585748224e-13, -1.113211641999393e-13,  1.895147461436429e-14,
 -2.197264449777487e-15,  1.939720344623920e-16, -1.387288172676148e-17,  8.361941496726799e-19, -4.365198331408999e-20,  2.013339101896555e-21, -8.329994545309720e-23,
  3.128788441888686e-24, -1.076185502355087e-25,  9.282722027277785e-14, -3.188894669501904e-14,  5.765923285910037e-15, -7.092996095576583e-16,  6.632888482476669e-17,
 -5.016352561046603e-18,  3.191776912021673e-19, -1.755913480837253e-20,  8.520970432490782e-22, -3.703565537911445e-23,  1.459201097786442e-24, -5.257040698220592e-26,
  2.658348400446511e-14, -9.622552454648799e-15,  1.838369128459990e-15, -2.387812571790415e-16,  2.354425531910433e-17, -1.874642775804622e-18,  1.253836051808642e-19,
 -7.239906330917476e-21,  3.682192056181414e-22, -1.675002767303856e-23,  6.897699033308727e-25, -2.593736489973959e-26,  8.165528227125183e-15, -3.096409964744667e-15,
  6.216050449197176e-16, -8.480147568831346e-17,  8.772364380208633e-18, -7.318239609225281e-19,  5.121502342749568e-20, -3.090132284366128e-21,  1.640109141335256e-22,
 -7.776028655399408e-24,  3.333469709023167e-25, -1.303241172925715e-26,  2.719626591742333e-15, -1.073935562138228e-15,  2.252114802072831e-16, -3.208752800026223e-17,
  3.463433362032995e-18, -3.011410897353174e-19,  2.193957210497211e-20, -1.376482017084777e-21,  7.588128948285401e-23, -3.732574625933017e-24,  1.658333762488421e-25,
 -6.711842673168627e-27,  9.894517201198678e-16, -4.043705109482257e-16,  8.803043886134529e-17, -1.301936644324534e-17,  1.457660419628210e-18, -1.313457575349293e-19,
  9.907098775457210e-21, -6.428863116339941e-22,  3.662039515017988e-23, -1.859565122263092e-24,  8.521017949445821e-26, -3.553531472294191e-27,  3.933513069552808e-16,
 -1.653230341624352e-16,  3.711607146335038e-17, -5.661220079402417e-18,  6.533221794826648e-19, -6.063451588614623e-20,  4.706957607196334e-21, -3.141014669856216e-22,
  1.838468944194770e-23, -9.585283458201064e-25,  4.506269890252141e-26, -1.926509297794024e-27,  1.683075279352785e-16, -7.228000252526137e-17,  1.661959566218775e-17,
 -2.596454329846019e-18,  3.067866866965910e-19, -2.913585579031466e-20,  2.313050037526514e-21, -1.577553284847635e-22,  9.431345234016636e-24, -5.019544972202065e-25,
  2.407486083408181e-26, -1.049382691130855e-27,  7.321713432363058e-17, -3.191817027071775e-17,  7.462760695196611e-18, -1.185659843927411e-18,  1.424299861687613e-19,
 -1.374719703938727e-20,  1.108694105735891e-21, -7.678299651778845e-23,  4.659328828261983e-24, -2.515938927811478e-25,  1.223790316315895e-26, -5.407467342817300e-28,
  2.538829889605732e-17, -1.116061327049430e-17,  2.633981457233190e-18, -4.224396537281225e-19,  5.121952473395715e-20, -4.988699497770583e-21,  4.059040603741570e-22,
 -2.835381446968431e-23,  1.735005636467776e-24, -9.445098875532108e-26,  4.630653595847654e-27, -2.061820804028154e-28,  6.618952041057345e-02, -1.817481563476569e-04,
  5.183428630032962e-07, -1.525444362591605e-09,  4.595844403998499e-12, -1.407585614165378e-14,  4.354608673589828e-17, -1.355338709033724e-19,  4.227332308523627e-22,
 -1.319794371159906e-24,  4.113042117326366e-27, -1.280871617979495e-29,  6.119602867203014e-02, -2.102901617406983e-04,  8.666883697618808e-07, -3.727375924397240e-09,
  1.588312650651383e-11, -6.628944120325888e-14,  2.709786039423839e-16, -1.087727806484716e-18,  4.297942517071703e-21, -1.675230296666419e-23,  6.450970961003730e-26,
 -2.457498452711845e-28,  5.231536905771458e-02, -2.521538006433589e-04,  1.478295885016714e-06, -8.317148534779580e-09,  4.433637724307903e-11, -2.265187527948999e-13,
  1.119149220557624e-15, -5.378637868770085e-18,  2.524830720313691e-20, -1.161149569475092e-22,  5.244044554313775e-25, -2.330157653990601e-27,  4.136037090987276e-02,
 -2.854582081787305e-04,  2.192381787889749e-06, -1.518335606248718e-08,  9.756796337018802e-11, -5.934874017767721e-13,  3.456277772800693e-15, -1.941449820911770e-17,
  1.057527402427374e-19, -5.608752731399813e-22,  2.905540985233553e-24, -1.473885602501427e-26,  3.024868849932448e-02, -2.931007694063294e-04,  2.807474465788091e-06,
 -2.338571596782559e-08,  1.780381161575704e-10, -1.267916852195990e-12,  8.562193766663232e-15, -5.533492135211167e-17,  3.445319815132505e-19, -2.077084436452134e-21,
  1.217207691785717e-23, -6.954956822235918e-26,  2.047186348782413e-02, -2.701084676751434e-04,  3.145893094490701e-06, -3.110311069539956e-08,  2.769685401880148e-10,
 -2.280772633242787e-12,  1.765096198706623e-14, -1.297927973923530e-16,  9.140004860127582e-19, -6.200315369037141e-21,  4.070350042689569e-23, -2.595110528685896e-25,
  1.282762867848820e-02, -2.235577721581459e-04,  3.120499355859710e-06, -3.624385268275504e-08,  3.736838893499598e-10, -3.524539006125890e-12,  3.098320154380585e-14,
 -2.570604124212405e-16,  2.031084424126910e-18, -1.538559714444185e-20,  1.123157856123339e-22, -7.933571776237617e-25,  7.446220935158974e-03, -1.668398834937492e-04,
  2.763399837673486e-06, -3.737642927398907e-08,  4.425241112417045e-10, -4.744702175003638e-12,  4.704587918319979e-14, -4.375014620245520e-16,  3.854167933340066e-18,
 -3.240513656898022e-20,  2.615327891254042e-22, -2.035266987639851e-24,  4.007260888275562e-03, -1.127882479248631e-04,  2.198871782271902e-06, -3.437172587053576e-08,
  4.641440783659407e-10, -5.622281357695069e-12,  6.251977708065496e-14, -6.481472488048016e-16,  6.333589365545521e-18, -5.881580820700849e-20,  5.223227310752962e-22,
 -4.457783721066297e-24,  2.001106242874385e-03, -6.937278303111055e-05,  1.580377907353128e-06, -2.836149599981765e-08,  4.342929919770744e-10, -5.912384467220872e-12,
  7.337728123833726e-14, -8.442033515389706e-16,  9.111329319216372e-18, -9.306884154624424e-20,  9.058784484038114e-22, -8.446621800887393e-24,  9.282576558630312e-04,
 -3.897834565323739e-05,  1.030583875985643e-06, -2.110913444358067e-08,  3.647076341102874e-10, -5.555045729177126e-12,  7.662666348267897e-14, -9.745654669513962e-16,
  1.157477475294573e-17, -1.295974764548969e-19,  1.377933122244544e-21, -1.399173903924289e-23,  4.004933027970440e-04, -2.008051002598348e-05,  6.122647883550764e-07,
 -1.423835948572908e-08,  2.763261304360999e-10, -4.690371242852348e-12,  7.165054094714054e-14, -1.003995299989845e-15,  1.308036520157264e-17, -1.600489494052430e-19,
  1.853505185043767e-21, -2.043889938580817e-23,  1.609545277246492e-04, -9.518254457886823e-06,  3.326576263587819e-07, -8.741262217671886e-09,  1.897941588387514e-10,
 -3.577453688459432e-12,  6.032674008884470e-14, -9.285587439561902e-16,  1.323333180012594e-17, -1.764813053319177e-19,  2.220484932986805e-21, -2.652603219777000e-23,
  6.036161884219807e-05, -4.165252608264384e-06,  1.659131147803027e-07, -4.904586874853813e-09,  1.187049223706413e-10, -2.476703108887762e-12,  4.597017350712002e-14,
 -7.751819819371051e-16,  1.205453192885963e-17, -1.748036225552428e-19,  2.384126833526217e-21, -3.078751857313922e-23,  2.116752393578352e-05, -1.688499050244179e-06,
  7.624511138008953e-08, -2.525246909844430e-09,  6.789846924899682e-11, -1.563514605351963e-12,  3.185834053222159e-14, -5.871181685982509e-16,  9.939790933196992e-18,
 -1.563946764423847e-19,  2.307542546717676e-21, -3.214924394613946e-23,  6.958026096045937e-06, -6.362943690205635e-07,  3.240824218751172e-08, -1.197995124717710e-09,
  3.567226578796933e-11, -9.041129374301824e-13,  2.017446073192286e-14, -4.054238403593116e-16,  7.457014921329111e-18, -1.270594535257046e-19,  2.024319675751556e-21,
 -3.037422464717253e-23,  2.150012485608596e-06, -2.237309772471409e-07,  1.279248890614549e-08, -5.258882308394677e-10,  1.729004506981656e-11, -4.810854376986039e-13,
  1.172911676507768e-14, -2.564908526815911e-16,  5.115553561615168e-18, -9.422037866931174e-20,  1.618138531362852e-21, -2.610558912110480e-23,  6.265708725420368e-07,
 -7.369698404468024e-08,  4.709476952208630e-09, -2.145645854994647e-10,  7.767052676182022e-12, -2.366759778239295e-13,  6.290956776113412e-15, -1.494046492686279e-16,
  3.225199714913760e-18, -6.410271436565721e-20,  1.184796183937544e-21, -2.052021330742676e-23,  1.728789209097894e-07, -2.284264724908232e-08,  1.624528093493398e-09,
 -8.175785852526737e-11,  3.249656517823389e-12, -1.081890285729138e-13,  3.128636536074938e-15, -8.054102164337081e-17,  1.878533054381717e-18, -4.022474901807177e-20,
  7.988836253619869e-22, -1.483197605475335e-23,  4.536186296362682e-08, -6.694965141306622e-09,  5.277577109738566e-10, -2.924628177473737e-11,  1.273015529296225e-12,
 -4.619839984758469e-14,  1.450500758837966e-15, -4.040044056215295e-17,  1.016368073225112e-18, -2.340901299196786e-20,  4.988133802528376e-22, -9.912939677213030e-24,
  1.137767043943000e-08, -1.865712388184115e-09,  1.623862320665390e-10, -9.877969487970020e-12,  4.696212949122373e-13, -1.853520391271254e-14,  6.305547260573345e-16,
 -1.896671383374364e-17,  5.137794608271718e-19, -1.270782788107126e-20,  2.900913454186798e-22, -6.161992059889717e-24,  2.744145474999767e-09, -4.974231652856319e-10,
  4.762191566955572e-11, -3.170094100950195e-12,  1.641847870619745e-13, -7.031407146789571e-15,  2.586474387937699e-16, -8.386152767269512e-18,  2.441810310962148e-19,
 -6.475329590403693e-21,  1.581122066045237e-22, -3.584551929999787e-24,  6.407834781253530e-10, -1.277697708892582e-10,  1.340503516001250e-11, -9.735163993299209e-13,
  5.478151281745685e-14, -2.539717867880245e-15,  1.008030347017821e-16, -3.516183293974731e-18,  1.098508032371760e-19, -3.117989769365600e-21,  8.130615483454087e-23,
 -1.964314340952064e-24,  1.459978425527385e-10, -3.186952295821023e-11,  3.650562499011408e-12, -2.883293134688206e-13,  1.758034805711011e-14, -8.801683505301892e-16,
  3.761117553625106e-17, -1.408555269682360e-18,  4.712633063132866e-20, -1.429158051388888e-21,  3.973173088705686e-23, -1.021261355245119e-24,  3.274549459393603e-11,
 -7.787916149368500e-12,  9.703206953479024e-13, -8.308112303892130e-14,  5.473396225725746e-15, -2.951691568546001e-16,  1.354775766454704e-17, -5.435500629363012e-19,
  1.943582064175172e-20, -6.285344288569831e-22,  1.859514685956031e-23, -5.076299414886601e-25,  7.302199380267251e-12, -1.883122740166046e-12,  2.542168322396039e-13,
 -2.351761036505943e-14,  1.669019255081117e-15, -9.668629163202760e-17,  4.754568454237982e-18, -2.038805672929259e-19,  7.774097061899476e-21, -2.675300134163809e-22,
  8.405912640483497e-24, -2.432440393864597e-25,  1.637131888250315e-12, -4.555540955911732e-13,  6.636686813822466e-14, -6.610016856666569e-15,  5.037212139752117e-16,
 -3.125363125156556e-17,  1.642110659394125e-18, -7.506513301708540e-20,  3.044822650985053e-21, -1.112424599636032e-22,  3.703887331870968e-24, -1.133686104150831e-25,
  3.735675576363328e-13, -1.116021189088340e-13,  1.747154434174479e-14, -1.866373213431285e-15,  1.521937187129744e-16, -1.008119457972938e-17,  5.642286970268039e-19,
 -2.741701167478782e-20,  1.179811909782994e-21, -4.564352566817167e-23,  1.606417456264494e-24, -5.188310978888330e-26,  8.792091133167746e-14, -2.805298919297518e-14,
  4.698194561289500e-15, -5.360887378361008e-16,  4.660129566355699e-17, -3.283783644361717e-18,  1.951197377952308e-19, -1.004639883733853e-20,  4.572459679386468e-22,
 -1.867697928940761e-23,  6.928806818364233e-25, -2.354940403686010e-26,  2.164678257251699e-14, -7.336808678227417e-15,  1.308153229540842e-15, -1.587342454493300e-16,
  1.464824207651650e-17, -1.093740704986921e-18,  6.873862869629014e-20, -3.736839284698646e-21,  1.792690936340447e-22, -7.705919936735975e-24,  3.003806740645566e-25,
 -1.071063456565927e-26,  5.657134833401648e-15, -2.025242608421995e-15,  3.824508479767689e-16, -4.911174230323267e-17,  4.789170941664222e-18, -3.772642832375855e-19,
  2.497359627995601e-20, -1.427720218227444e-21,  7.191786523612810e-23, -3.241228731589281e-24,  1.322814990671423e-25, -4.931281240908022e-27,  1.591889427191488e-15,
 -5.984000970616579e-16,  1.190172856676382e-16, -1.608844876165359e-17,  1.649503752352265e-18, -1.364249985879526e-19,  9.468080614093160e-21, -5.666864456591713e-22,
  2.984416156728804e-23, -1.404365769364636e-24,  5.976743020275517e-26, -2.320334058468861e-27,  4.885968110199157e-16, -1.916687217287884e-16,  3.990957552191950e-17,
 -5.646316340235143e-18,  6.052808125878130e-19, -5.227972286834924e-20,  3.784419962947816e-21, -2.359626087094593e-22,  1.293003525509870e-23, -6.323440990026820e-25,
  2.793708046737632e-26, -1.124608340289338e-27,  1.651474909789640e-16, -6.717622745676971e-17,  1.454953331821176e-17, -2.140912438107867e-18,  2.385123593358098e-19,
 -2.138847692820076e-20,  1.605780523556005e-21, -1.037327921081492e-22,  5.883176445319769e-24, -2.974882908061110e-25,  1.357625533006097e-26, -5.639507182481822e-28,
  6.162921428392435e-17, -2.582271784804753e-17,  5.777793769453145e-18, -8.783043535215056e-19,  1.010251432982670e-19, -9.346080995247838e-21,  7.232697623384841e-22,
 -4.811975048610265e-23,  2.808311450048451e-24, -1.460059278096303e-25,  6.845400969019548e-27, -2.918839515474320e-28,  2.506411457151022e-17, -1.074457751513891e-17,
  2.465644698617335e-18, -3.844401299358430e-19,  4.533561581161387e-20, -4.297423524849582e-21,  3.405389728829301e-22, -2.318417054429867e-23,  1.383664782583840e-24,
 -7.351817237439844e-26,  3.520383011814256e-27, -1.532073552794781e-28,  1.051284870758052e-17, -4.578961035827440e-18,  1.069561252305859e-18, -1.697622605392447e-19,
  2.037343486092095e-20, -1.964574550611356e-21,  1.582954142465298e-22, -1.095304405610835e-23,  6.640750958023284e-25, -3.582850074904860e-26,  1.741328192276098e-27,
 -7.688181902429351e-29,  3.570463244671596e-18, -1.569011507089767e-18,  3.701503848689813e-19, -5.934103895565786e-20,  7.192045279514151e-21, -7.002180547265699e-22,
  5.695103443242359e-23, -3.976722819998036e-24,  2.432504854177721e-25, -1.323736979895956e-26,  6.487586652820443e-28, -2.887627537613050e-29,  6.547070707427260e-02,
 -1.776734057360320e-04,  5.004696221280891e-07, -1.454107468345607e-09,  4.324478668952817e-12, -1.307480363034912e-14,  3.993360026903225e-17, -1.227359260803078e-19,
  3.780511469624555e-22, -1.166005174117959e-24,  3.589244430530933e-27, -1.104684341127533e-29,  6.036845772752034e-02, -2.035313471310835e-04,  8.234420047600551e-07,
 -3.483508937313497e-09,  1.461998359919051e-11, -6.013642984448979e-14,  2.423604719999261e-16, -9.593653495670387e-19,  3.738815323632961e-21, -1.437569652657560e-23,
  5.461507875267301e-26, -2.052940629787850e-28,  5.132979106887939e-02, -2.407149322730689e-04,  1.382601483663959e-06, -7.642599738914790e-09,  4.006285521105548e-11,
 -2.013788184657728e-13,  9.792579303965423e-16, -4.633718092034953e-18,  2.142228532614851e-20, -9.705299204095571e-23,  4.318875042921869e-25, -1.891292229482353e-27,
  4.025249856325139e-02, -2.686222901903120e-04,  2.019170448301364e-06, -1.371289782410635e-08,  8.648558987717838e-11, -5.166954900238072e-13,  2.957166461050602e-15,
 -1.633225299261109e-17,  8.750589552513128e-20, -4.566506510779487e-22,  2.328325864755207e-24, -1.162763260946699e-26,  2.911949361276118e-02, -2.717169189008886e-04,
  2.543135487627169e-06, -2.072931293255240e-08,  1.546153632116924e-10, -1.079836782646890e-12,  7.156561944771023e-15, -4.541800294939000e-17,  2.778305302173954e-19,
 -1.646289384177131e-21,  9.485804540777324e-24, -5.330879275231047e-26,  1.943950203664199e-02, -2.463622599269978e-04,  2.797810755149150e-06, -2.701469952075201e-08,
  2.353111931688904e-10, -1.897650441428683e-12,  1.439479712041006e-14, -1.038229754919997e-16,  7.175384281427981e-19, -4.779478281941067e-21,  3.082123851101773e-23,
 -1.931024846523687e-25,  1.198070779463463e-02, -2.002369466666669e-04,  2.719245072057997e-06, -3.079075594298779e-08,  3.100819574089490e-10, -2.860452462421188e-12,
  2.461797682453513e-14, -2.001246794503379e-16,  1.550310503083183e-18, -1.152054206813156e-20,  8.254243300836972e-23, -5.724909960302956e-25,  6.820396088856795e-03,
 -1.464132199194738e-04,  2.354421413969368e-06, -3.099777542157356e-08,  3.579965275251850e-10, -3.749674743734852e-12,  3.636056930606525e-14, -3.309774242624013e-16,
  2.856132611876864e-18, -2.353756703632214e-20,  1.862982702629415e-22, -1.422482113091007e-24,  3.588845189954376e-03, -9.672891456275439e-05,  1.827506361514862e-06,
 -2.776924188021555e-08,  3.653437556846355e-10, -4.318503165542064e-12,  4.691746097361051e-14, -4.756726783012332e-16,  4.549371033066405e-18, -4.137709005843209e-20,
  3.601035811218750e-22, -3.013414325482720e-24,  1.746901340806341e-03, -5.798138668215923e-05,  1.278119240133507e-06, -2.227058706523481e-08,  3.318991880833764e-10,
 -4.404898175245997e-12,  5.336371801079713e-14, -5.999226484992873e-16,  6.332430415419322e-18, -6.330747454957365e-20,  6.034790454949880e-22, -5.513978172451798e-24,
  7.873590014927152e-04, -3.165555029515515e-05,  8.089198853135083e-07, -1.607127499753376e-08,  2.699861150873386e-10, -4.005563849820339e-12,  5.389234185138021e-14,
 -6.692811832588930e-16,  7.768931724565867e-18, -8.508233416310785e-20,  8.854499152205151e-22, -8.805753476209258e-24,  3.289828043644552e-04, -1.579723882703159e-05,
  4.651145832002869e-07, -1.048293905358005e-08,  1.976613600721587e-10, -3.265654783750855e-12,  4.862514897851847e-14, -6.648948801878340e-16,  8.461397000357440e-18,
 -1.012132851896820e-19,  1.146719050079485e-21, -1.237887744756670e-23,  1.276060018971160e-04, -7.229917298562038e-06,  2.438541857600495e-07, -6.206330751500419e-09,
  1.308419873110662e-10, -2.399065688984401e-12,  3.941065985986973e-14, -5.916536238019923e-16,  8.232264346123875e-18, -1.072798365604281e-19,  1.319979900873366e-21,
 -1.543078547755105e-23,  4.602353845050965e-05, -3.044488943986727e-06,  1.169948721979704e-07, -3.348299510122999e-09,  7.864839073280372e-11, -1.595507693444305e-12,
  2.883678436548908e-14, -4.740790881089900e-16,  7.194892958856587e-18, -1.019157411858739e-19,  1.358876925801153e-21, -1.716697119519366e-23,  1.546477951335262e-05,
 -1.183413602570820e-06,  5.154920229882482e-08, -1.652494057772643e-09,  4.310839030028592e-11, -9.648716885996517e-13,  1.913823721233326e-14, -3.437584063443154e-16,
  5.678234445421801e-18, -8.725007310170052e-20,  1.258212692577092e-21, -1.714564814379920e-23,  4.852413253809293e-06, -4.260500390830730e-07,  2.093585457989243e-08,
 -7.490130701844197e-10,  2.163564216577743e-11, -5.329100873030820e-13,  1.157358681034402e-14, -2.266471276438523e-16,  4.066726519208839e-18, -6.765995902226604e-20,
  1.053436486262746e-21, -1.545841680332591e-23,  1.425588027260531e-06, -1.425735879108210e-07,  7.867751645800302e-09, -3.130715630083972e-10,  9.985366619167140e-12,
 -2.700072517663696e-13,  6.406751825191730e-15, -1.365216316222396e-16,  2.656099345139625e-18, -4.776693634474262e-20,  8.016651964860363e-22, -1.264844318306825e-23,
  3.933953493071469e-07, -4.452037592715297e-08,  2.747270901677673e-09, -1.211934172043285e-10,  4.256800947585192e-12, -1.260749765658355e-13,  3.261813565516942e-15,
 -7.549268143920975e-17,  1.589856322534724e-18, -3.085650328997816e-20,  5.573760002359107e-22, -9.441810482729136e-24,  1.023475167919692e-07, -1.302819853486046e-08,
  8.953771206925744e-10, -4.365359449703002e-11,  1.684221565658641e-12, -5.451629014524947e-14,  1.534902305106035e-15, -3.851630095708212e-17,  8.766045114600456e-19,
 -1.833329765615852e-20,  3.559237598187902e-22, -6.464481140489720e-24,  2.521309962420052e-08, -3.590069548763032e-09,  2.737367456696565e-10, -1.470558632620940e-11,
  6.216699592486011e-13, -2.194530634880798e-14,  6.711184997555513e-16, -1.822794875153853e-17,  4.476293550429315e-19, -1.007313632039268e-20,  2.098907261414212e-22,
 -4.081916594089542e-24,  5.911243245136922e-09, -9.366368771907916e-10,  7.894116641413802e-11, -4.659276834882421e-12,  2.152958218478862e-13, -8.270970555948181e-15,
  2.742231064576614e-16, -8.047858904215323e-18,  2.129137693840965e-19, -5.147844350326329e-21,  1.149656782349486e-22, -2.390904729021324e-24,  1.326776252171337e-09,
 -2.327908394536841e-10,  2.160916677879956e-11, -1.397220690602214e-12,  7.039883404664539e-14, -2.937014324822240e-15,  1.053716081123109e-16, -3.335739887565386e-18,
  9.492271519020404e-20, -2.462205573673742e-21,  5.885376770613757e-23, -1.307107517836781e-24,  2.870471858498680e-10, -5.550525871825243e-11,  5.654672744189716e-12,
 -3.993845642916101e-13,  2.188795716813363e-14, -9.895241595562908e-16,  3.834168154901917e-17, -1.306960619716602e-18,  3.993765442518628e-20, -1.109690397053790e-21,
  2.834835106513526e-23, -6.714348291903687e-25,  6.033561039092167e-11, -1.279813910941439e-11,  1.425883622416620e-12, -1.096854830801071e-13,  6.521916671398426e-15,
 -3.187870761455973e-16,  1.331343345376349e-17, -4.877460873659120e-19,  1.597726176525271e-20, -4.747649336935483e-22,  1.294223828051464e-23, -3.264232596693331e-25,
  1.243349675924870e-11, -2.879712922773883e-12,  3.496155362405552e-13, -2.920252852531792e-14,  1.878911155261728e-15, -9.906117539106771e-17,  4.449346585202546e-18,
 -1.748406952733658e-19,  6.128112584103759e-21, -1.943986876127715e-22,  5.645468991451250e-24, -1.513796346045085e-25,  2.538025621280835e-12, -6.388607943215256e-13,
  8.420637302769311e-14, -7.613054897448694e-15,  5.285417119310171e-16, -2.998046971836775e-17,  1.444821017266296e-18, -6.076497505146155e-20,  2.274160211957986e-21,
 -7.686577805647388e-23,  2.373613362161410e-24, -6.754573008003028e-26,  5.192146821707850e-13, -1.413631867682477e-13,  2.015075608103866e-14, -1.965263280357484e-15,
  1.467756145257989e-16, -8.932328469752658e-18,  4.606812916498386e-19, -2.068622097243365e-20,  8.247818321398828e-22, -2.963819758012559e-23,  9.711703924311974e-25,
 -2.927068332796551e-26,  1.078455681655506e-13, -3.160265788625009e-14,  4.851911849274573e-15, -5.085971425784951e-16,  4.072641072732466e-17, -2.650956526050229e-18,
  1.458980545245240e-19, -6.975790773501990e-21,  2.955448055123615e-22, -1.126339182776440e-23,  3.907107913896267e-25, -1.244381489570440e-26,  2.307190672573793e-14,
 -7.239280916905893e-15,  1.191813493472046e-15, -1.337441104299506e-16,  1.144070713780253e-17, -7.937923398495012e-19,  4.646893702459564e-20, -2.358523519724454e-21,
  1.058702220003133e-22, -4.267148978643127e-24,  1.562780336804381e-25, -5.245984085328811e-27,  5.162927101923197e-15, -1.725221687934695e-15,  3.031204171674006e-16,
 -3.625687551217352e-17,  3.299701154833833e-18, -2.431020804746610e-19,  1.508244898652138e-20, -8.097947352774231e-22,  3.838560814000668e-23, -1.631033860210665e-24,
  6.287231196461883e-26, -2.217813048324168e-27,  1.228182943794106e-15, -4.345797848269413e-16,  8.106828724752697e-17, -1.028588627176277e-17,  9.914219019487341e-19,
 -7.722524581098742e-20,  5.056881974013778e-21, -2.860883055298773e-22,  1.426622640422328e-23, -6.367221267257341e-25,  2.574261038865938e-26, -9.509831434491456e-28,
  3.156671752478586e-16, -1.175656473517825e-16,  2.315401625182414e-17, -3.099698474230316e-18,  3.148242708003041e-19, -2.580198891348005e-20,  1.775012744244899e-21,
 -1.053405200637404e-22,  5.502412052489526e-24, -2.568843720807931e-25,  1.084933083726294e-26, -4.181083410840426e-28,  8.899315311997747e-17, -3.466602645723510e-17,
  7.163954209315791e-18, -1.006000371247420e-18,  1.070614918489352e-19, -9.182328686877041e-21,  6.601828248577049e-22, -4.089348044488817e-23,  2.226661342077661e-24,
 -1.082294438777288e-25,  4.753358459634110e-27, -1.902570024988079e-28,  2.785143183451706e-17, -1.127231431309685e-17,  2.428190153318939e-18, -3.553732573073743e-19,
  3.938281034545596e-20, -3.513621611357584e-21,  2.624899632925003e-22, -1.687584615297984e-23,  9.526955397054917e-25, -4.795924731539474e-26,  2.179252866230357e-27,
 -9.014899179686961e-29,  9.724941889259004e-18, -4.061374607183397e-18,  9.054538701431778e-19, -1.371474358666848e-19,  1.571975772174493e-20, -1.449318118793287e-21,
  1.117889263440724e-22, -7.413660134911184e-24,  4.313313361046088e-25, -2.235820362127150e-26,  1.045222387389391e-27, -4.444345272454640e-29,  3.748609111548156e-18,
 -1.603895858110940e-18,  3.672808533256301e-19, -5.714487633142794e-20,  6.724928058424981e-21, -6.361803418849188e-22,  5.031401919910765e-23, -3.418930111893910e-24,
  2.036723122756141e-25, -1.080248199416754e-26,  5.163818898222736e-28, -2.243564695900891e-29,  1.512732142475295e-18, -6.582720570256494e-19,  1.536011606814121e-19,
 -2.435444565752078e-20,  2.919827837018275e-21, -2.812729902039281e-22,  2.264154223617792e-23, -1.565173631262697e-24,  9.480836605037820e-26, -5.110594207978802e-27,
  2.481692022935437e-28, -1.094781088233836e-29,  5.025698749769666e-19, -2.207687499724989e-19,  5.206054841773741e-20, -8.342616662868807e-21,  1.010689521138770e-21,
 -9.836028528552493e-23,  7.996733621185452e-24, -5.581673946753628e-25,  3.412908298319492e-26, -1.856555651070055e-27,  9.095537190539461e-29, -4.046962705100037e-30,
  6.476791208793205e-02, -1.737382892003768e-04,  4.834270186348269e-07, -1.386956849147163e-09,  4.072295199294835e-12, -1.215630728046775e-14,  3.666024301535336e-17,
 -1.112831222813827e-19,  3.385462913581024e-22, -1.031697116220188e-24,  3.137094342084634e-27, -9.544708675204413e-30,  5.956724816048557e-02, -1.971071322849270e-04,
  7.830047252421958e-07, -3.258903886351278e-09,  1.347331357025639e-11, -5.462906926256735e-14,  2.170983369723905e-16, -8.475990751839225e-19,  3.258530730916243e-21,
 -1.236145946305789e-23,  4.633982043578286e-26, -1.719033002287542e-28,  5.038848711670901e-02, -2.300103661076266e-04,  1.294607429997253e-06, -7.032580473704591e-09,
  3.626017853396825e-11, -1.793592075044657e-13,  8.586086179875421e-16, -4.000929440279075e-18,  1.822028553578044e-20, -8.133267719827346e-23,  3.566873117827724e-25,
 -1.539644372360316e-27,  3.920930615508151e-02, -2.531043826925059e-04,  1.862589351545395e-06, -1.240809349808955e-08,  7.682593159187914e-11, -4.509092819551779e-13,
  2.536717208181492e-15, -1.377807498519575e-17,  7.262653815816336e-20, -3.729932166036596e-22,  1.872163083594604e-24, -9.206268670765183e-27,  2.807179795932541e-02,
 -2.523263694389450e-04,  2.308543204963031e-06, -1.841932383094345e-08,  1.346381632901386e-10, -9.223873629768680e-13,  6.000912914381082e-15, -3.740681008405910e-17,
  2.248642273286243e-19, -1.309907115189662e-21,  7.422582841716298e-24, -4.103560536185693e-26,  1.849685155631526e-02, -2.252152420185357e-04,  2.495029997224165e-06,
 -2.353551735546152e-08,  2.005902295542509e-10, -1.584616082860480e-12,  1.178494930671050e-14, -8.339245895724196e-17,  5.657633537398105e-19, -3.701129948097231e-21,
  2.345028131822939e-23, -1.444071503267871e-25,  1.122104142245261e-02, -1.798807484727547e-04,  2.377734983233324e-06, -2.625682419996219e-08,  2.583547650437686e-10,
 -2.331618587577650e-12,  1.965094872350921e-14, -1.565595416940826e-16,  1.189394220864605e-18, -8.672538390355013e-21,  6.099900655184829e-23, -4.154972975816177e-25,
  6.270188447014087e-03, -1.289737731533576e-04,  2.014486394267592e-06, -2.582533939945954e-08,  2.910291433806886e-10, -2.978636128436618e-12,  2.825494964311515e-14,
 -2.518146744160039e-16,  2.129086684344669e-18, -1.720184772141158e-20,  1.335523648916904e-22, -1.000743297977965e-24,  3.229191283479572e-03, -8.334860175796581e-05,
  1.526684729443125e-06, -2.255777106596742e-08,  2.892345777345060e-10, -3.337142634292700e-12,  3.543122459940844e-14, -3.513861410391077e-16,  3.290004173596400e-18,
 -2.931340497643317e-20,  2.500626394616904e-22, -2.052201218628670e-24,  1.533852295987209e-03, -4.874141447939594e-05,  1.040038023752885e-06, -1.760072219869187e-08,
  2.553578674130001e-10, -3.304795216079530e-12,  3.909084827348181e-14, -4.295276154217028e-16,  4.435111168150585e-18, -4.340542576591633e-20,  4.053044836570668e-22,
 -3.629598150100013e-24,  6.725542879685500e-04, -2.588783776952530e-05,  6.395509543119079e-07, -1.232801188571937e-08,  2.014250795277709e-10, -2.911536987470478e-12,
  3.821715571034906e-14, -4.635393919652105e-16,  5.259953273497961e-18, -5.635610408950067e-20,  5.741710866879745e-22, -5.593474185230947e-24,  2.725088197159771e-04,
 -1.253032051982653e-05,  3.563288072729941e-07, -7.785274404207707e-09,  1.426552314424222e-10, -2.294534246842361e-12,  3.330846934412504e-14, -4.445425377040637e-16,
  5.526954315848933e-18, -6.464313063608421e-20,  7.166303411839084e-22, -7.574449671677941e-24,  1.021621430425451e-04, -5.544737298038748e-06,  1.805079409582489e-07,
 -4.450457316782190e-09,  9.111729106149768e-11, -1.625472219630922e-12,  2.601743364602589e-14, -3.810194442718400e-16,  5.176809031745250e-18, -6.593228951674876e-20,
  7.934363906478052e-22, -9.078006046663805e-24,  3.549031597535769e-05, -2.250057493226143e-06,  8.342300228637017e-08, -2.311688488238512e-09,  5.270518269335541e-11,
 -1.039747378173469e-12,  1.830133539441480e-14, -2.933748449292860e-16,  4.345910028845146e-18, -6.014083788794965e-20,  7.840082032561182e-22, -9.690629283657634e-24,
  1.144512888906967e-05, -8.399335491516979e-07,  3.529357634199282e-08, -1.095120225824956e-09,  2.771944474176830e-11, -6.031126885622529e-13,  1.164619845875845e-14,
 -2.039044912643654e-16,  3.286519819908914e-18, -4.932149004995696e-20,  6.952209255979296e-22, -9.266959079752297e-24,  3.433613535116852e-06, -2.893526368602596e-07,
  1.371656929591156e-08, -4.749357769912213e-10,  1.330847571898430e-11, -3.185819168789246e-13,  6.734268510525941e-15, -1.285197221247867e-16,  2.249707931695989e-18,
 -3.654936877494726e-20,  5.561376676943793e-22, -7.981590887423561e-24,  9.607388142784413e-07, -9.230493842621019e-08,  4.915169787628399e-09, -1.892977157199069e-10,
  5.856832397674164e-12, -1.539039547863959e-13,  3.554087081819651e-15, -7.379867364518789e-17,  1.400603678977133e-18, -2.459414777940537e-20,  4.033619401775906e-22,
 -6.223969144995450e-24,  2.514723485496259e-07, -2.736883222606424e-08,  1.630430555525141e-09, -6.963023368178874e-11,  2.372776612797810e-12, -6.829863842366103e-14,
  1.719809465050899e-15, -3.878823024898699e-17,  7.968791821454448e-19, -1.510189319206658e-20,  2.665935111653297e-22, -4.416804136395443e-24,  6.179498167779622e-08,
 -7.573920182949114e-09,  5.028420442210718e-10, -2.374373432579122e-11,  8.890294078469450e-13, -2.797414142763879e-14,  7.667191906174579e-16, -1.875217166748427e-17,
  4.164113821623362e-19, -8.505106561339991e-21,  1.613922454830192e-22, -2.867360772742670e-24,  1.431596452666875e-08, -1.965377241285569e-09,  1.448885500641518e-10,
 -7.543170913177728e-12,  3.096206989376038e-13, -1.062922984362058e-14,  3.165479668383640e-16, -8.382448173721590e-18,  2.009075087221943e-19, -4.416617904824422e-21,
  8.997647290975203e-23, -1.712166353134346e-24,  3.142269677932563e-09, -4.807719112415399e-10,  3.921749837092890e-11, -2.244993830070022e-12,  1.007907336629725e-13,
 -3.767759380189022e-15,  1.217130055059405e-16, -3.484292497457454e-18,  9.000753249599198e-20, -2.126844636547476e-21,  4.645911143174209e-23, -9.457782172616743e-25,
  6.572765453524958e-10, -1.115429594452832e-10,  1.003355865140413e-11, -6.298469940779367e-13,  3.085991499268086e-14, -1.253736400525603e-15,  4.385610562543193e-17,
 -1.355123459276935e-18,  3.767567295573876e-20, -9.556570258645981e-22,  2.235564005645678e-23, -4.862785536714902e-25,  1.319143985452191e-10, -2.471671239798888e-11,
  2.443533418554764e-12, -1.677535292551071e-13,  8.949485630438949e-15, -3.943656582641152e-16,  1.491168284483608e-17, -4.965355672771891e-19,  1.483569625111500e-20,
 -4.033970234467394e-22,  1.009254358197726e-23, -2.342802817959284e-25,  2.560494563582616e-11, -5.273216982198117e-12,  5.710334291761485e-13, -4.275594956609438e-14,
  2.477830963275831e-15, -1.181862999384026e-16,  4.821634882551106e-18, -1.727261200523175e-19,  5.537451087415877e-21, -1.611683692999656e-22,  4.306516775571057e-24,
 -1.065415444673157e-25,  4.851129892707726e-12, -1.093215854901779e-12,  1.292320025067313e-13, -1.052333365091616e-14,  6.608578879854990e-16, -3.404452706523795e-17,
  1.495589529509425e-18, -5.753381267596241e-20,  1.975743530213466e-21, -6.145400416489114e-23,  1.751114626784127e-24, -4.610319644335951e-26,  9.066904042046376e-13,
 -2.225708167244692e-13,  2.862071422912141e-14, -2.527044054161895e-15,  1.715157531742377e-16, -9.520466820544752e-18,  4.493864334575160e-19, -1.852699756261893e-20,
  6.802212417659549e-22, -2.257076528125541e-23,  6.846870433518622e-25, -1.915240573565398e-26,  1.692157591463020e-13, -4.503783116937642e-14,  6.276666444571434e-15,
 -5.989890327075856e-16,  4.381306143626706e-17, -2.613610381377441e-18,  1.322371646721748e-19, -5.829566885196836e-21,  2.283487191867676e-22, -8.066717245960742e-24,
  2.600090026788933e-25, -7.713093663872987e-27,  3.197020251780619e-14, -9.181388092953768e-15,  1.381279953651123e-15, -1.419762759531552e-16,  1.115637041072838e-17,
 -7.131488318002536e-19,  3.857150529738989e-20, -1.813591962300705e-21,  7.560828471295625e-23, -2.837061178363106e-24,  9.694961275994422e-26, -3.043464447194811e-27,
  6.208881656830033e-15, -1.914224411945515e-15,  3.095496823249757e-16, -3.413835758194204e-17,  2.871720744988510e-18, -1.960628366108300e-19,  1.130100314913922e-20,
 -5.650839890389265e-22,  2.500363944156881e-23, -9.939120358284667e-25,  3.591699210675432e-26, -1.190225988685034e-27,  1.260395919003859e-15, -4.149177486916042e-16,
  7.178515115131529e-17, -8.458120648291145e-18,  7.586561235930986e-19, -5.511590030656601e-20,  3.373674952113318e-21, -1.787988826960734e-22,  8.369916198663967e-24,
 -3.513758767805550e-25,  1.338775472125085e-26, -4.669764358180568e-28,  2.722440861959665e-16, -9.514789968536477e-17,  1.752171708048577e-17, -2.195203676664242e-18,
  2.090131497965459e-19, -1.608951915480816e-20,  1.041645648850428e-21, -5.828663656227436e-23,  2.875941509597701e-24, -1.270530346007200e-25,  5.086346394316755e-27,
 -1.861226365500965e-28,  6.372047226501487e-17, -2.349931276670963e-17,  4.580153710851661e-18, -6.069085005590811e-19,  6.103143517319420e-20, -4.954109292548331e-21,
  3.376657480744350e-22, -1.986078552855602e-23,  1.028504872490016e-24, -4.761832381138804e-26,  1.995020998863459e-27, -7.629006042193083e-29,  1.644537745543565e-17,
 -6.358289124916446e-18,  1.303492602053854e-18, -1.815992950093799e-19,  1.917802776711412e-20, -1.632624051063595e-21,  1.165387908926995e-22, -7.168719634914145e-24,
  3.877285020122419e-25, -1.872430624197248e-26,  8.172296355804136e-28, -3.251366313950187e-29,  4.748818197678142e-18, -1.911726098300084e-18,  4.094274533814335e-19,
 -5.957725683455449e-20,  6.565494281405683e-21, -5.825806657347235e-22,  4.329444469519914e-23, -2.769368496346298e-24,  1.555751738378936e-25, -7.794748807801324e-27,
  3.525744301273066e-28, -1.452075793255170e-29,  1.546241557581368e-18, -6.434794953704202e-19,  1.429075389771418e-19, -2.156307799669457e-20,  2.462306496178243e-21,
 -2.261940923283691e-22,  1.738553575997672e-23, -1.149063802951615e-24,  6.663370950518864e-26, -3.443017226596802e-27,  1.604635490782611e-28, -6.802814702773863e-30,
  5.632216813693299e-19, -2.404897223137594e-19,  5.494610371317884e-20, -8.529720447331557e-21,  1.001577924774753e-21, -9.454610095919167e-23,  7.461860107385324e-24,
 -5.060246301834608e-25,  3.008603276200656e-26, -1.592705078315208e-27,  7.599555494286986e-29, -3.296012404765948e-30,  2.181708118407677e-19, -9.484411146267690e-20,
  2.210653809917925e-20, -3.501256350582914e-21,  4.193057087075302e-22, -4.034976871163348e-23,  3.244674698083691e-24, -2.240746292406949e-25,  1.355984040921048e-26,
 -7.302465714305092e-28,  3.542813789303670e-29, -1.561503130496352e-30,  7.080564747447635e-20, -3.109141923460851e-20,  7.328612809300731e-21, -1.173877999221147e-21,
  1.421503273791441e-22, -1.382809885312887e-23,  1.123754902314494e-24, -7.840496551269821e-26,  4.792120774553151e-27, -2.605787524071677e-28,  1.276118688050131e-29,
 -5.675809298310501e-31,  6.408058989449321e-02, -1.699363574879363e-04,  4.671666056316348e-07, -1.323698367988446e-09,  3.837721306099852e-12, -1.131266186620456e-14,
  3.369056881027216e-17, -1.010204778164054e-19,  3.035662893809547e-22, -9.142204129299776e-25,  2.746080447438538e-27, -8.261845705877253e-30,  5.879110509679916e-02,
 -1.909959383643892e-04,  7.451561569977076e-07, -3.051796286377244e-09,  1.243097262713267e-11, -4.969211837551425e-14,  1.947609518207504e-16, -7.501028267788880e-19,
  2.845138187096670e-21, -1.065063022373166e-23,  3.940274351754862e-26, -1.442754316949981e-28,  4.948863846845326e-02, -2.199814732980916e-04,  1.213582589845462e-06,
 -6.480032401939841e-09,  3.287031571258768e-11, -1.600336385955364e-13,  7.543240000691974e-16, -3.462101470968256e-18,  1.553360404965701e-20, -6.833240416862477e-23,
  2.953832487946977e-25, -1.257006416073845e-27,  3.822577566266593e-02, -2.387790242382528e-04,  1.720780286610328e-06, -1.124784279494755e-08,  6.838661582383985e-11,
 -3.944067940539196e-13,  2.181547791119399e-15, -1.165517305986444e-17,  6.045455638891661e-20, -3.056175884612655e-22,  1.510381020698195e-24, -7.314740116529245e-27,
  2.709807921878287e-02, -2.347068826622292e-04,  2.099852215875242e-06, -1.640521202857943e-08,  1.175498210354138e-10, -7.901626403422182e-13,  5.047561157003994e-15,
 -3.091171165621347e-17,  1.826436951880900e-19, -1.046186820731766e-21,  5.831197475363400e-24, -3.171970999837852e-26,  1.763419634109013e-02, -2.063324589029856e-04,
  2.230862300088286e-06, -2.056500328735149e-08,  1.715472348013363e-10, -1.327868302091539e-12,  9.684614084311725e-15, -6.725057875797291e-17,  4.479804732204206e-19,
 -2.878838613697245e-21,  1.792528594627353e-23, -1.085168743448086e-25,  1.053766140637245e-02, -1.620523083475257e-04,  2.085995393717379e-06, -2.247199870169413e-08,
  2.161046057472098e-10, -1.908571466224257e-12,  1.575635552768030e-14, -1.230569594726229e-16,  9.170269745179692e-19, -6.562443270624380e-21,  4.532180099284134e-23,
 -3.032466121860459e-25,  5.784668484584895e-03, -1.140226378779898e-04,  1.730668336236960e-06, -2.161087617968621e-08,  2.377039809645092e-10, -2.377965655562688e-12,
  2.207175364808150e-14, -1.926414970540026e-16,  1.596234445253806e-18, -1.264661833773545e-20,  9.633261007593380e-23, -7.085441680768371e-25,  2.918614178820041e-03,
 -7.214401319194333e-05,  1.281696492504928e-06, -1.842090133131309e-08,  2.302558589971742e-10, -2.593872526622615e-12,  2.692049454182866e-14, -2.612238106921140e-16,
  2.394937720820538e-18, -2.090842783679452e-20,  1.748681541810566e-22, -1.407697599073298e-24,  1.354281419921691e-03, -4.120119891642386e-05,  8.513171509942940e-07,
 -1.399660711144047e-08,  1.977467383087694e-10, -2.496238018733908e-12,  2.883671535221583e-14, -3.097644082592533e-16,  3.129541791068599e-18, -2.998941516169505e-20,
  2.743620412821230e-22, -2.408573571796173e-24,  5.783707184685458e-04, -2.131250944222581e-05,  5.091801509121981e-07, -9.525314604847704e-09,  1.514060338132501e-10,
 -2.132781801139722e-12,  2.731852962517689e-14, -3.236899056188186e-16,  3.591359134065100e-18, -3.765184535610478e-20,  3.756173007151630e-22, -3.585114376182525e-24,
  2.275476305426952e-04, -1.001780615338657e-05,  2.752159647290511e-07, -5.830380136481648e-09,  1.038451912601520e-10, -1.626479324080579e-12,  2.302346857958615e-14,
 -2.999743826405927e-16,  3.644383236540844e-18, -4.168515070271403e-20,  4.522550526273070e-22, -4.681049486273939e-24,  8.256507496435285e-05, -4.291778848573159e-06,
  1.348776414944958e-07, -3.222046084831346e-09,  6.407605557071173e-11, -1.112349085419619e-12,  1.735080023192694e-14, -2.479179248361953e-16,  3.289724720040299e-18,
 -4.095460304406075e-20,  4.821120510301254e-22, -5.399421232746356e-24,  2.766750052486911e-05, -1.680736880504734e-06,  6.012650695972449e-08, -1.613434053379059e-09,
  3.571063498794176e-11, -6.851776004197602e-13,  1.174708171774275e-14, -1.836407915589144e-16,  2.655656067093563e-18, -3.590791579672458e-20,  4.577292484923598e-22,
 -5.536178184341646e-24,  8.576411897468089e-06, -6.034379215923653e-07,  2.445950789875373e-08, -7.346671324752563e-10,  1.804491983113943e-11, -3.816985837036025e-13,
  7.176396319801901e-15, -1.224860567563661e-16,  1.926596396900770e-18, -2.824109531531488e-20,  3.891418802015214e-22, -5.074299510306929e-24,  2.464110104643427e-06,
 -1.992298159504354e-07,  9.110113218379462e-09, -3.052831241790933e-10,  8.298971255600590e-12, -1.930848924595468e-13,  3.972820565730378e-15, -7.389291166927037e-17,
  1.261967551164948e-18, -2.002145619286990e-20,  2.977484611722483e-22, -4.179566763151028e-24,  6.577498285930773e-07, -6.068378712950571e-08,  3.117567814840589e-09,
 -1.161994267783680e-10,  3.487428193469586e-12, -8.905637824382648e-14,  2.001529620017160e-15, -4.049910188972742e-17,  7.497964842950143e-19, -1.285586479052457e-20,
  2.060486324976224e-22, -3.109408731505048e-24,  1.635826317859700e-07, -1.711313052974282e-08,  9.839448065200567e-10, -4.067415968447039e-11,  1.344587281933756e-12,
 -3.761174667820441e-14,  9.217377222602867e-16, -2.025737990419497e-17,  4.059762479649639e-19, -7.512365854950886e-21,  1.295983858824183e-22, -2.099896935726865e-24,
  3.803279634570092e-08, -4.485879777817835e-09,  2.876100677588653e-10, -1.314998494754846e-11,  4.777551294197492e-13, -1.461167317784719e-14,  3.898117464292756e-16,
 -9.291342336647201e-18,  2.012902686837830e-19, -4.014807376412308e-21,  7.445960339961837e-23, -1.293931173897350e-24,  8.299936184264553e-09, -1.097947816732317e-09,
  7.822564897122029e-11, -3.945532326241971e-12,  1.572072909315241e-13, -5.247402242883894e-15,  1.521541704519268e-16, -3.927696301757847e-18,  9.186364475273103e-20,
 -1.972537278531251e-21,  3.928426453507966e-23, -7.313540733771078e-25,  1.708318674550971e-09, -2.522160923050234e-10,  1.990258941436721e-11, -1.104579196769901e-12,
  4.816707698755200e-14, -1.751592476270847e-15,  5.511695005059275e-17, -1.538742862822492e-18,  3.880436555187057e-20, -8.959586019912381e-22,  1.913969938777807e-23,
 -3.813299682959194e-25,  3.335113162524593e-10, -5.470272266353247e-11,  4.765599458572550e-12, -2.903013888667825e-13,  1.382595137550515e-14, -5.467952184993632e-16,
  1.864305183814687e-17, -5.621077628925145e-19,  1.526470199159957e-20, -3.785347156449738e-22,  8.664051544214432e-24, -1.845353849178630e-25,  6.217568432028692e-11,
 -1.127952980529547e-11,  1.081428315958290e-12, -7.212528500909145e-14,  3.743881334830291e-15, -1.607384282567260e-16,  5.928747811322246e-18, -1.927811338106473e-19,
  5.630088488880621e-21, -1.497646526459872e-22,  3.668512062238249e-24, -8.343732818734107e-26,  1.115680318598976e-11, -2.228967215593644e-12,  2.344424038928255e-13,
 -1.707572116049139e-14,  9.639836563995188e-16, -4.484594908276466e-17,  1.786459852462518e-18, -6.255119438241886e-20,  1.961826915661223e-21, -5.590664516638776e-23,
  1.463768703831097e-24, -3.550914219009657e-26,  1.944924211869456e-12, -4.260791122995550e-13,  4.900633953565762e-14, -3.887781318830715e-15,  2.381585058776192e-16,
 -1.198145643890796e-17,  5.145491292362055e-19, -1.936850960557059e-20,  6.513779428800272e-22, -1.985739059524459e-23,  5.549701045389834e-25, -1.434062192437435e-26,
  3.329749169023551e-13, -7.963927551664566e-14,  9.983230811185212e-15, -8.602297507419327e-16,  5.704214328911770e-17, -3.096604960521071e-18,  1.430842887264925e-19,
 -5.779576743500342e-21,  2.080676014811982e-22, -6.774566626420981e-24,  2.017913989213987e-25, -5.546154994968441e-27,  5.668973468901825e-14, -1.473648214310101e-14,
  2.006271358578669e-15, -1.872056210285564e-16,  1.340167672393972e-17, -7.831545718353350e-19,  3.884892973204700e-20, -1.680432503998596e-21,  6.463352163420058e-23,
 -2.243484878766861e-24,  7.109748793386307e-26, -2.074903733698978e-27,  9.736603168284039e-15, -2.737942110136458e-15,  4.032991586568912e-16, -4.061697249582005e-17,
  3.129793474698550e-18, -1.963447624001281e-19,  1.042984229559587e-20, -4.819777928574272e-22,  1.976136849984008e-23, -7.296954649943850e-25,  2.455231533282014e-26,
 -7.593296015876132e-28,  1.714566204636484e-15, -5.189554242867954e-16,  8.236547656979289e-17, -8.920306007653162e-18,  7.373906922768009e-19, -4.950678574618846e-20,
  2.807910101248700e-21, -1.382428777527750e-22,  6.026252282466051e-24, -2.361249654137718e-25,  8.415216611338750e-27, -2.751593550126371e-28,  3.151728211324504e-16,
 -1.021328742664595e-16,  1.738646185601019e-17, -2.016528417279831e-18,  1.781434838241315e-19, -1.275391575309660e-20,  7.697529741089203e-22, -4.024602122392209e-23,
  1.859540272615929e-24, -7.708805861020866e-26,  2.901660973879115e-27, -1.000344022891582e-28,  6.166446355289685e-17, -2.127170578604220e-17,  3.864334993726964e-18,
 -4.777428067764955e-19,  4.490592560764185e-20, -3.414164574854998e-21,  2.184089174518267e-22, -1.208143285055642e-23,  5.895352934139070e-25, -2.576720183468316e-26,
  1.020948807008477e-27, -3.698934557512712e-29,  1.310442042495337e-17, -4.782516384905730e-18,  9.219290814211332e-19, -1.208477636345655e-19,  1.202570055340881e-20,
 -9.663195921462562e-22,  6.522252698955271e-23, -3.800273956962743e-24,  1.950199405330980e-25, -8.950363079113925e-27,  3.718270943748496e-28, -1.410337212188573e-29,
  3.085631150104187e-18, -1.183525219629025e-18,  2.405739815740987e-19, -3.323570809850654e-20,  3.481358846329738e-21, -2.940371879470531e-22,  2.082940016136887e-23,
 -1.271904790870463e-24,  6.830618991538480e-26, -3.276162275882037e-27,  1.420477774762253e-28, -5.615547186023836e-30,  8.191553855772384e-19, -3.278854933209282e-19,
  6.978938380397990e-20, -1.009329317447521e-20,  1.105680291774250e-21, -9.754611802924146e-23,  7.208790915014618e-24, -4.586389142743965e-25,  2.563135263009046e-26,
 -1.277769938764877e-27,  5.751694079593295e-29, -2.357793239222232e-30,  2.478375844933109e-19, -1.027515197212890e-19,  2.272591134982629e-20, -3.415064427320402e-21,
  3.884142802813211e-22, -3.554280719675042e-23,  2.721640800964479e-24, -1.792312803848350e-25,  1.035723889798888e-26, -5.333609471942614e-28,  2.477651397333558e-29,
 -1.047094020337937e-30,  8.503783372605691e-20, -3.623077177389327e-20,  8.257873221762137e-21, -1.278845106012873e-21,  1.498106293351288e-22, -1.410929827934547e-23,
  1.111076018485977e-24, -7.518553930387176e-26,  4.460916873866820e-27, -2.356789493629164e-28,  1.122350537418558e-29, -4.858631357902663e-31,  3.154192697482883e-20,
 -1.369756795072720e-20,  3.188919467927481e-21, -5.044694466869777e-22,  6.034471555280869e-23, -5.800423971599999e-24,  4.659226737645326e-25, -3.214203339226011e-26,
  1.943063721750612e-27, -1.045363408132600e-28,  5.066691860286648e-30, -2.231060028545478e-31,  9.985249543431316e-21, -4.382827479165372e-21,  1.032609343104270e-21,
 -1.653237448380658e-22,  2.001060129180776e-23, -1.945710387246824e-24,  1.580500877613495e-25, -1.102245376072421e-26,  6.734079412014913e-28, -3.660238482045086e-29,
  1.791783028633614e-30, -7.966188648910472e-32,  6.340821998052383e-02, -1.662615352188667e-04,  4.516433198322511e-07, -1.264061862836006e-09,  3.619330237550398e-12,
 -1.053696306951838e-14,  3.099319249431334e-17, -9.181243849976022e-20,  2.725470004450375e-22, -8.113122006190729e-25,  2.407319100505542e-27, -7.164520860244535e-30,
  5.803881658128242e-02, -1.851778680223208e-04,  7.096959817297238e-07, -2.860604455320408e-09,  1.148222336003067e-11, -4.525994576851028e-14,  1.749771522909793e-16,
 -6.649009671088167e-19,  2.488620384272244e-21, -9.194427490408996e-24,  3.357419157978566e-26, -1.213606140583419e-28,  4.862764972358510e-02, -2.105751504288721e-04,
  1.138875227708246e-06, -5.978761071199361e-09,  2.984310958954379e-11, -1.430391532555641e-13,  6.639900510489432e-16, -3.002209132597376e-18,  1.327363371578106e-20,
 -5.755261351731752e-23,  2.452645669534021e-25, -1.029148195127159e-27,  3.729736270694384e-02, -2.255346587916144e-04,  1.592119900581046e-06, -1.021402444103131e-08,
  6.099670558467410e-11, -3.457569457878603e-13,  1.880712208829807e-15, -9.885604166391721e-18,  5.046649277283717e-20, -2.511766443315543e-22,  1.222456902157366e-24,
 -5.831720391752832e-27,  2.619164613526099e-02, -2.186647012598069e-04,  1.913773491493676e-06, -1.464454172253848e-08,  1.028911463652122e-10, -6.787803240449129e-13,
  4.258501454106388e-15, -2.562729382404466e-17,  1.488636385609549e-19, -8.386221947906712e-22,  4.598694230318431e-24, -2.461810410975615e-26,  1.684306067473455e-02,
 -1.894279591882573e-04,  1.999713628164999e-06, -1.802068998337067e-08,  1.471696346223928e-10, -1.116504896953447e-12,  7.987647916080035e-15, -5.444385621865932e-17,
  3.561753630442199e-19, -2.248918270932541e-21,  1.376406900021103e-23, -8.193222503195876e-26,  9.921199548109541e-03, -1.463869938067062e-04,  1.835881285920364e-06,
 -1.930026467858600e-08,  1.814518631987549e-10, -1.568656503111013e-12,  1.268842395606473e-14, -9.716670128419345e-17,  7.104325834016532e-19, -4.990737796205798e-21,
  3.385033107235373e-23, -2.225271902473551e-25,  5.354712937677630e-03, -1.011533939789960e-04,  1.492676405748031e-06, -1.816104066269162e-08,  1.950331152853626e-10,
 -1.907594650619202e-12,  1.732943010619147e-14, -1.481597224107871e-16,  1.203406822729813e-18, -9.351524866278366e-21,  6.990301126440643e-23, -5.047779040641740e-25,
  2.649228774520546e-03, -6.271574128121864e-05,  1.081145556881614e-06, -1.511906236816517e-08,  1.842888433854127e-10, -2.027541833810051e-12,  2.057496949148811e-14,
 -1.953915641230466e-16,  1.754514911777074e-18, -1.501194227106343e-20,  1.231187186928552e-22, -9.723830747694876e-25,  1.202105179646776e-03, -3.501227557016815e-05,
  7.008082477933083e-07, -1.119721173706299e-08,  1.540947557634463e-10, -1.897847942403478e-12,  2.141702368242031e-14, -2.249661571107422e-16,  2.224331612684329e-18,
 -2.087502618341780e-20,  1.871500436545984e-22, -1.610901032619436e-24,  5.005977789836150e-04, -1.765812568325837e-05,  4.081112219346753e-07, -7.411302756978290e-09,
  1.146348710998240e-10, -1.574066478629650e-12,  1.967938390110240e-14, -2.278369284816227e-16,  2.472182310070625e-18, -2.536670115722104e-20,  2.478368258581570e-22,
 -2.318035322558415e-24,  1.914735990605738e-04, -8.069981257050857e-06,  2.142370476126865e-07, -4.401706439130068e-09,  7.622354191810355e-11, -1.162800466692137e-12,
  1.605400757839245e-14, -2.042401014644659e-16,  2.425119659460373e-18, -2.713264621390025e-20,  2.881378975913307e-22, -2.921038893587328e-24,  6.733367423776374e-05,
 -3.351541921439443e-06,  1.016975599498495e-07, -2.354341993959208e-09,  4.548713546314024e-11, -7.685745708699258e-13,  1.168531470815161e-14, -1.629346791238840e-16,
  2.111918280529676e-18, -2.570390844154298e-20,  2.960356624423331e-22, -3.245854362615678e-24,  2.179641147297106e-05, -1.268406342861342e-06,  4.378652972142312e-08,
 -1.137963752767219e-09,  2.445487036643715e-11, -4.564270708264098e-13,  7.623217470142866e-15, -1.162364991224335e-16,  1.641168999553153e-18, -2.168511574528220e-20,
  2.703367611247807e-22, -3.199861155400822e-24,  6.504412048858440e-06, -4.386423649124689e-07,  1.715129797985310e-08, -4.987139541964605e-10,  1.188786171287308e-11,
 -2.444957278208701e-13,  4.476189044271675e-15, -7.448635003381030e-17,  1.143468663017899e-18, -1.637392549842940e-20,  2.205787893241044e-22, -2.814024733009847e-24,
  1.792589502135216e-06, -1.390081976653993e-07,  6.131020555996392e-09, -1.988417583560077e-10,  5.244191657363724e-12, -1.185938653970548e-13,  2.375339135443871e-15,
 -4.306121016128212e-17,  7.175509028897586e-19, -1.111795738922722e-20,  1.616069548040600e-22, -2.218934111912963e-24,  4.572445538736378e-07, -4.049237885447634e-08,
  2.006698096015145e-09, -7.238134077714910e-11,  2.107200914818314e-12, -5.229286220469861e-14,  1.143845157022443e-15, -2.255408668611339e-17,  4.073497337578964e-19,
 -6.819928072324723e-21,  1.068233579110685e-22, -1.576600394396604e-24,  1.082317231824457e-07, -1.087842520643290e-08,  6.035352437354762e-10, -2.414601720542972e-11,
  7.742693217094815e-13, -2.104665256916708e-14,  5.019575481528454e-16, -1.074949658749302e-17,  2.101463543972728e-19, -3.796891056775163e-21,  6.401022023275722e-23,
 -1.014334353468521e-24,  2.384949725798950e-08, -2.705547716999893e-09,  1.674640754818191e-10, -7.412342891560689e-12,  2.612655563731370e-13, -7.765673493526988e-15,
  2.016356831904503e-16, -4.683422359923279e-18,  9.898038828975944e-20, -1.927732677946420e-21,  3.494046362067893e-23, -5.938593403447089e-25,  4.911169903756913e-09,
 -6.256187858350379e-10,  4.306115382366495e-11, -2.103551374702090e-12,  8.134153636191342e-14, -2.639380755661637e-15,  7.450285139041749e-17, -1.874507328461662e-18,
  4.277761533807060e-20, -8.970843239226987e-22,  1.746349604605321e-23, -3.180420494742460e-25,  9.494440316673117e-10, -1.351728608929233e-10,  1.031375340890292e-11,
 -5.547482206813010e-13,  2.348904424622317e-14, -8.307209939438123e-16,  2.545690618146590e-17, -6.929460202832018e-19,  1.705615125248228e-20, -3.847344678502012e-22,
  8.036126367481622e-24, -1.566713334899245e-25,  1.732712831170745e-10, -2.744795001595564e-11,  2.314596732745228e-12, -1.367616202420033e-13,  6.328944386379933e-15,
 -2.435758805843331e-16,  8.092169485248958e-18, -2.380139270309682e-19,  6.311714542572678e-21, -1.529809978416653e-22,  3.425191785833649e-24, -7.141841052373167e-26,
  3.004813131278210e-11, -5.273694018520819e-12,  4.900387196356111e-13, -3.173435469060770e-14,  1.602045518059565e-15, -6.698737660040088e-17,  2.409305320112060e-18,
 -7.647573090567099e-20,  2.182376913616382e-21, -5.677583769531862e-23,  1.361237220411549e-24, -3.032647049223659e-26,  4.990549250602629e-12, -9.664001345303684e-13,
  9.865904321725542e-14, -6.986025418690696e-15,  3.839796127775815e-16, -1.741460718063717e-17,  6.770761733952900e-19, -2.316237500447713e-20,  7.104230044795916e-22,
 -1.981515306810665e-23,  5.081848533651680e-25, -1.208435015558062e-26,  8.012300293736928e-13, -1.704840394020477e-13,  1.906424357547072e-14, -1.472484563918858e-15,
  8.793639620695244e-17, -4.318001855168440e-18,  1.811908587714799e-19, -6.670568528275926e-21,  2.196037659765076e-22, -6.558722864279492e-24,  1.797129191214746e-25,
 -4.556135697069493e-27,  1.257199361957624e-13, -2.927039213341110e-14,  3.574046013192439e-15, -3.003358945861908e-16,  1.944461248702315e-17, -1.031733616892607e-18,
  4.664217533458302e-20, -1.844920288778230e-21,  6.509353220503123e-23, -2.078717128977605e-24,  6.077163943584818e-26, -1.640460877845666e-27,  1.952810384550079e-14,
 -4.953352732305117e-15,  6.582372428785762e-16, -6.001051459932933e-17,  4.201705924055534e-18, -2.403749008825373e-19,  1.168373219159251e-20, -4.956101836524244e-22,
  1.870777068386986e-23, -6.377296870583087e-25,  1.986093640489901e-26, -5.699652425871257e-28,  3.047780177055246e-15, -8.384076704607474e-16,  1.208164413700266e-16,
 -1.191296701580856e-17,  8.995407189614288e-19, -5.534559855593257e-20,  2.885647609507939e-21, -1.309826859741648e-22,  5.278645139580618e-24, -1.917090782229205e-25,
  6.348158816506980e-27, -1.933266946151233e-28,  4.861489754222130e-16, -1.443299832631168e-16,  2.246425336047621e-17, -2.387353396429168e-18,  1.937950671617041e-19,
 -1.278593845226633e-20,  7.131375681709232e-22, -3.454909481939963e-23,  1.482889926875603e-24, -5.724249839201887e-26,  2.010894206869699e-27, -6.484602996773288e-29,
  8.078688977284864e-17, -2.574894604143855e-17,  4.309591610496560e-18, -4.916566659345828e-19,  4.274841097577151e-20, -3.014049366934932e-21,  1.792545559425302e-22,
 -9.240514405619620e-24,  4.211744266910828e-25, -1.723226903126398e-26,  6.404783385461975e-28, -2.181278023254305e-29,  1.428397065233004e-17, -4.859802270111151e-18,
  8.703033467857010e-19, -1.060992272313304e-19,  9.838967115701711e-21, -7.383694379829209e-22,  4.664599702729954e-23, -2.549293687667852e-24,  1.229592965346033e-25,
 -5.314368490151715e-27,  2.083024216733362e-28, -7.468713296924517e-30,  2.747974634232449e-18, -9.918242755694206e-19,  1.889792627571807e-19, -2.448992177622889e-20,
  2.410170543114149e-21, -1.916091674435711e-22,  1.280029421714395e-23, -7.384607359599233e-25,  3.753514484145623e-26, -1.706850052907249e-27,  7.028023888282194e-29,
 -2.642989573430336e-30,  5.883067664471606e-19, -2.237420499667732e-19,  4.507032190734918e-20, -6.171273771863239e-21,  6.408550328870934e-22, -5.367616045256891e-23,
  3.771833747563976e-24, -2.285348643887207e-25,  1.218150485858569e-26, -5.800496254739332e-28,  2.497489793668284e-29, -9.807159185189810e-31,  1.430496325367575e-19,
 -5.690983497832679e-20,  1.203351024185646e-20, -1.729030882396725e-21,  1.882101641394985e-22, -1.650275452738367e-23,  1.212365245500088e-24, -7.669320778854242e-26,
  4.262457798496761e-27, -2.113625801619242e-28,  9.465398851229548e-30, -3.860995118375929e-31,  4.006646430011244e-20, -1.654433012882092e-20,  3.643100276425435e-21,
 -5.450665990481974e-22,  6.172969193920069e-23, -5.625436128851909e-24,  4.290427032201683e-25, -2.814544347627193e-26,  1.620394329583250e-27, -8.314502609078380e-29,
  3.848995369490025e-30, -1.621214325182473e-31,  1.290658769656036e-20, -5.486010551611070e-21,  1.247164319895538e-21, -1.926426995029121e-22,  2.251032268743909e-23,
 -2.114856592940937e-24,  1.661458401539155e-25, -1.121718947863093e-26,  6.640657639373969e-28, -3.500879581944014e-29,  1.663739746654221e-30, -7.187926241855430e-32,
  4.571999008793720e-21, -1.983222809710432e-21,  4.611338575363330e-22, -7.285720527381386e-23,  8.704452515151156e-24, -8.356808503167853e-25,  6.704834686476323e-26,
 -4.620152465337542e-27,  2.789932851268151e-28, -1.499382343084128e-29,  7.259758484438183e-31, -3.193570152046247e-32,  1.409584316187478e-21, -6.184433748283028e-22,
  1.456369828456038e-22, -2.330550336398027e-23,  2.819507591019790e-24, -2.740216969030284e-25,  2.224843235904914e-26, -1.550905582993780e-27,  9.470920896326549e-29,
 -5.145584450114964e-30,  2.517830317099998e-31, -1.118953708451126e-32,  6.275030543309638e-02, -1.627080949296783e-04,  4.368152073543596e-07, -1.207798934666121e-09,
  3.415826092956499e-12, -9.823016237031533e-15,  2.854028346417921e-17, -8.354026501792241e-20,  2.449996927657881e-22, -7.210369932865336e-25,  2.113284472140887e-27,
 -6.224577457140767e-30,  5.730924715926485e-02, -1.796345533610772e-04,  6.764418723336915e-07, -2.683908474461663e-09,  1.061755620824092e-11, -4.127519881586243e-14,
  1.574268560866475e-16, -5.903120011448449e-19,  2.180561346750801e-21, -7.952394843214771e-24,  2.866611257542514e-26, -1.023101201896568e-28,  4.780312791969232e-02,
 -2.017432237454770e-04,  1.069903356160373e-06, -5.523319480632154e-09,  2.713511529980461e-11, -1.280659857031178e-13,  5.855763119916471e-16, -2.608794817272281e-18,
  1.136794181779808e-20, -4.859061484261234e-23,  2.041762181773037e-25, -8.449108650227072e-28,  3.641994447368390e-02, -2.132718917276410e-04,  1.475186786101055e-06,
 -9.291036745870147e-09,  5.451142590149515e-11, -3.037669586845526e-13,  1.625229399516237e-15, -8.406396503342915e-18,  4.224581210758498e-20, -2.070465418012721e-22,
  9.925387870713600e-25, -4.664854534905044e-27,  2.534653291485445e-02, -2.040304617799158e-04,  1.747485889711335e-06, -1.310156977920474e-08,  9.028212557729408e-11,
 -5.846754461261672e-13,  3.603330869261132e-15, -2.131321640100305e-17,  1.217389715556698e-19, -6.746328798772236e-22,  3.640319143852120e-24, -1.918180628500240e-26,
  1.611602904147220e-02, -1.742568450399553e-04,  1.796889117449352e-06, -1.583469677628644e-08,  1.266394455681438e-10, -9.418777290315466e-13,  6.611333983272224e-15,
 -4.424203184366944e-17,  2.843132984223646e-19, -1.764207754064829e-21,  1.061536872714452e-23, -6.214474600370176e-26,  9.363625517296066e-03, -1.325792825905738e-04,
  1.620713350552715e-06, -1.663235505010165e-08,  1.529161854597292e-10, -1.294370537469398e-12,  1.026077807335147e-14, -7.706421243866176e-17,  5.529500584550510e-19,
 -3.813995109839648e-21,  2.541118928610663e-23, -1.641584438938316e-25,  4.972673191824163e-03, -9.003342310433986e-05,  1.292277610111589e-06, -1.532446437958877e-08,
  1.607254954456266e-10, -1.537411274155959e-12,  1.367308345342867e-14, -1.145381607219937e-16,  9.121529668119556e-19, -6.953843639278766e-21,  5.102040443151634e-23,
 -3.617816337570417e-25,  2.414582002130617e-03, -5.474508159953119e-05,  9.161524474220978e-07, -1.246976987030505e-08,  1.482636380735800e-10, -1.593517143248251e-12,
  1.581510462102376e-14, -1.470212953005069e-16,  1.293303804225460e-18, -1.084744749038995e-20,  8.725752725196464e-23, -6.762656291379682e-25,  1.072473606600731e-03,
 -2.990407533598292e-05,  5.800671674631833e-07, -9.009428899954577e-09,  1.208064586696448e-10, -1.452030787205524e-12,  1.601104615494086e-14, -1.644948697528883e-16,
  1.592079380863461e-18, -1.463607557599132e-20,  1.286122533120035e-22, -1.085646226536974e-24,  4.359728597774696e-04, -1.472003376335892e-05,  3.292192166890908e-07,
 -5.805351888342836e-09,  8.740271309828242e-11, -1.170155088158200e-12,  1.428276946668499e-14, -1.616081781048350e-16,  1.715295310470906e-18, -1.722925139314680e-20,
  1.648900956445439e-22, -1.511560340564655e-24,  1.623140369692753e-04, -6.548274479318623e-06,  1.680294375490416e-07, -3.349040838667591e-09,  5.639903935135544e-11,
 -8.381885475340585e-13,  1.128940932380276e-14, -1.402695219296864e-16,  1.628147165490697e-18, -1.782116054255234e-20,  1.852798480602053e-22, -1.839993869734930e-24,
  5.539178029448218e-05, -2.639673770730385e-06,  7.735039069001669e-08, -1.735706051857977e-09,  3.258669973353058e-11, -5.360161014752395e-13,  7.944980307438053e-15,
 -1.081263350046173e-16,  1.369254148307826e-18, -1.629515073183817e-20,  1.836422859362380e-22, -1.971559408464597e-24,  1.734543645960606e-05, -9.667189158978165e-07,
  3.220680554540269e-08, -8.107818420633812e-10,  1.692013725252936e-11, -3.072438621123017e-13,  4.999901901164693e-15, -7.437029455334632e-17,  1.025378646463175e-18,
 -1.324175793188991e-20,  1.614632776296347e-22, -1.870601376733838e-24,  4.990479876356295e-06, -3.224737046451284e-07,  1.216373293293899e-08, -3.424316750675173e-10,
  7.922559199209051e-12, -1.584491066833234e-13,  2.825097430867065e-15, -4.583992190650092e-17,  6.868900812150520e-19, -9.609563980190147e-21,  1.265747057735711e-22,
 -1.579982978256745e-24,  1.321340250107527e-06, -9.824001715495938e-08,  4.179106083692507e-09, -1.311798628128153e-10,  3.356721571221136e-12, -7.378916551847591e-14,
  1.438815814862019e-15, -2.542491747964312e-17,  4.134123970671454e-19, -6.256274373734473e-21,  8.889260619168730e-23, -1.193945132220395e-24,  3.225966209313661e-07,
 -2.741070193166278e-08,  1.310202921828428e-09, -4.573226470178769e-11,  1.291461194075686e-12, -3.114619450438854e-14,  6.630904402654049e-16, -1.274156387597140e-17,
  2.245056157827635e-19, -3.670388434313903e-21,  5.618673693314149e-23, -8.110596090456298e-25,  7.279942835897309e-08, -7.026746826121693e-09,  3.760924551040234e-10,
 -1.456074345530314e-11,  4.528754954828188e-13, -1.196219183897068e-14,  2.776426388969267e-16, -5.793591217215723e-18,  1.104830136983639e-19, -1.949084270398336e-21,
  3.211065474891133e-23, -4.976375691864050e-25,  1.523006715130389e-08, -1.660856700224030e-09,  9.921587626082687e-11, -4.250551389663166e-12,  1.453317214394584e-13,
 -4.197745702720197e-15,  1.060725598477308e-16, -2.400725586191743e-18,  4.949310970804804e-20, -9.411858759657052e-22,  1.667100846774091e-23, -2.771154324360141e-25,
  2.964448267386361e-09, -3.634342843475624e-10,  2.415722543769340e-11, -1.142638057616104e-12,  4.287161687562349e-14, -1.352085008070717e-15,  3.714870582525514e-17,
 -9.108842566431907e-19,  2.027993747548125e-20, -4.153101369755979e-22,  7.901903247843482e-24, -1.407627673039555e-25,  5.392033152423717e-10, -7.397750739405481e-11,
  5.455305077280268e-12, -2.842748050591722e-13,  1.168423739574301e-14, -4.017838760308140e-16,  1.198807406573828e-17, -3.181072151639875e-19,  7.640934487753491e-21,
 -1.683559882328903e-22,  3.437842241731963e-24, -6.557551294025955e-26,  9.213572871356908e-11, -1.408572234563317e-11,  1.149128896329651e-12, -6.583070419782922e-14,
  2.959100246047675e-15, -1.107896683368576e-16,  3.585470824380291e-18, -1.028506711997370e-19,  2.662719091453128e-21, -6.306548305408431e-23,  1.380955959869462e-24,
 -2.818281055045769e-26,  1.488501105000170e-11, -2.525398008344988e-12,  2.272943567226697e-13, -1.428489633713898e-14,  7.010398559859604e-16, -2.853728045987601e-17,
  1.000493690692309e-18, -3.099102876865842e-20,  8.639066859250532e-22, -2.197441813433869e-23,  5.155380267723542e-25, -1.124747039072630e-26,  2.291189101189209e-12,
 -4.296812183164761e-13,  4.254788332142868e-14, -2.927313599956564e-15,  1.565714199525402e-16, -6.919427207451584e-18,  2.624612085528205e-19, -8.768892998449453e-21,
  2.629234785307902e-22, -7.175270684829661e-24,  1.801922838318696e-25, -4.198906303664392e-27,  3.391357051019690e-13, -7.002462161278766e-14,  7.607425877069418e-15,
 -5.717010791624493e-16,  3.326510153133132e-17, -1.593472928969088e-18,  6.530153304203128e-20, -2.350231914617668e-21,  7.570827230671104e-23, -2.214312417646068e-24,
  5.946286360214632e-26, -1.478508039793124e-27,  4.880553438585034e-14, -1.105093360590019e-14,  1.313328576418320e-15, -1.075518275382260e-16,  6.794272268308711e-18,
 -3.521556963103662e-19,  1.556734721756424e-20, -6.026803562662121e-22,  2.083007578009536e-23, -6.521262778901105e-25,  1.870397955809647e-26, -4.956728066866695e-28,
  6.918503691578930e-15, -1.710764467755965e-15,  2.217174160203882e-16, -1.973489006802361e-17,  1.350494625836929e-18, -7.558846563900381e-20,  3.597920209021494e-21,
 -1.495839747471117e-22,  5.538392402927431e-24, -1.853237432295058e-25,  5.669175295324310e-27, -1.599102549000375e-28,  9.809654080687337e-16, -2.637364599028472e-16,
  3.714836407094771e-17, -3.583519404089830e-18,  2.649668311245005e-19, -1.597798075282428e-20,  8.171684420740682e-22, -3.641219913800347e-23,  1.441554983516529e-24,
 -5.146550697706702e-26,  1.676315216606643e-27, -5.024531840816444e-29,  1.416156456740803e-16, -4.120132632398170e-17,  6.283468343329698e-18, -6.547480138857527e-19,
  5.215445677892281e-20, -3.379148569250372e-21,  1.852212581798648e-22, -8.824577439025720e-24,  3.727206120402846e-25, -1.416673826799144e-26,  4.902983784562698e-28,
 -1.558520533869587e-29,  2.124215104539497e-17, -6.653389369203165e-18,  1.093945803935167e-18, -1.226654499684231e-19,  1.048965559087323e-20, -7.278721684240351e-22,
  4.262946857477013e-23, -2.165348103450089e-24,  9.730325211955703e-26, -3.927075166854584e-27,  1.440478698242930e-28, -4.843959896749762e-30,  3.386566573085411e-18,
 -1.135507597553545e-18,  2.003049220089394e-19, -2.406264201265288e-20,  2.199954914703728e-21, -1.628556438333678e-22,  1.015393223234025e-23, -5.479570006855554e-25,
  2.610956054909255e-26, -1.115309152680078e-27,  4.322416904960984e-29, -1.533025371548770e-30,  5.880853395427296e-19, -2.097728912604215e-19,  3.947969719887325e-20,
 -5.054745164641135e-21,  4.916799257546249e-22, -3.865065246467536e-23,  2.554157269099506e-24, -1.458200353713486e-25,  7.337652603840021e-27, -3.304476744916371e-28,
  1.347969015703278e-29, -5.023809190047375e-31,  1.140736377728556e-19, -4.299288222831579e-20,  8.577595077776342e-21, -1.163431365578375e-21,  1.197128976512844e-22,
 -9.938379653409975e-24,  6.924339397367716e-25, -4.161070162569292e-26,  2.200443510303129e-27, -1.039813345198379e-28,  4.444198433232100e-30, -1.732815774980577e-31,
  2.530820430362083e-20, -1.000281216908569e-20,  2.100263667699953e-21, -2.996854410365113e-22,  3.240200193090432e-23, -2.822593681476849e-24,  2.060572832164626e-25,
 -1.295602270320863e-26,  7.158627831983949e-28, -3.529746918684776e-29,  1.572125391940071e-30, -6.379242157771988e-32,  6.536713472417458e-21, -2.687498374382682e-21,
  5.890135039095829e-22, -8.771498688167179e-23,  9.888736528672944e-24, -8.971973830262567e-25,  6.813690628435832e-26, -4.451480954326626e-27,  2.552668376734459e-28,
 -1.304811406369553e-29,  6.018036352512442e-31, -2.525826913558189e-32,  1.969842418767316e-21, -8.351835997894898e-22,  1.893412245353246e-22, -2.916582813409332e-23,
  3.398848455941258e-24, -3.184889191592542e-25,  2.495761421383047e-26, -1.680872254865339e-27,  9.927385452415076e-29, -5.221665768389013e-30,  2.476048215795575e-31,
 -1.067466028728052e-32,  6.645469722748286e-22, -2.879167925409657e-22,  6.685602689423696e-23, -1.054880625352543e-23,  1.258638666437842e-24, -1.206824524448256e-25,
  9.670573327945472e-27, -6.655757661247251e-28,  4.014470972235910e-29, -2.155044520602438e-30,  1.042295126370931e-31, -4.580214727608121e-33,  1.991991610570419e-22,
 -8.735739901593515e-23,  2.056128641247257e-23, -3.288618970253614e-24,  3.976557926592999e-25, -3.862798528409347e-26,  3.134759550689529e-27, -2.184151331214428e-28,
  1.333174426148637e-29, -7.239884879611252e-31,  3.541035486516208e-32, -1.572997119666539e-33,  6.210637159626805e-02, -1.592706332080863e-04,  4.226431746713915e-07,
 -1.154680962913267e-09,  3.226030445784118e-12, -9.165256458327060e-15,  2.630712693974798e-17, -7.609979839728081e-20,  2.205001789273649e-22, -6.417369870303758e-25,
  1.857584524748544e-27, -5.418497121417230e-30,  5.660133203480662e-02, -1.743490194458110e-04,  6.452276643550222e-07, -2.520431803543393e-09,  9.828535505696912e-12,
 -3.768767102123986e-14,  1.418335014228386e-16, -5.249018239401407e-19,  1.913874672923847e-21, -6.890901000995226e-24,  2.452413151606369e-26, -8.643601083604787e-29,
  4.701286387547091e-02, -1.934419252995672e-04,  1.006146377261601e-06, -5.108908718371025e-09,  2.470862293880451e-11, -1.148491645084439e-13,  5.173707532107937e-16,
 -2.271502536389754e-18,  9.757152327534352e-21, -4.112084441700300e-23,  1.703996023810142e-25, -6.955154050509389e-28,  3.558977411706976e-02, -2.019019884380790e-04,
  1.368733608575046e-06, -8.465414711838792e-09,  4.880783730691786e-11, -2.674398643274607e-13,  1.407708275757697e-15, -7.166510910819654e-18,  3.545994014311814e-20,
 -1.711631054601190e-22,  8.083368514884317e-25, -3.743567012475179e-27,  2.455740865657723e-02, -1.906557524288799e-04,  1.598562935149465e-06, -1.174610035770736e-08,
  7.940726104992771e-11, -5.049380134706083e-13,  3.057639952860429e-15, -1.777962546864613e-17,  9.988188491647266e-20, -5.445904685101332e-22,  2.892199696660473e-24,
 -1.500334471815852e-26,  1.544659526035371e-02, -1.606087292778140e-04,  1.618435321999992e-06, -1.395094831598508e-08,  1.092933446931695e-10, -7.970988410289567e-13,
  5.490936261396102e-15, -3.608330211238767e-17,  2.278289759573652e-19, -1.389612868617926e-21,  8.222003204155679e-24, -4.734690951188996e-26,  8.858031972684905e-03,
 -1.203722196417205e-04,  1.434992179317624e-06, -1.438011455128870e-08,  1.293263994379132e-10, -1.072126161118228e-12,  8.331381299358848e-15, -6.138379937186761e-17,
  4.323260379234160e-19, -2.928534872855398e-21,  1.917037894808715e-23, -1.217229334003896e-25,  4.632110059087542e-03, -8.038928538808676e-05,  1.122853906069594e-06,
 -1.298204644771126e-08,  1.330151510909533e-10, -1.244661712664254e-12,  1.083966291969867e-14, -8.898995555856443e-17,  6.950115088359672e-19, -5.199126219246813e-21,
  3.744938700666810e-23, -2.608145128822539e-25,  2.209366312904647e-03, -4.797637804732257e-05,  7.797599685162701e-07, -1.033321140866034e-08,  1.198781973874148e-10,
 -1.259015312652192e-12,  1.222368753305049e-14, -1.112642573840808e-16,  9.590546954951510e-19, -7.886988359316752e-21,  6.223922466017318e-23, -4.734404997807937e-25,
  9.614973050169976e-04, -2.566521004259991e-05,  4.826566885902894e-07, -7.289440403765703e-09,  9.526322865729226e-11, -1.117732536016304e-12,  1.204580313339946e-14,
 -1.210722839279137e-16,  1.147317357644771e-18, -1.033398135021291e-20,  8.902412600601967e-23, -7.370966392899909e-25,  3.819503867220946e-04, -1.234282822386766e-05,
  2.672297322612438e-07, -4.576942398150478e-09,  6.709072802952230e-11, -8.759970888344833e-13,  1.044132201730110e-14, -1.154894560735031e-16,  1.199305155410264e-18,
 -1.179476447074096e-20,  1.105930073048237e-22, -9.938374678447690e-25,  1.385749733301483e-04, -5.350637027625424e-06,  1.327463279656307e-07, -2.567281551095774e-09,
  4.205468097570404e-11, -6.090312315917225e-13,  8.004173023313902e-15, -9.714811598162879e-17,  1.102527930746391e-18, -1.180858099577807e-20,  1.202132662080343e-22,
 -1.169678781082515e-24,  4.595029588075886e-05, -2.096073159353042e-06,  5.932741786114093e-08, -1.290667937963658e-09,  2.355140283960252e-11, -3.772110608815573e-13,
  5.451882372811819e-15, -7.243245407535798e-17,  8.962999667669248e-19, -1.043169235772043e-20,  1.150561246327942e-22, -1.209669820340927e-24,  1.393818125480205e-05,
 -7.438076365759212e-07,  2.391830983188284e-08, -5.833453230850718e-10,  1.182400810072382e-11, -2.089264610318020e-13,  3.313272667818315e-15, -4.808397058581869e-17,
  6.474814176512373e-19, -8.173474297802235e-21,  9.749482150175009e-23, -1.105679720105829e-24,  3.871932416356588e-06, -2.396645322293082e-07,  8.721382211783339e-09,
 -2.377341431796609e-10,  5.339232840415996e-12, -1.038530002872114e-13,  1.803550078798465e-15, -2.853897842834838e-17,  4.174775720067232e-19, -5.706773783427941e-21,
  7.350500077946537e-23, -8.978664226299750e-25,  9.864313266454250e-07, -7.029184454286459e-08,  2.883967734420786e-09, -8.761996157652917e-11,  2.175514882995407e-12,
 -4.649135817789320e-14,  8.826231389491406e-16, -1.520424236910037e-17,  2.412607549783305e-19, -3.566301260431963e-21,  4.953589264089226e-23, -6.508911340958202e-25,
  2.308813189226922e-07, -1.881522223126209e-08,  8.673410224012497e-10, -2.929572499653382e-11,  8.025099817204557e-13, -1.880953081724736e-14,  3.897710328982817e-16,
 -7.299181175093029e-18,  1.254769569096089e-19, -2.003290599716574e-21,  2.997249560207722e-23, -4.231807589777738e-25,  4.975589656680808e-08, -4.609818355867462e-09,
  2.379822456154956e-10, -8.915358630207067e-12,  2.689447736730939e-13, -6.902837053121595e-15,  1.559166240819064e-16, -3.170269272637846e-18,  5.897406807525269e-20,
 -1.015848989066141e-21,  1.635495275137663e-23, -2.478844057732711e-25,  9.899455299197674e-09, -1.037209512781210e-09,  5.978315454849852e-11, -2.478559662050567e-12,
  8.219648449393125e-14, -2.306916467840106e-15,  5.672704429642101e-17, -1.250982414565452e-18,  2.515655741162831e-20, -4.670875792145428e-22,  8.084888577841549e-24,
 -1.314322168725463e-25,  1.824489051984766e-09, -2.151407220015071e-10,  1.380491907486881e-11, -6.320938268030471e-13,  2.300716234734450e-14, -7.051416874445536e-16,
  1.885516277404802e-17, -4.505132352305869e-19,  9.784583777026838e-21, -1.956583058312619e-22,  3.638160507015257e-24, -6.338773477334708e-26,  3.127665996299674e-10,
 -4.132453294284715e-11,  2.943936882324372e-12, -1.485746712783585e-13,  5.926313394286451e-15, -1.980992077486429e-16,  5.753901397203671e-18, -1.488133936330290e-19,
  3.487690484752317e-21, -7.505134273554474e-23,  1.498054195069646e-24, -2.795366227050874e-26,  5.012311714582976e-11, -7.389954557805849e-12,  5.829476784786831e-13,
 -3.236545521017994e-14,  1.412629937269055e-15, -5.143706200232515e-17,  1.621157735434524e-18, -4.534258346064378e-20,  1.145782588488300e-21, -2.651279229051691e-23,
  5.676749506347400e-25, -1.133711310768003e-26,  7.555616513435347e-12, -1.238201036933108e-12,  1.078781316642503e-13, -6.576544793087767e-15,  3.136182099765734e-16,
 -1.242401444951683e-17,  4.244451556131796e-19, -1.282626256236263e-20,  3.491661923416826e-22, -8.681274718614216e-24,  1.992461585521967e-25, -4.255837937838720e-27,
  1.079378850369409e-12, -1.958700188221401e-13,  1.880006560167355e-14, -1.256035813506415e-15,  6.534235940824722e-17, -2.812623111576303e-18,  1.040403446924261e-19,
 -3.393541051198066e-21,  9.943442027607857e-23, -2.654185893546000e-24,  6.524801654565396e-26, -1.489484989963428e-27,  1.474691609063057e-13, -2.952152566643562e-14,
  3.113551424713394e-15, -2.275148583929864e-16,  1.289094090418196e-17, -6.020858637213983e-19,  2.408556367266948e-20, -8.470596435395921e-22,  2.668844751569333e-23,
 -7.641276820376308e-25,  2.010292282665410e-26, -4.900541968620931e-28,  1.948137920552603e-14, -4.285952387137010e-15,  4.953578919356653e-16, -3.950534223045684e-17,
  2.433543624576920e-18, -1.231410427795616e-19,  5.320085705315454e-21, -2.014871470289025e-22,  6.818523789425958e-24, -2.091804626530175e-25,  5.883507075291450e-27,
 -1.530092577192143e-28,  2.521427849558273e-15, -6.072185369241071e-16,  7.668610071020719e-17, -6.659085738415527e-18,  4.450762352588359e-19, -2.435685290069485e-20,
  1.134657058476030e-21, -4.620968330200187e-23,  1.677343655401348e-24, -5.506650367191965e-26,  1.653856198563002e-27, -4.583177470882957e-29,  3.247737148316401e-16,
 -8.525536471603765e-17,  1.172774259306833e-17, -1.105907494747281e-18,  8.001410415123640e-20, -4.725769185091246e-21,  2.369288754682258e-22, -1.035763292176187e-23,
  4.026030507016549e-25, -1.412198618943493e-26,  4.522195320542208e-28, -1.333443555810402e-29,  4.240528455026510e-17, -1.207870962357502e-17,  1.803368223571630e-18,
 -1.841032609185195e-19,  1.437960446800942e-20, -9.142960412824023e-22,  4.921862831440168e-23, -2.304647651209778e-24,  9.573209251828160e-26, -3.580796168215872e-27,
  1.220281879561624e-28, -3.821645367096134e-30,  5.733640969505056e-18, -1.763229505175984e-18,  2.845577876915511e-19, -3.133681814045597e-20,  2.633626080557623e-21,
 -1.797256892830622e-22,  1.035894896537598e-23, -5.181510173789663e-25,  2.294216634982820e-26, -9.128399466033807e-28,  3.302752710429780e-29, -1.096062614232628e-30,
  8.224840491466044e-19, -2.715560291806269e-19,  4.714824569391813e-20, -5.577019896316081e-21,  5.023420511717778e-22, -3.665761791706378e-23,  2.254305796653966e-24,
 -1.200527734311846e-25,  5.647939915367823e-27, -2.383175674670299e-28,  9.127498148399676e-30, -3.200599244236951e-31,  1.285542288016755e-19, -4.528641076270661e-20,
  8.412555032383293e-21, -1.063435247622191e-21,  1.021734378845671e-22, -7.936950710263120e-24,  5.185380057532093e-25, -2.928017406627581e-26,  1.457859574129208e-27,
 -6.498796217996769e-29,  2.625080613342843e-30, -9.691463582958473e-32,  2.251466160962776e-20, -8.403968916174437e-21,  1.659653718776795e-21, -2.228600810161727e-22,
  2.270952626340773e-23, -1.867703161319966e-24,  1.289571751833565e-25, -7.682323233836216e-27,  4.028633322486179e-28, -1.888409363535296e-29,  8.008558970040905e-31,
 -3.099285681057600e-32,  4.539652445695600e-21, -1.781741495320386e-21,  3.713110490303330e-22, -5.259111174639513e-23,  5.645393497063390e-24, -4.883738934920657e-25,
  3.541454133161933e-26, -2.212384992479654e-27,  1.214832218269280e-28, -5.954229826738001e-30,  2.636686094979927e-31, -1.063958985848666e-32,  1.076862226535245e-21,
 -4.406890189721793e-22,  9.609917732364085e-23, -1.423957878262647e-23,  1.597537079479065e-24, -1.442625091951826e-25,  1.090621486179164e-26, -7.094019172641162e-28,
  4.050853083188323e-29, -2.062194707816570e-30,  9.473915115606817e-32, -3.961280030562296e-33,  3.024400615219988e-22, -1.278832877127494e-22,  2.890586274412366e-23,
 -4.439454691686995e-24,  5.158611322399538e-25, -4.820359486746576e-26,  3.767146905110120e-27, -2.530514223941878e-28,  1.490777471430296e-29, -7.822199218905447e-31,
  3.700474037546470e-32, -1.591727129555595e-33,  9.687880432328643e-23, -4.191878260134907e-23,  9.719850560877299e-24, -1.531437892183310e-24,  1.824681347731297e-25,
 -1.747176369233951e-26,  1.398200450146597e-27, -9.610752477983278e-29,  5.789601574577826e-30, -3.104233384655364e-31,  1.499627220383498e-32, -6.582493578750168e-34,
  2.818209626909646e-23, -1.235315366228936e-23,  2.905997177618201e-24, -4.645397372614295e-25,  5.614147876117613e-26, -5.450674832037258e-27,  4.421088198681868e-28,
 -3.078857760823397e-29,  1.878369653233306e-30, -1.019572459536162e-31,  4.984413932776705e-33, -2.213169214127406e-34,  6.147596481918222e-02, -1.559440487285090e-04,
  4.090907621457067e-07, -1.104497322714181e-09,  3.048870464693405e-12, -8.558678460727794e-15,  2.427174318778042e-17, -6.939954616121176e-20,  1.986795886393332e-22,
 -5.719905544641897e-25,  1.634774243414238e-27, -4.726639348793544e-30,  5.591407174695152e-02, -1.693055616038431e-04,  6.159017340025911e-07, -2.369025187356616e-09,
  9.107666466146412e-12, -3.445333605879293e-14,  1.279576805918167e-16, -4.674448587852891e-19,  1.682580464143968e-21, -5.981924305362923e-24,  2.102120411330959e-26,
 -7.317925739623516e-29,  4.625481550259319e-02, -1.856314314469236e-04,  9.471378277731643e-07, -4.731292973219355e-09,  2.253083356549719e-11, -1.031615316725568e-13,
  4.579263838010469e-16, -1.981701356870124e-18,  8.392459883142778e-21, -3.487933538235158e-23,  1.425600142081098e-25, -5.740330536420448e-28,  3.480344075041752e-02,
 -1.913455786559841e-04,  1.271663439246948e-06, -7.725510030717470e-09,  4.378127566205807e-11, -2.359400684137769e-13,  1.222048381847777e-15, -6.124450759741196e-18,
  2.984246492279366e-20, -1.418968206245453e-22,  6.602883121062638e-25, -3.013720728000557e-27,  2.381949946232639e-02, -1.784102054060313e-04,  1.464912036967770e-06,
 -1.055255008908780e-08,  7.000380270668119e-11, -4.371847836743679e-13,  2.601762213017286e-15, -1.487599108322634e-17,  8.220922112890857e-20, -4.410957408700445e-22,
  2.305994996812387e-24, -1.177893962920028e-26,  1.482903546416988e-02, -1.483023311494857e-04,  1.461012307610966e-06, -1.232295969643637e-08,  9.459142511321754e-11,
 -6.766605823324191e-13,  4.575580595762165e-15, -2.953357860749662e-17,  1.832530081894451e-19, -1.098895124072902e-21,  6.394745824587364e-24, -3.622961584353704e-26,
  8.398457678583866e-03, -1.095489127644918e-04,  1.274172195905220e-06, -1.247212567080232e-08,  1.097518736664126e-10, -8.913270473155613e-13,  6.791465194728828e-15,
 -4.909808005788541e-17,  3.395015540815199e-19, -2.259001580835950e-21,  1.453180795314863e-23, -9.070870027114443e-26,  4.327580638780647e-03, -7.199521632988313e-05,
  9.790609026083957e-07, -1.103961907111954e-08,  1.105338971367119e-10, -1.012060402974640e-12,  8.633109812132544e-15, -6.947621542634767e-17,  5.322525677729050e-19,
 -3.907777723406170e-21,  2.763937922723924e-23, -1.890971237256572e-25,  2.029195270633361e-03, -4.220350073788299e-05,  6.664876702944278e-07, -8.601663054261415e-09,
  9.739609778875099e-11, -9.998097919828636e-13,  9.498463796839644e-15, -8.467490534220691e-17,  7.153312165882875e-19, -5.769106510561019e-21,  4.467121871849781e-23,
 -3.335805961665350e-25,  8.660394374564494e-04, -2.212954041027906e-05,  4.036388728985272e-07, -5.929440364894161e-09,  7.554504579363904e-11, -8.654855104960660e-13,
  9.118405366875584e-15, -8.968202092262329e-17,  8.322745324024937e-19, -7.346257650698237e-21,  6.205483598276476e-23, -5.040647788295051e-25,  3.365310143939492e-04,
 -1.040768313775631e-05,  2.182102527578609e-07, -3.631060978427473e-09,  5.183562587892861e-11, -6.602369379867277e-13,  7.686697817478168e-15, -8.313047640901388e-17,
  8.447963929047489e-19, -8.136389926850978e-21,  7.475914460081006e-23, -6.587019122359028e-25,  1.191162617174839e-04, -4.401319278076139e-06,  1.056056830315683e-07,
 -1.982272058305378e-09,  3.159377640926019e-11, -4.459480581941672e-13,  5.720126095910239e-15, -6.783304661824315e-17,  7.528505161857727e-19, -7.891611519021757e-21,
  7.867956634799336e-23, -7.502008827600638e-25,  3.842549324669343e-05, -1.677530269544423e-06,  4.587265387823243e-08, -9.677254062878350e-10,  1.716674201344479e-11,
 -2.677798112496927e-13,  3.774636412753182e-15, -4.896592104640474e-17,  5.921908117607972e-19, -6.741650276965071e-21,  7.278372792759737e-23, -7.495148773170189e-25,
  1.130546393029758e-05, -5.775372143006293e-07,  1.792821807357637e-08, -4.236877917424045e-10,  8.342647193419001e-12, -1.434699935825338e-13,  2.217619259562817e-15,
 -3.140573188677000e-17,  4.130936450006705e-19, -5.098154874162433e-21,  5.949746864007051e-23, -6.606132759353682e-25,  3.036608476823095e-06, -1.799962653955755e-07,
  6.319532155586271e-09, -1.668178461805926e-10,  3.637362891726240e-12, -6.881860065291820e-14,  1.164241622470772e-15, -1.796858896616930e-17,  2.566366026149838e-19,
 -3.428255393315350e-21,  4.318527929299612e-23, -5.162624556168079e-25,  7.454991574645058e-07, -5.089796981942934e-08,  2.014060754538227e-09, -5.922984433029545e-11,
  1.427084994872399e-12, -2.965085663520718e-14,  5.481212111577355e-16, -9.205486870118880e-18,  1.425643656345288e-19, -2.058657394807803e-21,  2.795624974362984e-23,
 -3.593978470739044e-25,  1.675456560380839e-07, -1.309000905323243e-08,  5.818934564912603e-10, -1.901893275289838e-11,  5.053994679943600e-13, -1.151301176872045e-14,
  2.322259487952990e-16, -4.238553639476492e-18,  7.109199548275081e-20, -1.108467594791811e-21,  1.621008070392541e-23, -2.238704472593104e-25,  3.453771149889538e-08,
 -3.070051649475685e-09,  1.528452681513680e-10, -5.540117527821210e-12,  1.620914523943844e-13, -4.042553097597547e-15,  8.886163292584111e-17, -1.760627615498316e-18,
  3.194910099052310e-20, -5.373646207694016e-22,  8.454735857921333e-24, -1.253269214812112e-25,  6.546258047391311e-09, -6.586367273671962e-10,  3.661935655208175e-11,
 -1.469002345371121e-12,  4.724691947839258e-14, -1.288388653554614e-15,  3.082878544224339e-17, -6.624053144402661e-19,  1.299299650583833e-20, -2.355387263108650e-22,
  3.983984320905551e-24, -6.333807351268331e-26,  1.144365414360697e-09, -1.297149692450602e-10,  8.032381169798444e-12, -3.559415708875207e-13,  1.256630441647852e-14,
 -3.742338527104370e-16,  9.737877524465348e-18, -2.267040019247812e-19,  4.802747208671013e-21, -9.376981606388254e-23,  1.703885629734412e-24, -2.903365150049020e-26,
  1.852123059834892e-10, -2.355124044415159e-11,  1.620138788158871e-12, -7.916458950302269e-14,  3.063674841288097e-15, -9.953114565267822e-17,  2.813752388775527e-18,
 -7.091758372301018e-20,  1.621480860543160e-21, -3.407330259598181e-23,  6.647244427013810e-25, -1.213269132655807e-26,  2.788506444812649e-11, -3.962004865637359e-12,
  3.020521155981420e-13, -1.624636557920064e-14,  6.883009622211202e-16, -2.436768982741501e-17,  7.477558732606133e-19, -2.038756149882911e-20,  5.027487848785100e-22,
 -1.136341917518709e-23,  2.378656984836818e-25, -4.647918914209483e-27,  3.928463726878424e-12, -6.213599211239707e-13,  5.237389141936985e-14, -3.095632201137423e-15,
  1.433891045182231e-16, -5.526049233241322e-18,  1.839056785225950e-19, -5.420075645270497e-21,  1.440530775660607e-22, -3.499981456265034e-24,  7.856556596222480e-26,
 -1.642592165314889e-27,  5.216380526099387e-13, -9.151741739648106e-14,  8.508783834579173e-15, -5.517229549487800e-16,  2.790324185263309e-17, -1.169350251401678e-18,
  4.216590819076726e-20, -1.342236766130215e-21,  3.842085774878195e-23, -1.002792613655381e-24,  2.412437303901191e-26, -5.393494266168565e-28,  6.586775825903785e-14,
 -1.277257737869524e-14,  1.306795811925121e-15, -9.279203072810555e-17,  5.116807038658441e-18, -2.329018728801184e-19,  9.090578750998515e-21, -3.122723981246157e-22,
  9.619367964938931e-24, -2.695088048561734e-25,  6.943805883787306e-27, -1.658980856289185e-28,  7.995591761259663e-15, -1.707512987190252e-15,  1.917730945627657e-16,
 -1.488380626031075e-17,  8.934780160506642e-19, -4.411353691955792e-20,  1.861637389304350e-21, -6.893935112773399e-23,  2.283228839069461e-24, -6.860899967663645e-26,
  1.891600565836325e-27, -4.825691352574751e-29,  9.454308414476528e-16, -2.215252228658769e-16,  2.723891407046753e-17, -2.305808869261265e-18,  1.504206024291130e-19,
 -8.043491996091213e-21,  3.665063309772232e-22, -1.461325323634607e-23,  5.197594508203442e-25, -1.673300120169925e-26,  4.931780125543880e-28, -1.342122995576529e-29,
  1.106396251357840e-16, -2.832990967899341e-17,  3.802591117676386e-18, -3.502456836981451e-19,  2.477818079695877e-20, -1.432376221485529e-21,  7.035322618682077e-23,
 -3.015615516183813e-24,  1.150221073214277e-25, -3.961893529986682e-27,  1.246667292274422e-28, -3.614524972670854e-30,  1.305935598269731e-17, -3.638290431816070e-18,
  5.313129854327588e-19, -5.309762081582350e-20,  4.063499551081196e-21, -2.533715017744704e-22,  1.338665768830373e-23, -6.156703431531116e-25,  2.513670598520070e-26,
 -9.247459620548397e-28,  3.101422311325531e-29, -9.564617134449822e-31,  1.589782884677184e-18, -4.795588273637896e-19,  7.589835550045621e-20, -8.202038190807814e-21,
  6.769425028247532e-22, -4.540053917024047e-23,  2.573512577958954e-24, -1.266819566105409e-25,  5.523450060423352e-27, -2.165413966670737e-28,  7.723775386378288e-30,
 -2.528300380882987e-31,  2.047918980014609e-19, -6.652254034315051e-20,  1.135845622584529e-20, -1.321912330343983e-21,  1.172219430762750e-22, -8.426547572589929e-24,
  5.107780940577696e-25, -2.682690007021724e-26,  1.245369725551647e-27, -5.187904418882440e-29,  1.962549145079727e-30, -6.800423741695468e-32,  2.873057621803081e-20,
 -9.987688163682531e-21,  1.829929748150798e-21, -2.282263183721930e-22,  2.164430870078536e-23, -1.660442071935576e-24,  1.071825793261517e-25, -5.982620763425062e-27,
  2.945767588899718e-28, -1.299156419023866e-29,  5.193834164085369e-31, -1.898552061643800e-32,  4.527268221906776e-21, -1.672573228108723e-21,  3.267410006901812e-22,
 -4.341012974774666e-23,  4.378130126744249e-24, -3.565106468236433e-25,  2.438125011644396e-26, -1.439148131233856e-27,  7.480370687109397e-29, -3.476617390213088e-30,
  1.462333493281994e-31, -5.614637546255357e-33,  8.262698423761017e-22, -3.218776463546665e-22,  6.654342273290309e-23, -9.350812268234393e-24,  9.961010733612933e-25,
 -8.553610419675470e-26,  6.158622738111366e-27, -3.821045003487505e-28,  2.084335359151289e-29, -1.015108432391848e-30,  4.467676843656351e-32, -1.792202515368750e-33,
  1.792499671924905e-22, -7.299034698278209e-23,  1.583093899307835e-23, -2.333246128324439e-24,  2.604082881258088e-25, -2.339768260852193e-26,  1.760297798040546e-27,
 -1.139654942282557e-28,  6.478438301170337e-30, -3.283729720413707e-31,  1.502274370231236e-32, -6.256147880289022e-34,  4.673213916600439e-23, -1.970268577001023e-23,
  4.439269186522339e-24, -6.796363010387252e-25,  7.872917499309137e-26, -7.334668108555450e-27,  5.715521058967552e-28, -3.828583874818488e-29,  2.249422906767644e-30,
 -1.177219446926434e-31,  5.555152063793390e-33, -2.383736494357806e-34,  1.416786830044890e-23, -6.121842296340993e-24,  1.417313699053742e-24, -2.229661829282773e-25,
  2.652614591931706e-26, -2.536236924344452e-27,  2.026786992126019e-28, -1.391237941427376e-29,  8.369845633282986e-31, -4.481947092004411e-32,  2.162506689556893e-33,
 -9.480808225832370e-35,  3.991861670053457e-24, -1.748882095491570e-24,  4.111795813959020e-25, -6.569171490697320e-26,  7.934619553826071e-27, -7.699312409784178e-28,
  6.241597147678241e-29, -4.344369235712819e-30,  2.649075719677229e-31, -1.437186649199225e-32,  7.022574916498165e-34, -3.116664021051497e-35,  6.085865128853574e-02,
 -1.527235220168568e-04,  3.961239378591771e-07, -1.057053781477383e-09,  2.883368349468897e-12, -7.998775031690250e-15,  2.241455641413732e-17, -6.335904123089776e-20,
  1.792165088660633e-22, -5.105775862700615e-25,  1.440198968109597e-27, -4.132629455602185e-30,  5.524652731200453e-02, -1.644896349622075e-04,  5.883255571253870e-07,
 -2.228652543957836e-09,  8.448280043691394e-12, -3.153352231899470e-14,  1.155917679688152e-16, -4.168916798786913e-19,  1.481621761817215e-21, -5.202065070915579e-24,
  1.805252172338441e-26, -6.208447613979469e-29,  4.552709285366364e-02, -1.782754555181950e-04,  8.924590695216061e-07, -4.386726679533329e-09,  2.057316281980515e-11,
 -9.280792504945587e-14,  4.060173704240034e-16, -1.732180116214096e-18,  7.233641461693640e-21, -2.965146262119463e-23,  1.195545707251808e-25, -4.749783385159589e-28,
  3.405783426394306e-02, -1.815315356739987e-04,  1.183009608065059e-06, -7.061222902028976e-09,  3.934241396112828e-11, -2.085653563802378e-13,  1.063200133537964e-15,
 -5.246375408090521e-18,  2.517928975635046e-20, -1.179569604024066e-22,  5.409259578109924e-25, -2.433634366714787e-27,  2.312852127176275e-02, -1.671790336409825e-04,
  1.344723874367421e-06, -9.499182566326033e-09,  6.185226751886880e-11, -3.794576153704348e-13,  2.219798269703062e-15, -1.248253091849060e-17,  6.787238727199482e-20,
 -3.584399508369072e-22,  1.844967194427879e-24, -9.281137780778802e-27,  1.425830080582063e-02, -1.371809969951932e-04,  1.321789558816343e-06, -1.091206572005441e-08,
  8.209264635790954e-11, -5.761421504095088e-13,  3.825125227514326e-15, -2.425603507504726e-17,  1.479371817927815e-19, -8.723466420781568e-22,  4.993702473960056e-24,
 -2.784004281777582e-26,  7.979741329361538e-03, -9.992564423372523e-05,  1.134482053031200e-06, -1.085029820063843e-08,  9.344996966341079e-11, -7.436725175043739e-13,
  5.557346734231452e-15, -3.943039428230918e-17,  2.677451682129882e-19, -1.750337072096632e-21,  1.106709518829286e-23, -6.792557622636879e-26,  4.054466241990493e-03,
 -6.466403394516922e-05,  8.565635069219358e-07, -9.422377186445193e-09,  9.221648504487839e-11, -8.264078944453023e-13,  6.906508010904108e-15, -5.449690891030696e-17,
  4.096187595916090e-19, -2.952276356197309e-21,  2.050817726576177e-23, -1.378597171020424e-25,  1.870426837200421e-03, -3.725943052468445e-05,  5.719958904128587e-07,
 -7.191670970061863e-09,  7.950008705889480e-11, -7.978910403487038e-13,  7.419114338705954e-15, -6.478924285657996e-17,  5.365577511254293e-19, -4.244662791898327e-21,
  3.225644265757848e-23, -2.365077131371168e-25,  7.835562275715375e-04, -1.916573662820318e-05,  3.392029996495884e-07, -4.848109511134627e-09,  6.023492971445993e-11,
 -6.739956899454961e-13,  6.943589547735388e-15, -6.684187255689330e-17,  6.076136744377258e-19, -5.256942512925078e-21,  4.355105801700657e-23, -3.471252850559221e-25,
  2.981343445121952e-04, -8.823134908178582e-06,  1.792084160699123e-07, -2.898045137641920e-09,  4.030186459629208e-11, -5.008845827384852e-13,  5.697287316272152e-15,
 -6.025870486624466e-17,  5.993886526634118e-19, -5.654527620112144e-21,  5.092217577424899e-23, -4.399958116337652e-25,  1.030613185473360e-04, -3.643661763782505e-06,
  8.457960346130012e-08, -1.541264234414012e-09,  2.390682971423018e-11, -3.289769162781613e-13,  4.119351662563119e-15, -4.773917978119191e-17,  5.182537294759286e-19,
 -5.317796780066378e-21,  5.193368379189213e-23, -4.853354152929786e-25,  3.238188053416505e-05, -1.352707718050095e-06,  3.574597877279927e-08, -7.314104946401983e-10,
  1.261618738898616e-11, -1.917053793273680e-13,  2.636067270861158e-15, -3.339586516415807e-17,  3.948109098539045e-19, -4.397178280211209e-21,  4.647600253901705e-23,
 -4.688496105734227e-25,  9.252904330926193e-06, -4.523799526929322e-07,  1.355877906483012e-08, -3.105429895138162e-10,  5.941303573217248e-12, -9.946017965614191e-14,
  1.498705897302966e-15, -2.071538137848266e-17,  2.662057825382660e-19, -3.212447567452300e-21,  3.668578029220019e-23, -3.988503379737626e-25,  2.406328072728281e-06,
 -1.365534290762814e-07,  4.625972145061716e-09, -1.182685617179644e-10,  2.504008329414018e-12, -4.608938259984018e-14,  7.596826870553760e-16, -1.143740722836513e-17,
  1.595156991505062e-19, -2.082637384979725e-21,  2.566069302472620e-23, -3.002590671898291e-25,  5.701247229764974e-07, -3.728117506207368e-08,  1.422829582522728e-09,
 -4.050503985874411e-11,  9.471383794266300e-13, -1.913494399640472e-14,  3.444712342406730e-16, -5.640963268214540e-18,  8.527227084486305e-20, -1.203008716436245e-21,
  1.597351410311714e-23, -2.009309734608962e-25,  1.232237321930521e-07, -9.226016940742165e-09,  3.954668788006276e-10, -1.250795835982226e-11,  3.224474017314757e-13,
 -7.139507336591492e-15,  1.401883353142067e-16, -2.493984517077090e-18,  4.081711437752596e-20, -6.215818475922734e-22,  8.885334831059767e-24, -1.200389942830739e-25,
  2.433697816021414e-08, -2.074593618838198e-09,  9.959065272560480e-11, -3.492477864617121e-12,  9.910300327883895e-14, -2.401700162362588e-15,  5.137852455283876e-17,
 -9.919676687557251e-19,  1.756018687009604e-20, -2.884007434045688e-22,  4.434577117964791e-24, -6.429156999830046e-26,  4.401832094914847e-09, -4.250681879184919e-10,
  2.279152222159897e-11, -8.845444309408624e-13,  2.758889448177819e-14, -7.309401578851819e-16,  1.701882030794927e-17, -3.562825036990515e-19,  6.816467865667679e-21,
 -1.206461684578681e-22,  1.994087702726032e-24, -3.100321026152192e-26,  7.311397937374748e-10, -7.961898849502606e-11,  4.756362410929143e-12, -2.039414737986043e-13,
  6.982603553092545e-15, -2.020347808441748e-16,  5.115352002300688e-18, -1.160259373641001e-19,  2.397466483092583e-21, -4.570009902276676e-23,  8.114539830264993e-25,
 -1.352195180181490e-26,  1.119164448849528e-10, -1.368712896276760e-11,  9.088520662964396e-13, -4.298418978860507e-14,  1.613597447162644e-15, -5.093900812615740e-17,
  1.401383882735452e-18, -3.441551594640654e-20,  7.675744593143218e-22, -1.574908035641841e-23,  3.002577985025580e-25, -5.360056002582039e-27,  1.585757538531403e-11,
 -2.169745330870026e-12,  1.597874818339959e-13, -8.322956413357766e-15,  3.421716125382959e-16, -1.177489054822282e-17,  3.517233466747913e-19, -9.346381178188612e-21,
  2.248737089711480e-22, -4.963940394331972e-24,  1.015680662708137e-25, -1.941512587804520e-27,  2.091415673671511e-12, -3.190215550481955e-13,  2.599998559543353e-14,
 -1.489291845404827e-15,  6.697977278606076e-17, -2.510357939052302e-18,  8.135942087938529e-20, -2.337934642804141e-21,  6.064935493357649e-23, -1.439659113511433e-24,
  3.160021793971573e-26, -6.465439134722513e-28,  2.585326410615496e-13, -4.381494404286118e-14,  3.943444244267064e-15, -2.480312517851940e-16,  1.218932125905131e-17,
 -4.971236984895783e-19,  1.746814713822162e-20, -5.424790135577273e-22,  1.516483119538952e-23, -3.869027863311764e-25,  9.106116446053551e-27, -1.993313796452929e-28,
  3.021374174919312e-14, -5.670018068195464e-15,  5.623546478485676e-16, -3.877879539222818e-17,  2.079987316392073e-18, -9.221961736319630e-20,  3.510500407770682e-21,
 -1.177382310543345e-22,  3.544600662315705e-24, -9.714499202304462e-26,  2.450345357062863e-27, -5.735714914057601e-29,  3.373941655509224e-15, -6.987486036814520e-16,
  7.619945699282121e-17, -5.751325743129715e-18,  3.362457759579121e-19, -1.618923035414233e-20,  6.670113863211167e-22, -2.414019757751934e-23,  7.821090899912210e-25,
 -2.300995356382705e-26,  6.216162888882950e-28, -1.555013228727488e-29,  3.647612438068542e-16, -8.307396937504141e-17,  9.937048736780738e-18, -8.194062114664446e-19,
  5.213766777011589e-20, -2.722502019360253e-21,  1.212682668820997e-22, -4.731238966199526e-24,  1.648071054494860e-25, -5.200491587107469e-27,  1.503471477900305e-28,
 -4.016184850121976e-30,  3.879447443557729e-17, -9.679602218803364e-18,  1.266621761023026e-18, -1.138624304396887e-19,  7.870591445560478e-21, -4.450229373728626e-22,
  2.140013203549724e-23, -8.988775771846219e-25,  3.362420353587570e-26, -1.136700961685003e-27,  3.512928749521688e-29, -1.001005112717775e-30,  4.138349372847425e-18,
 -1.126520506798494e-18,  1.607630163598458e-19, -1.571437798689407e-20,  1.177412580124513e-21, -7.194385701263956e-23,  3.728116223344784e-24, -1.683035319588349e-25,
  6.749973140470377e-27, -2.440972392870063e-28,  8.052405757366949e-30, -2.444138114314226e-31,  4.531182036108444e-19, -1.339420256735568e-19,  2.077036059580885e-20,
 -2.200774596252838e-21,  1.782372837272961e-22, -1.173937180727078e-23,  6.539923631717903e-25, -3.166127250890594e-26,  1.358550594786378e-27, -5.244740478987018e-29,
  1.843228974023902e-30, -5.948236912171479e-32,  5.232070781304119e-20, -1.670542993651554e-20,  2.802703821314074e-21, -3.206681975817404e-22,  2.797316688721939e-23,
 -1.979468425747927e-24,  1.181878289604188e-25, -6.118050995215088e-27,  2.800839451317944e-28, -1.151223681013879e-29,  4.299153906836035e-31, -1.471319542456478e-32,
  6.570743223998422e-21, -2.252273083828722e-21,  4.066835337686271e-22, -5.000474763884971e-23,  4.677714590653761e-24, -3.541509693600609e-25,  2.257294997791116e-26,
 -1.244714533557524e-27,  6.057516486426395e-29, -2.641605862221111e-30,  1.044689367069544e-31, -3.779159663608965e-33,  9.283339032958097e-22, -3.392235351194794e-22,
  6.550790018319978e-23, -8.605393079941492e-24,  8.584626527374639e-25, -6.917266091894075e-26,  4.682975671178524e-27, -2.737436613037495e-28,  1.409598648200236e-29,
 -6.492564651664514e-31,  2.707312307793128e-32, -1.030842201467218e-33,  1.527319536905087e-22, -5.902205657763069e-23,  1.209799180863566e-23, -1.685773238283799e-24,
  1.781180182874495e-25, -1.517521001706617e-26,  1.084368383702381e-27, -6.678938142766853e-29,  3.617796825138565e-30, -1.750065719862051e-31,  7.652401627026755e-33,
 -3.050613262752072e-34,  3.016836321345178e-23, -1.221885108682532e-23,  2.634849993368324e-24, -3.861191739788723e-25,  4.285466703027768e-26, -3.829842857779731e-27,
  2.866443105922106e-28, -1.846556364262855e-29,  1.044652399492553e-30, -5.270578474675401e-32,  2.400509046271452e-33, -9.954044013665737e-35,  7.270365202377230e-24,
 -3.055655230973510e-24,  6.861210702296154e-25, -1.046853369923284e-25,  1.208657940203799e-26, -1.122413820531250e-27,  8.719297449166361e-29, -5.823242857729620e-30,
  3.411501837828462e-31, -1.780429280362968e-32,  8.379137615928328e-34, -3.586263294435156e-35,  2.078978700587604e-24, -8.969756792326622e-25,  2.073236551986852e-25,
 -3.256171151495780e-26,  3.867618877512330e-27, -3.692163648696739e-28,  2.946065369570133e-29, -2.019298138312539e-30,  1.213116272889302e-31, -6.487213648653345e-33,
  3.125901217080474e-34, -1.368705738109174e-35,  5.661393840488844e-25, -2.478997225847533e-25,  5.824873805211617e-26, -9.300426172259742e-27,  1.122688208788309e-27,
 -1.088757444782846e-28,  8.821187144963258e-30, -6.136436957953964e-31,  3.739799230044125e-32, -2.027857681646865e-33,  9.903687407009996e-35, -4.393120376611340e-36,
  6.025401593880618e-02, -1.496044967904931e-04,  3.837109097100673e-07, -1.012171055042022e-09,  2.728631922615828e-12, -7.481482863686415e-15,  2.071810626479412e-17,
 -5.790743353787344e-20,  1.618302649962614e-22, -4.564505993869940e-25,  1.269861810722020e-27, -3.622872818534446e-30,  5.459781578563275e-02, -1.598877548661230e-04,
  5.623724270000926e-07, -2.098378569752977e-09,  7.844433083268394e-12, -2.889420613582536e-14,  1.045553774237081e-16, -3.723419773817828e-19,  1.306713124461151e-21,
 -4.531741122390887e-24,  1.553140929610281e-26, -5.277985186912485e-29,  4.482794470381843e-02, -1.713408876506210e-04,  8.417337908331963e-07, -4.071891927851641e-09,
  1.881065101702187e-11, -8.362031814293874e-14,  3.606028758535909e-16, -1.516899228244733e-18,  6.247461389866702e-21, -2.526224166227569e-23,  1.004959044281711e-25,
 -3.939952548637900e-28,  3.335011432260938e-02, -1.723960046255703e-04,  1.101918510170911e-06, -6.463776678951513e-09,  3.541483051388782e-11, -1.847240664442974e-13,
  9.269721635355280e-16, -4.504606090796362e-18,  2.129782226766323e-20, -9.831778357439988e-23,  4.443987983418806e-25, -1.971100664905578e-27,  2.248062179514240e-02,
 -1.568609381344627e-04,  1.236430121265391e-06, -8.567479453576082e-09,  5.476877601214636e-11, -3.301425937427675e-13,  1.898851460052521e-15, -1.050359451767551e-17,
  5.620410115458642e-20, -2.922015551523195e-22,  1.481083596292926e-24, -7.338918083326465e-27,  1.372992654224248e-02, -1.271089749176234e-04,  1.198360959171328e-06,
 -9.685999810891978e-09,  7.143546706505565e-11, -4.919819283703750e-13,  3.207772542814238e-15, -1.998823932983422e-17,  1.198513936700190e-19, -6.950983129478023e-22,
  3.914967915320936e-24, -2.148132902695059e-26,  7.597400294197470e-03, -9.134626882713896e-05,  1.012781336781035e-06, -9.467198184367466e-09,  7.982562162250595e-11,
 -6.226319491070280e-13,  4.564349590990087e-15, -3.179082509065646e-17,  2.120301936299142e-19, -1.362106634378133e-21,  8.466746998981378e-24, -5.110556272667028e-26,
  3.808832847352798e-03, -5.823991721059222e-05,  7.518301510675636e-07, -8.070625969141976e-09,  7.722954802065180e-11, -6.775743065893949e-13,  5.549189655259642e-15,
 -4.294244217579788e-17,  3.167491736058964e-19, -2.241546999797936e-21,  1.529593053742159e-23, -1.010468746162830e-25,  1.730023487019100e-03, -3.300819245036360e-05,
  4.928309723364375e-07, -6.038241230413485e-09,  6.518537059550989e-11, -6.397940594413482e-13,  5.824085411883616e-15, -4.983431962012544e-17,  4.046676864767440e-19,
 -3.140808067227047e-21,  2.342909745358737e-23, -1.687032777772373e-25,  7.119739226882712e-04, -1.666940664012168e-05,  2.863910831419907e-07, -3.983734438075925e-09,
  4.828053458556654e-11, -5.277748255583304e-13,  5.318011967742440e-15, -5.011777875257745e-17,  4.463577899307597e-19, -3.786038474454837e-21,  3.076752179830267e-23,
 -2.406795363929667e-25,  2.655034177574219e-04, -7.518327413866415e-06,  1.479928563641490e-07, -2.326464521629665e-09,  3.152530668376684e-11, -3.824041434718343e-13,
  4.250565125766553e-15, -4.397713876278338e-17,  4.282574976929025e-19, -3.958117701022160e-21,  3.494307377972505e-23, -2.961417615338339e-25,  8.973137138345242e-05,
 -3.034970234299989e-06,  6.817859837402655e-08, -1.206442524918431e-09,  1.821664687388042e-11, -2.444423625644826e-13,  2.988685830012021e-15, -3.385553680074551e-17,
  3.595716677662439e-19, -3.612359783927879e-21,  3.456284091037569e-23, -3.166326725815309e-25,  2.749188488762399e-05, -1.098686528303744e-06,  2.806400531347906e-08,
 -5.570809239358295e-10,  9.345795356507496e-12, -1.383675120227118e-13,  1.856402677581536e-15, -2.297271217127239e-17,  2.655336808144764e-19, -2.893763912117299e-21,
  2.994875978627519e-23, -2.960147450637146e-25,  7.638820739229335e-06, -3.573391447585089e-07,  1.034281519227660e-08, -2.296226161666880e-10,  4.269362623091182e-12,
 -6.958652897054563e-14,  1.022385977490784e-15, -1.379506364645187e-17,  1.732237087388094e-19, -2.044327804672716e-21,  2.284839509752817e-23, -2.432737209943417e-25,
  1.926018171125597e-06, -1.046055737556081e-07,  3.419649777914053e-09, -8.468743251566007e-11,  1.741315410453972e-12, -3.118594370670707e-14,  5.009026157664909e-16,
 -7.357661605089961e-18,  1.002191634624187e-19, -1.279020946061027e-21,  1.541638800838253e-23, -1.765868991854034e-25,  4.410156437192349e-07, -2.761157117114869e-08,
  1.016385956595837e-09, -2.801185319226801e-11,  6.357574261567206e-13, -1.249065503267843e-14,  2.190037443790309e-16, -3.497318362745434e-18,  5.160971695490836e-20,
 -7.114257531797766e-22,  9.237302333638181e-24, -1.137066841519223e-25,  9.180740608799527e-08, -6.584730536401857e-09,  2.721473956335098e-10, -8.329645446204174e-12,
  2.083293210492848e-13, -4.483828970580645e-15,  8.571388041756744e-17, -1.486432353946020e-18,  2.373973314677911e-20, -3.531189370080868e-22,  4.934505797866952e-24,
 -6.521705537238005e-26,  1.740036456453683e-08, -1.421809260489447e-09,  6.580340867098052e-11, -2.232517221692855e-12,  6.144157175616394e-14, -1.446912853773576e-15,
  3.012492482978344e-17, -5.667913409938637e-19,  9.788468040687542e-21, -1.569849690173657e-22,  2.359159918084379e-24, -3.345292848363593e-26,  3.008290698350383e-09,
 -2.786720107744419e-10,  1.440668763389826e-11, -5.408748318667977e-13,  1.635872628676062e-14, -4.210734330363249e-16,  9.539755605200139e-18, -1.945797267843774e-19,
  3.631129112732253e-21, -6.274770434109730e-23,  1.013456608690443e-24, -1.540932377564567e-26,  4.755911148816009e-10, -4.972667926696021e-11,  2.864977908027688e-12,
 -1.188410377504871e-13,  3.945530243624294e-15, -1.109038256816400e-16,  2.732073607292405e-18, -6.037133677539705e-20,  1.216670615768914e-21, -2.264170103701171e-23,
  3.928319092140422e-25, -6.401454539356194e-27,  6.897349228150367e-11, -8.107654658415655e-12,  5.194586799007627e-13, -2.377314522262855e-14,  8.654851084336847e-16,
 -2.654502268303991e-17,  7.105753576308659e-19, -1.700140217606310e-20,  3.698391749482883e-22, -7.408617433170043e-24,  1.380218419793312e-25, -2.409593924282392e-27,
  9.213724071818308e-12, -1.213183656691311e-12,  8.626271458956716e-14, -4.349762946317416e-15,  1.734817550393737e-16, -5.801509945408251e-18,  1.686533875326931e-19,
 -4.367114522111165e-21,  1.025006235106755e-22, -2.209411727780116e-24,  4.418260817897806e-26, -8.260943012595518e-28,  1.139582904573749e-12, -1.675120189269443e-13,
  1.319286718797954e-14, -7.320290263013512e-16,  3.195446742221290e-17, -1.164343129315719e-18,  3.673875187454987e-20, -1.029091322868409e-21,  2.605095036613530e-23,
 -6.040224948003884e-25,  1.296159209601746e-26, -2.594726358864358e-28,  1.313613954284192e-13, -2.148717097147278e-14,  1.870876250829951e-15, -1.140844094364641e-16,
  5.445596557496256e-18, -2.160504530284420e-19,  7.395200087693969e-21, -2.239825836054038e-22,  6.113015198360444e-24, -1.524115387739419e-25,  3.508487995768543e-27,
 -7.517617970086572e-29,  1.422970857393593e-14, -2.581993429629391e-15,  2.480652566203949e-16, -1.660231215001195e-17,  8.657331537414237e-19, -3.737066842606336e-20,
  1.386812457303291e-21, -4.539427338502699e-23,  1.335142862311866e-24, -3.578136749515150e-26,  8.832899750760706e-28, -2.025086635379265e-29,  1.463651464673021e-15,
 -2.936782945675913e-16,  3.107182602838597e-17, -2.279168427140755e-18,  1.296944850088263e-19, -6.086036876591016e-21,  2.446850427757062e-22, -8.650638384319402e-24,
  2.740498038874411e-25, -7.890707650355461e-27,  2.087907472568359e-28, -5.119676422029414e-30,  1.448138396052141e-16, -3.202513596648483e-17,  3.723392482827736e-18,
 -2.988565187590287e-19,  1.853488333346315e-20, -9.445340216194747e-22,  4.110464347175227e-23, -1.568374634422395e-24,  5.347851407537482e-26, -1.653254084738310e-27,
  4.686151654532000e-29, -1.228226647271855e-30,  1.400442720016588e-17, -3.401388706482868e-18,  4.335202243968811e-19, -3.800429032455755e-20,  2.564900940632963e-21,
 -1.417551524842326e-22,  6.669705090153370e-24, -2.743638050431075e-25,  1.005965641847990e-26, -3.335966466646450e-28,  1.012052156270525e-29, -2.832883473632671e-31,
  1.349987149210527e-18, -3.586958668551841e-19,  4.997628532257700e-20, -4.774133761867350e-21,  3.499410602259905e-22, -2.093891997053977e-23,  1.063502932650164e-24,
 -4.709720602507133e-26,  1.854355000268806e-27, -6.588007794309003e-29,  2.136518996483434e-30, -6.379350339027843e-32,  1.328406019855664e-19, -3.844118542553323e-20,
  5.835211371864666e-21, -6.057004376386282e-22,  4.809814415102400e-23, -3.108773168037474e-24,  1.700891192594823e-25, -8.093081477971510e-27,  3.415410592854670e-28,
 -1.297633960235205e-29,  4.490862143841618e-31, -1.427958001988865e-32,  1.372663589289870e-20, -4.303888663324096e-21,  7.088577157228279e-22, -7.966522990896357e-23,
  6.831142534150727e-24, -4.754957391469705e-25,  2.794544570864821e-26, -1.424848260818367e-27,  6.428667609488908e-29, -2.605635055536359e-30,  9.600348122021466e-32,
 -3.243293329088380e-33,  1.539225590865685e-21, -5.197816820930059e-22,  9.241907985317558e-23, -1.119435818877265e-23,  1.032156594711563e-24, -7.706774572966248e-26,
  4.847146383253088e-27, -2.638827230060549e-28,  1.268517694655306e-29, -5.466832794590848e-31,  2.137540427230751e-32, -7.648455216476455e-34,  1.943076304649749e-22,
 -7.017574703259247e-23,  1.338656750201251e-23, -1.737544570757392e-24,  1.713387701809256e-25, -1.365302567305970e-26,  9.144611000466253e-28, -5.290758605196520e-29,
  2.697571586072377e-30, -1.230726939468064e-31,  5.085193067346102e-33, -1.919290536424013e-34,  2.869704145300109e-23, -1.099480711466826e-23,  2.233147327974574e-24,
 -3.083903224504093e-25,  3.230215612575351e-26, -2.729091933030143e-27,  1.934453576739111e-28, -1.182282478291187e-29,  6.356518504480557e-31, -3.052909013768067e-32,
  1.325741257544405e-33, -5.250103212401392e-35,  5.137529568086522e-24, -2.068850604950173e-24,  4.433587933939576e-25, -6.457348863510681e-26,  7.124313930363829e-27,
 -6.330356728371888e-28,  4.711779117590548e-29, -3.019179131842612e-30,  1.699300208971785e-31, -8.531242358193753e-33,  3.867167948283077e-34, -1.596269707896753e-35,
  1.139391711342876e-24, -4.772582900693026e-25,  1.067695168946043e-25, -1.623087616924385e-26,  1.867290312619381e-27, -1.728084104095688e-28,  1.337980443838103e-29,
 -8.907216984366565e-31,  5.202146494889967e-32, -2.706890270342930e-33,  1.270285432319685e-34, -5.421863028770401e-36,  3.061761478000374e-25, -1.318881909500241e-25,
  3.043023157146071e-26, -4.770859723742727e-27,  5.656970417609076e-28, -5.391311184418148e-29,  4.294896716648614e-30, -2.939215013678444e-31,  1.763100552515559e-32,
 -9.414538491429098e-34,  4.530059255918868e-35, -1.980837941676625e-36,  8.039864402244243e-26, -3.518479461771684e-26,  8.262083109588634e-27, -1.318341287678624e-27,
  1.590413643945237e-28, -1.541394669293563e-29,  1.248096124129637e-30, -8.677252407531123e-32,  5.285253654378261e-33, -2.864264520081624e-34,  1.398096077229982e-35,
 -6.198469265136845e-37,  5.966166143421897e-02, -1.465826627345966e-04,  3.718219539673632e-07, -9.696835060695941e-10,  2.583846237891668e-12, -7.003134873212795e-15,
  1.916679590096541e-17, -5.298228098122678e-20,  1.462751515012548e-22, -4.087107546681026e-25,  1.120309954356360e-27, -3.186180473492945e-30,  5.396710620368204e-02,
 -1.554874069863316e-04,  5.379263117200675e-07, -1.977357834765658e-09,  7.290821574959003e-12, -2.650540547421165e-14,  9.469151301125776e-17, -3.330219346554340e-19,
  1.154215413109494e-21, -3.954531020569490e-24,  1.338601324380270e-26, -4.496114941945075e-29,  4.415574648956049e-02, -1.647974757573523e-04,  7.946232054710547e-07,
 -3.783844581273744e-09,  1.722146230194090e-11, -7.545374984473644e-14,  3.207971819583654e-16, -1.330788349721063e-18,  5.406388175120514e-21, -2.156862600648298e-23,
  8.466803254983991e-26, -3.276144673610258e-28,  3.267768299198971e-02, -1.638815581255860e-04,  1.027634897471950e-06, -5.925528008669566e-09,  3.193299062675118e-11,
 -1.639164210960200e-13,  8.098760332270692e-16, -3.876438708382486e-18,  1.805850464175101e-20, -8.216151680130899e-23,  3.661068132836482e-25, -1.601145281912734e-27,
  2.187233018538697e-02, -1.473663252827209e-04,  1.138668032275064e-06, -7.741622208467247e-09,  4.859883687154812e-11, -2.879054585327297e-13,  1.628426859282291e-15,
 -8.862540149479135e-18,  4.667776388991722e-20, -2.389430593441294e-22,  1.192869702659002e-24, -5.823162913543739e-27,  1.323995476033865e-02, -1.179683063384702e-04,
  1.088675106047483e-06, -8.617749287834975e-09,  6.232250603957718e-11, -4.213001383507837e-13,  2.698238625028811e-15, -1.652490365788000e-17,  9.743286324070664e-20,
 -5.558827648720068e-22,  3.081016868307021e-24, -1.664141267548441e-26,  7.247529665442753e-03, -8.367764025653866e-05,  9.064457660117021e-07, -8.283946851363624e-09,
  6.840010327470463e-11, -5.230456516006103e-13,  3.762266022861648e-15, -2.572922593848824e-17,  1.685848911519046e-19, -1.064466552492464e-21,  6.506004720503023e-24,
 -3.862763256680824e-26,  3.587317448483492e-03, -5.259264446085523e-05,  6.619718473658159e-07, -6.936518067262478e-09,  6.491809165806726e-11, -5.577475970876200e-13,
  4.477367736830169e-15, -3.398769286605474e-17,  2.460732012745287e-19, -1.710175616621439e-21,  1.146600087132381e-23, -7.445219080493261e-26,  1.605440914881320e-03,
 -2.933857522815814e-05,  4.262309742930049e-07, -5.090497116908556e-09,  5.368138719837518e-11, -5.153954138054265e-13,  4.594227615404302e-15, -3.852676849948744e-17,
  3.068197057653761e-19, -2.336856645275874e-21,  1.711484760891585e-23, -1.210493636475278e-25,  6.495933257049885e-04, -1.455712434233242e-05,  2.428940959835280e-07,
 -3.289204785554191e-09,  3.889553029081582e-11, -4.154860148361772e-13,  4.095773026638631e-15, -3.779683409346809e-17,  3.298777675380794e-19, -2.743724948931581e-21,
  2.187638023334926e-23, -1.679820759095162e-25,  2.376325648358269e-04, -6.438027191046452e-06,  1.228661988360477e-07, -1.878093938593500e-09,  2.480509705402674e-11,
 -2.937409335668572e-13,  3.191428371298522e-15, -3.230659289073984e-17,  3.080707838336537e-19, -2.790086774265163e-21,  2.415101511377645e-23, -2.007939743252725e-25,
  7.859719376958537e-05, -2.542843503014717e-06,  5.530055090710502e-08, -9.504900693195288e-10,  1.397454232222344e-11, -1.829004074810744e-13,  2.184024176298164e-15,
 -2.418819909471138e-17,  2.513830892307464e-19, -2.473101554029740e-21,  2.318684064077409e-23, -2.082657083182594e-25,  2.350715477253167e-05, -8.985679246531716e-07,
  2.219219095044149e-08, -4.274688330362914e-10,  6.976461661342199e-12, -1.006610910123081e-13,  1.317976472016106e-15, -1.593452297047370e-17,  1.801110605676704e-19,
 -1.920973702437145e-21,  1.947033606556773e-23, -1.885859409195307e-25,  6.359008035336484e-06, -2.845549611204825e-07,  7.955260567364354e-09, -1.712343401171913e-10,
  3.094687512364224e-12, -4.912020840183987e-14,  7.038103810709960e-16, -9.272060618256723e-18,  1.137875278308466e-19, -1.313513603604953e-21,  1.436983574699876e-23,
 -1.498593543123506e-25,  1.556485147224131e-06, -8.088321653439583e-08,  2.551923154457352e-09, -6.122699089274536e-11,  1.222832708175663e-12, -2.131270130253478e-14,
  3.336321161751092e-16, -4.782056838813058e-18,  6.362489291939366e-20, -7.938415131308596e-22,  9.361581542808137e-24, -1.049857456989298e-25,  3.449238838185469e-07,
 -2.066940948986851e-08,  7.338741666453866e-10, -1.958287507245225e-11,  4.314459276306231e-13, -8.244381739260772e-15,  1.408065753695788e-16, -2.193039677589957e-18,
  3.159651275043319e-20, -4.256245835885115e-22,  5.404754895021045e-24, -6.511162275507751e-26,  6.926163805970173e-08, -4.756862496243180e-09,  1.895587429122426e-10,
 -5.614762547987022e-12,  1.362511945826885e-13, -2.850805620763729e-15,  5.306028941626954e-17, -8.970512675479982e-19,  1.398204645415654e-20, -2.031628436368578e-22,
  2.775566191184535e-24, -3.589000553638566e-26,  1.261729635957322e-08, -9.877992161669109e-10,  4.407053363541398e-11, -1.446495287668484e-12,  3.861074202212921e-14,
 -8.835971040895417e-16,  1.790526758303293e-17, -3.283094151965208e-19,  5.531706005494720e-21, -8.663680699250034e-23,  1.272530502611584e-24, -1.764987049099816e-26,
  2.088532726933921e-09, -1.854984612200872e-10,  9.244468844273141e-12, -3.357075148052467e-13,  9.845415660009880e-15, -2.462051261504374e-16,  5.427608892570957e-18,
 -1.078618747656776e-19,  1.963345988382926e-21, -3.312541109326771e-23,  5.228191605032812e-25, -7.774127387095898e-27,  3.148109822232731e-10, -3.158603172551707e-11,
  1.754601184054163e-12, -7.039880498626829e-14,  2.266125344260411e-15, -6.187632546027891e-17,  1.483004923340097e-18, -3.192426402266740e-20,  6.274689637354064e-22,
 -1.139950632296201e-23,  1.932511613953843e-25, -3.079485507548564e-27,  4.333331171250401e-11, -4.892728438976278e-12,  3.023587390157806e-13, -1.338660894501312e-14,
  4.725531753397988e-16, -1.407927008916501e-17,  3.666707337411078e-19, -8.546418607292210e-21,  1.813155408212247e-22, -3.545789391305267e-24,  6.454482993997037e-26,
 -1.101910042385381e-27,  5.467178650271619e-12, -6.922552508358673e-13,  4.750382168182492e-14, -2.318113158017544e-15,  8.966674934770259e-17, -2.913393812510118e-18,
  8.241043533500925e-20, -2.079061442729427e-21,  4.759604623688302e-23, -1.001666005327660e-24,  1.957423649591146e-26, -3.579347743226491e-28,  6.352636983127766e-13,
 -8.991596359221207e-14,  6.839678680843518e-15, -3.674734113368879e-16,  1.556395093716400e-17, -5.511876686316981e-19,  1.692785899597204e-20, -4.620994086048532e-22,
  1.141268748908445e-23, -2.584203797640088e-25,  5.420319403898077e-27, -1.061463308336877e-28,  6.840216259022571e-14, -1.078992565980552e-14,  9.082910844988744e-16,
 -5.367077153884788e-17,  2.487240831899838e-18, -9.596005078940587e-20,  3.198546393891082e-21, -9.445239218455239e-23,  2.516044553002719e-24, -6.128639160928572e-26,
  1.379521375797154e-27, -2.892695541843805e-29,  6.879103399751105e-15, -1.205796499051209e-15,  1.121404357097257e-16, -7.279930948937850e-18,  3.688672196250271e-19,
 -1.549544343182609e-20,  5.603424085569954e-22, -1.789400096758615e-23,  5.139940636147509e-25, -1.346541300323335e-26,  3.252140927265278e-28, -7.300618253457427e-30,
  6.526639964411964e-16, -1.267512874041069e-16,  1.300080021287763e-17, -9.261501736641490e-19,  5.126552092553507e-20, -2.343421773138100e-21,  9.189189742370550e-23,
 -3.172159128640452e-24,  9.822176824206075e-26, -2.766683244808135e-27,  7.167693849235883e-29, -1.722160895077683e-30,  5.916166072701434e-17, -1.269117988684626e-17,
  1.432960105245168e-18, -1.118705249480566e-19,  6.758139495394884e-21, -3.358936025796086e-22,  1.427334511757155e-23, -5.323401484232241e-25,  1.775965619872957e-26,
 -5.376328517858689e-28,  1.493474312816311e-29, -3.839030188434995e-31,  5.205752086212271e-18, -1.229472728596089e-18,  1.524896782317274e-19, -1.302571502182370e-20,
  8.576923536020731e-22, -4.630202899109459e-23,  2.130246071021178e-24, -8.576932816315115e-26,  3.080733766438872e-27, -1.001638134614762e-28,  2.981502836865966e-30,
 -8.194354151163629e-32,  4.535280187038610e-19, -1.174955911007676e-19,  1.596756611442254e-20, -1.489419657176346e-21,  1.067199132622177e-22, -6.248615384266382e-24,
  3.108585366296079e-25, -1.349571592849465e-26,  5.213414241323107e-28, -1.818599918683701e-29,  5.794888065495864e-31, -1.701219791035973e-32,  4.008310254495689e-20,
 -1.134307949366311e-20,  1.683867438744315e-21, -1.710794063257247e-22,  1.330953604111866e-23, -8.435474007112256e-25,  4.529485117104427e-26, -2.116791544430465e-27,
  8.780407401495153e-29, -3.281142484206351e-30,  1.117576966578635e-31, -3.499482831843090e-33,  3.701112645766608e-21, -1.138433371163278e-21,  1.838985893330608e-22,
 -2.028346808047504e-23,  1.708259751929187e-24, -1.168756673292620e-25,  6.756454509301342e-27, -3.390791601237592e-28,  1.506792960762509e-29, -6.018719812293414e-31,
  2.186638715834802e-32, -7.288070014152193e-34,  3.696720457127801e-22, -1.228718309691386e-22,  2.149409271413184e-23, -2.562614824154499e-24,  2.327120962095782e-25,
 -1.712392327118985e-26,  1.062020536395506e-27, -5.704527030073068e-29,  2.707066618532934e-30, -1.152259336816540e-31,  4.451910458517755e-33, -1.574804710686330e-34,
  4.155533597426359e-23, -1.482178241768243e-23,  2.790763559950095e-24, -3.576531469118314e-25,  3.483779454695768e-26, -2.743470972162299e-27,  1.816841320658579e-28,
 -1.039789790650456e-29,  5.246410874815911e-31, -2.369675217381860e-32,  9.697035797677370e-34, -3.626125825762502e-35,  5.485980176381738e-24, -2.082580389436497e-24,
  4.188804110132264e-25, -5.729406162234123e-26,  5.945850900670479e-27, -4.978800321167526e-28,  3.498961123501981e-29, -2.120908387682121e-30,  1.131303759023487e-31,
 -5.392197933073190e-33,  2.324497130385141e-34, -9.140780866257436e-36,  8.859414588721696e-25, -3.545556582933177e-25,  7.547660959401563e-26, -1.092074237527816e-26,
  1.197206282402638e-27, -1.057258677151355e-28,  7.822863723880464e-30, -4.984205917928003e-31,  2.789962737618581e-32, -1.393325762267766e-33,  6.283943518896880e-35,
 -2.581263375040632e-36,  1.799682882849717e-25, -7.510909946706687e-26,  1.673633623855364e-26, -2.534219864786795e-27,  2.904363651575241e-28, -2.677917555335718e-29,
  2.066014813473907e-30, -1.370674980753151e-31,  7.978836244035202e-33, -4.138526636686095e-34,  1.936180802924736e-35, -8.239770732832259e-37,  4.526726727142099e-26,
 -1.946564700264614e-26,  4.482713962765203e-27, -7.014684440849355e-28,  8.302158200836192e-29, -7.898086054744491e-30,  6.280968081510672e-31, -4.291188626286475e-32,
  2.569928841143730e-33, -1.370141324644428e-34,  6.582883043268507e-36, -2.874296394378449e-37,  1.143368125570499e-26, -5.000699343969596e-27,  1.173471569252158e-27,
 -1.871182726659755e-28,  2.255839611825241e-29, -2.184883030028080e-30,  1.768013936379759e-31, -1.228430108882773e-32,  7.477765472835860e-34, -4.050083443451289e-35,
  1.975784485625783e-36, -8.754796604600647e-38,  5.908120721696181e-02, -1.436539395898224e-04,  3.604292586692541e-07, -9.294379693875531e-10,  2.448266084633070e-12,
 -6.560418179852936e-15,  1.774667146647466e-17, -4.852851203730502e-20,  1.323354477819575e-22, -3.665881239166273e-25,  9.885351304442997e-28, -2.813498459427871e-30,
  5.335361586507915e-02, -1.512769660666020e-04,  5.148808344980018e-07, -1.864825173638502e-09,  6.782705159775114e-12, -2.434065883146202e-14,  8.586330038243240e-17,
 -2.982652583164776e-19,  1.021031996126697e-21, -3.456636710073959e-24,  1.155661895003096e-26, -3.837895852262433e-29,  4.350898945081117e-02, -1.586175424491460e-04,
  7.508218526597727e-07, -3.519967791243881e-09,  1.578645847369484e-11, -6.818290763245482e-14,  2.858449425327892e-16, -1.169580992448498e-18,  4.687559276459506e-21,
 -1.845337306966072e-23,  7.149166158732933e-26, -2.730648536613252e-28,  3.203816051992329e-02, -1.559364609870296e-04,  9.594892664662740e-07, -5.439806470587082e-09,
  2.884056692688091e-11, -1.457192154318144e-13,  7.090006814119433e-16, -3.343197442963853e-18,  1.534815569190558e-20, -6.883414850147256e-23,  3.024216181175793e-25,
 -1.304335864607913e-27,  2.130051331135758e-02, -1.386157842340523e-04,  1.050250691547461e-06, -7.008063656629661e-09,  4.321228965218997e-11, -2.516398715547711e-13,
  1.399957077924890e-15, -7.497752524612808e-18,  3.887634288353243e-20, -1.959821883097120e-22,  9.638117888232573e-25, -4.636000966786879e-27,  1.278486850316549e-02,
 -1.096562240070834e-04,  9.909779993544039e-07, -7.684629917390624e-09,  5.450834740688176e-11, -3.617601363856783e-13,  2.276344442170095e-15, -1.370481635459378e-17,
  7.947365347094574e-20, -4.461256089188586e-22,  2.433750670043307e-24, -1.294229742593888e-26,  6.926717912887651e-03, -7.680586307773812e-05,  8.132748515692026e-07,
 -7.268560919565608e-09,  5.878678674678958e-11, -4.408203756705895e-13,  3.111952558922672e-15, -2.090056054675105e-17,  1.345659085279312e-19, -8.352828548528344e-22,
  5.020822498346516e-24, -2.932713428810530e-26,  3.387035101544158e-03, -4.761297621613039e-05,  5.846157192647072e-07, -5.981537981711129e-09,  5.476499213517025e-11,
 -4.608747097199665e-13,  3.627293497221042e-15, -2.701592555352077e-17,  1.920295866880169e-19, -1.310919860115431e-21,  8.637233341332110e-24, -5.513653042802446e-26,
  1.494539059478715e-03, -2.615921618002353e-05,  3.699767109149008e-07, -4.308415080590983e-09,  4.439413523325298e-11, -4.170427401559809e-13,  3.641171192579101e-15,
 -2.993219722717933e-17,  2.338315434974963e-19, -1.748020970356610e-21,  1.257185525022013e-23, -8.735582041650719e-26,  5.950152991884465e-04, -1.276187236244110e-05,
  2.068997552941660e-07, -2.728352652839949e-09,  3.148887065422917e-11, -3.287799291175328e-13,  3.171523114013509e-15, -2.866571311065063e-17,  2.452222498777208e-19,
 -2.000422377665101e-21,  1.565195938924218e-23, -1.179989467318048e-25,  2.137125489035281e-04, -5.538920020928008e-06,  1.025291778866536e-07, -1.524337955779182e-09,
  1.962833619613641e-11, -2.269742315725212e-13,  2.410995013482533e-15, -2.388498155960345e-17,  2.230783032036151e-19, -1.980136903698257e-21,  1.680898065992395e-23,
 -1.371238234132689e-25,  6.924341300755918e-05, -2.142522129427879e-06,  4.512414519377748e-08, -7.535284015613737e-10,  1.079021184854746e-11, -1.377783436991550e-13,
  1.607169201020212e-15, -1.740595411862923e-17,  1.770499316408311e-19, -1.706028480341894e-21,  1.567643820503582e-23, -1.380797838747349e-25,  2.023796093491483e-05,
 -7.397938506554713e-07,  1.767104811889650e-08, -3.303733276373919e-10,  5.246527806941899e-12, -7.379127526794487e-14,  9.430877166800780e-16, -1.114199859309048e-17,
  1.231805693392069e-19, -1.285998597894584e-21,  1.276746565464961e-23, -1.212032414132622e-25,  5.336155483555520e-06, -2.283594799402668e-07,  6.167867532730228e-09,
 -1.287421949841086e-10,  2.262123333000551e-12, -3.497273994202672e-14,  4.887827528020419e-16, -6.288242104207356e-18,  7.543268183146879e-20, -8.518626214139966e-22,
  9.123652253604504e-24, -9.320942037740878e-26,  1.269559961011991e-06, -6.310389544971704e-08,  1.921818966235976e-09, -4.467834396267580e-11,  8.668903889935257e-13,
 -1.470626384083687e-14,  2.244094562027819e-16, -3.139207222357388e-18,  4.080393937625502e-20, -4.977988789040555e-22,  5.744362993493669e-24, -6.307935671347240e-26,
  2.726504730681260e-07, -1.563247530617366e-08,  5.353994846767959e-10, -1.383421942660349e-11,  2.959134706555164e-13, -5.500426424199985e-15,  9.152110047646474e-17,
 -1.390415294587421e-18,  1.956100308709773e-20, -2.575272432909471e-22,  3.198590689663462e-24, -3.771660865479169e-26,  5.288753208520487e-08, -3.476763511225967e-09,
  1.335829827997493e-10, -3.829391618206027e-12,  9.017022041037160e-14, -1.834270876387864e-15,  3.324384785250350e-17, -5.479718467702597e-19,  8.336408402057192e-21,
 -1.183378510077418e-22,  1.580725591578471e-24, -1.999960894508336e-26,  9.274523953299334e-09, -6.953701473012095e-10,  2.990393139292197e-11, -9.495498526908269e-13,
  2.458377335476594e-14, -5.467449387085261e-16,  1.078404973953473e-17, -1.927163931446737e-19,  3.168163953363941e-21, -4.845954037003139e-23,  6.957266581571756e-25,
 -9.439176591977021e-27,  1.472276129133302e-09, -1.253115914617423e-10,  6.019043012099350e-12, -2.114080155373828e-13,  6.011800437778299e-15, -1.460572322129945e-16,
  3.133092523072371e-18, -6.066544886365066e-20,  1.077125127742296e-21, -1.774395246285410e-23,  2.736747438428379e-25, -3.979853068132984e-27,  2.119505232111724e-10,
 -2.039482527576540e-11,  1.092047616195120e-12, -4.237465160940045e-14,  1.322407858243557e-15, -3.507359225918599e-17,  8.178119996824432e-19, -1.714981718593609e-20,
  3.287385746760932e-22, -5.830348639232516e-24,  9.657440361709969e-26, -1.504857429197095e-27,  2.773947309513407e-11, -3.006536139044959e-12,  1.791441457122857e-13,
 -7.671221488969793e-15,  2.625314359188014e-16, -7.597362917716195e-18,  1.924795610843850e-19, -4.370077911017490e-21,  9.041292802443812e-23, -1.725968318469161e-24,
  3.069671226539186e-26, -5.124350688785074e-28,  3.311408857671740e-12, -4.029219548337949e-13,  2.667227226125202e-14, -1.259200359284114e-15,  4.722762152483972e-17,
 -1.490594136261236e-18,  4.102032513230840e-20, -1.008105958589697e-21,  2.250732213804466e-23, -4.624072350300578e-25,  8.829247603914908e-27, -1.578830871325512e-28,
  3.621359127559488e-13, -4.931742287364467e-14,  3.621409963106503e-15, -1.883200266869742e-16,  7.736444378242597e-18, -2.662153216376456e-19,  7.955935526009446e-21,
 -2.116097210504890e-22,  5.097836301388290e-24, -1.127080054270670e-25,  2.310313853308168e-27, -4.425134317651994e-29,  3.648832383482647e-14, -5.545905589415353e-15,
  4.510808462537586e-16, -2.581593025327571e-17,  1.161052951938888e-18, -4.354460710076002e-20,  1.412952452033824e-21, -4.066865459919138e-23,  1.057096749694055e-24,
 -2.514992030124471e-26,  5.534289518536841e-28, -1.135411658620930e-29,  3.412571618194808e-15, -5.773111387136683e-16,  5.193649975569595e-17, -3.268516509283029e-18,
  1.608446796238401e-19, -6.572621687761238e-21,  2.315155026887717e-22, -7.210213975888175e-24,  2.021982336054134e-25, -5.176482919203638e-27,  1.222808649152110e-28,
 -2.687047210669395e-30,  2.990985450493362e-16, -5.616691349236674e-17,  5.580620381634260e-18, -3.858412471879483e-19,  2.076348585697764e-20, -9.240857453438264e-22,
  3.532545768761126e-23, -1.190181232510731e-24,  3.600480835334359e-26, -9.917700202706071e-28,  2.514767803060161e-29, -5.918402753265314e-31,  2.487056386492392e-17,
 -5.169860440811523e-18,  5.664011745697081e-19, -4.297754179448572e-20,  2.527265748942253e-21, -1.224369889408604e-22,  5.077486985744087e-24, -1.850099976494893e-25,
  6.035993226207105e-27, -1.788525357073795e-28,  4.866944704633527e-30, -1.226490975219400e-31,  1.992917616776037e-18, -4.571955999543185e-19,  5.513072405904156e-20,
 -4.585010323160327e-21,  2.943366147897277e-22, -1.551036321166457e-23,  6.973397791004320e-25, -2.746486544880207e-26,  9.658937663035903e-28, -3.077379316265265e-29,
  8.983314078232376e-31, -2.423078489500721e-32,  1.569660088511942e-19, -3.960659880341262e-20,  5.245010420958729e-21, -4.773055723218682e-22,  3.340486513604719e-23,
 -1.912538981075092e-24,  9.312990885090636e-26, -3.961164425664086e-27,  1.500436375562664e-28, -5.136176333495254e-30,  1.607196251216473e-31, -4.636674412580007e-33,
  1.245526222654342e-20, -3.443129208144794e-21,  4.993681032952620e-22, -4.961462432332108e-23,  3.778422581568058e-24, -2.346438970859075e-25,  1.235629863442754e-26,
 -5.667821321313924e-28,  2.309315351674580e-29, -8.482662057618278e-31,  2.841904880238851e-32, -8.758675437109001e-34,  1.026403040290336e-21, -3.093980627134330e-22,
  4.897115082838027e-23, -5.296254394729569e-24,  4.377292494651630e-25, -2.941400350397042e-26,  1.671326534874493e-27, -8.250275479288183e-29,  3.608589139527550e-30,
 -1.419635126817541e-31,  5.082682959003554e-33, -1.670400498332196e-34,  9.111041869276069e-23, -2.977855247075709e-23,  5.120343721095852e-24, -6.003683699073353e-25,
  5.365298250685328e-26, -3.887833625115332e-27,  2.375989671266038e-28, -1.258349215190517e-29,  5.891114957795806e-31, -2.475129793050652e-32,  9.444122447586827e-34,
 -3.300839569380390e-35,  9.089935707059067e-24, -3.199257263861297e-24,  5.940978304572763e-25, -7.511622022093787e-26,  7.222286088399906e-27, -5.616969357359311e-28,
  3.675500506262677e-29, -2.079473101483498e-30,  1.037714499919062e-31, -4.637681113781515e-33,  1.878562881401209e-34, -6.956350316554588e-36,  1.068100911640610e-24,
 -4.014826979692230e-25,  7.991377169205325e-26, -1.081926872503274e-26,  1.111759161886925e-27, -9.221342088707991e-29,  6.421619719721802e-30, -3.858524013445265e-31,
  2.040906434836029e-32, -9.649339065246848e-34,  4.127476773674997e-35, -1.611013434109143e-36,  1.548336118520685e-25, -6.155179765024128e-26,  1.300933017415751e-26,
 -1.869077567206216e-27,  2.035042710588189e-28, -1.785352943338195e-29,  1.312674219667332e-30, -8.312716315229242e-32,  4.625988198529824e-33, -2.297294581399138e-34,
  1.030500780455854e-35, -4.211100011076973e-37,  2.866647132363173e-26, -1.191679823044808e-26,  2.644031625122323e-27, -3.986652854788985e-28,  4.550154053756746e-29,
 -4.178741509954497e-30,  3.211580930771091e-31, -2.122853631744965e-32,  1.231363379114614e-33, -6.365201063211470e-35,  2.968164788897800e-36, -1.259186555776790e-37,
  6.720715805147593e-27, -2.884634285865032e-27,  6.629362049129134e-28, -1.035265474203638e-28,  1.222840277756420e-29, -1.161082636323443e-30,  9.216352637148666e-32,
 -6.285356128148833e-33,  3.757690587726485e-34, -2.000045160271050e-35,  9.593805821498755e-37, -4.182474630929713e-38,  1.628444763870809e-27, -7.117695498761925e-28,
  1.669053422004495e-28, -2.659506700024770e-29,  3.203947005736744e-30, -3.101020198197617e-31,  2.507662870442945e-32, -1.741200964648040e-33,  1.059236930136844e-34,
 -5.733446193365551e-36,  2.795305522597227e-37, -1.237888857662990e-38,  5.851228861662930e-02, -1.408144624383690e-04,  3.495067804247354e-07, -8.912926908183625e-10,
  2.321209281836077e-12, -6.150337046953128e-15,  1.644522847059462e-17, -4.449753724296698e-20,  1.198210753398803e-22, -3.294257300521805e-25,  8.718837246813882e-28,
 -2.497741742758447e-30,  5.275660692413108e-02, -1.472456223873492e-04,  4.931383623597044e-07, -1.760087205254283e-09,  6.315841314111548e-12, -2.237657656909229e-14,
  7.795120562052217e-17, -2.674972398850571e-19,  9.045224952087779e-22, -3.026443041494584e-24,  9.993470836364824e-27, -3.282850968351115e-29,  4.288627084145109e-02,
 -1.527757334355512e-04,  7.100539161625156e-07, -3.277931816210001e-09,  1.448883556390056e-11, -6.169925267776939e-14,  2.551006345845947e-16, -1.029678981936401e-18,
  4.071943598342044e-21, -1.582014518282877e-23,  6.049682640296536e-26, -2.281267664363444e-28,  3.142936386908177e-02, -1.485140285722941e-04,  8.968870187589130e-07,
 -5.000778794612870e-09,  2.608903781524754e-11, -1.297732234117982e-13,  6.219106137065574e-16, -2.889477984225338e-18,  1.307471996200865e-20, -5.781103758565740e-23,
  2.504720708470594e-25, -1.065501454085350e-27,  2.076233767640130e-02, -1.305387829909579e-04,  9.701419494577163e-07, -6.355172788031204e-09,  3.849917681206458e-11,
 -2.204258323577978e-13,  1.206426778122575e-15, -6.359535920554764e-18,  3.246844730789210e-20, -1.612184669203213e-22,  7.811634193737739e-25, -3.702956195676032e-27,
  1.236153545301880e-02, -1.020829671953919e-04,  9.037657508403583e-07, -6.867535110829663e-09,  4.778980941263682e-11, -3.114595060924828e-13,  1.925927120048169e-15,
 -1.140089874328921e-17,  6.503639609126849e-20, -3.592747723635114e-22,  1.929441634705138e-24, -1.010370351858874e-26,  6.631976170341203e-03, -7.063320981932232e-05,
  7.314173321604781e-07, -6.394636167307690e-09,  5.067224709161969e-11, -3.726959713268583e-13,  2.582764231353740e-15, -1.703920328890934e-17,  1.078199974886617e-19,
 -6.580618520898341e-22,  3.890879433478554e-24, -2.236305702897589e-26,  3.205502594677108e-03, -4.320893923441587e-05,  5.178051732703529e-07, -5.174553305261309e-09,
  4.636018818422799e-11, -3.822439726579630e-13,  2.950231403663922e-15, -2.156386025558493e-17,  1.505119328627446e-19, -1.009477928241903e-21,  6.537406214162135e-24,
 -4.103449811358939e-26,  1.395510631385663e-03, -2.339473562417093e-05,  3.222769554933223e-07, -3.660358122427777e-09,  3.686341045641697e-11, -3.389211685599468e-13,
  2.899016646524123e-15, -2.336644176711785e-17,  1.790989211687943e-19, -1.314373955564543e-21,  9.284690715224680e-24, -6.339331765805658e-26,  5.470823161414496e-04,
 -1.122954444385422e-05,  1.769781477767311e-07, -2.273257600974035e-09,  2.561373908429669e-11, -2.614707909899100e-13,  2.468722477601702e-15, -2.185948325550914e-17,
  1.833280375015496e-19, -1.467077130232033e-21,  1.126668336192782e-23, -8.340803598113927e-26,  1.930885928266577e-04, -4.786841559904359e-06,  8.598123562873793e-08,
 -1.243670188835535e-09,  1.561722461056198e-11, -1.763905580066018e-13,  1.832299150392452e-15, -1.776821738399887e-17,  1.625700898918332e-19, -1.414607778629880e-21,
  1.177859587842069e-23, -9.429756923228901e-26,  6.134192618947107e-05, -1.814959978970686e-06,  3.703309314755212e-08, -6.009886713656221e-10,  8.383971632309405e-12,
 -1.044671704024601e-13,  1.190686397617233e-15, -1.261296906050841e-17,  1.255941343560065e-19, -1.185574371648417e-21,  1.067902894854202e-23, -9.225664794224519e-26,
  1.753829017741547e-05, -6.129609986381155e-07,  1.416524455349802e-08, -2.571042737544141e-10,  3.973905822068900e-12, -5.449495624862918e-14,  6.799834226740025e-16,
 -7.851956804667873e-18,  8.492180762893275e-20, -8.679906239886720e-22,  8.442437434450750e-24, -7.856405778091830e-26,  4.512422483722974e-06, -1.846301635542015e-07,
  4.818955141582408e-09, -9.756178370833541e-11,  1.667012672410214e-12, -2.510804208804857e-14,  3.423547652939842e-16, -4.301945892131420e-18,  5.045282674358852e-20,
 -5.574939723244184e-22,  5.846450097226710e-24, -5.852075369334853e-26,  1.044803569098715e-06, -4.965870065052808e-08,  1.460066387311059e-09, -3.289589823096848e-11,
  6.202013058067455e-13, -1.024276154619620e-14,  1.523850051276577e-16, -2.080782760523209e-18,  2.642706957781234e-20, -3.152920098852303e-22,  3.560715788256000e-24,
 -3.829196318156021e-26,  2.177390731593113e-07, -1.194047968307847e-08,  3.945195212935797e-10, -9.872394436717662e-12,  2.050487232015077e-13, -3.708124739963559e-15,
  6.011793757812607e-17, -8.910251055605517e-19,  1.224195462842640e-20, -1.575378661883829e-22,  1.914086402223736e-24, -2.209423940683078e-26,  4.085804711803092e-08,
 -2.569914456008493e-09,  9.520337750866723e-11, -2.641522255763578e-12,  6.036107473990893e-14, -1.193931858661676e-15,  2.107285336975276e-17, -3.387030808243093e-19,
  5.029851841833936e-21, -6.976172039658594e-23,  9.112121658627040e-25, -1.128156393750686e-26,  6.907789869606674e-09, -4.957783303902666e-10,  2.054951726151276e-11,
 -6.312737265039386e-13,  1.585297168817759e-14, -3.426626739365167e-16,  6.579113161598336e-18, -1.145967082472457e-19,  1.838263723844713e-21, -2.746250912050042e-23,
  3.854111176160640e-25, -5.115301000125809e-27,  1.053313525675654e-09, -8.586969268299093e-11,  3.974691616339757e-12, -1.350171539271785e-13,  3.722883480141228e-15,
 -8.787411476818182e-17,  1.834267322300064e-18, -3.460628567304078e-20,  5.993658579030886e-22, -9.640786198425638e-24,  1.453138137557307e-25, -2.066742202743327e-27,
  1.450688610813035e-10, -1.337984764568308e-11,  6.904092636845425e-13, -2.590559896273423e-14,  7.837232536734921e-16, -2.018990177861162e-17,  4.579863837919278e-19,
 -9.355794166569339e-21,  1.748994625904025e-22, -3.028171590260197e-24,  4.900924267457307e-26, -7.467701214565618e-28,  1.808403700470885e-11, -1.880295339366661e-12,
  1.079903129926390e-13, -4.471684439836010e-15,  1.483416139517335e-16, -4.169184714939150e-18,  1.027455199262401e-19, -2.272138225371900e-21,  4.583964683252292e-23,
 -8.541716804396404e-25,  1.484203855888497e-26, -2.422603753709170e-28,  2.046312450154021e-12, -2.390999779388778e-13,  1.526211310384934e-14, -6.968713804277338e-16,
  2.533747841651041e-17, -7.766872297369307e-19,  2.079115415569037e-20, -4.976820065680364e-22,  1.083511793518099e-23, -2.172886870218306e-25,  4.053499400925047e-27,
 -7.087505283706226e-29,  2.110078966329445e-13, -2.762724027655952e-14,  1.957372602316957e-15, -9.848213357983579e-17,  3.923041665141993e-18, -1.311346303694256e-19,
  3.812734179188525e-21, -9.878870610027253e-23,  2.321016024101219e-24, -5.009626429367760e-26,  1.003395277051612e-27, -1.879482202326842e-29,  1.993159423128927e-14,
 -2.916510305263653e-15,  2.290666322399845e-16, -1.269151083418785e-17,  5.537250779746952e-19, -2.018096889588316e-20,  6.372919431734453e-22, -1.787421536201494e-23,
  4.532365707320816e-25, -1.052988062761284e-26,  2.264725487589549e-28, -4.545005140503596e-30,  1.736607510210576e-15, -2.832812839090591e-16,  2.463527530017302e-17,
 -1.502126006229288e-18,  7.175788684071734e-20, -2.851141538351919e-21,  9.778895156172097e-23, -2.969091019976089e-24,  8.126314447735599e-26, -2.032440510948830e-27,
  4.694544691319093e-29, -1.009532169746378e-30,  1.408364157555096e-16, -2.554801852573103e-17,  2.457016558922407e-18, -1.647661405905784e-19,  8.615148943692793e-21,
 -3.731159505472673e-22,  1.389857423206415e-23, -4.568365594619334e-25,  1.349687047623300e-26, -3.634315878453381e-28,  9.016235110125373e-30, -2.077781147681945e-31,
  1.075750840721579e-17, -2.164623381549834e-18,  2.299167718540383e-19, -1.694359389435771e-20,  9.692392301179543e-22, -4.574309678513966e-23,  1.850294861225415e-24,
 -6.583462699011379e-26,  2.099492017484044e-27, -6.086468826052855e-29,  1.621793584479061e-30, -4.005119309068974e-32,  7.858256935696342e-19, -1.749206066241031e-19,
  2.048811626710270e-20, -1.657609409207542e-21,  1.036678653601622e-22, -5.328964585904760e-24,  2.339872049727783e-25, -9.009657526156657e-27,  3.100683807623864e-28,
 -9.675750389346393e-30,  2.768617996823231e-31, -7.325656577140732e-33,  5.598451973787818e-20, -1.374315412244248e-20,  1.771751543730851e-21, -1.571612706489838e-22,
  1.073492039354313e-23, -6.005435376718199e-25,  2.860413492699225e-26, -1.191208208939000e-27,  4.421724074961573e-29, -1.484486482709170e-30,  4.559250439705976e-32,
 -1.291907258235455e-33,  3.987840663667896e-21, -1.075673090554487e-21,  1.522654458109399e-22, -1.478061025872487e-23,  1.100941129837083e-24, -6.693865291247427e-26,
  3.454461965814328e-27, -1.554212983992272e-28,  6.216254698104373e-30, -2.243115472497851e-31,  7.387585288287536e-33, -2.239721825819757e-34,  2.929882434270511e-22,
 -8.645704530229391e-23,  1.339489938593686e-23, -1.419160106750448e-24,  1.150061488788564e-25, -7.584045824545757e-27,  4.232482477341875e-28, -2.053623620477458e-29,
  8.835208114401342e-31, -3.421135369883816e-32,  1.206337409035499e-33, -3.906966103638917e-35,  2.306569749058403e-23, -7.405629657026632e-24,  1.250461405412151e-24,
 -1.440639458299397e-25,  1.265928024319106e-26, -9.026347610188418e-28,  5.431702447964153e-29, -2.834394118155524e-30,  1.308239932565575e-31, -5.422074328015851e-33,
  2.041917447020103e-34, -7.047538522271146e-36,  2.035862800800160e-24, -7.064247283618247e-25,  1.292664124323209e-25, -1.611179666407493e-26,  1.527931358230188e-27,
 -1.172720887317563e-28,  7.577226306375833e-30, -4.235207676496653e-31,  2.089012712174894e-32, -9.232257042081838e-34,  3.699704523259671e-35, -1.355956694438032e-36,
  2.120131122840834e-25, -7.885180418911392e-26,  1.552101060523725e-26, -2.078520384010928e-27,  2.113452909005268e-28, -1.735325856839724e-29,  1.196779473261998e-30,
 -7.124336620543266e-32,  3.734762468364567e-33, -1.750688104987044e-34,  7.427004745463858e-36, -2.876024202493017e-37,  2.744864452346150e-26, -1.083341773359323e-26,
  2.272125544240070e-27, -3.239754853268070e-28,  3.501654496838145e-29, -3.050412375490173e-30,  2.227648333334454e-31, -1.401538690565439e-32,  7.750891395361196e-34,
 -3.826098887416972e-35,  1.706405986149655e-36, -6.934690980868837e-38,  4.607635599733156e-27, -1.907271184741291e-27,  4.212221902133531e-28, -6.322189142966474e-29,
  7.183877721883134e-30, -6.569327022958259e-31,  5.028137677663762e-32, -3.310475683928656e-33,  1.912958110683860e-34, -9.852451172734748e-36,  4.578195258751997e-37,
 -1.935676266139449e-38,  1.002314344392956e-27, -4.293430240915090e-28,  9.845181605574322e-29, -1.534078525133236e-29,  1.808149805765182e-30, -1.713274664090194e-31,
  1.357231086428886e-32, -9.238190143596258e-34,  5.512783172236453e-35, -2.928950791808136e-36,  1.402535532777238e-37, -6.104302178674072e-39,  2.323007374388966e-28,
 -1.014659771809626e-28,  2.377498799320831e-29, -3.785459656460518e-30,  4.556967544904722e-31, -4.407335308784875e-32,  3.561476180522427e-33, -2.471199697329296e-34,
  1.502306891482471e-35, -8.126363326948204e-37,  3.959431345005461e-38, -1.752333735007684e-39,  5.795455601631018e-02, -1.380605680864660e-04,  3.390301133291588e-07,
 -8.551163676180610e-10,  2.202050668890865e-12, -5.770180185765615e-15,  1.525124118526936e-17, -4.084649113813860e-20,  1.085637662414562e-22, -2.966670698553651e-25,
  7.679716955559318e-28, -2.233744632252670e-30,  5.217538326300900e-02, -1.433833151298884e-04,  4.726091905689219e-07, -1.662514837099261e-09,  5.886427874679143e-12,
 -2.059245393512096e-14,  7.085066397810455e-17, -2.402213398361855e-19,  8.024309211505968e-22, -2.654156167751532e-24,  8.654993594131165e-27, -2.814155005652554e-29,
  4.228628509028136e-02, -1.472487935394211e-04,  6.720699924597481e-07, -3.055659220607296e-09,  1.331381327337090e-11, -5.590859545454476e-14,  2.280114546545556e-16,
 -9.080410936387575e-19,  3.543662111955635e-21, -1.358958596658161e-23,  5.130124862581725e-26, -1.910174305573159e-28,  3.084928765250385e-02, -1.415720657057486e-04,
  8.392991243108968e-07, -4.603333615082267e-09,  2.363651498288152e-11, -1.157728111951977e-13,  5.465631041534481e-16, -2.502540525589932e-18,  1.116311323651057e-20,
 -4.867006788924348e-23,  2.079791460582152e-25, -8.727591028092853e-28,  2.025523617696587e-02, -1.230725490316768e-04,  8.974352513874970e-07, -5.772939408834470e-09,
  3.436636393814228e-11, -1.934961426412926e-13,  1.042074340813905e-15, -5.407681579319560e-18,  2.718986462701809e-20, -1.330012795332868e-22,  6.350501343914629e-25,
 -2.967139581204849e-27,  1.196715965062055e-02, -9.516994167000762e-05,  8.257454363574116e-07, -6.150324725774055e-09,  4.199815112001397e-11, -2.688442247071861e-13,
  1.633995232318594e-15, -9.512608783791555e-18,  5.339087610676177e-20, -2.903033232028333e-22,  1.535040124432145e-24, -7.916900276188072e-27,  6.360678753904041e-03,
 -6.507557624135346e-05,  6.593107371991230e-07, -5.640299113729873e-09,  4.380147198136044e-11, -3.160657865978635e-13,  2.150611972900536e-15, -1.393979313304331e-17,
  8.670928914755933e-20, -5.204561790838682e-22,  3.027503087128583e-24, -1.712509008674839e-26,  3.040575521043731e-03, -3.930282343306502e-05,  4.599207541766109e-07,
 -4.490298137424344e-09,  3.937713400665998e-11, -3.181714834595320e-13,  2.408749725622486e-15, -1.728179961678558e-17,  1.184728088745342e-19, -7.808138028154775e-22,
  4.971048559925075e-24, -3.068661455145965e-26,  1.306823438957022e-03, -2.098268198110491e-05,  2.816795219703620e-07, -3.121201957246181e-09,  3.073092637538031e-11,
 -2.765895592924999e-13,  2.318360290540185e-15, -1.832579844184719e-17,  1.378447158058781e-19, -9.933108202987867e-22,  6.893066065910979e-24, -4.625425191835496e-26,
  5.048323579828178e-04, -9.916246196850846e-06,  1.519952914756998e-07, -1.902250659558227e-09,  2.093046907733254e-11, -2.089491837367425e-13,  1.931428979535097e-15,
 -1.675774700020783e-17,  1.378123173385885e-19, -1.082085145463119e-21,  8.158005421918408e-24, -5.931683059528513e-26,  1.752280695294403e-04, -4.154693348097120e-06,
  7.244733080792733e-08, -1.019786915750729e-09,  1.249171658298336e-11, -1.378416406725694e-13,  1.400568753268095e-15, -1.329739656547370e-17,  1.192116185673334e-19,
 -1.017086409962765e-21,  8.308240688979289e-24, -6.528753785724259e-26,  5.463196273549891e-05, -1.545411516960755e-06,  3.056186202859898e-08, -4.821195998628463e-10,
  6.553976632422949e-12, -7.971118079344999e-14,  8.879178913195817e-16, -9.201740692473187e-18,  8.971493888838919e-20, -8.298076015526597e-22,  7.328288114790332e-24,
 -6.210525183089463e-26,  1.529497377242081e-05, -5.109765663756342e-07,  1.142820209736266e-08, -2.014238493178803e-10,  3.030866954344059e-12, -4.053323408684417e-14,
  4.939042778897948e-16, -5.575456680845230e-18,  5.900229580362238e-20, -5.905313311535810e-22,  5.628092775685621e-24, -5.134960461773113e-26,  3.844183653207213e-06,
 -1.503435151627806e-07,  3.793017263382997e-09, -7.449833191862264e-11,  1.238129828993015e-12, -1.817159141709756e-14,  2.417807806905972e-16, -2.968035835174765e-18,
  3.403763956257759e-20, -3.680733242689032e-22,  3.780169482890453e-24, -3.707865804901932e-26,  8.672488853717673e-07, -3.940284770609022e-08,  1.118688124098258e-09,
 -2.443102422493957e-11,  4.476519576863434e-13, -7.198685091747742e-15,  1.044344665038188e-16, -1.392225939665903e-18,  1.728002288247093e-20, -2.016457755679217e-22,
  2.229026715629258e-24, -2.347862880115369e-26,  1.756110662422697e-07, -9.207591320519050e-09,  2.935206445042992e-10, -7.114269453453249e-12,  1.435020114163611e-13,
 -2.525167351865493e-15,  3.989630645589386e-17, -5.769613378825677e-19,  7.742561049599903e-21, -9.740493739835000e-23,  1.157859288424944e-24, -1.308492089133042e-26,
  3.192188049546754e-08, -1.920313314759895e-09,  6.859270747923467e-11, -1.842219814717824e-12,  4.085673850222074e-14, -7.858908401119870e-16,  1.351002715440537e-17,
 -2.117649299144135e-19,  3.070130263056893e-21, -4.160881680572399e-23,  5.315011434039262e-25, -6.439962139398780e-27,  5.210957008320409e-09, -3.578414001538610e-10,
  1.429503405546356e-11, -4.248551491375896e-13,  1.034963202334142e-14, -2.174384000957726e-16,  4.064228256763077e-18, -6.900637126808408e-20,  1.080212529408355e-21,
 -1.576299613711451e-23,  2.162630248303904e-25, -2.808106791838882e-27,  7.644397586932945e-10, -5.965987799617864e-11,  2.660819069912304e-12, -8.741319694182639e-14,
  2.337111429610066e-15, -5.359669310840212e-17,  1.088704245606026e-18, -2.001461727718787e-20,  3.381567459656941e-22, -5.311240841803070e-24,  7.823858910179953e-26,
 -1.088345368246784e-27,  1.008920810186178e-10, -8.914078239387001e-12,  4.431701662415814e-13, -1.607805462274946e-14,  4.715086718987001e-16, -1.179797939237410e-17,
  2.603562106250411e-19, -5.181062340346588e-21,  9.445958618203299e-23, -1.596576982957170e-24,  2.524766536812227e-26, -3.761916713262463e-28,  1.200043939699011e-11,
 -1.196227900366750e-12,  6.620058575302295e-14, -2.650284019136354e-15,  8.521312567634839e-17, -2.325754650347170e-18,  5.574907854748758e-20, -1.200755680050345e-21,
  2.362151390465173e-23, -4.296322223305876e-25,  7.293221811791396e-27, -1.163952856757112e-28,  1.289513502408579e-12, -1.445864777593528e-13,  8.895831979467329e-15,
 -3.927457280587294e-16,  1.384031925075252e-17, -4.119846272585015e-19,  1.072631586449986e-20, -2.500589000699437e-22,  5.308177717338647e-24, -1.038992866149632e-25,
  1.893489460357257e-27, -3.236997864917280e-29,  1.256115574709516e-13, -1.579948020099517e-14,  1.079507298245728e-15, -5.253158317759025e-17,  2.028549377587799e-18,
 -6.585411295914252e-20,  1.862417226561300e-21, -4.700000696701596e-23,  1.076762840249129e-24, -2.268513590450159e-26,  4.439132813350879e-28, -8.130497867262394e-30,
  1.114414942623496e-14, -1.568571431995016e-15,  1.188959457981006e-16, -6.374453480685045e-18,  2.697007056911192e-19, -9.549053130789139e-21,  2.933871739881004e-22,
 -8.016390553571085e-24,  1.982537754275922e-25, -4.496813255384700e-27,  9.450988419968246e-29, -1.854985918068727e-30,  9.062214791901533e-16, -1.424097724336224e-16,
  1.196366024086234e-17, -7.063985307077248e-19,  3.274334072523999e-20, -1.264495512335732e-21,  4.221473856278440e-23, -1.249175213789289e-24,  3.335836579076104e-26,
 -8.148439037440037e-28,  1.839870375034881e-29, -3.870920251147010e-31,  6.812056295742492e-17, -1.192522532810293e-17,  1.109264231943229e-18, -7.210308677092256e-20,
  3.661127487907249e-21, -1.542249985993534e-22,  5.595540855516154e-24, -1.793590911372945e-25,  5.173186043442325e-27, -1.361238843158379e-28,  3.302996912237203e-30,
 -7.450971435203515e-32,  4.787009662414602e-18, -9.314376117973090e-19,  9.583327473899528e-20, -6.854163963513567e-21,  3.811709720891326e-22, -1.751455390792607e-23,
  6.906644168923033e-25, -2.398491002283475e-26,  7.473234642469969e-28, -2.118753472113922e-29,  5.525923816874621e-31, -1.336811392312309e-32,  3.191649882059691e-19,
 -6.885718474951604e-20,  7.826677598757467e-21, -6.155176975426693e-22,  3.747549046642855e-23, -1.877943570620282e-24,  8.048165018600840e-26, -3.027979263033776e-27,
  1.019228175108326e-28, -3.113572739638544e-30,  8.728832661200337e-32, -2.264632143810672e-33,  2.058271884184713e-20, -4.909965781235650e-21,  6.156062736163357e-22,
 -5.318102880814847e-23,  3.542458591233735e-24, -1.934990876306681e-25,  9.008976011688279e-27, -3.671010801223495e-28,  1.334570563790396e-29, -4.391827084318107e-31,
  1.323182527868297e-32, -3.680761609939346e-34,  1.316221647667430e-21, -3.460264521824412e-22,  4.775701482378655e-23, -4.525083684090299e-24,  3.293819500929065e-25,
 -1.959229707768851e-26,  9.901366112434815e-28, -4.366460758688386e-29,  1.713239973100054e-30, -6.069447841427923e-32,  1.963907801999459e-33, -5.853757429347697e-35,
  8.614803945382457e-23, -2.485721519082990e-23,  3.765805105772351e-24, -3.904815259110196e-25,  3.099999810167335e-26, -2.004554953955128e-27,  1.097911004023283e-28,
 -5.232377859534220e-30,  2.212723564745908e-31, -8.427824367284369e-33,  2.925033070931677e-34, -9.330222262411329e-36,  6.003706201115814e-24, -1.891521781726989e-24,
  3.133269125051281e-25, -3.543602627264149e-26,  3.059142966119094e-27, -2.144566926921468e-28,  1.269753528199019e-29, -6.523777393879317e-31,  2.966619794501538e-32,
 -1.212097452078525e-33,  4.502494046624353e-35, -1.533682638377246e-36,  4.673645330056317e-25, -1.597317812283582e-25,  2.877565683088361e-26, -3.532584786547644e-27,
  3.301571333681110e-28, -2.498878295711328e-29,  1.593128911357103e-30, -8.791220645015371e-32,  4.283305846997858e-33, -1.870792578206949e-34,  7.412556884911778e-36,
 -2.687392416619028e-37,  4.295138414051976e-26, -1.579368827346911e-26,  3.071922825033586e-27, -4.066151979753557e-28,  4.088329054846233e-29, -3.320890365073183e-30,
  2.266736387156823e-31, -1.336072714345330e-32,  6.937830148344202e-34, -3.222636743497552e-35,  1.355239359614387e-36, -5.204174514448332e-38,  4.940644496072011e-27,
 -1.934862146157275e-27,  4.024540667028700e-28, -5.691937384205743e-29,  6.103862591285684e-30, -5.277221305017180e-31,  3.825962173127344e-32, -2.390421350457864e-33,
  1.313164011563076e-34, -6.440776578549463e-36,  2.854894525744357e-37, -1.153378770367602e-38,  7.478265972240005e-28, -3.081275780308623e-28,  6.771106025796468e-29,
 -1.011285108373068e-29,  1.143639413256829e-30, -1.041001227931314e-31,  7.932594309639201e-33, -5.200584925564727e-34,  2.992913943276275e-35, -1.535430538076974e-36,
  7.107947454623023e-38, -2.994431887956495e-39,  1.502110272532521e-28, -6.420298994557200e-29,  1.468707467057746e-29, -2.283111445584990e-30,  2.684787318933374e-31,
 -2.538236921939071e-32,  2.006428349557882e-33, -1.362875274046169e-34,  8.116581502551010e-36, -4.304074173282682e-37,  2.057207113573096e-38, -8.937755115599451e-40,
  3.319430505811472e-29, -1.448828319500168e-29,  3.392063341260744e-30, -5.396449668027089e-31,  6.491089907814278e-32, -6.273047685374663e-33,  5.065271094899390e-34,
 -3.512045366532146e-35,  2.133535647723608e-36, -1.153282095355768e-37,  5.615378179768653e-39, -2.483586056323580e-40,  5.740767407111810e-02, -1.353887824510642e-04,
  3.289763688385071e-07, -8.207872800472317e-10,  2.090216710938293e-12, -5.417491912814360e-15,  1.415461161427417e-17, -3.753759028550731e-20,  9.841361967268387e-23,
 -2.678470361464682e-25,  6.745986339163687e-28, -2.018355782260263e-30,  5.160928761827448e-02, -1.396806719205647e-04,  4.532108117279159e-07, -1.571536630280079e-09,
  5.491052763022494e-12, -1.896993673722580e-14,  6.447005392838027e-17, -2.160078760873520e-19,  7.128256280320037e-22, -2.331506458357026e-24,  7.506332897910225e-27,
 -2.417989048392913e-29,  4.170781580874784e-02, -1.420153669764750e-04,  6.366442482567298e-07, -2.851294676237250e-09,  1.224836903219045e-11, -5.072904674891231e-14,
  2.041030490581424e-16, -8.020913269902817e-19,  3.089435288666679e-21, -1.169616929374800e-23,  4.359316814391627e-26, -1.603011765914951e-28,  3.029608717242026e-02,
 -1.350723750523013e-04,  7.862540616034396e-07, -4.242983425002128e-09,  2.144676009147875e-11, -1.034573478570718e-13,  4.812406683890110e-16, -2.171821436469512e-18,
  9.551925250762538e-21, -4.107062380702987e-23,  1.731283215882159e-25, -7.167713457528264e-28,  1.977687902120148e-02, -1.161611059954889e-04,  8.313357071606838e-07,
 -5.252727870957603e-09,  3.073476427413344e-11, -1.702092759149436e-13,  9.021540416813250e-16, -4.609556379692153e-18,  2.282925956806084e-20, -1.100291044244830e-22,
  5.177951563660413e-25, -2.384934489570617e-27,  1.159923999167538e-02, -8.884816550480898e-05,  7.558025876209115e-07, -5.519325860302066e-09,  3.699280916596916e-11,
 -2.326407635103118e-13,  1.390070879145729e-15, -7.960114002905266e-18,  4.396611182311473e-20, -2.353392951986395e-22,  1.225464810792243e-24, -6.225779921287760e-27,
  6.110512966544970e-03, -6.006037353753747e-05,  5.956322204200217e-07, -4.987368969532338e-09,  3.796623755957874e-11, -2.688378408646719e-13,  1.796485291580992e-15,
 -1.144290402700885e-17,  6.998256050439639e-20, -4.131809475133925e-22,  2.365040452512281e-24, -1.316820289600376e-26,  2.890396204669860e-03, -3.582874513014562e-05,
  4.096171310918490e-07, -3.908187556050310e-09,  3.355471774767302e-11, -2.657644406132805e-13,  1.973968431937840e-15, -1.390453508276584e-17,  9.363956386692390e-20,
 -6.065614058792578e-22,  3.797063102891013e-24, -2.305596788933882e-26,  1.227173642152772e-03, -1.887110629344159e-05,  2.470020550698857e-07, -2.670904222106016e-09,
  2.571642120315680e-11, -2.266391671249795e-13,  1.861974097708585e-15, -1.443744016153002e-17,  1.065943211509521e-19, -7.543687962342185e-22,  5.143654666017971e-24,
 -3.392757710135945e-26,  4.674623650628840e-04, -8.786200805969777e-06,  1.310474452039428e-07, -1.598427448384688e-09,  1.717945229261714e-11, -1.677610248783638e-13,
  1.518516830731114e-15, -1.291282679589376e-17,  1.041520444595369e-19, -8.025587139246699e-22,  5.941023834944238e-24, -4.243423809900172e-26,  1.596954844252635e-04,
 -3.620864978783835e-06,  6.132370500592047e-08, -8.402670188791380e-10,  1.004295395848337e-11, -1.082965176304140e-13,  1.076570669143038e-15, -1.000955316587535e-17,
  8.794519176645339e-20, -7.358360784193879e-22,  5.898043614367712e-24, -4.550109126144734e-26,  4.890503132876252e-05, -1.322389730812479e-06,  2.535652373391430e-08,
 -3.889340164555919e-10,  5.153550184966942e-12, -6.119423196376516e-14,  6.663448995456184e-16, -6.757202394542946e-18,  6.451979423088296e-20, -5.848479231882814e-22,
  5.064895139851492e-24, -4.211460492514025e-26,  1.341969811946033e-05, -4.284525734695728e-07,  9.277277141989989e-09, -1.588207213562790e-10,  2.327118765629093e-12,
 -3.035772539354240e-14,  3.613144910220660e-16, -3.988146110038978e-18,  4.130398446262916e-20, -4.048790130328114e-22,  3.781692904724636e-24, -3.383417019127973e-26,
  3.298277440870532e-06, -1.232642299293727e-07,  3.006853578995090e-09, -5.730661563956593e-11,  9.265815826262536e-13, -1.325430675109703e-14,  1.721235570033432e-16,
 -2.064577288923737e-18,  2.315642950017397e-20, -2.450999376081994e-22,  2.465572478931786e-24, -2.370254016231912e-26,  7.258382582760527e-07, -3.151438929358110e-08,
  8.641467359825448e-10, -1.829641002831655e-11,  3.258815144812611e-13, -5.103700142058201e-15,  7.221417890103146e-17, -9.400418012684381e-19,  1.140427972908557e-20,
 -1.301858415133450e-22,  1.408829824522210e-24, -1.453672865800576e-26,  1.429867859311476e-07, -7.165404162908826e-09,  2.204136357148987e-10, -5.175266799501051e-12,
  1.013972533620219e-13, -1.736464236432739e-15,  2.674064915565968e-17, -3.773829450864469e-19,  4.947234586570099e-21, -6.085316431456450e-23,  7.078079240314784e-25,
 -7.832217950696086e-27,  2.521234878593703e-08, -1.449974525411631e-09,  4.994163140671390e-11, -1.298470116060408e-12,  2.795303982008538e-14, -5.229516386560010e-16,
  8.757168294329098e-18, -1.338813596639508e-19,  1.895152421163709e-21, -2.510102721991991e-23,  3.136003931523963e-25, -3.719051536832291e-27,  3.979601184414961e-09,
 -2.613581469470340e-10,  1.006235551643535e-11, -2.893442665582344e-13,  6.837933895155239e-15, -1.396471490176869e-16,  2.541310831357087e-18, -4.206470156292991e-20,
  6.426341824262371e-22, -9.160742503606092e-24,  1.228773932632006e-25, -1.561075779094411e-27,  5.625305549453069e-10, -4.200657193476288e-11,  1.804976068664898e-12,
 -5.734582223520001e-14,  1.486714970958076e-15, -3.312711995968438e-17,  6.548627621029881e-19, -1.173164085407900e-20,  1.933702316405125e-22, -2.965861324743012e-24,
  4.270032631998973e-26, -5.809871930238880e-28,  7.126448185469006e-11, -6.028162452940516e-12,  2.886900874634075e-13, -1.012588419750827e-14,  2.878468375493694e-16,
 -6.995567457482730e-18,  1.501857251129294e-19, -2.911448804902006e-21,  5.176834324644031e-23, -8.542184792421604e-25,  1.319906333988676e-26, -1.923172800602628e-28,
  8.101909114412482e-12, -7.737728095834932e-13,  4.125022592410009e-14, -1.596357485372229e-15,  4.974189631290788e-17, -1.318316759081192e-18,  3.073513561514844e-20,
 -6.447361045330499e-22,  1.236714887714007e-23, -2.195501244818810e-25,  3.641003951056165e-27, -5.681396723053710e-29,  8.282428596348273e-13, -8.905294903175245e-14,
  5.279191580136934e-15, -2.253059037673347e-16,  7.694044807087332e-18, -2.223735908314572e-19,  5.630442774244273e-21, -1.278240447711808e-22,  2.645463653677321e-24,
 -5.053594644105880e-26,  8.996591663719549e-28, -1.503643463662127e-29,  7.635781477926059e-14, -9.219459374466084e-15,  6.071993428098244e-16, -2.856883438566911e-17,
  1.069167794279686e-18, -3.370196933746063e-20,  9.269303559771109e-22, -2.277982087868234e-23,  5.088178577585729e-25, -1.046215312543100e-26,  1.999928761901119e-28,
 -3.581255334134800e-30,  6.374893561363166e-15, -8.623804793224882e-16,  6.304947253885502e-17, -3.269619921431008e-18,  1.341052661933354e-19, -4.611357455548629e-21,
  1.378111013542822e-22, -3.667521467130009e-24,  8.844428128634821e-26, -1.958186842648041e-27,  4.020940451641453e-29, -7.717203831042919e-31,  4.847418229088844e-16,
 -7.331711791190419e-17,  5.946049202730622e-18, -3.398014222606107e-19,  1.527636534466517e-20, -5.731873496890826e-22,  1.861977203532643e-23, -5.368187164804229e-25,
  1.398295654340794e-26, -3.335036919407230e-28,  7.359417278641763e-30, -1.514496842863649e-31,  3.383565938385600e-17, -5.710537078241566e-18,  5.133765572345658e-19,
 -3.232556470141092e-20,  1.593104523141236e-21, -6.524410636975484e-23,  2.304664381321118e-24, -7.201339191086260e-26,  2.027010240657113e-27, -5.210433959898278e-29,
  1.236180475156094e-30, -2.728889141617982e-32,  2.191137173833009e-18, -4.118270845117318e-19,  4.100956921871108e-20, -2.844575680355817e-21,  1.536925355587086e-22,
 -6.871877463429900e-24,  2.640441080385507e-25, -8.945458097205289e-27,  2.722043206994604e-28, -7.544143163617600e-30,  1.925131956864098e-31, -4.560481269781996e-33,
  1.335227275761985e-19, -2.788807499635952e-20,  3.073341422885081e-21, -2.347515402191614e-22,  1.390435048910061e-23, -6.788011976990601e-25,  2.837692004622636e-26,
 -1.042612687517641e-27,  3.430741808444966e-29, -1.025477282612131e-30,  2.815417759163370e-32, -7.159001254995094e-34,  7.801864163545259e-21, -1.806430462998165e-21,
  2.200493144539889e-22, -1.849701931847034e-23,  1.200603631806572e-24, -6.398632060532793e-26,  2.910078638330797e-27, -1.159564828771682e-28,  4.126180208546243e-30,
 -1.330241638874041e-31,  3.929472457305857e-33, -1.072543092251233e-34,  4.480416274629187e-22, -1.146613003724989e-22,  1.541330410791141e-23, -1.424210478249627e-24,
  1.012221550971566e-25, -5.885588993130209e-27,  2.910626203289831e-28, -1.257263135985939e-29,  4.836194922940538e-31, -1.681035396469672e-32,  5.340933588707128e-34,
 -1.564271556521946e-35,  2.610986091440645e-23, -7.357918947556545e-24,  1.088836378506934e-24, -1.103907154995741e-25,  8.577786451801013e-27, -5.434329762739377e-28,
  2.918851966180481e-29, -1.365315224114737e-30,  5.671446119109584e-32, -2.123408768881999e-33,  7.249307655742324e-35, -2.276102437233796e-36,  1.608156657171805e-24,
 -4.966260869212873e-25,  8.061956167000795e-26, -8.941911230109305e-27,  7.576979497979339e-28, -5.218053130791708e-29,  3.037404329024489e-30, -1.535380777177994e-31,
  6.874016491397285e-33, -2.766915240300281e-34,  1.013166442405406e-35, -3.403971476633059e-37,  1.100920065227184e-25, -3.702306767277277e-26,  6.559959403774990e-27,
 -7.924730546186841e-28,  7.293107633659578e-29, -5.439074522242744e-30,  3.418973249463084e-31, -1.861318675903292e-32,  8.952074685151509e-34, -3.861664777866025e-35,
  1.511953863572027e-36, -5.419223509443957e-38,  8.890925059881872e-27, -3.229594569069583e-27,  6.202037694564349e-28, -8.107862548023426e-29,  8.055111419975558e-30,
 -6.468413579529149e-31,  4.366886200977113e-32, -2.547003402349673e-33,  1.309309133674293e-34, -6.023224231210695e-36,  2.509590130994081e-37, -9.551610457528663e-39,
  9.038404847606853e-28, -3.510028741795582e-28,  7.236057570989632e-29, -1.014487202026260e-29,  1.078760291899332e-30, -9.251335142462566e-32,  6.655234199197972e-33,
 -4.127248236665626e-34,  2.251138559010182e-35, -1.096593458087124e-36,  4.828832419243494e-38, -1.938605247588269e-39,  1.226480814947181e-28, -5.028248781644317e-29,
  1.099003534993478e-29, -1.632673967734755e-30,  1.836857942333974e-31, -1.663729266014543e-32,  1.261761195885950e-33, -8.234328994905927e-35,  4.718074407141529e-36,
 -2.410305657753215e-37,  1.111298543739114e-38, -4.663581071102698e-40,  2.262957645497734e-29, -9.649457149678728e-30,  2.201699314997808e-30, -3.413768982186156e-31,
  4.004356286870151e-32, -3.776663627910930e-33,  2.978460855746511e-34, -2.018620750415424e-35,  1.199607755732284e-36, -6.348176638538818e-38,  3.028199806233048e-39,
 -1.313127984823439e-40,  4.751832461601373e-30, -2.072411458242729e-30,  4.847816587658894e-31, -7.705708031736373e-32,  9.260860812784349e-33, -8.942340145541427e-34,
  7.214802398672600e-35, -4.998519669303876e-36,  3.034247199448979e-37, -1.638952312544600e-38,  7.974419878181607e-40, -3.524509999097790e-41,  };
  int offset = -38;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 38;
    if (std::isnan(t)) {
      fill_n(rr+offset, 38, 0.5);
      fill_n(ww+offset, 38, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 38; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=38; ++j) {
        const int boxof = it*456+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
