//
// Created by zxm on 2024/7/17.
//
#include "global.h"
#include <QDBusMetaType>
/*
<method name="BackupV20">
    <arg type="i" direction="out"/>
    <annotation name="org.qtproject.QtDBus.QtTypeName.In0" value="V20BackupReq"/>
    <arg name="v20BackupReq" type="a(i)" direction="in"/>
</method>
*/

void registerALLMetaType()
{
    V20BackupReq::registerMetaType();
    V20RestoreReq::registerMetaType();
    V20Response::registerMetaType();
    SystemCloneRequest::registerMetaType();
    GhostLogQuery::registerMetaType();
    OperateLogQuery::registerMetaType();
    UserDataBackupRequest::registerMetaType();
    BackupInfo::registerMetaType();
    UserDataRestoreRequest::registerMetaType();
    SystemBackupRequest::registerMetaType();
    SystemRestoreRequest::registerMetaType();
}

// Marshall the V20BackupReq data into a D-Bus argument
QDBusArgument &operator<<(QDBusArgument &arg, const V20BackupReq &req)
{
    arg.beginStructure();
    arg << req.operateID
        << req.userName
        << req.operateType
        << req.backupPath
        << req.language
        << req.actionType;
    arg.endStructure();
    return arg;
}

// Retrieve the V20BackupReq data from the D-Bus argument
const QDBusArgument &operator>>(const QDBusArgument &arg, V20BackupReq &req)
{
    arg.beginStructure();
    arg >> req.operateID
        >> req.userName
        >> req.operateType
        >> req.backupPath
        >> req.language
        >> req.actionType;
    arg.endStructure();
    return arg;
}

void V20BackupReq::registerMetaType()
{
    qRegisterMetaType<V20BackupReq>("V20BackupReq");
    qDBusRegisterMetaType<V20BackupReq>();
}

// V20RestoreReq D-Bus argument
QDBusArgument &operator<<(QDBusArgument &arg, const V20RestoreReq &req)
{
    arg.beginStructure();
    arg << req.operateID
        << req.userName
        << req.operateType
        << req.backupDir
        << req.language
        << req.formatData
        << req.actionType;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, V20RestoreReq &req)
{
    arg.beginStructure();
    arg >> req.operateID
        >> req.userName
        >> req.operateType
        >> req.backupDir
        >> req.language
        >> req.formatData
        >> req.actionType;
    arg.endStructure();
    return arg;
}

void V20RestoreReq::registerMetaType()
{
    qRegisterMetaType<V20RestoreReq>("V20RestoreReq");
    qDBusRegisterMetaType<V20RestoreReq>();
}

// V20Response D-Bus argument
QDBusArgument &operator<<(QDBusArgument &arg, const V20Response &rsp)
{
    arg.beginStructure();
    arg << rsp.operateID
        << rsp.userName
        << rsp.operateType
        << rsp.retCode
        << rsp.progress
        << rsp.errMsg
        << rsp.autoReboot;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, V20Response &rsp)
{
    arg.beginStructure();
    arg >> rsp.operateID
        >> rsp.userName
        >> rsp.operateType
        >> rsp.retCode
        >> rsp.progress
        >> rsp.errMsg
        >> rsp.autoReboot;
    arg.endStructure();
    return arg;
}

void V20Response::registerMetaType()
{
    qRegisterMetaType<V20Response>("V20Response");
    qDBusRegisterMetaType<V20Response>();
}

// SystemCloneRequest D-Bus argument
QDBusArgument &operator<<(QDBusArgument &arg, const SystemCloneRequest &req)
{
    arg.beginStructure();
    arg << req.username
        << req.operateID
        << req.destPath
        << req.destUUID
        << req.relativePath
        << req.operateType
        << req.totalSize;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, SystemCloneRequest &req)
{
    arg.beginStructure();
    arg >> req.username
        >> req.operateID
        >> req.destPath
        >> req.destUUID
        >> req.relativePath
        >> req.operateType
        >> req.totalSize;
    arg.endStructure();
    return arg;
}

void SystemCloneRequest::registerMetaType()
{
    qRegisterMetaType<SystemCloneRequest>("SystemCloneRequest");
    qDBusRegisterMetaType<SystemCloneRequest>();
}


QDBusArgument &operator<<(QDBusArgument &arg, const GhostLogQuery &req)
{
    arg.beginStructure();
    arg << req.mask
        << req.beginTime
        << req.endTime
        << req.operateType
        << req.userName
        << req.orderByTimeDesc;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, GhostLogQuery &req)
{
    arg.beginStructure();
    arg >> req.mask
        >> req.beginTime
        >> req.endTime
        >> req.operateType
        >> req.userName
        >> req.orderByTimeDesc;
    arg.endStructure();
    return arg;
}

void GhostLogQuery::registerMetaType()
{
    qRegisterMetaType<GhostLogQuery>("GhostLogQuery");
    qDBusRegisterMetaType<GhostLogQuery>();
}

QDBusArgument &operator<<(QDBusArgument &arg, const OperateLogQuery &req)
{
    arg.beginStructure();
    arg << req.mask
        << req.beginTime
        << req.endTime
        << req.operateType
        << req.username
        << req.orderByTimeDesc;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, OperateLogQuery &req)
{
    arg.beginStructure();
    arg >> req.mask
        >> req.beginTime
        >> req.endTime
        >> req.operateType
        >> req.username
        >> req.orderByTimeDesc;
    arg.endStructure();
    return arg;
}

void OperateLogQuery::registerMetaType()
{
    qRegisterMetaType<OperateLogQuery>("OperateLogQuery");
    qDBusRegisterMetaType<OperateLogQuery>();
}

QDBusArgument &operator<<(QDBusArgument &arg, const UserDataBackupRequest &req)
{
    arg.beginStructure();
    arg << req.username
        << req.rootUUID
        << req.destUUID
        << req.remark
        << req.operateID
        << req.exclude
        << req.filesFrom
        << req.strTotalSizeBytes;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, UserDataBackupRequest &req)
{
    arg.beginStructure();
    arg >> req.username
        >> req.rootUUID
        >> req.destUUID
        >> req.remark
        >> req.operateID
        >> req.exclude
        >> req.filesFrom
        >> req.strTotalSizeBytes;
    arg.endStructure();
    return arg;
}

void UserDataBackupRequest::registerMetaType()
{
    qRegisterMetaType<UserDataBackupRequest>("UserDataBackupRequest");
    qDBusRegisterMetaType<UserDataBackupRequest>();
}

QDBusArgument &operator<<(QDBusArgument &arg, const BackupInfo &info)
{
    arg.beginStructure();
    arg << info.operateID
        << info.username
        << info.startTime
        << info.remark
        << info.operateType
        << info.recoveryType
        << info.backupPath
        << info.size
        << info.rootUUID
        << info.backupDevUUID
        << info.backupDevice
        << info.backupDeviceRemovable
        << info.status
        << info.submissionTime
        << info.systemVersion
        << info.submissionVersion
        << info.submissionType
        << info.backupVersion
        << info.versionDisplay;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, BackupInfo &info)
{
    arg.beginStructure();
    arg >> info.operateID
        >> info.username
        >> info.startTime
        >> info.remark
        >> info.operateType
        >> info.recoveryType
        >> info.backupPath
        >> info.size
        >> info.rootUUID
        >> info.backupDevUUID
        >> info.backupDevice
        >> info.backupDeviceRemovable
        >> info.status
        >> info.submissionTime
        >> info.systemVersion
        >> info.submissionVersion
        >> info.submissionType
        >> info.backupVersion
        >> info.versionDisplay;
    arg.endStructure();
    return arg;
}

void BackupInfo::registerMetaType()
{
    qRegisterMetaType<BackupInfo>("BackupInfo");
    qDBusRegisterMetaType<BackupInfo>();
}

QDBusArgument &operator<<(QDBusArgument &arg, const UserDataRestoreRequest &req)
{
    arg.beginStructure();
    arg << req.username
        << req.operateID
        << req.backupInfo;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, UserDataRestoreRequest &req)
{
    arg.beginStructure();
    arg >> req.username
        >> req.operateID
        >> req.backupInfo;
    arg.endStructure();
    return arg;
}

void UserDataRestoreRequest::registerMetaType()
{
    qRegisterMetaType<UserDataRestoreRequest>("UserDataRestoreRequest");
    qDBusRegisterMetaType<UserDataRestoreRequest>();
}

// Marshall the SystemBackupRequest data into a D-Bus argument
QDBusArgument &operator<<(QDBusArgument &arg, const SystemBackupRequest &req)
{
    arg.beginStructure();
    arg << req.operateID
        << req.userName
        << req.operateType
        << req.snapshotName
        << req.rootUUID
        << req.destUUID
        << req.remark;
    arg.endStructure();
    return arg;
}

// Retrieve the SystemBackupRequest data from the D-Bus argument
const QDBusArgument &operator>>(const QDBusArgument &arg, SystemBackupRequest &req)
{
    arg.beginStructure();
    arg >> req.operateID
        >> req.userName
        >> req.operateType
        >> req.snapshotName
        >> req.rootUUID
        >> req.destUUID
        >> req.remark;
    arg.endStructure();
    return arg;
}

void SystemBackupRequest::registerMetaType()
{
    qRegisterMetaType<SystemBackupRequest>("SystemBackupRequest");
    qDBusRegisterMetaType<SystemBackupRequest>();
}

// Marshall the SystemRestoreRequest data into a D-Bus argument
QDBusArgument &operator<<(QDBusArgument &arg, const SystemRestoreRequest &req)
{
    arg.beginStructure();
    arg << req.username
        << req.operateID
        << req.backupInfo;
    arg.endStructure();
    return arg;
}

// Retrieve the SystemRestoreRequest data from the D-Bus argument
const QDBusArgument &operator>>(const QDBusArgument &arg, SystemRestoreRequest &req)
{
    arg.beginStructure();
    arg >> req.username
        >> req.operateID
        >> req.backupInfo;
    arg.endStructure();
    return arg;
}

void SystemRestoreRequest::registerMetaType()
{
    qRegisterMetaType<SystemRestoreRequest>("SystemRestoreRequest");
    qDBusRegisterMetaType<SystemRestoreRequest>();
}