#pragma once
#include "utils/global.h"
#include "utils/FsTab.h"
#include "utils/data-collection/EventData.h"
#include <QString>
#include <QSharedPointer>
#include <QObject>

class SystemRecovery : public QObject
{
    Q_OBJECT
public:
    explicit SystemRecovery();
    ~SystemRecovery() override;

    virtual bool supported(FSTabInfoList &fsTabInfoList) = 0;
    //获取备份默认存放设备
    virtual QString getDefaultBackupDeviceUUID(const QString &rootPath) = 0;
    //备份系统
    virtual ErrorCode systemBackup(const SystemBackupRequest &request) = 0;
    //还原系统
    virtual ErrorCode systemRestore(const SystemRestoreRequest &request) = 0;
    //制作uimg
    virtual ErrorCode createUImg(const QString &backupDir) = 0;
    //获取所有备份信息
    virtual BackupInfoList listSystemBackup(QStringList &destUUIDs) = 0;
    //删除系统备份信息
    virtual ErrorCode removeSystemBackup(const RemoveUserDataBackupRequest &request) = 0;

    // 系统全量备份空间校验
    virtual ErrorCode checkFullSystemBackupSpace(SystemBackupRequest &request) = 0;

    // 系统增量备份空间校验
    virtual ErrorCode checkIncSystemBackupSpace(const SystemBackupRequest &request) = 0;

    // 上报数据埋点信息
    virtual void reportEventLog(const ResultInfo &resultInfo, OperateType opType, RecoveryType recoveryType);

    virtual bool isRunning();
    //更新操作记录
Q_SIGNALS:
    void progressChanged(const QString &progress);
    void error(const QString &errMsg);
    void success(const QString &msg);
    void spaceCheckFinished(const QString &space);
protected:
    QString m_defaultBackupDeviceUUID;
};

typedef QSharedPointer<SystemRecovery> SystemRecoveryPtr;
