/*
* Copyright (C) 2019 ~ 2019 Uniontech Technology Co., Ltd.
*
* Author:     liaojiayun <liaojiayun@uniontech.com>
*
* Maintainer: liaojiayun <liaojiayun@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "treeviewmodel.h"

#include <DApplication>

DWIDGET_USE_NAMESPACE

TreeViewModel::TreeViewModel(QObject *parent):
    QStandardItemModel(parent)
  , m_rowNum(0)
{

}

QVariant TreeViewModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    if(role == Qt::DisplayRole){
        switch (section) {
        case 0:
            return DApplication::translate("Recovery.Table.Header", kBackupFile);
        case 1:
            return DApplication::translate("Recovery.Table.Header", kTime);
        }
    }else if (role == Qt::TextAlignmentRole) {
        return QVariant(Qt::AlignLeft | Qt::AlignVCenter);
    } else if (role == Qt::InitialSortOrderRole) {
        return QVariant::fromValue(Qt::DescendingOrder);
    }
    return QAbstractItemModel::headerData(section, orientation, role);
}

void TreeViewModel::appendRow(const QList<QStandardItem *> &items)
{
    QStandardItemModel::appendRow(items);
    m_rowNum++;
}

void TreeViewModel::clear()
{
    QStandardItemModel::clear();
    m_rowNum=0;
}

int TreeViewModel::rowCount(const QModelIndex &parent) const
{
    if (parent.isValid())
        return 0;
    return m_rowNum;
}

int TreeViewModel::columnCount(const QModelIndex &parent) const
{
    if (parent.isValid())
        return 0;

    return 2;
}
