//
// Created by uos on 2022/3/17.
//

#ifndef UOS_RECOVERY_ADVANCEDWIDGET_H
#define UOS_RECOVERY_ADVANCEDWIDGET_H

#include <DPushButton>
#include <DGuiApplicationHelper>
#include <DWidget>
#include <QMouseEvent>
#include "common/AuthorityUtils.h"

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class QLabel;
class ItemFrame;
class HelpDialog;

class AdvancedWidget : public DWidget
{
    Q_OBJECT
public:
    explicit AdvancedWidget(DWidget *parent = nullptr);
    void setLVM(bool isLVM);
    void setEncrypted(bool isEncrypted);

private:
    void initUI();
    void initConnect();
    int getAdvanceUiLayoutType();
    void initHelpLayout();
    void showNotSupportDlg(const QString &msg);
    void checkAdminAuthority(AuthorityType type);

signals:
    void showGhostWidgetSignal();
    void enter();
    void leave();

private Q_SLOTS:
    void onItemIcoBtnClicked();
    void onNextBtnBtnClicked();
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);
    void doAdminAuthorityTask(bool result, int type);

protected:
    bool eventFilter(QObject* watched, QEvent* event);

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper;
    QLabel *m_title = nullptr;
    QLabel *m_subTitle = nullptr;
    QLabel *m_helpLabel = nullptr;
    DPushButton *m_nextBtn = nullptr;
    QWidget *m_nextButtonWidget = nullptr;
    ItemFrame *m_itemGhostFrame = nullptr;
    HelpDialog* m_helpDialog = nullptr;
    AuthorityUtils *m_adminAuthUtils = nullptr;
    bool m_bDirectionRTL = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
};

#endif //UOS_RECOVERY_ADVANCEDWIDGET_H
