/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 */

#include "config.h"
#include "euc.h"

/*
 * Attempts to define some definitions useful for dealing with
 * Japanese EUC Packed Format text.
 */

#define _set(num)         ((num)<<_euc_codeset_shift)
#define _bpc(num)         ((num)<<_euc_bpc_shift)

unsigned const char euc_info[256] =
{
 /*   0     x00 */ _set(0)|_bpc(1),
 /*   1     x01 */ _set(0)|_bpc(1),
 /*   2     x02 */ _set(0)|_bpc(1),
 /*   3     x03 */ _set(0)|_bpc(1),
 /*   4     x04 */ _set(0)|_bpc(1),
 /*   5     x05 */ _set(0)|_bpc(1),
 /*   6     x06 */ _set(0)|_bpc(1),
 /*   7     x07 */ _set(0)|_bpc(1),
 /*   8     x08 */ _set(0)|_bpc(1),
 /*   9     x09 */ _set(0)|_bpc(1),
 /*  10     x0a */ _set(0)|_bpc(1),
 /*  11     x0b */ _set(0)|_bpc(1),
 /*  12     x0c */ _set(0)|_bpc(1),
 /*  13     x0d */ _set(0)|_bpc(1),
 /*  14     x0e */ _set(0)|_bpc(1),
 /*  15     x0f */ _set(0)|_bpc(1),
 /*  16     x10 */ _set(0)|_bpc(1),
 /*  17     x11 */ _set(0)|_bpc(1),
 /*  18     x12 */ _set(0)|_bpc(1),
 /*  19     x13 */ _set(0)|_bpc(1),
 /*  20     x14 */ _set(0)|_bpc(1),
 /*  21     x15 */ _set(0)|_bpc(1),
 /*  22     x16 */ _set(0)|_bpc(1),
 /*  23     x17 */ _set(0)|_bpc(1),
 /*  24     x18 */ _set(0)|_bpc(1),
 /*  25     x19 */ _set(0)|_bpc(1),
 /*  26     x1a */ _set(0)|_bpc(1),
 /*  27     x1b */ _set(0)|_bpc(1),
 /*  28     x1c */ _set(0)|_bpc(1),
 /*  29     x1d */ _set(0)|_bpc(1),
 /*  30     x1e */ _set(0)|_bpc(1),
 /*  31     x1f */ _set(0)|_bpc(1),
 /*  32 ' ' x20 */ _set(0)|_bpc(1),
 /*  33 '!' x21 */ _set(0)|_bpc(1),
 /*  34 '"' x22 */ _set(0)|_bpc(1),
 /*  35 '#' x23 */ _set(0)|_bpc(1),
 /*  36 '$' x24 */ _set(0)|_bpc(1),
 /*  37 '%' x25 */ _set(0)|_bpc(1),
 /*  38 '&' x26 */ _set(0)|_bpc(1),
 /*  39 ''' x27 */ _set(0)|_bpc(1),
 /*  40 '(' x28 */ _set(0)|_bpc(1),
 /*  41 ')' x29 */ _set(0)|_bpc(1),
 /*  42 '*' x2a */ _set(0)|_bpc(1),
 /*  43 '+' x2b */ _set(0)|_bpc(1),
 /*  44 ',' x2c */ _set(0)|_bpc(1),
 /*  45 '-' x2d */ _set(0)|_bpc(1),
 /*  46 '.' x2e */ _set(0)|_bpc(1),
 /*  47 '/' x2f */ _set(0)|_bpc(1),
 /*  48 '0' x30 */ _set(0)|_bpc(1),
 /*  49 '1' x31 */ _set(0)|_bpc(1),
 /*  50 '2' x32 */ _set(0)|_bpc(1),
 /*  51 '3' x33 */ _set(0)|_bpc(1),
 /*  52 '4' x34 */ _set(0)|_bpc(1),
 /*  53 '5' x35 */ _set(0)|_bpc(1),
 /*  54 '6' x36 */ _set(0)|_bpc(1),
 /*  55 '7' x37 */ _set(0)|_bpc(1),
 /*  56 '8' x38 */ _set(0)|_bpc(1),
 /*  57 '9' x39 */ _set(0)|_bpc(1),
 /*  58 ':' x3a */ _set(0)|_bpc(1),
 /*  59 ';' x3b */ _set(0)|_bpc(1),
 /*  60 '<' x3c */ _set(0)|_bpc(1),
 /*  61 '=' x3d */ _set(0)|_bpc(1),
 /*  62 '>' x3e */ _set(0)|_bpc(1),
 /*  63 '?' x3f */ _set(0)|_bpc(1),
 /*  64 '@' x40 */ _set(0)|_bpc(1),
 /*  65 'A' x41 */ _set(0)|_bpc(1),
 /*  66 'B' x42 */ _set(0)|_bpc(1),
 /*  67 'C' x43 */ _set(0)|_bpc(1),
 /*  68 'D' x44 */ _set(0)|_bpc(1),
 /*  69 'E' x45 */ _set(0)|_bpc(1),
 /*  70 'F' x46 */ _set(0)|_bpc(1),
 /*  71 'G' x47 */ _set(0)|_bpc(1),
 /*  72 'H' x48 */ _set(0)|_bpc(1),
 /*  73 'I' x49 */ _set(0)|_bpc(1),
 /*  74 'J' x4a */ _set(0)|_bpc(1),
 /*  75 'K' x4b */ _set(0)|_bpc(1),
 /*  76 'L' x4c */ _set(0)|_bpc(1),
 /*  77 'M' x4d */ _set(0)|_bpc(1),
 /*  78 'N' x4e */ _set(0)|_bpc(1),
 /*  79 'O' x4f */ _set(0)|_bpc(1),
 /*  80 'P' x50 */ _set(0)|_bpc(1),
 /*  81 'Q' x51 */ _set(0)|_bpc(1),
 /*  82 'R' x52 */ _set(0)|_bpc(1),
 /*  83 'S' x53 */ _set(0)|_bpc(1),
 /*  84 'T' x54 */ _set(0)|_bpc(1),
 /*  85 'U' x55 */ _set(0)|_bpc(1),
 /*  86 'V' x56 */ _set(0)|_bpc(1),
 /*  87 'W' x57 */ _set(0)|_bpc(1),
 /*  88 'X' x58 */ _set(0)|_bpc(1),
 /*  89 'Y' x59 */ _set(0)|_bpc(1),
 /*  90 'Z' x5a */ _set(0)|_bpc(1),
 /*  91 '[' x5b */ _set(0)|_bpc(1),
 /*  92 '\' x5c */ _set(0)|_bpc(1),
 /*  93 ']' x5d */ _set(0)|_bpc(1),
 /*  94 '^' x5e */ _set(0)|_bpc(1),
 /*  95 '_' x5f */ _set(0)|_bpc(1),
 /*  96 '`' x60 */ _set(0)|_bpc(1),
 /*  97 'a' x61 */ _set(0)|_bpc(1),
 /*  98 'b' x62 */ _set(0)|_bpc(1),
 /*  99 'c' x63 */ _set(0)|_bpc(1),
 /* 100 'd' x64 */ _set(0)|_bpc(1),
 /* 101 'e' x65 */ _set(0)|_bpc(1),
 /* 102 'f' x66 */ _set(0)|_bpc(1),
 /* 103 'g' x67 */ _set(0)|_bpc(1),
 /* 104 'h' x68 */ _set(0)|_bpc(1),
 /* 105 'i' x69 */ _set(0)|_bpc(1),
 /* 106 'j' x6a */ _set(0)|_bpc(1),
 /* 107 'k' x6b */ _set(0)|_bpc(1),
 /* 108 'l' x6c */ _set(0)|_bpc(1),
 /* 109 'm' x6d */ _set(0)|_bpc(1),
 /* 110 'n' x6e */ _set(0)|_bpc(1),
 /* 111 'o' x6f */ _set(0)|_bpc(1),
 /* 112 'p' x70 */ _set(0)|_bpc(1),
 /* 113 'q' x71 */ _set(0)|_bpc(1),
 /* 114 'r' x72 */ _set(0)|_bpc(1),
 /* 115 's' x73 */ _set(0)|_bpc(1),
 /* 116 't' x74 */ _set(0)|_bpc(1),
 /* 117 'u' x75 */ _set(0)|_bpc(1),
 /* 118 'v' x76 */ _set(0)|_bpc(1),
 /* 119 'w' x77 */ _set(0)|_bpc(1),
 /* 120 'x' x78 */ _set(0)|_bpc(1),
 /* 121 'y' x79 */ _set(0)|_bpc(1),
 /* 122 'z' x7a */ _set(0)|_bpc(1),
 /* 123 '{' x7b */ _set(0)|_bpc(1),
 /* 124 '|' x7c */ _set(0)|_bpc(1),
 /* 125 '}' x7d */ _set(0)|_bpc(1),
 /* 126 '~' x7e */ _set(0)|_bpc(1),
 /* 127     x7f */ _set(0)|_bpc(1),
 /* 128     x80 */ 0,
 /* 129     x81 */ 0,
 /* 130     x82 */ 0,
 /* 131     x83 */ 0,
 /* 132     x84 */ 0,
 /* 133     x85 */ 0,
 /* 134     x86 */ 0,
 /* 135     x87 */ 0,
 /* 136     x88 */ 0,
 /* 137     x89 */ 0,
 /* 138     x8a */ 0,
 /* 139     x8b */ 0,
 /* 140     x8c */ 0,
 /* 141     x8d */ 0,
 /* 142     x8e */ _set(2)|_bpc(2), /* for halfwidth katakana */
 /* 143     x8f */ _set(3)|_bpc(3), /* for JIS X 0212 */
 /* 144     x90 */ 0,
 /* 145     x91 */ 0,
 /* 146     x92 */ 0,
 /* 147     x93 */ 0,
 /* 148     x94 */ 0,
 /* 149     x95 */ 0,
 /* 150     x96 */ 0,
 /* 151     x97 */ 0,
 /* 152     x98 */ 0,
 /* 153     x99 */ 0,
 /* 154     x9a */ 0,
 /* 155     x9b */ 0,
 /* 156     x9c */ 0,
 /* 157     x9d */ 0,
 /* 158     x9e */ 0,
 /* 159 ROW x9f */ 0,
 /* 160 --- xa0 */ 0,
 /* 161  1  xa1 */ _set(1)|_bpc(2),   /* punctuation and symbols */
 /* 162  2  xa2 */ _set(1)|_bpc(2),   /* punctuation and symbols */
 /* 163  3  xa3 */ _set(1)|_bpc(2),   /* full-width roman alphanumerics */
 /* 164  4  xa4 */ _set(1)|_bpc(2),   /* hiragana */
 /* 165  5  xa5 */ _set(1)|_bpc(2),   /* katakana */
 /* 166  6  xa6 */ _set(1)|_bpc(2),   /* greek letters */
 /* 167  7  xa7 */ _set(1)|_bpc(2),   /* funky cryllic letters */
 /* 168  8  xa8 */ _set(1)|_bpc(2),   /* box drawing stuff */
 /* 169  9  xa9 */ 0,         /* unassigned */
 /* 170 10  xaa */ 0,         /* unassigned */
 /* 171 11  xab */ 0,         /* unassigned */
 /* 172 12  xac */ 0,         /* unassigned */
 /* 173 13  xad */ 0,         /* unassigned */
 /* 174 14  xae */ 0,         /* unassigned */
 /* 175 15  xaf */ 0,         /* unassigned */
 /* 176 16  xb0 */ _set(1)|_bpc(2), /* kanji.... */
 /* 177 17  xb1 */ _set(1)|_bpc(2),
 /* 178 18  xb2 */ _set(1)|_bpc(2),
 /* 179 19  xb3 */ _set(1)|_bpc(2),
 /* 180 20  xb4 */ _set(1)|_bpc(2),
 /* 181 21  xb5 */ _set(1)|_bpc(2),
 /* 182 22  xb6 */ _set(1)|_bpc(2),
 /* 183 23  xb7 */ _set(1)|_bpc(2),
 /* 184 24  xb8 */ _set(1)|_bpc(2),
 /* 185 25  xb9 */ _set(1)|_bpc(2),
 /* 186 26  xba */ _set(1)|_bpc(2),
 /* 187 27  xbb */ _set(1)|_bpc(2),
 /* 188 28  xbc */ _set(1)|_bpc(2),
 /* 189 29  xbd */ _set(1)|_bpc(2),
 /* 190 30  xbe */ _set(1)|_bpc(2),
 /* 191 31  xbf */ _set(1)|_bpc(2),
 /* 192 32  xc0 */ _set(1)|_bpc(2),
 /* 193 33  xc1 */ _set(1)|_bpc(2),
 /* 194 34  xc2 */ _set(1)|_bpc(2),
 /* 195 35  xc3 */ _set(1)|_bpc(2),
 /* 196 36  xc4 */ _set(1)|_bpc(2),
 /* 197 37  xc5 */ _set(1)|_bpc(2),
 /* 198 38  xc6 */ _set(1)|_bpc(2),
 /* 199 39  xc7 */ _set(1)|_bpc(2),
 /* 200 40  xc8 */ _set(1)|_bpc(2),
 /* 201 41  xc9 */ _set(1)|_bpc(2),
 /* 202 42  xca */ _set(1)|_bpc(2),
 /* 203 43  xcb */ _set(1)|_bpc(2),
 /* 204 44  xcc */ _set(1)|_bpc(2),
 /* 205 45  xcd */ _set(1)|_bpc(2),
 /* 206 46  xce */ _set(1)|_bpc(2),
 /* 207 47  xcf */ _set(1)|_bpc(2),
 /* 208 48  xd0 */ _set(1)|_bpc(2),
 /* 209 49  xd1 */ _set(1)|_bpc(2),
 /* 210 50  xd2 */ _set(1)|_bpc(2),
 /* 211 51  xd3 */ _set(1)|_bpc(2),
 /* 212 52  xd4 */ _set(1)|_bpc(2),
 /* 213 53  xd5 */ _set(1)|_bpc(2),
 /* 214 54  xd6 */ _set(1)|_bpc(2),
 /* 215 55  xd7 */ _set(1)|_bpc(2),
 /* 216 56  xd8 */ _set(1)|_bpc(2),
 /* 217 57  xd9 */ _set(1)|_bpc(2),
 /* 218 58  xda */ _set(1)|_bpc(2),
 /* 219 59  xdb */ _set(1)|_bpc(2),
 /* 220 60  xdc */ _set(1)|_bpc(2),
 /* 221 61  xdd */ _set(1)|_bpc(2),
 /* 222 62  xde */ _set(1)|_bpc(2),
 /* 223 63  xdf */ _set(1)|_bpc(2),
 /* 224 64  xe0 */ _set(1)|_bpc(2),
 /* 225 65  xe1 */ _set(1)|_bpc(2),
 /* 226 66  xe2 */ _set(1)|_bpc(2),
 /* 227 67  xe3 */ _set(1)|_bpc(2),
 /* 228 68  xe4 */ _set(1)|_bpc(2),
 /* 229 69  xe5 */ _set(1)|_bpc(2),
 /* 230 70  xe6 */ _set(1)|_bpc(2),
 /* 231 71  xe7 */ _set(1)|_bpc(2),
 /* 232 72  xe8 */ _set(1)|_bpc(2),
 /* 233 73  xe9 */ _set(1)|_bpc(2),
 /* 234 74  xea */ _set(1)|_bpc(2),
 /* 235 75  xeb */ _set(1)|_bpc(2),
 /* 236 76  xec */ _set(1)|_bpc(2),
 /* 237 77  xed */ _set(1)|_bpc(2),
 /* 238 78  xee */ _set(1)|_bpc(2),
 /* 239 79  xef */ _set(1)|_bpc(2),
 /* 240 80  xf0 */ _set(1)|_bpc(2),
 /* 241 81  xf1 */ _set(1)|_bpc(2),
 /* 242 82  xf2 */ _set(1)|_bpc(2),
 /* 243 83  xf3 */ _set(1)|_bpc(2),
 /* 244 84  xf4 */ _set(1)|_bpc(2),
 /* 245 85  xf5 */ 0, /* unassigned */
 /* 246 86  xf6 */ 0, /* unassigned */
 /* 247 87  xf7 */ 0, /* unassigned */
 /* 248 88  xf8 */ 0, /* unassigned */
 /* 249 89  xf9 */ 0, /* unassigned */
 /* 250 90  xfa */ 0, /* unassigned */
 /* 251 91  xfb */ 0, /* unassigned */
 /* 252 92  xfc */ 0, /* unassigned */
 /* 253 93  xfd */ 0, /* unassigned */
 /* 254 94  xfe */ 0, /* unassigned */
 /* 255     xff */ 0,
};
