% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-number.R
\name{number_options}
\alias{number_options}
\title{Number options}
\usage{
number_options(
  decimal.mark = ".",
  big.mark = " ",
  style_positive = c("none", "plus", "space"),
  style_negative = c("hyphen", "minus", "parens"),
  currency.prefix = "$",
  currency.suffix = "",
  currency.decimal.mark = decimal.mark,
  currency.big.mark = setdiff(c(".", ","), currency.decimal.mark)[1],
  ordinal.rules = ordinal_english()
)
}
\arguments{
\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.  The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{big.mark}{Character used between every 3 digits to separate thousands.
The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{style_positive}{A string that determines the style of positive numbers:
\itemize{
\item \code{"none"} (the default): no change, e.g. \code{1}.
\item \code{"plus"}: preceded by \code{+}, e.g. \code{+1}.
\item \code{"space"}: preceded by a Unicode "figure space", i.e., a space equally
as wide as a number or \code{+}. Compared to \code{"none"}, adding a figure space
can ensure numbers remain properly aligned when they are left- or
right-justified.
}

The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{style_negative}{A string that determines the style of negative numbers:
\itemize{
\item \code{"hyphen"} (the default): preceded by a standard hyphen \code{-}, e.g. \code{-1}.
\item \code{"minus"}, uses a proper Unicode minus symbol. This is a typographical
nicety that ensures \code{-} aligns with the horizontal bar of the
the horizontal bar of \code{+}.
\item \code{"parens"}, wrapped in parentheses, e.g. \code{(1)}.
}

The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{currency.prefix, currency.suffix, currency.decimal.mark, currency.big.mark}{Settings for \code{\link[=label_currency]{label_currency()}} passed on without the \code{currency.}-prefix.}

\item{ordinal.rules}{Setting for \code{\link[=label_ordinal]{label_ordinal()}} passed on without the
\code{ordinal.}-prefix.}
}
\value{
The old options invisibly
}
\description{
Control the settings for formatting numbers globally.
}
\examples{
# Default number formatting
x <- c(0.1, 1, 1000)
label_number()(x)

# Now again with new options set
number_options(style_positive = "plus", decimal.mark = ",")
label_number()(x)

# The options are the argument names with a 'scales.'-prefix
options("scales.style_positive")

# Resetting the options to their defaults
number_options()
label_number()(x)
}
