% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_indel_contexts.R
\name{plot_indel_contexts}
\alias{plot_indel_contexts}
\title{Plot the indel contexts}
\usage{
plot_indel_contexts(
  counts,
  same_y = FALSE,
  extra_labels = FALSE,
  condensed = FALSE
)
}
\arguments{
\item{counts}{A tibble containing the number of indels per COSMIC context.}

\item{same_y}{A boolean describing whether the same y axis should be used for all samples.}

\item{extra_labels}{A boolean describing whether extra labels should be added.
These can clarify the plot, but will shift when different plot widths are used.
We recommend saving a plot with a width of 12, when using this argument.}

\item{condensed}{More condensed plotting format. Default = F.}
}
\value{
A ggplot figure.
}
\description{
Plot the indel contexts
}
\details{
Plots the number of indels  COSMIC context per sample.
It takes a tibble with counts as its input. This tibble can be generated by 'count_indel_contexts()'.
Each sample is plotted in a separate facet.
The same y axis can be used for all samples or a separate y axis can be used.
The facets at the top show the indel types. First the C and T deletions
Then the C and T insertions. Next are the multi base deletions and insertions.
Finally the deletions with microhomology (mh) are shown.
The x-axis at the bottom shows the number of repeat units.
For mh deletions the microhomology length is shown.
}
\examples{
## Get The indel counts
## See 'count_indel_contexts()' for more info on how to do this.
indel_counts <- readRDS(system.file("states/blood_indel_counts.rds",
  package = "MutationalPatterns"
))

## Plot contexts
plot_indel_contexts(indel_counts)

## Use the same y axis for all samples.
plot_indel_contexts(indel_counts, same_y = TRUE)

## Add extra labels to make plot clearer
plot_indel_contexts(indel_counts, extra_labels = TRUE)

## Create a more condensed plot
plot_indel_contexts(indel_counts, condensed = TRUE)
}
\seealso{
\code{\link{count_indel_contexts}}, \code{\link{plot_main_indel_contexts}}

Other Indels: 
\code{\link{count_indel_contexts}()},
\code{\link{get_indel_context}()},
\code{\link{plot_compare_indels}()},
\code{\link{plot_main_indel_contexts}()}
}
\concept{Indels}
