# Plasma Desktop

Plasma for the desktop form factor. This repository contains code for many of the widgets, KCMs, and other parts of the Plasma Desktop.

See [the CODEMAP](./CODEMAP.md) to get an idea of the layout of this repository.

## See Also

This repository contains only components specific to the desktop form factor. Components which are more generic can be found elsewhere under the [Plasma group](https://invent.kde.org/plasma/) or in individual repositories. For example:

* [Plasma Workspace](https://invent.kde.org/plasma/plasma-workspace) contains more generic code shared between Desktop, Mobile, and other form factors of Plasma. If you can't find what you're looking for in plasma-desktop, look here first.
* [libplasma](https://invent.kde.org/plasma/libplasma) includes the building blocks for Plasma widgets.
* [Plasma NetworkManager Applet](https://invent.kde.org/plasma/plasma-nm) has code for the network manager widget.
* [Plasma PulseAudio Applet](https://invent.kde.org/plasma/plasma-pa) is where the code for the PulseAudio KCM and widget lives.
* [Plasma Add-ons](https://invent.kde.org/plasma/kdeplasma-addons) is the home of the rest of the widgets that aren't in plasma-desktop, plasma-workspace, or another specific repository. For example: Web Browser, Comics, and Sticky Notes.

## Building

The easiest way to make changes and test Plasma Desktop during development is to [build it with kdesrc-build](https://develop.kde.org/docs/getting-started/building/).

## Contributing

Like other projects in the KDE ecosystem, contributions are welcome from all. This repository is managed on [KDE Invent](https://invent.kde.org/plasma/plasma-desktop), our GitLab instance.

* Want to contribute code? See the [GitLab wiki page](https://community.kde.org/Infrastructure/GitLab) for a tutorial on how to send a merge request.
* Reporting a bug? Please submit it on the [KDE Bugtracking System](https://bugs.kde.org/enter_bug.cgi?format=guided&product=plasmashell). Please do not use the Issues
tab to report bugs.
* Is there a part of Plasma Desktop that's not translated? See the [Getting Involved in Translation wiki page](https://community.kde.org/Get_Involved/translation) to see how
you can help translate!

If you get stuck or need help with anything at all, head over to the [KDE New Contributors room](https://go.kde.org/matrix/#/#kde-welcome:kde.org) on Matrix. For questions specifically about Plasma Desktop, please ask in the [KDE Development room](https://go.kde.org/matrix/#/#plasma:kde.org). See [Matrix](https://community.kde.org/Matrix) for more details.

