; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=armv7 %s -o - | FileCheck %s
; RUN: llc -mtriple=thumbv7 %s -o - | FileCheck --check-prefix=THUMB %s

declare double @fn()

define void @test(ptr %p, ptr %res) nounwind {
; CHECK-LABEL: test:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    push {r4, r5, r11, lr}
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    mov r4, r1
; CHECK-NEXT:    vcmp.f64 d16, #0
; CHECK-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-NEXT:    mrs r5, apsr
; CHECK-NEXT:    vneg.f64 d17, d16
; CHECK-NEXT:    vmovne.f64 d16, d17
; CHECK-NEXT:    vstr d16, [r1]
; CHECK-NEXT:    bl fn
; CHECK-NEXT:    vmov d16, r0, r1
; CHECK-NEXT:    eor r1, r1, #-2147483648
; CHECK-NEXT:    msr APSR_nzcvq, r5
; CHECK-NEXT:    vmov d17, r0, r1
; CHECK-NEXT:    vmovne.f64 d16, d17
; CHECK-NEXT:    vstr d16, [r4]
; CHECK-NEXT:    pop {r4, r5, r11, pc}
;
; THUMB-LABEL: test:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    push {r4, r5, r7, lr}
; THUMB-NEXT:    vldr d16, [r0]
; THUMB-NEXT:    mov r4, r1
; THUMB-NEXT:    vcmp.f64 d16, #0
; THUMB-NEXT:    vmrs APSR_nzcv, fpscr
; THUMB-NEXT:    mrs r5, apsr
; THUMB-NEXT:    vneg.f64 d17, d16
; THUMB-NEXT:    it ne
; THUMB-NEXT:    vmovne.f64 d16, d17
; THUMB-NEXT:    vstr d16, [r1]
; THUMB-NEXT:    bl fn
; THUMB-NEXT:    vmov d16, r0, r1
; THUMB-NEXT:    eor r1, r1, #-2147483648
; THUMB-NEXT:    msr APSR_nzcvq, r5
; THUMB-NEXT:    vmov d17, r0, r1
; THUMB-NEXT:    it ne
; THUMB-NEXT:    vmovne.f64 d16, d17
; THUMB-NEXT:    vstr d16, [r4]
; THUMB-NEXT:    pop {r4, r5, r7, pc}
entry:
  %x = load double, ptr %p
  %cmp = fcmp une double %x, 0.000000e+00
  %nx = fneg double %x
  %sx = select i1 %cmp, double %nx, double %x
  store double %sx, ptr %res
  %y = call double @fn()
  %ny = fneg double %y
  %sy = select i1 %cmp, double %ny, double %y
  store double %sy, ptr %res
  ret void
}
