# Breeze Icons

Breeze Icons is a [freedesktop.org compatible](https://specifications.freedesktop.org/icon-theme-spec/latest/) icon theme. It's developed by the KDE Community as part of KDE Frameworks and it's used by default in KDE Plasma and KDE Applications.

You can browse the icons on your system using Icon Explorer from the Plasma SDK.

## Guidelines

The rules and guidelines for creating [new app and symbolic icons are described in our Human Interface Guidelines](https://develop.kde.org/hig/icons/#designing-your-own-icons). Before committing new or modified icons, make sure to review [the Icon Workflow Tips](https://community.kde.org/Guidelines_and_HOWTOs/Icon_Workflow_Tips) to ensure your icon is properly aligned and optimized.

## Web Usage

Breeze Icons can be used as a webfont from [cdn.kde.org/breeze-icons/icons.html](https://cdn.kde.org/breeze-icons/icons.html).

```html
<i class="icon icon_icon-name"></i>
```

## Contributing

Like other projects in the KDE ecosystem, contributions are welcome from all. This repository is managed on [KDE Invent](https://invent.kde.org/frameworks/breeze-icons), our GitLab instance.

* Want to contribute code? See the [GitLab wiki page](https://community.kde.org/Infrastructure/GitLab) for a tutorial on how to send a merge request.
* Reporting a bug? Please submit it on the [KDE Bugtracking System](https://bugs.kde.org/enter_bug.cgi?format=guided&product=breeze&component=icons). Please do not use the Issues
page to report bugs.

If you get stuck or need help with anything at all, head over to the [KDE New Contributors room](https://go.kde.org/matrix/#/#kde-welcome:kde.org) on Matrix. For questions about Breeze Icons, please ask in the [KDE Visual Design Group room](https://go.kde.org/matrix/#/#visualdesigngroup:kde.org). See [Matrix](https://community.kde.org/Matrix) for more details.
