#pragma once
/*
 *  $Id: graph-utils.h 28348 2025-08-11 16:29:06Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_UTILS_H__
#define __GWYUI_GRAPH_UTILS_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <libgwyddion/rgba.h>
#include <libgwyddion/selection-axis.h>
#include <libgwyddion/selection-point.h>
#include <libgwyddion/selection-range.h>
#include <libgwyddion/selection-rectangle.h>
#include <libgwyui/gwygraphcurvemodel.h>

G_BEGIN_DECLS

/* XXX: And then we have a similar 1D struct for each axis. We might simply want the 1D structures and have the 2D
 * as two copies of it. */
typedef struct {
    GdkRectangle area;
    gdouble real_xmin;
    gdouble real_ymin;
    /* FIXME: This is weird for non-linear mapping. Just store the bloody endpoints! */
    gdouble real_height;
    gdouble real_width;
    gboolean log_x;
    gboolean log_y;
} GwyGraphActiveAreaSpecs;

G_GNUC_INTERNAL void          _gwy_graph_draw_point           (cairo_t *cr,
                                                               gdouble x,
                                                               gdouble y,
                                                               GwyGraphPointType type,
                                                               gdouble size,
                                                               const GwyRGBA *color);
G_GNUC_INTERNAL void          _gwy_graph_draw_line            (cairo_t *cr,
                                                               gdouble x_from,
                                                               gdouble y_from,
                                                               gdouble x_to,
                                                               gdouble y_to,
                                                               GwyGraphLineStyle line_style,
                                                               gdouble line_width,
                                                               const GwyRGBA *color);
G_GNUC_INTERNAL void          _gwy_graph_draw_curve           (cairo_t *cr,
                                                               GwyGraphActiveAreaSpecs *specs,
                                                               GwyGraphCurveModel *gcmodel);
G_GNUC_INTERNAL void          _gwy_graph_draw_selection_points(cairo_t *cr,
                                                               GwyGraphActiveAreaSpecs *specs,
                                                               GwySelectionPoint *selection);
G_GNUC_INTERNAL void          _gwy_graph_draw_selection_areas (cairo_t *cr,
                                                               GwyGraphActiveAreaSpecs *specs,
                                                               GwySelectionRectangle *selection);
G_GNUC_INTERNAL void          _gwy_graph_draw_selection_lines (cairo_t *cr,
                                                               GwyGraphActiveAreaSpecs *specs,
                                                               GwySelectionAxis *selection);
G_GNUC_INTERNAL void          _gwy_graph_draw_selection_ranges(cairo_t *cr,
                                                               GwyGraphActiveAreaSpecs *specs,
                                                               GwySelectionRange *selection);
G_GNUC_INTERNAL void          _gwy_graph_draw_grid            (cairo_t *cr,
                                                               GwyGraphActiveAreaSpecs *specs,
                                                               const gdouble *x_grid_data,
                                                               guint nxdata,
                                                               const gdouble *y_grid_data,
                                                               guint nydata);
G_GNUC_INTERNAL GtkTreeModel* _gwy_graph_get_point_type_store (void);
G_GNUC_INTERNAL GtkTreeModel* _gwy_graph_get_line_style_store (void);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
