// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package apigeeregistry

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	apigeeregistrypb "cloud.google.com/go/apigeeregistry/apiv1/apigeeregistrypb"
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httpbodypb "google.golang.org/genproto/googleapis/api/httpbody"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newRegistryClientHook clientHook

// RegistryCallOptions contains the retry settings for each method of RegistryClient.
type RegistryCallOptions struct {
	ListApis                    []gax.CallOption
	GetApi                      []gax.CallOption
	CreateApi                   []gax.CallOption
	UpdateApi                   []gax.CallOption
	DeleteApi                   []gax.CallOption
	ListApiVersions             []gax.CallOption
	GetApiVersion               []gax.CallOption
	CreateApiVersion            []gax.CallOption
	UpdateApiVersion            []gax.CallOption
	DeleteApiVersion            []gax.CallOption
	ListApiSpecs                []gax.CallOption
	GetApiSpec                  []gax.CallOption
	GetApiSpecContents          []gax.CallOption
	CreateApiSpec               []gax.CallOption
	UpdateApiSpec               []gax.CallOption
	DeleteApiSpec               []gax.CallOption
	TagApiSpecRevision          []gax.CallOption
	ListApiSpecRevisions        []gax.CallOption
	RollbackApiSpec             []gax.CallOption
	DeleteApiSpecRevision       []gax.CallOption
	ListApiDeployments          []gax.CallOption
	GetApiDeployment            []gax.CallOption
	CreateApiDeployment         []gax.CallOption
	UpdateApiDeployment         []gax.CallOption
	DeleteApiDeployment         []gax.CallOption
	TagApiDeploymentRevision    []gax.CallOption
	ListApiDeploymentRevisions  []gax.CallOption
	RollbackApiDeployment       []gax.CallOption
	DeleteApiDeploymentRevision []gax.CallOption
	ListArtifacts               []gax.CallOption
	GetArtifact                 []gax.CallOption
	GetArtifactContents         []gax.CallOption
	CreateArtifact              []gax.CallOption
	ReplaceArtifact             []gax.CallOption
	DeleteArtifact              []gax.CallOption
	GetLocation                 []gax.CallOption
	ListLocations               []gax.CallOption
	GetIamPolicy                []gax.CallOption
	SetIamPolicy                []gax.CallOption
	TestIamPermissions          []gax.CallOption
	CancelOperation             []gax.CallOption
	DeleteOperation             []gax.CallOption
	GetOperation                []gax.CallOption
	ListOperations              []gax.CallOption
}

func defaultRegistryGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("apigeeregistry.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("apigeeregistry.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("apigeeregistry.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://apigeeregistry.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultRegistryCallOptions() *RegistryCallOptions {
	return &RegistryCallOptions{
		ListApis: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetApi: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateApi: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateApi: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteApi: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListApiVersions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetApiVersion: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateApiVersion: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateApiVersion: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteApiVersion: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListApiSpecs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetApiSpec: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetApiSpecContents: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateApiSpec: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateApiSpec: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteApiSpec: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		TagApiSpecRevision: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListApiSpecRevisions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RollbackApiSpec: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteApiSpecRevision: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListApiDeployments: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetApiDeployment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateApiDeployment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateApiDeployment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteApiDeployment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		TagApiDeploymentRevision: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListApiDeploymentRevisions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RollbackApiDeployment: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteApiDeploymentRevision: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListArtifacts: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetArtifact: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetArtifactContents: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateArtifact: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ReplaceArtifact: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteArtifact: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Aborted,
					codes.Canceled,
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    200 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetLocation:        []gax.CallOption{},
		ListLocations:      []gax.CallOption{},
		GetIamPolicy:       []gax.CallOption{},
		SetIamPolicy:       []gax.CallOption{},
		TestIamPermissions: []gax.CallOption{},
		CancelOperation:    []gax.CallOption{},
		DeleteOperation:    []gax.CallOption{},
		GetOperation:       []gax.CallOption{},
		ListOperations:     []gax.CallOption{},
	}
}

// internalRegistryClient is an interface that defines the methods available from Apigee Registry API.
type internalRegistryClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListApis(context.Context, *apigeeregistrypb.ListApisRequest, ...gax.CallOption) *ApiIterator
	GetApi(context.Context, *apigeeregistrypb.GetApiRequest, ...gax.CallOption) (*apigeeregistrypb.Api, error)
	CreateApi(context.Context, *apigeeregistrypb.CreateApiRequest, ...gax.CallOption) (*apigeeregistrypb.Api, error)
	UpdateApi(context.Context, *apigeeregistrypb.UpdateApiRequest, ...gax.CallOption) (*apigeeregistrypb.Api, error)
	DeleteApi(context.Context, *apigeeregistrypb.DeleteApiRequest, ...gax.CallOption) error
	ListApiVersions(context.Context, *apigeeregistrypb.ListApiVersionsRequest, ...gax.CallOption) *ApiVersionIterator
	GetApiVersion(context.Context, *apigeeregistrypb.GetApiVersionRequest, ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error)
	CreateApiVersion(context.Context, *apigeeregistrypb.CreateApiVersionRequest, ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error)
	UpdateApiVersion(context.Context, *apigeeregistrypb.UpdateApiVersionRequest, ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error)
	DeleteApiVersion(context.Context, *apigeeregistrypb.DeleteApiVersionRequest, ...gax.CallOption) error
	ListApiSpecs(context.Context, *apigeeregistrypb.ListApiSpecsRequest, ...gax.CallOption) *ApiSpecIterator
	GetApiSpec(context.Context, *apigeeregistrypb.GetApiSpecRequest, ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error)
	GetApiSpecContents(context.Context, *apigeeregistrypb.GetApiSpecContentsRequest, ...gax.CallOption) (*httpbodypb.HttpBody, error)
	CreateApiSpec(context.Context, *apigeeregistrypb.CreateApiSpecRequest, ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error)
	UpdateApiSpec(context.Context, *apigeeregistrypb.UpdateApiSpecRequest, ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error)
	DeleteApiSpec(context.Context, *apigeeregistrypb.DeleteApiSpecRequest, ...gax.CallOption) error
	TagApiSpecRevision(context.Context, *apigeeregistrypb.TagApiSpecRevisionRequest, ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error)
	ListApiSpecRevisions(context.Context, *apigeeregistrypb.ListApiSpecRevisionsRequest, ...gax.CallOption) *ApiSpecIterator
	RollbackApiSpec(context.Context, *apigeeregistrypb.RollbackApiSpecRequest, ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error)
	DeleteApiSpecRevision(context.Context, *apigeeregistrypb.DeleteApiSpecRevisionRequest, ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error)
	ListApiDeployments(context.Context, *apigeeregistrypb.ListApiDeploymentsRequest, ...gax.CallOption) *ApiDeploymentIterator
	GetApiDeployment(context.Context, *apigeeregistrypb.GetApiDeploymentRequest, ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error)
	CreateApiDeployment(context.Context, *apigeeregistrypb.CreateApiDeploymentRequest, ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error)
	UpdateApiDeployment(context.Context, *apigeeregistrypb.UpdateApiDeploymentRequest, ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error)
	DeleteApiDeployment(context.Context, *apigeeregistrypb.DeleteApiDeploymentRequest, ...gax.CallOption) error
	TagApiDeploymentRevision(context.Context, *apigeeregistrypb.TagApiDeploymentRevisionRequest, ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error)
	ListApiDeploymentRevisions(context.Context, *apigeeregistrypb.ListApiDeploymentRevisionsRequest, ...gax.CallOption) *ApiDeploymentIterator
	RollbackApiDeployment(context.Context, *apigeeregistrypb.RollbackApiDeploymentRequest, ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error)
	DeleteApiDeploymentRevision(context.Context, *apigeeregistrypb.DeleteApiDeploymentRevisionRequest, ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error)
	ListArtifacts(context.Context, *apigeeregistrypb.ListArtifactsRequest, ...gax.CallOption) *ArtifactIterator
	GetArtifact(context.Context, *apigeeregistrypb.GetArtifactRequest, ...gax.CallOption) (*apigeeregistrypb.Artifact, error)
	GetArtifactContents(context.Context, *apigeeregistrypb.GetArtifactContentsRequest, ...gax.CallOption) (*httpbodypb.HttpBody, error)
	CreateArtifact(context.Context, *apigeeregistrypb.CreateArtifactRequest, ...gax.CallOption) (*apigeeregistrypb.Artifact, error)
	ReplaceArtifact(context.Context, *apigeeregistrypb.ReplaceArtifactRequest, ...gax.CallOption) (*apigeeregistrypb.Artifact, error)
	DeleteArtifact(context.Context, *apigeeregistrypb.DeleteArtifactRequest, ...gax.CallOption) error
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// RegistryClient is a client for interacting with Apigee Registry API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The Registry service allows teams to manage descriptions of APIs.
type RegistryClient struct {
	// The internal transport-dependent client.
	internalClient internalRegistryClient

	// The call options for this service.
	CallOptions *RegistryCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *RegistryClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *RegistryClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *RegistryClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListApis returns matching APIs.
func (c *RegistryClient) ListApis(ctx context.Context, req *apigeeregistrypb.ListApisRequest, opts ...gax.CallOption) *ApiIterator {
	return c.internalClient.ListApis(ctx, req, opts...)
}

// GetApi returns a specified API.
func (c *RegistryClient) GetApi(ctx context.Context, req *apigeeregistrypb.GetApiRequest, opts ...gax.CallOption) (*apigeeregistrypb.Api, error) {
	return c.internalClient.GetApi(ctx, req, opts...)
}

// CreateApi creates a specified API.
func (c *RegistryClient) CreateApi(ctx context.Context, req *apigeeregistrypb.CreateApiRequest, opts ...gax.CallOption) (*apigeeregistrypb.Api, error) {
	return c.internalClient.CreateApi(ctx, req, opts...)
}

// UpdateApi used to modify a specified API.
func (c *RegistryClient) UpdateApi(ctx context.Context, req *apigeeregistrypb.UpdateApiRequest, opts ...gax.CallOption) (*apigeeregistrypb.Api, error) {
	return c.internalClient.UpdateApi(ctx, req, opts...)
}

// DeleteApi removes a specified API and all of the resources that it
// owns.
func (c *RegistryClient) DeleteApi(ctx context.Context, req *apigeeregistrypb.DeleteApiRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteApi(ctx, req, opts...)
}

// ListApiVersions returns matching versions.
func (c *RegistryClient) ListApiVersions(ctx context.Context, req *apigeeregistrypb.ListApiVersionsRequest, opts ...gax.CallOption) *ApiVersionIterator {
	return c.internalClient.ListApiVersions(ctx, req, opts...)
}

// GetApiVersion returns a specified version.
func (c *RegistryClient) GetApiVersion(ctx context.Context, req *apigeeregistrypb.GetApiVersionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error) {
	return c.internalClient.GetApiVersion(ctx, req, opts...)
}

// CreateApiVersion creates a specified version.
func (c *RegistryClient) CreateApiVersion(ctx context.Context, req *apigeeregistrypb.CreateApiVersionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error) {
	return c.internalClient.CreateApiVersion(ctx, req, opts...)
}

// UpdateApiVersion used to modify a specified version.
func (c *RegistryClient) UpdateApiVersion(ctx context.Context, req *apigeeregistrypb.UpdateApiVersionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error) {
	return c.internalClient.UpdateApiVersion(ctx, req, opts...)
}

// DeleteApiVersion removes a specified version and all of the resources that
// it owns.
func (c *RegistryClient) DeleteApiVersion(ctx context.Context, req *apigeeregistrypb.DeleteApiVersionRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteApiVersion(ctx, req, opts...)
}

// ListApiSpecs returns matching specs.
func (c *RegistryClient) ListApiSpecs(ctx context.Context, req *apigeeregistrypb.ListApiSpecsRequest, opts ...gax.CallOption) *ApiSpecIterator {
	return c.internalClient.ListApiSpecs(ctx, req, opts...)
}

// GetApiSpec returns a specified spec.
func (c *RegistryClient) GetApiSpec(ctx context.Context, req *apigeeregistrypb.GetApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	return c.internalClient.GetApiSpec(ctx, req, opts...)
}

// GetApiSpecContents returns the contents of a specified spec.
// If specs are stored with GZip compression, the default behavior
// is to return the spec uncompressed (the mime_type response field
// indicates the exact format returned).
func (c *RegistryClient) GetApiSpecContents(ctx context.Context, req *apigeeregistrypb.GetApiSpecContentsRequest, opts ...gax.CallOption) (*httpbodypb.HttpBody, error) {
	return c.internalClient.GetApiSpecContents(ctx, req, opts...)
}

// CreateApiSpec creates a specified spec.
func (c *RegistryClient) CreateApiSpec(ctx context.Context, req *apigeeregistrypb.CreateApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	return c.internalClient.CreateApiSpec(ctx, req, opts...)
}

// UpdateApiSpec used to modify a specified spec.
func (c *RegistryClient) UpdateApiSpec(ctx context.Context, req *apigeeregistrypb.UpdateApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	return c.internalClient.UpdateApiSpec(ctx, req, opts...)
}

// DeleteApiSpec removes a specified spec, all revisions, and all child
// resources (e.g., artifacts).
func (c *RegistryClient) DeleteApiSpec(ctx context.Context, req *apigeeregistrypb.DeleteApiSpecRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteApiSpec(ctx, req, opts...)
}

// TagApiSpecRevision adds a tag to a specified revision of a spec.
func (c *RegistryClient) TagApiSpecRevision(ctx context.Context, req *apigeeregistrypb.TagApiSpecRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	return c.internalClient.TagApiSpecRevision(ctx, req, opts...)
}

// ListApiSpecRevisions lists all revisions of a spec.
// Revisions are returned in descending order of revision creation time.
func (c *RegistryClient) ListApiSpecRevisions(ctx context.Context, req *apigeeregistrypb.ListApiSpecRevisionsRequest, opts ...gax.CallOption) *ApiSpecIterator {
	return c.internalClient.ListApiSpecRevisions(ctx, req, opts...)
}

// RollbackApiSpec sets the current revision to a specified prior revision.
// Note that this creates a new revision with a new revision ID.
func (c *RegistryClient) RollbackApiSpec(ctx context.Context, req *apigeeregistrypb.RollbackApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	return c.internalClient.RollbackApiSpec(ctx, req, opts...)
}

// DeleteApiSpecRevision deletes a revision of a spec.
func (c *RegistryClient) DeleteApiSpecRevision(ctx context.Context, req *apigeeregistrypb.DeleteApiSpecRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	return c.internalClient.DeleteApiSpecRevision(ctx, req, opts...)
}

// ListApiDeployments returns matching deployments.
func (c *RegistryClient) ListApiDeployments(ctx context.Context, req *apigeeregistrypb.ListApiDeploymentsRequest, opts ...gax.CallOption) *ApiDeploymentIterator {
	return c.internalClient.ListApiDeployments(ctx, req, opts...)
}

// GetApiDeployment returns a specified deployment.
func (c *RegistryClient) GetApiDeployment(ctx context.Context, req *apigeeregistrypb.GetApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	return c.internalClient.GetApiDeployment(ctx, req, opts...)
}

// CreateApiDeployment creates a specified deployment.
func (c *RegistryClient) CreateApiDeployment(ctx context.Context, req *apigeeregistrypb.CreateApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	return c.internalClient.CreateApiDeployment(ctx, req, opts...)
}

// UpdateApiDeployment used to modify a specified deployment.
func (c *RegistryClient) UpdateApiDeployment(ctx context.Context, req *apigeeregistrypb.UpdateApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	return c.internalClient.UpdateApiDeployment(ctx, req, opts...)
}

// DeleteApiDeployment removes a specified deployment, all revisions, and all
// child resources (e.g., artifacts).
func (c *RegistryClient) DeleteApiDeployment(ctx context.Context, req *apigeeregistrypb.DeleteApiDeploymentRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteApiDeployment(ctx, req, opts...)
}

// TagApiDeploymentRevision adds a tag to a specified revision of a
// deployment.
func (c *RegistryClient) TagApiDeploymentRevision(ctx context.Context, req *apigeeregistrypb.TagApiDeploymentRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	return c.internalClient.TagApiDeploymentRevision(ctx, req, opts...)
}

// ListApiDeploymentRevisions lists all revisions of a deployment.
// Revisions are returned in descending order of revision creation time.
func (c *RegistryClient) ListApiDeploymentRevisions(ctx context.Context, req *apigeeregistrypb.ListApiDeploymentRevisionsRequest, opts ...gax.CallOption) *ApiDeploymentIterator {
	return c.internalClient.ListApiDeploymentRevisions(ctx, req, opts...)
}

// RollbackApiDeployment sets the current revision to a specified prior
// revision. Note that this creates a new revision with a new revision ID.
func (c *RegistryClient) RollbackApiDeployment(ctx context.Context, req *apigeeregistrypb.RollbackApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	return c.internalClient.RollbackApiDeployment(ctx, req, opts...)
}

// DeleteApiDeploymentRevision deletes a revision of a deployment.
func (c *RegistryClient) DeleteApiDeploymentRevision(ctx context.Context, req *apigeeregistrypb.DeleteApiDeploymentRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	return c.internalClient.DeleteApiDeploymentRevision(ctx, req, opts...)
}

// ListArtifacts returns matching artifacts.
func (c *RegistryClient) ListArtifacts(ctx context.Context, req *apigeeregistrypb.ListArtifactsRequest, opts ...gax.CallOption) *ArtifactIterator {
	return c.internalClient.ListArtifacts(ctx, req, opts...)
}

// GetArtifact returns a specified artifact.
func (c *RegistryClient) GetArtifact(ctx context.Context, req *apigeeregistrypb.GetArtifactRequest, opts ...gax.CallOption) (*apigeeregistrypb.Artifact, error) {
	return c.internalClient.GetArtifact(ctx, req, opts...)
}

// GetArtifactContents returns the contents of a specified artifact.
// If artifacts are stored with GZip compression, the default behavior
// is to return the artifact uncompressed (the mime_type response field
// indicates the exact format returned).
func (c *RegistryClient) GetArtifactContents(ctx context.Context, req *apigeeregistrypb.GetArtifactContentsRequest, opts ...gax.CallOption) (*httpbodypb.HttpBody, error) {
	return c.internalClient.GetArtifactContents(ctx, req, opts...)
}

// CreateArtifact creates a specified artifact.
func (c *RegistryClient) CreateArtifact(ctx context.Context, req *apigeeregistrypb.CreateArtifactRequest, opts ...gax.CallOption) (*apigeeregistrypb.Artifact, error) {
	return c.internalClient.CreateArtifact(ctx, req, opts...)
}

// ReplaceArtifact used to replace a specified artifact.
func (c *RegistryClient) ReplaceArtifact(ctx context.Context, req *apigeeregistrypb.ReplaceArtifactRequest, opts ...gax.CallOption) (*apigeeregistrypb.Artifact, error) {
	return c.internalClient.ReplaceArtifact(ctx, req, opts...)
}

// DeleteArtifact removes a specified artifact.
func (c *RegistryClient) DeleteArtifact(ctx context.Context, req *apigeeregistrypb.DeleteArtifactRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteArtifact(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *RegistryClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *RegistryClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *RegistryClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *RegistryClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *RegistryClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *RegistryClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *RegistryClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *RegistryClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *RegistryClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// registryGRPCClient is a client for interacting with Apigee Registry API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type registryGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing RegistryClient
	CallOptions **RegistryCallOptions

	// The gRPC API client.
	registryClient apigeeregistrypb.RegistryClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewRegistryClient creates a new registry client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The Registry service allows teams to manage descriptions of APIs.
func NewRegistryClient(ctx context.Context, opts ...option.ClientOption) (*RegistryClient, error) {
	clientOpts := defaultRegistryGRPCClientOptions()
	if newRegistryClientHook != nil {
		hookOpts, err := newRegistryClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := RegistryClient{CallOptions: defaultRegistryCallOptions()}

	c := &registryGRPCClient{
		connPool:         connPool,
		registryClient:   apigeeregistrypb.NewRegistryClient(connPool),
		CallOptions:      &client.CallOptions,
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:  iampb.NewIAMPolicyClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *registryGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *registryGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *registryGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *registryGRPCClient) ListApis(ctx context.Context, req *apigeeregistrypb.ListApisRequest, opts ...gax.CallOption) *ApiIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListApis[0:len((*c.CallOptions).ListApis):len((*c.CallOptions).ListApis)], opts...)
	it := &ApiIterator{}
	req = proto.Clone(req).(*apigeeregistrypb.ListApisRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*apigeeregistrypb.Api, string, error) {
		resp := &apigeeregistrypb.ListApisResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.registryClient.ListApis(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetApis(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) GetApi(ctx context.Context, req *apigeeregistrypb.GetApiRequest, opts ...gax.CallOption) (*apigeeregistrypb.Api, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetApi[0:len((*c.CallOptions).GetApi):len((*c.CallOptions).GetApi)], opts...)
	var resp *apigeeregistrypb.Api
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.GetApi(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) CreateApi(ctx context.Context, req *apigeeregistrypb.CreateApiRequest, opts ...gax.CallOption) (*apigeeregistrypb.Api, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateApi[0:len((*c.CallOptions).CreateApi):len((*c.CallOptions).CreateApi)], opts...)
	var resp *apigeeregistrypb.Api
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.CreateApi(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) UpdateApi(ctx context.Context, req *apigeeregistrypb.UpdateApiRequest, opts ...gax.CallOption) (*apigeeregistrypb.Api, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "api.name", url.QueryEscape(req.GetApi().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateApi[0:len((*c.CallOptions).UpdateApi):len((*c.CallOptions).UpdateApi)], opts...)
	var resp *apigeeregistrypb.Api
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.UpdateApi(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) DeleteApi(ctx context.Context, req *apigeeregistrypb.DeleteApiRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApi[0:len((*c.CallOptions).DeleteApi):len((*c.CallOptions).DeleteApi)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.registryClient.DeleteApi(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *registryGRPCClient) ListApiVersions(ctx context.Context, req *apigeeregistrypb.ListApiVersionsRequest, opts ...gax.CallOption) *ApiVersionIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListApiVersions[0:len((*c.CallOptions).ListApiVersions):len((*c.CallOptions).ListApiVersions)], opts...)
	it := &ApiVersionIterator{}
	req = proto.Clone(req).(*apigeeregistrypb.ListApiVersionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*apigeeregistrypb.ApiVersion, string, error) {
		resp := &apigeeregistrypb.ListApiVersionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.registryClient.ListApiVersions(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetApiVersions(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) GetApiVersion(ctx context.Context, req *apigeeregistrypb.GetApiVersionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetApiVersion[0:len((*c.CallOptions).GetApiVersion):len((*c.CallOptions).GetApiVersion)], opts...)
	var resp *apigeeregistrypb.ApiVersion
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.GetApiVersion(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) CreateApiVersion(ctx context.Context, req *apigeeregistrypb.CreateApiVersionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateApiVersion[0:len((*c.CallOptions).CreateApiVersion):len((*c.CallOptions).CreateApiVersion)], opts...)
	var resp *apigeeregistrypb.ApiVersion
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.CreateApiVersion(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) UpdateApiVersion(ctx context.Context, req *apigeeregistrypb.UpdateApiVersionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiVersion, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "api_version.name", url.QueryEscape(req.GetApiVersion().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateApiVersion[0:len((*c.CallOptions).UpdateApiVersion):len((*c.CallOptions).UpdateApiVersion)], opts...)
	var resp *apigeeregistrypb.ApiVersion
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.UpdateApiVersion(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) DeleteApiVersion(ctx context.Context, req *apigeeregistrypb.DeleteApiVersionRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApiVersion[0:len((*c.CallOptions).DeleteApiVersion):len((*c.CallOptions).DeleteApiVersion)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.registryClient.DeleteApiVersion(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *registryGRPCClient) ListApiSpecs(ctx context.Context, req *apigeeregistrypb.ListApiSpecsRequest, opts ...gax.CallOption) *ApiSpecIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListApiSpecs[0:len((*c.CallOptions).ListApiSpecs):len((*c.CallOptions).ListApiSpecs)], opts...)
	it := &ApiSpecIterator{}
	req = proto.Clone(req).(*apigeeregistrypb.ListApiSpecsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*apigeeregistrypb.ApiSpec, string, error) {
		resp := &apigeeregistrypb.ListApiSpecsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.registryClient.ListApiSpecs(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetApiSpecs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) GetApiSpec(ctx context.Context, req *apigeeregistrypb.GetApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetApiSpec[0:len((*c.CallOptions).GetApiSpec):len((*c.CallOptions).GetApiSpec)], opts...)
	var resp *apigeeregistrypb.ApiSpec
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.GetApiSpec(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) GetApiSpecContents(ctx context.Context, req *apigeeregistrypb.GetApiSpecContentsRequest, opts ...gax.CallOption) (*httpbodypb.HttpBody, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetApiSpecContents[0:len((*c.CallOptions).GetApiSpecContents):len((*c.CallOptions).GetApiSpecContents)], opts...)
	var resp *httpbodypb.HttpBody
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.GetApiSpecContents(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) CreateApiSpec(ctx context.Context, req *apigeeregistrypb.CreateApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateApiSpec[0:len((*c.CallOptions).CreateApiSpec):len((*c.CallOptions).CreateApiSpec)], opts...)
	var resp *apigeeregistrypb.ApiSpec
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.CreateApiSpec(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) UpdateApiSpec(ctx context.Context, req *apigeeregistrypb.UpdateApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "api_spec.name", url.QueryEscape(req.GetApiSpec().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateApiSpec[0:len((*c.CallOptions).UpdateApiSpec):len((*c.CallOptions).UpdateApiSpec)], opts...)
	var resp *apigeeregistrypb.ApiSpec
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.UpdateApiSpec(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) DeleteApiSpec(ctx context.Context, req *apigeeregistrypb.DeleteApiSpecRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApiSpec[0:len((*c.CallOptions).DeleteApiSpec):len((*c.CallOptions).DeleteApiSpec)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.registryClient.DeleteApiSpec(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *registryGRPCClient) TagApiSpecRevision(ctx context.Context, req *apigeeregistrypb.TagApiSpecRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TagApiSpecRevision[0:len((*c.CallOptions).TagApiSpecRevision):len((*c.CallOptions).TagApiSpecRevision)], opts...)
	var resp *apigeeregistrypb.ApiSpec
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.TagApiSpecRevision(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) ListApiSpecRevisions(ctx context.Context, req *apigeeregistrypb.ListApiSpecRevisionsRequest, opts ...gax.CallOption) *ApiSpecIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListApiSpecRevisions[0:len((*c.CallOptions).ListApiSpecRevisions):len((*c.CallOptions).ListApiSpecRevisions)], opts...)
	it := &ApiSpecIterator{}
	req = proto.Clone(req).(*apigeeregistrypb.ListApiSpecRevisionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*apigeeregistrypb.ApiSpec, string, error) {
		resp := &apigeeregistrypb.ListApiSpecRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.registryClient.ListApiSpecRevisions(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetApiSpecs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) RollbackApiSpec(ctx context.Context, req *apigeeregistrypb.RollbackApiSpecRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RollbackApiSpec[0:len((*c.CallOptions).RollbackApiSpec):len((*c.CallOptions).RollbackApiSpec)], opts...)
	var resp *apigeeregistrypb.ApiSpec
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.RollbackApiSpec(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) DeleteApiSpecRevision(ctx context.Context, req *apigeeregistrypb.DeleteApiSpecRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiSpec, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApiSpecRevision[0:len((*c.CallOptions).DeleteApiSpecRevision):len((*c.CallOptions).DeleteApiSpecRevision)], opts...)
	var resp *apigeeregistrypb.ApiSpec
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.DeleteApiSpecRevision(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) ListApiDeployments(ctx context.Context, req *apigeeregistrypb.ListApiDeploymentsRequest, opts ...gax.CallOption) *ApiDeploymentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListApiDeployments[0:len((*c.CallOptions).ListApiDeployments):len((*c.CallOptions).ListApiDeployments)], opts...)
	it := &ApiDeploymentIterator{}
	req = proto.Clone(req).(*apigeeregistrypb.ListApiDeploymentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*apigeeregistrypb.ApiDeployment, string, error) {
		resp := &apigeeregistrypb.ListApiDeploymentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.registryClient.ListApiDeployments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetApiDeployments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) GetApiDeployment(ctx context.Context, req *apigeeregistrypb.GetApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetApiDeployment[0:len((*c.CallOptions).GetApiDeployment):len((*c.CallOptions).GetApiDeployment)], opts...)
	var resp *apigeeregistrypb.ApiDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.GetApiDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) CreateApiDeployment(ctx context.Context, req *apigeeregistrypb.CreateApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateApiDeployment[0:len((*c.CallOptions).CreateApiDeployment):len((*c.CallOptions).CreateApiDeployment)], opts...)
	var resp *apigeeregistrypb.ApiDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.CreateApiDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) UpdateApiDeployment(ctx context.Context, req *apigeeregistrypb.UpdateApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "api_deployment.name", url.QueryEscape(req.GetApiDeployment().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateApiDeployment[0:len((*c.CallOptions).UpdateApiDeployment):len((*c.CallOptions).UpdateApiDeployment)], opts...)
	var resp *apigeeregistrypb.ApiDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.UpdateApiDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) DeleteApiDeployment(ctx context.Context, req *apigeeregistrypb.DeleteApiDeploymentRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApiDeployment[0:len((*c.CallOptions).DeleteApiDeployment):len((*c.CallOptions).DeleteApiDeployment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.registryClient.DeleteApiDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *registryGRPCClient) TagApiDeploymentRevision(ctx context.Context, req *apigeeregistrypb.TagApiDeploymentRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TagApiDeploymentRevision[0:len((*c.CallOptions).TagApiDeploymentRevision):len((*c.CallOptions).TagApiDeploymentRevision)], opts...)
	var resp *apigeeregistrypb.ApiDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.TagApiDeploymentRevision(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) ListApiDeploymentRevisions(ctx context.Context, req *apigeeregistrypb.ListApiDeploymentRevisionsRequest, opts ...gax.CallOption) *ApiDeploymentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListApiDeploymentRevisions[0:len((*c.CallOptions).ListApiDeploymentRevisions):len((*c.CallOptions).ListApiDeploymentRevisions)], opts...)
	it := &ApiDeploymentIterator{}
	req = proto.Clone(req).(*apigeeregistrypb.ListApiDeploymentRevisionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*apigeeregistrypb.ApiDeployment, string, error) {
		resp := &apigeeregistrypb.ListApiDeploymentRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.registryClient.ListApiDeploymentRevisions(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetApiDeployments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) RollbackApiDeployment(ctx context.Context, req *apigeeregistrypb.RollbackApiDeploymentRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RollbackApiDeployment[0:len((*c.CallOptions).RollbackApiDeployment):len((*c.CallOptions).RollbackApiDeployment)], opts...)
	var resp *apigeeregistrypb.ApiDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.RollbackApiDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) DeleteApiDeploymentRevision(ctx context.Context, req *apigeeregistrypb.DeleteApiDeploymentRevisionRequest, opts ...gax.CallOption) (*apigeeregistrypb.ApiDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteApiDeploymentRevision[0:len((*c.CallOptions).DeleteApiDeploymentRevision):len((*c.CallOptions).DeleteApiDeploymentRevision)], opts...)
	var resp *apigeeregistrypb.ApiDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.DeleteApiDeploymentRevision(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) ListArtifacts(ctx context.Context, req *apigeeregistrypb.ListArtifactsRequest, opts ...gax.CallOption) *ArtifactIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListArtifacts[0:len((*c.CallOptions).ListArtifacts):len((*c.CallOptions).ListArtifacts)], opts...)
	it := &ArtifactIterator{}
	req = proto.Clone(req).(*apigeeregistrypb.ListArtifactsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*apigeeregistrypb.Artifact, string, error) {
		resp := &apigeeregistrypb.ListArtifactsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.registryClient.ListArtifacts(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetArtifacts(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) GetArtifact(ctx context.Context, req *apigeeregistrypb.GetArtifactRequest, opts ...gax.CallOption) (*apigeeregistrypb.Artifact, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetArtifact[0:len((*c.CallOptions).GetArtifact):len((*c.CallOptions).GetArtifact)], opts...)
	var resp *apigeeregistrypb.Artifact
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.GetArtifact(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) GetArtifactContents(ctx context.Context, req *apigeeregistrypb.GetArtifactContentsRequest, opts ...gax.CallOption) (*httpbodypb.HttpBody, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetArtifactContents[0:len((*c.CallOptions).GetArtifactContents):len((*c.CallOptions).GetArtifactContents)], opts...)
	var resp *httpbodypb.HttpBody
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.GetArtifactContents(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) CreateArtifact(ctx context.Context, req *apigeeregistrypb.CreateArtifactRequest, opts ...gax.CallOption) (*apigeeregistrypb.Artifact, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateArtifact[0:len((*c.CallOptions).CreateArtifact):len((*c.CallOptions).CreateArtifact)], opts...)
	var resp *apigeeregistrypb.Artifact
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.CreateArtifact(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) ReplaceArtifact(ctx context.Context, req *apigeeregistrypb.ReplaceArtifactRequest, opts ...gax.CallOption) (*apigeeregistrypb.Artifact, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "artifact.name", url.QueryEscape(req.GetArtifact().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReplaceArtifact[0:len((*c.CallOptions).ReplaceArtifact):len((*c.CallOptions).ReplaceArtifact)], opts...)
	var resp *apigeeregistrypb.Artifact
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.registryClient.ReplaceArtifact(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) DeleteArtifact(ctx context.Context, req *apigeeregistrypb.DeleteArtifactRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteArtifact[0:len((*c.CallOptions).DeleteArtifact):len((*c.CallOptions).DeleteArtifact)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.registryClient.DeleteArtifact(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *registryGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.locationsClient.GetLocation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.locationsClient.ListLocations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *registryGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.GetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.SetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.TestIamPermissions(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *registryGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *registryGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *registryGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
