//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securityinsights/armsecurityinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ThreatIntelligenceIndicatorMetricsServer is a fake server for instances of the armsecurityinsights.ThreatIntelligenceIndicatorMetricsClient type.
type ThreatIntelligenceIndicatorMetricsServer struct {
	// List is the fake for method ThreatIntelligenceIndicatorMetricsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, workspaceName string, options *armsecurityinsights.ThreatIntelligenceIndicatorMetricsClientListOptions) (resp azfake.Responder[armsecurityinsights.ThreatIntelligenceIndicatorMetricsClientListResponse], errResp azfake.ErrorResponder)
}

// NewThreatIntelligenceIndicatorMetricsServerTransport creates a new instance of ThreatIntelligenceIndicatorMetricsServerTransport with the provided implementation.
// The returned ThreatIntelligenceIndicatorMetricsServerTransport instance is connected to an instance of armsecurityinsights.ThreatIntelligenceIndicatorMetricsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewThreatIntelligenceIndicatorMetricsServerTransport(srv *ThreatIntelligenceIndicatorMetricsServer) *ThreatIntelligenceIndicatorMetricsServerTransport {
	return &ThreatIntelligenceIndicatorMetricsServerTransport{srv: srv}
}

// ThreatIntelligenceIndicatorMetricsServerTransport connects instances of armsecurityinsights.ThreatIntelligenceIndicatorMetricsClient to instances of ThreatIntelligenceIndicatorMetricsServer.
// Don't use this type directly, use NewThreatIntelligenceIndicatorMetricsServerTransport instead.
type ThreatIntelligenceIndicatorMetricsServerTransport struct {
	srv *ThreatIntelligenceIndicatorMetricsServer
}

// Do implements the policy.Transporter interface for ThreatIntelligenceIndicatorMetricsServerTransport.
func (t *ThreatIntelligenceIndicatorMetricsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ThreatIntelligenceIndicatorMetricsClient.List":
		resp, err = t.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *ThreatIntelligenceIndicatorMetricsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if t.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/threatIntelligence/main/metrics`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.List(req.Context(), resourceGroupNameParam, workspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThreatIntelligenceMetricsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
