# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Set common HTTP headers."""

from django.http import HttpRequest, HttpResponseBase
from django.utils.cache import patch_vary_headers
from django.utils.deprecation import MiddlewareMixin


class HeadersMiddleware(MiddlewareMixin):
    """Set common HTTP headers."""

    def process_response(
        self,
        request: HttpRequest,  # noqa: U100
        response: HttpResponseBase,
    ) -> HttpResponseBase:
        """Process response in middleware."""
        # Don't allow caches to use responses to satisfy requests that have
        # different authentication.
        patch_vary_headers(response, ("Cookie", "Token"))
        return response
