#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 Alarig Le Lay
set -o errexit

###
# Mini Metro
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250521.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='mini-metro'
GAME_NAME='Mini Metro'

ARCHIVE_BASE_1_NAME='MiniMetro-release-53-linux.tar.gz'
ARCHIVE_BASE_1_MD5='67f52adb9cacd494bb79c76cfb36931d'
ARCHIVE_BASE_1_SIZE='330000'
ARCHIVE_BASE_1_VERSION='53-humble1'
ARCHIVE_BASE_1_URL='https://www.humblebundle.com/store/mini-metro'

ARCHIVE_BASE_0_NAME='MiniMetro-release-50a-linux.tar.gz'
ARCHIVE_BASE_0_MD5='93577776ea002a6e0a8dc482486ff174'
ARCHIVE_BASE_0_SIZE='320000'
ARCHIVE_BASE_0_VERSION='50a-humble1'

UNITY3D_NAME='Mini Metro'
UNITY3D_PLUGINS='
libminimetrox.so'

CONTENT_PATH_DEFAULT='.'

## The game fails to run with the wayland backend of SDL,
## spamming errors about libminimetrox.so.
APP_MAIN_PRERUN='
# The game fails to run with the wayland backend of SDL.
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
