#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Detective Gallo
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240823.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='detective-gallo'
GAME_NAME='Detective Gallo'

ARCHIVE_BASE_0_NAME='setup_detective_gallo_1.21_(29213).exe'
ARCHIVE_BASE_0_MD5='8e11f1d9d90468d1835cc68da7acb604'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_detective_gallo_1.21_(29213)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='93b24aafa234dd6e6dd053df5f3f594a'
ARCHIVE_BASE_0_SIZE='4500000'
ARCHIVE_BASE_0_VERSION='1.21-gog29213'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/detective_gallo'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES='
acsetup.cfg
*.0??
*.exe
*.tra
*.vox'
## TODO: Check if the shipped library is required
CONTENT_GAME0_MAIN_FILES='
agsd3dvsync.dll'
CONTENT_DOC_MAIN_FILES='
docs'

APP_MAIN_SCUMMID='ags:detectivegallo'
APP_MAIN_ICON='detective gallo.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
