#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Year of Springs
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240905.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='a-year-of-springs'
GAME_NAME='A Year of Springs'

ARCHIVE_BASE_0_NAME='a_year_of_springs_1_05_60321.sh'
ARCHIVE_BASE_0_MD5='683044c44f06061a84490c2a02b5303b'
ARCHIVE_BASE_0_SIZE='248120'
ARCHIVE_BASE_0_VERSION='1.05-gog60321'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/a_year_of_springs'

CONTENT_PATH_DEFAULT='data/noarch/game/ayearofsprings-market/game'
CONTENT_GAME_MAIN_FILES='
cache
presplash_background.png
presplash_foreground.png
assets.rpa
scripts.rpa
script_version.txt'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='../../../support/icon.png'

## Ensure easy upgrades from packages generated with pre-20240905.1 game scripts.
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
a-year-of-springs-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
