; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X64

define i64 @testmsxs(float %x) {
; GISEL-X86-LABEL: testmsxs:
; GISEL-X86:       # %bb.0: # %entry
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl %eax, (%esp)
; GISEL-X86-NEXT:    calll lroundf
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 4
; GISEL-X86-NEXT:    retl
;
; CHECK-LABEL: testmsxs:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lroundf@PLT # TAILCALL
;
; GISEL-X64-LABEL: testmsxs:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X64-NEXT:    callq lroundf
; GISEL-X64-NEXT:    popq %rcx
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 8
; GISEL-X64-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.lround.i64.f32(float %x)
  ret i64 %0
}

define i64 @testmsxd(double %x) {
; GISEL-X86-LABEL: testmsxd:
; GISEL-X86:       # %bb.0: # %entry
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl 4(%eax), %eax
; GISEL-X86-NEXT:    xorl %edx, %edx
; GISEL-X86-NEXT:    addl %esp, %edx
; GISEL-X86-NEXT:    movl %ecx, (%esp)
; GISEL-X86-NEXT:    movl %eax, 4(%edx)
; GISEL-X86-NEXT:    calll lround
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 4
; GISEL-X86-NEXT:    retl
;
; CHECK-LABEL: testmsxd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lround@PLT # TAILCALL
;
; GISEL-X64-LABEL: testmsxd:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X64-NEXT:    callq lround
; GISEL-X64-NEXT:    popq %rcx
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 8
; GISEL-X64-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.lround.i64.f64(double %x)
  ret i64 %0
}

define i64 @testmsll(x86_fp80 %x) {
; GISEL-X86-LABEL: testmsll:
; GISEL-X86:       # %bb.0: # %entry
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fstpt (%esp)
; GISEL-X86-NEXT:    calll lroundl
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 4
; GISEL-X86-NEXT:    retl
;
; CHECK-LABEL: testmsll:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lroundl@PLT # TAILCALL
;
; GISEL-X64-LABEL: testmsll:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    subq $24, %rsp
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 32
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fstpt (%rsp)
; GISEL-X64-NEXT:    callq lroundl
; GISEL-X64-NEXT:    addq $24, %rsp
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 8
; GISEL-X64-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.lround.i64.f80(x86_fp80 %x)
  ret i64 %0
}
