; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-- -passes=amdgpu-simplifylib < %s | FileCheck %s

; private variant of sincos is defined but marked nobuiltin, so
; introduce a call to the generic one.

define float @_Z3sinf(float %x) {
; CHECK-LABEL: define float @_Z3sinf
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = call float asm "
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float asm "; $0 = sin($1)","=v,v"(float %x)
  ret float %result
}

define float @_Z3cosf(float %x) {
; CHECK-LABEL: define float @_Z3cosf
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = call float asm "
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float asm "; $0 = cos($1)","=v,v"(float %x)
  ret float %result
}

define float @_Z6sincosfPU3AS5f(float %x, ptr addrspace(5) %ptr) nobuiltin {
; CHECK-LABEL: define float @_Z6sincosfPU3AS5f
; CHECK-SAME: (float [[X:%.*]], ptr addrspace(5) [[PTR:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[RESULT0:%.*]] = call float asm "
; CHECK-NEXT:    [[RESULT1:%.*]] = call float asm "
; CHECK-NEXT:    store float [[RESULT1]], ptr addrspace(5) [[PTR]], align 4
; CHECK-NEXT:    ret float [[RESULT0]]
;
  %result0 = call float asm "; $0 = sin($1)","=v,v"(float %x)
  %result1 = call float asm "; $0 = cos($1)","=v,v"(float %x)
  store float %result1, ptr addrspace(5) %ptr
  ret float %result0
}

define float @_Z6sincosfPU3AS0f(float %x, ptr %ptr) {
; CHECK-LABEL: define float @_Z6sincosfPU3AS0f
; CHECK-SAME: (float [[X:%.*]], ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[RESULT0:%.*]] = call float asm "
; CHECK-NEXT:    [[RESULT1:%.*]] = call float asm "
; CHECK-NEXT:    store float [[RESULT1]], ptr [[PTR]], align 4
; CHECK-NEXT:    ret float [[RESULT0]]
;
  %result0 = call float asm "; $0 = sin($1)","=v,v"(float %x)
  %result1 = call float asm "; $0 = cos($1)","=v,v"(float %x)
  store float %result1, ptr %ptr
  ret float %result0
}

define void @sincos_f32(float %x, ptr addrspace(1) nocapture writeonly %sin_out, ptr addrspace(1) nocapture writeonly %cos_out) {
; CHECK-LABEL: define void @sincos_f32
; CHECK-SAME: (float [[X:%.*]], ptr addrspace(1) writeonly captures(none) [[SIN_OUT:%.*]], ptr addrspace(1) writeonly captures(none) [[COS_OUT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[__SINCOS_:%.*]] = alloca float, align 4, addrspace(5)
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr addrspace(5) [[__SINCOS_]] to ptr
; CHECK-NEXT:    [[TMP1:%.*]] = call contract float @_Z6sincosfPU3AS0f(float [[X]], ptr [[TMP0]])
; CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr addrspace(5) [[__SINCOS_]], align 4
; CHECK-NEXT:    store float [[TMP1]], ptr addrspace(1) [[SIN_OUT]], align 4
; CHECK-NEXT:    [[CALL1:%.*]] = tail call contract float @_Z3cosf(float [[X]])
; CHECK-NEXT:    store float [[TMP2]], ptr addrspace(1) [[COS_OUT]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %call = tail call contract float @_Z3sinf(float %x)
  store float %call, ptr addrspace(1) %sin_out, align 4
  %call1 = tail call contract float @_Z3cosf(float %x)
  store float %call1, ptr addrspace(1) %cos_out, align 4
  ret void
}
