; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK-LINUX
; RUN: llc -mtriple=aarch64-none-eabi < %s | FileCheck %s --check-prefixes=CHECK-LINUX
; RUN: llc -mtriple=aarch64-pc-windows-msvc < %s | FileCheck %s --check-prefix=CHECK-PC
; RUN: llc -mtriple=aarch64-apple-darwin < %s | FileCheck %s --check-prefixes=CHECK-APPLE

@trampg = internal global [36 x i8] zeroinitializer, align 8

declare void @llvm.init.trampoline(ptr, ptr, ptr);
declare ptr @llvm.adjust.trampoline(ptr);

define ptr @f(ptr nest %x, i64 %y) {
; CHECK-LINUX-LABEL: f:
; CHECK-LINUX:       // %bb.0:
; CHECK-LINUX-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-LINUX-NEXT:    sub sp, sp, #237, lsl #12 // =970752
; CHECK-LINUX-NEXT:    sub sp, sp, #3264
; CHECK-LINUX-NEXT:    .cfi_def_cfa_offset 974032
; CHECK-LINUX-NEXT:    .cfi_offset w29, -16
; CHECK-LINUX-NEXT:    add x0, x15, x0
; CHECK-LINUX-NEXT:    add sp, sp, #237, lsl #12 // =970752
; CHECK-LINUX-NEXT:    add sp, sp, #3264
; CHECK-LINUX-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-LINUX-NEXT:    ret
;
; CHECK-PC-LABEL: f:
; CHECK-PC:       .seh_proc f
; CHECK-PC-NEXT:  // %bb.0:
; CHECK-PC-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-PC-NEXT:    .seh_save_fplr_x 16
; CHECK-PC-NEXT:    mov x9, x15
; CHECK-PC-NEXT:    mov x15, #60876 // =0xedcc
; CHECK-PC-NEXT:    .seh_nop
; CHECK-PC-NEXT:    bl __chkstk
; CHECK-PC-NEXT:    .seh_nop
; CHECK-PC-NEXT:    sub sp, sp, x15, lsl #4
; CHECK-PC-NEXT:    .seh_stackalloc 974016
; CHECK-PC-NEXT:    mov x15, x9
; CHECK-PC-NEXT:    .seh_endprologue
; CHECK-PC-NEXT:    add x0, x15, x0
; CHECK-PC-NEXT:    .seh_startepilogue
; CHECK-PC-NEXT:    add sp, sp, #237, lsl #12 // =970752
; CHECK-PC-NEXT:    .seh_stackalloc 970752
; CHECK-PC-NEXT:    add sp, sp, #3264
; CHECK-PC-NEXT:    .seh_stackalloc 3264
; CHECK-PC-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-PC-NEXT:    .seh_save_fplr_x 16
; CHECK-PC-NEXT:    .seh_endepilogue
; CHECK-PC-NEXT:    ret
; CHECK-PC-NEXT:    .seh_endfunclet
; CHECK-PC-NEXT:    .seh_endproc
;
; CHECK-APPLE-LABEL: f:
; CHECK-APPLE:       ; %bb.0:
; CHECK-APPLE-NEXT:    stp x28, x27, [sp, #-16]! ; 16-byte Folded Spill
; CHECK-APPLE-NEXT:    sub sp, sp, #237, lsl #12 ; =970752
; CHECK-APPLE-NEXT:    sub sp, sp, #3264
; CHECK-APPLE-NEXT:    .cfi_def_cfa_offset 974032
; CHECK-APPLE-NEXT:    .cfi_offset w27, -8
; CHECK-APPLE-NEXT:    .cfi_offset w28, -16
; CHECK-APPLE-NEXT:    add x0, x15, x0
; CHECK-APPLE-NEXT:    add sp, sp, #237, lsl #12 ; =970752
; CHECK-APPLE-NEXT:    add sp, sp, #3264
; CHECK-APPLE-NEXT:    ldp x28, x27, [sp], #16 ; 16-byte Folded Reload
; CHECK-APPLE-NEXT:    ret
  %chkstack = alloca [u0xedcba x i8]
  %sum = getelementptr i8, ptr %x, i64 %y
  ret ptr %sum
}

define i64 @func1() {
; CHECK-LINUX-LABEL: func1:
; CHECK-LINUX:       // %bb.0:
; CHECK-LINUX-NEXT:    sub sp, sp, #64
; CHECK-LINUX-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-LINUX-NEXT:    .cfi_def_cfa_offset 64
; CHECK-LINUX-NEXT:    .cfi_offset w30, -16
; CHECK-LINUX-NEXT:    adrp x8, :got:f
; CHECK-LINUX-NEXT:    mov w9, #544 // =0x220
; CHECK-LINUX-NEXT:    add x0, sp, #8
; CHECK-LINUX-NEXT:    ldr x8, [x8, :got_lo12:f]
; CHECK-LINUX-NEXT:    movk w9, #54815, lsl #16
; CHECK-LINUX-NEXT:    str w9, [sp, #16]
; CHECK-LINUX-NEXT:    add x9, sp, #56
; CHECK-LINUX-NEXT:    stp x9, x8, [sp, #24]
; CHECK-LINUX-NEXT:    mov x8, #143 // =0x8f
; CHECK-LINUX-NEXT:    movk x8, #22528, lsl #16
; CHECK-LINUX-NEXT:    movk x8, #177, lsl #32
; CHECK-LINUX-NEXT:    movk x8, #22528, lsl #48
; CHECK-LINUX-NEXT:    str x8, [sp, #8]
; CHECK-LINUX-NEXT:    add x8, sp, #8
; CHECK-LINUX-NEXT:    add x1, x8, #12
; CHECK-LINUX-NEXT:    bl __clear_cache
; CHECK-LINUX-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-LINUX-NEXT:    mov x0, xzr
; CHECK-LINUX-NEXT:    add sp, sp, #64
; CHECK-LINUX-NEXT:    ret
;
; CHECK-PC-LABEL: func1:
; CHECK-PC:       .seh_proc func1
; CHECK-PC-NEXT:  // %bb.0:
; CHECK-PC-NEXT:    sub sp, sp, #64
; CHECK-PC-NEXT:    .seh_stackalloc 64
; CHECK-PC-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-PC-NEXT:    .seh_save_reg x30, 48
; CHECK-PC-NEXT:    .seh_endprologue
; CHECK-PC-NEXT:    adrp x8, f
; CHECK-PC-NEXT:    add x8, x8, :lo12:f
; CHECK-PC-NEXT:    add x9, sp, #56
; CHECK-PC-NEXT:    stp x9, x8, [sp, #24]
; CHECK-PC-NEXT:    mov w8, #544 // =0x220
; CHECK-PC-NEXT:    add x0, sp, #8
; CHECK-PC-NEXT:    movk w8, #54815, lsl #16
; CHECK-PC-NEXT:    str w8, [sp, #16]
; CHECK-PC-NEXT:    mov x8, #143 // =0x8f
; CHECK-PC-NEXT:    movk x8, #22528, lsl #16
; CHECK-PC-NEXT:    movk x8, #177, lsl #32
; CHECK-PC-NEXT:    movk x8, #22528, lsl #48
; CHECK-PC-NEXT:    str x8, [sp, #8]
; CHECK-PC-NEXT:    add x8, sp, #8
; CHECK-PC-NEXT:    add x1, x8, #12
; CHECK-PC-NEXT:    bl __clear_cache
; CHECK-PC-NEXT:    mov x0, xzr
; CHECK-PC-NEXT:    .seh_startepilogue
; CHECK-PC-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-PC-NEXT:    .seh_save_reg x30, 48
; CHECK-PC-NEXT:    add sp, sp, #64
; CHECK-PC-NEXT:    .seh_stackalloc 64
; CHECK-PC-NEXT:    .seh_endepilogue
; CHECK-PC-NEXT:    ret
; CHECK-PC-NEXT:    .seh_endfunclet
; CHECK-PC-NEXT:    .seh_endproc
;
; CHECK-APPLE-LABEL: func1:
; CHECK-APPLE:       ; %bb.0:
; CHECK-APPLE-NEXT:    sub sp, sp, #64
; CHECK-APPLE-NEXT:    stp x29, x30, [sp, #48] ; 16-byte Folded Spill
; CHECK-APPLE-NEXT:    .cfi_def_cfa_offset 64
; CHECK-APPLE-NEXT:    .cfi_offset w30, -8
; CHECK-APPLE-NEXT:    .cfi_offset w29, -16
; CHECK-APPLE-NEXT:  Lloh0:
; CHECK-APPLE-NEXT:    adrp x8, _f@PAGE
; CHECK-APPLE-NEXT:  Lloh1:
; CHECK-APPLE-NEXT:    add x8, x8, _f@PAGEOFF
; CHECK-APPLE-NEXT:    add x9, sp, #40
; CHECK-APPLE-NEXT:    stp x9, x8, [sp, #16]
; CHECK-APPLE-NEXT:    mov w8, #544 ; =0x220
; CHECK-APPLE-NEXT:    mov x0, sp
; CHECK-APPLE-NEXT:    movk w8, #54815, lsl #16
; CHECK-APPLE-NEXT:    str w8, [sp, #8]
; CHECK-APPLE-NEXT:    mov x8, #143 ; =0x8f
; CHECK-APPLE-NEXT:    movk x8, #22528, lsl #16
; CHECK-APPLE-NEXT:    movk x8, #177, lsl #32
; CHECK-APPLE-NEXT:    movk x8, #22528, lsl #48
; CHECK-APPLE-NEXT:    str x8, [sp]
; CHECK-APPLE-NEXT:    mov x8, sp
; CHECK-APPLE-NEXT:    add x1, x8, #12
; CHECK-APPLE-NEXT:    bl ___clear_cache
; CHECK-APPLE-NEXT:    ldp x29, x30, [sp, #48] ; 16-byte Folded Reload
; CHECK-APPLE-NEXT:    mov x0, xzr
; CHECK-APPLE-NEXT:    add sp, sp, #64
; CHECK-APPLE-NEXT:    ret
; CHECK-APPLE-NEXT:    .loh AdrpAdd Lloh0, Lloh1
  %val = alloca i64
  %tramp = alloca [36 x i8], align 8
  call void @llvm.init.trampoline(ptr %tramp, ptr @f, ptr %val)
  %fp = call ptr @llvm.adjust.trampoline(ptr %tramp)
  ret i64 0
}

define i64 @func2() {
; CHECK-LINUX-LABEL: func2:
; CHECK-LINUX:       // %bb.0:
; CHECK-LINUX-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-LINUX-NEXT:    .cfi_def_cfa_offset 16
; CHECK-LINUX-NEXT:    .cfi_offset w30, -16
; CHECK-LINUX-NEXT:    adrp x8, :got:f
; CHECK-LINUX-NEXT:    mov w9, #544 // =0x220
; CHECK-LINUX-NEXT:    adrp x0, trampg
; CHECK-LINUX-NEXT:    add x0, x0, :lo12:trampg
; CHECK-LINUX-NEXT:    ldr x8, [x8, :got_lo12:f]
; CHECK-LINUX-NEXT:    movk w9, #54815, lsl #16
; CHECK-LINUX-NEXT:    str w9, [x0, #8]
; CHECK-LINUX-NEXT:    add x9, sp, #8
; CHECK-LINUX-NEXT:    add x1, x0, #12
; CHECK-LINUX-NEXT:    stp x9, x8, [x0, #16]
; CHECK-LINUX-NEXT:    mov x8, #143 // =0x8f
; CHECK-LINUX-NEXT:    movk x8, #22528, lsl #16
; CHECK-LINUX-NEXT:    movk x8, #177, lsl #32
; CHECK-LINUX-NEXT:    movk x8, #22528, lsl #48
; CHECK-LINUX-NEXT:    str x8, [x0]
; CHECK-LINUX-NEXT:    bl __clear_cache
; CHECK-LINUX-NEXT:    mov x0, xzr
; CHECK-LINUX-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-LINUX-NEXT:    ret
;
; CHECK-PC-LABEL: func2:
; CHECK-PC:       .seh_proc func2
; CHECK-PC-NEXT:  // %bb.0:
; CHECK-PC-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-PC-NEXT:    .seh_save_reg_x x30, 16
; CHECK-PC-NEXT:    .seh_endprologue
; CHECK-PC-NEXT:    adrp x0, trampg
; CHECK-PC-NEXT:    add x0, x0, :lo12:trampg
; CHECK-PC-NEXT:    adrp x8, f
; CHECK-PC-NEXT:    add x8, x8, :lo12:f
; CHECK-PC-NEXT:    add x9, sp, #8
; CHECK-PC-NEXT:    add x1, x0, #12
; CHECK-PC-NEXT:    stp x9, x8, [x0, #16]
; CHECK-PC-NEXT:    mov w8, #544 // =0x220
; CHECK-PC-NEXT:    movk w8, #54815, lsl #16
; CHECK-PC-NEXT:    str w8, [x0, #8]
; CHECK-PC-NEXT:    mov x8, #143 // =0x8f
; CHECK-PC-NEXT:    movk x8, #22528, lsl #16
; CHECK-PC-NEXT:    movk x8, #177, lsl #32
; CHECK-PC-NEXT:    movk x8, #22528, lsl #48
; CHECK-PC-NEXT:    str x8, [x0]
; CHECK-PC-NEXT:    bl __clear_cache
; CHECK-PC-NEXT:    mov x0, xzr
; CHECK-PC-NEXT:    .seh_startepilogue
; CHECK-PC-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-PC-NEXT:    .seh_save_reg_x x30, 16
; CHECK-PC-NEXT:    .seh_endepilogue
; CHECK-PC-NEXT:    ret
; CHECK-PC-NEXT:    .seh_endfunclet
; CHECK-PC-NEXT:    .seh_endproc
;
; CHECK-APPLE-LABEL: func2:
; CHECK-APPLE:       ; %bb.0:
; CHECK-APPLE-NEXT:    sub sp, sp, #32
; CHECK-APPLE-NEXT:    stp x29, x30, [sp, #16] ; 16-byte Folded Spill
; CHECK-APPLE-NEXT:    .cfi_def_cfa_offset 32
; CHECK-APPLE-NEXT:    .cfi_offset w30, -8
; CHECK-APPLE-NEXT:    .cfi_offset w29, -16
; CHECK-APPLE-NEXT:  Lloh2:
; CHECK-APPLE-NEXT:    adrp x0, _trampg@PAGE
; CHECK-APPLE-NEXT:  Lloh3:
; CHECK-APPLE-NEXT:    add x0, x0, _trampg@PAGEOFF
; CHECK-APPLE-NEXT:  Lloh4:
; CHECK-APPLE-NEXT:    adrp x8, _f@PAGE
; CHECK-APPLE-NEXT:  Lloh5:
; CHECK-APPLE-NEXT:    add x8, x8, _f@PAGEOFF
; CHECK-APPLE-NEXT:    add x9, sp, #8
; CHECK-APPLE-NEXT:    add x1, x0, #12
; CHECK-APPLE-NEXT:    stp x9, x8, [x0, #16]
; CHECK-APPLE-NEXT:    mov w8, #544 ; =0x220
; CHECK-APPLE-NEXT:    movk w8, #54815, lsl #16
; CHECK-APPLE-NEXT:    str w8, [x0, #8]
; CHECK-APPLE-NEXT:    mov x8, #143 ; =0x8f
; CHECK-APPLE-NEXT:    movk x8, #22528, lsl #16
; CHECK-APPLE-NEXT:    movk x8, #177, lsl #32
; CHECK-APPLE-NEXT:    movk x8, #22528, lsl #48
; CHECK-APPLE-NEXT:    str x8, [x0]
; CHECK-APPLE-NEXT:    bl ___clear_cache
; CHECK-APPLE-NEXT:    ldp x29, x30, [sp, #16] ; 16-byte Folded Reload
; CHECK-APPLE-NEXT:    mov x0, xzr
; CHECK-APPLE-NEXT:    add sp, sp, #32
; CHECK-APPLE-NEXT:    ret
; CHECK-APPLE-NEXT:    .loh AdrpAdd Lloh4, Lloh5
; CHECK-APPLE-NEXT:    .loh AdrpAdd Lloh2, Lloh3
  %val = alloca i64
  call void @llvm.init.trampoline(ptr @trampg, ptr @f, ptr %val)
  %fp = call ptr @llvm.adjust.trampoline(ptr @trampg)
  ret i64 0
}
