# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p870 -iterations=1 -instruction-tables=full < %s | FileCheck %s

fli.h fa5, nan
fli.s fa5, nan
fli.d fa5, nan

fround.h fa0, fa0, rdn
froundnx.h fa0, fa0, rdn
fround.s fa0, fa0, rdn
froundnx.s fa0, fa0, rdn
fround.d fa0, fa0, rdn
froundnx.d fa0, fa0, rdn

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Branch:2 SiFiveP800IEXQ4, SiFiveP800IEXQ5
# CHECK-NEXT: [1]   - SiFiveP800Div:1
# CHECK-NEXT: [2]   - SiFiveP800FEXQ0:1
# CHECK-NEXT: [3]   - SiFiveP800FEXQ1:1
# CHECK-NEXT: [4]   - SiFiveP800FloatArith:2 SiFiveP800FEXQ0, SiFiveP800FEXQ1
# CHECK-NEXT: [5]   - SiFiveP800FloatDiv:1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ0:1
# CHECK-NEXT: [7]   - SiFiveP800IEXQ1:1
# CHECK-NEXT: [8]   - SiFiveP800IEXQ2:1
# CHECK-NEXT: [9]   - SiFiveP800IEXQ3:1
# CHECK-NEXT: [10]  - SiFiveP800IEXQ4:1
# CHECK-NEXT: [11]  - SiFiveP800IEXQ5:1
# CHECK-NEXT: [12]  - SiFiveP800IntArith:4 SiFiveP800IEXQ0, SiFiveP800IEXQ1, SiFiveP800IEXQ2, SiFiveP800IEXQ3
# CHECK-NEXT: [13]  - SiFiveP800LD:1
# CHECK-NEXT: [14]  - SiFiveP800LDST:2
# CHECK-NEXT: [15]  - SiFiveP800Load:3 SiFiveP800LDST, SiFiveP800LDST, SiFiveP800LD
# CHECK-NEXT: [16]  - SiFiveP800Mul:2 SiFiveP800IEXQ1, SiFiveP800IEXQ3
# CHECK-NEXT: [17]  - SiFiveP800VDiv:1
# CHECK-NEXT: [18]  - SiFiveP800VEXQ0:1
# CHECK-NEXT: [19]  - SiFiveP800VEXQ1:1
# CHECK-NEXT: [20]  - SiFiveP800VFloatDiv:1
# CHECK-NEXT: [21]  - SiFiveP800VLD:1
# CHECK-NEXT: [22]  - SiFiveP800VST:1
# CHECK-NEXT: [23]  - SiFiveP800VectorArith:2 SiFiveP800VEXQ0, SiFiveP800VEXQ1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800IEXQ3,SiFiveP800IntArith,SiFiveP800Mul FLI_H                fli.h	fa5, nan
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800IEXQ3,SiFiveP800IntArith,SiFiveP800Mul FLI_S                fli.s	fa5, nan
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800IEXQ3,SiFiveP800IntArith,SiFiveP800Mul FLI_D                fli.d	fa5, nan
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800FloatArith                       FROUND_H                   fround.h	fa0, fa0, rdn
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800FloatArith                       FROUNDNX_H                 froundnx.h	fa0, fa0, rdn
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800FloatArith                       FROUND_S                   fround.s	fa0, fa0, rdn
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800FloatArith                       FROUNDNX_S                 froundnx.s	fa0, fa0, rdn
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800FloatArith                       FROUND_D                   fround.d	fa0, fa0, rdn
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800FloatArith                       FROUNDNX_D                 froundnx.d	fa0, fa0, rdn

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Div
# CHECK-NEXT: [1]   - SiFiveP800FEXQ0
# CHECK-NEXT: [2]   - SiFiveP800FEXQ1
# CHECK-NEXT: [3]   - SiFiveP800FloatDiv
# CHECK-NEXT: [4]   - SiFiveP800IEXQ0
# CHECK-NEXT: [5]   - SiFiveP800IEXQ1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ2
# CHECK-NEXT: [7]   - SiFiveP800IEXQ3
# CHECK-NEXT: [8]   - SiFiveP800IEXQ4
# CHECK-NEXT: [9]   - SiFiveP800IEXQ5
# CHECK-NEXT: [10]  - SiFiveP800LD
# CHECK-NEXT: [11.0] - SiFiveP800LDST
# CHECK-NEXT: [11.1] - SiFiveP800LDST
# CHECK-NEXT: [12]  - SiFiveP800VDiv
# CHECK-NEXT: [13]  - SiFiveP800VEXQ0
# CHECK-NEXT: [14]  - SiFiveP800VEXQ1
# CHECK-NEXT: [15]  - SiFiveP800VFloatDiv
# CHECK-NEXT: [16]  - SiFiveP800VLD
# CHECK-NEXT: [17]  - SiFiveP800VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]
# CHECK-NEXT:  -     3.00   3.00    -      -      -      -     3.00    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     fli.h	fa5, nan
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     fli.s	fa5, nan
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     fli.d	fa5, nan
# CHECK-NEXT:  -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fround.h	fa0, fa0, rdn
# CHECK-NEXT:  -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     froundnx.h	fa0, fa0, rdn
# CHECK-NEXT:  -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fround.s	fa0, fa0, rdn
# CHECK-NEXT:  -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     froundnx.s	fa0, fa0, rdn
# CHECK-NEXT:  -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fround.d	fa0, fa0, rdn
# CHECK-NEXT:  -     0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     froundnx.d	fa0, fa0, rdn
