; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-unroll -S %s | FileCheck %s

; Test case for https://github.com/llvm/llvm-project/issues/140442.
define i32 @peel_last_iter_of_outer_lcssa_phi_with_constant_after_unrolling_inner() {
; CHECK-LABEL: define i32 @peel_last_iter_of_outer_lcssa_phi_with_constant_after_unrolling_inner() {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[OUTER_HEADER:.*]]
; CHECK:       [[OUTER_HEADER]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[INNER_LATCH:.*]] ]
; CHECK-NEXT:    br label %[[INNER_HEADER:.*]]
; CHECK:       [[INNER_HEADER]]:
; CHECK-NEXT:    br i1 false, label %[[THEN:.*]], label %[[INNER_LATCH]]
; CHECK:       [[THEN]]:
; CHECK-NEXT:    call void @foo(i32 0)
; CHECK-NEXT:    br label %[[INNER_LATCH]]
; CHECK:       [[INNER_LATCH]]:
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i16 [[IV_NEXT]], 999
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT_PEEL_BEGIN:.*]], label %[[OUTER_HEADER]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       [[EXIT_PEEL_BEGIN]]:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i16 [ [[IV_NEXT]], %[[INNER_LATCH]] ]
; CHECK-NEXT:    br label %[[OUTER_HEADER_PEEL:.*]]
; CHECK:       [[OUTER_HEADER_PEEL]]:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i16 [[IV_NEXT_LCSSA]], 999
; CHECK-NEXT:    br label %[[INNER_HEADER_PEEL:.*]]
; CHECK:       [[INNER_HEADER_PEEL]]:
; CHECK-NEXT:    br i1 [[TMP0]], label %[[THEN_PEEL:.*]], label %[[INNER_LATCH_PEEL:.*]]
; CHECK:       [[THEN_PEEL]]:
; CHECK-NEXT:    call void @foo(i32 0)
; CHECK-NEXT:    br label %[[INNER_LATCH_PEEL]]
; CHECK:       [[INNER_LATCH_PEEL]]:
; CHECK-NEXT:    [[IV_NEXT_PEEL:%.*]] = add i16 [[IV_NEXT_LCSSA]], 1
; CHECK-NEXT:    [[EC_PEEL:%.*]] = icmp eq i16 [[IV_NEXT_PEEL]], 1000
; CHECK-NEXT:    br i1 [[EC_PEEL]], label %[[EXIT_PEEL_NEXT:.*]], label %[[EXIT_PEEL_NEXT]]
; CHECK:       [[EXIT_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[OUTER_HEADER_PEEL_NEXT:.*]]
; CHECK:       [[OUTER_HEADER_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret i32 1
;
entry:
  br label %outer.header

outer.header:
  %iv = phi i16 [ 0, %entry ], [ %iv.next, %outer.latch ]
  %0 = icmp eq i16 %iv, 999
  br label %inner.header

inner.header:
  %inner.iv = phi i32 [ 0, %outer.header ], [ %inner.iv.next, %inner.latch ]
  %1 = add i32 %inner.iv, 1
  br i1 %0, label %then, label %inner.latch

then:
  call void @foo(i32 %inner.iv)
  br label %inner.latch

inner.latch:
  %inner.iv.next = add i32 %inner.iv, 1
  %inner.ec = icmp eq i32 %inner.iv.next, 1
  br i1 %inner.ec, label %outer.latch, label %inner.header

outer.latch:
  %iv.next = add i16 %iv, 1
  %ec = icmp eq i16 %iv.next, 1000
  br i1 %ec, label %exit, label %outer.header

exit:
  ret i32 %1
}

; Test case for https://github.com/llvm/llvm-project/issues/142895.

define i32 @pr142895_exit_value_is_arg(i32 %arg) {
; CHECK-LABEL: define i32 @pr142895_exit_value_is_arg(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[INC:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i32 [[INC]], 32
; CHECK-NEXT:    br i1 [[EXITCOND]], label %[[LOOP]], label %[[EXIT_PEEL_BEGIN:.*]], !llvm.loop [[LOOP2:![0-9]+]]
; CHECK:       [[EXIT_PEEL_BEGIN]]:
; CHECK-NEXT:    [[TMP0:%.*]] = phi i32 [ [[INC]], %[[LOOP]] ]
; CHECK-NEXT:    br label %[[LOOP_PEEL:.*]]
; CHECK:       [[LOOP_PEEL]]:
; CHECK-NEXT:    [[CMP1_PEEL:%.*]] = icmp eq i32 [[TMP0]], 32
; CHECK-NEXT:    [[SEL_PEEL:%.*]] = select i1 [[CMP1_PEEL]], i32 0, i32 0
; CHECK-NEXT:    [[SUB_PEEL:%.*]] = sub i32 0, 0
; CHECK-NEXT:    [[XOR_PEEL:%.*]] = xor i32 0, 0
; CHECK-NEXT:    [[INC_PEEL:%.*]] = add i32 [[TMP0]], 1
; CHECK-NEXT:    [[EXITCOND_PEEL:%.*]] = icmp ne i32 [[INC_PEEL]], 33
; CHECK-NEXT:    br i1 [[EXITCOND_PEEL]], label %[[EXIT_PEEL_NEXT:.*]], label %[[EXIT_PEEL_NEXT]]
; CHECK:       [[EXIT_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[LOOP_PEEL_NEXT:.*]]
; CHECK:       [[LOOP_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret i32 [[ARG]]
;
entry:
  br label %loop

loop:
  %indvar = phi i32 [ 0, %entry ], [ %inc, %loop ]
  %cmp1 = icmp eq i32 %indvar, 32
  %sel = select i1 %cmp1, i32 0, i32 0
  %sub = sub i32 0, 0
  %xor = xor i32 0, 0
  %inc = add i32 %indvar, 1
  %exitcond = icmp ne i32 %inc, 33
  br i1 %exitcond, label %loop, label %exit

exit:
  %exit.lcssa = phi i32 [ %arg, %loop ]
  ret i32 %exit.lcssa
}

define i32 @pr142895_exit_value_is_inst(i32 %arg) {
; CHECK-LABEL: define i32 @pr142895_exit_value_is_inst(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[MUL:%.*]] = mul i32 [[ARG]], 7
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[INC:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i32 [[INC]], 32
; CHECK-NEXT:    br i1 [[EXITCOND]], label %[[LOOP]], label %[[EXIT_PEEL_BEGIN:.*]], !llvm.loop [[LOOP3:![0-9]+]]
; CHECK:       [[EXIT_PEEL_BEGIN]]:
; CHECK-NEXT:    [[TMP0:%.*]] = phi i32 [ [[INC]], %[[LOOP]] ]
; CHECK-NEXT:    br label %[[LOOP_PEEL:.*]]
; CHECK:       [[LOOP_PEEL]]:
; CHECK-NEXT:    [[CMP1_PEEL:%.*]] = icmp eq i32 [[TMP0]], 32
; CHECK-NEXT:    [[SEL_PEEL:%.*]] = select i1 [[CMP1_PEEL]], i32 0, i32 0
; CHECK-NEXT:    [[SUB_PEEL:%.*]] = sub i32 0, 0
; CHECK-NEXT:    [[XOR_PEEL:%.*]] = xor i32 0, 0
; CHECK-NEXT:    [[INC_PEEL:%.*]] = add i32 [[TMP0]], 1
; CHECK-NEXT:    [[EXITCOND_PEEL:%.*]] = icmp ne i32 [[INC_PEEL]], 33
; CHECK-NEXT:    br i1 [[EXITCOND_PEEL]], label %[[EXIT_PEEL_NEXT:.*]], label %[[EXIT_PEEL_NEXT]]
; CHECK:       [[EXIT_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[LOOP_PEEL_NEXT:.*]]
; CHECK:       [[LOOP_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret i32 [[MUL]]
;
entry:
  %mul = mul i32 %arg, 7
  br label %loop

loop:
  %indvar = phi i32 [ 0, %entry ], [ %inc, %loop ]
  %cmp1 = icmp eq i32 %indvar, 32
  %sel = select i1 %cmp1, i32 0, i32 0
  %sub = sub i32 0, 0
  %xor = xor i32 0, 0
  %inc = add i32 %indvar, 1
  %exitcond = icmp ne i32 %inc, 33
  br i1 %exitcond, label %loop, label %exit

exit:
  %exit.lcssa = phi i32 [ %mul, %loop ]
  ret i32 %exit.lcssa
}

declare void @foo(i32)
;.
; CHECK: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]]}
; CHECK: [[META1]] = !{!"llvm.loop.peeled.count", i32 1}
; CHECK: [[LOOP2]] = distinct !{[[LOOP2]], [[META1]]}
; CHECK: [[LOOP3]] = distinct !{[[LOOP3]], [[META1]]}
;.
