# RUN: llvm-mc -triple x86_64 -x86-asm-syntax=intel -output-asm-variant=1 --show-encoding %s | FileCheck %s

## ldtilecfg

# CHECK: {evex}	ldtilecfg	[rax + 4*rbx + 123]
# CHECK: encoding: [0x62,0xf2,0x7c,0x08,0x49,0x44,0x98,0x7b]
         {evex}	ldtilecfg	[rax + 4*rbx + 123]

# CHECK: ldtilecfg	[r28 + 4*r29 + 291]
# CHECK: encoding: [0x62,0x9a,0x78,0x08,0x49,0x84,0xac,0x23,0x01,0x00,0x00]
         ldtilecfg	[r28 + 4*r29 + 291]

## sttilecfg

# CHECK: {evex}	sttilecfg	[rax + 4*rbx + 123]
# CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x49,0x44,0x98,0x7b]
         {evex}	sttilecfg	[rax + 4*rbx + 123]

# CHECK: sttilecfg	[r28 + 4*r29 + 291]
# CHECK: encoding: [0x62,0x9a,0x79,0x08,0x49,0x84,0xac,0x23,0x01,0x00,0x00]
         sttilecfg	[r28 + 4*r29 + 291]

## tileloadd

# CHECK: {evex}	tileloadd	tmm6, [rax + 4*rbx + 123]
# CHECK: encoding: [0x62,0xf2,0x7f,0x08,0x4b,0x74,0x98,0x7b]
         {evex}	tileloadd	tmm6, [rax + 4*rbx + 123]

# CHECK: tileloadd	tmm6, [r28 + 4*r29 + 291]
# CHECK: encoding: [0x62,0x9a,0x7b,0x08,0x4b,0xb4,0xac,0x23,0x01,0x00,0x00]
         tileloadd	tmm6, [r28 + 4*r29 + 291]

## tileloaddt1

# CHECK: {evex}	tileloaddt1	tmm6, [rax + 4*rbx + 123]
# CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x4b,0x74,0x98,0x7b]
         {evex}	tileloaddt1	tmm6, [rax + 4*rbx + 123]

# CHECK: tileloaddt1	tmm6, [r28 + 4*r29 + 291]
# CHECK: encoding: [0x62,0x9a,0x79,0x08,0x4b,0xb4,0xac,0x23,0x01,0x00,0x00]
         tileloaddt1	tmm6, [r28 + 4*r29 + 291]

## tilestored

# CHECK: {evex}	tilestored	[rax + 4*rbx + 123], tmm6
# CHECK: encoding: [0x62,0xf2,0x7e,0x08,0x4b,0x74,0x98,0x7b]
         {evex}	tilestored	[rax + 4*rbx + 123], tmm6

# CHECK: tilestored	[r28 + 4*r29 + 291], tmm6
# CHECK: encoding: [0x62,0x9a,0x7a,0x08,0x4b,0xb4,0xac,0x23,0x01,0x00,0x00]
         tilestored	[r28 + 4*r29 + 291], tmm6
