; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-linux-gnu  -mattr=+avx512f < %s | FileCheck %s --check-prefixes=ALL,X64,X64-KNL
; RUN: llc -mtriple=i386-unknown-linux-gnu  -mattr=+avx512f < %s | FileCheck %s --check-prefixes=ALL,X86,X86-KNL
; RUN: llc -mtriple=x86_64-unknown-linux-gnu  -mattr=+avx512vl -mattr=+avx512dq < %s | FileCheck %s --check-prefixes=ALL,X64,X64-SKX,X64-SKX-SMALL
; RUN: llc -mtriple=x86_64-unknown-linux-gnu  -mattr=+avx512vl -mattr=+avx512dq -code-model=large < %s | FileCheck %s --check-prefixes=ALL,X64,X64-SKX,X64-SKX-LARGE
; RUN: llc -mtriple=i386-unknown-linux-gnu  -mattr=+avx512vl -mattr=+avx512dq < %s | FileCheck %s --check-prefixes=ALL,X86,X86-SKX
; RUN: opt -mtriple=x86_64-apple-darwin -passes=scalarize-masked-mem-intrin -mcpu=corei7-avx -S < %s | FileCheck %s -check-prefixes=SCALAR
; RUN: opt -mtriple=x86_64-apple-darwin -passes=scalarize-masked-mem-intrin -mcpu=corei7-avx -S < %s | FileCheck %s -check-prefixes=SCALAR
; RUN: llc -O0 -mtriple=x86_64-unknown-linux-gnu -mcpu=skx < %s -o /dev/null

@glob_array = internal unnamed_addr constant [16 x i32] [i32 1, i32 1, i32 2, i32 3, i32 5, i32 8, i32 13, i32 21, i32 34, i32 55, i32 89, i32 144, i32 233, i32 377, i32 610, i32 987], align 16

; SCALAR-LABEL: test1
; SCALAR:      extractelement <16 x ptr>
; SCALAR-NEXT: load float
; SCALAR-NEXT: insertelement <16 x float>
; SCALAR-NEXT: extractelement <16 x ptr>
; SCALAR-NEXT: load float

define <16 x float> @test1(ptr %base, <16 x i32> %ind) {
; X64-LABEL: test1:
; X64:       # %bb.0:
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    vgatherdps (%rdi,%zmm0,4), %zmm1 {%k1}
; X64-NEXT:    vmovaps %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test1:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    vgatherdps (%eax,%zmm0,4), %zmm1 {%k1}
; X86-NEXT:    vmovaps %zmm1, %zmm0
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr float, <16 x ptr> %broadcast.splat, <16 x i64> %sext_ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

declare <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr>, i32, <16 x i1>, <16 x i32>)
declare <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr>, i32, <16 x i1>, <16 x float>)
declare <8 x i32> @llvm.masked.gather.v8i32.v8p0(<8 x ptr> , i32, <8 x i1> , <8 x i32> )


; SCALAR-LABEL: test2
; SCALAR:      extractelement <16 x ptr>
; SCALAR-NEXT: load float
; SCALAR-NEXT: insertelement <16 x float>
; SCALAR-NEXT: br label %else
; SCALAR: else:
; SCALAR-NEXT:  %res.phi.else = phi
; SCALAR-NEXT:  and i16 %{{.*}}, 2
; SCALAR-NEXT:  icmp ne i16 %{{.*}}, 0
; SCALAR-NEXT:  br i1 %{{.*}}, label %cond.load1, label %else2

define <16 x float> @test2(ptr %base, <16 x i32> %ind, i16 %mask) {
; X64-LABEL: test2:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    vgatherdps (%rdi,%zmm0,4), %zmm1 {%k1}
; X64-NEXT:    vmovaps %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test2:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    vgatherdps (%eax,%zmm0,4), %zmm1 {%k1}
; X86-NEXT:    vmovaps %zmm1, %zmm0
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr float, <16 x ptr> %broadcast.splat, <16 x i64> %sext_ind
  %imask = bitcast i16 %mask to <16 x i1>
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> %imask, <16 x float>undef)
  ret <16 x float> %res
}

define <16 x i32> @test3(ptr %base, <16 x i32> %ind, i16 %mask) {
; X64-LABEL: test3:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-NEXT:    vpgatherdd (%rdi,%zmm0,4), %zmm1 {%k1}
; X64-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test3:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-NEXT:    vpgatherdd (%eax,%zmm0,4), %zmm1 {%k1}
; X86-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr i32, <16 x ptr> %broadcast.splat, <16 x i64> %sext_ind
  %imask = bitcast i16 %mask to <16 x i1>
  %res = call <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> %imask, <16 x i32>undef)
  ret <16 x i32> %res
}


define <16 x i32> @test4(ptr %base, <16 x i32> %ind, i16 %mask) {
; X64-LABEL: test4:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-NEXT:    kmovw %k1, %k2
; X64-NEXT:    vpgatherdd (%rdi,%zmm0,4), %zmm1 {%k2}
; X64-NEXT:    vmovdqa64 %zmm1, %zmm2
; X64-NEXT:    vpgatherdd (%rdi,%zmm0,4), %zmm2 {%k1}
; X64-NEXT:    vpaddd %zmm2, %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test4:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-NEXT:    kmovw %k1, %k2
; X86-NEXT:    vpgatherdd (%eax,%zmm0,4), %zmm1 {%k2}
; X86-NEXT:    vmovdqa64 %zmm1, %zmm2
; X86-NEXT:    vpgatherdd (%eax,%zmm0,4), %zmm2 {%k1}
; X86-NEXT:    vpaddd %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %gep.random = getelementptr i32, <16 x ptr> %broadcast.splat, <16 x i32> %ind
  %imask = bitcast i16 %mask to <16 x i1>
  %gt1 = call <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> %imask, <16 x i32>undef)
  %gt2 = call <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> %imask, <16 x i32>%gt1)
  %res = add <16 x i32> %gt1, %gt2
  ret <16 x i32> %res
}


; SCALAR-LABEL: test5
; SCALAR:        and i16 %scalar_mask, 1
; SCALAR-NEXT:   icmp ne i16 %{{.*}}, 0
; SCALAR-NEXT:   br i1 %{{.*}}, label %cond.store, label %else
; SCALAR: cond.store:
; SCALAR-NEXT:  %Elt0 = extractelement <16 x i32> %val, i64 0
; SCALAR-NEXT:  %Ptr0 = extractelement <16 x ptr> %gep.random, i64 0
; SCALAR-NEXT:  store i32 %Elt0, ptr %Ptr0, align 4
; SCALAR-NEXT:  br label %else
; SCALAR: else:
; SCALAR-NEXT:   and i16 %scalar_mask, 2
; SCALAR-NEXT:   icmp ne i16 %{{.*}}, 0
; SCALAR-NEXT:  br i1 %{{.*}}, label %cond.store1, label %else2

define void @test5(ptr %base, <16 x i32> %ind, i16 %mask, <16 x i32>%val) {
; X64-LABEL: test5:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    kmovw %k1, %k2
; X64-NEXT:    vpscatterdd %zmm1, (%rdi,%zmm0,4) {%k2}
; X64-NEXT:    vpscatterdd %zmm1, (%rdi,%zmm0,4) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
;
; X86-LABEL: test5:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    kmovw %k1, %k2
; X86-NEXT:    vpscatterdd %zmm1, (%eax,%zmm0,4) {%k2}
; X86-NEXT:    vpscatterdd %zmm1, (%eax,%zmm0,4) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %gep.random = getelementptr i32, <16 x ptr> %broadcast.splat, <16 x i32> %ind
  %imask = bitcast i16 %mask to <16 x i1>
  call void @llvm.masked.scatter.v16i32.v16p0(<16 x i32>%val, <16 x ptr> %gep.random, i32 4, <16 x i1> %imask)
  call void @llvm.masked.scatter.v16i32.v16p0(<16 x i32>%val, <16 x ptr> %gep.random, i32 4, <16 x i1> %imask)
  ret void
}

declare void @llvm.masked.scatter.v8i32.v8p0(<8 x i32> , <8 x ptr> , i32 , <8 x i1> )
declare void @llvm.masked.scatter.v16i32.v16p0(<16 x i32> , <16 x ptr> , i32 , <16 x i1> )


; SCALAR-LABEL: test6
; SCALAR:        store i32 %Elt0, ptr %Ptr01, align 4
; SCALAR-NEXT:   %Elt1 = extractelement <8 x i32> %a1, i64 1
; SCALAR-NEXT:   %Ptr12 = extractelement <8 x ptr> %ptr, i64 1
; SCALAR-NEXT:   store i32 %Elt1, ptr %Ptr12, align 4
; SCALAR-NEXT:   %Elt2 = extractelement <8 x i32> %a1, i64 2
; SCALAR-NEXT:   %Ptr23 = extractelement <8 x ptr> %ptr, i64 2
; SCALAR-NEXT:   store i32 %Elt2, ptr %Ptr23, align 4

define <8 x i32> @test6(<8 x i32>%a1, <8 x ptr> %ptr) {
; X64-LABEL: test6:
; X64:       # %bb.0:
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X64-NEXT:    kxnorw %k0, %k0, %k2
; X64-NEXT:    vpgatherqd (,%zmm1), %ymm2 {%k2}
; X64-NEXT:    vpscatterqd %ymm0, (,%zmm1) {%k1}
; X64-NEXT:    vmovdqa %ymm2, %ymm0
; X64-NEXT:    retq
;
; X86-KNL-LABEL: test6:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X86-KNL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X86-KNL-NEXT:    movw $255, %ax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kmovw %k1, %k2
; X86-KNL-NEXT:    vpgatherdd (,%zmm1), %zmm2 {%k2}
; X86-KNL-NEXT:    vpscatterdd %zmm0, (,%zmm1) {%k1}
; X86-KNL-NEXT:    vmovdqa %ymm2, %ymm0
; X86-KNL-NEXT:    retl
;
; X86-SKX-LABEL: test6:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X86-SKX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X86-SKX-NEXT:    kxnorw %k0, %k0, %k2
; X86-SKX-NEXT:    vpgatherdd (,%ymm1), %ymm2 {%k2}
; X86-SKX-NEXT:    vpscatterdd %ymm0, (,%ymm1) {%k1}
; X86-SKX-NEXT:    vmovdqa %ymm2, %ymm0
; X86-SKX-NEXT:    retl
  %a = call <8 x i32> @llvm.masked.gather.v8i32.v8p0(<8 x ptr> %ptr, i32 4, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x i32> undef)

  call void @llvm.masked.scatter.v8i32.v8p0(<8 x i32> %a1, <8 x ptr> %ptr, i32 4, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>)
  ret <8 x i32>%a
}

define <8 x i32> @test7(ptr %base, <8 x i32> %ind, i8 %mask) {
; X64-KNL-LABEL: test7:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X64-KNL-NEXT:    kmovw %esi, %k0
; X64-KNL-NEXT:    kshiftlw $8, %k0, %k0
; X64-KNL-NEXT:    kshiftrw $8, %k0, %k1
; X64-KNL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-KNL-NEXT:    kmovw %k1, %k2
; X64-KNL-NEXT:    vpgatherdd (%rdi,%zmm0,4), %zmm1 {%k2}
; X64-KNL-NEXT:    vmovdqa64 %zmm1, %zmm2
; X64-KNL-NEXT:    vpgatherdd (%rdi,%zmm0,4), %zmm2 {%k1}
; X64-KNL-NEXT:    vpaddd %ymm2, %ymm1, %ymm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test7:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    kmovw %ecx, %k0
; X86-KNL-NEXT:    kshiftlw $8, %k0, %k0
; X86-KNL-NEXT:    kshiftrw $8, %k0, %k1
; X86-KNL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-KNL-NEXT:    kmovw %k1, %k2
; X86-KNL-NEXT:    vpgatherdd (%eax,%zmm0,4), %zmm1 {%k2}
; X86-KNL-NEXT:    vmovdqa64 %zmm1, %zmm2
; X86-KNL-NEXT:    vpgatherdd (%eax,%zmm0,4), %zmm2 {%k1}
; X86-KNL-NEXT:    vpaddd %ymm2, %ymm1, %ymm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test7:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    kmovw %esi, %k1
; X64-SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-SKX-NEXT:    kmovw %k1, %k2
; X64-SKX-NEXT:    vpgatherdd (%rdi,%ymm0,4), %ymm1 {%k2}
; X64-SKX-NEXT:    vmovdqa %ymm1, %ymm2
; X64-SKX-NEXT:    vpgatherdd (%rdi,%ymm0,4), %ymm2 {%k1}
; X64-SKX-NEXT:    vpaddd %ymm2, %ymm1, %ymm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test7:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-SKX-NEXT:    kmovw %k1, %k2
; X86-SKX-NEXT:    vpgatherdd (%eax,%ymm0,4), %ymm1 {%k2}
; X86-SKX-NEXT:    vmovdqa %ymm1, %ymm2
; X86-SKX-NEXT:    vpgatherdd (%eax,%ymm0,4), %ymm2 {%k1}
; X86-SKX-NEXT:    vpaddd %ymm2, %ymm1, %ymm0
; X86-SKX-NEXT:    retl
  %broadcast.splatinsert = insertelement <8 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <8 x ptr> %broadcast.splatinsert, <8 x ptr> undef, <8 x i32> zeroinitializer

  %gep.random = getelementptr i32, <8 x ptr> %broadcast.splat, <8 x i32> %ind
  %imask = bitcast i8 %mask to <8 x i1>
  %gt1 = call <8 x i32> @llvm.masked.gather.v8i32.v8p0(<8 x ptr> %gep.random, i32 4, <8 x i1> %imask, <8 x i32>undef)
  %gt2 = call <8 x i32> @llvm.masked.gather.v8i32.v8p0(<8 x ptr> %gep.random, i32 4, <8 x i1> %imask, <8 x i32>%gt1)
  %res = add <8 x i32> %gt1, %gt2
  ret <8 x i32> %res
}

; No uniform base in this case, index <8 x i64> contains addresses,
; each gather call will be split into two
define <16 x i32> @test8(<16 x ptr> %ptr.random, <16 x i32> %ind, i16 %mask) {
; X64-LABEL: test8:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    kshiftrw $8, %k1, %k2
; X64-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X64-NEXT:    kmovw %k2, %k3
; X64-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; X64-NEXT:    vpgatherqd (,%zmm1), %ymm3 {%k3}
; X64-NEXT:    kmovw %k1, %k3
; X64-NEXT:    vpgatherqd (,%zmm0), %ymm2 {%k3}
; X64-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm4
; X64-NEXT:    vpgatherqd (,%zmm1), %ymm3 {%k2}
; X64-NEXT:    vpgatherqd (,%zmm0), %ymm2 {%k1}
; X64-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm0
; X64-NEXT:    vpaddd %zmm0, %zmm4, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test8:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-NEXT:    kmovw %k1, %k2
; X86-NEXT:    vpgatherdd (,%zmm0), %zmm1 {%k2}
; X86-NEXT:    vmovdqa64 %zmm1, %zmm2
; X86-NEXT:    vpgatherdd (,%zmm0), %zmm2 {%k1}
; X86-NEXT:    vpaddd %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
  %imask = bitcast i16 %mask to <16 x i1>
  %gt1 = call <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr> %ptr.random, i32 4, <16 x i1> %imask, <16 x i32>undef)
  %gt2 = call <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr> %ptr.random, i32 4, <16 x i1> %imask, <16 x i32>%gt1)
  %res = add <16 x i32> %gt1, %gt2
  ret <16 x i32> %res
}

%struct.RT = type { i8, [10 x [20 x i32]], i8 }
%struct.ST = type { i32, double, %struct.RT }

; Masked gather for aggregate types
; Test9 and Test10 should give the same result (scalar and vector indices in GEP)


define <8 x i32> @test9(ptr %base, <8 x i64> %ind1, <8 x i32>%ind5) {
; X64-KNL-LABEL: test9:
; X64-KNL:       # %bb.0: # %entry
; X64-KNL-NEXT:    vpbroadcastq %rdi, %zmm2
; X64-KNL-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [824,824,824,824,824,824,824,824]
; X64-KNL-NEXT:    vpmuludq %zmm3, %zmm0, %zmm4
; X64-KNL-NEXT:    vpaddq %zmm4, %zmm2, %zmm2
; X64-KNL-NEXT:    vpsrlq $32, %zmm0, %zmm0
; X64-KNL-NEXT:    vpmuludq %zmm3, %zmm0, %zmm0
; X64-KNL-NEXT:    vpsllq $32, %zmm0, %zmm0
; X64-KNL-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; X64-KNL-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; X64-KNL-NEXT:    vpmuldq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm1, %zmm1
; X64-KNL-NEXT:    vpaddq %zmm1, %zmm0, %zmm1
; X64-KNL-NEXT:    kxnorw %k0, %k0, %k1
; X64-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-KNL-NEXT:    vpgatherqd 72(,%zmm1), %ymm0 {%k1}
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test9:
; X86-KNL:       # %bb.0: # %entry
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %ymm2
; X86-KNL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [80,80,80,80,80,80,80,80]
; X86-KNL-NEXT:    vpmulld %ymm3, %ymm1, %ymm1
; X86-KNL-NEXT:    vpmovqd %zmm0, %ymm0
; X86-KNL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [820,820,820,820,820,820,820,820]
; X86-KNL-NEXT:    vpmulld %ymm3, %ymm0, %ymm0
; X86-KNL-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; X86-KNL-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; X86-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-KNL-NEXT:    movw $255, %ax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    vpgatherdd 68(,%zmm1), %zmm0 {%k1}
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test9:
; X64-SKX-SMALL:       # %bb.0: # %entry
; X64-SKX-SMALL-NEXT:    vpbroadcastq %rdi, %zmm2
; X64-SKX-SMALL-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; X64-SKX-SMALL-NEXT:    vpmuldq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm1, %zmm1
; X64-SKX-SMALL-NEXT:    vpaddq %zmm1, %zmm0, %zmm1
; X64-SKX-SMALL-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-SMALL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    vpgatherqd 72(,%zmm1), %ymm0 {%k1}
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test9:
; X64-SKX-LARGE:       # %bb.0: # %entry
; X64-SKX-LARGE-NEXT:    vpbroadcastq %rdi, %zmm2
; X64-SKX-LARGE-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpmuldq (%rax){1to8}, %zmm1, %zmm1
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpmullq (%rax){1to8}, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; X64-SKX-LARGE-NEXT:    vpaddq %zmm1, %zmm0, %zmm1
; X64-SKX-LARGE-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-LARGE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    vpgatherqd 72(,%zmm1), %ymm0 {%k1}
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test9:
; X86-SKX:       # %bb.0: # %entry
; X86-SKX-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm1, %ymm1
; X86-SKX-NEXT:    vpmovqd %zmm0, %ymm0
; X86-SKX-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to8}, %ymm0, %ymm0
; X86-SKX-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; X86-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vpgatherdd 68(,%ymm1), %ymm0 {%k1}
; X86-SKX-NEXT:    retl
entry:
  %broadcast.splatinsert = insertelement <8 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <8 x ptr> %broadcast.splatinsert, <8 x ptr> undef, <8 x i32> zeroinitializer

  %arrayidx = getelementptr  %struct.ST, <8 x ptr> %broadcast.splat, <8 x i64> %ind1, <8 x i32> <i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2>, <8 x i32><i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>, <8 x i32> %ind5, <8 x i64> <i64 13, i64 13, i64 13, i64 13, i64 13, i64 13, i64 13, i64 13>
  %res = call <8 x i32 >  @llvm.masked.gather.v8i32.v8p0(<8 x ptr>%arrayidx, i32 4, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x i32> undef)
  ret <8 x i32> %res
}

define <8 x i32> @test10(ptr %base, <8 x i64> %i1, <8 x i32>%ind5) {
; X64-KNL-LABEL: test10:
; X64-KNL:       # %bb.0: # %entry
; X64-KNL-NEXT:    vpbroadcastq %rdi, %zmm2
; X64-KNL-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [824,824,824,824,824,824,824,824]
; X64-KNL-NEXT:    vpmuludq %zmm3, %zmm0, %zmm4
; X64-KNL-NEXT:    vpaddq %zmm4, %zmm2, %zmm2
; X64-KNL-NEXT:    vpsrlq $32, %zmm0, %zmm0
; X64-KNL-NEXT:    vpmuludq %zmm3, %zmm0, %zmm0
; X64-KNL-NEXT:    vpsllq $32, %zmm0, %zmm0
; X64-KNL-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; X64-KNL-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; X64-KNL-NEXT:    vpmuldq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm1, %zmm1
; X64-KNL-NEXT:    vpaddq %zmm1, %zmm0, %zmm1
; X64-KNL-NEXT:    kxnorw %k0, %k0, %k1
; X64-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-KNL-NEXT:    vpgatherqd 72(,%zmm1), %ymm0 {%k1}
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test10:
; X86-KNL:       # %bb.0: # %entry
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %ymm2
; X86-KNL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [80,80,80,80,80,80,80,80]
; X86-KNL-NEXT:    vpmulld %ymm3, %ymm1, %ymm1
; X86-KNL-NEXT:    vpmovqd %zmm0, %ymm0
; X86-KNL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [820,820,820,820,820,820,820,820]
; X86-KNL-NEXT:    vpmulld %ymm3, %ymm0, %ymm0
; X86-KNL-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; X86-KNL-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; X86-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-KNL-NEXT:    movw $255, %ax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    vpgatherdd 68(,%zmm1), %zmm0 {%k1}
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test10:
; X64-SKX-SMALL:       # %bb.0: # %entry
; X64-SKX-SMALL-NEXT:    vpbroadcastq %rdi, %zmm2
; X64-SKX-SMALL-NEXT:    vpmullq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; X64-SKX-SMALL-NEXT:    vpmuldq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm1, %zmm1
; X64-SKX-SMALL-NEXT:    vpaddq %zmm1, %zmm0, %zmm1
; X64-SKX-SMALL-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-SMALL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    vpgatherqd 72(,%zmm1), %ymm0 {%k1}
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test10:
; X64-SKX-LARGE:       # %bb.0: # %entry
; X64-SKX-LARGE-NEXT:    vpbroadcastq %rdi, %zmm2
; X64-SKX-LARGE-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpmuldq (%rax){1to8}, %zmm1, %zmm1
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpmullq (%rax){1to8}, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; X64-SKX-LARGE-NEXT:    vpaddq %zmm1, %zmm0, %zmm1
; X64-SKX-LARGE-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-LARGE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    vpgatherqd 72(,%zmm1), %ymm0 {%k1}
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test10:
; X86-SKX:       # %bb.0: # %entry
; X86-SKX-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm1, %ymm1
; X86-SKX-NEXT:    vpmovqd %zmm0, %ymm0
; X86-SKX-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to8}, %ymm0, %ymm0
; X86-SKX-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; X86-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vpgatherdd 68(,%ymm1), %ymm0 {%k1}
; X86-SKX-NEXT:    retl
entry:
  %broadcast.splatinsert = insertelement <8 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <8 x ptr> %broadcast.splatinsert, <8 x ptr> undef, <8 x i32> zeroinitializer

  %arrayidx = getelementptr  %struct.ST, <8 x ptr> %broadcast.splat, <8 x i64> %i1, i32 2, i32 1, <8 x i32> %ind5, i64 13
  %res = call <8 x i32 >  @llvm.masked.gather.v8i32.v8p0(<8 x ptr>%arrayidx, i32 4, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x i32> undef)
  ret <8 x i32> %res
}

; Splat index in GEP, requires broadcast
define <16 x float> @test11(ptr %base, i32 %ind) {
; X64-LABEL: test11:
; X64:       # %bb.0:
; X64-NEXT:    movslq %esi, %rax
; X64-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; X64-NEXT:    vgatherdps (%rax,%zmm1,4), %zmm0 {%k1}
; X64-NEXT:    retq
;
; X86-LABEL: test11:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $2, %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; X86-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %gep.random = getelementptr float, <16 x ptr> %broadcast.splat, i32 %ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

; We are checking the uniform base here. It is taken directly from input to vgatherdps
define <16 x float> @test12(ptr %base, <16 x i32> %ind) {
; X64-LABEL: test12:
; X64:       # %bb.0:
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    vgatherdps (%rdi,%zmm0,4), %zmm1 {%k1}
; X64-NEXT:    vmovaps %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test12:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    vgatherdps (%eax,%zmm0,4), %zmm1 {%k1}
; X86-NEXT:    vmovaps %zmm1, %zmm0
; X86-NEXT:    retl
  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr float, ptr%base, <16 x i64> %sext_ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

; The same as the previous, but the mask is undefined
define <16 x float> @test13(ptr %base, <16 x i32> %ind) {
; X64-LABEL: test13:
; X64:       # %bb.0:
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    vgatherdps (%rdi,%zmm0,4), %zmm1 {%k1}
; X64-NEXT:    vmovaps %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test13:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    vgatherdps (%eax,%zmm0,4), %zmm1 {%k1}
; X86-NEXT:    vmovaps %zmm1, %zmm0
; X86-NEXT:    retl
  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr float, ptr%base, <16 x i64> %sext_ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

; The base pointer is not splat, can't find unform base
define <16 x float> @test14(ptr %base, i32 %ind, <16 x ptr> %vec) {
; X64-LABEL: test14:
; X64:       # %bb.0:
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vpbroadcastd %esi, %zmm1
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-NEXT:    vgatherdps (%rax,%zmm1,4), %zmm0 {%k1}
; X64-NEXT:    retq
;
; X86-LABEL: test14:
; X86:       # %bb.0:
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vbroadcastss {{[0-9]+}}(%esp), %zmm1
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> %vec, ptr %base, i32 1
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %gep.random = getelementptr float, <16 x ptr> %broadcast.splat, i32 %ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

declare <4 x float> @llvm.masked.gather.v4f32.v4p0(<4 x ptr>, i32, <4 x i1>, <4 x float>)
declare <4 x double> @llvm.masked.gather.v4f64.v4p0(<4 x ptr>, i32, <4 x i1>, <4 x double>)
declare <2 x double> @llvm.masked.gather.v2f64.v2p0(<2 x ptr>, i32, <2 x i1>, <2 x double>)

; Gather smaller than existing instruction
define <4 x float> @test15(ptr %base, <4 x i32> %ind, <4 x i1> %mask) {
; X64-KNL-LABEL: test15:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %ymm0
; X64-KNL-NEXT:    vpsllq $2, %ymm0, %ymm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %ymm1
; X64-KNL-NEXT:    vpaddq %ymm0, %ymm1, %ymm1
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    # implicit-def: $xmm0
; X64-KNL-NEXT:    je .LBB14_2
; X64-KNL-NEXT:  # %bb.1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-KNL-NEXT:  .LBB14_2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB14_4
; X64-KNL-NEXT:  # %bb.3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rcx
; X64-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; X64-KNL-NEXT:  .LBB14_4: # %else2
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    vextracti128 $1, %ymm1, %xmm1
; X64-KNL-NEXT:    jne .LBB14_5
; X64-KNL-NEXT:  # %bb.6: # %else5
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB14_7
; X64-KNL-NEXT:  .LBB14_8: # %else8
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB14_5: # %cond.load4
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB14_8
; X64-KNL-NEXT:  .LBB14_7: # %cond.load7
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test15:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm1
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    # implicit-def: $xmm0
; X86-KNL-NEXT:    jne .LBB14_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB14_3
; X86-KNL-NEXT:  .LBB14_4: # %else2
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    jne .LBB14_5
; X86-KNL-NEXT:  .LBB14_6: # %else5
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    jne .LBB14_7
; X86-KNL-NEXT:  .LBB14_8: # %else8
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB14_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm1, %ecx
; X86-KNL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB14_4
; X86-KNL-NEXT:  .LBB14_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm1, %ecx
; X86-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    je .LBB14_6
; X86-KNL-NEXT:  .LBB14_5: # %cond.load4
; X86-KNL-NEXT:    vpextrd $2, %xmm1, %ecx
; X86-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    je .LBB14_8
; X86-KNL-NEXT:  .LBB14_7: # %cond.load7
; X86-KNL-NEXT:    vpextrd $3, %xmm1, %eax
; X86-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test15:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X64-SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-SKX-NEXT:    vgatherdps (%rdi,%xmm0,4), %xmm1 {%k1}
; X64-SKX-NEXT:    vmovaps %xmm1, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test15:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-SKX-NEXT:    vgatherdps (%eax,%xmm0,4), %xmm1 {%k1}
; X86-SKX-NEXT:    vmovaps %xmm1, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <4 x i32> %ind to <4 x i64>
  %gep.random = getelementptr float, ptr %base, <4 x i64> %sext_ind
  %res = call <4 x float> @llvm.masked.gather.v4f32.v4p0(<4 x ptr> %gep.random, i32 4, <4 x i1> %mask, <4 x float> undef)
  ret <4 x float>%res
}

; Gather smaller than existing instruction
define <4 x double> @test16(ptr %base, <4 x i32> %ind, <4 x i1> %mask, <4 x double> %src0) {
; X64-KNL-LABEL: test16:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %ymm0
; X64-KNL-NEXT:    vpsllq $3, %ymm0, %ymm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %ymm1
; X64-KNL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    je .LBB15_2
; X64-KNL-NEXT:  # %bb.1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1],ymm2[2,3,4,5,6,7]
; X64-KNL-NEXT:  .LBB15_2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB15_4
; X64-KNL-NEXT:  # %bb.3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vmovhps {{.*#+}} xmm1 = xmm2[0,1],mem[0,1]
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; X64-KNL-NEXT:  .LBB15_4: # %else2
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    vextracti128 $1, %ymm0, %xmm0
; X64-KNL-NEXT:    jne .LBB15_5
; X64-KNL-NEXT:  # %bb.6: # %else5
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB15_7
; X64-KNL-NEXT:  .LBB15_8: # %else8
; X64-KNL-NEXT:    vmovdqa %ymm2, %ymm0
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB15_5: # %cond.load4
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vpbroadcastq (%rcx), %ymm1
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm1[4,5],ymm2[6,7]
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB15_8
; X64-KNL-NEXT:  .LBB15_7: # %cond.load7
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vpbroadcastq (%rax), %ymm0
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; X64-KNL-NEXT:    vmovdqa %ymm2, %ymm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test16:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpslld $3, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB15_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB15_3
; X86-KNL-NEXT:  .LBB15_4: # %else2
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    jne .LBB15_5
; X86-KNL-NEXT:  .LBB15_6: # %else5
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    jne .LBB15_7
; X86-KNL-NEXT:  .LBB15_8: # %else8
; X86-KNL-NEXT:    vmovdqa %ymm2, %ymm0
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB15_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1],ymm2[2,3,4,5,6,7]
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB15_4
; X86-KNL-NEXT:  .LBB15_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-KNL-NEXT:    vmovhps {{.*#+}} xmm1 = xmm2[0,1],mem[0,1]
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    je .LBB15_6
; X86-KNL-NEXT:  .LBB15_5: # %cond.load4
; X86-KNL-NEXT:    vpextrd $2, %xmm0, %ecx
; X86-KNL-NEXT:    vpbroadcastq (%ecx), %ymm1
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm1[4,5],ymm2[6,7]
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    je .LBB15_8
; X86-KNL-NEXT:  .LBB15_7: # %cond.load7
; X86-KNL-NEXT:    vpextrd $3, %xmm0, %eax
; X86-KNL-NEXT:    vpbroadcastq (%eax), %ymm0
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; X86-KNL-NEXT:    vmovdqa %ymm2, %ymm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test16:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X64-SKX-NEXT:    vgatherdpd (%rdi,%xmm0,8), %ymm2 {%k1}
; X64-SKX-NEXT:    vmovapd %ymm2, %ymm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test16:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vgatherdpd (%eax,%xmm0,8), %ymm2 {%k1}
; X86-SKX-NEXT:    vmovapd %ymm2, %ymm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <4 x i32> %ind to <4 x i64>
  %gep.random = getelementptr double, ptr %base, <4 x i64> %sext_ind
  %res = call <4 x double> @llvm.masked.gather.v4f64.v4p0(<4 x ptr> %gep.random, i32 4, <4 x i1> %mask, <4 x double> %src0)
  ret <4 x double>%res
}

define <2 x double> @test17(ptr %base, <2 x i32> %ind, <2 x i1> %mask, <2 x double> %src0) {
; X64-KNL-LABEL: test17:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-KNL-NEXT:    vpsllq $3, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB16_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB16_3
; X64-KNL-NEXT:  .LBB16_4: # %else2
; X64-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB16_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovlps {{.*#+}} xmm2 = mem[0,1],xmm2[2,3]
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB16_4
; X64-KNL-NEXT:  .LBB16_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vmovhps {{.*#+}} xmm2 = xmm2[0,1],mem[0,1]
; X64-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test17:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpslld $3, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB16_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB16_3
; X86-KNL-NEXT:  .LBB16_4: # %else2
; X86-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB16_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vmovlps {{.*#+}} xmm2 = mem[0,1],xmm2[2,3]
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB16_4
; X86-KNL-NEXT:  .LBB16_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vmovhps {{.*#+}} xmm2 = xmm2[0,1],mem[0,1]
; X86-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test17:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X64-SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpsllq $3, %xmm0, %xmm0
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB16_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB16_3
; X64-SKX-NEXT:  .LBB16_4: # %else2
; X64-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB16_1: # %cond.load
; X64-SKX-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-NEXT:    vmovlps {{.*#+}} xmm2 = mem[0,1],xmm2[2,3]
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB16_4
; X64-SKX-NEXT:  .LBB16_3: # %cond.load1
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-NEXT:    vmovhps {{.*#+}} xmm2 = xmm2[0,1],mem[0,1]
; X64-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test17:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X86-SKX-NEXT:    vpslld $3, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB16_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB16_3
; X86-SKX-NEXT:  .LBB16_4: # %else2
; X86-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB16_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vmovlps {{.*#+}} xmm2 = mem[0,1],xmm2[2,3]
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB16_4
; X86-SKX-NEXT:  .LBB16_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vmovhps {{.*#+}} xmm2 = xmm2[0,1],mem[0,1]
; X86-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <2 x i32> %ind to <2 x i64>
  %gep.random = getelementptr double, ptr %base, <2 x i64> %sext_ind
  %res = call <2 x double> @llvm.masked.gather.v2f64.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> %mask, <2 x double> %src0)
  ret <2 x double>%res
}

declare void @llvm.masked.scatter.v4i32.v4p0(<4 x i32> , <4 x ptr> , i32 , <4 x i1> )
declare void @llvm.masked.scatter.v4f64.v4p0(<4 x double> , <4 x ptr> , i32 , <4 x i1> )
declare void @llvm.masked.scatter.v2i64.v2p0(<2 x i64> , <2 x ptr> , i32 , <2 x i1> )
declare void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> , <2 x ptr> , i32 , <2 x i1> )
declare void @llvm.masked.scatter.v2f32.v2p0(<2 x float> , <2 x ptr> , i32 , <2 x i1> )

define void @test18(<4 x i32>%a1, <4 x ptr> %ptr, <4 x i1>%mask) {
; X64-KNL-LABEL: test18:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpslld $31, %xmm2, %xmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    je .LBB17_2
; X64-KNL-NEXT:  # %bb.1: # %cond.store
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovss %xmm0, (%rcx)
; X64-KNL-NEXT:  .LBB17_2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB17_4
; X64-KNL-NEXT:  # %bb.3: # %cond.store1
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rcx
; X64-KNL-NEXT:    vextractps $1, %xmm0, (%rcx)
; X64-KNL-NEXT:  .LBB17_4: # %else2
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    vextracti128 $1, %ymm1, %xmm1
; X64-KNL-NEXT:    jne .LBB17_5
; X64-KNL-NEXT:  # %bb.6: # %else4
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB17_7
; X64-KNL-NEXT:  .LBB17_8: # %else6
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB17_5: # %cond.store3
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vextractps $2, %xmm0, (%rcx)
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB17_8
; X64-KNL-NEXT:  .LBB17_7: # %cond.store5
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-KNL-NEXT:    vextractps $3, %xmm0, (%rax)
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test18:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $31, %xmm2, %xmm2
; X86-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB17_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB17_3
; X86-KNL-NEXT:  .LBB17_4: # %else2
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    jne .LBB17_5
; X86-KNL-NEXT:  .LBB17_6: # %else4
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    jne .LBB17_7
; X86-KNL-NEXT:  .LBB17_8: # %else6
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB17_1: # %cond.store
; X86-KNL-NEXT:    vmovd %xmm1, %ecx
; X86-KNL-NEXT:    vmovss %xmm0, (%ecx)
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB17_4
; X86-KNL-NEXT:  .LBB17_3: # %cond.store1
; X86-KNL-NEXT:    vpextrd $1, %xmm1, %ecx
; X86-KNL-NEXT:    vextractps $1, %xmm0, (%ecx)
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    je .LBB17_6
; X86-KNL-NEXT:  .LBB17_5: # %cond.store3
; X86-KNL-NEXT:    vpextrd $2, %xmm1, %ecx
; X86-KNL-NEXT:    vextractps $2, %xmm0, (%ecx)
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    je .LBB17_8
; X86-KNL-NEXT:  .LBB17_7: # %cond.store5
; X86-KNL-NEXT:    vpextrd $3, %xmm1, %eax
; X86-KNL-NEXT:    vextractps $3, %xmm0, (%eax)
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test18:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $31, %xmm2, %xmm2
; X64-SKX-NEXT:    vpmovd2m %xmm2, %k1
; X64-SKX-NEXT:    vpscatterqd %xmm0, (,%ymm1) {%k1}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test18:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $31, %xmm2, %xmm2
; X86-SKX-NEXT:    vpmovd2m %xmm2, %k1
; X86-SKX-NEXT:    vpscatterdd %xmm0, (,%xmm1) {%k1}
; X86-SKX-NEXT:    retl
  call void @llvm.masked.scatter.v4i32.v4p0(<4 x i32> %a1, <4 x ptr> %ptr, i32 4, <4 x i1> %mask)
  ret void
}

define void @test19(<4 x double>%a1, ptr %ptr, <4 x i1>%mask, <4 x i64> %ind) {
; X64-KNL-LABEL: test19:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpsllq $3, %ymm2, %ymm1
; X64-KNL-NEXT:    vmovq %rdi, %xmm2
; X64-KNL-NEXT:    vpbroadcastq %xmm2, %ymm2
; X64-KNL-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    je .LBB18_2
; X64-KNL-NEXT:  # %bb.1: # %cond.store
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovlps %xmm0, (%rcx)
; X64-KNL-NEXT:  .LBB18_2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB18_4
; X64-KNL-NEXT:  # %bb.3: # %cond.store1
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rcx
; X64-KNL-NEXT:    vmovhps %xmm0, (%rcx)
; X64-KNL-NEXT:  .LBB18_4: # %else2
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X64-KNL-NEXT:    vextracti128 $1, %ymm1, %xmm1
; X64-KNL-NEXT:    jne .LBB18_5
; X64-KNL-NEXT:  # %bb.6: # %else4
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB18_7
; X64-KNL-NEXT:  .LBB18_8: # %else6
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB18_5: # %cond.store3
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovlps %xmm0, (%rcx)
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB18_8
; X64-KNL-NEXT:  .LBB18_7: # %cond.store5
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-KNL-NEXT:    vmovhps %xmm0, (%rax)
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test19:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; X86-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpmovqd %zmm2, %ymm1
; X86-KNL-NEXT:    vpslld $3, %xmm1, %xmm1
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm2
; X86-KNL-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    je .LBB18_2
; X86-KNL-NEXT:  # %bb.1: # %cond.store
; X86-KNL-NEXT:    vmovd %xmm1, %ecx
; X86-KNL-NEXT:    vmovlps %xmm0, (%ecx)
; X86-KNL-NEXT:  .LBB18_2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB18_4
; X86-KNL-NEXT:  # %bb.3: # %cond.store1
; X86-KNL-NEXT:    vpextrd $1, %xmm1, %ecx
; X86-KNL-NEXT:    vmovhps %xmm0, (%ecx)
; X86-KNL-NEXT:  .LBB18_4: # %else2
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-KNL-NEXT:    jne .LBB18_5
; X86-KNL-NEXT:  # %bb.6: # %else4
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    jne .LBB18_7
; X86-KNL-NEXT:  .LBB18_8: # %else6
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB18_5: # %cond.store3
; X86-KNL-NEXT:    vpextrd $2, %xmm1, %ecx
; X86-KNL-NEXT:    vmovlps %xmm0, (%ecx)
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    je .LBB18_8
; X86-KNL-NEXT:  .LBB18_7: # %cond.store5
; X86-KNL-NEXT:    vpextrd $3, %xmm1, %eax
; X86-KNL-NEXT:    vmovhps %xmm0, (%eax)
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test19:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X64-SKX-NEXT:    vscatterqpd %ymm0, (%rdi,%ymm2,8) {%k1}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test19:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vscatterqpd %ymm0, (%eax,%ymm2,8) {%k1}
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  %gep = getelementptr double, ptr %ptr, <4 x i64> %ind
  call void @llvm.masked.scatter.v4f64.v4p0(<4 x double> %a1, <4 x ptr> %gep, i32 8, <4 x i1> %mask)
  ret void
}

; Data type requires widening
define void @test20(<2 x float>%a1, <2 x ptr> %ptr, <2 x i1> %mask) {
; X64-KNL-LABEL: test20:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm2, %xmm2
; X64-KNL-NEXT:    vptestmq %zmm2, %zmm2, %k0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB19_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB19_3
; X64-KNL-NEXT:  .LBB19_4: # %else2
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB19_1: # %cond.store
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovd %xmm0, (%rcx)
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB19_4
; X64-KNL-NEXT:  .LBB19_3: # %cond.store1
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-KNL-NEXT:    vextractps $1, %xmm0, (%rax)
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test20:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm2, %xmm2
; X86-KNL-NEXT:    vptestmq %zmm2, %zmm2, %k0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB19_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB19_3
; X86-KNL-NEXT:  .LBB19_4: # %else2
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB19_1: # %cond.store
; X86-KNL-NEXT:    vmovd %xmm1, %ecx
; X86-KNL-NEXT:    vmovd %xmm0, (%ecx)
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB19_4
; X86-KNL-NEXT:  .LBB19_3: # %cond.store1
; X86-KNL-NEXT:    vpextrd $1, %xmm1, %eax
; X86-KNL-NEXT:    vextractps $1, %xmm0, (%eax)
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test20:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm2, %xmm2
; X64-SKX-NEXT:    vpmovq2m %xmm2, %k0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB19_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB19_3
; X64-SKX-NEXT:  .LBB19_4: # %else2
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB19_1: # %cond.store
; X64-SKX-NEXT:    vmovq %xmm1, %rcx
; X64-SKX-NEXT:    vmovd %xmm0, (%rcx)
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB19_4
; X64-SKX-NEXT:  .LBB19_3: # %cond.store1
; X64-SKX-NEXT:    vpextrq $1, %xmm1, %rax
; X64-SKX-NEXT:    vextractps $1, %xmm0, (%rax)
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test20:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm2, %xmm2
; X86-SKX-NEXT:    vpmovq2m %xmm2, %k0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB19_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB19_3
; X86-SKX-NEXT:  .LBB19_4: # %else2
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB19_1: # %cond.store
; X86-SKX-NEXT:    vmovd %xmm1, %ecx
; X86-SKX-NEXT:    vmovd %xmm0, (%ecx)
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB19_4
; X86-SKX-NEXT:  .LBB19_3: # %cond.store1
; X86-SKX-NEXT:    vpextrd $1, %xmm1, %eax
; X86-SKX-NEXT:    vextractps $1, %xmm0, (%eax)
; X86-SKX-NEXT:    retl
  call void @llvm.masked.scatter.v2f32.v2p0(<2 x float> %a1, <2 x ptr> %ptr, i32 4, <2 x i1> %mask)
  ret void
}

; Data type requires promotion
define void @test21(<2 x i32>%a1, <2 x ptr> %ptr, <2 x i1>%mask) {
; X64-KNL-LABEL: test21:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm2, %xmm2
; X64-KNL-NEXT:    vptestmq %zmm2, %zmm2, %k0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB20_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB20_3
; X64-KNL-NEXT:  .LBB20_4: # %else2
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB20_1: # %cond.store
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovss %xmm0, (%rcx)
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB20_4
; X64-KNL-NEXT:  .LBB20_3: # %cond.store1
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-KNL-NEXT:    vextractps $1, %xmm0, (%rax)
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test21:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm2, %xmm2
; X86-KNL-NEXT:    vptestmq %zmm2, %zmm2, %k0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB20_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB20_3
; X86-KNL-NEXT:  .LBB20_4: # %else2
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB20_1: # %cond.store
; X86-KNL-NEXT:    vmovd %xmm1, %ecx
; X86-KNL-NEXT:    vmovss %xmm0, (%ecx)
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB20_4
; X86-KNL-NEXT:  .LBB20_3: # %cond.store1
; X86-KNL-NEXT:    vpextrd $1, %xmm1, %eax
; X86-KNL-NEXT:    vextractps $1, %xmm0, (%eax)
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test21:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm2, %xmm2
; X64-SKX-NEXT:    vpmovq2m %xmm2, %k0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB20_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB20_3
; X64-SKX-NEXT:  .LBB20_4: # %else2
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB20_1: # %cond.store
; X64-SKX-NEXT:    vmovq %xmm1, %rcx
; X64-SKX-NEXT:    vmovss %xmm0, (%rcx)
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB20_4
; X64-SKX-NEXT:  .LBB20_3: # %cond.store1
; X64-SKX-NEXT:    vpextrq $1, %xmm1, %rax
; X64-SKX-NEXT:    vextractps $1, %xmm0, (%rax)
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test21:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm2, %xmm2
; X86-SKX-NEXT:    vpmovq2m %xmm2, %k0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB20_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB20_3
; X86-SKX-NEXT:  .LBB20_4: # %else2
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB20_1: # %cond.store
; X86-SKX-NEXT:    vmovd %xmm1, %ecx
; X86-SKX-NEXT:    vmovss %xmm0, (%ecx)
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB20_4
; X86-SKX-NEXT:  .LBB20_3: # %cond.store1
; X86-SKX-NEXT:    vpextrd $1, %xmm1, %eax
; X86-SKX-NEXT:    vextractps $1, %xmm0, (%eax)
; X86-SKX-NEXT:    retl
  call void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> %a1, <2 x ptr> %ptr, i32 4, <2 x i1> %mask)
  ret void
}

; The result type requires widening
declare <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr>, i32, <2 x i1>, <2 x float>)

define <2 x float> @test22(ptr %base, <2 x i32> %ind, <2 x i1> %mask, <2 x float> %src0) {
; X64-KNL-LABEL: test22:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-KNL-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB21_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB21_3
; X64-KNL-NEXT:  .LBB21_4: # %else2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB21_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-KNL-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB21_4
; X64-KNL-NEXT:  .LBB21_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X64-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test22:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB21_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB21_3
; X86-KNL-NEXT:  .LBB21_4: # %else2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB21_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB21_4
; X86-KNL-NEXT:  .LBB21_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X86-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test22:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X64-SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB21_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB21_3
; X64-SKX-NEXT:  .LBB21_4: # %else2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB21_1: # %cond.load
; X64-SKX-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-SKX-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB21_4
; X64-SKX-NEXT:  .LBB21_3: # %cond.load1
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X64-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test22:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X86-SKX-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB21_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB21_3
; X86-SKX-NEXT:  .LBB21_4: # %else2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB21_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SKX-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB21_4
; X86-SKX-NEXT:  .LBB21_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X86-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <2 x i32> %ind to <2 x i64>
  %gep.random = getelementptr float, ptr %base, <2 x i64> %sext_ind
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> %mask, <2 x float> %src0)
  ret <2 x float>%res
}

define <2 x float> @test22a(ptr %base, <2 x i64> %ind, <2 x i1> %mask, <2 x float> %src0) {
; X64-KNL-LABEL: test22a:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB22_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB22_3
; X64-KNL-NEXT:  .LBB22_4: # %else2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB22_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-KNL-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB22_4
; X64-KNL-NEXT:  .LBB22_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X64-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test22a:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB22_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB22_3
; X86-KNL-NEXT:  .LBB22_4: # %else2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB22_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB22_4
; X86-KNL-NEXT:  .LBB22_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X86-KNL-NEXT:    vmovaps %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test22a:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X64-SKX-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB22_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB22_3
; X64-SKX-NEXT:  .LBB22_4: # %else2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB22_1: # %cond.load
; X64-SKX-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-SKX-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB22_4
; X64-SKX-NEXT:  .LBB22_3: # %cond.load1
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X64-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test22a:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X86-SKX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-SKX-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB22_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB22_3
; X86-SKX-NEXT:  .LBB22_4: # %else2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB22_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SKX-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB22_4
; X86-SKX-NEXT:  .LBB22_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; X86-SKX-NEXT:    vmovaps %xmm2, %xmm0
; X86-SKX-NEXT:    retl
  %gep.random = getelementptr float, ptr %base, <2 x i64> %ind
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> %mask, <2 x float> %src0)
  ret <2 x float>%res
}

declare <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr>, i32, <2 x i1>, <2 x i32>)
declare <2 x i64> @llvm.masked.gather.v2i64.v2p0(<2 x ptr>, i32, <2 x i1>, <2 x i64>)

define <2 x i32> @test23(ptr %base, <2 x i32> %ind, <2 x i1> %mask, <2 x i32> %src0) {
; X64-KNL-LABEL: test23:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-KNL-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB23_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB23_3
; X64-KNL-NEXT:  .LBB23_4: # %else2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB23_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrd $0, (%rcx), %xmm2, %xmm2
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB23_4
; X64-KNL-NEXT:  .LBB23_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vpinsrd $1, (%rax), %xmm2, %xmm2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test23:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB23_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB23_3
; X86-KNL-NEXT:  .LBB23_4: # %else2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB23_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vpinsrd $0, (%ecx), %xmm2, %xmm2
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB23_4
; X86-KNL-NEXT:  .LBB23_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vpinsrd $1, (%eax), %xmm2, %xmm2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test23:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X64-SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB23_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB23_3
; X64-SKX-NEXT:  .LBB23_4: # %else2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB23_1: # %cond.load
; X64-SKX-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-NEXT:    vpinsrd $0, (%rcx), %xmm2, %xmm2
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB23_4
; X64-SKX-NEXT:  .LBB23_3: # %cond.load1
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-NEXT:    vpinsrd $1, (%rax), %xmm2, %xmm2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test23:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X86-SKX-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB23_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB23_3
; X86-SKX-NEXT:  .LBB23_4: # %else2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB23_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vpinsrd $0, (%ecx), %xmm2, %xmm2
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB23_4
; X86-SKX-NEXT:  .LBB23_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vpinsrd $1, (%eax), %xmm2, %xmm2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <2 x i32> %ind to <2 x i64>
  %gep.random = getelementptr i32, ptr %base, <2 x i64> %sext_ind
  %res = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> %mask, <2 x i32> %src0)
  ret <2 x i32>%res
}

define <2 x i32> @test23b(ptr %base, <2 x i64> %ind, <2 x i1> %mask, <2 x i32> %src0) {
; X64-KNL-LABEL: test23b:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB24_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB24_3
; X64-KNL-NEXT:  .LBB24_4: # %else2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB24_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrd $0, (%rcx), %xmm2, %xmm2
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB24_4
; X64-KNL-NEXT:  .LBB24_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vpinsrd $1, (%rax), %xmm2, %xmm2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test23b:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB24_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB24_3
; X86-KNL-NEXT:  .LBB24_4: # %else2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB24_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vpinsrd $0, (%ecx), %xmm2, %xmm2
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB24_4
; X86-KNL-NEXT:  .LBB24_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vpinsrd $1, (%eax), %xmm2, %xmm2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test23b:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X64-SKX-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB24_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB24_3
; X64-SKX-NEXT:  .LBB24_4: # %else2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB24_1: # %cond.load
; X64-SKX-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-NEXT:    vpinsrd $0, (%rcx), %xmm2, %xmm2
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB24_4
; X64-SKX-NEXT:  .LBB24_3: # %cond.load1
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-NEXT:    vpinsrd $1, (%rax), %xmm2, %xmm2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test23b:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X86-SKX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-SKX-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB24_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB24_3
; X86-SKX-NEXT:  .LBB24_4: # %else2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB24_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vpinsrd $0, (%ecx), %xmm2, %xmm2
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB24_4
; X86-SKX-NEXT:  .LBB24_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vpinsrd $1, (%eax), %xmm2, %xmm2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
  %gep.random = getelementptr i32, ptr %base, <2 x i64> %ind
  %res = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> %mask, <2 x i32> %src0)
  ret <2 x i32>%res
}

define <2 x i32> @test24(ptr %base, <2 x i32> %ind) {
; X64-KNL-LABEL: test24:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-KNL-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    vmovq %xmm0, %rax
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-KNL-NEXT:    vpinsrd $1, (%rcx), %xmm0, %xmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test24:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    vmovd %xmm0, %eax
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-KNL-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    vpinsrd $1, (%ecx), %xmm0, %xmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test24:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    vmovq %xmm0, %rax
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-SKX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-SKX-NEXT:    vpinsrd $1, (%rcx), %xmm0, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test24:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    vmovd %xmm0, %eax
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-SKX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SKX-NEXT:    vpinsrd $1, (%ecx), %xmm0, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <2 x i32> %ind to <2 x i64>
  %gep.random = getelementptr i32, ptr %base, <2 x i64> %sext_ind
  %res = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> <i1 true, i1 true>, <2 x i32> undef)
  ret <2 x i32>%res
}

define <2 x i64> @test25(ptr %base, <2 x i32> %ind, <2 x i1> %mask, <2 x i64> %src0) {
; X64-KNL-LABEL: test25:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-KNL-NEXT:    vpsllq $3, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB26_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB26_3
; X64-KNL-NEXT:  .LBB26_4: # %else2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB26_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrq $0, (%rcx), %xmm2, %xmm2
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB26_4
; X64-KNL-NEXT:  .LBB26_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vpinsrq $1, (%rax), %xmm2, %xmm2
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test25:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmq %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    vpslld $3, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB26_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB26_3
; X86-KNL-NEXT:  .LBB26_4: # %else2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB26_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vpinsrd $0, (%ecx), %xmm2, %xmm1
; X86-KNL-NEXT:    vpinsrd $1, 4(%ecx), %xmm1, %xmm2
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB26_4
; X86-KNL-NEXT:  .LBB26_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vpinsrd $2, (%eax), %xmm2, %xmm0
; X86-KNL-NEXT:    vpinsrd $3, 4(%eax), %xmm0, %xmm2
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test25:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X64-SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpsllq $3, %xmm0, %xmm0
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB26_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB26_3
; X64-SKX-NEXT:  .LBB26_4: # %else2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB26_1: # %cond.load
; X64-SKX-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-NEXT:    vpinsrq $0, (%rcx), %xmm2, %xmm2
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB26_4
; X64-SKX-NEXT:  .LBB26_3: # %cond.load1
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-NEXT:    vpinsrq $1, (%rax), %xmm2, %xmm2
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test25:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovq2m %xmm1, %k0
; X86-SKX-NEXT:    vpslld $3, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB26_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB26_3
; X86-SKX-NEXT:  .LBB26_4: # %else2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB26_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vpinsrd $0, (%ecx), %xmm2, %xmm1
; X86-SKX-NEXT:    vpinsrd $1, 4(%ecx), %xmm1, %xmm2
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB26_4
; X86-SKX-NEXT:  .LBB26_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vpinsrd $2, (%eax), %xmm2, %xmm0
; X86-SKX-NEXT:    vpinsrd $3, 4(%eax), %xmm0, %xmm2
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <2 x i32> %ind to <2 x i64>
  %gep.random = getelementptr i64, ptr %base, <2 x i64> %sext_ind
  %res = call <2 x i64> @llvm.masked.gather.v2i64.v2p0(<2 x ptr> %gep.random, i32 8, <2 x i1> %mask, <2 x i64> %src0)
  ret <2 x i64>%res
}

define <2 x i64> @test26(ptr %base, <2 x i32> %ind, <2 x i64> %src0) {
; X64-KNL-LABEL: test26:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-KNL-NEXT:    vpsllq $3, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    vmovq %xmm0, %rax
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X64-KNL-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; X64-KNL-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test26:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $3, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    vmovd %xmm0, %eax
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-KNL-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    vpinsrd $1, 4(%eax), %xmm0, %xmm0
; X86-KNL-NEXT:    vpinsrd $2, (%ecx), %xmm0, %xmm0
; X86-KNL-NEXT:    vpinsrd $3, 4(%ecx), %xmm0, %xmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test26:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpsllq $3, %xmm0, %xmm0
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    vmovq %xmm0, %rax
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-SKX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X64-SKX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; X64-SKX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test26:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $3, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    vmovd %xmm0, %eax
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-SKX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SKX-NEXT:    vpinsrd $1, 4(%eax), %xmm0, %xmm0
; X86-SKX-NEXT:    vpinsrd $2, (%ecx), %xmm0, %xmm0
; X86-SKX-NEXT:    vpinsrd $3, 4(%ecx), %xmm0, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <2 x i32> %ind to <2 x i64>
  %gep.random = getelementptr i64, ptr %base, <2 x i64> %sext_ind
  %res = call <2 x i64> @llvm.masked.gather.v2i64.v2p0(<2 x ptr> %gep.random, i32 8, <2 x i1> <i1 true, i1 true>, <2 x i64> %src0)
  ret <2 x i64>%res
}

; Result type requires widening; all-ones mask
define <2 x float> @test27(ptr %base, <2 x i32> %ind) {
; X64-KNL-LABEL: test27:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-KNL-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm1
; X64-KNL-NEXT:    vpbroadcastq %xmm1, %xmm1
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-KNL-NEXT:    vmovq %xmm0, %rax
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test27:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm1
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-KNL-NEXT:    vmovd %xmm0, %eax
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-KNL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test27:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxdq %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm1
; X64-SKX-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-SKX-NEXT:    vmovq %xmm0, %rax
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-SKX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-SKX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test27:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    vmovd %xmm0, %eax
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-SKX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SKX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; X86-SKX-NEXT:    retl
  %sext_ind = sext <2 x i32> %ind to <2 x i64>
  %gep.random = getelementptr float, ptr %base, <2 x i64> %sext_ind
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> <i1 true, i1 true>, <2 x float> undef)
  ret <2 x float>%res
}

; Data type requires promotion, mask is all-ones
define void @test28(<2 x i32>%a1, <2 x ptr> %ptr) {
; X64-LABEL: test28:
; X64:       # %bb.0:
; X64-NEXT:    vmovq %xmm1, %rax
; X64-NEXT:    vmovss %xmm0, (%rax)
; X64-NEXT:    vpextrq $1, %xmm1, %rax
; X64-NEXT:    vextractps $1, %xmm0, (%rax)
; X64-NEXT:    retq
;
; X86-LABEL: test28:
; X86:       # %bb.0:
; X86-NEXT:    vmovd %xmm1, %eax
; X86-NEXT:    vmovss %xmm0, (%eax)
; X86-NEXT:    vpextrd $1, %xmm1, %eax
; X86-NEXT:    vextractps $1, %xmm0, (%eax)
; X86-NEXT:    retl
  call void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> %a1, <2 x ptr> %ptr, i32 4, <2 x i1> <i1 true, i1 true>)
  ret void
}

; SCALAR-LABEL: test29
; SCALAR:      extractelement <16 x ptr>
; SCALAR-NEXT: load float
; SCALAR-NEXT: insertelement <16 x float>
; SCALAR-NEXT: extractelement <16 x ptr>
; SCALAR-NEXT: load float

define <16 x float> @test29(ptr %base, <16 x i32> %ind) {
; X64-LABEL: test29:
; X64:       # %bb.0:
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    movw $44, %ax
; X64-NEXT:    kmovw %eax, %k1
; X64-NEXT:    vgatherdps (%rdi,%zmm0,4), %zmm1 {%k1}
; X64-NEXT:    vmovaps %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test29:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    movw $44, %cx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vgatherdps (%eax,%zmm0,4), %zmm1 {%k1}
; X86-NEXT:    vmovaps %zmm1, %zmm0
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr float, <16 x ptr> %broadcast.splat, <16 x i64> %sext_ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 false, i1 false, i1 true, i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false>, <16 x float> undef)
  ret <16 x float>%res
}

declare <3 x i32> @llvm.masked.gather.v3i32.v3p0(<3 x ptr>, i32, <3 x i1>, <3 x i32>)
define <3 x i32> @test30(<3 x ptr> %base, <3 x i32> %ind, <3 x i1> %mask, <3 x i32> %src0) {
; X64-KNL-LABEL: test30:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $xmm2 killed $xmm2 def $ymm2
; X64-KNL-NEXT:    andl $1, %edi
; X64-KNL-NEXT:    kmovw %edi, %k0
; X64-KNL-NEXT:    kmovw %esi, %k1
; X64-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X64-KNL-NEXT:    kshiftrw $14, %k1, %k1
; X64-KNL-NEXT:    korw %k1, %k0, %k0
; X64-KNL-NEXT:    movw $-5, %ax
; X64-KNL-NEXT:    kmovw %eax, %k1
; X64-KNL-NEXT:    kandw %k1, %k0, %k0
; X64-KNL-NEXT:    kmovw %edx, %k1
; X64-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X64-KNL-NEXT:    kshiftrw $13, %k1, %k1
; X64-KNL-NEXT:    korw %k1, %k0, %k0
; X64-KNL-NEXT:    movb $7, %al
; X64-KNL-NEXT:    kmovw %eax, %k1
; X64-KNL-NEXT:    kandw %k1, %k0, %k0
; X64-KNL-NEXT:    kshiftlw $12, %k0, %k0
; X64-KNL-NEXT:    kshiftrw $12, %k0, %k1
; X64-KNL-NEXT:    vpmovsxdq %xmm1, %ymm1
; X64-KNL-NEXT:    vpsllq $2, %ymm1, %ymm1
; X64-KNL-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X64-KNL-NEXT:    vpgatherqd (,%zmm0), %ymm2 {%k1}
; X64-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test30:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    andl $1, %eax
; X86-KNL-NEXT:    kmovw %eax, %k0
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X86-KNL-NEXT:    kshiftrw $14, %k1, %k1
; X86-KNL-NEXT:    korw %k1, %k0, %k0
; X86-KNL-NEXT:    movw $-5, %ax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kandw %k1, %k0, %k0
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X86-KNL-NEXT:    kshiftrw $13, %k1, %k1
; X86-KNL-NEXT:    korw %k1, %k0, %k0
; X86-KNL-NEXT:    movb $7, %al
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kandw %k1, %k0, %k0
; X86-KNL-NEXT:    kshiftlw $12, %k0, %k0
; X86-KNL-NEXT:    kshiftrw $12, %k0, %k1
; X86-KNL-NEXT:    vpslld $2, %xmm1, %xmm1
; X86-KNL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X86-KNL-NEXT:    vpgatherdd (,%zmm0), %zmm2 {%k1}
; X86-KNL-NEXT:    vmovdqa %xmm2, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test30:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    kmovw %esi, %k0
; X64-SKX-NEXT:    kshiftlb $7, %k0, %k0
; X64-SKX-NEXT:    kshiftrb $6, %k0, %k0
; X64-SKX-NEXT:    kmovw %edi, %k1
; X64-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X64-SKX-NEXT:    kshiftrb $7, %k1, %k1
; X64-SKX-NEXT:    korw %k0, %k1, %k0
; X64-SKX-NEXT:    movb $-5, %al
; X64-SKX-NEXT:    kmovw %eax, %k1
; X64-SKX-NEXT:    kandw %k1, %k0, %k0
; X64-SKX-NEXT:    kmovw %edx, %k1
; X64-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X64-SKX-NEXT:    kshiftrb $5, %k1, %k1
; X64-SKX-NEXT:    korw %k1, %k0, %k0
; X64-SKX-NEXT:    movb $7, %al
; X64-SKX-NEXT:    kmovw %eax, %k1
; X64-SKX-NEXT:    kandw %k1, %k0, %k1
; X64-SKX-NEXT:    vpmovsxdq %xmm1, %ymm1
; X64-SKX-NEXT:    vpsllq $2, %ymm1, %ymm1
; X64-SKX-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X64-SKX-NEXT:    vpgatherqd (,%ymm0), %xmm2 {%k1}
; X64-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test30:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovw %eax, %k0
; X86-SKX-NEXT:    kshiftlb $7, %k0, %k0
; X86-SKX-NEXT:    kshiftrb $6, %k0, %k0
; X86-SKX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X86-SKX-NEXT:    kshiftrb $7, %k1, %k1
; X86-SKX-NEXT:    korw %k0, %k1, %k0
; X86-SKX-NEXT:    movb $-5, %al
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kandw %k1, %k0, %k0
; X86-SKX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X86-SKX-NEXT:    kshiftrb $5, %k1, %k1
; X86-SKX-NEXT:    korw %k1, %k0, %k0
; X86-SKX-NEXT:    movb $7, %al
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kandw %k1, %k0, %k1
; X86-SKX-NEXT:    vpslld $2, %xmm1, %xmm1
; X86-SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X86-SKX-NEXT:    vpgatherdd (,%xmm0), %xmm2 {%k1}
; X86-SKX-NEXT:    vmovdqa %xmm2, %xmm0
; X86-SKX-NEXT:    retl
  %sext_ind = sext <3 x i32> %ind to <3 x i64>
  %gep.random = getelementptr i32, <3 x ptr> %base, <3 x i64> %sext_ind
  %res = call <3 x i32> @llvm.masked.gather.v3i32.v3p0(<3 x ptr> %gep.random, i32 4, <3 x i1> %mask, <3 x i32> %src0)
  ret <3 x i32>%res
}

; Non-power of 2 scatter
declare void @llvm.masked.scatter.v3i32.v3p0(<3 x i32>, <3 x ptr>, i32, <3 x i1>)
define void @test30b(<3 x ptr> %base, <3 x i32> %ind, <3 x i1> %mask, <3 x i32> %src0) {
; X64-KNL-LABEL: test30b:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $xmm2 killed $xmm2 def $ymm2
; X64-KNL-NEXT:    andl $1, %edi
; X64-KNL-NEXT:    kmovw %edi, %k0
; X64-KNL-NEXT:    kmovw %esi, %k1
; X64-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X64-KNL-NEXT:    kshiftrw $14, %k1, %k1
; X64-KNL-NEXT:    korw %k1, %k0, %k0
; X64-KNL-NEXT:    movw $-5, %ax
; X64-KNL-NEXT:    kmovw %eax, %k1
; X64-KNL-NEXT:    kandw %k1, %k0, %k0
; X64-KNL-NEXT:    kmovw %edx, %k1
; X64-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X64-KNL-NEXT:    kshiftrw $13, %k1, %k1
; X64-KNL-NEXT:    korw %k1, %k0, %k0
; X64-KNL-NEXT:    movb $7, %al
; X64-KNL-NEXT:    kmovw %eax, %k1
; X64-KNL-NEXT:    kandw %k1, %k0, %k0
; X64-KNL-NEXT:    kshiftlw $12, %k0, %k0
; X64-KNL-NEXT:    kshiftrw $12, %k0, %k1
; X64-KNL-NEXT:    vpmovsxdq %xmm1, %ymm1
; X64-KNL-NEXT:    vpsllq $2, %ymm1, %ymm1
; X64-KNL-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X64-KNL-NEXT:    vpscatterqd %ymm2, (,%zmm0) {%k1}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test30b:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    andl $1, %eax
; X86-KNL-NEXT:    kmovw %eax, %k0
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X86-KNL-NEXT:    kshiftrw $14, %k1, %k1
; X86-KNL-NEXT:    korw %k1, %k0, %k0
; X86-KNL-NEXT:    movw $-5, %ax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kandw %k1, %k0, %k0
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kshiftlw $15, %k1, %k1
; X86-KNL-NEXT:    kshiftrw $13, %k1, %k1
; X86-KNL-NEXT:    korw %k1, %k0, %k0
; X86-KNL-NEXT:    movb $7, %al
; X86-KNL-NEXT:    kmovw %eax, %k1
; X86-KNL-NEXT:    kandw %k1, %k0, %k0
; X86-KNL-NEXT:    kshiftlw $12, %k0, %k0
; X86-KNL-NEXT:    kshiftrw $12, %k0, %k1
; X86-KNL-NEXT:    vpslld $2, %xmm1, %xmm1
; X86-KNL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X86-KNL-NEXT:    vpscatterdd %zmm2, (,%zmm0) {%k1}
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test30b:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    kmovw %esi, %k0
; X64-SKX-NEXT:    kshiftlb $7, %k0, %k0
; X64-SKX-NEXT:    kshiftrb $6, %k0, %k0
; X64-SKX-NEXT:    kmovw %edi, %k1
; X64-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X64-SKX-NEXT:    kshiftrb $7, %k1, %k1
; X64-SKX-NEXT:    korw %k0, %k1, %k0
; X64-SKX-NEXT:    movb $-5, %al
; X64-SKX-NEXT:    kmovw %eax, %k1
; X64-SKX-NEXT:    kandw %k1, %k0, %k0
; X64-SKX-NEXT:    kmovw %edx, %k1
; X64-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X64-SKX-NEXT:    kshiftrb $5, %k1, %k1
; X64-SKX-NEXT:    korw %k1, %k0, %k0
; X64-SKX-NEXT:    movb $7, %al
; X64-SKX-NEXT:    kmovw %eax, %k1
; X64-SKX-NEXT:    kandw %k1, %k0, %k1
; X64-SKX-NEXT:    vpmovsxdq %xmm1, %ymm1
; X64-SKX-NEXT:    vpsllq $2, %ymm1, %ymm1
; X64-SKX-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X64-SKX-NEXT:    vpscatterqd %xmm2, (,%ymm0) {%k1}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test30b:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovw %eax, %k0
; X86-SKX-NEXT:    kshiftlb $7, %k0, %k0
; X86-SKX-NEXT:    kshiftrb $6, %k0, %k0
; X86-SKX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X86-SKX-NEXT:    kshiftrb $7, %k1, %k1
; X86-SKX-NEXT:    korw %k0, %k1, %k0
; X86-SKX-NEXT:    movb $-5, %al
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kandw %k1, %k0, %k0
; X86-SKX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kshiftlb $7, %k1, %k1
; X86-SKX-NEXT:    kshiftrb $5, %k1, %k1
; X86-SKX-NEXT:    korw %k1, %k0, %k0
; X86-SKX-NEXT:    movb $7, %al
; X86-SKX-NEXT:    kmovw %eax, %k1
; X86-SKX-NEXT:    kandw %k1, %k0, %k1
; X86-SKX-NEXT:    vpslld $2, %xmm1, %xmm1
; X86-SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X86-SKX-NEXT:    vpscatterdd %xmm2, (,%xmm0) {%k1}
; X86-SKX-NEXT:    retl
  %sext_ind = sext <3 x i32> %ind to <3 x i64>
  %gep.random = getelementptr i32, <3 x ptr> %base, <3 x i64> %sext_ind
  call void @llvm.masked.scatter.v3i32.v3p0(<3 x i32> %src0, <3 x ptr> %gep.random, i32 4, <3 x i1> %mask)
  ret void
}

declare <16 x ptr> @llvm.masked.gather.v16p0.v16p0(<16 x ptr>, i32, <16 x i1>, <16 x ptr>)
define <16 x ptr> @test31(<16 x ptr> %ptrs) {
; X64-LABEL: test31:
; X64:       # %bb.0:
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X64-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; X64-NEXT:    kxnorw %k0, %k0, %k2
; X64-NEXT:    vpgatherqq (,%zmm0), %zmm3 {%k2}
; X64-NEXT:    vpgatherqq (,%zmm1), %zmm2 {%k1}
; X64-NEXT:    vmovdqa64 %zmm3, %zmm0
; X64-NEXT:    vmovdqa64 %zmm2, %zmm1
; X64-NEXT:    retq
;
; X86-LABEL: test31:
; X86:       # %bb.0:
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-NEXT:    vpgatherdd (,%zmm0), %zmm1 {%k1}
; X86-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-NEXT:    retl
  %res = call <16 x ptr> @llvm.masked.gather.v16p0.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x ptr> undef)
  ret <16 x ptr>%res
}

define <16 x i32> @test_gather_16i32(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x i32> %src0)  {
; X64-KNL-LABEL: test_gather_16i32:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    vextracti64x4 $1, %zmm3, %ymm2
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vpgatherqd (,%zmm1), %ymm2 {%k2}
; X64-KNL-NEXT:    vpgatherqd (,%zmm0), %ymm3 {%k1}
; X64-KNL-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_16i32:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vpgatherdd (,%zmm0), %zmm2 {%k1}
; X86-KNL-NEXT:    vmovdqa64 %zmm2, %zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_gather_16i32:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    vextracti64x4 $1, %zmm3, %ymm2
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vpgatherqd (,%zmm1), %ymm2 {%k2}
; X64-SKX-NEXT:    vpgatherqd (,%zmm0), %ymm3 {%k1}
; X64-SKX-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_16i32:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vpgatherdd (,%zmm0), %zmm2 {%k1}
; X86-SKX-NEXT:    vmovdqa64 %zmm2, %zmm0
; X86-SKX-NEXT:    retl
  %res = call <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x i32> %src0)
  ret <16 x i32> %res
}
define <16 x i64> @test_gather_16i64(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x i64> %src0)  {
; X64-KNL-LABEL: test_gather_16i64:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vpgatherqq (,%zmm0), %zmm3 {%k1}
; X64-KNL-NEXT:    vpgatherqq (,%zmm1), %zmm4 {%k2}
; X64-KNL-NEXT:    vmovdqa64 %zmm3, %zmm0
; X64-KNL-NEXT:    vmovdqa64 %zmm4, %zmm1
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_16i64:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    pushl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_offset 8
; X86-KNL-NEXT:    .cfi_offset %ebp, -8
; X86-KNL-NEXT:    movl %esp, %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_register %ebp
; X86-KNL-NEXT:    andl $-64, %esp
; X86-KNL-NEXT:    subl $64, %esp
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vmovdqa64 8(%ebp), %zmm1
; X86-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X86-KNL-NEXT:    vpgatherdq (,%ymm0), %zmm2 {%k1}
; X86-KNL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; X86-KNL-NEXT:    vpgatherdq (,%ymm0), %zmm1 {%k2}
; X86-KNL-NEXT:    vmovdqa64 %zmm2, %zmm0
; X86-KNL-NEXT:    movl %ebp, %esp
; X86-KNL-NEXT:    popl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa %esp, 4
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_gather_16i64:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vpgatherqq (,%zmm0), %zmm3 {%k1}
; X64-SKX-NEXT:    vpgatherqq (,%zmm1), %zmm4 {%k2}
; X64-SKX-NEXT:    vmovdqa64 %zmm3, %zmm0
; X64-SKX-NEXT:    vmovdqa64 %zmm4, %zmm1
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_16i64:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    pushl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_offset 8
; X86-SKX-NEXT:    .cfi_offset %ebp, -8
; X86-SKX-NEXT:    movl %esp, %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_register %ebp
; X86-SKX-NEXT:    andl $-64, %esp
; X86-SKX-NEXT:    subl $64, %esp
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vmovdqa64 8(%ebp), %zmm1
; X86-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X86-SKX-NEXT:    vpgatherdq (,%ymm0), %zmm2 {%k1}
; X86-SKX-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; X86-SKX-NEXT:    vpgatherdq (,%ymm0), %zmm1 {%k2}
; X86-SKX-NEXT:    vmovdqa64 %zmm2, %zmm0
; X86-SKX-NEXT:    movl %ebp, %esp
; X86-SKX-NEXT:    popl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa %esp, 4
; X86-SKX-NEXT:    retl
  %res = call <16 x i64> @llvm.masked.gather.v16i64.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x i64> %src0)
  ret <16 x i64> %res
}
declare <16 x i64> @llvm.masked.gather.v16i64.v16p0(<16 x ptr> %ptrs, i32, <16 x i1> %mask, <16 x i64> %src0)
define <16 x float> @test_gather_16f32(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x float> %src0)  {
; X64-KNL-LABEL: test_gather_16f32:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    vextractf64x4 $1, %zmm3, %ymm2
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vgatherqps (,%zmm1), %ymm2 {%k2}
; X64-KNL-NEXT:    vgatherqps (,%zmm0), %ymm3 {%k1}
; X64-KNL-NEXT:    vinsertf64x4 $1, %ymm2, %zmm3, %zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_16f32:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vgatherdps (,%zmm0), %zmm2 {%k1}
; X86-KNL-NEXT:    vmovaps %zmm2, %zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_gather_16f32:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    vextractf64x4 $1, %zmm3, %ymm2
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vgatherqps (,%zmm1), %ymm2 {%k2}
; X64-SKX-NEXT:    vgatherqps (,%zmm0), %ymm3 {%k1}
; X64-SKX-NEXT:    vinsertf64x4 $1, %ymm2, %zmm3, %zmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_16f32:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vgatherdps (,%zmm0), %zmm2 {%k1}
; X86-SKX-NEXT:    vmovaps %zmm2, %zmm0
; X86-SKX-NEXT:    retl
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x float> %src0)
  ret <16 x float> %res
}
define <16 x double> @test_gather_16f64(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x double> %src0)  {
; X64-KNL-LABEL: test_gather_16f64:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vgatherqpd (,%zmm0), %zmm3 {%k1}
; X64-KNL-NEXT:    vgatherqpd (,%zmm1), %zmm4 {%k2}
; X64-KNL-NEXT:    vmovapd %zmm3, %zmm0
; X64-KNL-NEXT:    vmovapd %zmm4, %zmm1
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_16f64:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    pushl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_offset 8
; X86-KNL-NEXT:    .cfi_offset %ebp, -8
; X86-KNL-NEXT:    movl %esp, %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_register %ebp
; X86-KNL-NEXT:    andl $-64, %esp
; X86-KNL-NEXT:    subl $64, %esp
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vmovapd 8(%ebp), %zmm1
; X86-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X86-KNL-NEXT:    vgatherdpd (,%ymm0), %zmm2 {%k1}
; X86-KNL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-KNL-NEXT:    vgatherdpd (,%ymm0), %zmm1 {%k2}
; X86-KNL-NEXT:    vmovapd %zmm2, %zmm0
; X86-KNL-NEXT:    movl %ebp, %esp
; X86-KNL-NEXT:    popl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa %esp, 4
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_gather_16f64:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vgatherqpd (,%zmm0), %zmm3 {%k1}
; X64-SKX-NEXT:    vgatherqpd (,%zmm1), %zmm4 {%k2}
; X64-SKX-NEXT:    vmovapd %zmm3, %zmm0
; X64-SKX-NEXT:    vmovapd %zmm4, %zmm1
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_16f64:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    pushl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_offset 8
; X86-SKX-NEXT:    .cfi_offset %ebp, -8
; X86-SKX-NEXT:    movl %esp, %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_register %ebp
; X86-SKX-NEXT:    andl $-64, %esp
; X86-SKX-NEXT:    subl $64, %esp
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vmovapd 8(%ebp), %zmm1
; X86-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X86-SKX-NEXT:    vgatherdpd (,%ymm0), %zmm2 {%k1}
; X86-SKX-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-SKX-NEXT:    vgatherdpd (,%ymm0), %zmm1 {%k2}
; X86-SKX-NEXT:    vmovapd %zmm2, %zmm0
; X86-SKX-NEXT:    movl %ebp, %esp
; X86-SKX-NEXT:    popl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa %esp, 4
; X86-SKX-NEXT:    retl
  %res = call <16 x double> @llvm.masked.gather.v16f64.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x double> %src0)
  ret <16 x double> %res
}
declare <16 x double> @llvm.masked.gather.v16f64.v16p0(<16 x ptr> %ptrs, i32, <16 x i1> %mask, <16 x double> %src0)
define void @test_scatter_16i32(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x i32> %src0)  {
; X64-KNL-LABEL: test_scatter_16i32:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vpscatterqd %ymm3, (,%zmm0) {%k1}
; X64-KNL-NEXT:    vextracti64x4 $1, %zmm3, %ymm0
; X64-KNL-NEXT:    vpscatterqd %ymm0, (,%zmm1) {%k2}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_scatter_16i32:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vpscatterdd %zmm2, (,%zmm0) {%k1}
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_scatter_16i32:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vpscatterqd %ymm3, (,%zmm0) {%k1}
; X64-SKX-NEXT:    vextracti64x4 $1, %zmm3, %ymm0
; X64-SKX-NEXT:    vpscatterqd %ymm0, (,%zmm1) {%k2}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_scatter_16i32:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vpscatterdd %zmm2, (,%zmm0) {%k1}
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  call void @llvm.masked.scatter.v16i32.v16p0(<16 x i32> %src0, <16 x ptr> %ptrs, i32 4, <16 x i1> %mask)
  ret void
}
define void @test_scatter_16i64(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x i64> %src0)  {
; X64-KNL-LABEL: test_scatter_16i64:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vpscatterqq %zmm3, (,%zmm0) {%k1}
; X64-KNL-NEXT:    vpscatterqq %zmm4, (,%zmm1) {%k2}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_scatter_16i64:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    pushl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_offset 8
; X86-KNL-NEXT:    .cfi_offset %ebp, -8
; X86-KNL-NEXT:    movl %esp, %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_register %ebp
; X86-KNL-NEXT:    andl $-64, %esp
; X86-KNL-NEXT:    subl $64, %esp
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vmovdqa64 8(%ebp), %zmm1
; X86-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X86-KNL-NEXT:    vpscatterdq %zmm2, (,%ymm0) {%k1}
; X86-KNL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; X86-KNL-NEXT:    vpscatterdq %zmm1, (,%ymm0) {%k2}
; X86-KNL-NEXT:    movl %ebp, %esp
; X86-KNL-NEXT:    popl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa %esp, 4
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_scatter_16i64:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vpscatterqq %zmm3, (,%zmm0) {%k1}
; X64-SKX-NEXT:    vpscatterqq %zmm4, (,%zmm1) {%k2}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_scatter_16i64:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    pushl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_offset 8
; X86-SKX-NEXT:    .cfi_offset %ebp, -8
; X86-SKX-NEXT:    movl %esp, %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_register %ebp
; X86-SKX-NEXT:    andl $-64, %esp
; X86-SKX-NEXT:    subl $64, %esp
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vmovdqa64 8(%ebp), %zmm1
; X86-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X86-SKX-NEXT:    vpscatterdq %zmm2, (,%ymm0) {%k1}
; X86-SKX-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; X86-SKX-NEXT:    vpscatterdq %zmm1, (,%ymm0) {%k2}
; X86-SKX-NEXT:    movl %ebp, %esp
; X86-SKX-NEXT:    popl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa %esp, 4
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  call void @llvm.masked.scatter.v16i64.v16p0(<16 x i64> %src0, <16 x ptr> %ptrs, i32 4, <16 x i1> %mask)
  ret void
}
declare void @llvm.masked.scatter.v16i64.v16p0(<16 x i64> %src0, <16 x ptr> %ptrs, i32, <16 x i1> %mask)
define void @test_scatter_16f32(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x float> %src0)  {
; X64-KNL-LABEL: test_scatter_16f32:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vscatterqps %ymm3, (,%zmm0) {%k1}
; X64-KNL-NEXT:    vextractf64x4 $1, %zmm3, %ymm0
; X64-KNL-NEXT:    vscatterqps %ymm0, (,%zmm1) {%k2}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_scatter_16f32:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vscatterdps %zmm2, (,%zmm0) {%k1}
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_scatter_16f32:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vscatterqps %ymm3, (,%zmm0) {%k1}
; X64-SKX-NEXT:    vextractf64x4 $1, %zmm3, %ymm0
; X64-SKX-NEXT:    vscatterqps %ymm0, (,%zmm1) {%k2}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_scatter_16f32:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vscatterdps %zmm2, (,%zmm0) {%k1}
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  call void @llvm.masked.scatter.v16f32.v16p0(<16 x float> %src0, <16 x ptr> %ptrs, i32 4, <16 x i1> %mask)
  ret void
}
declare void @llvm.masked.scatter.v16f32.v16p0(<16 x float> %src0, <16 x ptr> %ptrs, i32, <16 x i1> %mask)
define void @test_scatter_16f64(<16 x ptr> %ptrs, <16 x i1> %mask, <16 x double> %src0)  {
; X64-KNL-LABEL: test_scatter_16f64:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-KNL-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-KNL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; X64-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X64-KNL-NEXT:    vscatterqpd %zmm3, (,%zmm0) {%k1}
; X64-KNL-NEXT:    vscatterqpd %zmm4, (,%zmm1) {%k2}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_scatter_16f64:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    pushl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_offset 8
; X86-KNL-NEXT:    .cfi_offset %ebp, -8
; X86-KNL-NEXT:    movl %esp, %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_register %ebp
; X86-KNL-NEXT:    andl $-64, %esp
; X86-KNL-NEXT:    subl $64, %esp
; X86-KNL-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-KNL-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; X86-KNL-NEXT:    vmovapd 8(%ebp), %zmm1
; X86-KNL-NEXT:    kshiftrw $8, %k1, %k2
; X86-KNL-NEXT:    vscatterdpd %zmm2, (,%ymm0) {%k1}
; X86-KNL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-KNL-NEXT:    vscatterdpd %zmm1, (,%ymm0) {%k2}
; X86-KNL-NEXT:    movl %ebp, %esp
; X86-KNL-NEXT:    popl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa %esp, 4
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_scatter_16f64:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm2, %zmm2
; X64-SKX-NEXT:    vpslld $31, %zmm2, %zmm2
; X64-SKX-NEXT:    vpmovd2m %zmm2, %k1
; X64-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X64-SKX-NEXT:    vscatterqpd %zmm3, (,%zmm0) {%k1}
; X64-SKX-NEXT:    vscatterqpd %zmm4, (,%zmm1) {%k2}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_scatter_16f64:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    pushl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_offset 8
; X86-SKX-NEXT:    .cfi_offset %ebp, -8
; X86-SKX-NEXT:    movl %esp, %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_register %ebp
; X86-SKX-NEXT:    andl $-64, %esp
; X86-SKX-NEXT:    subl $64, %esp
; X86-SKX-NEXT:    vpmovsxbd %xmm1, %zmm1
; X86-SKX-NEXT:    vpslld $31, %zmm1, %zmm1
; X86-SKX-NEXT:    vpmovd2m %zmm1, %k1
; X86-SKX-NEXT:    vmovapd 8(%ebp), %zmm1
; X86-SKX-NEXT:    kshiftrw $8, %k1, %k2
; X86-SKX-NEXT:    vscatterdpd %zmm2, (,%ymm0) {%k1}
; X86-SKX-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-SKX-NEXT:    vscatterdpd %zmm1, (,%ymm0) {%k2}
; X86-SKX-NEXT:    movl %ebp, %esp
; X86-SKX-NEXT:    popl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa %esp, 4
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  call void @llvm.masked.scatter.v16f64.v16p0(<16 x double> %src0, <16 x ptr> %ptrs, i32 4, <16 x i1> %mask)
  ret void
}
declare void @llvm.masked.scatter.v16f64.v16p0(<16 x double> %src0, <16 x ptr> %ptrs, i32, <16 x i1> %mask)

define <4 x i64> @test_pr28312(<4 x ptr> %p1, <4 x i1> %k, <4 x i1> %k2,<4 x i64> %d) {
; X64-KNL-LABEL: test_pr28312:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    # implicit-def: $ymm1
; X64-KNL-NEXT:    je .LBB42_2
; X64-KNL-NEXT:  # %bb.1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X64-KNL-NEXT:  .LBB42_2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB42_4
; X64-KNL-NEXT:  # %bb.3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrq $1, (%rcx), %xmm1, %xmm2
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; X64-KNL-NEXT:  .LBB42_4: # %else2
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    vextracti128 $1, %ymm0, %xmm2
; X64-KNL-NEXT:    je .LBB42_6
; X64-KNL-NEXT:  # %bb.5: # %cond.load4
; X64-KNL-NEXT:    vmovq %xmm2, %rcx
; X64-KNL-NEXT:    vpbroadcastq (%rcx), %ymm3
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; X64-KNL-NEXT:  .LBB42_6: # %else5
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB42_8
; X64-KNL-NEXT:  # %bb.7: # %cond.load7
; X64-KNL-NEXT:    vpextrq $1, %xmm2, %rax
; X64-KNL-NEXT:    vpbroadcastq (%rax), %ymm3
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; X64-KNL-NEXT:  .LBB42_8: # %else8
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    # implicit-def: $ymm3
; X64-KNL-NEXT:    jne .LBB42_9
; X64-KNL-NEXT:  # %bb.10: # %else15
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB42_11
; X64-KNL-NEXT:  .LBB42_12: # %else21
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    jne .LBB42_13
; X64-KNL-NEXT:  .LBB42_14: # %else27
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB42_16
; X64-KNL-NEXT:  .LBB42_15: # %cond.load29
; X64-KNL-NEXT:    vpextrq $1, %xmm2, %rax
; X64-KNL-NEXT:    vpbroadcastq (%rax), %ymm4
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; X64-KNL-NEXT:  .LBB42_16: # %else33
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    # implicit-def: $ymm4
; X64-KNL-NEXT:    jne .LBB42_17
; X64-KNL-NEXT:  # %bb.18: # %else40
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB42_19
; X64-KNL-NEXT:  .LBB42_20: # %else46
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    jne .LBB42_21
; X64-KNL-NEXT:  .LBB42_22: # %else52
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB42_24
; X64-KNL-NEXT:  .LBB42_23: # %cond.load54
; X64-KNL-NEXT:    vpextrq $1, %xmm2, %rax
; X64-KNL-NEXT:    vpbroadcastq (%rax), %ymm0
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm0[6,7]
; X64-KNL-NEXT:  .LBB42_24: # %else58
; X64-KNL-NEXT:    vpaddq %ymm3, %ymm1, %ymm0
; X64-KNL-NEXT:    vpaddq %ymm4, %ymm0, %ymm0
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB42_9: # %cond.load11
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB42_12
; X64-KNL-NEXT:  .LBB42_11: # %cond.load17
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrq $1, (%rcx), %xmm3, %xmm4
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    je .LBB42_14
; X64-KNL-NEXT:  .LBB42_13: # %cond.load23
; X64-KNL-NEXT:    vmovq %xmm2, %rcx
; X64-KNL-NEXT:    vpbroadcastq (%rcx), %ymm4
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB42_15
; X64-KNL-NEXT:    jmp .LBB42_16
; X64-KNL-NEXT:  .LBB42_17: # %cond.load36
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB42_20
; X64-KNL-NEXT:  .LBB42_19: # %cond.load42
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrq $1, (%rcx), %xmm4, %xmm0
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm4 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    je .LBB42_22
; X64-KNL-NEXT:  .LBB42_21: # %cond.load48
; X64-KNL-NEXT:    vmovq %xmm2, %rcx
; X64-KNL-NEXT:    vpbroadcastq (%rcx), %ymm0
; X64-KNL-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm0[4,5],ymm4[6,7]
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB42_23
; X64-KNL-NEXT:    jmp .LBB42_24
;
; X86-KNL-LABEL: test_pr28312:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    pushl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_offset 8
; X86-KNL-NEXT:    .cfi_offset %ebp, -8
; X86-KNL-NEXT:    movl %esp, %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_register %ebp
; X86-KNL-NEXT:    pushl %ebx
; X86-KNL-NEXT:    pushl %esi
; X86-KNL-NEXT:    andl $-32, %esp
; X86-KNL-NEXT:    subl $32, %esp
; X86-KNL-NEXT:    .cfi_offset %esi, -16
; X86-KNL-NEXT:    .cfi_offset %ebx, -12
; X86-KNL-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-KNL-NEXT:    vptestmd %zmm1, %zmm1, %k0
; X86-KNL-NEXT:    kmovw %k0, %ebx
; X86-KNL-NEXT:    testb $1, %bl
; X86-KNL-NEXT:    vmovd %xmm0, %eax
; X86-KNL-NEXT:    # implicit-def: $ymm1
; X86-KNL-NEXT:    je .LBB42_2
; X86-KNL-NEXT:  # %bb.1: # %cond.load
; X86-KNL-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86-KNL-NEXT:  .LBB42_2: # %else
; X86-KNL-NEXT:    testb $2, %bl
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-KNL-NEXT:    je .LBB42_4
; X86-KNL-NEXT:  # %bb.3: # %cond.load1
; X86-KNL-NEXT:    vpinsrd $2, (%ecx), %xmm1, %xmm2
; X86-KNL-NEXT:    vpinsrd $3, 4(%ecx), %xmm2, %xmm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; X86-KNL-NEXT:  .LBB42_4: # %else2
; X86-KNL-NEXT:    testb $4, %bl
; X86-KNL-NEXT:    vpextrd $2, %xmm0, %edx
; X86-KNL-NEXT:    je .LBB42_6
; X86-KNL-NEXT:  # %bb.5: # %cond.load4
; X86-KNL-NEXT:    vpbroadcastd (%edx), %ymm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4],ymm1[5,6,7]
; X86-KNL-NEXT:    vpbroadcastd 4(%edx), %ymm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5],ymm1[6,7]
; X86-KNL-NEXT:  .LBB42_6: # %else5
; X86-KNL-NEXT:    testb $8, %bl
; X86-KNL-NEXT:    vpextrd $3, %xmm0, %esi
; X86-KNL-NEXT:    je .LBB42_8
; X86-KNL-NEXT:  # %bb.7: # %cond.load7
; X86-KNL-NEXT:    vpbroadcastd (%esi), %ymm0
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6],ymm1[7]
; X86-KNL-NEXT:    vpbroadcastd 4(%esi), %ymm1
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0,1,2,3,4,5,6],ymm1[7]
; X86-KNL-NEXT:  .LBB42_8: # %else8
; X86-KNL-NEXT:    kmovw %k0, %ebx
; X86-KNL-NEXT:    testb $1, %bl
; X86-KNL-NEXT:    # implicit-def: $ymm0
; X86-KNL-NEXT:    jne .LBB42_9
; X86-KNL-NEXT:  # %bb.10: # %else15
; X86-KNL-NEXT:    testb $2, %bl
; X86-KNL-NEXT:    jne .LBB42_11
; X86-KNL-NEXT:  .LBB42_12: # %else21
; X86-KNL-NEXT:    testb $4, %bl
; X86-KNL-NEXT:    jne .LBB42_13
; X86-KNL-NEXT:  .LBB42_14: # %else27
; X86-KNL-NEXT:    testb $8, %bl
; X86-KNL-NEXT:    je .LBB42_16
; X86-KNL-NEXT:  .LBB42_15: # %cond.load29
; X86-KNL-NEXT:    vpbroadcastd (%esi), %ymm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6],ymm0[7]
; X86-KNL-NEXT:    vpbroadcastd 4(%esi), %ymm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm2[7]
; X86-KNL-NEXT:  .LBB42_16: # %else33
; X86-KNL-NEXT:    kmovw %k0, %ebx
; X86-KNL-NEXT:    testb $1, %bl
; X86-KNL-NEXT:    # implicit-def: $ymm2
; X86-KNL-NEXT:    jne .LBB42_17
; X86-KNL-NEXT:  # %bb.18: # %else40
; X86-KNL-NEXT:    testb $2, %bl
; X86-KNL-NEXT:    jne .LBB42_19
; X86-KNL-NEXT:  .LBB42_20: # %else46
; X86-KNL-NEXT:    testb $4, %bl
; X86-KNL-NEXT:    jne .LBB42_21
; X86-KNL-NEXT:  .LBB42_22: # %else52
; X86-KNL-NEXT:    testb $8, %bl
; X86-KNL-NEXT:    je .LBB42_24
; X86-KNL-NEXT:  .LBB42_23: # %cond.load54
; X86-KNL-NEXT:    vpbroadcastd (%esi), %ymm3
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6],ymm2[7]
; X86-KNL-NEXT:    vpbroadcastd 4(%esi), %ymm3
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm3[7]
; X86-KNL-NEXT:  .LBB42_24: # %else58
; X86-KNL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X86-KNL-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; X86-KNL-NEXT:    leal -8(%ebp), %esp
; X86-KNL-NEXT:    popl %esi
; X86-KNL-NEXT:    popl %ebx
; X86-KNL-NEXT:    popl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa %esp, 4
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB42_9: # %cond.load11
; X86-KNL-NEXT:    .cfi_def_cfa %ebp, 8
; X86-KNL-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X86-KNL-NEXT:    testb $2, %bl
; X86-KNL-NEXT:    je .LBB42_12
; X86-KNL-NEXT:  .LBB42_11: # %cond.load17
; X86-KNL-NEXT:    vpinsrd $2, (%ecx), %xmm0, %xmm2
; X86-KNL-NEXT:    vpinsrd $3, 4(%ecx), %xmm2, %xmm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; X86-KNL-NEXT:    testb $4, %bl
; X86-KNL-NEXT:    je .LBB42_14
; X86-KNL-NEXT:  .LBB42_13: # %cond.load23
; X86-KNL-NEXT:    vpbroadcastd (%edx), %ymm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4],ymm0[5,6,7]
; X86-KNL-NEXT:    vpbroadcastd 4(%edx), %ymm2
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5],ymm0[6,7]
; X86-KNL-NEXT:    testb $8, %bl
; X86-KNL-NEXT:    jne .LBB42_15
; X86-KNL-NEXT:    jmp .LBB42_16
; X86-KNL-NEXT:  .LBB42_17: # %cond.load36
; X86-KNL-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; X86-KNL-NEXT:    testb $2, %bl
; X86-KNL-NEXT:    je .LBB42_20
; X86-KNL-NEXT:  .LBB42_19: # %cond.load42
; X86-KNL-NEXT:    vpinsrd $2, (%ecx), %xmm2, %xmm3
; X86-KNL-NEXT:    vpinsrd $3, 4(%ecx), %xmm3, %xmm3
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; X86-KNL-NEXT:    testb $4, %bl
; X86-KNL-NEXT:    je .LBB42_22
; X86-KNL-NEXT:  .LBB42_21: # %cond.load48
; X86-KNL-NEXT:    vpbroadcastd (%edx), %ymm3
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4],ymm2[5,6,7]
; X86-KNL-NEXT:    vpbroadcastd 4(%edx), %ymm3
; X86-KNL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm3[5],ymm2[6,7]
; X86-KNL-NEXT:    testb $8, %bl
; X86-KNL-NEXT:    jne .LBB42_23
; X86-KNL-NEXT:    jmp .LBB42_24
;
; X64-SKX-LABEL: test_pr28312:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X64-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X64-SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-SKX-NEXT:    vpgatherqq (,%ymm0), %ymm1 {%k1}
; X64-SKX-NEXT:    vpaddq %ymm1, %ymm1, %ymm0
; X64-SKX-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_pr28312:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    pushl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_offset 8
; X86-SKX-NEXT:    .cfi_offset %ebp, -8
; X86-SKX-NEXT:    movl %esp, %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_register %ebp
; X86-SKX-NEXT:    andl $-32, %esp
; X86-SKX-NEXT:    subl $32, %esp
; X86-SKX-NEXT:    vpslld $31, %xmm1, %xmm1
; X86-SKX-NEXT:    vpmovd2m %xmm1, %k1
; X86-SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-SKX-NEXT:    vpgatherdq (,%xmm0), %ymm1 {%k1}
; X86-SKX-NEXT:    vpaddq %ymm1, %ymm1, %ymm0
; X86-SKX-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X86-SKX-NEXT:    movl %ebp, %esp
; X86-SKX-NEXT:    popl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa %esp, 4
; X86-SKX-NEXT:    retl
  %g1 = call <4 x i64> @llvm.masked.gather.v4i64.v4p0(<4 x ptr> %p1, i32 8, <4 x i1> %k, <4 x i64> undef)
  %g2 = call <4 x i64> @llvm.masked.gather.v4i64.v4p0(<4 x ptr> %p1, i32 8, <4 x i1> %k, <4 x i64> undef)
  %g3 = call <4 x i64> @llvm.masked.gather.v4i64.v4p0(<4 x ptr> %p1, i32 8, <4 x i1> %k, <4 x i64> undef)
  %a = add <4 x i64> %g1, %g2
  %b = add <4 x i64> %a, %g3
  ret <4 x i64> %b
}
declare <4 x i64> @llvm.masked.gather.v4i64.v4p0(<4 x ptr>, i32, <4 x i1>, <4 x i64>)

define <8 x i32> @test_global_array(<8 x i64> %indxs) {
; X64-KNL-LABEL: test_global_array:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    kxnorw %k0, %k0, %k1
; X64-KNL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-KNL-NEXT:    vpgatherqd glob_array(,%zmm0,4), %ymm1 {%k1}
; X64-KNL-NEXT:    vmovdqa %ymm1, %ymm0
; X64-KNL-NEXT:    retq
;
; X86-LABEL: test_global_array:
; X86:       # %bb.0:
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-NEXT:    vpgatherqd glob_array(,%zmm0,4), %ymm1 {%k1}
; X86-NEXT:    vmovdqa %ymm1, %ymm0
; X86-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_global_array:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-SMALL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-SKX-SMALL-NEXT:    vpgatherqd glob_array(,%zmm0,4), %ymm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovdqa %ymm1, %ymm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_global_array:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    movabsq $glob_array, %rax
; X64-SKX-LARGE-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-LARGE-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-SKX-LARGE-NEXT:    vpgatherqd (%rax,%zmm0,4), %ymm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovdqa %ymm1, %ymm0
; X64-SKX-LARGE-NEXT:    retq
  %p = getelementptr inbounds [16 x i32], ptr @glob_array, i64 0, <8 x i64> %indxs
  %g = call <8 x i32> @llvm.masked.gather.v8i32.v8p0(<8 x ptr> %p, i32 8, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x i32> undef)
  ret <8 x i32> %g
}

define <8 x i32> @test_global_array_zeroinitializer_index(<8 x i64> %indxs) {
; X64-KNL-LABEL: test_global_array_zeroinitializer_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    kxnorw %k0, %k0, %k1
; X64-KNL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-KNL-NEXT:    vpgatherqd glob_array(,%zmm0,4), %ymm1 {%k1}
; X64-KNL-NEXT:    vmovdqa %ymm1, %ymm0
; X64-KNL-NEXT:    retq
;
; X86-LABEL: test_global_array_zeroinitializer_index:
; X86:       # %bb.0:
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-NEXT:    vpgatherqd glob_array(,%zmm0,4), %ymm1 {%k1}
; X86-NEXT:    vmovdqa %ymm1, %ymm0
; X86-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_global_array_zeroinitializer_index:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-SMALL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-SKX-SMALL-NEXT:    vpgatherqd glob_array(,%zmm0,4), %ymm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovdqa %ymm1, %ymm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_global_array_zeroinitializer_index:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    movabsq $glob_array, %rax
; X64-SKX-LARGE-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-LARGE-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-SKX-LARGE-NEXT:    vpgatherqd (%rax,%zmm0,4), %ymm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovdqa %ymm1, %ymm0
; X64-SKX-LARGE-NEXT:    retq
  %p = getelementptr inbounds [16 x i32], ptr @glob_array, <8 x i64> zeroinitializer, <8 x i64> %indxs
  %g = call <8 x i32> @llvm.masked.gather.v8i32.v8p0(<8 x ptr> %p, i32 8, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x i32> undef)
  ret <8 x i32> %g
}

define void @v1_scatter(<1 x i32>%a1, <1 x ptr> %ptr, <1 x i1> %mask) {
; X64-LABEL: v1_scatter:
; X64:       # %bb.0:
; X64-NEXT:    testb $1, %dl
; X64-NEXT:    je .LBB45_2
; X64-NEXT:  # %bb.1: # %cond.store
; X64-NEXT:    movl %edi, (%rsi)
; X64-NEXT:  .LBB45_2: # %else
; X64-NEXT:    retq
;
; X86-LABEL: v1_scatter:
; X86:       # %bb.0:
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB45_2
; X86-NEXT:  # %bb.1: # %cond.store
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:  .LBB45_2: # %else
; X86-NEXT:    retl
  call void @llvm.masked.scatter.v1i32.v1p0(<1 x i32> %a1, <1 x ptr> %ptr, i32 4, <1 x i1> %mask)
  ret void
}
declare void @llvm.masked.scatter.v1i32.v1p0(<1 x i32>, <1 x ptr>, i32, <1 x i1>)

define <1 x i32> @v1_gather(<1 x ptr> %ptr, <1 x i1> %mask, <1 x i32> %src0) {
; X64-LABEL: v1_gather:
; X64:       # %bb.0:
; X64-NEXT:    movl (%rdi), %eax
; X64-NEXT:    retq
;
; X86-LABEL: v1_gather:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    retl
  %res = call <1 x i32> @llvm.masked.gather.v1i32.v1p0(<1 x ptr> %ptr, i32 4, <1 x i1> <i1 true>, <1 x i32> %src0)
  ret <1 x i32>%res
}
declare <1 x i32> @llvm.masked.gather.v1i32.v1p0(<1 x ptr>, i32, <1 x i1>, <1 x i32>)

; Make sure we don't crash when the index element type is larger than i64 and we need to widen the result
; This experienced a bad interaction when we widened and then tried to split.
define <2 x float> @large_index(ptr %base, <2 x i128> %ind, <2 x i1> %mask, <2 x float> %src0) {
; X64-KNL-LABEL: large_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k0
; X64-KNL-NEXT:    vmovq %rcx, %xmm0
; X64-KNL-NEXT:    vmovq %rsi, %xmm2
; X64-KNL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; X64-KNL-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-KNL-NEXT:    vmovq %rdi, %xmm2
; X64-KNL-NEXT:    vpbroadcastq %xmm2, %xmm2
; X64-KNL-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB47_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB47_3
; X64-KNL-NEXT:  .LBB47_4: # %else2
; X64-KNL-NEXT:    vmovdqa %xmm1, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB47_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X64-KNL-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3]
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB47_4
; X64-KNL-NEXT:  .LBB47_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; X64-KNL-NEXT:    vmovaps %xmm1, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: large_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X86-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k0
; X86-KNL-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-KNL-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm2
; X86-KNL-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB47_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB47_3
; X86-KNL-NEXT:  .LBB47_4: # %else2
; X86-KNL-NEXT:    vmovdqa %xmm1, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB47_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-KNL-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3]
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB47_4
; X86-KNL-NEXT:  .LBB47_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; X86-KNL-NEXT:    vmovaps %xmm1, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: large_index:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-SKX-NEXT:    vpmovq2m %xmm0, %k0
; X64-SKX-NEXT:    vmovq %rcx, %xmm0
; X64-SKX-NEXT:    vmovq %rsi, %xmm2
; X64-SKX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; X64-SKX-NEXT:    vpsllq $2, %xmm0, %xmm0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm2
; X64-SKX-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB47_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB47_3
; X64-SKX-NEXT:  .LBB47_4: # %else2
; X64-SKX-NEXT:    vmovdqa %xmm1, %xmm0
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB47_1: # %cond.load
; X64-SKX-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X64-SKX-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3]
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB47_4
; X64-SKX-NEXT:  .LBB47_3: # %cond.load1
; X64-SKX-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; X64-SKX-NEXT:    vmovaps %xmm1, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: large_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm0, %xmm0
; X86-SKX-NEXT:    vpmovq2m %xmm0, %k0
; X86-SKX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SKX-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-SKX-NEXT:    vpslld $2, %xmm0, %xmm0
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB47_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB47_3
; X86-SKX-NEXT:  .LBB47_4: # %else2
; X86-SKX-NEXT:    vmovaps %xmm1, %xmm0
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB47_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-SKX-NEXT:    vmovss {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3]
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB47_4
; X86-SKX-NEXT:  .LBB47_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; X86-SKX-NEXT:    vmovaps %xmm1, %xmm0
; X86-SKX-NEXT:    retl
  %gep.random = getelementptr float, ptr %base, <2 x i128> %ind
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep.random, i32 4, <2 x i1> %mask, <2 x float> %src0)
  ret <2 x float>%res
}

; Make sure we allow index to be sign extended from a smaller than i32 element size.
define <16 x float> @sext_i8_index(ptr %base, <16 x i8> %ind) {
; X64-LABEL: sext_i8_index:
; X64:       # %bb.0:
; X64-NEXT:    vpmovsxbd %xmm0, %zmm1
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-NEXT:    vgatherdps (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-NEXT:    retq
;
; X86-LABEL: sext_i8_index:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovsxbd %xmm0, %zmm1
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-NEXT:    retl
  %sext_ind = sext <16 x i8> %ind to <16 x i64>
  %gep.random = getelementptr float, ptr%base, <16 x i64> %sext_ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

; Make sure we allow index to be sign extended from a smaller than i32 element size.
define <8 x float> @sext_v8i8_index(ptr %base, <8 x i8> %ind) {
; X64-KNL-LABEL: sext_v8i8_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %ymm1
; X64-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-KNL-NEXT:    movw $255, %ax
; X64-KNL-NEXT:    kmovw %eax, %k1
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: sext_v8i8_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %ymm1
; X86-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-KNL-NEXT:    movw $255, %cx
; X86-KNL-NEXT:    kmovw %ecx, %k1
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: sext_v8i8_index:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovsxbd %xmm0, %ymm1
; X64-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-NEXT:    vgatherdps (%rdi,%ymm1,4), %ymm0 {%k1}
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: sext_v8i8_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %ymm1
; X86-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vgatherdps (%eax,%ymm1,4), %ymm0 {%k1}
; X86-SKX-NEXT:    retl
  %sext_ind = sext <8 x i8> %ind to <8 x i64>
  %gep.random = getelementptr float, ptr%base, <8 x i64> %sext_ind

  %res = call <8 x float> @llvm.masked.gather.v8f32.v8p0(<8 x ptr> %gep.random, i32 4, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x float> undef)
  ret <8 x float>%res
}
declare <8 x float> @llvm.masked.gather.v8f32.v8p0(<8 x ptr>, i32, <8 x i1>, <8 x float>)

; Make sure we also allow index to be zero extended from a smaller than i32 element size.
define <16 x float> @zext_i8_index(ptr %base, <16 x i8> %ind) {
; X64-LABEL: zext_i8_index:
; X64:       # %bb.0:
; X64-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-NEXT:    vgatherdps (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-NEXT:    retq
;
; X86-LABEL: zext_i8_index:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-NEXT:    retl
  %zext_ind = zext <16 x i8> %ind to <16 x i64>
  %gep.random = getelementptr float, ptr%base, <16 x i64> %zext_ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

; Make sure we also allow index to be zero extended from a smaller than i32 element size.
define <8 x float> @zext_v8i8_index(ptr %base, <8 x i8> %ind) {
; X64-KNL-LABEL: zext_v8i8_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovzxbd {{.*#+}} ymm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; X64-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-KNL-NEXT:    movw $255, %ax
; X64-KNL-NEXT:    kmovw %eax, %k1
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: zext_v8i8_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    vpmovzxbd {{.*#+}} ymm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; X86-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-KNL-NEXT:    movw $255, %cx
; X86-KNL-NEXT:    kmovw %ecx, %k1
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: zext_v8i8_index:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpmovzxbd {{.*#+}} ymm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; X64-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-NEXT:    vgatherdps (%rdi,%ymm1,4), %ymm0 {%k1}
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: zext_v8i8_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vpmovzxbd {{.*#+}} ymm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; X86-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vgatherdps (%eax,%ymm1,4), %ymm0 {%k1}
; X86-SKX-NEXT:    retl
  %zext_ind = zext <8 x i8> %ind to <8 x i64>
  %gep.random = getelementptr float, ptr%base, <8 x i64> %zext_ind

  %res = call <8 x float> @llvm.masked.gather.v8f32.v8p0(<8 x ptr> %gep.random, i32 4, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x float> undef)
  ret <8 x float>%res
}

; Index requires promotion
define void @test_scatter_2i32_index(<2 x double> %a1, ptr %base, <2 x i32> %ind, <2 x i1> %mask) {
; X64-KNL-LABEL: test_scatter_2i32_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm2, %xmm2
; X64-KNL-NEXT:    vptestmq %zmm2, %zmm2, %k0
; X64-KNL-NEXT:    vpmovsxdq %xmm1, %xmm1
; X64-KNL-NEXT:    vpsllq $3, %xmm1, %xmm1
; X64-KNL-NEXT:    vmovq %rdi, %xmm2
; X64-KNL-NEXT:    vpbroadcastq %xmm2, %xmm2
; X64-KNL-NEXT:    vpaddq %xmm1, %xmm2, %xmm1
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB52_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB52_3
; X64-KNL-NEXT:  .LBB52_4: # %else2
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB52_1: # %cond.store
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovlps %xmm0, (%rcx)
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB52_4
; X64-KNL-NEXT:  .LBB52_3: # %cond.store1
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-KNL-NEXT:    vmovhps %xmm0, (%rax)
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_scatter_2i32_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm2, %xmm2
; X86-KNL-NEXT:    vptestmq %zmm2, %zmm2, %k0
; X86-KNL-NEXT:    vpslld $3, %xmm1, %xmm1
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm2
; X86-KNL-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB52_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB52_3
; X86-KNL-NEXT:  .LBB52_4: # %else2
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB52_1: # %cond.store
; X86-KNL-NEXT:    vmovd %xmm1, %ecx
; X86-KNL-NEXT:    vmovlps %xmm0, (%ecx)
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB52_4
; X86-KNL-NEXT:  .LBB52_3: # %cond.store1
; X86-KNL-NEXT:    vpextrd $1, %xmm1, %eax
; X86-KNL-NEXT:    vmovhps %xmm0, (%eax)
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_scatter_2i32_index:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpsllq $63, %xmm2, %xmm2
; X64-SKX-NEXT:    vpmovq2m %xmm2, %k0
; X64-SKX-NEXT:    vpbroadcastq %rdi, %xmm2
; X64-SKX-NEXT:    vpmovsxdq %xmm1, %xmm1
; X64-SKX-NEXT:    vpsllq $3, %xmm1, %xmm1
; X64-SKX-NEXT:    vpaddq %xmm1, %xmm2, %xmm1
; X64-SKX-NEXT:    kmovw %k0, %eax
; X64-SKX-NEXT:    testb $1, %al
; X64-SKX-NEXT:    jne .LBB52_1
; X64-SKX-NEXT:  # %bb.2: # %else
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    jne .LBB52_3
; X64-SKX-NEXT:  .LBB52_4: # %else2
; X64-SKX-NEXT:    retq
; X64-SKX-NEXT:  .LBB52_1: # %cond.store
; X64-SKX-NEXT:    vmovq %xmm1, %rcx
; X64-SKX-NEXT:    vmovlps %xmm0, (%rcx)
; X64-SKX-NEXT:    testb $2, %al
; X64-SKX-NEXT:    je .LBB52_4
; X64-SKX-NEXT:  .LBB52_3: # %cond.store1
; X64-SKX-NEXT:    vpextrq $1, %xmm1, %rax
; X64-SKX-NEXT:    vmovhps %xmm0, (%rax)
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_scatter_2i32_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm2, %xmm2
; X86-SKX-NEXT:    vpmovq2m %xmm2, %k0
; X86-SKX-NEXT:    vpslld $3, %xmm1, %xmm1
; X86-SKX-NEXT:    vpaddd {{[0-9]+}}(%esp){1to4}, %xmm1, %xmm1
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB52_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB52_3
; X86-SKX-NEXT:  .LBB52_4: # %else2
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB52_1: # %cond.store
; X86-SKX-NEXT:    vmovd %xmm1, %ecx
; X86-SKX-NEXT:    vmovlps %xmm0, (%ecx)
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB52_4
; X86-SKX-NEXT:  .LBB52_3: # %cond.store1
; X86-SKX-NEXT:    vpextrd $1, %xmm1, %eax
; X86-SKX-NEXT:    vmovhps %xmm0, (%eax)
; X86-SKX-NEXT:    retl
  %gep = getelementptr double, ptr%base, <2 x i32> %ind
  call void @llvm.masked.scatter.v2f64.v2p0(<2 x double> %a1, <2 x ptr> %gep, i32 4, <2 x i1> %mask)
  ret void
}
declare void @llvm.masked.scatter.v2f64.v2p0(<2 x double>, <2 x ptr>, i32, <2 x i1>)

define <16 x float> @zext_index(ptr %base, <16 x i32> %ind) {
; X64-KNL-LABEL: zext_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm1
; X64-KNL-NEXT:    kxnorw %k0, %k0, %k1
; X64-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: zext_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm1
; X86-KNL-NEXT:    kxnorw %k0, %k0, %k1
; X86-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: zext_index:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm1
; X64-SKX-SMALL-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-SMALL-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    vgatherdps (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: zext_index:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vandps (%rax){1to16}, %zmm0, %zmm1
; X64-SKX-LARGE-NEXT:    kxnorw %k0, %k0, %k1
; X64-SKX-LARGE-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    vgatherdps (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: zext_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm1
; X86-SKX-NEXT:    kxnorw %k0, %k0, %k1
; X86-SKX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vgatherdps (%eax,%zmm1,4), %zmm0 {%k1}
; X86-SKX-NEXT:    retl
  %ind_masked = and <16 x i32> %ind, <i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15>
  %sext_ind = zext <16 x i32> %ind_masked to <16 x i64>
  %gep.random = getelementptr float, ptr%base, <16 x i64> %sext_ind

  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}

define <16 x double> @test_gather_setcc_split(ptr %base, <16 x i32> %ind, <16 x i32> %cmp, <16 x double> %passthru) {
; X64-KNL-LABEL: test_gather_setcc_split:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; X64-KNL-NEXT:    vptestnmd %zmm4, %zmm4, %k1
; X64-KNL-NEXT:    vptestnmd %zmm1, %zmm1, %k2
; X64-KNL-NEXT:    vgatherdpd (%rdi,%ymm0,8), %zmm2 {%k2}
; X64-KNL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X64-KNL-NEXT:    vgatherdpd (%rdi,%ymm0,8), %zmm3 {%k1}
; X64-KNL-NEXT:    vmovapd %zmm2, %zmm0
; X64-KNL-NEXT:    vmovapd %zmm3, %zmm1
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_setcc_split:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    pushl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_offset 8
; X86-KNL-NEXT:    .cfi_offset %ebp, -8
; X86-KNL-NEXT:    movl %esp, %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_register %ebp
; X86-KNL-NEXT:    andl $-64, %esp
; X86-KNL-NEXT:    subl $64, %esp
; X86-KNL-NEXT:    vmovdqa64 %zmm1, %zmm3
; X86-KNL-NEXT:    vmovapd 72(%ebp), %zmm1
; X86-KNL-NEXT:    movl 8(%ebp), %eax
; X86-KNL-NEXT:    vextracti64x4 $1, %zmm3, %ymm4
; X86-KNL-NEXT:    vptestnmd %zmm4, %zmm4, %k1
; X86-KNL-NEXT:    vptestnmd %zmm3, %zmm3, %k2
; X86-KNL-NEXT:    vgatherdpd (%eax,%ymm0,8), %zmm2 {%k2}
; X86-KNL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-KNL-NEXT:    vgatherdpd (%eax,%ymm0,8), %zmm1 {%k1}
; X86-KNL-NEXT:    vmovapd %zmm2, %zmm0
; X86-KNL-NEXT:    movl %ebp, %esp
; X86-KNL-NEXT:    popl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa %esp, 4
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_gather_setcc_split:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; X64-SKX-NEXT:    vptestnmd %ymm4, %ymm4, %k1
; X64-SKX-NEXT:    vptestnmd %ymm1, %ymm1, %k2
; X64-SKX-NEXT:    vgatherdpd (%rdi,%ymm0,8), %zmm2 {%k2}
; X64-SKX-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X64-SKX-NEXT:    vgatherdpd (%rdi,%ymm0,8), %zmm3 {%k1}
; X64-SKX-NEXT:    vmovapd %zmm2, %zmm0
; X64-SKX-NEXT:    vmovapd %zmm3, %zmm1
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_setcc_split:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    pushl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_offset 8
; X86-SKX-NEXT:    .cfi_offset %ebp, -8
; X86-SKX-NEXT:    movl %esp, %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_register %ebp
; X86-SKX-NEXT:    andl $-64, %esp
; X86-SKX-NEXT:    subl $64, %esp
; X86-SKX-NEXT:    vmovapd 72(%ebp), %zmm3
; X86-SKX-NEXT:    movl 8(%ebp), %eax
; X86-SKX-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; X86-SKX-NEXT:    vptestnmd %ymm4, %ymm4, %k1
; X86-SKX-NEXT:    vptestnmd %ymm1, %ymm1, %k2
; X86-SKX-NEXT:    vgatherdpd (%eax,%ymm0,8), %zmm2 {%k2}
; X86-SKX-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-SKX-NEXT:    vgatherdpd (%eax,%ymm0,8), %zmm3 {%k1}
; X86-SKX-NEXT:    vmovapd %zmm2, %zmm0
; X86-SKX-NEXT:    vmovapd %zmm3, %zmm1
; X86-SKX-NEXT:    movl %ebp, %esp
; X86-SKX-NEXT:    popl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa %esp, 4
; X86-SKX-NEXT:    retl
  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr double, ptr%base, <16 x i64> %sext_ind

  %mask = icmp eq <16 x i32> %cmp, zeroinitializer
  %res = call <16 x double> @llvm.masked.gather.v16f64.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> %mask, <16 x double> %passthru)
  ret <16 x double>%res
}

define void @test_scatter_setcc_split(ptr %base, <16 x i32> %ind, <16 x i32> %cmp, <16 x double> %src0)  {
; X64-KNL-LABEL: test_scatter_setcc_split:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; X64-KNL-NEXT:    vptestnmd %zmm4, %zmm4, %k1
; X64-KNL-NEXT:    vptestnmd %zmm1, %zmm1, %k2
; X64-KNL-NEXT:    vscatterdpd %zmm2, (%rdi,%ymm0,8) {%k2}
; X64-KNL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X64-KNL-NEXT:    vscatterdpd %zmm3, (%rdi,%ymm0,8) {%k1}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_scatter_setcc_split:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    pushl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_offset 8
; X86-KNL-NEXT:    .cfi_offset %ebp, -8
; X86-KNL-NEXT:    movl %esp, %ebp
; X86-KNL-NEXT:    .cfi_def_cfa_register %ebp
; X86-KNL-NEXT:    andl $-64, %esp
; X86-KNL-NEXT:    subl $64, %esp
; X86-KNL-NEXT:    vmovapd 72(%ebp), %zmm3
; X86-KNL-NEXT:    movl 8(%ebp), %eax
; X86-KNL-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; X86-KNL-NEXT:    vptestnmd %zmm4, %zmm4, %k1
; X86-KNL-NEXT:    vptestnmd %zmm1, %zmm1, %k2
; X86-KNL-NEXT:    vscatterdpd %zmm2, (%eax,%ymm0,8) {%k2}
; X86-KNL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-KNL-NEXT:    vscatterdpd %zmm3, (%eax,%ymm0,8) {%k1}
; X86-KNL-NEXT:    movl %ebp, %esp
; X86-KNL-NEXT:    popl %ebp
; X86-KNL-NEXT:    .cfi_def_cfa %esp, 4
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: test_scatter_setcc_split:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; X64-SKX-NEXT:    vptestnmd %ymm4, %ymm4, %k1
; X64-SKX-NEXT:    vptestnmd %ymm1, %ymm1, %k2
; X64-SKX-NEXT:    vscatterdpd %zmm2, (%rdi,%ymm0,8) {%k2}
; X64-SKX-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X64-SKX-NEXT:    vscatterdpd %zmm3, (%rdi,%ymm0,8) {%k1}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: test_scatter_setcc_split:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    pushl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_offset 8
; X86-SKX-NEXT:    .cfi_offset %ebp, -8
; X86-SKX-NEXT:    movl %esp, %ebp
; X86-SKX-NEXT:    .cfi_def_cfa_register %ebp
; X86-SKX-NEXT:    andl $-64, %esp
; X86-SKX-NEXT:    subl $64, %esp
; X86-SKX-NEXT:    vmovapd 72(%ebp), %zmm3
; X86-SKX-NEXT:    movl 8(%ebp), %eax
; X86-SKX-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; X86-SKX-NEXT:    vptestnmd %ymm4, %ymm4, %k1
; X86-SKX-NEXT:    vptestnmd %ymm1, %ymm1, %k2
; X86-SKX-NEXT:    vscatterdpd %zmm2, (%eax,%ymm0,8) {%k2}
; X86-SKX-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; X86-SKX-NEXT:    vscatterdpd %zmm3, (%eax,%ymm0,8) {%k1}
; X86-SKX-NEXT:    movl %ebp, %esp
; X86-SKX-NEXT:    popl %ebp
; X86-SKX-NEXT:    .cfi_def_cfa %esp, 4
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr double, ptr%base, <16 x i64> %sext_ind

  %mask = icmp eq <16 x i32> %cmp, zeroinitializer
  call void @llvm.masked.scatter.v16f64.v16p0(<16 x double> %src0, <16 x ptr> %gep.random, i32 4, <16 x i1> %mask)
  ret void
}

; This test case previously triggered an infinite loop when the two gathers became identical after DAG combine removed the sign extend.
define <16 x float> @test_sext_cse(ptr %base, <16 x i32> %ind, ptr %foo) {
; X64-LABEL: test_sext_cse:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps %zmm0, (%rsi)
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-NEXT:    vgatherdps (%rdi,%zmm0,4), %zmm1 {%k1}
; X64-NEXT:    vaddps %zmm1, %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: test_sext_cse:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovaps %zmm0, (%ecx)
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X86-NEXT:    vgatherdps (%eax,%zmm0,4), %zmm1 {%k1}
; X86-NEXT:    vaddps %zmm1, %zmm1, %zmm0
; X86-NEXT:    retl
  %broadcast.splatinsert = insertelement <16 x ptr> undef, ptr %base, i32 0
  %broadcast.splat = shufflevector <16 x ptr> %broadcast.splatinsert, <16 x ptr> undef, <16 x i32> zeroinitializer

  %sext_ind = sext <16 x i32> %ind to <16 x i64>
  %gep.random = getelementptr float, <16 x ptr> %broadcast.splat, <16 x i64> %sext_ind

  store <16 x i32> %ind, ptr %foo
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  %gep.random2 = getelementptr float, <16 x ptr> %broadcast.splat, <16 x i32> %ind
  %res2 = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %gep.random2, i32 4, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  %res3 = fadd <16 x float> %res2, %res
  ret <16 x float>%res3
}

define void @zero_mask(<2 x double>%a1, <2 x ptr> %ptr) {
; ALL-LABEL: zero_mask:
; ALL:       # %bb.0:
; ALL-NEXT:    ret{{[l|q]}}
  call void @llvm.masked.scatter.v2f64.v2p0(<2 x double> %a1, <2 x ptr> %ptr, i32 4, <2 x i1> zeroinitializer)
  ret void
}

define <2 x i64> @gather_2i64_constant_indices(ptr %ptr, <2 x i1> %mask) {
; X64-KNL-LABEL: gather_2i64_constant_indices:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k0
; X64-KNL-NEXT:    vmovq %rdi, %xmm0
; X64-KNL-NEXT:    vpbroadcastq %xmm0, %xmm0
; X64-KNL-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB58_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB58_3
; X64-KNL-NEXT:  .LBB58_4: # %else2
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB58_1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm1, %rcx
; X64-KNL-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB58_4
; X64-KNL-NEXT:  .LBB58_3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-KNL-NEXT:    vpinsrq $1, (%rax), %xmm0, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: gather_2i64_constant_indices:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X86-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm0
; X86-KNL-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB58_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB58_3
; X86-KNL-NEXT:  .LBB58_4: # %else2
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB58_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm1, %ecx
; X86-KNL-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB58_4
; X86-KNL-NEXT:  .LBB58_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm1, %eax
; X86-KNL-NEXT:    vpinsrd $2, (%eax), %xmm0, %xmm0
; X86-KNL-NEXT:    vpinsrd $3, 4(%eax), %xmm0, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: gather_2i64_constant_indices:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    vpmovq2m %xmm0, %k0
; X64-SKX-SMALL-NEXT:    vpbroadcastq %rdi, %xmm0
; X64-SKX-SMALL-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; X64-SKX-SMALL-NEXT:    kmovw %k0, %eax
; X64-SKX-SMALL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    testb $1, %al
; X64-SKX-SMALL-NEXT:    jne .LBB58_1
; X64-SKX-SMALL-NEXT:  # %bb.2: # %else
; X64-SKX-SMALL-NEXT:    testb $2, %al
; X64-SKX-SMALL-NEXT:    jne .LBB58_3
; X64-SKX-SMALL-NEXT:  .LBB58_4: # %else2
; X64-SKX-SMALL-NEXT:    retq
; X64-SKX-SMALL-NEXT:  .LBB58_1: # %cond.load
; X64-SKX-SMALL-NEXT:    vmovq %xmm1, %rcx
; X64-SKX-SMALL-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X64-SKX-SMALL-NEXT:    testb $2, %al
; X64-SKX-SMALL-NEXT:    je .LBB58_4
; X64-SKX-SMALL-NEXT:  .LBB58_3: # %cond.load1
; X64-SKX-SMALL-NEXT:    vpextrq $1, %xmm1, %rax
; X64-SKX-SMALL-NEXT:    vpinsrq $1, (%rax), %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: gather_2i64_constant_indices:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    vpmovq2m %xmm0, %k0
; X64-SKX-LARGE-NEXT:    vpbroadcastq %rdi, %xmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpaddq (%rax), %xmm0, %xmm1
; X64-SKX-LARGE-NEXT:    kmovw %k0, %eax
; X64-SKX-LARGE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    testb $1, %al
; X64-SKX-LARGE-NEXT:    jne .LBB58_1
; X64-SKX-LARGE-NEXT:  # %bb.2: # %else
; X64-SKX-LARGE-NEXT:    testb $2, %al
; X64-SKX-LARGE-NEXT:    jne .LBB58_3
; X64-SKX-LARGE-NEXT:  .LBB58_4: # %else2
; X64-SKX-LARGE-NEXT:    retq
; X64-SKX-LARGE-NEXT:  .LBB58_1: # %cond.load
; X64-SKX-LARGE-NEXT:    vmovq %xmm1, %rcx
; X64-SKX-LARGE-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X64-SKX-LARGE-NEXT:    testb $2, %al
; X64-SKX-LARGE-NEXT:    je .LBB58_4
; X64-SKX-LARGE-NEXT:  .LBB58_3: # %cond.load1
; X64-SKX-LARGE-NEXT:    vpextrq $1, %xmm1, %rax
; X64-SKX-LARGE-NEXT:    vpinsrq $1, (%rax), %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: gather_2i64_constant_indices:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm0, %xmm0
; X86-SKX-NEXT:    vpmovq2m %xmm0, %k0
; X86-SKX-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm0
; X86-SKX-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB58_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB58_3
; X86-SKX-NEXT:  .LBB58_4: # %else2
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB58_1: # %cond.load
; X86-SKX-NEXT:    vmovd %xmm1, %ecx
; X86-SKX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB58_4
; X86-SKX-NEXT:  .LBB58_3: # %cond.load1
; X86-SKX-NEXT:    vpextrd $1, %xmm1, %eax
; X86-SKX-NEXT:    vpinsrd $2, (%eax), %xmm0, %xmm0
; X86-SKX-NEXT:    vpinsrd $3, 4(%eax), %xmm0, %xmm0
; X86-SKX-NEXT:    retl
  %gep = getelementptr i64, ptr %ptr, <2 x i64> <i64 0, i64 -2>
  %res = tail call <2 x i64> @llvm.masked.gather.v2i64.v2p0(<2 x ptr> %gep, i32 8, <2 x i1> %mask, <2 x i64> zeroinitializer) #1
  ret <2 x i64> %res
}

define <16 x i32> @gather_16i64_constant_indices(ptr %ptr, <16 x i1> %mask) {
; X64-KNL-LABEL: gather_16i64_constant_indices:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X64-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-KNL-NEXT:    vpgatherdd (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: gather_16i64_constant_indices:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X86-KNL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-KNL-NEXT:    vpgatherdd (%eax,%zmm1,4), %zmm0 {%k1}
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: gather_16i64_constant_indices:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X64-SKX-SMALL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    vpgatherdd (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: gather_16i64_constant_indices:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vmovdqa64 (%rax), %zmm1
; X64-SKX-LARGE-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    vpgatherdd (%rdi,%zmm1,4), %zmm0 {%k1}
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: gather_16i64_constant_indices:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vpgatherdd (%eax,%zmm1,4), %zmm0 {%k1}
; X86-SKX-NEXT:    retl
  %gep = getelementptr i32, ptr %ptr, <16 x i64> <i64 0, i64 -2, i64 1, i64 -8, i64 10, i64 20, i64 50, i64 65536, i64 16777215, i64 2147483647, i64 100, i64 -2000, i64 -2147483648, i64 76897723, i64 7, i64 -67897687>
  %res = tail call <16 x i32> @llvm.masked.gather.v16i32.v16p0(<16 x ptr> %gep, i32 4, <16 x i1> %mask, <16 x i32> zeroinitializer) #1
  ret <16 x i32> %res
}

define void @scatter_2i64_constant_indices(ptr %ptr, <2 x i1> %mask, <2 x i32> %src0)  {
; X64-KNL-LABEL: scatter_2i64_constant_indices:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k0
; X64-KNL-NEXT:    vmovq %rdi, %xmm0
; X64-KNL-NEXT:    vpbroadcastq %xmm0, %xmm0
; X64-KNL-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    jne .LBB60_1
; X64-KNL-NEXT:  # %bb.2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    jne .LBB60_3
; X64-KNL-NEXT:  .LBB60_4: # %else2
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB60_1: # %cond.store
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovss %xmm1, (%rcx)
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB60_4
; X64-KNL-NEXT:  .LBB60_3: # %cond.store1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vextractps $1, %xmm1, (%rax)
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: scatter_2i64_constant_indices:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X86-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm0
; X86-KNL-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB60_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB60_3
; X86-KNL-NEXT:  .LBB60_4: # %else2
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB60_1: # %cond.store
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vmovss %xmm1, (%ecx)
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB60_4
; X86-KNL-NEXT:  .LBB60_3: # %cond.store1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %eax
; X86-KNL-NEXT:    vextractps $1, %xmm1, (%eax)
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: scatter_2i64_constant_indices:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    vpmovq2m %xmm0, %k0
; X64-SKX-SMALL-NEXT:    vpbroadcastq %rdi, %xmm0
; X64-SKX-SMALL-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-SKX-SMALL-NEXT:    kmovw %k0, %eax
; X64-SKX-SMALL-NEXT:    testb $1, %al
; X64-SKX-SMALL-NEXT:    jne .LBB60_1
; X64-SKX-SMALL-NEXT:  # %bb.2: # %else
; X64-SKX-SMALL-NEXT:    testb $2, %al
; X64-SKX-SMALL-NEXT:    jne .LBB60_3
; X64-SKX-SMALL-NEXT:  .LBB60_4: # %else2
; X64-SKX-SMALL-NEXT:    retq
; X64-SKX-SMALL-NEXT:  .LBB60_1: # %cond.store
; X64-SKX-SMALL-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-SMALL-NEXT:    vmovss %xmm1, (%rcx)
; X64-SKX-SMALL-NEXT:    testb $2, %al
; X64-SKX-SMALL-NEXT:    je .LBB60_4
; X64-SKX-SMALL-NEXT:  .LBB60_3: # %cond.store1
; X64-SKX-SMALL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-SMALL-NEXT:    vextractps $1, %xmm1, (%rax)
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: scatter_2i64_constant_indices:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpsllq $63, %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    vpmovq2m %xmm0, %k0
; X64-SKX-LARGE-NEXT:    vpbroadcastq %rdi, %xmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpaddq (%rax), %xmm0, %xmm0
; X64-SKX-LARGE-NEXT:    kmovw %k0, %eax
; X64-SKX-LARGE-NEXT:    testb $1, %al
; X64-SKX-LARGE-NEXT:    jne .LBB60_1
; X64-SKX-LARGE-NEXT:  # %bb.2: # %else
; X64-SKX-LARGE-NEXT:    testb $2, %al
; X64-SKX-LARGE-NEXT:    jne .LBB60_3
; X64-SKX-LARGE-NEXT:  .LBB60_4: # %else2
; X64-SKX-LARGE-NEXT:    retq
; X64-SKX-LARGE-NEXT:  .LBB60_1: # %cond.store
; X64-SKX-LARGE-NEXT:    vmovq %xmm0, %rcx
; X64-SKX-LARGE-NEXT:    vmovss %xmm1, (%rcx)
; X64-SKX-LARGE-NEXT:    testb $2, %al
; X64-SKX-LARGE-NEXT:    je .LBB60_4
; X64-SKX-LARGE-NEXT:  .LBB60_3: # %cond.store1
; X64-SKX-LARGE-NEXT:    vpextrq $1, %xmm0, %rax
; X64-SKX-LARGE-NEXT:    vextractps $1, %xmm1, (%rax)
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: scatter_2i64_constant_indices:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpsllq $63, %xmm0, %xmm0
; X86-SKX-NEXT:    vpmovq2m %xmm0, %k0
; X86-SKX-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm0
; X86-SKX-NEXT:    vpaddd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-SKX-NEXT:    kmovw %k0, %eax
; X86-SKX-NEXT:    testb $1, %al
; X86-SKX-NEXT:    jne .LBB60_1
; X86-SKX-NEXT:  # %bb.2: # %else
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    jne .LBB60_3
; X86-SKX-NEXT:  .LBB60_4: # %else2
; X86-SKX-NEXT:    retl
; X86-SKX-NEXT:  .LBB60_1: # %cond.store
; X86-SKX-NEXT:    vmovd %xmm0, %ecx
; X86-SKX-NEXT:    vmovss %xmm1, (%ecx)
; X86-SKX-NEXT:    testb $2, %al
; X86-SKX-NEXT:    je .LBB60_4
; X86-SKX-NEXT:  .LBB60_3: # %cond.store1
; X86-SKX-NEXT:    vpextrd $1, %xmm0, %eax
; X86-SKX-NEXT:    vextractps $1, %xmm1, (%eax)
; X86-SKX-NEXT:    retl
  %gep = getelementptr i32, ptr %ptr, <2 x i64> <i64 0, i64 -2>
  call void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> %src0, <2 x ptr> %gep, i32 4, <2 x i1> %mask)
  ret void
}

define void @scatter_16i64_constant_indices(ptr %ptr, <16 x i1> %mask, <16 x i32> %src0)  {
; X64-KNL-LABEL: scatter_16i64_constant_indices:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X64-KNL-NEXT:    vpscatterdd %zmm1, (%rdi,%zmm0,4) {%k1}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: scatter_16i64_constant_indices:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X86-KNL-NEXT:    vpscatterdd %zmm1, (%eax,%zmm0,4) {%k1}
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: scatter_16i64_constant_indices:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X64-SKX-SMALL-NEXT:    vpscatterdd %zmm1, (%rdi,%zmm0,4) {%k1}
; X64-SKX-SMALL-NEXT:    vzeroupper
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: scatter_16i64_constant_indices:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vmovdqa64 (%rax), %zmm0
; X64-SKX-LARGE-NEXT:    vpscatterdd %zmm1, (%rdi,%zmm0,4) {%k1}
; X64-SKX-LARGE-NEXT:    vzeroupper
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: scatter_16i64_constant_indices:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,4294967294,1,4294967288,10,20,50,65536,16777215,2147483647,100,4294965296,2147483648,76897723,7,4227069609]
; X86-SKX-NEXT:    vpscatterdd %zmm1, (%eax,%zmm0,4) {%k1}
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  %gep = getelementptr i32, ptr %ptr, <16 x i64> <i64 0, i64 -2, i64 1, i64 -8, i64 10, i64 20, i64 50, i64 65536, i64 16777215, i64 2147483647, i64 100, i64 -2000, i64 -2147483648, i64 76897723, i64 7, i64 -67897687>
  call void @llvm.masked.scatter.v16i32.v16p0(<16 x i32> %src0, <16 x ptr> %gep, i32 4, <16 x i1> %mask)
  ret void
}

define <4 x i32> @splat_ptr_gather(ptr %ptr, <4 x i1> %mask, <4 x i32> %passthru) {
; X64-KNL-LABEL: splat_ptr_gather:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpslld $31, %xmm0, %xmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; X64-KNL-NEXT:    vmovq %rdi, %xmm0
; X64-KNL-NEXT:    vpbroadcastq %xmm0, %ymm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    je .LBB62_2
; X64-KNL-NEXT:  # %bb.1: # %cond.load
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrd $0, (%rcx), %xmm1, %xmm1
; X64-KNL-NEXT:  .LBB62_2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB62_4
; X64-KNL-NEXT:  # %bb.3: # %cond.load1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrd $1, (%rcx), %xmm1, %xmm1
; X64-KNL-NEXT:  .LBB62_4: # %else2
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    vextracti128 $1, %ymm0, %xmm0
; X64-KNL-NEXT:    jne .LBB62_5
; X64-KNL-NEXT:  # %bb.6: # %else5
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB62_7
; X64-KNL-NEXT:  .LBB62_8: # %else8
; X64-KNL-NEXT:    vmovdqa %xmm1, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB62_5: # %cond.load4
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vpinsrd $2, (%rcx), %xmm1, %xmm1
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB62_8
; X64-KNL-NEXT:  .LBB62_7: # %cond.load7
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vpinsrd $3, (%rax), %xmm1, %xmm1
; X64-KNL-NEXT:    vmovdqa %xmm1, %xmm0
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: splat_ptr_gather:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $31, %xmm0, %xmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB62_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB62_3
; X86-KNL-NEXT:  .LBB62_4: # %else2
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    jne .LBB62_5
; X86-KNL-NEXT:  .LBB62_6: # %else5
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    jne .LBB62_7
; X86-KNL-NEXT:  .LBB62_8: # %else8
; X86-KNL-NEXT:    vmovdqa %xmm1, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB62_1: # %cond.load
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vpinsrd $0, (%ecx), %xmm1, %xmm1
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB62_4
; X86-KNL-NEXT:  .LBB62_3: # %cond.load1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-KNL-NEXT:    vpinsrd $1, (%ecx), %xmm1, %xmm1
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    je .LBB62_6
; X86-KNL-NEXT:  .LBB62_5: # %cond.load4
; X86-KNL-NEXT:    vpextrd $2, %xmm0, %ecx
; X86-KNL-NEXT:    vpinsrd $2, (%ecx), %xmm1, %xmm1
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    je .LBB62_8
; X86-KNL-NEXT:  .LBB62_7: # %cond.load7
; X86-KNL-NEXT:    vpextrd $3, %xmm0, %eax
; X86-KNL-NEXT:    vpinsrd $3, (%eax), %xmm1, %xmm1
; X86-KNL-NEXT:    vmovdqa %xmm1, %xmm0
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: splat_ptr_gather:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $31, %xmm0, %xmm0
; X64-SKX-NEXT:    vpmovd2m %xmm0, %k1
; X64-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-NEXT:    vpgatherdd (%rdi,%xmm0,4), %xmm1 {%k1}
; X64-SKX-NEXT:    vmovdqa %xmm1, %xmm0
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: splat_ptr_gather:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $31, %xmm0, %xmm0
; X86-SKX-NEXT:    vpmovd2m %xmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vpgatherdd (%eax,%xmm0,4), %xmm1 {%k1}
; X86-SKX-NEXT:    vmovdqa %xmm1, %xmm0
; X86-SKX-NEXT:    retl
  %1 = insertelement <4 x ptr> undef, ptr %ptr, i32 0
  %2 = shufflevector <4 x ptr> %1, <4 x ptr> undef, <4 x i32> zeroinitializer
  %3 = call <4 x i32> @llvm.masked.gather.v4i32.v4p0(<4 x ptr> %2, i32 4, <4 x i1> %mask, <4 x i32> %passthru)
  ret <4 x i32> %3
}
declare  <4 x i32> @llvm.masked.gather.v4i32.v4p0(<4 x ptr>, i32, <4 x i1>, <4 x i32>)

define void @splat_ptr_scatter(ptr %ptr, <4 x i1> %mask, <4 x i32> %val) {
; X64-KNL-LABEL: splat_ptr_scatter:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpslld $31, %xmm0, %xmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; X64-KNL-NEXT:    vmovq %rdi, %xmm0
; X64-KNL-NEXT:    vpbroadcastq %xmm0, %ymm0
; X64-KNL-NEXT:    kmovw %k0, %eax
; X64-KNL-NEXT:    testb $1, %al
; X64-KNL-NEXT:    je .LBB63_2
; X64-KNL-NEXT:  # %bb.1: # %cond.store
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vmovss %xmm1, (%rcx)
; X64-KNL-NEXT:  .LBB63_2: # %else
; X64-KNL-NEXT:    testb $2, %al
; X64-KNL-NEXT:    je .LBB63_4
; X64-KNL-NEXT:  # %bb.3: # %cond.store1
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rcx
; X64-KNL-NEXT:    vextractps $1, %xmm1, (%rcx)
; X64-KNL-NEXT:  .LBB63_4: # %else2
; X64-KNL-NEXT:    testb $4, %al
; X64-KNL-NEXT:    vextracti128 $1, %ymm0, %xmm0
; X64-KNL-NEXT:    jne .LBB63_5
; X64-KNL-NEXT:  # %bb.6: # %else4
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    jne .LBB63_7
; X64-KNL-NEXT:  .LBB63_8: # %else6
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
; X64-KNL-NEXT:  .LBB63_5: # %cond.store3
; X64-KNL-NEXT:    vmovq %xmm0, %rcx
; X64-KNL-NEXT:    vextractps $2, %xmm1, (%rcx)
; X64-KNL-NEXT:    testb $8, %al
; X64-KNL-NEXT:    je .LBB63_8
; X64-KNL-NEXT:  .LBB63_7: # %cond.store5
; X64-KNL-NEXT:    vpextrq $1, %xmm0, %rax
; X64-KNL-NEXT:    vextractps $3, %xmm1, (%rax)
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: splat_ptr_scatter:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpslld $31, %xmm0, %xmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; X86-KNL-NEXT:    vpbroadcastd {{[0-9]+}}(%esp), %xmm0
; X86-KNL-NEXT:    kmovw %k0, %eax
; X86-KNL-NEXT:    testb $1, %al
; X86-KNL-NEXT:    jne .LBB63_1
; X86-KNL-NEXT:  # %bb.2: # %else
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    jne .LBB63_3
; X86-KNL-NEXT:  .LBB63_4: # %else2
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    jne .LBB63_5
; X86-KNL-NEXT:  .LBB63_6: # %else4
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    jne .LBB63_7
; X86-KNL-NEXT:  .LBB63_8: # %else6
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
; X86-KNL-NEXT:  .LBB63_1: # %cond.store
; X86-KNL-NEXT:    vmovd %xmm0, %ecx
; X86-KNL-NEXT:    vmovss %xmm1, (%ecx)
; X86-KNL-NEXT:    testb $2, %al
; X86-KNL-NEXT:    je .LBB63_4
; X86-KNL-NEXT:  .LBB63_3: # %cond.store1
; X86-KNL-NEXT:    vpextrd $1, %xmm0, %ecx
; X86-KNL-NEXT:    vextractps $1, %xmm1, (%ecx)
; X86-KNL-NEXT:    testb $4, %al
; X86-KNL-NEXT:    je .LBB63_6
; X86-KNL-NEXT:  .LBB63_5: # %cond.store3
; X86-KNL-NEXT:    vpextrd $2, %xmm0, %ecx
; X86-KNL-NEXT:    vextractps $2, %xmm1, (%ecx)
; X86-KNL-NEXT:    testb $8, %al
; X86-KNL-NEXT:    je .LBB63_8
; X86-KNL-NEXT:  .LBB63_7: # %cond.store5
; X86-KNL-NEXT:    vpextrd $3, %xmm0, %eax
; X86-KNL-NEXT:    vextractps $3, %xmm1, (%eax)
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: splat_ptr_scatter:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $31, %xmm0, %xmm0
; X64-SKX-NEXT:    vpmovd2m %xmm0, %k1
; X64-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-SKX-NEXT:    vpscatterdd %xmm1, (%rdi,%xmm0,4) {%k1}
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: splat_ptr_scatter:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpslld $31, %xmm0, %xmm0
; X86-SKX-NEXT:    vpmovd2m %xmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-SKX-NEXT:    vpscatterdd %xmm1, (%eax,%xmm0,4) {%k1}
; X86-SKX-NEXT:    retl
  %1 = insertelement <4 x ptr> undef, ptr %ptr, i32 0
  %2 = shufflevector <4 x ptr> %1, <4 x ptr> undef, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4i32.v4p0(<4 x i32> %val, <4 x ptr> %2, i32 4, <4 x i1> %mask)
  ret void
}

;
; PR13310
; Failure to fold scaled-index into gather/scatter scale operand.
;

define <8 x float> @scaleidx_x86gather(ptr %base, <8 x i32> %index, <8 x i32> %imask) nounwind {
; X64-LABEL: scaleidx_x86gather:
; X64:       # %bb.0:
; X64-NEXT:    vpslld $2, %ymm0, %ymm2
; X64-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-NEXT:    vgatherdps %ymm1, (%rdi,%ymm2), %ymm0
; X64-NEXT:    retq
;
; X86-LABEL: scaleidx_x86gather:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; X86-NEXT:    vgatherdps %ymm1, (%eax,%ymm0,4), %ymm2
; X86-NEXT:    vmovaps %ymm2, %ymm0
; X86-NEXT:    retl
  %mask = bitcast <8 x i32> %imask to <8 x float>
  %scaledindex = mul <8 x i32> %index, <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  %v = call <8 x float> @llvm.x86.avx2.gather.d.ps.256(<8 x float> undef, ptr %base, <8 x i32> %scaledindex, <8 x float> %mask, i8 1) nounwind
  ret <8 x float> %v
}

define <8 x float> @scaleidx_x86gather_outofrange(ptr %base, <8 x i32> %index, <8 x i32> %imask) nounwind {
; X64-LABEL: scaleidx_x86gather_outofrange:
; X64:       # %bb.0:
; X64-NEXT:    vpslld $2, %ymm0, %ymm2
; X64-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X64-NEXT:    vgatherdps %ymm1, (%rdi,%ymm2,4), %ymm0
; X64-NEXT:    retq
;
; X86-LABEL: scaleidx_x86gather_outofrange:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpslld $2, %ymm0, %ymm2
; X86-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; X86-NEXT:    vgatherdps %ymm1, (%eax,%ymm2,4), %ymm0
; X86-NEXT:    retl
  %mask = bitcast <8 x i32> %imask to <8 x float>
  %scaledindex = mul <8 x i32> %index, <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  %v = call <8 x float> @llvm.x86.avx2.gather.d.ps.256(<8 x float> undef, ptr %base, <8 x i32> %scaledindex, <8 x float> %mask, i8 4) nounwind
  ret <8 x float> %v
}
declare <8 x float> @llvm.x86.avx2.gather.d.ps.256(<8 x float>, ptr, <8 x i32>, <8 x float>, i8) nounwind readonly

define void @scaleidx_x86scatter(<16 x float> %value, ptr %base, <16 x i32> %index, i16 %imask) nounwind {
; X64-LABEL: scaleidx_x86scatter:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpaddd %zmm1, %zmm1, %zmm1
; X64-NEXT:    vscatterdps %zmm0, (%rdi,%zmm1,2) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
;
; X86-LABEL: scaleidx_x86scatter:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vscatterdps %zmm0, (%eax,%zmm1,4) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
  %mask = bitcast i16 %imask to <16 x i1>
  %scaledindex = shl <16 x i32> %index, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  call void @llvm.x86.avx512.mask.scatter.dps.512(ptr %base, <16 x i1> %mask, <16 x i32> %scaledindex, <16 x float> %value, i32 2)
  ret void
}
declare void @llvm.x86.avx512.mask.scatter.dps.512(ptr, <16 x i1>, <16 x i32>, <16 x float>, i32)

define void @scaleidx_scatter(<8 x float> %value, ptr %base, <8 x i32> %index, i8 %imask) nounwind {
; X64-KNL-LABEL: scaleidx_scatter:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X64-KNL-NEXT:    vpaddd %ymm1, %ymm1, %ymm1
; X64-KNL-NEXT:    kmovw %esi, %k0
; X64-KNL-NEXT:    kshiftlw $8, %k0, %k0
; X64-KNL-NEXT:    kshiftrw $8, %k0, %k1
; X64-KNL-NEXT:    vscatterdps %zmm0, (%rdi,%zmm1,4) {%k1}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: scaleidx_scatter:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    vpaddd %ymm1, %ymm1, %ymm1
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    kmovw %ecx, %k0
; X86-KNL-NEXT:    kshiftlw $8, %k0, %k0
; X86-KNL-NEXT:    kshiftrw $8, %k0, %k1
; X86-KNL-NEXT:    vscatterdps %zmm0, (%eax,%zmm1,4) {%k1}
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: scaleidx_scatter:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpaddd %ymm1, %ymm1, %ymm1
; X64-SKX-NEXT:    kmovw %esi, %k1
; X64-SKX-NEXT:    vscatterdps %ymm0, (%rdi,%ymm1,4) {%k1}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: scaleidx_scatter:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-SKX-NEXT:    vscatterdps %ymm0, (%eax,%ymm1,8) {%k1}
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  %scaledindex = mul <8 x i32> %index, <i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2>
  %ptrs = getelementptr float, ptr %base, <8 x i32> %scaledindex
  %mask = bitcast i8 %imask to <8 x i1>
  call void @llvm.masked.scatter.v8f32.v8p0(<8 x float> %value, <8 x ptr> %ptrs, i32 1, <8 x i1> %mask)
  ret void
}

define void @scaleidx_scatter_outofrange(<8 x float> %value, ptr %base, <8 x i32> %index, i8 %imask) nounwind {
; X64-KNL-LABEL: scaleidx_scatter_outofrange:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X64-KNL-NEXT:    vpslld $2, %ymm1, %ymm1
; X64-KNL-NEXT:    kmovw %esi, %k0
; X64-KNL-NEXT:    kshiftlw $8, %k0, %k0
; X64-KNL-NEXT:    kshiftrw $8, %k0, %k1
; X64-KNL-NEXT:    vscatterdps %zmm0, (%rdi,%zmm1,4) {%k1}
; X64-KNL-NEXT:    vzeroupper
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: scaleidx_scatter_outofrange:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    vpslld $2, %ymm1, %ymm1
; X86-KNL-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    kmovw %ecx, %k0
; X86-KNL-NEXT:    kshiftlw $8, %k0, %k0
; X86-KNL-NEXT:    kshiftrw $8, %k0, %k1
; X86-KNL-NEXT:    vscatterdps %zmm0, (%eax,%zmm1,4) {%k1}
; X86-KNL-NEXT:    vzeroupper
; X86-KNL-NEXT:    retl
;
; X64-SKX-LABEL: scaleidx_scatter_outofrange:
; X64-SKX:       # %bb.0:
; X64-SKX-NEXT:    vpslld $2, %ymm1, %ymm1
; X64-SKX-NEXT:    kmovw %esi, %k1
; X64-SKX-NEXT:    vscatterdps %ymm0, (%rdi,%ymm1,4) {%k1}
; X64-SKX-NEXT:    vzeroupper
; X64-SKX-NEXT:    retq
;
; X86-SKX-LABEL: scaleidx_scatter_outofrange:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    vpslld $2, %ymm1, %ymm1
; X86-SKX-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-SKX-NEXT:    vscatterdps %ymm0, (%eax,%ymm1,4) {%k1}
; X86-SKX-NEXT:    vzeroupper
; X86-SKX-NEXT:    retl
  %scaledindex = mul <8 x i32> %index, <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  %ptrs = getelementptr float, ptr %base, <8 x i32> %scaledindex
  %mask = bitcast i8 %imask to <8 x i1>
  call void @llvm.masked.scatter.v8f32.v8p0(<8 x float> %value, <8 x ptr> %ptrs, i32 2, <8 x i1> %mask)
  ret void
}
declare void @llvm.masked.scatter.v8f32.v8p0(<8 x float>, <8 x ptr>, i32 immarg, <8 x i1>)

;
; PR45906
; This used to cause fast-isel to generate bad copy instructions that would
; cause an error in copyPhysReg.
;

%struct.foo = type { ptr, i64, i16, i16, i32 }

define <8 x i64> @pr45906(<8 x ptr> %ptr) {
; X64-LABEL: pr45906:
; X64:       # %bb.0: # %bb
; X64-NEXT:    kxnorw %k0, %k0, %k1
; X64-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-NEXT:    vpgatherqq 8(,%zmm0), %zmm1 {%k1}
; X64-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-NEXT:    retq
;
; X86-LABEL: pr45906:
; X86:       # %bb.0: # %bb
; X86-NEXT:    kxnorw %k0, %k0, %k1
; X86-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-NEXT:    vpgatherdq 4(,%ymm0), %zmm1 {%k1}
; X86-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-NEXT:    retl
bb:
  %tmp = getelementptr inbounds %struct.foo, <8 x ptr> %ptr, i64 0, i32 1
  %tmp1 = call <8 x i64> @llvm.masked.gather.v8i64.v8p0(<8 x ptr> %tmp, i32 8, <8 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>, <8 x i64> undef)
  ret <8 x i64> %tmp1
}
declare <8 x i64> @llvm.masked.gather.v8i64.v8p0(<8 x ptr>, i32, <8 x i1>, <8 x i64>)

; Test gathers from struct
%struct.pt = type { float, float, float, i32 }
%struct.pt2 = type { float, float }

define <16 x float> @test_gather_structpt_16f32_mask_index(ptr %x, ptr %arr, <16 x i1> %mask, <16 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt_16f32_mask_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-KNL-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm0,8), %zmm1 {%k1}
; X64-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt_16f32_mask_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vpslld $4, (%ecx), %zmm0
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm0), %zmm1 {%k1}
; X86-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt_16f32_mask_index:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-SKX-SMALL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vgatherdps (%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt_16f32_mask_index:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpandd (%rax){1to16}, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vgatherdps (%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt_16f32_mask_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vpslld $4, (%ecx), %zmm0
; X86-SKX-NEXT:    vgatherdps (%eax,%zmm0), %zmm1 {%k1}
; X86-SKX-NEXT:    vmovaps %zmm1, %zmm0
; X86-SKX-NEXT:    retl
  %wide.load = load <16 x i32>, ptr %arr, align 4
  %and = and <16 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <16 x i32> %and to <16 x i64>
  %ptrs = getelementptr inbounds %struct.pt, ptr %x, <16 x i64> %zext
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x float> %src0)
  ret <16 x float> %res
}

define <16 x float> @test_gather_structpt_16f32_mask_index_offset(ptr %x, ptr %arr, <16 x i1> %mask, <16 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt_16f32_mask_index_offset:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-KNL-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; X64-KNL-NEXT:    vgatherdps 4(%rdi,%zmm0,8), %zmm1 {%k1}
; X64-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt_16f32_mask_index_offset:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vpslld $4, (%ecx), %zmm0
; X86-KNL-NEXT:    vgatherdps 4(%eax,%zmm0), %zmm1 {%k1}
; X86-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt_16f32_mask_index_offset:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-SKX-SMALL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vgatherdps 4(%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt_16f32_mask_index_offset:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpandd (%rax){1to16}, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vgatherdps 4(%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt_16f32_mask_index_offset:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vpslld $4, (%ecx), %zmm0
; X86-SKX-NEXT:    vgatherdps 4(%eax,%zmm0), %zmm1 {%k1}
; X86-SKX-NEXT:    vmovaps %zmm1, %zmm0
; X86-SKX-NEXT:    retl
  %wide.load = load <16 x i32>, ptr %arr, align 4
  %and = and <16 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <16 x i32> %and to <16 x i64>
  %ptrs = getelementptr inbounds %struct.pt, ptr %x, <16 x i64> %zext, i32 1
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x float> %src0)
  ret <16 x float> %res
}

define {<16 x float>, <16 x float>} @test_gather_structpt_16f32_mask_index_pair(ptr %x, ptr %arr, <16 x i1> %mask, <16 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt_16f32_mask_index_pair:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-KNL-NEXT:    vpaddd %zmm0, %zmm0, %zmm2
; X64-KNL-NEXT:    kmovw %k1, %k2
; X64-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm2,8), %zmm0 {%k2}
; X64-KNL-NEXT:    vgatherdps 4(%rdi,%zmm2,8), %zmm1 {%k1}
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt_16f32_mask_index_pair:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vpslld $4, (%ecx), %zmm2
; X86-KNL-NEXT:    kmovw %k1, %k2
; X86-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm2), %zmm0 {%k2}
; X86-KNL-NEXT:    vgatherdps 4(%eax,%zmm2), %zmm1 {%k1}
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt_16f32_mask_index_pair:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-SKX-SMALL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpaddd %zmm0, %zmm0, %zmm2
; X64-SKX-SMALL-NEXT:    kmovw %k1, %k2
; X64-SKX-SMALL-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-SMALL-NEXT:    vgatherdps (%rdi,%zmm2,8), %zmm0 {%k2}
; X64-SKX-SMALL-NEXT:    vgatherdps 4(%rdi,%zmm2,8), %zmm1 {%k1}
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt_16f32_mask_index_pair:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vpandd (%rax){1to16}, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpaddd %zmm0, %zmm0, %zmm2
; X64-SKX-LARGE-NEXT:    kmovw %k1, %k2
; X64-SKX-LARGE-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-LARGE-NEXT:    vgatherdps (%rdi,%zmm2,8), %zmm0 {%k2}
; X64-SKX-LARGE-NEXT:    vgatherdps 4(%rdi,%zmm2,8), %zmm1 {%k1}
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt_16f32_mask_index_pair:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vpslld $4, (%ecx), %zmm2
; X86-SKX-NEXT:    kmovw %k1, %k2
; X86-SKX-NEXT:    vmovaps %zmm1, %zmm0
; X86-SKX-NEXT:    vgatherdps (%eax,%zmm2), %zmm0 {%k2}
; X86-SKX-NEXT:    vgatherdps 4(%eax,%zmm2), %zmm1 {%k1}
; X86-SKX-NEXT:    retl
  %wide.load = load <16 x i32>, ptr %arr, align 4
  %and = and <16 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <16 x i32> %and to <16 x i64>
  %ptrs1 = getelementptr inbounds %struct.pt, ptr %x, <16 x i64> %zext
  %res1 = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs1, i32 4, <16 x i1> %mask, <16 x float> %src0)
  %ptrs = getelementptr inbounds %struct.pt, ptr %x, <16 x i64> %zext, i32 1
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x float> %src0)
  %pair1 = insertvalue {<16 x float>, <16 x float>} poison, <16 x float> %res1, 0
  %pair2 = insertvalue {<16 x float>, <16 x float>} %pair1, <16 x float> %res, 1
  ret {<16 x float>, <16 x float>} %pair2
}

define <8 x float> @test_gather_structpt2_8f32_mask_index(ptr %x, ptr %arr, <8 x i1> %mask, <8 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt2_8f32_mask_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; X64-KNL-NEXT:    vpmovsxwq %xmm0, %zmm0
; X64-KNL-NEXT:    vpsllq $63, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vbroadcastss {{.*#+}} ymm0 = [536870911,536870911,536870911,536870911,536870911,536870911,536870911,536870911]
; X64-KNL-NEXT:    vandps (%rsi), %ymm0, %ymm0
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm0,8), %zmm1 {%k1}
; X64-KNL-NEXT:    vmovaps %ymm1, %ymm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt2_8f32_mask_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; X86-KNL-NEXT:    vpmovsxwq %xmm0, %zmm0
; X86-KNL-NEXT:    vpsllq $63, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vmovdqu (%ecx), %ymm0
; X86-KNL-NEXT:    vpslld $3, %ymm0, %ymm0
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm0), %zmm1 {%k1}
; X86-KNL-NEXT:    vmovaps %ymm1, %ymm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt2_8f32_mask_index:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxwd %xmm0, %ymm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %ymm0, %ymm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %ymm0, %k1
; X64-SKX-SMALL-NEXT:    vmovups (%rsi), %ymm0
; X64-SKX-SMALL-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-SKX-SMALL-NEXT:    vgatherdps (%rdi,%ymm0,8), %ymm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovaps %ymm1, %ymm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt2_8f32_mask_index:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxwd %xmm0, %ymm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %ymm0, %ymm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %ymm0, %k1
; X64-SKX-LARGE-NEXT:    vmovups (%rsi), %ymm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vandps (%rax){1to8}, %ymm0, %ymm0
; X64-SKX-LARGE-NEXT:    vgatherdps (%rdi,%ymm0,8), %ymm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovaps %ymm1, %ymm0
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt2_8f32_mask_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxwd %xmm0, %ymm0
; X86-SKX-NEXT:    vpslld $31, %ymm0, %ymm0
; X86-SKX-NEXT:    vpmovd2m %ymm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vmovups (%ecx), %ymm0
; X86-SKX-NEXT:    vgatherdps (%eax,%ymm0,8), %ymm1 {%k1}
; X86-SKX-NEXT:    vmovaps %ymm1, %ymm0
; X86-SKX-NEXT:    retl
  %wide.load = load <8 x i32>, ptr %arr, align 4
  %and = and <8 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <8 x i32> %and to <8 x i64>
  %ptrs = getelementptr inbounds %struct.pt2, ptr %x, <8 x i64> %zext
  %res = call <8 x float> @llvm.masked.gather.v8f32.v8p0(<8 x ptr> %ptrs, i32 4, <8 x i1> %mask, <8 x float> %src0)
  ret <8 x float> %res
}

define <8 x float> @test_gather_structpt2_8f32_mask_index_offset(ptr %x, ptr %arr, <8 x i1> %mask, <8 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt2_8f32_mask_index_offset:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; X64-KNL-NEXT:    vpmovsxwq %xmm0, %zmm0
; X64-KNL-NEXT:    vpsllq $63, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vbroadcastss {{.*#+}} ymm0 = [536870911,536870911,536870911,536870911,536870911,536870911,536870911,536870911]
; X64-KNL-NEXT:    vandps (%rsi), %ymm0, %ymm0
; X64-KNL-NEXT:    vgatherdps 4(%rdi,%zmm0,8), %zmm1 {%k1}
; X64-KNL-NEXT:    vmovaps %ymm1, %ymm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt2_8f32_mask_index_offset:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; X86-KNL-NEXT:    vpmovsxwq %xmm0, %zmm0
; X86-KNL-NEXT:    vpsllq $63, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vmovdqu (%ecx), %ymm0
; X86-KNL-NEXT:    vpslld $3, %ymm0, %ymm0
; X86-KNL-NEXT:    vgatherdps 4(%eax,%zmm0), %zmm1 {%k1}
; X86-KNL-NEXT:    vmovaps %ymm1, %ymm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt2_8f32_mask_index_offset:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxwd %xmm0, %ymm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %ymm0, %ymm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %ymm0, %k1
; X64-SKX-SMALL-NEXT:    vmovups (%rsi), %ymm0
; X64-SKX-SMALL-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-SKX-SMALL-NEXT:    vgatherdps 4(%rdi,%ymm0,8), %ymm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovaps %ymm1, %ymm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt2_8f32_mask_index_offset:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxwd %xmm0, %ymm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %ymm0, %ymm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %ymm0, %k1
; X64-SKX-LARGE-NEXT:    vmovups (%rsi), %ymm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vandps (%rax){1to8}, %ymm0, %ymm0
; X64-SKX-LARGE-NEXT:    vgatherdps 4(%rdi,%ymm0,8), %ymm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovaps %ymm1, %ymm0
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt2_8f32_mask_index_offset:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxwd %xmm0, %ymm0
; X86-SKX-NEXT:    vpslld $31, %ymm0, %ymm0
; X86-SKX-NEXT:    vpmovd2m %ymm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vmovups (%ecx), %ymm0
; X86-SKX-NEXT:    vgatherdps 4(%eax,%ymm0,8), %ymm1 {%k1}
; X86-SKX-NEXT:    vmovaps %ymm1, %ymm0
; X86-SKX-NEXT:    retl
  %wide.load = load <8 x i32>, ptr %arr, align 4
  %and = and <8 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <8 x i32> %and to <8 x i64>
  %ptrs = getelementptr inbounds %struct.pt2, ptr %x, <8 x i64> %zext, i32 1
  %res = call <8 x float> @llvm.masked.gather.v8f32.v8p0(<8 x ptr> %ptrs, i32 4, <8 x i1> %mask, <8 x float> %src0)
  ret <8 x float> %res
}

define {<8 x float>, <8 x float>} @test_gather_structpt2_8f32_mask_index_pair(ptr %x, ptr %arr, <8 x i1> %mask, <8 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt2_8f32_mask_index_pair:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; X64-KNL-NEXT:    vpmovsxwq %xmm0, %zmm0
; X64-KNL-NEXT:    vpsllq $63, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vbroadcastss {{.*#+}} ymm0 = [536870911,536870911,536870911,536870911,536870911,536870911,536870911,536870911]
; X64-KNL-NEXT:    vandps (%rsi), %ymm0, %ymm2
; X64-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X64-KNL-NEXT:    kmovw %k1, %k2
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm2,8), %zmm0 {%k2}
; X64-KNL-NEXT:    vgatherdps 4(%rdi,%zmm2,8), %zmm1 {%k1}
; X64-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X64-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 killed $zmm1
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt2_8f32_mask_index_pair:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; X86-KNL-NEXT:    vpmovsxwq %xmm0, %zmm0
; X86-KNL-NEXT:    vpsllq $63, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmq %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vmovdqu (%ecx), %ymm0
; X86-KNL-NEXT:    vpslld $3, %ymm0, %ymm2
; X86-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X86-KNL-NEXT:    kmovw %k1, %k2
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm2), %zmm0 {%k2}
; X86-KNL-NEXT:    vgatherdps 4(%eax,%zmm2), %zmm1 {%k1}
; X86-KNL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X86-KNL-NEXT:    # kill: def $ymm1 killed $ymm1 killed $zmm1
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt2_8f32_mask_index_pair:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxwd %xmm0, %ymm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %ymm0, %ymm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %ymm0, %k1
; X64-SKX-SMALL-NEXT:    vmovups (%rsi), %ymm0
; X64-SKX-SMALL-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm2
; X64-SKX-SMALL-NEXT:    kmovw %k1, %k2
; X64-SKX-SMALL-NEXT:    vmovaps %ymm1, %ymm0
; X64-SKX-SMALL-NEXT:    vgatherdps (%rdi,%ymm2,8), %ymm0 {%k2}
; X64-SKX-SMALL-NEXT:    vgatherdps 4(%rdi,%ymm2,8), %ymm1 {%k1}
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt2_8f32_mask_index_pair:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxwd %xmm0, %ymm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %ymm0, %ymm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %ymm0, %k1
; X64-SKX-LARGE-NEXT:    vmovups (%rsi), %ymm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vandps (%rax){1to8}, %ymm0, %ymm2
; X64-SKX-LARGE-NEXT:    kmovw %k1, %k2
; X64-SKX-LARGE-NEXT:    vmovaps %ymm1, %ymm0
; X64-SKX-LARGE-NEXT:    vgatherdps (%rdi,%ymm2,8), %ymm0 {%k2}
; X64-SKX-LARGE-NEXT:    vgatherdps 4(%rdi,%ymm2,8), %ymm1 {%k1}
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt2_8f32_mask_index_pair:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxwd %xmm0, %ymm0
; X86-SKX-NEXT:    vpslld $31, %ymm0, %ymm0
; X86-SKX-NEXT:    vpmovd2m %ymm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vmovups (%ecx), %ymm2
; X86-SKX-NEXT:    kmovw %k1, %k2
; X86-SKX-NEXT:    vmovaps %ymm1, %ymm0
; X86-SKX-NEXT:    vgatherdps (%eax,%ymm2,8), %ymm0 {%k2}
; X86-SKX-NEXT:    vgatherdps 4(%eax,%ymm2,8), %ymm1 {%k1}
; X86-SKX-NEXT:    retl
  %wide.load = load <8 x i32>, ptr %arr, align 4
  %and = and <8 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <8 x i32> %and to <8 x i64>
  %ptrs1 = getelementptr inbounds %struct.pt2, ptr %x , <8 x i64> %zext
  %res1 = call <8 x float> @llvm.masked.gather.v8f32.v8p0(<8 x ptr> %ptrs1, i32 4, <8 x i1> %mask, <8 x float> %src0)
  %ptrs = getelementptr inbounds %struct.pt2, ptr %x, <8 x i64> %zext, i32 1
  %res = call <8 x float> @llvm.masked.gather.v8f32.v8p0(<8 x ptr> %ptrs, i32 4, <8 x i1> %mask, <8 x float> %src0)
  %pair1 = insertvalue {<8 x float>, <8 x float>} poison, <8 x float> %res1, 0
  %pair2 = insertvalue {<8 x float>, <8 x float>} %pair1, <8 x float> %res, 1
  ret {<8 x float>, <8 x float>} %pair2
}

define <16 x float> @test_gather_structpt2_16f32_mask_index(ptr %x, ptr %arr, <16 x i1> %mask, <16 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt2_16f32_mask_index:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm0,8), %zmm1 {%k1}
; X64-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt2_16f32_mask_index:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vmovups (%ecx), %zmm0
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm0,8), %zmm1 {%k1}
; X86-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt2_16f32_mask_index:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovups (%rsi), %zmm0
; X64-SKX-SMALL-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vgatherdps (%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt2_16f32_mask_index:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    vmovups (%rsi), %zmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vandps (%rax){1to16}, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vgatherdps (%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt2_16f32_mask_index:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vmovups (%ecx), %zmm0
; X86-SKX-NEXT:    vgatherdps (%eax,%zmm0,8), %zmm1 {%k1}
; X86-SKX-NEXT:    vmovaps %zmm1, %zmm0
; X86-SKX-NEXT:    retl
  %wide.load = load <16 x i32>, ptr %arr, align 4
  %and = and <16 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <16 x i32> %and to <16 x i64>
  %ptrs = getelementptr inbounds %struct.pt2, ptr %x, <16 x i64> %zext
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x float> %src0)
  ret <16 x float> %res
}

define <16 x float> @test_gather_structpt2_16f32_mask_index_offset(ptr %x, ptr %arr, <16 x i1> %mask, <16 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt2_16f32_mask_index_offset:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-KNL-NEXT:    vgatherdps 4(%rdi,%zmm0,8), %zmm1 {%k1}
; X64-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt2_16f32_mask_index_offset:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vmovups (%ecx), %zmm0
; X86-KNL-NEXT:    vgatherdps 4(%eax,%zmm0,8), %zmm1 {%k1}
; X86-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt2_16f32_mask_index_offset:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovups (%rsi), %zmm0
; X64-SKX-SMALL-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vgatherdps 4(%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-SMALL-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt2_16f32_mask_index_offset:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    vmovups (%rsi), %zmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vandps (%rax){1to16}, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vgatherdps 4(%rdi,%zmm0,8), %zmm1 {%k1}
; X64-SKX-LARGE-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt2_16f32_mask_index_offset:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vmovups (%ecx), %zmm0
; X86-SKX-NEXT:    vgatherdps 4(%eax,%zmm0,8), %zmm1 {%k1}
; X86-SKX-NEXT:    vmovaps %zmm1, %zmm0
; X86-SKX-NEXT:    retl
  %wide.load = load <16 x i32>, ptr %arr, align 4
  %and = and <16 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <16 x i32> %and to <16 x i64>
  %ptrs = getelementptr inbounds %struct.pt2, ptr %x, <16 x i64> %zext, i32 1
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x float> %src0)
  ret <16 x float> %res
}

define {<16 x float>, <16 x float>} @test_gather_structpt2_16f32_mask_index_pair(ptr %x, ptr %arr, <16 x i1> %mask, <16 x float> %src0) {
; X64-KNL-LABEL: test_gather_structpt2_16f32_mask_index_pair:
; X64-KNL:       # %bb.0:
; X64-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X64-KNL-NEXT:    vmovdqu64 (%rsi), %zmm0
; X64-KNL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm2
; X64-KNL-NEXT:    kmovw %k1, %k2
; X64-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X64-KNL-NEXT:    vgatherdps (%rdi,%zmm2,8), %zmm0 {%k2}
; X64-KNL-NEXT:    vgatherdps 4(%rdi,%zmm2,8), %zmm1 {%k1}
; X64-KNL-NEXT:    retq
;
; X86-KNL-LABEL: test_gather_structpt2_16f32_mask_index_pair:
; X86-KNL:       # %bb.0:
; X86-KNL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-KNL-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-KNL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-KNL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-KNL-NEXT:    vmovups (%ecx), %zmm2
; X86-KNL-NEXT:    kmovw %k1, %k2
; X86-KNL-NEXT:    vmovaps %zmm1, %zmm0
; X86-KNL-NEXT:    vgatherdps (%eax,%zmm2,8), %zmm0 {%k2}
; X86-KNL-NEXT:    vgatherdps 4(%eax,%zmm2,8), %zmm1 {%k1}
; X86-KNL-NEXT:    retl
;
; X64-SKX-SMALL-LABEL: test_gather_structpt2_16f32_mask_index_pair:
; X64-SKX-SMALL:       # %bb.0:
; X64-SKX-SMALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-SMALL-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-SMALL-NEXT:    vmovups (%rsi), %zmm0
; X64-SKX-SMALL-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm2
; X64-SKX-SMALL-NEXT:    kmovw %k1, %k2
; X64-SKX-SMALL-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-SMALL-NEXT:    vgatherdps (%rdi,%zmm2,8), %zmm0 {%k2}
; X64-SKX-SMALL-NEXT:    vgatherdps 4(%rdi,%zmm2,8), %zmm1 {%k1}
; X64-SKX-SMALL-NEXT:    retq
;
; X64-SKX-LARGE-LABEL: test_gather_structpt2_16f32_mask_index_pair:
; X64-SKX-LARGE:       # %bb.0:
; X64-SKX-LARGE-NEXT:    vpmovsxbd %xmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpslld $31, %zmm0, %zmm0
; X64-SKX-LARGE-NEXT:    vpmovd2m %zmm0, %k1
; X64-SKX-LARGE-NEXT:    vmovups (%rsi), %zmm0
; X64-SKX-LARGE-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; X64-SKX-LARGE-NEXT:    vandps (%rax){1to16}, %zmm0, %zmm2
; X64-SKX-LARGE-NEXT:    kmovw %k1, %k2
; X64-SKX-LARGE-NEXT:    vmovaps %zmm1, %zmm0
; X64-SKX-LARGE-NEXT:    vgatherdps (%rdi,%zmm2,8), %zmm0 {%k2}
; X64-SKX-LARGE-NEXT:    vgatherdps 4(%rdi,%zmm2,8), %zmm1 {%k1}
; X64-SKX-LARGE-NEXT:    retq
;
; X86-SKX-LABEL: test_gather_structpt2_16f32_mask_index_pair:
; X86-SKX:       # %bb.0:
; X86-SKX-NEXT:    vpmovsxbd %xmm0, %zmm0
; X86-SKX-NEXT:    vpslld $31, %zmm0, %zmm0
; X86-SKX-NEXT:    vpmovd2m %zmm0, %k1
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SKX-NEXT:    vmovups (%ecx), %zmm2
; X86-SKX-NEXT:    kmovw %k1, %k2
; X86-SKX-NEXT:    vmovaps %zmm1, %zmm0
; X86-SKX-NEXT:    vgatherdps (%eax,%zmm2,8), %zmm0 {%k2}
; X86-SKX-NEXT:    vgatherdps 4(%eax,%zmm2,8), %zmm1 {%k1}
; X86-SKX-NEXT:    retl
  %wide.load = load <16 x i32>, ptr %arr, align 4
  %and = and <16 x i32> %wide.load, <i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911, i32 536870911>
  %zext = zext <16 x i32> %and to <16 x i64>
  %ptrs1 = getelementptr inbounds %struct.pt2, ptr %x, <16 x i64> %zext
  %res1 = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs1, i32 4, <16 x i1> %mask, <16 x float> %src0)
  %ptrs = getelementptr inbounds %struct.pt2, ptr %x, <16 x i64> %zext, i32 1
  %res = call <16 x float> @llvm.masked.gather.v16f32.v16p0(<16 x ptr> %ptrs, i32 4, <16 x i1> %mask, <16 x float> %src0)
  %pair1 = insertvalue {<16 x float>, <16 x float>} poison, <16 x float> %res1, 0
  %pair2 = insertvalue {<16 x float>, <16 x float>} %pair1, <16 x float> %res, 1
  ret {<16 x float>, <16 x float>} %pair2
}
