; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx %s -o - | FileCheck %s


define void @load_sext_2i8_to_2i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_2i8_to_2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.h $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 56
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 56
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <2 x i8>, ptr %ptr
  %B = sext <2 x i8> %A to <2 x i64>
  store <2 x i64> %B, ptr %dst
  ret void
}

define void @load_sext_4i8_to_4i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_4i8_to_4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 24
; CHECK-NEXT:    vsrai.w $vr0, $vr0, 24
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <4 x i8>, ptr %ptr
  %B = sext <4 x i8> %A to <4 x i32>
  store <4 x i32> %B, ptr %dst
  ret void
}

define void @load_sext_8i8_to_8i16(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_8i8_to_8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.h $vr0, $vr0, 8
; CHECK-NEXT:    vsrai.h $vr0, $vr0, 8
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <8 x i8>, ptr %ptr
  %B = sext <8 x i8> %A to <8 x i16>
  store <8 x i16> %B, ptr %dst
  ret void
}

define void @load_sext_2i16_to_2i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_2i16_to_2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 48
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 48
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <2 x i16>, ptr %ptr
  %B = sext <2 x i16> %A to <2 x i64>
  store <2 x i64> %B, ptr %dst
  ret void
}

define void @load_sext_4i16_to_4i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_4i16_to_4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 16
; CHECK-NEXT:    vsrai.w $vr0, $vr0, 16
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <4 x i16>, ptr %ptr
  %B = sext <4 x i16> %A to <4 x i32>
  store <4 x i32> %B, ptr %dst
  ret void
}

define void @load_sext_2i32_to_2i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_2i32_to_2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 16
; CHECK-NEXT:    vslli.d $vr0, $vr0, 32
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 32
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <2 x i32>, ptr %ptr
  %B = sext <2 x i32> %A to <2 x i64>
  store <2 x i64> %B, ptr %dst
  ret void
}

define void @load_sext_16i8_to_16i16(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_16i8_to_16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr1, $vr0, $vr0
; CHECK-NEXT:    vslli.h $vr1, $vr1, 8
; CHECK-NEXT:    vsrai.h $vr1, $vr1, 8
; CHECK-NEXT:    vilvh.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.h $vr0, $vr0, 8
; CHECK-NEXT:    vsrai.h $vr0, $vr0, 8
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <16 x i8>, ptr %ptr
  %B = sext <16 x i8> %A to <16 x i16>
  store <16 x i16> %B, ptr %dst
  ret void
}

define void @load_sext_16i8_to_16i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_16i8_to_16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr2, $vr1, $vr1
; CHECK-NEXT:    vslli.w $vr2, $vr2, 24
; CHECK-NEXT:    vsrai.w $vr2, $vr2, 24
; CHECK-NEXT:    vilvh.h $vr1, $vr1, $vr1
; CHECK-NEXT:    vslli.w $vr1, $vr1, 24
; CHECK-NEXT:    vsrai.w $vr1, $vr1, 24
; CHECK-NEXT:    vilvh.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr3, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr3, $vr3, 24
; CHECK-NEXT:    vsrai.w $vr3, $vr3, 24
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 24
; CHECK-NEXT:    vsrai.w $vr0, $vr0, 24
; CHECK-NEXT:    vst $vr0, $a1, 48
; CHECK-NEXT:    vst $vr3, $a1, 32
; CHECK-NEXT:    vst $vr1, $a1, 16
; CHECK-NEXT:    vst $vr2, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <16 x i8>, ptr %ptr
  %B = sext <16 x i8> %A to <16 x i32>
  store <16 x i32> %B, ptr %dst
  ret void
}

define void @load_sext_16i8_to_16i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_16i8_to_16i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr2, $vr1, $vr1
; CHECK-NEXT:    vilvl.w $vr3, $vr2, $vr2
; CHECK-NEXT:    vslli.d $vr3, $vr3, 56
; CHECK-NEXT:    vsrai.d $vr3, $vr3, 56
; CHECK-NEXT:    vilvh.w $vr2, $vr2, $vr2
; CHECK-NEXT:    vslli.d $vr2, $vr2, 56
; CHECK-NEXT:    vsrai.d $vr2, $vr2, 56
; CHECK-NEXT:    vilvh.h $vr1, $vr1, $vr1
; CHECK-NEXT:    vilvl.w $vr4, $vr1, $vr1
; CHECK-NEXT:    vslli.d $vr4, $vr4, 56
; CHECK-NEXT:    vsrai.d $vr4, $vr4, 56
; CHECK-NEXT:    vilvh.w $vr1, $vr1, $vr1
; CHECK-NEXT:    vslli.d $vr1, $vr1, 56
; CHECK-NEXT:    vsrai.d $vr1, $vr1, 56
; CHECK-NEXT:    vilvh.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr5, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr6, $vr5, $vr5
; CHECK-NEXT:    vslli.d $vr6, $vr6, 56
; CHECK-NEXT:    vsrai.d $vr6, $vr6, 56
; CHECK-NEXT:    vilvh.w $vr5, $vr5, $vr5
; CHECK-NEXT:    vslli.d $vr5, $vr5, 56
; CHECK-NEXT:    vsrai.d $vr5, $vr5, 56
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr7, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr7, $vr7, 56
; CHECK-NEXT:    vsrai.d $vr7, $vr7, 56
; CHECK-NEXT:    vilvh.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 56
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 56
; CHECK-NEXT:    vst $vr0, $a1, 112
; CHECK-NEXT:    vst $vr7, $a1, 96
; CHECK-NEXT:    vst $vr5, $a1, 80
; CHECK-NEXT:    vst $vr6, $a1, 64
; CHECK-NEXT:    vst $vr1, $a1, 48
; CHECK-NEXT:    vst $vr4, $a1, 32
; CHECK-NEXT:    vst $vr2, $a1, 16
; CHECK-NEXT:    vst $vr3, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <16 x i8>, ptr %ptr
  %B = sext <16 x i8> %A to <16 x i64>
  store <16 x i64> %B, ptr %dst
  ret void
}

define void @load_sext_8i16_to_8i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_8i16_to_8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr1, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr1, $vr1, 16
; CHECK-NEXT:    vsrai.w $vr1, $vr1, 16
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 16
; CHECK-NEXT:    vsrai.w $vr0, $vr0, 16
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <8 x i16>, ptr %ptr
  %B = sext <8 x i16> %A to <8 x i32>
  store <8 x i32> %B, ptr %dst
  ret void
}

define void @load_sext_8i16_to_8i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_8i16_to_8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr2, $vr1, $vr1
; CHECK-NEXT:    vslli.d $vr2, $vr2, 48
; CHECK-NEXT:    vsrai.d $vr2, $vr2, 48
; CHECK-NEXT:    vilvh.w $vr1, $vr1, $vr1
; CHECK-NEXT:    vslli.d $vr1, $vr1, 48
; CHECK-NEXT:    vsrai.d $vr1, $vr1, 48
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr3, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr3, $vr3, 48
; CHECK-NEXT:    vsrai.d $vr3, $vr3, 48
; CHECK-NEXT:    vilvh.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 48
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 48
; CHECK-NEXT:    vst $vr0, $a1, 48
; CHECK-NEXT:    vst $vr3, $a1, 32
; CHECK-NEXT:    vst $vr1, $a1, 16
; CHECK-NEXT:    vst $vr2, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <8 x i16>, ptr %ptr
  %B = sext <8 x i16> %A to <8 x i64>
  store <8 x i64> %B, ptr %dst
  ret void
}

define void @load_sext_4i32_to_4i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_sext_4i32_to_4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vshuf4i.w $vr1, $vr0, 16
; CHECK-NEXT:    vslli.d $vr1, $vr1, 32
; CHECK-NEXT:    vsrai.d $vr1, $vr1, 32
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 50
; CHECK-NEXT:    vslli.d $vr0, $vr0, 32
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 32
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <4 x i32>, ptr %ptr
  %B = sext <4 x i32> %A to <4 x i64>
  store <4 x i64> %B, ptr %dst
  ret void
}
